@Echo Off

Rem   ͻ
Rem    NOTO BENE: My home directory for InterMail is C:\IM (NOT the default 
Rem    upon installation!). If yours is different, you'll need to make the  
Rem    appropriate path changes in this batch file.                         
Rem   ͼ

Set IM=C:\IM

:START
         C:
         Cd \Im

Rem   ͻ
Rem           I load X00 as a SYS file, if you don't, load it here.        
Rem   ͼ

         Rem X00 e 1 B,0,38400

Rem   ͻ
Rem    First, we check to see if any DIFF files have arrived. If so, copy  
Rem    them to the WildCat! home directory (where they must reside for     
Rem    WildMail.) Be sure to configure InterMail to look for the NodeLists 
Rem    there also, so you don't end up with two copies.                    
Rem   ͼ

         If Not Exist C:\Im\Files\Nodediff.* Goto COPYENETDIFF
         Copy C:\Im\Files\Nodediff.* C:\Wc30

:COPYENETDIFF
         If Not Exist C:\Im\Files\Enetdiff.* Goto COPYOURDIFF
         Copy C:\Im\Files\Enetdiff.* C:\Wc30

:COPYOURDIFF
         If Not Exist C:\Im\Files\Ourdiff.* Goto DONECOPY
         Copy C:\Im\Files\Ourdiff.* C:\Wc30

:DONECOPY

Rem   ͻ
Rem    Check to see if any *.TIC files have arrived. If so, goto TICKIT to 
Rem    toss them.                                                          
Rem   ͼ

         If Exist C:\Im\Files\*.Tic Goto TICKIT
         If Not Exist C:\Wc30\Nodediff.* Goto NEXT
         If Not Exist C:\Wc30\Enetdiff.* Goto NEXT
         If Not Exist C:\Wc30\Ourdiff.* Goto NEXT

Rem   ͻ
Rem    Once all of the DIFF's have arrived, go to NLIST and process them.  
Rem    Above, we check to make sure all of the DIFF's have arrived before  
Rem    compiling them. This way, we only do one nodelist compilation each  
Rem    week.                                                               
Rem   ͼ

         Goto NLIST

:NEXT
         Im /Nounpack

Rem   ͻ
Rem           The errorlevel that IM exits with is picked up below.        
Rem   ͼ

 If ErrorLevel 200 Goto LOAD_BBS                 Human caller exit from InterMail.
 If ErrorLevel 150 Goto TOSS                     Exit from InterMail when files received with ErrorLevel 150.
 If ErrorLevel 145 Goto WEEKLY                   Event - Once a week.
 If ErrorLevel 140 Goto 6OCLOCK                  Event - 6 PM
 If ErrorLevel 130 Goto NOON                     Event - Noon
 If ErrorLevel 120 Goto MAINT                    Event - Nightly maintenance.
 If ErrorLevel 110 Goto MIDNIGHT                 Event - Midnight updates.
 If ErrorLevel 105 Goto SCAN                    [F10] Ŀ
 If ErrorLevel 100 Goto QMODEM                   [F9]  
 If ErrorLevel  90 Goto ACTVIEW                  [F7]    Some of the F-Keys
 If ErrorLevel  85 Goto OLX                      [F6]    I have set up in
 If ErrorLevel  80 Goto TOMCAT                   [F5]    InterMail. Should be
 If ErrorLevel  75 Goto WCREPAIR                 [F4]    self-explanitory.
 If ErrorLevel  70 Goto MAKEWILD                 [F3]  
 If ErrorLevel  65 Goto WCPRO                    [F2]  
 If ErrorLevel  60 Goto LOCAL_LOGON              [F1] 
 If ErrorLevel  10 goto DONE                     User exit.
 If ErrorLevel   8 Exit                          InterMail already loaded.
 If ErrorLevel   6 goto FOSSILERR                Ŀ
 If ErrorLevel   5 goto MODEMERR                  
 If ErrorLevel   4 goto MODEMDEAD                    Various Errors.
 If ErrorLevel   3 goto NOSPACE                   
 If ErrorLevel   1 goto FATAL                    


:LOAD_BBS                                                    [Errorlevel 200]
         Dobbs.Bat

:TOSS                                                        [Errorlevel 150]

Rem   ͻ
Rem       This is where WildMail unpacks and tosses new messages TO you.   
Rem   ͼ

         Oh! 1
         Cd \WildMail
         WM Toss
         Wmlog Wm.Log 100 Nobackup
         Copy Wmlog.Bbs \Wc30\Disp\Tomcat.Bbs
Rem   ͻ
Rem     After tossing the packets, run AREAFIX and RAID to check your Net  
Rem     Mail for any update requests.                                      
Rem   ͼ
         Areafix EC
         If Exist Fast.Bat Call Fast.Bat
         Cd \Im\Files\Tick
         Raid -R
         Goto START

:WEEKLY                                                      [Errorlevel 145]
         Call Weekly.Bat
         Goto START

:6OCLOCK                                                     [Errorlevel 140]
         Copy \Wc30\Disp\Good-E.* \Wc30\Disp\Goodbye.*
         Goto SCAN

:NOON                                                        [Errorlevel 130]
         Copy \Wc30\Disp\Good-A.* \Wc30\Disp\Goodbye.*
         Goto SCAN

:MAINT                                                       [Errorlevel 120]
         Call Maint.Bat
         Goto SCAN

:MIDNIGHT                                                    [Errorlevel 110]
         Call Midnite.Bat

:SCAN                                                        [Errorlevel 105]

Rem   ͻ
Rem     This is where WildMail scans and packs outgoing messages FROM you. 
Rem     Note: I go here from several daily events. You might want to scan  
Rem     after every call. If so, move this to EXEBBS.BAT                   
Rem   ͼ

         Oh! 1
         Cd \Wc30
         Cd \WildMail
         WM Scan
         Wmlog Wm.Log 100 Nobackup
         Copy Wmlog.Bbs \Wc30\Disp\Tomcat.Bbs
         Goto START

:QMODEM                                                      [Errorlevel 100]
         Call Qm.Bat
         Goto START

:ACTVIEW                                                      [Errorlevel 90]
         Cd \Wc30
         Actview 43 Nolocal Nomouse
         Goto START

:OLX                                                          [Errorlevel 85]
         Cd \Qm\Olx
         Olx
         Goto START

:TOMCAT                                                       [Errorlevel 80]
         Cd \Wc30
         Tomcat Rich Waugh
         Goto START

:WCREPAIR                                                     [Errorlevel 75]
         Cd \Wc30
         Wcrepair
         Goto START

:MAKEWILD                                                     [Errorlevel 70]
         Cd \Wc30
         Makewild
         Goto START

:WCPRO                                                        [Errorlevel 65]
         Cd \Wc30
         Wcpro
         Goto START

:LOCAL_LOGON                                                  [Errorlevel 60]
         Cd \Wc30
         WildCat /B LOCAL
         Goto START

:TICKIT
Rem   ͻ
Rem     As you can see, prior to actually tossing the files, I do some     
Rem     manipulation to them, i.e. converting ARJ & LZH files to ZIP and   
Rem     adding my own file header. If you change the extention of the      
Rem     file, be sure you change the file name in the TIC also or it won't 
Rem     toss. I do this in the batch file with SNR (Search & Replace).     
Rem   ͼ
         Cd \Im\Files
         Copy *.Tic \Temp
         Snr -#4 -s "ARJ=ZIP" -#4 -s"LZH=ZIP" *.Tic
         Txt2zip *.Zip D:\Util\Logo.Cmt
         Zipds *.Zip
         Cd \Wc30
         TranScan C:\Im\Files\*.Arj -TY -A730 -ZD:\Util\Logo.Cmt -CZip -L\Wc30\Activity.001
         TranScan C:\Im\Files\*.Lzh -TY -A730 -ZD:\Util\Logo.Cmt -CZip -L\Wc30\Activity.001
         Cd \Im\Files\Tick
Rem   ͻ
Rem     Prior to running TICK (which will delete the TIC's) I run RAID to  
Rem     generate the New File Arrival announcements.                       
Rem   ͼ
         Raid Announce
         Tick >> Tick.Log
Rem   ͻ
Rem     After TICK has tossed the files, WCFILE is called to update the    
Rem     WildCat! database in each of the areas the TIC'ed files were       
Rem     tossed to.                                                         
Rem   ͼ
         Cd \Wc30
                  If Not Exist D:\Wcfile\001\Files.Bbs Goto 013
                  Wcfile /D:D:\Wcfile\001\Files.Bbs /A:1 /P:1,12,15,75 /T /C
                  Del D:\Wcfile\001\Files.Bbs
         :013
                  If Not Exist D:\Wcfile\013\Files.Bbs Goto 014
                  Wcfile /D:D:\Wcfile\013\Files.Bbs /A:13 /P:1,12,15,75 /T /C
                  Del D:\Wcfile\013\Files.Bbs
         :014
                  If Not Exist D:\Wcfile\014\Files.Bbs Goto 041
                  Wcfile /D:D:\Wcfile\014\Files.Bbs /A:14 /P:1,12,15,75 /T /C
                  Del D:\Wcfile\014\Files.Bbs
         :041
                  If Not Exist D:\Wcfile\041\Files.Bbs Goto 042
                  Wcfile /D:D:\Wcfile\041\Files.Bbs /A:41 /P:1,12,15,75 /T /C
                  Del D:\Wcfile\041\Files.Bbs
         :042
                  If Not Exist D:\Wcfile\042\Files.Bbs Goto 043
                  Wcfile /D:D:\Wcfile\042\Files.Bbs /A:42 /P:1,12,15,75 /T /C
                  Del D:\Wcfile\042\Files.Bbs
         :043
                  If Not Exist D:\Wcfile\043\Files.Bbs Goto TICKDONE
                  Wcfile /D:D:\Wcfile\043\Files.Bbs /A:43 /P:1,12,15,75 /T /C
                  Del D:\Wcfile\043\Files.Bbs
         :TICKDONE
                  Del \Im\Files\*.Tic
                  Cd \Im\Files\Tick
                  Pkzip -m Ticks \Temp\*.Tic
                  If Exist C:\Im\Files\*.Pkt Goto TOSS
Goto START

:NLIST
         Echo ########### Processing NodeDiff File(s) #############
         Cd \Wc30

Rem   ͻ
Rem    First, we apply the DIFF's to the various NodeLists (with XlaxDiff) 
Rem   ͼ

         Xlaxdiff /C
         Xlaxdiff /E=Enetdiff.* /O=Enetlist.* /C
         Xlaxdiff /E=Ourdiff.* /O=Ourlist.* /C

Rem   ͻ
Rem                      Then we compile the NodeLists.                    
Rem   ͼ

         \Im\Imnc /C

Rem   ͻ
Rem      Delete the DIFF's (IMPORTANT!), after tossing them to the file    
Rem      areas with TICK. Remember, we check for their existance in the    
Rem      beginning of this batch file.                                     
Rem   ͼ

         Del \Wc30\????Diff.*
         Del \Wc30\Ourdiff.*

Rem   ͻ
Rem      This is where you run WildNode.  
Rem   ͼ

         Cd \Wc30
         WildNode
         Echo ############### NODELIST COMPILED ############### >> C:\Wc30\Activity.001
         Goto TICKIT

:FOSSILERR
         Echo.
         Echo X00 not installed!
         Echo.
         Goto DONE

:MODEMERR
         Echo.
         Echo The modem does not respond correctly!
         Echo.
         Rem *  One solution, if this happens occasionally, may be to let the
         Rem *  batch file reboot the computer by removing the REM in front of
         Rem *  XU BOOT below. Note that Autoexec.Bat must call Imrun.Bat for
         Rem *  this to work.
         Rem XU BOOT
         Goto DONE

:MODEMDEAD
         Echo.
         Echo The modem seems completely dead!
         Echo.
         Goto DONE

:NOSPACE
         Echo.
         Echo Out of diskspace
         Echo.
         Goto DONE

:FATAL
         Echo.
         Echo FATAL error reported by InterMail!
         Echo.

:DONE                                (Exitpoint from the batch file)
         Rem *  Un-install the X00 SIO driver
         C:
         Cd \Im
         Rem X00

