Unit dspin;
{
                DSpin - Door version of Spinning Curser Input
                             - Sep 05 / 1997
                This Unit has my new Funky Input routine.
                Also has the dynlb stuff from Enigma
}

interface

function ReadKeySpin(wait : Byte) : Char;
{$IFDEF LINUX}
function readnospinkey : Char;
{$ENDIF}
function ReadStringSpin(Len, X, Y, Attr1, Attr2: Byte; Limiter: Char): String;
function DPipeStrLen(S: String): Byte;
function Tdnylb(quest, ys, ns: string): boolean;
function Tdynlb(quest, ys, ns: string): boolean;

implementation
Uses
{$IFDEF OS2}
  os2base,
  VpSysLow,
  door2,
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  VpSysLow,
  door2,
{$ENDIF}
{$IFDEF LINUX}
  LocalD,
  Enigma,
{$ENDIF}
{$IFDEF MSDOS}
  Door,
{$ENDIF}
  Crt;

Const
  SpinChar : Array [1..4] of Char = ('','/','','\');

Function ReadKeySpin(Wait : Byte) : Char;
Var
  X,Y  : Byte;
  Num  : Byte;
  Ch   : Char;
begin
  Num := 1;                               (* initialize SpinChars  *)
  X   := WhereX;                          (* Where am I ??         *)
  Y   := WhereY;
  Repeat
    DGotoXY(X, Y);                   (* Go back               *)
    DPipe(SpinChar[Num]);           (* Spin the Cursor       *)
    Delay(Wait);                    (* Wait, it's to fast!   *)
    DGotoXY(X, Y);                   (* Go back               *)
{    DWrite(#8); }
    Inc(Num);                       (* Next SpinChar, please *)
    if Num = 5 then Num := 1;       (* I have only 5 Chars   *)
  {$IFDEF LINUX}
  Until Keypressed;
  {$ELSE}
  Until DKeypressed;
  {$ENDIF}
  DReadC(Ch);
  ReadKeySpin := Ch;                    (* give a result         *)
end;

{$IFDEF Linux}
function readnospinkey : Char;
Var
  Ch   : Char;
begin
  Repeat
      SysCtrlSleep(1);
  Until Keypressed;
  DReadC(CH);
  ReadNoSpinKey:= Ch;                    { give a result         }
end;
{$ENDIF}

function ReadStringSpin(Len, X, Y, Attr1, Attr2: Byte; Limiter: Char): String;
var
  i: integer;
 ch: char;
  s: string;
begin
  DGotoXY(x,y);
  fg(Attr2);
  for i:=1 to len do DPipe(Limiter);
  for i:=1 to len do DPipe(#8);
  fg(Attr1);
  x:=wherex;
  y:=wherey;
  s:='';
  repeat
    ch:=ReadKeySpin(40);
    if (ch<>#8) and (ch<>^M) and (ch<>#9) and (length(s)<Len) then
      begin
        if ch in [#1..#7,#10..#12,#14..#31,#127..#255] then ch:=#0 else
        begin
          s:=s+ch;
          DPipe(ch);
        end;
      end;
    if (ch=chr(8)) and (length(s)>0) then
      begin
        delete(s,length(s),1);
        DPipe(chr(8));
        fg(Attr2);
        DPipe(Limiter);
        fg(Attr1);
        DPipe(#8);
      end;
  until (ch=^M) or (ch=#9);
  readstringspin:=s;
end;

function DPipeStrLen(S: String): Byte;
Var
  C: Byte;
  B: Integer;
Begin
  C:=Length(S);
  For B:=1 to Length(S) Do
    If S[B]='|' Then Dec(C, 3);
  DPipeStrLen:=C;
End;

function Tdynlb(quest, ys, ns: string): boolean;
var
  ch    : char;
  yn    : char;
  ysl   : integer;

procedure yes(b: boolean);
var
  i: integer;
begin
  for i:=1 to ysl do
    DPipe(#8);
  if b=true then
    DPipe(ys)
  else DPipe(ns);
end;

begin
  yn := 'Y';
  Ysl:=DPipeStrLen(Ys);
  DPipe('|09' + quest + ' ' + ys);
  tdynlb:=true;
  repeat
    DReadC(Ch);
    Ch := Upcase(Ch);
    if ch = #32 then begin
      if yn = 'Y' then yn := 'N'
      else yn := 'Y'
    end else
    if ch in ['Y','D','4',#75] then yn := 'Y'
    else if ch in ['N','C','6',#77] then yn := 'N';
    case yn of
    'Y': begin
        yes(true);
        tdynlb:=true;
      end;
    'N': begin
        yes(false);
        tdynlb:=false;
      end;
    end;
  until ch = #13;
  DCrlf;
end;

function Tdnylb(quest, ys, ns: string): boolean;
var
  ch: char;
  yn: char;
  nsl: integer;

procedure yes(b: boolean);
var
  i: integer;
begin
  for i:=1 to nsl do
    DPipe(#8);
  if b=true then
    DPipe(ys)
  else DPipe(ns);
end;

begin
  yn := 'N';
  Nsl:=DPipeStrLen(Ns);
  DPipe('|09' + quest + ' ' + Ns);
  tdnylb:=false;
  repeat
    DReadC(Ch);
    ch := upcase(ch);
    if ch = #32 then begin
      if yn = 'Y' then yn := 'N'
      else yn := 'Y'
    end
    else if ch in ['Y','D','4',#75] then yn:='Y'
    else if ch in ['N','C','6',#77] then yn:='N';
    case yn of
    'Y': begin
        yes(true);
        tdnylb:=true;
     end;
    'N': begin
        yes(false);
        tdnylb:=false;
      end;
    end;
  until ch = #13;
  DCrlf;
end;

begin
end.
