Program CGIWhoCalled;
{
                Last 10 callers for Gamesrv - CGI version
        Written by: Shawn Highfield - Version 0.04 - December 15 2010
}
uses
  Pipes,
  dos;

var
  TieVersion: String;
  TheDataFile: String;
  MainURL: String;
  Colours: String;
  CountedLines: Integer;
  L,
  BackLine: Integer;

// ---Function's for most CGI's-------
function strupcase(s: string): string;           {Convert String to upcase}
var
  i: integer;
begin
  for i:=1 to length(s) do s[i]:=upcase(s[i]);
  strupcase:=s;
end;

function scmp(s, s1: string): boolean;
begin
  if strupcase(s)=strupcase(s1) then
    scmp:=true else scmp:=false;
end;

function token(c: char; var s: string): string;  {Looking for a character}
var tmp: string;
begin
  if (pos(c, s)<>0) then
    begin
      tmp:=copy(s, 1, pos(c, s)-1);
      delete(s, 1, pos(c, s));
    end else
    begin
      tmp:=copy(s, 1, length(s));
      delete(s, 1, length(s));
    end;
  token:=tmp;
end;

function exedir: string;                         {Get the Main directory}
var
  s: string;
begin
  s:=paramstr(0);
  while s[length(s)]<>'\' do dec(s[0]);
  exedir:=s;
end;

function convert(s: string): string;             {Convert to pascal strings}
var
  s1: string;
  i: integer;
  j, k: longint;
begin
  for i:=1 to length(s) do if s[i]='+' then s[i]:=' ';
  repeat
    i:=pos('%', s);
    if i>0 then
      begin
        s1:=copy(s, i+1, 2);
        delete(s, i, 3);
        s1:='$'+s1;
        val(s1, j, k);
        if k=0 then
          begin
            s1:=char(j);
            insert(s1, s, i);
          end;
      end;
  until pos('%', s)=0;
  convert:=s;
end;

function itos(n: longint): string;               {Integer to String}
var s: string;
begin
  str(n, S);
  ItoS:=S;
end;

function stoi(s: string): longint;               {String to Integer}
var i, j: longint;
begin
  val(s, i, j);
  stoi:=i;
end;

function delfile(s: string): boolean;
var f: file;
begin
  assign(f, s);
  {$I-}erase(f);{$I+}
  if ioresult<>0 then delfile:=false else delfile:=true;
end;
// ------------------------------------

Procedure NotFound;            {This is shown in case of a file error}
begin
  WriteLn('<HTML>');
  WriteLn('<TITLE>Last 10 Callers</TITLE>');
  WriteLn('<BR>');
  WriteLn('<FONT COLOR="Blue"><FONT SIZE=+4>The last 10 callers list is blank.</FONT></FONT><BR>');
  WriteLn('<FONT COLOR="White">');
  WriteLn('<BR>');
  WriteLn('<A HREF="' + mainurl + '"Back to original page</A> <BR>');
  WriteLN('<BR>');
  WriteLn('<Font Color="Cyan">' + TieVersion);
  Write('<FONT COLOR="Yellow">Written by: Shawn ''<A HREF="');
  WriteLn('mailto://shighfield@gmail.com">Tiny</A>'' Highfield<BR>');
  WriteLn('<A HREF="http://www.tinysbbs.com">Tiny''s BBS</A>');
  WriteLn('</HTML>');
end;

Procedure CountTheLines;
var
  x: word;
  i: Integer;
  s: String;
  f: Text;
begin
  i:=0;
  Assign(F, ThedataFile);
{$I-}
  REset(F);
  x := ioresult;
{$I+}
  While not EOF(F) do
  begin
    ReadLn(F, S);
    ReadLn(F, S);
    ReadLn(F, S);
    ReadLn(F, s);
    Inc(I);
  end;
  Close(F);
  CountedLines := i;
end;

Procedure ReadIt;
var
    i: Integer;
    s: String;
    F: Text;
  Txt: array[1..100] of string[50];
begin
  CountTheLines;
//Setup the screen
  WriteLn('<BR><CENTER>');
  WriteLn('<IMG SRC="' + mainurl + '/whocalled_hdr.png">');
  WriteLn('<BR>');
//Table
  WriteLn('<table style="text-align: left; width: 55%;" border="1" cellpadding="2" cellspacing="2">');
  WriteLn('<tbody>');
  WriteLn('<tr>');
  WriteLn('<td style="vertical-align: top; width: 45%">');
  Pipe('|07Username');
  WriteLn('</TD>');
  WriteLn('<td style="vertical-align: top; width: 22%">');
  Pipe('|07IP');
  WriteLn('</TD>');
  WriteLn('<td style="vertical-align: top; width: 10%">');
  Pipe('|07Date');
  WriteLn('</TD>');
  WriteLn('<td style="vertical-align: top; width: 10%">');
  Pipe('|07Time');
  WriteLn('</TD>');
  i := 1;
  backline := CountedLines;
  l := backline;
  Assign(F, TheDataFile);
  Reset(F);
  While i <= (backline * 4) do
  begin
    ReadLn(F, s);
    Txt[i] := s;
    Inc(i);
  end;
  if L > 10 then L := 10;
  For backline := L downto 1 do
  begin
    WriteLn('<tr>');
    WriteLn('<td style="vertical-align: top;">');
    Pipe('|10' + Txt[i-4]);
    WriteLn('</TD>');
    WriteLn('<td style="vertical-align: top;">');
    Pipe('|11' + Txt[i-3]);
    WriteLn('</TD>');
    WriteLn('<td style="vertical-align: top;">');
    Pipe('|13' + Txt[i-2]);
    WriteLn('</TD>');
    WriteLn('<td style="vertical-align: top;">');
    Pipe('|14' + Txt[i-1]);
    WriteLn('</TD></TR>');
    Dec(i,4);
  end;
  Close(F);
  WriteLn('</TABLE>');
end;

Procedure ReadTheConfig;
var
  f: Text;
begin
  Assign(F, exedir + 'whocallcgi.cfg');
  {$I-}Reset(f);{$I+}
  if ioresult<>0 then                           {File not found!}
  begin
    NotFOund;
    Halt;
  end;
  ReadLn(F, TheDataFile);                       {Get the datafile name}
  ReadLn(F, mainurl);                           {The URL to return to in case of error etc.}
  ReadLn(F, colours);                           {Colour settings}
  Close(F);
end;

BEGIN
  TieVersion:='Last 10 Callers/CGI - Version 0.04';
  ReadTheConfig;
  writeln('Content-type: text/html');
  writeln;
  WriteLn('<HTML>');
  WriteLn('<HEAD>');
  WriteLn('<TITLE>Last 10 Callers</TITLE>');
  WriteLn('</HEAD>');
  WriteLn(colours);
  WriteLn('<BR>');
  ReadIt;
// Footer display
  WriteLn('<BR>');
  WriteLn('<Font Color="Cyan">' + TieVersion);
  Write('<FONT COLOR="Yellow">Written by: Shawn ''<A HREF="');
  WriteLn('mailto://shighfield@gmail.com">Tiny</A>'' Highfield<BR>');
  WriteLn('<A HREF="http://www.tinysbbs.com">Tiny''s BBS</A>');
  WriteLn('</CENTER></BODY> </HTML>');
END.
