Unit CgiStf;
{
  This unit is for my CGI programs.  Has the commands from strstf and
  my pipe etc.
        Oct 28 1997
}
interface

type
  Ulong = Longint;

function exedir: string;
function stoi(s: string): longint;
function strupcase(s: string): string;
function scmp(s, s1: string): boolean;
function token(c: char; var s: string): string;
procedure crlf;
function convertascii(s: string): string;
Function delfile(s: String): Boolean;
Function Exist(s: String): Boolean;
Function LoCase(UpStr: String): String;
function itos(n: integer): string;
function LeadingZero(w : Word) : String;
function copyfile(source, dest: string): byte;

implementation

function exedir: string;
var
  s: string;
begin
  s:=paramstr(0);
  {$IFDEF LINUX}
  while s[length(s)]<>'/' do dec(s[0]);
  {$ELSE}
  while s[length(s)]<>'\' do dec(s[0]);
  {$ENDIF}
  exedir:=s;
end;

function stoi(s: string): longint;
var
  {$IFDEF MSDOS}
  i: Integer;
  j: Integer;
  {$ENDIF}
  {$IFDEF LINUX}
  i: Integer;
  j: Integer;
  {$ENDIF}
  {$IFDEF WIN32}
  i: longint;
  j: longint;
  {$ENDIF}
  {$IFDEF OS2}
  i: longint;
  j: Longint;
  {$ENDIF}
begin
  val(s, i, j);
  stoi:=i;
end;

function strupcase(s: string): string;
var
  i: integer;
begin
  for i:=1 to length(s) do s[i]:=upcase(s[i]);
  strupcase:=s;
end;

function scmp(s, s1: string): boolean;
begin
  if strupcase(s)=strupcase(s1) then
    scmp:=true else scmp:=false;
end;

function token(c: char; var s: string): string;
var tmp: string;
begin
  if (pos(c, s)<>0) then
    begin
      tmp:=copy(s, 1, pos(c, s)-1);
      delete(s, 1, pos(c, s));
    end else
    begin
      tmp:=copy(s, 1, length(s));
      delete(s, 1, length(s));
    end;
  token:=tmp;
end;

Procedure CrLf;
Begin
  WriteLn('<BR>');
end;

function convertascii(s: string): string;
var
  s1: string;
  i: integer;
  {$IFDEF MSDOS}
  j, k: Integer;
  {$ENDIF}
  {$IFDEF LINUX}
  j,k: Integer;
  {$ENDIF}
  {$IFDEF WIN32}
  j, k: LongInt;
  {$ENDIF}
  {$IFDEF OS2}
  j,k: Longint;
  {$ENDIF}
begin
  for i:=1 to length(s) do if s[i]='+' then s[i]:=' ';
  repeat
    i:=pos('%', s);
    if i>0 then
      begin
        s1:=copy(s, i+1, 2);
        delete(s, i, 3);
        s1:='$'+s1;
        val(s1, j, k);
        if k=0 then
          begin
            s1:=char(j);
            insert(s1, s, i);
          end;
      end;
  until pos('%', s)=0;
  convertascii:=s;
end;

Function delfile(s: String): Boolean;
var
  f: File;
begin
  Assign(F, s);
  {$I-}erase(f);{$I+}
  if ioresult<>0 then delfile:=False else delfile:=True;
end;

Function Exist(s: String): Boolean;
var
  f: File;
  Oldmode: BYte;
begin
  OldMode:=Filemode;
  Filemode:=0;
  Assign(F,S);
  {$I-}Reset(F);{$I+}
  Exist := ioresult<>0;
  Filemode:=Oldmode;
end;

Function LoCase(UpStr: String): String;
var
  B: Byte;
begin
  for B := 1 to Length(UpStr) do
    if UpStr[B] in [#65..#90] then UpStr[B] := Chr(Ord(UpStr[B]) + 32);
  LoCase := UpStr;
end;

function itos(n: integer): string;
var
  v: string;
begin
  str(n,v);
  itos:=v;
end;

function LeadingZero(w : Word) : String;
var
  s : String;
begin
  Str(w:0,s);
  if Length(s) = 1 then
    s := '0' + s;
  LeadingZero := s;
end;

function copyfile(source, dest: string): byte;
const bufsize = 64000;
var
  src, dst: file;
  buf: pchar;
  len, nwritten: longint;
begin
  getmem(buf, bufsize);
  assign(src, source);
  {$I-} reset(src, 1); {$I+}
  if ioresult<>0 then
    begin
      copyfile:=1;
      exit;
    end;
  assign(dst, dest);
  {$I-} rewrite(dst, 1); {$I+}
  if ioresult<>0 then
    begin
      copyfile:=2;
      exit;
    end;
  repeat
    blockread(src, buf^, bufsize, len);
    blockwrite(dst, buf^, len, nwritten);
  until (len = 0) or (len <> nwritten);
  close(src);
  close(dst);
  freemem(buf, bufsize);
  copyfile:=0;
end;

begin
end.
