unit Add;

INTERFACE

procedure TnyBorderDisp;
Procedure Header;
Procedure HitEnter;
function StrUpcase(s: String): String;
function FileExists(FileName: String): Boolean;
{$IFDEF DOS}
procedure Fdel(FileName: string; Var ErrCode: byte);
procedure Frename(SourceFile,TargetFile: string; Var ErrCode: byte);
{$ENDIF}

IMPLEMENTATION

uses
  Dos,
  Crt,
  Enigma;

procedure TnyBorderDisp;
begin
  PipeLn('                                                                               ');
  PipeLn('|12|16|04|12|04    |08                                                |04   |12|04|12');
  PipeLn('|20|16                                                                             |20');
  PipeLn('|04|16                                                                             ');
  PipeLn('                                                                             ');
  PipeLn('                                                                             ');
  PipeLn('                                                                               ');
  PipeLn('                                                                               ');
  PipeLn('                                                                               ');
  PipeLn('                                                                               ');
  PipeLn('                                                                               ');
  PipeLn('                                                                               ');
  PipeLn('                                                                               ');
  PipeLn('                                                                               ');
  PipeLn('                                                                               ');
  PipeLn('                                                                               ');
  PipeLn('                                                                               ');
  PipeLn('|08                                                                             ');
  PipeLn('                                                                             ');
  PipeLn('|04                                                                             ');
  PipeLn('                                                                             ');
  PipeLn('                                                                             ');
  PipeLn('|12|20|16                                                                             |20');
  PipeLn('|16|04|12|04    |08                                                |04   |12|04|12');
end;

Procedure Header;
begin
  GotoXY(2,1);
  Pipe('         |12     |13                  ');
  GotoXY(2,2);
  Pipe('           |12   |15 |13 |04    |13   |04      |12Word File');
  GotoXY(2,3);
  Pipe('           |12       |13  |04     |13    |04       |12Editor');
  GotoXY(2,4);
  Pipe('          |13Written By:|04                 |12S|04tewart |12H|04onsberger');
  GotoXY(2,5);
  Pipe('          |13Version:|12 1|15.|120                   |13Compiled |12Dec. 04|15, |121997');
end;

Procedure HitEnter;
var
  X, Y: Byte;
  ch: Char;
begin
  X := WhereX;
  Y := WhereY;
  repeat
    GotoXY(X,Y);
    Pipe('|15Press |04<|12ENTER|04> |15To Continue');
    Ch := ReadKey;
  until Ch = #13;
end;

function FileExists(FileName: String): Boolean;
{
   Boolean function that returns True if the file exists;otherwise,
   it returns False. Closes the file if it exists.
}
var
 F: file;
begin
 {$I-}
 Assign(F, FileName);
 FileMode := 0;  { Set file access to read only }
 Reset(F);
 Close(F);
 {$I+}
 FileExists := (IOResult = 0) and (FileName <> '');
 Filemode := 2;
end;

function StrUpcase(s: String): String;
{
  Converts a string to uppercase
}
var
  i: Integer;
begin
  for i:= 1 to Length(s) do S[i]:= Upcase(s[i]);
  StrUpcase := s;
end;

{$IFDEF DOS}
procedure Fdel(FileName: string; Var ErrCode: byte);
var
  reg: registers;
begin                                   { Fdel }
  FileName:=concat(FileName,#0);
  reg.ds:=Seg(FileName[1]); reg.dx:=Ofs(FileName[1]);
  reg.ah:=$41;
  MsDos(reg);
  ErrCode:=0;
  if (reg.flags AND FCarry)=1 then ErrCode:=reg.ax;
end;                                    { Fdel }

procedure Frename(SourceFile,TargetFile: string; Var ErrCode: byte);
var
  reg: registers;
begin                                   { Frename }
  SourceFile:=concat(SourceFile,#0);
  TargetFile:=concat(TargetFile,#0);
  reg.ds:=Seg(SourceFile[1]); reg.dx:=Ofs(SourceFile[1]);
  reg.es:=Seg(TargetFile[1]); reg.di:=Ofs(TargetFile[1]);
  reg.ah:=$56;
  MsDos(reg);
  ErrCode:=0;
  if (reg.flags AND FCarry)=1 then ErrCode:=reg.ax;
end;                                    { Frename }
{$ENDIF}

begin
end.
