Program Dateditor;
(*

External WORDS.DAT editor for T-Hang

Written By Stewart Honsberger

Started: Dec 03 1997

Last Updated: 1/22/98

TODO:
- Fix "delete word" in the List Words section

*)

Uses
  {$IFDEF OS2}
  Strstf,              { OS/2 File copy/Rename/Del routines, etc. }
  {$ENDIF}
  {$IFDEF WIN32}
  StrStf,
  {$ENDIF}
  Add,                 { Border, Header, File handling, Hit Enter }
  Enigma,              { Pipe routines, Misc.                     }
  crt;                 { ClrScr, Misc.                            }

type
  rec_type=Record      { These are the structs for the .DAT file  }
    word:string[15];
    hint:string[50];
End;

var
  Rec: rec_type;         { This is to access the DAT file entries }
  Wordfile: File of rec_type;  { DAT file itself                  }
  QUIT: Boolean;         { Should I quit?                         }
  STOP: Boolean;         { To stop the list words menu            }
  Num:Integer;           { Word Number                            }
  Y: Integer;            { Cursor Position                        }

procedure QuitMe;
begin
  Quit := TRUE;
  window(1,1,80,25);
  TextColor(7);
  ClrScr;
end;

procedure Startup;
begin
  if not fileexists('words.dat') then begin { If the wordfile doesn't exist }
    ClrScr;
    GotoXY(1,1);
    Pipe('|07 |12T|04he |12d|04ata |12f|04ile |15(|07WORDS.DAT|15) |09*|14MUST|09* |12e|04xists |12i|04n |12t|04he');
    Pipe(' |12c|04urrent |12d|04irectory|15!');
    Delay(1000);
    CrLf; CrLf;
    QUIT := TRUE;   { Yes we should quit }
    Exit;
  end;
  window(1,1,80,25);
  ClrScr;
  TnyBorderDisp;
end;

procedure Alter;
var
  i: Integer;               { Temp Int. }
  Ch: Char;                 { Temp Char }
  TWord: String;            { Temp Word }
  THint: String;            { Temp Hint }
begin
  window(3,4,78,22);
  ClrScr;
  GotoXY(3,6);
  Pipe('|12O|04ld |12W|04ord|07: ');
  Textcolor(09);
  Write(rec.word);
  GotoXY(3,8);
  Pipe('|12N|04ew |12W|04ord |15(|07<|14ENTER|07> |12t|04o |12l|04eave |12u|04nchanged|15)|07: ');
  GotoXY(3,9);
  Pipe('|07[');
  GotoXY(19,9);
  Pipe('|07]');
  TWord := Inpt(15, 4, 9, 15, 1, ch, '');
  if length(TWord) = 0 then TWord := rec.word;
  TWord := StrUpcase(TWord);
  GotoXY(3,11);
  Pipe('|12O|04ld |12H|04int|07: ');
  Textcolor(09);
  Pipe(rec.hint);
  GotoXY(3,13);
  Pipe('|12N|04ew |12H|04int |15(|07<|14ENTER|07> |12t|04o |12l|04eave |12u|04nchanged|15)|07: ');
  GotoXY(3,14);
  Pipe('|07[');
  GotoXY(54,14);
  Pipe('|07]');
  THint := Inpt(50, 4, 14, 15, 1, ch, '');
  if length(THint) = 0 then THint := rec.hint;
  GotoXY(3,16);
  Pipe('|12W|04ould |12y|04ou |12l|04ike |12t|04o |12s|04ave? |15(|04Y|07/|04n|15)');
  repeat
    Ch := Upcase(ReadKey);
  until Ch in ['Y','N',#13];
  case Ch of
  'Y',#13 : begin
    rec.word := TWord;
    rec.hint := THint;
    end;
  end;
  ClrScr;
  Exit;
end;

procedure EditNumber(Number: Longint);
var
  Code: Byte;              { Temp Byte    }
  Ch: Char;                { Temp char    }
begin
  window(3,4,78,22);
  ClrScr;
  Assign(Wordfile, 'WORDS.DAT');
  Reset(Wordfile);
  seek(Wordfile, Number);
  read(wordfile, rec);
  GotoXY(5,8);
  Pipe('|01Word: ');
  TextColor(15);
  ClrEol;
  WriteLn(rec.word);
  GotoXY(5,10);
  Pipe('|01Hint: ');
  TextColor(15);
  ClrEol;
  PipeLn(rec.hint);
  GotoXY(5,12);
  Pipe('|12Edit this word? |12(|04Y|12) |15Yes |12(|04n|12) |15No |12(|04d|12) |15Delete');
  repeat
    Ch := Upcase(ReadKey);
  until Ch in ['Y','N','D',#13];
  if Ch = 'N' then begin
    Close(Wordfile);
    Exit;
  end;
  case Ch of
  'Y',#13 : begin
      Alter;
      Seek(Wordfile, Number);
      Write(Wordfile, rec);
    end;
  'D' : begin
      if Filepos(Wordfile) < Filesize(Wordfile) then begin
        repeat
          Read(Wordfile, rec);
          Seek(Wordfile, Filepos(Wordfile) - 1);
          Write(Wordfile, rec);
        until Eof(Wordfile);
      end;
      Seek(Wordfile, Filesize(Wordfile) - 1);
      Truncate(Wordfile);
    end;
  end;
  Seek(Wordfile, Number);
  Write(Wordfile, rec);
end;

(*
procedure Edit;
var
  Ch: Char;                { Temp char    }
  TempPos: Integer;
begin
  window(3,4,78,22);
  ClrScr;
  Assign(Wordfile, 'WORDS.DAT');
  Reset(Wordfile);
  While not Eof(Wordfile) do begin
    read(Wordfile, Rec);
    GotoXY(5,8);
    Pipe('|01Word: ');
    TextColor(15);
    ClrEol;
    WriteLn(rec.word);
    GotoXY(5,10);
    Pipe('|01Hint: ');
    TextColor(15);
    ClrEol;
    PipeLn(rec.hint);
    GotoXY(5,12);
    Pipe('|12Edit this word? |12(|04d|12) |15Delete |12(|04q|12) |15Quit |12(|04y|12) |15Yes |12(|04N|12) |15No|07/|15Next ' +
    '|12(|04P|12) |15Previous');
    repeat
      Ch := Upcase(ReadKey);
    until Ch in ['Y','N','P','Q','D',#13];
    case Ch of
    'Y' : Alter;
    'P' : begin
        If filepos(Wordfile) > 1 then Seek(Wordfile, Filepos(Wordfile) - 2)
        else Seek(Wordfile, Filepos(Wordfile) - 1);
      end;
    'D' : begin
        TempPos := Filepos(Wordfile);
        repeat
          Read(Wordfile, rec);
          Seek(Wordfile, Filepos(Wordfile) - 1);
          Write(Wordfile, rec);
        until Eof(Wordfile);
        Seek(Wordfile, Filesize(Wordfile) - 1);
        Truncate(Wordfile);
        Seek(Wordfile, TempPos - 1);
      end;
    'Q' : begin
        Close(Wordfile);
        Exit;
      end;
    end;
  end;
  Close(Wordfile);
end;
*)

procedure AddWord;
var
  Ch: Char;               { Temp Char }
  THint,                  { Temp Hint }
  TWord: String;          { Temp Word }
  i: Integer;             { Temp Int  }
begin
  window(3,4,78,22);
  ClrScr;
  GotoXY(3,3);
  Pipe('|12E|04nter |12t|04he |12w|04ord |15(|07Max |1115 |07Character|15): ');
  GotoXY(3,4);
  Pipe('|07[');
  GotoXY(19,4);
  Pipe('|07]');
  TWord := Inpt(15, 4, 4, 15, 1, ch, '');
  for i := 1 to Length(TWord) do
    TWord[i] := Upcase(TWord[i]);
  if Length(TWord) <= 2 then begin
    close(Wordfile);
    Exit;
  end;
  rec.word := TWord;
  GotoXY(3,6);
  Pipe('|12E|04nter |12t|04he |12h|04int |15(|07Max |1150 |07Characters|15): ');
  GotoXY(3,7);
  Pipe('|07[');
  GotoXY(54,7);
  Pipe('|07]');
  THint := Inpt(50, 4, 7, 15, 1, ch, '');
  if Length(THint) <= 5 then begin
    close(Wordfile);
    Exit;
  end;
  rec.hint := THint;
  GotoXY(3,9);
  Pipe('|12Y|04ou |12e|04ntered|07: |15');
  Pipe(rec.word);
  Pipe('|12. ');
  GotoXY(3,10);
  Pipe('|12W|04ith |12a h|04int |12o|04f|07: |15');
  Pipe(rec.hint);
  GotoXY(3,12);
  Pipe('|12W|04ould |12y|04ou |12l|04ike |12t|04o |12s|04ave? |15(|04Y|07/|04n|15)');
  repeat
    Ch := Upcase(ReadKey);
  until Ch in ['Y','N',#13];
  case Ch of
  'Y',#13 : begin
      assign(Wordfile,'words.dat');
      Reset(Wordfile);
      Seek(Wordfile, FileSize(Wordfile));
      Write(Wordfile, Rec);
    end;
  end;
  close(Wordfile);
  Exit;
end;

procedure Listmenu;
var
  i: Integer;                    { Temp Integer    }
  Ch: Char;
  N: String;
begin
  GotoXY(10,19);
  Pipe('|12(|04Y|07/|04ENTER|12) |07More |12(|04ESC|12) |07Quit |12(|04P|12) |07Previous |12(|04E|12) ');
  Pipe('|07Edit|15/|07Delete');
  repeat
    Ch := Upcase(ReadKey);
  until Ch in ['Y','P','E',#27,#13];
  case Ch of
    'E' : begin
      GotoXY(1,19);
      ClrEol;
      GotoXY(23,19);
      Pipe('|12E|04nter |12T|04he |12W|04ord |12N|04umber|07: ');
      N := Inpt(4, 46, 19, 1, 15, ch, '.');
      if (Length(N) > 0) AND (StoI(N) < Filesize(Wordfile)) then
          EditNumber(StoI(N));
      Num := Num - 15;
      Reset(Wordfile);
      Seek(Wordfile, Num);
      Y := 3;
      ClrScr;
      GotoXY(2,1);
      PipeLn('|14#    Word:            Hint:');
      GotoXY(1,2);
      Pipe('|12-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
      GotoXY(1,18);
      PipeLn('|12-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
      STOP := TRUE;
      Exit;
    end;
    'Y' : begin
      Stop := TRUE;
      Y := 3;
      Exit;
    end;
    #13 : begin
      Stop := TRUE;
      Y := 3;
      Exit;
    end;
    #27 : begin
      Stop := TRUE;
      Quit := TRUE;
      Exit;
    end;
    'P' : begin
      if Filepos(Wordfile) <> 15 then begin
        Num := Num - 30;
        Seek(Wordfile, Num);
        Y := 3;
        Stop := TRUE;
        Exit;
      end else begin
        Seek(Wordfile, FilePos(Wordfile) - 15);
        Num := Num - 15;
        Y := 3;
        Stop := TRUE;
        Exit;
      end;
    end;
  end;
end;

procedure List;
var
  i: Integer;                    { Temp Integer    }
  Ch: Char;
  N: String;
begin
  window(3,4,78,22);
  ClrScr;
  STOP := FALSE;
  Num := 0;
  Assign(Wordfile, 'words.dat');
  Reset(Wordfile);
  Y := 3;
  GotoXY(2,1);
  PipeLn('|14#    Word:            Hint:');
  GotoXY(1,2);
  Pipe('|12-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
  GotoXY(1,18);
  PipeLn('|12-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
  While not Eof(Wordfile) do begin
    Read(Wordfile, Rec);
    GotoXY(2,Y);
    ClrEol;
    TextColor(15);
    Write(Num);
    TextColor(09);
    GotoXY(7,Y);
    Write(rec.word);
    GotoXY(24,Y);
    TextColor(15);
    Pipe(rec.hint);
    Inc(Num);
    Inc(Y);
    if Y > 17 then begin
      While not stop do Listmenu;
      if QUIT then begin
        QUIT := FALSE;
        Exit;
      end;
    end;
    STOP := FALSE;
  end;
  For i := y to 17 do begin
    GotoXY(1,i);
    ClrEol;
  end;
  While not Stop do Listmenu;
  Close(Wordfile);
end;

procedure Menu;
var
  Ch: Char;
begin
  window(3,4,78,22);
  ClrScr;
  Header;
  GotoXY(27,9);
  PipeLn('|15( |12L |15) |07List|15/|07Edit Words');
(*  GotoXY(25,11);
  PipeLn('|15( |12E |15) |07Edit/Delete Words'); *)
  GotoXY(27,11);
  PipeLn('|15( |12A |15) |07Add Word');
  GotoXY(27,13);
  PipeLn('|15(|12Esc|15) |07Quit');
  GotoXY(27,15);
  Pipe('|12S|04election|07: ');
  repeat
    Ch := Upcase(ReadKey);
  until Ch in ['L',(*'E',*)'A',#27];
  case Ch of
    'L' : List;
(*    'E' : Edit; *)
    'A' : AddWord;
    #27 : Quitme;
  end;
end;

begin
  Startup;
  While not quit do Menu;
end.
