

Program TGConfig;

Uses Crt;

{$I Telegard.inc} (* Includes the Telegard structures for use *)

Var Cfg_File : File of Configrec;
    Cfg_Record : configrec; (* Stores the record here *)
    Key  : Char;

Procedure Read_Record;  { This reads the record into memory }
Begin
   Assign(Cfg_File,'Config.tg');
   Reset(Cfg_File);
   Read(Cfg_File,Cfg_Record);  (* only 1 record to read so read it *)
   {Cfg_record contains the config.tg after it was read}
   Close(Cfg_File);
end;

Procedure BBS_Info;
Var Vstring,V2 : String;
    Name : String;
Begin
  Clrscr;GotoXY(10,10);  {Shows the TG version}
  Textcolor(10);  Write('Telegard version : v');
  Str(lo(cfg_record.versionid),vstring); (* Convert the word into strings *)
  Str(hi(cfg_record.versionid),v2);      (* using hi and lo functions     *)
  {See Lo and Hi functions for details but it takes parts of the word}
  If lo(cfg_record.versionid)<10 then Vstring := '.0'+vstring;
  Textcolor(11);  Writeln(v2+vstring);
  Writeln;
  Textcolor(15);  Write('           BBS Name :');
  Textcolor(14);  Writeln(cfg_record.bbsname);
  Textcolor(15);  Write('   BBS Phone Number :');
  Textcolor(14);  Writeln(cfg_record.bbsphone);
  Textcolor(15);  Write('       BBS Location :');
  Textcolor(14);  Writeln(cfg_record.bbslocation);
  Textcolor(15);  Write(' Sysop''s Name/Alias :');
  Textcolor(14);  Writeln(cfg_record.sysopname);
  Writeln;Textcolor(12);
  Writeln('        Let''s rename your BBS');
  Writeln;Textcolor(13);
  Writeln('Enter your new BBS Name below (or enter for current name)');
  Writeln('Max of 80 characters only!');
  Textcolor(9);Write(':');
  Readln(Name);
  If Name='' then Name := Cfg_record.bbsname;
  Textcolor(11);Writeln('Current BBS Name :'+Name);
  Writeln('Press any key to continue...');
  Repeat until Keypressed;
  Cfg_record.bbsname := Name; (* Hold the new value *)
end;

Procedure Paths;
Var PathData : String;
Begin
  Clrscr;GotoXY(10,1);
  Textcolor(15);  Writeln('Telegard Current Paths');
  Writeln('Paths are listed in this order:');
  Writeln('Data, Text, Language, Menu, Logs, Msg, semaphore, attaches');
  Writeln('swap path, archiver, protocol, File, and script path.');
  Gotoxy(1,6);Textcolor(14);

  Writeln(':'+cfg_record.datapath);
  Writeln(':'+cfg_record.textpath);
  Writeln(':'+cfg_record.langpath);
  Writeln(':'+cfg_record.menupath);
  Writeln(':'+cfg_record.logspath);
  Writeln(':'+cfg_record.msgpath);
  Writeln(':'+cfg_record.semaphore);
  Writeln(':'+cfg_record.attachpath);
  Writeln(':'+cfg_record.swappath);
  Writeln(':'+cfg_record.arcpath);
  Writeln(':'+cfg_record.protpath);
  Writeln(':'+cfg_record.filepath);
  Writeln(':'+cfg_record.scriptpath);
  Textcolor(13);Writeln('I bet your Script path is empty :)');
  Textcolor(12);Writeln('Let''s change your path to your menus.');
  Writeln;Textcolor(13);
  Writeln('Enter your new menu path below (or enter for current name)');
  Writeln('Max of 79 characters only! Do not forget trailing \.');
  Textcolor(9);Write(':');
  Readln(PathData);
  If PathData ='' then PathData:= Cfg_record.menupath;
  Textcolor(11);Writeln('Current Menus Path below');
  Writeln(':'+pathdata);
  Writeln('Press any key to continue...');
  Repeat until Keypressed;
  Cfg_record.menupath := Pathdata; (* Hold new value *)
end;

Procedure Write_Data;
Begin
  Clrscr;Gotoxy(10,10);
  Textcolor(12);
  Writeln('If you want to change the data then press Y otherwise hit any key');
  Repeat until keypressed;
  Key := Readkey;Key:=Upcase(key);
  If Key='Y' then
  Begin
    (* This section of code will actually write the new data *)
    Assign(Cfg_File,'config.tg');
    Reset(cfg_file);
    Write(Cfg_file, cfg_record);  (* Simply rewrites the data to file *)
    Close(cfg_file);
  end;
  Textcolor(15);Writeln;
  If Key='Y' then
  Begin
    Writeln('Data has been changed!!!');
    Writeln('Try to quit and come back in view to verify the changes');
  end else
  Begin
    Writeln('Data has NOT been changed!!!');
  end;
  Writeln('Press any key to continue...');
  Repeat until keypressed;
end;

Procedure Display_Menu;

Begin
  ClrScr;GotoXY(10,10);Textcolor(14);
  Writeln('Config.tg Demo');
  Writeln('    ** Menu **');
  Writeln(' A.  Show BBS Info');
  Writeln(' B.  Show Paths');
  Writeln(' C.  Write the new data (save changed data)');
  Writeln(' Q.  Quit');
  Writeln;
  Writeln('Press A-C or Q please');
  Repeat
    Key := Readkey;Key := Upcase(Key);
  Until (Keypressed) or (Key>=chr(65)) and (Key<=chr(67)) or (key='Q');
  Case Key of
    'A': BBS_Info;
    'B': Paths;
    'C': Write_Data;
  end;
end;

Begin
  Read_Record;
  Repeat
    Display_Menu
  until Key = 'Q';
  Writeln; Writeln('Bye Bye now!');
End.

