PROGRAM Log;

USES Dos,
     Ramon;

{--------------------------------------------------------------------------}
{ TimeStamp                                                                }
{                                                                          }
{ Deze functie geeft een string in het formaat "10:13:12" terug met de     }
{ huidige tijd erin.                                                       }
{                                                                          }
FUNCTION TimeStamp : STRING;

VAR Hour,Min,Sec,SecH  : WordLong;

BEGIN
     GetTime (Hour,Min,Sec,SecH);

     TimeStamp:=AddUpWithPre0s (2,Word2String (Hour))+':'+
                AddUpWithPre0s (2,Word2String (Min))+':'+
                AddUpWithPre0s (2,Word2String (Sec));
END;


VAR LogFile : TEXT;
    LogPath : STRING;
    Param   : STRING;
    IORes   : BYTE;
    Lp      : BYTE;
    S       : BYTE;
    Indent  : BYTE;
    Nop     : ValNop;

BEGIN
     LogPath:=GetEnv ('WGTESTLOG');

     IF (LogPath = '') THEN
     BEGIN
          WriteLn (#7,'WGTESTLOG not set');
          Halt;
     END;

     Assign (LogFile,LogPath);
     {$I-} Append (LogFile); {$I+} IORes:=IOResult;
     IF (IORes = 2) THEN
     BEGIN
          {$I-} ReWrite (LogFile); {$I+} IORes:=IOResult;
     END;

     IF (IORes <> 0) THEN
     BEGIN
          WriteLn (#7,'Error appending to / creating '+LogPath,' (error ',IORes,')');
          Halt;
     END;

     Param:='';
     S:=1;
     Indent:=1;

     Val (ParamStr (1),Indent,Nop);
     IF (Nop = 0) THEN
     BEGIN
          S:=2;
          IF (Indent < 1) OR (Indent > 10) THEN
             Indent:=1;
     END ELSE
         Indent:=1;

     FOR Lp:=S TO ParamCount DO
         Param:=Param+' '+ParamStr (Lp);

     Indent:=(Indent-1)*2;
     IF (Indent <> 0) THEN
        Param:=Spaces (Indent)+Param;

     IF (Param <> DeleteFrontSpaces (Param)) THEN
        Param:=TimeStamp+Param;

     WriteLn (LogFile,Param);
     WriteLn (Param);

     Close (LogFile);
END.
