{ ------------------------------------------------------------}
{ Globals Structures                                          }
{                                                             }
{ Information used by the various databases                   }
{                                                             }
{ (c) 1994 WaterLine Software Development                     }

{$IFNDEF Wtr_Globals}
{$DEFINE Wtr_Globals}

(* Constant Declarations --------------------------------------------------- *)

CONST MaxLenOrganization    = 60;     { Maximum length of an organization description   }
      MaxLenAreaFixPwd      = 20;     { Maximum length of an areafix password           }
      MaxLenOrigin          = 61;     { Maximum length of the origin line text          }
      MaxLenDomain          = 50;     { Maximum length of a domain description          }
      MaxLenUserName        = 50;     { Maximum length of a username                    }
      MaxLenSysopName       = MaxLenUserName;
      MaxLenAreaName        = 60;     { Maximum length of an area name                  }
      MaxLenComment         = 60;     { Maximum length of its description               }

      MaxLenGroupDesc       = 30;     { Maximum length of a group description           }
      MaxLenUUCPName        = 10;     { Maximum length of an UUCP name (7 significant)  }
      MaxDomains            = 6;      { Maximum number of domain AKA's for a user       }
      MaxSubscrBaseElements = 5;      { Maximum number of elements in a subsciption seg }
      MaxLenFidoAddrDomain  = 25;
      MaxLenFidoAddrString  = 23+MaxLenFidoAddrDomain;
      MaxAkas               = 20;     { Maximum number of Fido NodeNrs                  }

      MaxLenListNameType    = 30;     { Maximum length of a mailing list name           }
      MaxLenListPswdType    = 12;     { Maximum length of a mailing list password       }
      NILRecordNr     : WORD= 65535;  { Indicates a NIL valued record pointer           }

      DataBaseHeaderLen  = 25;

      ConfigHeader       = 'WtrGate Config 07';
      AreaBaseHeader     = 'WtrGate AreaBase 02';
      UserBaseHeader     = 'WtrGate UserBase 01';
      SubscrBaseHeader   = 'WtrGate SubscrBase 01';
      GrpDescrBaseHeader = 'WtrGate GroupDescr 01';
      ListServerHeader   = 'WtrGate ListServer 01';

      ConfigFileName        = 'WTRCFG.TDB';
      AreaBaseFilename      = 'AREABASE.TDB';
      SubscriptBaseFilename = 'SUBSCRIP.TDB';
      UserBaseFilename      = 'USERBASE.TDB';
      GroupDescBaseFilename = 'GRPDESCR.TDB';
      ListServerFileName    = 'LISTSERV.TDB';

(* Type Declarations -------------------------------------------------------- *)

TYPE FidoAddrString  = STRING[MaxLenFidoAddrString];
     FidoDateType    = STRING[20];
     AkaIndexType    = 1..MaxAkas;

     IndexValueType  = LONGINT;
     GroupFlagType   = LONGINT; { bit mask }
     AreaFlagType    = LONGINT; { bit mask }

     CompressionType = (ARC,ARJ,LZH,PAK,ZIP,ZOO,OP1,GUS,PKT);
     FidoMsgStyleType= (NoneType,FidoMsgType,SquishType,JamType);

     FidoAddrType = RECORD
                          Zone   : WORD;
                          Net    : WORD;
                          Node   : WORD;
                          Point  : WORD;
                          Domain : STRING[MaxLenFidoAddrDomain];
                    END;

     UUCPNameString  = STRING[MaxLenUUCPName];

     BaseRecordNrType          = WORD;              { Standard Record Nr }
     AreaBaseRecordNrType      = BaseRecordNrType;
     SubscriptBaseRecordNrType = BaseRecordNrType;
     UserBaseRecordNrType      = BaseRecordNrType;
     GroupDescBaseRecordNrType = BaseRecordNrType;
     ListServerRecordNrType    = BaseRecordNrType;

{$ENDIF} { Wtr_Globals }




