PROGRAM JAMDumpLR;

{ Dump LastRead info from JAM-base }

USES Ramon;

TYPE LRRec = RECORD
                   UserCRC,
                   UserID,
                   LastReadMsg,
                   HighReadMsg : LONGINT;
             END;

VAR InFile : FILE;
    LR     : LRRec;

BEGIN
     IF (ParamCount <> 1) THEN
        Halt;

     Assign (InFile,ParamStr (1)+'.JLR');
     Reset (InFile,1);

     WriteLn ('------------------------------------------------');
     WriteLn ('Dumping LastRead info from '+ParamStr (1)+'.JLR');
     WriteLn ('------------------------------------------------');
     WriteLn ('Rec  UserCRC  UserID   LastRead HighRead');

     WHILE (FilePos (InFile) < FileSize (InFile)) DO
     BEGIN
          BlockRead (InFile,LR,SizeOf (LRRec));
          WriteLn (Word2HexString (FilePos (InFile) DIV SizeOf (LRRec))+' ',
                   Long2HexString (LR.UserCRC)+' ',
                   Long2HexString (LR.UserID)+' ',
                   Long2HexString (LR.LastReadMsg)+' ',
                   Long2HexString (LR.HighReadMsg));
     END;

     WriteLn ('------------------------------------------------');

     Close (InFile);
END.
