PROGRAM DmpNLTdb;

{ this program dumps the contents of nodelist.tdb to a text file, }
{ for verification of its contents.                               }

TYPE FilenameEntry = RECORD
                           Filename : ARRAY[1..8+1+3] OF CHAR;
                           Length   : LONGINT;
                     END;

TYPE ZoneEntry = RECORD
                       Zone   : WORD;
                       Length : WORD;
                 END;

TYPE NetEntry = RECORD
                      Net       : WORD;
                      ByteNodes : BYTE;
                      WordNodes : BYTE;
                END;

VAR InFile   : FILE;
    OutFile  : TEXT;
    IORes    : BYTE;

    FName    : FilenameEntry;
    FNameStr : STRING[8+1+3];

    Zone     : ZoneEntry;
    Net      : NetEntry;

    BNode    : BYTE;
    WNode    : WORD;

BEGIN
     WriteLn ('Dump NODELIST.TDB utility');
     WriteLn ('Reading NODELIST.TDB and writing to NODELIST.DMP (ascii)');
     WriteLn ('Wait...');

     Assign (OutFile,'NODELIST.DMP');
     ReWrite (OutFile);

     Assign (InFile,'NODELIST.TDB');
     {$I-} Reset (InFile,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          WriteLn ('Could not open NODELIST.TDB (error ',IORes,')');
          Close (OutFile);
          Exit;
     END;

     WHILE (FilePos (InFile) < FileSize (InFile)) DO
     BEGIN
          BlockRead (InFile,FName,SizeOf (FilenameEntry));

          Move (FName.Filename,FNameStr[1],8+1+3);
          FNameStr[0]:=Char (8+1+3);

          WriteLn (OutFile,'Nodelist filename: ',FNameStr,' (Length: ',FName.Length,')');
          WriteLn (OutFile);

          WHILE (FName.Length > 0) DO
          BEGIN
               BlockRead (InFile,Zone,SizeOf (ZoneEntry));
               Dec (FName.Length,SizeOf (ZoneEntry));
               Dec (FName.Length,Zone.Length);

               WriteLn (OutFile,'Zone: ',Zone.Zone,' (Length = ',Zone.Length,')');

               WHILE (Zone.Length > 0) DO
               BEGIN
                    BlockRead (InFile,Net,SizeOf (NetEntry));
                    Dec (Zone.Length,SizeOf (NetEntry));
                    Dec (Zone.Length,Net.ByteNodes);
                    Dec (Zone.Length,Net.WordNodes*2);

                    WriteLn (OutFile,' Net: ',Net.Net,' (Nodes: ',Net.ByteNodes,'+',Net.WordNodes,')');

                    WHILE (Net.ByteNodes > 0) DO
                    BEGIN
                         BlockRead (InFile,BNode,1);
                         Dec (Net.ByteNodes);
                         WriteLn (OutFile,'  Node: ',BNode:5,'  ->  ',Zone.Zone,':',Net.Net,'/',BNode);
                    END;

                    WHILE (Net.WordNodes > 0) DO
                    BEGIN
                         BlockRead (InFile,WNode,2);
                         Dec (Net.WordNodes);
                         WriteLn (OutFile,'  Node: ',WNode:5,'  ->  ',Zone.Zone,':',Net.Net,'/',WNode);
                    END;
               END; { while }

          END; { while }

          WriteLn (OutFile,'-- end of this nodelist --');
     END; { while }

     Close (InFile);
     Close (OutFile);
END.
