PROGRAM CorrDate;

USES Ramon,
     Fido;

PROCEDURE CorrectDate (DateStr,ExpectStr : STRING);

VAR OutStr : STRING;

BEGIN
     OutStr:=FidoCorrectDate (DateStr);

     Write (AddUpWithSpaces (22,'"'+DateStr+'"'),' -> "',OutStr,'" = ');
     IF (OutStr = ExpectStr) OR (ExpectStr = '') THEN
        WriteLn ('OK')
     ELSE
         WriteLn ('Not OK ***');
END;


BEGIN
     WriteLn ('---');

     { normal correct format }
     CorrectDate ('01 Jan 00  12:13:14','01 Jan 00  12:13:14');

     { seadog format }
     CorrectDate ('Sat 19 Mar 93 10:45','19 Mar 93  10:45:00');

     { seadog format }
     CorrectDate ('Thu  1 Apr 99 10:45','01 Apr 99  10:45:00');

     { missing space }
     CorrectDate ('01 Jan 00 12:13:14', '01 Jan 00  12:13:14');

     { single-digit year }
     CorrectDate ('15 Jan 1  12:13:00', '15 Jan 01  12:13:00');

     { three-digit year }
     CorrectDate ('15 Jan 104  12:13:5','15 Jan 04  12:13:50');

     { four digit year }
     CorrectDate ('15 Jan 2000 12:13',  '15 Jan 00  12:13:00');

     { year 2000 in weird format }
     CorrectDate ('15 Jan :0  12:13:59','15 Jan 00  12:13:59');

     { year 2140 in weird format }
     CorrectDate ('15 Jan >0  12:13:59','15 Jan 40  12:13:59');

     { pre-space instead of zero }
     CorrectDate (' 1 Jan 00  12:13:00','01 Jan 00  12:13:00');

     { invalid time }
     CorrectDate ('01 Jan 00  12:75:14','01 Jan 00  12:00:14');

     { must become :20, not :02 }
     CorrectDate ('01 Jan 00  12:75:2', '01 Jan 00  12:00:20');

     { invalid day }
     CorrectDate ('00 Jan 00  12:57:14','01 Jan 00  12:57:14');

     { invalid month }
     CorrectDate ('01 Anv 00  12:13:14','');

     { invalid hours }
     CorrectDate ('01 Jan 00  24:00:00','01 Jan 00  00:00:00');

     { short hours }
     CorrectDate ('01 Jan 00  4:00:00', '01 Jan 00  04:00:00');

     { invalid mins }
     CorrectDate ('01 Jan 00  23:60:00','01 Jan 00  23:00:00');

     { short mins }
     CorrectDate ('01 Jan 00  23:6:00', '01 Jan 00  23:06:00');

     { invalid secs }
     CorrectDate ('01 Jan 00  23:00:60','01 Jan 00  23:00:00');
     CorrectDate ('01 Jan 00  23:00:6', '01 Jan 00  23:00:00');

     { short secs }
     CorrectDate ('01 Jan 00  23:00:4', '01 Jan 00  23:00:40');

     { invalid dates }
     CorrectDate ('35 Apr 00  23:59:59','30 Apr 00  23:59:59');
     CorrectDate ('30 Feb 99  23:59:59','28 Feb 99  23:59:59');

     { schrikkeljaar }
     CorrectDate ('29 Feb 96  23:59:59','29 Feb 96  23:59:59');
     CorrectDate ('29 Feb 99  23:59:59','28 Feb 99  23:59:59');
     CorrectDate ('29 Feb 00  23:59:59','29 Feb 00  23:59:59');
     CorrectDate ('29 Feb 01  23:59:59','28 Feb 01  23:59:59');
     CorrectDate ('29 Feb 04  23:59:59','29 Feb 04  23:59:59');

     CorrectDate ('dd mmm yy  hh:mm:ss','');
     CorrectDate ('Some garbage','');
     CorrectDate ('','');
END.
