PROGRAM Colors;

USES Ramon;


{--------------------------------------------------------------------------}
{ ColorEditor                                                              }
{                                                                          }
{ Deze routine kan gebruikt worden om de kleuren die WaterGate gebruikt te }
{ veranderen.                                                              }
{                                                                          }
PROCEDURE ColorEditor;

    PROCEDURE EditOneColor (Color : ColorSet);

    CONST Xb = 10;
          Yb = 7;

    VAR Lp      : BYTE;
        Attr    : BYTE;
        Quit    : BOOLEAN;
        C,PrevC,
        R,PrevR : BYTE;
        X,Y     : XYType;

    BEGIN
         PushKeysLine;
         WriteKeysLine (' ^Esc Abort  ^F10 Accept  ^Left/Right Change ^Up/Down Foreground/Background');

         WindowPush (Xb,Yb,65,12);
         BoxDraw (Double,Xb,Yb,65,12);

         WriteXY (Xb+2,Yb+2,'Foreground');
         WriteXY (Xb+2,Yb+5,'Background');

         FOR Lp:=0 TO 15 DO
         BEGIN
              ModifyColor (cCustom1,Lp);
              WriteXYC (Xb+15+Lp*3,Yb+2,cCustom1,'');

              ModifyColor (cCustom1,Lp*16);
              WriteXYC (Xb+15+Lp*3,Yb+5,cCustom1,'  ');
         END;

         Attr:=GetColorValue (Color);

         R:=1;
         C:=Attr AND 15;
         PrevR:=2;
         PrevC:=255;

         SetLines (Single);

         Quit:=FALSE;
         REPEAT
               IF (PrevR <> R) OR (PrevC <> C) THEN
               BEGIN
                    SetColor (cBoxBack);

                    { oude verwijderen }
                    IF (PrevC <> 255) THEN
                    BEGIN
                         Y:=Yb+PrevR*3-2;
                         X:=Xb+14+PrevC*3;

                         WriteXY (X,Y,'    ');
                         WriteXY (X,Y+1,' ');
                         WriteXY (X+3,Y+1,' ');
                         WriteXY (X,Y+2,'    ');
                    END;

                    { nieuwe tekenen }

                    Y:=Yb+R*3-2;
                    X:=Xb+14+C*3;

                    WriteXY (X,Y,LB+HO+HO+RB);
                    WriteXY (X,Y+1,VR);
                    WriteXY (X+3,Y+1,VR);
                    WriteXY (X,Y+2,LON+HO+HO+RO);

                    PrevC:=C;
                    PrevR:=R;

                    WriteXY (Xb+5,Yb+8,Byte2HexString (Attr));

                    ModifyColor (cCustom1,Attr);
                    SetColor (cCustom1);
                    WriteXY (Xb+15,Yb+8,' This is in the selected color ');
               END;

               CASE ReadKey OF
                    kF10 :
                        BEGIN
                             ModifyColor (Color,Attr);
                             Quit:=TRUE;
                        END;

                    kEsc :
                        Quit:=TRUE;

                    kUp :
                        IF (R = 2) THEN
                        BEGIN
                             R:=1;
                             C:=Attr AND 15;
                        END;

                    kDown :
                        IF (R = 1) THEN
                        BEGIN
                             R:=2;
                             C:=Attr SHR 4;
                        END;

                    kRight :
                        IF (C < 15) THEN
                        BEGIN
                             Inc (C);
                             IF (R = 1) THEN
                                Inc (Attr)
                             ELSE
                                 Inc (Attr,16);
                        END;

                    KLeft :
                        IF (C > 0) THEN
                        BEGIN
                             Dec (C);
                             IF (R = 1) THEN
                                Dec (Attr)
                             ELSE
                                 Dec (Attr,16);
                        END;

               END; { case }

         UNTIL Quit;

         WindowPop;
         PopKeysLine;
    END;

VAR Quit  : BOOLEAN;
    Keuze : WORD;

BEGIN
     ListDefine (2,3,80,Video.Rows-4,Default,'Select a color',0);

     ListAddItem ('Desktop: background',Byte (cDesktop),Bottom);
     ListAddItem ('Desktop: title',Byte (cHeaders),Bottom);
     ListAddItem ('Window: border, no focus',Byte (cBoxLinesInactive),Bottom);
     ListAddItem ('Window: border, focus',Byte (cBoxLinesActive),Bottom);
     ListAddItem ('Window: background',Byte (cBoxBack),Bottom);
     ListAddItem ('Window: shadow',Byte (cBoxShadow),Bottom);
     ListAddItem ('Window: text',Byte (cBoxData),Bottom);
     ListAddItem ('Message: error',Byte (cError),Bottom);
     ListAddItem ('Message: normal',Byte (cMessage),Bottom);
     ListAddItem ('Keys line: key name',Byte (cKeyName),Bottom);
     ListAddItem ('Keys line: key description',Byte (cKeyDescr),Bottom);
     ListAddItem ('Keys line: blinking text',Byte (cKeyBlink),Bottom);
     ListAddItem ('Help: window',Byte (cHelp),Bottom);
     ListAddItem ('Help: highlighted',Byte (cHelpBright),Bottom);
     ListAddItem ('Help: link',Byte (cHelpLink),Bottom);
     ListAddItem ('List: Tagged item',Byte (cBoxDataTagged),Bottom);
     ListAddItem ('List: Not taggable item',Byte (cNotTagable),Bottom);
     ListAddItem ('Disabled field',Byte (cFieldDisabled),Bottom);
     ListAddItem ('Cursor bar',Byte (cMenuSelectBar),Bottom);
     ListAddItem ('Cursor bar on tagged item',Byte (cFieldCursorTagged),Bottom);
     ListAddItem ('Selected menu/list item',Byte (cMenuSelected),Bottom);

     Quit:=FALSE;
     REPEAT
           Keuze:=ListSelect (NoTag,[]);

           CASE Key OF
                kEsc : Quit:=TRUE;

                kRet : EditOneColor (ColorSet (Keuze));
           END; { case }

     UNTIL Quit;

     ListErase;
END;


BEGIN
     OpenDesktop ('Colors','1.0');

     ColorEditor;

     CloseDesktop;
END.
