{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT Trans;

{$i platform.inc}

{ new Translate unit to translate messages from one format to another }

{## netmail to mail laten zoeken naar "gw-to: a,b,c,d", "gw-cc: a,b,c,d" and
    "gw-bcc: a,b,c,d" apart from normal "To: a" }

INTERFACE

USES Database;

PROCEDURE Translate_Netmail2Mail;
PROCEDURE Translate_Mail2Netmail;

PROCEDURE Translate_News2Echomail;
PROCEDURE Translate_Echomail2News;

PROCEDURE Translate_News2Mail;
PROCEDURE Translate_Mail2News;

PROCEDURE Translate_Netmail2Echomail;
PROCEDURE Translate_Echomail2Netmail;

FUNCTION  FtnizeUserName (UserName : STRING) : STRING;
FUNCTION  FtnSubj_RemovePaths (Subj : STRING; FABit : BYTE) : STRING;

FUNCTION  CompleteMsgId (MsgID : STRING; SysAka : BYTE) : STRING;

FUNCTION  Trans_UserPlusAka2Email (FromUser : STRING; FromAKA : FidoAddrType) : STRING;
FUNCTION  Trans_NiceCaseName (Name : STRING) : STRING;
FUNCTION  CleanFidoName (Invoer : STRING; DoUnderScore : BOOLEAN) : STRING;
FUNCTION  Trans_RfcHeader2FullName (HeaderLen : BYTE; Header : STRING) : STRING;

PROCEDURE TransFix_Load (VAR AreaRec : AreaBaseRecord; MsgId : STRING);
PROCEDURE TransFix_Unload;
FUNCTION  TransFix_HeaderLine (Regel : STRING) : STRING;
FUNCTION  TransFix_FooterLine (Regel : STRING) : STRING;

{ for testing only, please remove! }
FUNCTION  MsgID2MessageID (MsgID : STRING) : STRING;
FUNCTION  MessageID2MsgID (Debug : CHAR; MessageID : STRING) : STRING;
FUNCTION  TestMessageID2MsgID (ID : STRING) : BOOLEAN;

FUNCTION BuildFidonetInternetAdres (Source : FidoAddrType; AddPunt : STRING) : STRING;

{## post-translation requirements:

i- REPLYTO *FTN* moet vervangen worden door REPLYTO <area origin aka><sp><config.gatewayuser>
i- MSGID *FTN* moet vervangen worden door MSGID <area origin aka> <area msgid>
-- Dan ook FromAddr_F EN ToAddr_F door deze AKA vervangen.
-- XPOST: kludge moet toegevoegd worden
i- AREA: kludge moet toegevoegd worden (not, now done during export)
i-  * Origin:  (*FTN*) -> add area origin and replace *FTN* with area originaka
i-  * Origin: text (*FTN*) -> replace *FTN* with area origin aka
}


IMPLEMENTATION

USES Ramon,
     Cfg,
     Msgs,
     Logs,
     Fido,
     Globals,
     Routing,
     Usenet,
     SwapMem,
     UU,
     Charsets,
     Language,
     Address,
     SeenBy,
     ListSrv,
     DelMime,
     Import;

      { tijdelijk, voor subject, from, to, etc. }
CONST CnstTekens : TekenArrayType = (
 {128..136} {}'c',{}'u',{}'e',{}'a',{}'a',{}'a',{}'a',{}'c',{}'e',
 {137..145} {}'e',{}'e',{}'i',{}'i',{}'i',{}'A',{}'A',{}'E',{}'*',
 {146..154} {}'A',{}'o',{}'o',{}'o',{}'u',{}'u',{}'y',{}'O',{}'U',
 {155..163} {}'*',{}'*',{}'*',{}'*',{}'f',{}'a',{}'i',{}'o',{}'u',
 {164..172} {}'e',{}'N',{}'*',{}'*',{}'?',{}'+',{}'+',{}'*',{}'*',
 {173..181} {}'!',{}'<',{}'>',{}'*',{}'*',{}'*',{}'|',{}'+',{}'+',
 {182..190} {}'+',{}'+',{}'+',{}'+',{}'|',{}'+',{}'+',{}'+',{}'+',
 {191..199} {}'+',{}'+',{}'+',{}'+',{}'+',{}'-',{}'+',{}'+',{}'+',
 {200..208} {}'+',{}'+',{}'+',{}'+',{}'+',{}'-',{}'+',{}'+',{}'+',
 {209..217} {}'+',{}'+',{}'+',{}'+',{}'+',{}'+',{}'+',{}'+',{}'+',
 {218..226} {}'+',{}'*',{}'*',{}'*',{}'*',{}'*',{}'a',{}'b',{}'c',
 {227..235} {}'d',{}'E',{}'*',{}'*',{}'*',{}'*',{}'*',{}'*',{}'*',
 {236..244} {}'*',{}'*',{}'*',{}'*',{}'=',{}'*',{}'*',{}'*',{}'*',
 {245..253} {}'*',{}'*',{}'=',{}'*',{}'*',{}'*',{}'*',{}'*',{}'*',
 {254..255} {}'*',{}'*');

VAR TransFix_OriginAka : BYTE;
    TransFix_Origin    : STRING[MaxLenOrigin];
    TransFix_MsgId     : STRING[8];
    TransFix_AreaName  : STRING[MaxLenAreaName];

{==========================================================================}
{                       DATE TRANSLATION                                   }
{==========================================================================}


{--------------------------------------------------------------------------}
{ DayOfWeek                                                                }
{                                                                          }
{ Deze routine bepaald de dag van de week in 0 voor maandag tot en met 6   }
{ voor zondag aan de hand van een dag nummer in de huidige maand.          }
{                                                                          }
{ RWI 950527: Overgenomen uit mijn verlof administratie programma, want    }
{             dit is zwaar klote werk!                                     }
{                                                                          }
FUNCTION DayOfWeek (Dag,Maand : BYTE; Jaar : WORD) : BYTE;

CONST DagenPerMaand : ARRAY[1..12] OF BYTE = (31,28,31,30,31,30,31,31,30,31,30,31);

VAR DagenSinds010180 : LONGINT;

BEGIN
     { normaal: 365 dagen/jaar. Schrikkel: 366 }
     DagenSinds010180:=0; { 1 jan 1980 was op een ... }

     WHILE (Maand > 1) DO
     BEGIN
          Dec (Maand);

          IF (Maand = 2) AND
             ((Jaar MOD 4) = 0) AND
             ( ((Jaar MOD 100) <> 0) OR ((Jaar MOD 400) = 0) )
          THEN
              Inc (DagenSinds010180);

          DagenSinds010180:=DagenSinds010180+DagenPerMaand[Maand];
     END;

     WHILE (Jaar > 1980) DO
     BEGIN
          Dec (Jaar);

          IF ((Jaar MOD 4) = 0) AND
              ( ((Jaar MOD 100) <> 0) OR ((Jaar MOD 400) = 0) )
          THEN
              Inc (DagenSinds010180);

          DagenSinds010180:=DagenSinds010180+365;
     END;

     DagenSinds010180:=DagenSinds010180+Dag;

     DayOfWeek:=(DagenSinds010180 MOD 7);
END;


{--------------------------------------------------------------------------}
{ Ftn2RfcDate                                                              }
{                                                                          }
{ Converteerd het Fido datum formaat naar een Usenet formaat               }
{ We houden het voorlopig simpel, verschil met TZ's rekenen we nog niet    }
{ mee.                                                                     }
{                                                                          }
{ Fido   : "01 Jan 86  02:34:56 "                                          }
{ UseNet : "Fri, 19 Nov 93 04:38:38 GMT"                                   }
{                                                                          }
{ RWI 950527: Nu wordt ook de dag van de week toegevoegd. Dat zal wat      }
{             problemen oplossen met die stomme verwerk punten die tijd    }
{             over hebben en formaten staan te controleren!                }
{                                                                          }
{ RAWI 971206: Added support for "01 Jan 100  00:01:1".                    }
{                                                                          }
FUNCTION Ftn2RfcDate (WerkRegel : STRING) : STRING;

VAR Jaar     : WORD;
    Lp,
    Maand,
    Dag,
    Dow      : BYTE;
    MaandStr : STRING[3];
    Nop      : ValNop;

BEGIN
     Val (Copy (WerkRegel,1,2),Dag,Nop);
     IF (Nop <> 0) THEN
        LogMessage (liFatal,'[Ftn2RfcDate] Error getting day from "'+WerkRegel+'"');

     MaandStr:=Copy (WerkRegel,4,3);

     IF (WerkRegel[10] = ' ') THEN
        Val (Copy (WerkRegel,8,2),Jaar,Nop)
     ELSE
         Val (Copy (WerkRegel,8,3),Jaar,Nop);   { "100" situation }

     IF (Nop <> 0) THEN
        LogMessage (liFatal,'[Ftn2RfcDate] Error getting year from "'+WerkRegel+'"');

     Jaar:=Jaar+1900;              { 100+ -> 2000+ }
     IF (Jaar < 1980) THEN         { RWI 960105: was 80... }
        Jaar:=Jaar+100; { 2000+ }

     Maand:=0;
     MaandStr:=UpCaseString (MaandStr);
     FOR Lp:=1 TO 12 DO
         IF (MaandStr = UpCaseString (Month[Lp])) THEN
         BEGIN
              Maand:=Lp;
              Break;
         END;

     IF (Maand = 0) THEN
     BEGIN
          LogMessage (liGeneral,'[MonthString2Nr] Cannot handle "'+Copy (WerkRegel,4,3)+'", assuming Sunday');
          Dow:=0;
     END ELSE
     BEGIN
          Dow:=DayOfWeek (Dag,Maand,Jaar);
          { 0=Maandag ipv Zondag... aanpassen }
          Dow:=(Dow+1) MOD 7;
     END;

     { extract the time parts }
     IF (Pos ('  ',WerkRegel) > 0) THEN
        Delete (WerkRegel,1,Pos ('  ',WerkRegel)+1)
     ELSE BEGIN
          LogMessage (liGeneral,'[Ftn2RfcDate] No double space in "'+WerkRegel+'", taking 00:00:00');
          WerkRegel:='00:00:00'; { force correct time }
     END;

     WHILE (WerkRegel[Length (WerkRegel)] IN [' ',#0]) AND (Length (WerkRegel) > 0) DO
           Delete (WerkRegel,Length (WerkRegel),1);

     IF (Length (WerkRegel) < 8{hh:mm:s}) THEN
        WerkRegel:=WerkRegel+'0';

     { RWI 950528: Toevoeging dag van de week }
     Ftn2RfcDate:=Day[Dow]+', '+Byte2String (Dag)+' '+Month[Maand]+' '+Word2String (Jaar)+' '+WerkRegel+' '+Config.TimeZone;
END;


{--------------------------------------------------------------------------}
{ Rfc2FtnDate                                                              }
{                                                                          }
{ Converteert de Usenet datum formaten naar het fido formaat.              }
{                                                                          }
{ UseNet : "Fri, 19 Nov 93 04:38:38 GMT"                                   }
{ Fido   : "01 Jan 86  02:34:56 "                                          }
{                                                                          }
FUNCTION Rfc2FtnDate (Oud : STRING) : FidoDateType;

VAR P     : BYTE;
    Datum : STRING[9];
    Tijd  : STRING[8];

BEGIN
     { RWI 950506: een bericht zonder datum kan voorkomen (ik had er zelf }
     {             een gemaakt ;-)                                        }
     IF (Oud = '') THEN
     BEGIN
          Rfc2FtnDate:=FidoCurrTime2Str;
          Exit;
     END;

     { Strip de kludge indicator uit OrgOud: "Date: ..." }
     Oud:=Copy (Oud,Pos (':',Oud)+2,Length (Oud));

     P:=Pos (',',Oud);
     IF (P > 0) THEN { Formaat 1: "Fri, 19 Mrt 93 16:14:55 GMT" }
        Delete (Oud,1,Pos (',',Oud));

     { eventuele voorloopspaties weghalen }
     WHILE (Oud[1] = ' ') DO
           Delete (Oud,1,1);

     { eventuele achtervoeg spaties weghalen }
     WHILE (Oud[Length (Oud)] = ' ') DO
           Delete (Oud,Length (Oud),1);

     { als het jaartal er in vier cijfers staat, dan naar twee omzetten }
     { zorg dat de software meer dan een eeuw mee kan }
     IF (Pos ('199',Oud) > 0) THEN
        Delete (Oud,Pos ('199',Oud),2); { 1993 -> 93 }

{## improve this shit.. }
     IF (Pos ('200',Oud) > 0) THEN
        Delete (Oud,Pos ('200',Oud),2); { 2010 -> 10 }

     IF (Pos ('201',Oud) > 0) THEN
        Delete (Oud,Pos ('201',Oud),2); { 2010 -> 10 }

     IF (Pos ('202',Oud) > 0) THEN
        Delete (Oud,Pos ('202',Oud),2); { 2020 -> 20 }

     IF (Pos ('203',Oud) > 0) THEN
        Delete (Oud,Pos ('203',Oud),2); { 2030 -> 30 }

     IF (Pos ('204',Oud) > 0) THEN
        Delete (Oud,Pos ('204',Oud),2); { 2040 -> 40 }

     { eventuele dubbele spatie tussen de datum en tijd weghalen }
     WHILE (Pos ('  ',Oud) > 0) DO
           Delete (Oud,Pos ('  ',Oud),1);

     { voorloop nul bij de uren invullen }
     IF (Oud[Pos (':',Oud)-2] = ' ') THEN
        Insert ('0',Oud,Pos (':',Oud)-1);

     { alle troep is er nu uit, nu kunnen we de rest overnemen }
     P:=Pos (':',Oud)-3;  { zoek het eind van de datum op }
     Datum:=Copy (Oud,1,P);
     Delete (Oud,1,P);

     IF (Pos (' ',Oud) > 0) THEN { "16:34:11 GMT" of "16:34:11 +0100" }
        Tijd:=Copy (Oud,1,Pos (' ',Oud)-1)
     ELSE
         Tijd:=Oud;

     { voorloop nul bij de dagen invullen }
     IF (Datum[2] = ' ') THEN
        Insert ('0',Datum,1);

     { voorloop nul bij de minuten invullen }
     IF (Tijd[Pos (':',Tijd)+2] = ':') THEN
        Insert ('0',Tijd,Pos (':',Tijd)+1);

     { voorloop nul bij de seconden invullen }
     IF (Tijd[Length (Tijd)-1] = ':') THEN
        Insert ('0',Tijd,Length (Tijd));

     IF (Length (Tijd) = 5) THEN { geen seconden deel }
        Tijd:=Tijd+':00';

     Rfc2FtnDate:=Datum+'  '+Tijd; { 19 tekens, zonder #0 afsluiter }
END;


{==========================================================================}
{                         MSGID <-> Message-Id:                            }
{==========================================================================}


{ MSGID <-> Message-ID mapping                                             }
{                                                                          }
{ 1) MSGID moet het Internet op kunnen en bij terugkomst gedetecteerd      }
{    worden en weer netjes omgezet worden.                                 }
{                                                                          }
{ 2) Niet-FTN MSGID kludges moeten gecodeerd worden in een Message-ID      }
{    header en bij terugkomst weer gedecodeerd worden. Lijkt op 1)         }
{    maar kan een andere kodering gebruiken.                               }
{                                                                          }
{ 3) Message-IDs die eens omgezet zijn in een MSGID en nu op de terug      }
{    weg zijn moeten weer netjes terug omgezet worden.                     }
{                                                                          }
{ Message-ID: codering: Zet er "wgid$" voor en neem de rest over en        }
{                       voeg een CRC32 over dit stuk toe.                  }
{                                                                          }
{ MSGID codering: als er wgid$ voor staat en de CRC32 klopt, neem dan      }
{                 de rest over.                                            }


{--------------------------------------------------------------------------}
{ FidoAddr2MimeStr                                                         }
{                                                                          }
{ This routine converts the Zone, Net, Node and Point parts of a FTN       }
{ address to a Gatebau MSGID.DOC compliant string. For example: 2:242/6.1  }
{ wordt 2=3A242=2F6.1                                                      }
{                                                                          }
FUNCTION FidoAddr2MimeStr (VAR Addr : FidoAddrType) : STRING;
BEGIN
     FidoAddr2MimeStr:=Word2String (Addr.Zone)+
                       '=3A'+
                       Word2String (Addr.Net)+
                       '=2F'+
                       Word2String (Addr.Node)+
                       '.'+
                       Word2String (Addr.Point);
END;


{--------------------------------------------------------------------------}
{ FidoDate2Gatebau                                                         }
{                                                                          }
{ This routine converts a FTN date in the format "01 Jan 98  10:20:30"     }
{ in the Gatebau format YYMMDD_HHMMSS.                                     }
{                                                                          }
FUNCTION FidoDate2Gatebau (Date : STRING) : STRING;

VAR Lp    : BYTE;
    Found : BOOLEAN;

BEGIN
     Found:=FALSE;
     FOR Lp:=1 TO 12 DO
         IF (UpCaseString (Copy (Date,4,3)) = UpCaseString (Month[Lp])) THEN
         BEGIN
              Found:=TRUE;
              Break;
         END;

     IF (NOT Found) THEN
     BEGIN
          LogMessage (liGeneral,'Could not decide on month from "'+Copy (Date,4,3)+'"; assuming 1');
          Lp:=1;
     END;

     FidoDate2Gatebau:=Date[8]+Date[9]+
                       AddUpWithPre0s (2,Byte2String (Lp))+
                       Date[1]+Date[2]+
                       '_'+
                       Date[12]+Date[13]+
                       Date[15]+Date[16]+
                       Date[18]+Date[19];
END;


{--------------------------------------------------------------------------}
{ MsgID2MessageID                                                          }
{                                                                          }
{ Deze routine vertaalt de fido MSGID kludge in een legale Message-ID      }
{ header en geeft deze terug (zonder de "Message-ID: ") voor toevoeging    }
{ aan de mail/news header.                                                 }
{                                                                          }
{ Message-ID codering in de MSGID kludge wordt gedetecteerd en vertaald in }
{ de originele header. Anders wordt de MSGID kludge gecodeerd en terug     }
{ gegeven.                                                                 }
{                                                                          }
FUNCTION MsgID2MessageID (MsgID : STRING) : STRING;

VAR Res : STRING;
    Lp  : BYTE;
    C   : CHAR;
    CRC : LONGINT;

BEGIN
     { Msg.MsgID_F bevat "anything crc32". }

     IF (MsgID = '') THEN
     BEGIN
          IF (Msg.FirstDest = NIL) THEN
             Res:=''
          ELSE
              Res:=Msg.FirstDest^.ToUser_F;

          Res:=Msg.FromUser_F+Res+Msg.Subj_F;
          CRC:=UpdateCRC32 ($FFFFFFFF,Res[1],Length (Res));

          Res:='<NOMSGID_'+
               FidoAddr2MimeStr (Msg.FromAddr_F)+'_'+
               FidoDate2Gatebau (Msg.Date_F)+'_'+
               LoCaseString (Long2HexString (CRC))+'@';

          IF (Msg.FromAddr_F.Zone IN [1..6]) THEN
             Res:=Res+'fidonet.org>'
          ELSE
              Res:=Res+Config.Domains[1]+'>';

         {Res:='<none_'+GetFidoPktName+'@'+Config.Domains[1]+'>';}

          MsgID2MessageID:=Res;
          Exit; { ## EXIT ## }
     END;

     { splitsen van "anything" en CRC32 (de laatste 8 tekens met een }
     { spatie ervoor zodat we een gecodeerde Message-ID: kunnen      }
     { herstellen.                                                   }
     IF (Length (MsgID) > 9) AND (MsgID[Length (MsgID)-8] = ' ') THEN
     BEGIN
          IF (Copy (MsgID,1,6) = 'wgmid$') THEN
          BEGIN
               { lekker makkelijk: een Message-ID: op de terugweg }
               MsgID2MessageID:=Copy (MsgID,7,Length (MsgID)-8-7);
               Exit; { ## EXIT ## }
          END;

          { Gatebau: gewoon <*@*> }
          IF (MsgID[1] = '<') AND (MsgID[Length (MsgID)-9] = '>') AND
             (Pos ('@',MsgID) > 0) THEN
          BEGIN
               MsgID2MessageID:=Copy (MsgID,1,Length (MsgID)-9);
               Exit; { ## EXIT ## }
          END;

          { Gatebau: gewoon "<*@*>" }
          IF (MsgID[1] = '"') AND (MsgID[2] = '<') AND
             (MsgID[Length (MsgID)-9] = '"') AND (MsgID[Length (MsgID)-10] = '>') AND
             (Pos ('@',MsgID) > 0) THEN
          BEGIN
               Res:=Copy (MsgID,2,Length (MsgID)-9-2);
               WHILE (Pos ('""',Res) > 0) DO
                     Delete (Res,Pos ('""',Res),1);
               MsgID2MessageID:=Res;
               Exit; { ## EXIT ## }
          END;

          { no special conversion, fall back to normal operation }
     END;

     { generic coding }
     Res:='<MSGID_';

     { MIME encode the rest }
     FOR Lp:=1 TO Length (MsgID) DO
     BEGIN
          IF (MsgID[Lp] IN [#0..#31,#128..#255,'(',')','<','>','@',',',';',':','\','"','[',']','/','=','_']) THEN
             Res:=Res+'='+Byte2HexString (Byte (MsgId[Lp]))
          ELSE
              IF (MsgID[Lp] = ' ') THEN
                 Res:=Res+'_'
              ELSE
                  Res:=Res+MsgID[Lp];
     END;

     IF (Msg.FromAddr_F.Zone IN [1..6]) THEN
        Res:=Res+'@fidonet.org>'
     ELSE
         Res:=Res+'@'+Config.Domains[1]+'>';

     MsgID2MessageID:=Res;
END;

     (* old stuff, from before Gatebau
     { RWI 970112: kijk of dit al een gecodeerde, vroeger Message-ID is }
     IF (Copy (MsgID,1,6) = 'wgmid$') THEN
     BEGIN
          Delete (MsgID,1,6);
          MsgID2MessageID:=MsgID;
          Exit;
     END;

     { ietwat meer werk: codering van een generiek MSGID }

     Res:='wgcid$';  { coded id }
     FOR Lp:=1 TO Length (MsgID) DO
     BEGIN
          C:=MsgID[Lp];

          CASE C OF
               'A'..'Z',
               'a'..'z',
               '0'..'9',
               '-' : Res:=Res+C;

               ':' : Res:=Res+'$g';
               '/' : Res:=Res+'$h';
               '.' : Res:=Res+'$i';
               ' ' : Res:=Res+'$j';
               '@' : Res:=Res+'$k';

               ELSE
                   Res:=Res+'$'+LoCaseString (Byte2HexString (Byte (C)));
          END; { case }
     END; { for }

     MsgID2MessageID:='<'+Res+'@'+Config.Domains[1]+'>';
END;
*)


{--------------------------------------------------------------------------}
{ TestMessageID2MsgID                                                      }
{                                                                          }
{ Deze routine controleert of een Message-ID:, In-Reply-To: or References: }
{ header contains a valid Message Identification that can be copied into   }
{ the MSGID or REPLY kludge of a fido message. If so, returns TRUE.        }
{                                                                          }
FUNCTION TestMessageID2MsgID (ID : STRING) : BOOLEAN;

VAR P1,P2,P3 : BYTE;

BEGIN
     {LogMessage (liDebug,'TestMessageID2MsgID: ID="'+ID+'"');}

     TestMessageID2MsgID:=FALSE; { assume not convertable }

     IF (ID = '') THEN
        Exit;

     P1:=Pos ('<',ID);
     P2:=Pos ('@',ID);
     P3:=Pos ('>',ID);

     IF (P1 > 0) AND (P2 > P1) AND (P3 > P2) AND
        (Copy (ID,P1,9) <> '<NOMSGID_') { must not be gated back }
     THEN
        TestMessageID2MsgID:=TRUE; { give it a try }
END;


{ ------------------------------------------------------------------- }
{ Callback for MsgsForEach (Header_U). If this sees a References:     }
{ line, it extracts each reference from it, and sets LookForContinu.. }
{ ..ation to TRUE.  The next run will check to see if the next line   }
{ is a continuation of the References: line.                          }

VAR TR_InReference  : BOOLEAN;      { Partway through a ref.? }
    TR_LastRef      : STRING;       { Last valid ref.         }
    TR_PrevRefPart  : STRING;
    TR_PrevRefHadCR : BOOLEAN;

FUNCTION TransReferences_Process (VAR OrigRegel : STRING) : BOOLEAN; FAR;

VAR P1,P2 : INTEGER;
    Line  : STRING;

BEGIN
     TransReferences_Process:=FALSE;        { do not abort }

     Line:=OrigRegel;

     { check for continuation line }
     IF TR_InReference AND TR_PrevRefHadCR AND (NOT (Line[1] IN [' ',#9])) THEN
        TR_InReference:=FALSE;

     { If we are in a reference, ASSUME this is a references line }
     IF CaselessStartMatch (Line,'References: ') THEN
     BEGIN
          Delete (Line,1,12);
          TR_InReference:=TRUE;
     END;

     IF TR_InReference THEN
     BEGIN
          IF (Line[Length (Line)] = #13) THEN
          BEGIN
               Delete (Line,Length (Line),1);
               TR_PrevRefHadCR:=TRUE;
          END ELSE
              TR_PrevRefHadCR:=FALSE;

          Line:=DeleteFrontAndBackSpaces (Line);

          WHILE (Line <> '') DO
          BEGIN
               { each message ID is enclosed between < and > }

               IF (TR_PrevRefPart <> '') THEN
               BEGIN
                    { assume "<" is in PrevRefPart }
                    P2:=Pos ('>',Line);

                    IF (P2 = 0) THEN
                    BEGIN
                         { not valid; abort here }
                         TR_PrevRefPart:='';
                         Exit; { ## EXIT ## }
                    END;

                    TR_LastRef:=TR_PrevRefPart+Copy (Line,1,P2);
                    Delete (Line,1,P2);
               END ELSE
               BEGIN
                    P1:=Pos ('<',Line);
                    P2:=Pos ('>',Line);

                    IF (P1 = 0) OR (P2 <= P1) THEN
                    BEGIN
                         { not a complete Reference part anymore }
                         { save this part and wait for continuation line }
                         TR_PrevRefPart:=Line;
                         Exit; { ## EXIT ## }
                    END;

                    TR_LastRef:=Copy (Line,P1,P2-P1+1);
                    Delete (Line,1,P2); { delete garbage as well }
               END;
          END; { while }
     END;
END;


{--------------------------------------------------------------------------}
{ Trans_GetLastReference                                                   }
{                                                                          }
{ Runs through the References: line, and retrieves the LAST reference      }
{ on the line.                                                             }
{                                                                          }
FUNCTION Trans_GetLastReference : STRING;
BEGIN
     TR_InReference:=FALSE;
     TR_PrevRefPart:='';
     TR_PrevRefHadCR:=FALSE;
     TR_LastRef:='';

     MsgsForEach (Msg.HeaderTop_U, TransReferences_Process);

     Trans_GetLastReference:=TR_LastRef;
END;


{--------------------------------------------------------------------------}
{ MessageID2MsgID                                                          }
{                                                                          }
{ Deze routine vertaalt de inhoud van een Message-ID header (en andere) in }
{ de inhoud voor een MSGID of REPLY etc.                                   }
{                                                                          }
{ Deze routine zal nog wel geleerd moeten worden om onnodige informatie te }
{ strippen. Voorlopig wordt gewoon de eerste <*@*> combinatie genomen.     }
{                                                                          }
FUNCTION MessageID2MsgID (Debug : CHAR; MessageID : STRING) : STRING;

VAR P1,P2,P3 : BYTE;
    Res      : STRING;
    Lp       : BYTE;
    Digit    : CHAR;
    Getal    : BYTE;

BEGIN
     {LogMessage (liDebug,'MessageID2MsgID: Debug='+Debug+', ID="'+MessageID+'"');}

     P1:=Pos ('<',MessageID);
     P2:=Pos ('@',MessageID);
     P3:=Pos ('>',MessageID);

     IF (P1 > 0) AND (P2 > P1) AND (P3 > P2) THEN
     BEGIN
          { strip het stuk dat we gaan bekijken }
          MessageID:=Copy (MessageID,P1,P3-P1+1);
          P2:=Pos ('@',MessageID);

          {LogMessage ('MID: "'+MessageID+'"');}

          { support gating back old WaterGate gated MSGID's }
          IF (Copy (MessageID,1,7) = '<wgcid$') AND (Copy (MessageID,P2+1,Length (Config.Domains[1])) = Config.Domains[1]) THEN
          BEGIN
               { een door ons gecodeerde MSGID: decoderen met die hap! }
               MessageID:=Copy (MessageID,8,P2-8);
               {LogMessage ('wgcid: "'+MessageID+'"');}

               Res:='';
               FOR Lp:=1 TO Length (MessageID) DO
               BEGIN
                    IF (MessageID[Lp] = '$') THEN
                    BEGIN
                         CASE MessageID[Lp+1] OF
                              'g' :
                                  BEGIN
                                       Res:=Res+':';
                                       Inc (Lp);
                                  END;

                              'h' :
                                  BEGIN
                                       Res:=Res+'/';
                                       Inc (Lp);
                                  END;

                              'i' :
                                  BEGIN
                                       Res:=Res+'.';
                                       Inc (Lp);
                                  END;

                              'j' :
                                  BEGIN
                                       Res:=Res+' ';
                                       Inc (Lp);
                                  END;

                              'k' :
                                  BEGIN
                                       Res:=Res+'@';
                                       Inc (Lp);
                                  END;

                              ELSE BEGIN
                                   Res:=Res+Char (Byte (HexString2Long (Copy (MessageID,Lp+1,2))));
                                   Inc (Lp,2);
                              END;
                         END; { case }

                    END ELSE
                        Res:=Res+MessageID[Lp];
               END;

               MessageID2MsgID:=Res;
               Exit;                    { ## EXIT ## }
          END;

          { Gatebau }
          IF (Copy (MessageID,1,9) = '<NOMSGID_') THEN
          BEGIN
               LogMessage (liGeneral,'Message ID '+MessageID+' should not show up here!');
               MessageID2MsgID:='';
               Exit;
          END;

          { the examples show '<MSGID-' as well, might be an error }
          { in MSGID.DOC though...                                 }
          IF (Copy (MessageID,1,7) = '<MSGID_') THEN
          BEGIN
               { remove domain }
               Res:=Copy (MessageID,1,Pos ('@',MessageID)-1);
               Delete (Res,1,7); { <MSGID_ }

               { convert all underscores back to spaces }
               { do this before the =5F's are converted to _'s }
               REPEAT
                     Lp:=Pos ('_',Res);
                     IF (Lp > 0) THEN
                        Res[Lp]:=' ';
               UNTIL (Lp = 0);

               { convert the rest: MIME to plain }
               Lp:=1;
               REPEAT
                     IF (Res[Lp] = '=') THEN
                     BEGIN
                          Digit:=UpCase (Res[Lp+1]);

                          IF (Digit IN ['0'..'9']) THEN
                             Getal:=Ord (Digit)-Ord ('0')
                          ELSE
                              IF (Digit IN ['A'..'F']) THEN
                                 Getal:=Ord (Digit)-Ord ('A')+10;

                          Getal:=Getal SHL 4;

                          Digit:=UpCase (Res[Lp+2]);

                          IF (Digit IN ['0'..'9']) THEN
                             Getal:=Getal OR (Ord (Digit)-Ord ('0'))
                          ELSE
                              IF (Digit IN ['A'..'F']) THEN
                                 Getal:=Getal OR (Ord (Digit)-Ord ('A')+10);

                          { opslaan als 8-bit data }
                          Res[Lp]:=Char (Getal);
                          Delete (Res,Lp+1,2);
                     END;

                     Inc (Lp);

               UNTIL (Lp >= Length (Res)-1);

               { RAWI 000302: a gatebau Message-ID should already contain }
               { the 8-digit hex code. Avoid adding a second one. Do not  }
               { handle case when it is missing.                          }
               {MessageID2MsgID:=Res+' *GATEBAU*';}
               MessageID2MsgID:=Res;
               Exit;                    { ## EXIT ## }
          END;

          { niet een door ons geformatteerd Message-ID       }
          { we kunnen nu of een _gewoon_ FTN MSGID aanmaken, }
          { of dit Message-ID in de MSGID stoppen.           }

          { RWI 960505: dit geeft zware problemen... met sommige tossers }
          {             ja, dus is het nu een optie, zoals alles hier..  }

          IF (Config.GateMsgId = gmInclude) THEN
          BEGIN
               Res:={GateBau: not anymore'wgmid$'+}MessageID;
               IF (Pos (' ',Res) > 0) OR (Pos ('"',Res) > 0) THEN
                  Res:='"'+Res+'"';

               {## note sure whether the CRC32 has to be calculated over }
               {   the string including the double quotes or not.        }
               Res:=Res+' *GATEBAU*'
          END ELSE
              Res:='*FTN*'; { Not }

          MessageID2MsgID:=Res;
          Exit;                   { ## EXIT ## }
     END;

     {
     Res:='?';
     IF Debug = 'M' THEN Res:='Message-ID';
     IF Debug = 'I' THEN Res:='In-Reply-To';
     IF Debug = 'R' THEN Res:='References';
     LogMessage ('Cannot UF invalid '+Res+': "'+MessageID+'"');}

     { terug vallen op "normale" message ID }
     MessageID2MsgID:='*FTN*';
END;


{==========================================================================}
{                       SUBJECT TRANSLATION                                }
{==========================================================================}


{--------------------------------------------------------------------------}
{ FtnSubj_RemovePaths                                                      }
{                                                                          }
{ This routine is called from TranslateNetmail2Mail to clean the subjecgt  }
{ from the paths to the files. It is only called when the netmail has      }
{ the file attach flag.                                                    }
{                                                                          }
FUNCTION FtnSubj_RemovePaths (Subj : STRING; FABit : BYTE) : STRING;

VAR Name,
    NewSubj : STRING;

BEGIN
     IF (FABit = 0) THEN
     BEGIN
          { no file attach bit set, return original subject }
          FtnSubj_RemovePaths:=Subj;
          Exit;
     END;

     Subj:=DeleteFrontAndBackSpaces (Subj);
     WHILE (Pos ('  ',Subj) > 0) DO
           Delete (Subj,Pos ('  ',Subj),1);

     NewSubj:='';
     WHILE (Subj <> '') DO
     BEGIN
          IF (Pos (' ',Subj) > 0) THEN
          BEGIN
               Name:=Copy (Subj,1,Pos (' ',Subj)-1);
               Delete (Subj,1,Pos (' ',Subj));
          END ELSE
          BEGIN
               Name:=Subj;
               Subj:='';
          END;

          { split the path and filename parts }
          WHILE (Pos ('\',Name) > 0) DO
                Delete (Name,1,Pos ('\',Name));

          IF (Name <> '') THEN
          BEGIN
               IF (NewSubj <> '') THEN
                  NewSubj:=NewSubj+' ';

               NewSubj:=NewSubj+Name;
          END;
     END; { while }

     FtnSubj_RemovePaths:=NewSubj;
END;


{--------------------------------------------------------------------------}
{ Rfc2FtnSubject                                                           }
{                                                                          }
{ Deze routine vervormt het UseNet subject in een die in de Fido Subj line }
{ past.                                                                    }
{                                                                          }
FUNCTION Rfc2FtnSubject (Subj : STRING) : STRING;

VAR P : BYTE;

BEGIN
     Delete (Subj,1,Pos (': ',Subj)+1);

     Subj:=MimeHeaderToFtn (Subj);

     P:=Pos ('(Was',Subj);
     IF (P = 0) THEN
        P:=Pos ('(was',Subj);

     IF (P > 0) THEN
        Subj:=Copy (Subj,1,P-1);

     IF (Subj <> '') AND (Subj[Length (Subj)] = #13) THEN
        Delete (Subj,Length (Subj),1);

     Rfc2FtnSubject:=Copy (Subj,1,MaxLenSubj_F);
END;


{==========================================================================}
{                       ADDRESS TRANSLATION                                }
{==========================================================================}


{--------------------------------------------------------------------------}
{ BuildFidonetInternetAdres                                                }
{                                                                          }
{ Maakt een internet adres van een gegeven fido adres.                     }
{ 2:512/17.6 ->  p6.f17.n512.z2                                            }
{                                                                          }
{ RWI 960512: "p0" wordt nu toegevoegd als de gateway aka een point bevat. }
{                                                                          }
FUNCTION BuildFidonetInternetAdres (Source : FidoAddrType; AddPunt : STRING) : STRING;

VAR Adres : STRING;

BEGIN
     Adres:='';

     IF (NOT Config.PackedAddresses) THEN
     BEGIN
          WITH Source DO
          BEGIN
               { RWI 960512: gateway aka controle op point toegevoegd }
               IF (Point <> 0) OR (Config.NodeNrs[Config.GatewayAKA].Point <> 0) THEN
                  Adres:='p'+Word2String (Point)+'.';

               Adres:=Adres+'f'+Word2String (Node)+
                           '.n'+Word2String (Net)+
                           '.z'+Word2String (Zone);
          END;
     END ELSE
         WITH Source DO
         BEGIN
              { RWI 960331: nu in p.f.n.z formaat ipv z.n.f.p formaat! }
              { RWi 970126: weer veranderd om p.f.n.z te krijgen.. }

              Adres:='';

              IF (Zone <> Config.NodeNrs[Config.GatewayAKA].Zone) THEN
                 Adres:='.z'+Word2String (Zone)+Adres;

              IF (Net <> Config.NodeNrs[Config.GatewayAKA].Net) THEN
                 Adres:='.n'+Word2String (Net)+Adres;

              IF (Node <> Config.NodeNrs[Config.GatewayAKA].Node) THEN
                 Adres:='.f'+Word2String (Node)+Adres;

              { het maakt niet uit of de gateway nu wel of niet een     }
              { point nummer heeft. Deze moet altijd in het adres omdat }
              { bij de terugvertaling het gateway aka point nummer op   }
              { nul wordt geforceerd.                                   }

              { RWI 960512: gateway aka controle op point toegevoegd }
              IF (Point <> 0) OR (Config.NodeNrs[Config.GatewayAKA].Point <> 0) THEN
                 Adres:='.p'+Word2String (Point)+Adres;

              Delete (Adres,1,1); { verwijder de voorste punt }

         END; { with }

     { merk op dat dit adres leeg kan zijn als SmallAddresses aan staat }
     { en het adres in de mapping hetzelfde is als een van onze systeem }
     { AKA's.                                                           }

     { RWI 950312: hier is de fix }
     IF (Adres <> '') THEN
        { RWI 950316: AddPunt stond ervoor... :-((( }
        Adres:=Adres+AddPunt; { niet als ie leeg is }

     BuildFidonetInternetAdres:=Adres;
END;


{--------------------------------------------------------------------------}
{ CleanFidoName                                                            }
{                                                                          }
{ Deze routine veranderd spaties in de naam naar underscores, en           }
{ verwijdert illegale highascii uit de naam. Dit kan problemen bij het     }
{ terugzetten van de originele naam geven, maar dat probleem is voor de    }
{ *(&(*& *( Fido programma's die dit soort dingen toestaan.                }
{                                                                          }
FUNCTION CleanFidoName (Invoer : STRING; DoUnderScore : BOOLEAN) : STRING;

VAR Teller : BYTE;

BEGIN
     Invoer:=DeleteBackSpaces (Invoer);

     FOR Teller:=1 TO Length (Invoer) DO
     BEGIN
          CASE Invoer[Teller] OF
               { vervang spaties door underscores }
               ' ' :
                   IF DoUnderScore THEN
                      Invoer[Teller]:=Config.NameSeparator;

               { Verwijder grappen als 'Tom Jones (Weird Tom)' }
               { Uit de fido naam string.                      }
               '(' :
                   BEGIN
                        Delete (Invoer,Teller,255);
                        Break;
                   END;

               { Verwijder alle High Ascii uit de regel }
               #127..#255 :
                   IF (NOT Config.Allow8Bit) THEN
                      Invoer[Teller]:=CnstTekens[Ord (Invoer[Teller])];
          END; { case }
     END; { for }

     CleanFidoName:=Invoer;
END;


{--------------------------------------------------------------------------}
{ Trans_FullName_Rfc2Ftn (WashFidoName)                                    }
{                                                                          }
{ Deze routine loop een naam af op underscores en vervangt deze door       }
{ spaties, om tegelijkertijd de letters volgend op de spaties te vervangen }
{ door hoofdletters.                                                       }
{                                                                          }
{ martijn_dijksterhuis ---> Martijn Dijksterhuis                           }
{                                                                          }
{ RWI 281094: Tegenwoordig hebben een variabel vertaalteken, maar die werd }
{             hier nog niet gebruikt. Hier werd nog van de underscore uit- }
{             gegaan, tewijl dat tegenwoordig ook een minteken of punt kan }
{             zijn. Verbeterd.                                             }
{                                                                          }
{ RWI 950910: Als er een < aan het begin van de naam staat, dan wordt die  }
{             nu verwijderd. Dit komt eigenlijk omdat Usenet2FidoUserName  }
{             de constructie "From: <ramon@wsd.wline.se>" niet goed aan    }
{             kan en "<ramon" als full name eruit haalt. Dat lossen we     }
{             hier dus maar op (vies he?).                                 }
{                                                                          }
FUNCTION Trans_FullName_Rfc2Ftn (RfcName : STRING) : STRING;

VAR Lp,A : BYTE;

BEGIN
     { RWI 950910 }
     IF (RfcName[1] = '<') THEN
        Delete (RfcName,1,1);

     { RAWI 970619 }
     IF (RfcName[1] = '"') THEN
        Delete (RfcName,1,1);

     REPEAT
           A:=Pos (Config.NameSeparator,RfcName);

           IF (A > 0) THEN
              RfcName[A]:=' ';

     UNTIL (A = 0);

     IF (Config.TransChar2 <> ' ') THEN
        REPEAT
              A:=Pos (Config.TransChar2,RfcName);

              IF (A > 0) THEN
                 RfcName[A]:=' ';

        UNTIL (A = 0);

     Trans_FullName_Rfc2Ftn:=RfcName; { tussen resultaat }

     { alle alle letters volgend op een spatie nu klein zijn, zet ze dan }
     { dan allemaal om in een hoofdletter. Al gecapitaliseerde namen     }
     { blijven dus in tact (Ramon van der Winkel)                        }

     { bevat de naam een hoofdletter? }
     FOR Lp:=1 TO Length (RfcName) DO
         IF (RfcName[Lp] IN ['A'..'Z']) THEN
            Exit;

     { alles lowercase, dan letters na een spatie omzetten in hoofdletter }
     FOR Lp:=1 TO Length (RfcName)-1 DO
         IF (RfcName[Lp] = ' ') THEN
            RfcName[Lp+1]:=UpCase (RfcName[Lp+1]);

     { begin letter ook }
     RfcName[1]:=UpCase (RfcName[1]);

     Trans_FullName_Rfc2Ftn:=RfcName;
END;


{--------------------------------------------------------------------------}
{ Trans_RfcHeader2FullName (Usenet2FidoUserName)                           }
{                                                                          }
{ Deze routine haalt uit de From: kludge van een Usenet bericht de user    }
{ naam en geeft deze terug. Er zijn twee mogelijkheden:                    }
{                                                                          }
{ From: ramon@wlink.nl (Ramon van der Winkel)    --> Ramon van der Winkel  }
{ From: <ramon@wsd.wlink.nl> (Ramon vd Winkel)   --> Ramon vd Winkel       }
{ From: <Martijn Dijksterhuis> martijn@wlink.nl  --> Martijn Dijksterhuis  }
{ From: A B (123) C D (456) <ramon@wsd>          --> A B                   }
{ From: martijn_dijksterhuis@wlink.nl            --> Martijn Dijksterhuis  }
{ From: "Ramon van der Winkel (ECS)" <ramon@..>  --> Ramon van der Winkel  }
{ From: "User.Name@domain"@other.domain          --> User Name             }
{ From: =?iso-8859?...?=                         --> MIME decoded name     }
{ From: dw@somewhere.com (diane white)           --> Diane White           }
{                                                                          }
{## add support for To: adres1@nl,adres2@se,adres3@jp (return first)       }
{                                                                          }
{ Nog op te lossen: Door de vertaling van de ' en ` naar " wordt er soms   }
{                   verkeerd vertaald waardoor de tekst What's in a name   }
{                   in de From: regel komt te staan als What"s in a name.  }
{                                                                          }
{FUNCTION Usenet2FidoUserName (LenName : Integer; VAR Invoer : UseNetUserNameString) : STRING;}
FUNCTION Trans_RfcHeader2FullName (HeaderLen : BYTE; Header : STRING) : STRING;

VAR P    : BYTE;
    Name : STRING;

    PROCEDURE CleanName;
    BEGIN
         { vertaling ' en ` naar " zodat we algemene routine kunnen houden }
         { RWI 960113 niet meer nodig...
         WHILE (Pos ('''',Name) > 0) DO
               Name[Pos ('''',Name)]:='"';

         WHILE (Pos ('`',Name) > 0) DO
               Name[Pos ('`',Name)]:='"';
         }

         { vieze quotes om de naam vandaan halen }
         IF (Name[1] IN ['"','''','`']) AND
            (Name[Length (Name)] IN ['"','''','`']) THEN
         BEGIN
              Delete (Name,1,1);
              Delete (Name,Length (Name),1);
         END;

         { check for MIME encoded name }
         Name:=MimeHeaderToFTN (Name);

         IF (Copy (Name,1,2) <> '=?') THEN
         BEGIN
              { RvdW 16-05-93: job omschrijving weghalen, achter een - teken }
              IF (Pos ('-',Name) > 0) THEN
                 Name:=Copy (Name,1,Pos ('-',Name)-1);
         END;

         IF (Pos ('(',Name) > 0) THEN
            Name:=Copy (Name,1,Pos ('(',Name)-1);

         IF (Pos (',',Name) > 0) THEN
            Name:=Copy (Name,1,Pos (',',Name)-1);

         { bijnamen die tussen " en " staan weghalen }
         IF (Pos ('"',Name) > 0) AND
            (Pos ('"',Copy (Name,Pos ('"',Name)+1,255)) > 0)
         THEN
             Name:=Copy (Name,1,Pos ('"',Name)-1)+
                   Copy (Name,Pos ('"',Name)+Pos ('"',Copy (Name,Pos ('"',Name)+1,255))+1,255);

         { dubbele spaties verwijderen, komen voor na verwijderen "tekst" }
         WHILE (Pos ('  ',Name) > 0) DO
               Delete (Name,Pos ('  ',Name),1);

         { "Ramon van der Winkel (ECS)" <ramon@...> wordt door de haakjes  }
         { omgezet in "Ramon van der Winkel en dat is natuurlijk niet mooi }
         { net als de parsing van de haakjes niet mooi is.. Weg met die "  }

         { enkele aanhalingsteken aan het begin verwijderen }
         IF (Name[1] = '"') AND (Pos ('"',Copy (Name,2,255)) = 0) THEN
            Delete (Name,1,1);

         Name:=DeleteFrontAndBackSpaces (Name); { nodig om lege namen te detecteren }
    END;

{ Trans_RfcHeader2FullName }

BEGIN
     IF (HeaderLen = 0) THEN
     BEGIN
          Header:='X: '+Header;
          HeaderLen:=2;
     END;

     Header:=MimeHeaderToFtn (Header);

     { Naam zit tussen ( ) ? }
     IF (Pos ('(',Header) > 0) THEN
     BEGIN
          P:=Pos ('(',Header)+1;

          IF (Pos ('<',Header) > P) THEN
          BEGIN
               { situatie From: A B (123) C D (456) <ramon@wsd> }
               Name:=Copy (Header,1,P-1);
               Delete (Name,1,HeaderLen);  { RWI 960212: toegevoegd. "From:" bleef staan }
               Name:=DeleteFrontAndBackSpaces (Name);
          END ELSE
              { normal }
              Name:=Copy (Header,P,Pos (')',Header)-P);

          CleanName;
          IF (Name <> '') THEN  { RWI 281094: voorkoming haakjes met niets ertussen }
          BEGIN
               Trans_RfcHeader2FullName:=Trans_NiceCaseName (Name);
               Exit;
          END;
     END;

     { Als er < > haken in de tekst zitten, staat de }
     { naam direct achter de From: regel             }
     IF (Pos ('<',Header) > 0) THEN
     BEGIN
          P:=Pos (':',Header)+2;
          Name:=Copy (Header,P,Pos ('<',Header)-1-P);

          CleanName;
          IF (Name <> '') THEN { RWI 281094: voorkoming haakjes met niets ertussen }
          BEGIN
               Trans_RfcHeader2FullName:=Trans_NiceCaseName (Name);
               Exit;
          END;
     END;

     IF (Pos ('@',Header) > 0) THEN
     BEGIN
          Name:=DeleteFrontSpaces (Copy (Header,HeaderLen+2,Pos ('@',Header)-(HeaderLen+2)));
          CleanName;
          Trans_RfcHeader2FullName:=Trans_FullName_Rfc2Ftn (Name);
     END ELSE
         { RWI 950202: in plaats van "Unknown" wordt nu gewoon het adres }
         {             genomen. Dit kan soms resulteren in dikke bang-   }
         {             paths, maar we zullen het eens testen.            }
         Trans_RfcHeader2FullName:=Copy (Header,HeaderLen+2,255); { geen translaties }
END;


{--------------------------------------------------------------------------}
{ Trans_UserPlusAka2Email                                                  }
{                                                                          }
{ A cut-down version of the big one below to just translate a FTN username }
{ and aka to a RFC address.                                                }
{                                                                          }
FUNCTION Trans_UserPlusAka2Email (FromUser : STRING; FromAKA : FidoAddrType) : STRING;

VAR KnownUser       : BOOLEAN;
    UserRecNr       : UserBaseRecordNrType;
    UserRec         : UserBaseRecord;
    HulpAddr        : FidoAddrType;
    EMail           : STRING;
    CleanedFidoName : STRING;

BEGIN
     { RWI 960113: opzoeken van bekende users naar boven gehaald zodat }
     {             de organization line gebruikt kan worden, zelfs als }
     {             er een MAP-UUCP statement gedefinieerd is.          }
     KnownUser:=FindUserBaseRecordByFidoAddress (FromAKA,UserRecNr);

     { RWI 960313: point worden nu bij hun node gemapped }
     IF (NOT KnownUser) AND (FromAKA.Point <> 0) THEN
     BEGIN
          HulpAddr:=FromAKA;
          HulpAddr.Point:=0;  { find the boss }
          KnownUser:=FindUserBaseRecordByFidoAddress (HulpAddr,UserRecNr);
     END;

     IF KnownUser THEN
        ReadUserBaseRecord (UserRecNr,UserRec);

     { kijk of er een override gedefinieerd is }
     IF (NOT GetFIDO_2_UUCP (FromUser,FromAKA,EMail)) THEN
     BEGIN
          IF FidoOurAdres (FromAKA) THEN
             EMail:=Config.Domains[1]
          ELSE
              IF FidoOurPoint (FromAKA) THEN
              BEGIN
                   EMail:=Config.Domains[1];

                   IF (FromAKA.Point <> 0) THEN         { 4D point }
                      EMail:='p'+Word2String (FromAKA.Point)+'.'+EMail;
              END ELSE
              BEGIN
                   IF KnownUser AND (UserRec.Domains[1] <> '') THEN
                   BEGIN
                        { dit adres staat in onze userbase en daar staat ook }
                        { een domain adres dat gebruikt moet worden. Dit     }
                        { domain adres moet ook in het bang path, tenzij het }
                        { ons systeem domain adres is (some people...).      }

                        EMail:=UserRec.Domains[1];

                        { RWI 960313: Als dit een point van deze node is, dan }
                        { moeten we het point adres even toevoegen. Wel even  }
                        { controleren of deze user zelf geen point is, want   }
                        { anders plakken we altijd de p#. eraan...            }
                        IF (FromAKA.Point <> 0) AND (UserRec.Address.Point = 0) THEN
                           EMail:='p'+Word2String (FromAKA.Point)+'.'+EMail;
                   END ELSE
                       EMail:=BuildFidonetInternetAdres (FromAKA,'.')+Config.Domains[1];
              END;
     END;

     CleanedFidoName:=CleanFidoName (FromUser,TRUE);

     IF (Pos ('@',EMail) = 0) THEN
     BEGIN
          IF (Pos ('@',CleanedFidoName) = 0) AND (Pos ('!',CleanedFidoName) = 0) THEN
             EMail:=CleanedFidoName+'@'+EMail
          ELSE
              EMail:=CleanedFidoName;
     END;

     IF Config.LogTranslationFU THEN
     BEGIN
          LogMessage (liTrivial,'Translation: "'+FromUser+'"%'+Fido2Str (FromAKA));
          LogExtraMessage ('      into: '+EMail);
     END;

     Trans_UserPlusAka2Email:=EMail;
END;


{---------------------------------------------------------------------------}
{ TranslateFromAddressFU                                                    }
{                                                                           }
{ Deze routine doet de vertaling van het From address voor Fido naar Usenet }
{ en wordt gebruikt bij de vertaling van Netmail naar Mail, maar ook voor   }
{ Echomail naar News.                                                       }
{                                                                           }
{ Wat er gebruikt wordt:                                                    }
{                                                                           }
{ Msg.FromAddr_F: De AKA van de zender van het bericht.                     }
{ Msg.FromUser_F: De full name van de zender van het bericht                }
{                                                                           }
{ Wat er terug gegeven wordt:                                               }
{                                                                           }
{ Organization: voor in de Organization: header line. Kan de system regel   }
{               of de user-defined regel zijn.                              }
{                                                                           }
{ BangFrom: Het hele adres in bangpath vorm. Dit moet als laatste deel van  }
{           het bang path gebruikt worden. Ons systeem domain adres zit er  }
{           al bij in.                                                      }
{                                                                           }
{ MailFromAdres: Het complete e-mail adres met een @ erin, na de vertaling. }
{                                                                           }
{ RWI 960313: points van een in de userbase gedefinieerde node worden nu    }
{             automatisch op het daar gedefinieerde domain adres gemapped.  }
{                                                                           }
{ RWI 960313: points van ons systeem worden nu op ons eerste systeem        }
{             domain adres gedefinieerd.                                    }
{                                                                           }
PROCEDURE TranslateFromAddressFU (VAR Organization,BangFrom,MailFromAdres : STRING);

VAR KnownUser       : BOOLEAN;
    UserRecNr       : UserBaseRecordNrType;
    UserRec         : UserBaseRecord;
    HulpAddr        : FidoAddrType;
    BangFromUser    : STRING;
    BangFromDomain  : STRING;
    CleanedFidoName : STRING;

BEGIN
     Organization:='';
     BangFromUser:='';   { nog geen naam voor in het bang path }
     BangFromDomain:=''; { nog geen domain voor in het bang path }

     { RWI 960113: opzoeken van bekende users naar boven gehaald zodat }
     {             de organization line gebruikt kan worden, zelfs als }
     {             er een MAP-UUCP statement gedefinieerd is.          }
     KnownUser:=FindUserBaseRecordByFidoAddress (Msg.FromAddr_F,UserRecNr);

     { RWI 960313: point worden nu bij hun node gemapped }
     IF (NOT KnownUser) AND (Msg.FromAddr_F.Point <> 0) THEN
     BEGIN
          HulpAddr:=Msg.FromAddr_F;
          HulpAddr.Point:=0;  { find the node }
          KnownUser:=FindUserBaseRecordByFidoAddress (HulpAddr,UserRecNr);
     END;

     IF KnownUser THEN
        ReadUserBaseRecord (UserRecNr,UserRec);

     { kijk of er een override gedefinieerd is }
     IF (NOT GetFIDO_2_UUCP (Msg.FromUser_F,Msg.FromAddr_F,MailFromAdres)) THEN
     BEGIN
          { RWI 950605: dit stuk overnieuw gedaan. De oude code ging er }
          {             vanuit dat er niet zoiets als "small addresses" }
          {             bestaat en hield daarom rekening met points.    }
          {             Dit doen we nu niet meer, dus zijn de volgende  }
          {             situaties overgebleven:                         }
          {                                                             }
          { 1) We zijn het zelf, geen subsysteem van ons.               }
          {                                                             }
          { 2) User is niet bekend.                                     }
          {    User is wel bekend, maar record heeft geen domain adres. }
          {                                                             }
          { 3) User is bekend en heeft een domain adres in zijn record. }
          {                                                             }
          { Situatie 1): Neem ons eerste systeem domain adres. Deze     }
          {              hoeft niet in het bang path komen te staan.    }
          {                                                             }
          { Situatie 2): Volledig of gedeeltelijk (small addresses) AKA }
          {              in het adres stoppen en ons eerste systeem     }
          {              domain adres toevoegen. Het eerste deel moet   }
          {              in het bangpath komen te staan.                }
          {                                                             }
          { Situatie 3): Het domain adres uit het record nemen. Deze    }
          {              moet ook in het bang path komen te staan.      }

          { Situatie 1 }
          IF FidoOurAdres (Msg.FromAddr_F) THEN
             { van ons eigen adres -> neem ons eigen domain }
             MailFromAdres:=Config.Domains[1]
          ELSE
              { BangFromDomain blijft leeg, want adres komt ons adres }
              { twee keer in het bang path. Nou ja, oke, er is een    }
              { controle. Dit helpt en versnelt.                      }
              IF FidoOurPoint (Msg.FromAddr_F) THEN
              BEGIN
                   MailFromAdres:=Config.Domains[1];

                   { we gaan er maar even van uit dat het adres al  }
                   { omgezet is naar een niet-3D adres, want dit    }
                   { gaat nu mis bij post van eens van onze systeem }
                   { AKA's zelf..                                   }
                   { Eigenlijk moeten die 3D addressen toch niet in }
                   { een netmail...                                 }
                   (*
                   IF (Msg.FromAddr_F.Point = 0) THEN
                      { 3D point }
                      MailFromAdres:='p'+Word2String (Msg.FromAddr_F.Node)+'.'+MailFromAdres
                   ELSE
                   *)

                   IF (Msg.FromAddr_F.Point <> 0) THEN
                   BEGIN
                        { 4D point }
                        MailFromAdres:='p'+Word2String (Msg.FromAddr_F.Point)+'.'+MailFromAdres;
                   END;

                   { nu moet dit domain adres WEL in het bang!path }
                   BangFromDomain:=MailFromAdres;
              END ELSE
              BEGIN
                   { Situatie 2/3 }

                   { check if this AKA is defined in our Userbase. If so, we    }
                   { might be able to get some personal translation information }
                   { from that record.                                          }
                   { RWI 960113: hierboven al gedaan...
                   KnownUser:=FindUserBaseRecordByFidoAddress (Msg.FromAddr_F,UserRecNr);
                   IF KnownUser THEN
                      ReadUserBaseRecord (UserRecNr,UserRec);
                   }

                   { Situatie 3 }
                   IF KnownUser AND (UserRec.Domains[1] <> '') THEN
                   BEGIN
                        { dit adres staat in onze userbase en daar staat ook }
                        { een domain adres dat gebruikt moet worden. Dit     }
                        { domain adres moet ook in het bang path, tenzij het }
                        { ons systeem domain adres is (some people...).      }

                        MailFromAdres:=UserRec.Domains[1];

                        { RWI 960313: Als dit een point van deze node is, dan }
                        { moeten we het point adres even toevoegen. Wel even  }
                        { controleren of deze user zelf geen point is, want   }
                        { anders plakken we altijd de p#. eraan...            }
                        IF (Msg.FromAddr_F.Point <> 0) AND (UserRec.Address.Point = 0) THEN
                           MailFromAdres:='p'+Word2String (Msg.FromAddr_F.Point)+'.'+MailFromAdres;

                        BangFromDomain:=MailFromAdres;

                        { we kunnen de custom origanization line uit het user }
                        { record gebruiken, of die nou leeg is of niet.       }

                        { RWI 950627: UserRec was UserData. Veroorzaakte }
                        {             verkeerde organization lines...    }
                        Organization:=UserRec.Organization;
                   END ELSE
                   { Situatie 2 }
                   BEGIN
                        { we kennen de node niet of het is een user van ons }
                        { zonder domain adres in het record. Nu moeten we   }
                        { zelf wat verzinnen en het hele of gedeeltelijke   }
                        { AKA moet in het adres, zodat erop gereageerd kan  }
                        { worden. Dit moet ook in het bang path.            }

                        MailFromAdres:=BuildFidonetInternetAdres (Msg.FromAddr_F,'.')+Config.Domains[1];
                        BangFromDomain:=MailFromAdres;
                   END;
              END; { situatie 2/3 }
     END ELSE
     BEGIN
          { mapping is gelukt, dus stond daar misschien wel een username in }

          { RWI 950317: bewaar nu ook het domain deel van het adres }
          {             voor in het bang path.                      }

          UsenetSplit (MailFromAdres,BangFromDomain,BangFromUser);

          { RWI 950605: dit ging mis als er geen usernaam in de mapping     }
          {             stond. Dat gebeurd bij MAP-UUCP mappings voor een   }
          {             domain naar een AKA. UsenetSplit gaat er dan vanuit }
          {             dat het de hele string de usernaam is ("newsfix"),  }
          {             terwijl dat het domain adres is. Hier corrigeren we }
          {             dat hardhandig.                                     }
          IF (BangFromDomain = '') THEN
          BEGIN
               BangFromDomain:=BangFromUser;
               BangFromUser:='';
          END;

          { RWI 960113: toegevoegd }
          IF KnownUser THEN
             Organization:=UserRec.Organization;
     END; { was een mapping }

     { nu de naam nog even erbij nemen, voor het geval die niet is }
     { Deze nemen we uit de full name van de zender, die we netjes }
     { omzetten met underscores (of wat dan ook) erin.             }
     CleanedFidoName:=CleanFidoName (Msg.FromUser_F,TRUE);

     { RWI 291094: Bugfix. "From wsd!Ramon_van_der_Winkel <datum>" werd er }
     {             in de header gezet, maar mijn adres was via een map     }
     {             ingesteld op ramon@wsd.wlink.nl, dat wil ik er dan ook  }
     {             wel boven hebben. Er stond dus '!'+CleanedFidoName en   }
     {             dat is nu veranderd in BangFromUser die onderweg        }
     {             bepaald wordt.                                          }

     IF (BangFromUser = '') THEN
        BangFromUser:=CleanedFidoName;

     { RWI 950317: bang pad bevat nu ook het BangFromDomain als die bekend is }

     { RWI 950529: Check toegevoegd om te controleren of BangFromDomain }
     {             en BangFrom gelijk waren. Dit komt voor bij lokaal   }
     {             gegenereerde netmailtjes waar een mapping aanwezig   }
     {             was voor een bepaald persoon, met daarin een domain  }
     {             gelijk aan het systeem domain. Dit gaat nu dus mis   }
     {             als er een sub-domain is met dezelfde naam, maar dat }
     {             mag geloof ik niet eens. Ff denken... gelijken UUCP- }
     {             namen mogen niet en gelijke (complete) domain namen  }
     {             is al helemaal onmogelijk.                           }

     { zet nu het bangpath adres op dat terug gegeven gaat worden }
     BangFrom:=NewsDomain;
     {BangFrom:=UseGetSystemFromName; { ons eerste domain of onze UUCPname }

     IF (BangFromDomain <> '') AND (BangFromDomain <> BangFrom) THEN
        BangFrom:=BangFrom+'!'+BangFromDomain;

     BangFrom:=BangFrom+'!'+BangFromUser;

     { als het MailFromAdres door de mapping al een usernaam gekregen }
     { heeft, dan hoeft de username er niet nog eens voor. Zeker niet }
     { deze vieze vertaalde naam die we hier hebben. Dus controleer   }
     { eerst even.                                                    }
     { RAWI 970507: Als de CleanedFidoName al een @ or ! bevat, dan   }
     { moet er ook geen domain meer aan toegevoegd worden..           }
     IF (Pos ('@',MailFromAdres) = 0) THEN
     BEGIN
          IF (Pos ('@',CleanedFidoName) = 0) AND (Pos ('!',CleanedFidoName) = 0) THEN
             MailFromAdres:=CleanedFidoName+'@'+MailFromAdres
          ELSE
              MailFromAdres:=CleanedFidoName;
     END;

     { use the system organization by default }
     IF (Organization = '') THEN
        Organization:=Config.Organization;

     { nu is het MailFromAdres compleet en kunnen we loggen }
     IF Config.LogTranslationFU THEN
     BEGIN
          LogMessage (liTrivial,'Translation: "'+Msg.FromUser_F+'"%'+Fido2Str (Msg.FromAddr_F));
          LogExtraMessage ('      into: '+MailFromAdres);
     END;
END;


{--------------------------------------------------------------------------}
{ Trans_NiceCaseName                                                       }
{                                                                          }
{ This routine takes a name and puts capitals in it to make it look good,  }
{ but avoids changing already capitalised names.                           }
{                                                                          }
{ Examples: diane white     --> Diane White                                }
{           DIANE WHITE     --> Diane White                                }
{           Ramon vd Winkel --> Ramon vd Winkel                            }
{                                                                          }
FUNCTION Trans_NiceCaseName (Name : STRING) : STRING;

VAR Lp : BYTE;

BEGIN
     { check for all upper case }
     IF (Name = UpCaseString (Name)) THEN
        Name:=LoCaseString (Name);

     { does the name contain a single upper case letter? }
     FOR Lp:=1 TO Length (Name) DO
         IF (Name[Lp] IN ['A'..'Z']) THEN
         BEGIN
              Trans_NiceCaseName:=Name; { as-is }
              Exit; { ## EXIT ## }
         END;

     { everything must be lower case }
     { change chars following a space to a capital }
     FOR Lp:=1 TO Length (Name)-1 DO
         IF (Name[Lp] = ' ') THEN
            Name[Lp+1]:=UpCase (Name[Lp+1]);

     { first char to upper as well }
     Name[1]:=UpCase (Name[1]);

     Trans_NiceCaseName:=Name;
END;


{--------------------------------------------------------------------------}
{ FtnizeUserName                                                           }
{ (WashFidoName)                                                           }
{                                                                          }
{ Deze routine loop een naam af op underscores en vervangt deze door       }
{ spaties, om tegelijkertijd de letters volgend op de spaties te vervangen }
{ door hoofdletters.                                                       }
{                                                                          }
{ martijn_dijksterhuis ---> Martijn Dijksterhuis                           }
{                                                                          }
{ RWI 281094: Tegenwoordig hebben een variabel vertaalteken, maar die werd }
{             hier nog niet gebruikt. Hier werd nog van de underscore uit- }
{             gegaan, tewijl dat tegenwoordig ook een minteken of punt kan }
{             zijn. Verbeterd.                                             }
{                                                                          }
{ RWI 950910: Als er een < aan het begin van de naam staat, dan wordt die  }
{             nu verwijderd. Dit komt eigenlijk omdat Usenet2FidoUserName  }
{             de constructie "From: <ramon@wsd.wline.se>" niet goed aan    }
{             kan en "<ramon" als full name eruit haalt. Dat lossen we     }
{             hier dus maar op (vies he?).                                 }
{                                                                          }
FUNCTION FtnizeUserName (UserName : STRING) : STRING;

VAR Lp,A : BYTE;

BEGIN
     { RWI 950910 }
     IF (UserName[1] = '<') THEN
        Delete (UserName,1,1);

     { RAWI 970619 }
     IF (UserName[1] = '"') THEN
        Delete (UserName,1,1);

     REPEAT
           A:=Pos (Config.NameSeparator,UserName);

           IF (A > 0) THEN
              UserName[A]:=' ';

     UNTIL (A = 0);

     IF (Config.TransChar2 <> ' ') THEN
        REPEAT
              A:=Pos (Config.TransChar2,UserName);

              IF (A > 0) THEN
                 UserName[A]:=' ';

        UNTIL (A = 0);

     FtnizeUserName:=Trans_NiceCaseName (UserName);
END;


{--------------------------------------------------------------------------}
{ AddReplyAlsoKludges                                                      }
{                                                                          }
{ Deze routine checkt de mail/news header voor andere reply adressen die   }
{ niet overeen komen met die al in REPLYADDR zit en voegt daarvoor de      }
{ REPLYALSO kludges toe.                                                   }
{                                                                          }
PROCEDURE AddReplyAlsoKludges (ReplyAddr : STRING);

VAR Done1,
    Done2,
    Tmp   : STRING;

BEGIN
     Done1:='';
     Done2:='';

     IF (Msg.ReplyTo_U <> '') THEN
     BEGIN
          Tmp:=UseGetAddress (Copy (Msg.ReplyTo_U,Length ('Reply-To: ')+1,255));
          IF (Tmp <> ReplyAddr) THEN
          BEGIN
               MsgsAddLineTo (Header_F,#1+'REPLYALSO '+Tmp);
               Done1:=Tmp;
          END;
     END;

     IF (Msg.Sender_U <> '') THEN
     BEGIN
          Tmp:=UseGetAddress (Copy (Msg.Sender_U,Length ('Sender: ')+1,255));
          IF (Tmp <> ReplyAddr) AND (Tmp <> Done1) THEN
          BEGIN
               MsgsAddLineTo (Header_F,#1+'REPLYALSO '+Tmp);
               Done2:=Tmp;
          END;
     END;

     IF (Msg.FromUser_U <> '') THEN
     BEGIN
          Tmp:=UseGetAddress (Copy (Msg.FromUser_U,Length ('From: ')+1,255));
          IF (Tmp <> ReplyAddr) AND (Tmp <> Done1) AND (Tmp <> Done2) THEN
             MsgsAddLineTo (Header_F,#1+'REPLYALSO '+Tmp);
     END;
END;


{==========================================================================}
{                       COPY HEADER FUNCTIONS                              }
{==========================================================================}


{--------------------------------------------------------------------------}
{ CopyHeadersFromFidoBody                                                  }
{                                                                          }
{ Deze routine bekijkt de body van het bericht en haalt daaruit e-mail     }
{ header regels en plaatst deze in de header van de e-mail. Alleen niet-   }
{ systeem headers worden toegestaan.                                       }
{ Het zoeken gaat door tot een lege regel uit de body verwijderd is, of    }
{ een niet-legale header regel gevonden is. Legale header regels beginnen  }
{ met een hoofdletter, hebben geen spatie in zich en eindigen met een      }
{ dubbele punt en een spatie, gevolgd door text.                           }
{                                                                          }
{ RWI 960310: Subject, Newsgroups and Organization are now buffered in     }
{             the Msg record and added when this routine returns.          }
{                                                                          }
{ RAWI 970917: This routine also takes care of removing the extra To: Cc:  }
{              and Bcc: headers - without logging or complaining.          }
{                                                                          }
PROCEDURE CopyHeadersFromFidoBody;

VAR Regel   : STRING;
    P       : BYTE;
    HadCR   : BOOLEAN;
    UpRegel : STRING[30];

LABEL Done,
      Silent;

BEGIN
{$IFNDEF WtrTest}
     IF (NOT Config.CopyHeaders_FU) THEN
        Exit;

     WHILE TRUE DO
     BEGIN
          { get the first line }
          Regel:=MsgsGetFirstRowInBody;

          IF (Regel = '') THEN
             Exit; { no more body lines }

          { remove the #13 at the end of the line }
          P:=Pos (#13,Regel);
          IF (P > 0) THEN
          BEGIN
               Regel:=Copy (Regel,1,P-1);
               HadCR:=TRUE;
          END ELSE
              HadCR:=FALSE;

         { onderzoek deze regel en kijk of het een mogelijke header is }

         { lege regel betekend het einde van de headers die we kopieren }
         IF (Regel = '') THEN
         BEGIN
              { we always remove the first empty line }
              MsgsDeleteFirstRowFromBody;
              Continue; { try again }
         END;

         { een header moet uit minimaal twee tekens bestaan,   }
         { gevolgd door een dubbele punt, een spatie, minimaal }
         { een teken tekst en een enter. Dus 2+2+1+1 = 6.      }
         { Vergeet de enter even.                              }
         IF (Length (Regel) < 5) THEN
            Exit;

         { moet beginnen met een hoofdletter }
         IF NOT (Regel[1] IN ['A'..'Z']) THEN
            Exit;

         { kijk of de header afgesloten is met een ": " }
         P:=Pos (': ',Regel);

         { header moet minimaal 2 letters lang zijn, dus de : }
         { kan niet vOOr de derde positie beginnen.           }
         IF (P < 3) THEN
            Exit;

         { en als die ": " er staat, dan mag er geen spatie }
         { vOOr die dubbele punt voorkomen.                 }
         IF (Pos (' ',Regel) < P) THEN
            Exit;

         { RWI 951117: haal extra spaties achter de dubbele punt weg }
         WHILE (Pos (':  '{two spaces!},Regel) > 0) DO
               Delete (Regel,Pos (':  ',Regel)+1,1);

         { sommige systeem headers staan we niet toe }
         P:=Pos (': ',Regel);
         UpRegel:=UpCaseString (Copy (Regel,1,P-1));

         IF (UpRegel = 'MESSAGE-ID') OR
            (UpRegel = 'FROM') OR
            (UpRegel = 'PATH') OR
            (UpRegel = 'DATE') OR
            (UpRegel = 'CC') OR
            (UpRegel = 'BCC') THEN
         BEGIN
              { deze header niet toestaan. Eventueel loggen }
              { maar wel gewoon doorgaan met andere headers }
              IF Config.LogIllegalHeaders THEN
                 LogMessage (liGeneral,'Not copying system header: "'+Regel+'"');
         END ELSE
         BEGIN
              { legale header gevonden. Overnemen die hap en daarna }
              { verwijderen uit de body.                            }

              { convert FTN set to RFC and 8-bit to 7-bit/qp etc. }
              Regel:=Copy (Regel,1,P+1)+CharSets_MimeEncodeHeader (Msg.Chrs_F,Copy (Regel,P+2,255));

              IF (UpRegel = 'ORGANIZATION') THEN
              BEGIN
                   Msg.Organization_U:=Regel+#13;
                   GOTO Done;
              END;

              IF (UpRegel = 'SUBJECT') THEN
              BEGIN
                   Msg.Subj_U:=Regel+#13;
                   GOTO Done;
              END;

              IF (UpRegel = 'NEWSGROUPS') THEN
              BEGIN
                   IF (NOT HadCR) THEN
                   BEGIN
                        LogMessage (liGeneral,'Correcting: "'+Regel+'"');

                        { not a #13 at the end, so remove everything }
                        { until and including comma.                 }
                        REPEAT
                              Delete (Regel,Length (Regel),1);
                        UNTIL (Regel[Length (Regel)] = ',') OR (Regel = '');

                        Delete (Regel,Length (Regel),1);

                        LogExtraMessage ('-> "'+Regel+'"');
                   END;

                   Msg.Newsgroups_U:=Regel+#13;
                   GOTO Done;
              END;

              { skip the lines with addresses }
              IF (UpRegel = 'TO') OR (UpRegel = 'GW-CC') OR (UpRegel = 'GW-BCC') THEN
                 GOTO Silent;

              MsgsAddLineTo (Header_U,Regel);

        Done:
              IF Config.LogCopyHeaders THEN
                 LogMessage (liGeneral,'Copying header: "'+Regel+'"');

        Silent:
         END;

         { verwijder this copied / interpreted line }
         MsgsDeleteFirstRowFromBody;

     END; { while }
{$ENDIF (!WtrStat)}
END;


{--------------------------------------------------------------------------}
{ Trans_FindAndCopyHeader                                                  }
{                                                                          }
{ This routine searches all the headers of a RFC message for the given     }
{ header. When found, the header is added to the Msg.CopiedHeadersTop_F    }
{ block. When a header was found and added, TRUE is returned.              }
{                                                                          }
FUNCTION Trans_FindAndCopyHeader (HeaderName : STRING; CopyHow : CopyHeaderHowType) : BOOLEAN;

VAR RegelPtr    : EenRegelRecordPtr;
    RegelLength : BYTE;
    Regel       : STRING; { RWI 950506: zo lang mogelijk, want hier moet de hele header line in! }

BEGIN
     IF (Msg.Ready_U = News) AND
        (Config.OrganizationInOrigin = 2{override copy header}) AND
        (HeaderName = 'ORGANIZATION: ')
     THEN
         Exit;

     RegelPtr:=Msg.HeaderTop_U^.FirstRegelRecordPtr;
     MsgsNewSeek (RegelPtr);

     {## could change this routine to a MsgsForEach construction }
     WHILE (RegelPtr <> NIL) DO
     BEGIN
          CASE RegelPtr^.Waar OF
               wMem :
                   BEGIN
                        Regel:=RegelPtr^.RegelPtr^;
                        RegelPtr:=RegelPtr^.NextRegelRecordPtr;
                        MsgsNewSeek (RegelPtr);
                   END;

               wSwapped :
                   BEGIN
                        { lees de lengte van de regel in }
                        BlockRead (SwapFile,RegelLength,1);

                        { einde van het swapped blok? }
                        IF (RegelLength = 0) THEN
                        BEGIN
                             { ja, ga naar de volgende regel }
                             RegelPtr:=RegelPtr^.NextRegelRecordPtr;
                             MsgsNewSeek (RegelPtr);
                             Continue; { met de while }
                        END;

                        { lees de regel zelf in }
                        BlockRead (SwapFile,Regel[1],RegelLength);
                        Regel[0]:=Char (RegelLength);
                   END; { swap }
          END; { case }

          IF CaselessStartMatch (Regel,HeaderName) THEN
          BEGIN
               IF (CopyHow = chKludge) THEN
                  Regel:=#1+Regel;

               { RWI 951117 corrigeer lelijke headers }
               { Subject:       dit is een subject }
               WHILE (Pos (':  ',Regel) > 0) DO
                     Delete (Regel,Pos (':  ',Regel)+1,1);

               { als er nog geen enter achter stond (bij een afgebroken }
               { header), voeg die dan toe.                             }
               IF (Regel[Length (Regel)] <> #13) THEN
                  Regel:=Regel+#13;

               { als de string te lang was om deze #13 toe te voegen, }
               { vervang dan gewoon het laatste teken van de regel.   }
               IF (Regel[Length (Regel)] <> #13) THEN
                  Regel[Length (Regel)]:=#13;

               MsgsAddLineToNoEOL (CopiedHeaders_F,Regel);
          END;
     END; { while }

     Trans_FindAndCopyHeader:=FALSE; { not found }
END;


{--------------------------------------------------------------------------}
{ Trans_CopyHeaders                                                        }
{                                                                          }
{ This routine searches for and copies header lines to the                 }
{ Msg.CopiedHeadersTop_F block. This block is added to the output message  }
{ after the HeaderTop_F and before the first body part. The headers can be }
{ copied as both kludges and plain text, hence the kludges must go first   }
{ and the text after that. If any text line was added, an empty line must  }
{ be inserted to separate the copied headers from the body text.           }
{                                                                          }
PROCEDURE Trans_CopyHeaders;

VAR Lp     : 1..MaxCopyHeaders;
    TAdded : BOOLEAN;

BEGIN
     IF (Msg.HeaderTop_U = NIL) THEN
        Exit;

     FOR Lp:=1 TO MaxCopyHeaders DO
         IF (Config.CopyHeaderHow[Lp] = chKludge) AND (Config.CopyHeaderNames[Lp] <> '') THEN
            Trans_FindAndCopyHeader (Config.CopyHeaderNames[Lp]+' ',Config.CopyHeaderHow[Lp]);

     TAdded:=FALSE;
     FOR Lp:=1 TO MaxCopyHeaders DO
         IF (Config.CopyHeaderHow[Lp] = chText) AND (Config.CopyHeaderNames[Lp] <> '') THEN
            TAdded:=TAdded OR Trans_FindAndCopyHeader (Config.CopyHeaderNames[Lp]+' ',Config.CopyHeaderHow[Lp]);

     IF TAdded THEN
        MsgsAddLineTo (CopiedHeaders_F,'');
END;


{==========================================================================}
{                       OTHER SUPPORT FUNCTIONS                            }
{==========================================================================}


{--------------------------------------------------------------------------}
{ Trans_FirstBodyLineIsEmpty                                               }
{                                                                          }
FUNCTION Trans_FirstBodyLineIsEmpty : BOOLEAN;

VAR Regel : STRING[5];

BEGIN
     Regel:=MsgsGetFirstRowInBody;
     Trans_FirstBodyLineIsEmpty:=(Regel = '') OR (Regel = #13);
END;



{--------------------------------------------------------------------------}
{ Trans_AddNewsgroupsHeader                                                }
{                                                                          }
{ This routine adds a Newsgroups: header with all the current newsgroup    }
{ names. This is used by Echo2News and Mail2News translation functions.    }
{                                                                          }
PROCEDURE Trans_AddNewsgroupsHeader;

VAR NewsLine : STRING;
    Lp       : BYTE;
    AreaRec  : AreaBaseRecord;

BEGIN
     { --- build Newsgroups header }

     Msg.NewsGroups_U:='';
     NewsLine:='Newsgroups: ';

     FOR Lp:=1 TO MAX_AREA_CROSS_POSTS DO
         IF (Msg.AreaRecNrs[Lp] <> NILRecordNr) THEN
         BEGIN
              ReadAreaBaseRecord (Msg.AreaRecNrs[Lp],AreaRec);

              IF (Length (NewsLine)+Length (AreaRec.AreaName_U) > 250) THEN
              BEGIN
                   { empty NewsLine first }
                   IF (Msg.NewsGroups_U = '') THEN
                      Msg.NewsGroups_U:=NewsLine; { no #13 at end }

                   MsgsAddLineToNoEOL (Header_U,NewsLine);
                   Newsline:=' ';
              END;

              NewsLine:=NewsLine+LoCaseString (AreaRec.AreaName_U)+',';
         END;

     { replace the last comma with a #13 }
     NewsLine[Length (NewsLine)]:=#13;

     IF (Msg.NewsGroups_U = '') THEN
        Msg.NewsGroups_U:=NewsLine;

     MsgsAddLineToNoEOL (Header_U,NewsLine);
END;


{==========================================================================}
{                        NETMAIL -> MAIL                                   }
{==========================================================================}


{--------------------------------------------------------------------------}
{ AddFilesToBody                                                           }
{                                                                          }
{ Deze routine loopt de opgegeven regel en breekt deze op de spaties. Het  }
{ resultaat wordt daarna als filename geinterpreteerd en UU-encoded in de  }
{ body van het bericht opgenomen.                                          }
{                                                                          }
PROCEDURE AddFilesToBody (Filenames : STRING);

VAR Name : STRING;

BEGIN
     Filenames:=DeleteFrontAndBackSpaces (Filenames);
     WHILE (Pos ('  ',Filenames) > 0) DO
           Delete (Filenames,Pos ('  ',Filenames),1);

     WHILE (Filenames <> '') DO
     BEGIN
          IF (Pos (' ',Filenames) > 0) THEN
          BEGIN
               Name:=Copy (Filenames,1,Pos (' ',Filenames)-1);
               Delete (Filenames,1,Pos (' ',Filenames));
          END ELSE
          BEGIN
               Name:=Filenames;
               Filenames:='';
          END;

          { RAWI 990208: skip the [teamwg] mailing list indicators }
          IF (Name[1] = '[') AND (Name[Length (Name)] = ']') THEN
             Continue;

          { RAWI 980927: attached files are now always encoded into the body }
          XX_FileToBody (Name,FALSE,FALSE,TRUE{force encode});
     END; { while }

     MsgsAddLineTo (Body,''); { lege regel na 'end' nodig }
END;


{--------------------------------------------------------------------------}
{ Translate_Netmail2Mail                                                   }
{                                                                          }
{ Deze routine kan een netmail bericht zo veranderen dat het als een       }
{ legitiem Mail bericht over de wereld zal verzonden worden.               }
{                                                                          }
PROCEDURE Translate_Netmail2Mail;

VAR Organization,
    MailFromAdres,
    BangFrom       : STRING;
    FindPtr        : DestRecordPtr;
    AddrList       : STRING;

BEGIN
     IF Config.LogDebug THEN
        LogMessage (liTrivial,'Translating Netmail -> Mail');

     { --- translate all fields }

     Msg.Date_U:='Date: '+Ftn2RfcDate (Msg.Date_F);
     Msg.MessageID_U:='Message-ID: '+MsgID2MessageID (Msg.MsgID_F);
     Msg.Subj_U:='Subject: '+CharSets_MimeEncodeHeader (Msg.Chrs_F,FtnSubj_RemovePaths (Msg.Subj_F,Msg.Attr_F AND MSGFILE));

     IF (Msg.ReplyID_F <> '') THEN
        Msg.InReplyTo_U:='In-Reply-To: '+MsgID2MessageID (Msg.ReplyID_F)
     ELSE
         Msg.InReplyTo_U:='';

     TranslateFromAddressFU (Organization,BangFrom,MailFromAdres);

     {Msg.FromUser_U:=BuildFromHeader (MailFromAdres,CleanFidoName (Msg.FromUser_F,FALSE));}
     Msg.FromUser_U:=RFC_BuildFromHeader (MailFromAdres,Msg.FromUser_F);

     IF (Organization <> '') THEN
        Msg.Organization_U:='Organization: '+Organization;

     { --- build a new header }

     MsgsReleaseLines (Msg.HeaderTop_U) ;

     { now added by UUCP mail outbound handling code
     MsgsAddLineTo (Header_U,'From '+BangFrom+' '+UsenetArpanetDate);
     }

     MsgsAddLineTo (Header_U,'Received: by '+UseGetSystemFromName+' ('+ProgramShortName+' '+MainRevisionNr+')');
     MsgsAddLineTo (Header_U,'          via FTN; '+UsenetArpanetDate);
    {MsgsAddLineTo (Header_U,'          for '+MailToAdres);}

     MsgsAddLineTo (Header_U,Msg.Date_U);
     MsgsAddLineTo (Header_U,Msg.MessageID_U);

     IF (Msg.InReplyTo_U <> '') THEN
        MsgsAddLineTo (Header_U,Msg.InReplyTo_U);

     MsgsAddLineTo (Header_U,Msg.FromUser_U);

     {## stop doing this in mailing list distribution mode }
     {   since the header will be replaced anyway. }

     { add To: header }
     AddrList:='To: ';
     FindPtr:=Msg.FirstDest;
     WHILE (FindPtr <> NIL) DO
     BEGIN
          { include FTN users as well?? }
          IF (FindPtr^.Status IN [destRFC,destRFCUser]) AND
             (FindPtr^.ToType IN [destNotSure,destTo]) THEN
          BEGIN
               IF (Length (AddrList)+Length (FindPtr^.To_U) > 200) THEN
               BEGIN
                    MsgsAddLineTo (Header_U,AddrList);
                    AddrList:=#9; { continuation header }
               END;

               AddrList:=AddrList+FindPtr^.To_U+',';
          END;

          FindPtr:=FindPtr^.NextDest;
     END;

     IF (AddrList <> #9) AND (AddrList <> 'To: ') THEN
     BEGIN
          IF (AddrList[Length (AddrList)] = ',') THEN
             Delete (AddrList,Length (AddrList),1);

          MsgsAddLineTo (Header_U,AddrList);
     END;

     {## stop doing this in mailing list distribution mode }
     {   since the header will be replaced anyway. }

     { add Cc: header }
     AddrList:='Cc: ';
     FindPtr:=Msg.FirstDest;
     WHILE (FindPtr <> NIL) DO
     BEGIN
          { include FTN users as well?? }
          IF (FindPtr^.Status IN [destRFC,destRFCUser]) AND
             (FindPtr^.ToType = destCC) THEN
          BEGIN
               IF (Length (AddrList)+Length (FindPtr^.To_U) > 200) THEN
               BEGIN
                    MsgsAddLineTo (Header_U,AddrList);
                    AddrList:=#9; { continuation header }
               END;

               AddrList:=AddrList+FindPtr^.To_U+',';
          END;

          FindPtr:=FindPtr^.NextDest;
     END;

     IF (AddrList <> #9) AND (AddrList <> 'Cc: ') THEN
     BEGIN
          IF (AddrList[Length (AddrList)] = ',') THEN
             Delete (AddrList,Length (AddrList),1);

             MsgsAddLineTo (Header_U,AddrList);
     END;

     { override the Newsgroups, Subject and Organization headers }
     CopyHeadersFromFidoBody;

     { Subj_U, Organization_U and Newsgroups_U must be added now }

     MsgsAddLineTo (Header_U,Msg.Subj_U);

     IF (Msg.Organization_U <> '') THEN
        MsgsAddLineTo (Header_U,Msg.Organization_U);

     IF (Msg.Newsgroups_U <> '') THEN
     BEGIN
          { RWI 950217: controle op #13, dan via NoEOL toevoegen }
          {## wanneer worden deze geinterpreteerd?}
          IF (Msg.Newsgroups_U[Length (Msg.Newsgroups_U)] = #13) THEN
             MsgsAddLineToNoEOL (Header_U,Msg.Newsgroups_U)
          ELSE
              MsgsAddLineTo (Header_U,Msg.Newsgroups_U);
     END;

     { kijk of er een file attach bij het bericht zit. Zoja, dan moeten }
     { we alle files in de subject regel overnemen in het mail bericht. }
     IF ((Msg.Attr_F AND MSGFILE) > 0) THEN
     BEGIN
          { UU-encoded file in het bericht opnemen }
          {$IFNDEF WtrTest}
          AddFilesToBody (Msg.Subj_F);
          {$ENDIF}
          Msg.Attr_F:=Msg.Attr_F XOR MSGFILE;  { wis de f/a vlag }
     END;

     { must be set before ListTrans_ReplaceRfcHeader is called! }
     Msg.Ready_F:=NotReady;
     Msg.Ready_U:=Mail;

     IF Msg.IsListDist THEN
     BEGIN
          { special translation Netmail -> Mail for mailing list distribution }
          ListTrans_ReplaceRfcHeader;
          { has added From:, To:, Sender: and maybe a Reply-To: }
     END ELSE
         AddSignature;

     FtnBodyToMime;

     { MIME headers toevoegen }
     AddStandardMimeHeaders;

     Msg.WasGated:=TRUE;
END;


{==========================================================================}
{                        MAIL -> NETMAIL                                   }
{==========================================================================}


{--------------------------------------------------------------------------}
{ CompleteMsgId                                                            }
{                                                                          }
{ This routine is called with the output of MessageID2MsgId to complete it }
{ with the parts not filled in yet. The following cases are possible:      }
{    *FTN*                                                                 }
{    wgmid$<fjdkfj>                                                        }
{    <blalba@somewhere> *GATEBAU*                                          }
{    2:200/111.15 123bf145
{ The first needs the gateway AKA filled in and both need a 8 digit hex    }
{ number at the end.                                                       }
{ This routine is used for both MSGID and REPLY kludges!!                  }
{                                                                          }
FUNCTION CompleteMsgId (MsgID : STRING; SysAka : BYTE) : STRING;
BEGIN
     IF (MsgID = '*FTN*') THEN
        MsgID:=Fido2Str (Config.NodeNrs[SysAka])+' ';

     IF (Pos ('*GATEBAU*',MsgID) > 0) THEN
        MsgID:=Copy (MsgID,1,Pos ('*GATEBAU*',MsgID)-1);

     IF (MsgID[Length (MsgID)] <> ' ') THEN
        MsgID:=MsgID+' ';

     CompleteMsgId:=MsgID+GetFidoPktName;
END;


{--------------------------------------------------------------------------}
{ Translate_Mail2Netmail                                                   }
{                                                                          }
{ Verstouw een mailtje dusdanig dat het als een legitiem netmail bericht   }
{ zijn reis over de wereld kan voort zetten.                               }
{                                                                          }
PROCEDURE Translate_Mail2Netmail;

VAR MatchAddr    : FidoAddrType;
    Tmp          : STRING;
    SenderInBody : BOOLEAN;
    Lp           : BYTE;
    TFirst       : BOOLEAN;
    InSetNr,
    OutSetNr     : CharSetNr;

BEGIN
     (*
     { Controleer eerst of het bericht wel verzonden kan worden }
     { Doe dit door HIER al te kijken of het bericht            }
     { a) Voor ons                                              }
     { b) Voor een van onze points                              }
     { c) Voor een routable node                                }
     { bestemd is.                                              }

     { Eerst MatchAdres, die is later nog nodig! }
     { RWI 960113: hoezo? een search for MatchAdres levert niets op! }
     IF (NOT FidoMapPoint (FidoToAddr,WashFidoName (ToUserUsenet))) THEN
        IF FidoOurAdres (FidoToAddr) THEN
           MatchAddr:=Config.NodeNrs[Config.GatewayAKA]
        ELSE
            IF (FindRoute (FidoToAddr,MatchAddr) = 0) THEN
            BEGIN
                 LogMessage ('Bouncing mail for '+Fido2Str (FidoToAddr));
                 UsenetBounceMail ('Reason: Unable to transport message to '+Fido2Str (FidoToAddr));
                 TranslateMail2Netmail:=FALSE;
                 Exit;
            END;
     *)

     IF Config.LogDebug THEN
        LogMessage (liTrivial,'Translating Mail -> Netmail');

     MsgsReleaseLines (Msg.HeaderTop_F);
     MsgsReleaseLines (Msg.CopiedHeadersTop_F);
     MsgsReleaseLines (Msg.FooterTop_F);

     { standard header fields }
     Msg.Subj_F:=Rfc2FtnSubject (Msg.Subj_U);

     Msg.Date_F:=Rfc2FtnDate (Msg.Date_U);

     { set up reply address plus kludges }
     Tmp:=UsenetReplyAdres;

     { Full name }
     SenderInBody:=FALSE;

     IF Config.HeaderFullname THEN
        Msg.FromUser_F:=Copy (Trans_RfcHeader2FullName (Length ('FROM:'),Msg.FromUser_U),1,MaxLenUserName_F)
     ELSE BEGIN
          { het e-mail adres moet in de fido From: regel }
          Msg.FromUser_F:=Tmp;

          IF (Length (Tmp) >= MaxLenUserName_F) THEN
          BEGIN
               { ff wat aanpassen zodat het duidelijk afgebroken is }
               Msg.FromUser_F:=Copy (Msg.FromUser_F,1,MaxLenUserName_F-3)+'...';

               SenderInBody:=TRUE; { volgt nog, na de BuildNetmail }
          END;
     END;

     IF (Msg.FromUser_F = '') THEN
        Msg.FromUser_F:='Unknown';

     Msg.FromAddr_F:=Config.NodeNrs[Config.GatewayAKA];

     Msg.Attr_F:=MSGPRIVATE OR MSGLOCAL;
     {## ExtAttr_F ?}
     {## Cost_F ?}

     { --- MSGID en REPLY kludges }
     Msg.MsgID_F:=CompleteMsgId (MessageID2MsgID ('M',Msg.MessageID_U),Config.GatewayAKA);
     MsgsAddLineTo (Header_F,#1'MSGID: '+Msg.MsgID_F);

     IF TestMessageID2MsgID (Msg.InReplyTo_U) THEN
     BEGIN
          Msg.ReplyID_F:=CompleteMsgId (MessageID2MsgID ('I',Msg.InReplyTo_U),Config.GatewayAKA);
          MsgsAddLineTo (Header_F,#1'REPLY: '+Msg.ReplyID_F);
     END;

     { Vul de header aan met extra fancy fido kludges (ala fredmail) }
     { Dit werkt echt! Tof, TimEd reageerd erop...                   }
     IF (Config.ReplyFSC35) THEN
     BEGIN
          { ^Reply-To kludge }
          { RWI 950612: The node number used came from AreaData.OriginAKA }
          { RWI 960118: dubbelepunt achter kludge naam verwijderd! }
          MsgsAddLineTo (Header_F,#1+'REPLYTO '+Fido2Str (Config.NodeNrs[Config.GatewayAKA])+' '+Config.GatewayUser);

          { ^ReplyAddr Kludge }
          { RWI 960118: dubbelepunt achter kludge naam verwijderd }
          MsgsAddLineTo (Header_F,#1+'REPLYADDR '+Tmp);

          { RWI 960304: REPLYALSO kludges toegevoegd }
          AddReplyAlsoKludges (Tmp);
     END;

     MsgsAddLineTo (Header_F,BuildTIDKludge);

     IF SenderInBody THEN
     BEGIN
          { dan moet ie ook nog eens duidelijk in de body }
          { zodat we er handmatig op kunnen replyen }
          MsgsAddFirstLineTo (Body,'');
          MsgsAddFirstLineTo (Body,'Message sender: '+Tmp);
          MsgsAddFirstLineTo (Body,'');

          { we houden er geen rekening mee hier dat het ook }
          { nog eens geconfigureerd kan zijn om de From:    }
          { header in de body te kopieren. In dat geval zal }
          { ook niet nog eens geselecteerd zijn om het      }
          { volledige adres in de From: regel te zetten...  }
     END;

     {MsgsAddLineTo (Footer_F,FidoTear);}

     Tmp:=CharSets_MakeDecision_RFC2FTN (FALSE{=mail},InSetNr,OutSetNr);

     {## set Chrs_F ?}
     MsgsAddLineTo (Header_F,BuildCHRSKludge (Tmp));

     { RAWI 970617: do MIME -> FTN translation first so single-part }
     {              encoding headers are copied before CopyHeaders  }
     {              adds more lines to the body (always at the top) }

     { Note: This might fail when we start to translate MIME headers }

     { vertaal de body van MIME formaat naar FTN formaat }
     { maar behoudt nog wel de encoded files             }
     IF Msg.IsMime THEN
        MimeBodyToFtn (InSetNr,OutSetNr)
     ELSE
         RfcBodyToFtn (InSetNr,OutSetNr);

     Trans_CopyHeaders;

     Msg.Ready_F:=Netmail;
     Msg.Ready_U:=NotReady;
     Msg.WasGated:=TRUE;
END;


{==========================================================================}
{                        NEWS -> ECHOMAIL                                  }
{==========================================================================}


{--------------------------------------------------------------------------}
{ Translate_News2Echomail                                                  }
{                                                                          }
{ This routine translates the internal message from news to echomail       }
{ format. This is a generic translation, independent of the area the       }
{ message will be distributed in. Completion of the message takes place    }
{ during delivery. MSGID, REPLY, REPLYTO etc. addresses are filled in at   }
{ that point.                                                              }
{ Msg.AreaRecNrs[] contains a list of all the areas this message can be    }
{ posted in. News-only areas have not been removed! This information can   }
{ be used to decide which character set to use for translating.            }
{                                                                          }
PROCEDURE Translate_News2Echomail;

VAR ReplyAddress,
    FromAddress  : STRING;

    Tmp      : STRING;
    FromF    : STRING;
    TFirst   : BOOLEAN;
    Lp       : BYTE;
    InSetNr,
    OutSetNr : CharSetNr;

BEGIN
     IF Config.LogDebug THEN
        LogMessage (liTrivial,'Translating News -> Echomail');

     MsgsReleaseLines (Msg.HeaderTop_F);
     MsgsReleaseLines (Msg.CopiedHeadersTop_F);
     MsgsReleaseLines (Msg.FooterTop_F);

     { Voeg een unieke ^MSGID flag toe }

     { note: cross-posted messages get their MSGID replaced on  }
     {       import in a message base or export to a .PKT file, }
     {       based on the AreaRecNr.                            }

     IF (NOT TestMessageID2MsgID (Msg.MessageID_U)) THEN
     BEGIN
          LogMessage (liFatal,'Article stopped because of Message-ID');
          LogExtraMessage (Msg.MessageID_U);
          WriteMessageToRFCBad ('News article has an invalid Message-ID',NIL);
          Msg.Ready_F:=NotReady;
          Msg.Ready_U:=Bad;
          Exit;
     END;

     { MSGID can be incomplete. This is completed by TransFix }
     MsgsAddLineTo (Header_F,#1'MSGID: '+MessageID2MsgID ('M',Msg.MessageID_U));

     { Optioneel een REPLY kludge }
     Tmp:='';
     IF TestMessageID2MsgID (Msg.InReplyTo_U) THEN
        Tmp:=MessageID2MsgID ('I',Msg.InReplyTo_U)
     ELSE BEGIN
          Tmp{abuse}:=Trans_GetLastReference;

          IF TestMessageID2MsgID (Tmp) THEN
            Tmp:=MessageID2MsgID ('R',Tmp)
          ELSE
              Tmp{revoke abuse}:='';
     END;

     { RAWI990207: no need to keep it, contains garbage anyway }
     IF (Tmp = '*FTN*') AND (Config.GateMsgId = gmNot) THEN
        Tmp:='';

     IF (Tmp <> '') THEN
        { REPLY can be incomplete. This is completed by TransFix }
        {## set Msg.Reply_F? }
        MsgsAddLineTo (Header_F,#1'REPLY: '+Tmp);

     ReplyAddress:=UsenetReplyAdres;
     FromAddress:=Msg.FromUser_U;

     Tmp:='';

     { RWI 960304: ondersteuning van geforceerd REPLYADDR bij MAP-AREA }
     {## tijdelijk even uitgeschakeld...
     IF (Msg.MapAreaReplyAddrPtr <> NIL) THEN
        Tmp:=MapAreaReplyAddrPtr^;
     }

     IF (Tmp = '') THEN
        Tmp:=ReplyAddress;

     { RWI 950524: FSC35 en From: zijn nu apart te selecteren }
     { eigenlijk is FSC35 bullshit bij echomail, maar goed... }
     { Laat maar aanwezig ivm de ListServer (echo->netmail)   }
     IF (Config.ReplyFSC35) THEN
     BEGIN
          { ^Reply-To kludge   }
          { RWI 960118: dubbelepunt achter kludge naam verwijderd! }
          MsgsAddLineTo (Header_F,#1+'REPLYTO *FTN*');
          {## #2#2 = Fido2Str (Config.NodeNrs[AreaData.OriginAKA] }

          { ^Reply-Addr Kludge }
          { RWI 960118: dubbelepunt achter kludge naam verwijderd! }
          MsgsAddLineTo (Header_F,#1+'REPLYADDR '+Tmp);

          { RWI 960118: added REPLYALSO kludge }
          { see if there is a Sender: or Reply-To: line that is  }
          { different from the above address and can be used for }
          { the REPLYALSO kludge.                                }
          AddReplyAlsoKludges (Tmp);
     END;

     { Full name }
     IF (Config.HeaderFullname) THEN
        Msg.FromUser_F:=Copy (Trans_RfcHeader2FullName (Length ('FROM:'),FromAddress),1,MaxLenUserName_F)
     ELSE BEGIN
          { het e-mail adres moet in de fido From: regel }

          { RWI 960714: netjes het e-mail adres eruit halen en dus }
          {             niet het e-mail adres _en_ (afgekapt!) de  }
          {             full-name erbij. Bah! Nu veel beter!       }

          FromF:=UseGetAddress (Copy (FromAddress,6,255));

          IF (Length (FromF) >= MaxLenUserName_F) THEN
          BEGIN
               { dan moet ie ook nog eens duidelijk in de body }
               { zodat we er handmatig op kunnen replyen }

               MsgsAddFirstLineTo (Body,'');
               MsgsAddFirstLineTo (Body,'Message sender: '+FromF);
               MsgsAddFirstLineTo (Body,'');

               { we houden er geen rekening mee hier dat het ook }
               { nog eens geconfigureerd kan zijn om de From:    }
               { header in de body te kopieren. In dat geval zal }
               { ook niet nog eens geselecteerd zijn om het      }
               { volledige adres in de From: regel te zetten...  }

               { ff wat aanpassen zodat het duidelijk afgebroken is }
               Msg.FromUser_F:=Copy (FromF,1,MaxLenUserName_F-3)+'...';
          END ELSE
              Msg.FromUser_F:=FromF;
     END;

     { Toevoegen van een ^TID lijn (!) }
     MsgsAddLineTo (Header_F,BuildTIDKludge);

     Tmp:=CharSets_MakeDecision_RFC2FTN (TRUE{=news},InSetNr,OutSetNr);

     MsgsAddLineTo (Header_F,BuildCHRSKludge (Tmp));

     { Als er meer areas in een string zitten een XPOST }
     { kludge meegeven...                               }
     { wordt automatisch gedaan tijdens export..
     IF (CrossPosted <> '') THEN
        MsgsAddLineTo (Header_F,#1'XPOST: '+CrossPosted);
     }

     Trans_CopyHeaders;

     IF (Msg.FromUser_F = '') THEN
        Msg.FromUser_F:='Unknown';

     { TO }
     IF (Config.HeaderFullname) THEN
        Msg.ToUser_F:=Copy (Trans_RfcHeader2FullName (Length ('TO:'),Msg.ToUser_U),1,MaxLenUserName_F)
     ELSE BEGIN
          { het e-mail adres moet in de fido To: regel }
          { RWI 960824: UseGetAddress ingevoegd }
          FromF{misbruik}:=UseGetAddress (Copy (Msg.ToUser_U,4,255));

          IF (Length (FromF) >= MaxLenUserName_F) THEN
             { ff wat aanpassen zodat het duidelijk afgebroken is }
             Msg.ToUser_F:=Copy (FromF,1,MaxLenUserName_F-3)+'...'
          ELSE
              Msg.ToUser_F:=FromF;
     END;

     IF Msg.IsListDist THEN
     BEGIN
          Msg.ToUser_F:='';     { force to All }
     END;

     IF (Msg.ToUser_F = '') THEN
        Msg.ToUser_F:='All';

     Msg.Subj_F:=Copy (Rfc2FtnSubject (Msg.Subj_U),1,MaxLenSubj_F);

     Msg.Date_F:=Rfc2FtnDate (Msg.Date_U);

     FidoSplit ('0',Msg.FromAddr_F); {Config.NodeNrs[AreaData.OriginAKA];}
{##} Msg.FromAddr_F.Domain:=#1#2#3; { = replace this aka with OriginAKA for area }
     Msg.Attr_F:=0;

     { Voeg Tearline + Origin lijn toe }
     MsgsAddlineTo (Footer_F,FidoTear);

     { work out whether we have to put the Organization in the }
     { Origin line or not. If so, then add it, otherwise leave }
     { it blank for the moment.                                }
     Tmp:='';
     IF (Config.OrganizationInOrigin <> 0{no}) THEN
     BEGIN
          Tmp:=DeleteFrontAndBackSpaces (Copy (Msg.Organization_U,15,255));
          Tmp:=MimeHeaderToFtn (Tmp);
          IF (Tmp <> '') THEN
             Tmp:=GetLang1 (105,Tmp);
     END;

     MsgsAddLineTo (Footer_F,' * Origin: '+Tmp+' (*FTN*)');

     { vertaal de body van MIME formaat naar FTN formaat }
     { maar behoudt nog wel de encoded files             }
     IF Msg.IsMime THEN
        MimeBodyToFtn (InSetNr,OutSetNr)
     ELSE
         RfcBodyToFtn (InSetNr,OutSetNr);

     { prepare the internal SEEN-BY and PATH administration }
     SBP_StoreEmptySeenByAndPath;

     { Omdat we nu nieuwe mailtjes exporteren moet hierover ook een }
     { CRC berekend worden.                                         }
     {DupeCheckAdd (FidoCRCMessage);}

     Msg.Ready_F:=Echomail;
     Msg.Ready_U:=NotReady;
END;


{==========================================================================}
{                        NEWS -> MAIL                                      }
{==========================================================================}


{--------------------------------------------------------------------------}
{ TransN2M_CopyHeader                                                      }
{                                                                          }
{ This routine is called for each line in the header of the news article   }
{ when translating it to mail.                                             }
{                                                                          }
FUNCTION TransN2M_CopyHeader (VAR OrigRegel : STRING) : BOOLEAN; FAR;
BEGIN
     TransN2M_CopyHeader:=FALSE; { do not abort }

     {## does not take care of continuation headers!}

     { strip News Article related headers that should not show up in Mail }

     {RAWI000730: keep these for mail2news operation
     IF CaselessStartMatch (OrigRegel,'Newsgroups:') THEN
        Exit;
     }

     IF CaselessStartMatch (OrigRegel,'Path:') THEN
        Exit;

     IF CaselessStartMatch (OrigRegel,'Lines:') THEN
        Exit;

     { keep the rest }
     MsgsAddLineToNoEOL (Header_U,OrigRegel);
END;


{--------------------------------------------------------------------------}
{ Translate_News2Mail                                                      }
{                                                                          }
{ This routine translates a RFC news article to RFC mail format.           }
{                                                                          }
PROCEDURE Translate_News2Mail;

VAR OldHeader : TopRegelRecordPtr;

BEGIN
     IF Config.LogDebug THEN
        LogMessage (liTrivial,'Translating News -> Mail');

     Msg.Ready_U:=Mail;

     IF Msg.IsListDist THEN
     BEGIN
          ListTrans_ReplaceRfcHeader;
          Exit; { ## EXIT ## }
     END;

     { remove the Path:, Newsgroups: and Lines: headers }
     OldHeader:=Msg.HeaderTop_U;
     Msg.HeaderTop_U:=NIL;

     { now added by UUCP mail outbound handling code
     MsgsAddLineTo (Header_U,'From '+Config.Domains[1]+'!not-for-mail '+UsenetArpanetDate);
     }

     MsgsForEachKill (OldHeader,TransN2M_CopyHeader);
END;


{==========================================================================}
{                        MAIL -> NEWS                                      }
{==========================================================================}


{--------------------------------------------------------------------------}
{ TransM2N_CopyHeader                                                      }
{                                                                          }
FUNCTION TransM2N_CopyHeader (VAR OrigRegel : STRING) : BOOLEAN; FAR;
BEGIN
     TransM2N_CopyHeader:=FALSE; { do not abort }

     { remove UUCP header }
     IF CaselessStartMatch (OrigRegel,'From ') THEN
        Exit;

     MsgsAddLineToNoEOL (Header_U,OrigRegel);
END;


{--------------------------------------------------------------------------}
{ Translate_Mail2News                                                      }
{                                                                          }
{ This routine translates a RFC mail message to an RFC news article.       }
{                                                                          }
PROCEDURE Translate_Mail2News;

VAR OldHeader : TopRegelRecordPtr;

BEGIN
     IF Config.LogDebug THEN
        LogMessage (liTrivial,'Translating Mail -> News');

     Msg.Ready_U:=News; { required set by ListTrans }

     IF (Msg.IsListDist) THEN
        ListTrans_ReplaceRfcHeader
     ELSE BEGIN
          {## it leaves the To: and Reply-To: lines in during mailing list distributions (mail->news)}

          { replace headers }
          OldHeader:=Msg.HeaderTop_U;
          Msg.HeaderTop_U:=NIL;

          { add Path: header }
          MsgsAddLineTo (Header_U,'Path: '+NewsDomain+'!not-for-mail');

          { add Newsgroups: header }
          Trans_AddNewsgroupsHeader;

          MsgsForEachKill (OldHeader,TransM2N_CopyHeader);
     END;

     MsgsAddLineTo (Header_U,'Lines: '+Longint2String (MsgsCalcBodyLines));
END;


{==========================================================================}
{                        ECHOMAIL -> NEWS                                  }
{==========================================================================}


{--------------------------------------------------------------------------}
{ Translate_Echomail2News                                                  }
{                                                                          }
{ This routine translate the internal message from echomail to news        }
{ format.                                                                  }
{                                                                          }
PROCEDURE Translate_Echomail2News;

VAR Organization,
    BangFrom,
    MailFromAdres : STRING;
    Lines         : LONGINT;

BEGIN
     IF Config.LogDebug THEN
        LogMessage (liTrivial,'Translating Echomail -> News');

     { there is no special code here for mailing list translation }
     { since News is just an intermediate format there.           }

     { clean the RFC header }
     MsgsReleaseLines (Msg.HeaderTop_U);

     TranslateFromAddressFU (Organization,BangFrom,MailFromAdres);

     MsgsAddLineTo (Header_U,'Path: '+BangFrom);

     { now copy the headers. Some will fill in the Subject,   }
     { Organization and Newsgroups fields in the Msg record.  }
     { Others go directly into the header. The Msg.XXX fields }
     { are thus overriding the otherwise used value.          }

     { if there was an organization line returned from          }
     { TranslateFromAddressFU then override the already present }
     { (which one?)                                             }
     IF (Organization <> '') THEN
        Msg.Organization_U:='Organization: '+Organization
     ELSE
         Msg.Organization_U:='';

     Msg.Subj_U:='Subject: '+CharSets_MimeEncodeHeader (Msg.Chrs_F,Msg.Subj_F);

     Msg.Newsgroups_U:=''; { in order to detect override }

     {Msg.FromUser_U:=BuildFromHeader (MailFromAdres,CleanFidoName (Msg.FromUser_F,FALSE));}
     Msg.FromUser_U:=RFC_BuildFromHeader (MailFromAdres,Msg.FromUser_F);
     MsgsAddLineTo (Header_U,Msg.FromUser_U);

     Msg.MessageID_U:='Message-ID: '+MsgID2MessageID (Msg.MsgID_F);

     CopyHeadersFromFidoBody;

     { Subj_U, Organization_U and Newsgroups_U must be handled now }

     IF (Msg.Newsgroups_U <> '') THEN
     BEGIN
          {## this is not valid anymore}
          { if a Newsgroups_U header was copied, then interpret it and get  }
          { all the areas we know. Forget about the rest. CopyHeaders has   }
          { already made sure a #13 is at the end, so there will be no      }
          { Header_U scan.                                                  }
          { Notice that the message is never distributed in these areas on  }
          { the FTN side. UUCP style subscribers do get a proper copy       }
          { though. If the FTN side has to get a copy, then we need to      }
          { check for this header at once when the message hits our system. }
          Address_SelectNewsgroups;
     END;

     { now build the header with either one or multiple newsgroup names }
     Trans_AddNewsgroupsHeader;

     MsgsAddLineTo (Header_U,'Message-ID: '+MsgID2MessageID (Msg.MsgID_F));

     IF (Msg.ReplyID_F <> '') THEN
        MsgsAddLineTo (Header_U,'References: '+MsgID2MessageID (Msg.ReplyID_F));

     Msg.Date_U:='Date: '+Ftn2RfcDate (Msg.Date_F);
     MsgsAddLineTo (Header_U,Msg.Date_U);

     MsgsAddLineTo (Header_U,Msg.Subj_U);

     { organization kludge, optioneel }
     IF (Msg.Organization_U <> '') THEN
        MsgsAddLineTo (Header_U,Msg.Organization_U);

     AddSignature;

     Lines:=FtnBodyToMime;

     AddStandardMimeHeaders;

     MsgsAddLineTo (Header_U,'Lines: '+Longint2String (Lines));

     Msg.Ready_F:=NotReady;
     Msg.Ready_U:=News;
END;



{==========================================================================}
{                        ECHOMAIL -> NETMAIL                               }
{==========================================================================}


{--------------------------------------------------------------------------}
{ TransE2N_CleanFooter                                                     }
{                                                                          }
FUNCTION TransE2N_CleanFooter (VAR OrigRegel : STRING) : BOOLEAN; FAR;
BEGIN
     TransE2N_CleanFooter:=FALSE; { do not abort }

     { remove Origin lines }
     IF CaselessStartMatch (OrigRegel,' * Origin') THEN
        Exit;

     { remove SEEN-BY lines }
     IF CaselessStartMatch (OrigRegel,'SEEN-BY:') THEN
        Exit;

     { remove PATH lines }
     IF CaselessStartMatch (OrigRegel,#1'PATH:') THEN
        Exit;

     MsgsAddLineToNoEOL (Footer_F,OrigRegel);
END;


{--------------------------------------------------------------------------}
{ Translate_Echomail2Netmail                                               }
{                                                                          }
{ This routine translate the internal message format from echomail to      }
{ netmail. This can be used during a mailing list distribution with both   }
{ netmail subscribers and a ListToArea for an echomail area.               }
{                                                                          }
PROCEDURE Translate_Echomail2Netmail;

VAR OldTop : TopRegelRecordPtr;

BEGIN
     IF Config.LogDebug THEN
        LogMessage (liTrivial,'Translating Echomail -> Netmail');

     { do we need to change the header? }
     { 1 - there is no AREA kludge }
     { 2 - no need to insert an INTL, FMPT or TOPT header }

     { clean the FTN footer }
     { 1 - remove SEEN-BY lines }
     { 2 - remove PATH lines }
     { 3 - remove origin line }
     { note that the tear-line is part of the body while }
     { the Origin is part of the footer.                 }

     OldTop:=Msg.FooterTop_F;
     Msg.FooterTop_F:=NIL;

     MsgsForEachKill (OldTop,TransE2N_CleanFooter);

     Msg.FromAddr_F:=Config.NodeNrs[Config.GatewayAKA];

     Msg.Attr_F:=MSGPRIVATE OR MSGLOCAL;
     {## ExtAttr_F ?}
     {## Cost_F ?}

     Msg.Ready_F:=Netmail;
     Msg.Ready_U:=NotReady;
END;


{==========================================================================}
{                        NETMAIL -> ECHOMAIL                               }
{==========================================================================}


VAR N2E_FoundOrigin,
    N2E_FoundTear: BOOLEAN;

{--------------------------------------------------------------------------}
{ TransN2E_CleanHeader                                                     }
{                                                                          }
FUNCTION TransN2E_CleanHeader (VAR OrigRegel : STRING) : BOOLEAN; FAR;
BEGIN
     TransN2E_CleanHeader:=FALSE; { do not abort }

     { remove VIA lines }
     IF CaselessStartMatch (OrigRegel,#1'VIA') THEN
        Exit;

     {## remove REPLYTO, REPLYADDR, REPLYALSO, PID?}

     MsgsAddLineToNoEOL (Header_F,OrigRegel);
END;


{--------------------------------------------------------------------------}
{ TransN2E_CleanFooter                                                     }
{                                                                          }
FUNCTION TransN2E_CleanFooter (VAR OrigRegel : STRING) : BOOLEAN; FAR;
BEGIN
     TransN2E_CleanFooter:=FALSE; { do not abort }

     { remove VIA lines }
     IF CaselessStartMatch (OrigRegel,#1'VIA') THEN
        Exit;

     IF CaselessStartMatch (OrigRegel,' * Origin:') THEN
        N2E_FoundOrigin:=TRUE;

     IF CaselessStartMatch (OrigRegel,'---') THEN
        N2E_FoundTear:=TRUE;

     MsgsAddLineToNoEOL (Footer_F,OrigRegel);
END;


{--------------------------------------------------------------------------}
{ Translate_Netmail2Echomail                                               }
{                                                                          }
{ This routine translate a FTN netmail message into a FTN echomail.        }
{                                                                          }
PROCEDURE Translate_Netmail2Echomail;

VAR OldTop : TopRegelRecordPtr;

BEGIN
     IF Config.LogDebug THEN
        LogMessage (liTrivial,'Translating Netmail -> Echomail');

     N2E_FoundOrigin:=FALSE;
     N2E_FoundTear:=FALSE;

     OldTop:=Msg.HeaderTop_F;
     Msg.HeaderTop_F:=NIL;
     MsgsForEachKill (OldTop,TransN2E_CleanHeader);

     OldTop:=Msg.FooterTop_F;
     Msg.FooterTop_F:=NIL;
     MsgsForEachKill (OldTop,TransN2E_CleanFooter);

     { add an origin line if not present already.  make sure it doesn't go }
     { before the tear line.                                               }
     IF (NOT N2E_FoundOrigin) THEN
        IF (N2E_FoundTear) THEN        { Don't put before tear line ... }
           MsgsAddLineTo (Footer_F, ' * Origin:  (*FTN*)')
         ELSE
           MsgsAddFirstLineTo (Footer_F, ' * Origin:  (*FTN*)');

     { This should always be first }
     IF (NOT N2E_FoundTear) THEN
        MsgsAddFirstLineTo (Footer_F, FidoTear);

     { clear out flags that should not be on echomail }
     Msg.Attr_F:=Msg.Attr_F AND (NOT (MSGLOCAL OR MSGPRIVATE));

     Msg.Ready_F:=Echomail;
     Msg.Ready_U:=NotReady;
END;


{==========================================================================}
{                        TRANS FIX STUFF                                   }
{==========================================================================}


{--------------------------------------------------------------------------}
{ TransFix_Load                                                            }
{                                                                          }
{ This routine must be called before any of the other TransFix_* routines  }
{ to copy some pieces of information from the Area Record in which the     }
{ message is / will be distributed. This routine can be called at any time }
{ before or during processing.                                             }
{                                                                          }
PROCEDURE TransFix_Load (VAR AreaRec : AreaBaseRecord; MsgId : STRING);
BEGIN
     TransFix_OriginAka:=AreaRec.OriginAka;
     TransFix_MsgId:=MsgId;

     IF (AreaRec.OriginNr = 0) THEN
        TransFix_Origin:=AreaRec.Origin
     ELSE
         TransFix_Origin:=Config.Origins[AreaRec.OriginNr];

     { check for empty system/custom origin line }
     IF (TransFix_Origin = '') THEN
        TransFix_Origin:='Another WaterGate Site!';

     TransFix_AreaName:=UpCaseString (DeleteBackSpaces (AreaRec.AreaName_F));
END;


{--------------------------------------------------------------------------}
{ TransFix_Unload                                                          }
{                                                                          }
{ This routine resets the variables used by TransFix, so illegal use can   }
{ be detected.                                                             }
{                                                                          }
PROCEDURE TransFix_Unload;
BEGIN
     TransFix_MsgId:='#ERROR!#';
     TransFix_Origin:=TransFix_MsgId;
     TransFix_OriginAka:=1;
END;


{--------------------------------------------------------------------------}
{ TransFix_HeaderLine                                                      }
{                                                                          }
{ This routine checks a header line and replaces the *FTN* info and other  }
{ info where required, like the 8 hex digit number in the MSGID kludge.    }
{                                                                          }
FUNCTION TransFix_HeaderLine (Regel : STRING) : STRING;

VAR CRC  : LONGINT;
    Help : STRING;

BEGIN
     { check MSGID }
     IF (Regel = #1'MSGID: *FTN*'#13) THEN
     BEGIN
          TransFix_HeaderLine:=#1'MSGID: '+
                               Fido2Str (Config.NodeNrs[TransFix_OriginAka])+
                               ' '+
                               TransFix_MsgID+
                               #13;
          Exit; { ## EXIT ## }
     END;

     IF (Regel = #1'REPLY: *FTN*'#13) THEN
     BEGIN
          LogMessage (liReport,'TransFix_HeaderLine: Found *FTN* in REPLY kludge');
          TransFix_HeaderLine:=''; { leave out of message }
          Exit; { ## EXIT ## }
     END;

     { check REPLYTO }
     IF (Regel = #1'REPLYTO *FTN*'#13) THEN
     BEGIN
          TransFix_HeaderLine:=#1'REPLYTO '+
                               Fido2Str (Config.NodeNrs[TransFix_OriginAka])+
                               ' '+
                               Config.GatewayUser+
                               #13;
          Exit; { ## EXIT ## }
     END;

     IF (Copy (Regel,Length (Regel)-10,11) = ' *GATEBAU*'#13) AND
        ((Copy (Regel,1,8) = #1'MSGID: ') OR
         (Copy (Regel,1,8) = #1'REPLY: ')) THEN
     BEGIN
          { replace *GATEBAU* with a CRC32 that includes the area name }
          {LogMessage ('TransFix: '+Regel);}
          Regel:=Copy (Regel,1,Length (Regel)-11);

          { According to MSGID.DOC }
          { wel over de originele Message-ID contents berekenen, }
          { dus eerst  weer terug vertalen ivm " hantering.      }
          Help:=MsgId2MessageID (Copy (Regel,9,255)+' 00000000')+TransFix_AreaName; { no space between the two! }
          CRC:=UpdateCRC32 ($FFFFFFFF,Help[1],Length (Help)) XOR $FFFFFFFF;
          Regel:=Regel+' '+LoCaseString (Long2HexString (CRC));

          {LogExtraMessage (Regel);}
          TransFix_HeaderLine:=Regel+#13;
          Exit; { ## EXIT ## }
     END;

     TransFix_HeaderLine:=Regel;
END;


{--------------------------------------------------------------------------}
{ TransFix_CompleteOrigin                                                  }
{                                                                          }
{ This routine completes the Origin: line. The *FTN* parts are placed and  }
{ the correct origin is put under the message.                             }
{ The input Regel can be with or without #13 at the end.                   }
{ The returned regel DOES NOT have a #13 at the end!                       }
{                                                                          }
FUNCTION TransFix_CompleteOrigin (Regel : STRING) : STRING;

VAR OrgPart : STRING[30]; { must be able to hold " (12345:12345/12345.12345)" }

BEGIN
     IF (Regel[Length (Regel)] = #13) THEN
        Delete (Regel,Length (Regel),1);

     IF (Pos (' (*FTN*)',Regel) <> Length (Regel)-7) THEN
     BEGIN
          TransFix_CompleteOrigin:=Regel;
          Exit;
     END;

     Regel:=Copy (Regel,1,Length (Regel)-8); { remove " (*FTN*)" }

     IF (Length (Regel) = 11{" * Origin: "}) THEN
        Regel:=Regel+TransFix_Origin; { pre-calculated in TransFix_Load }

     WITH Config.NodeNrs[TransFix_OriginAka] DO
     BEGIN
          OrgPart:=' ('+Word2String (Zone)+':'+
                        Word2String (Net)+'/'+
                        Word2String (Node);

          IF (Point > 0) THEN
             OrgPart:=OrgPart+'.'+Word2String (Point);

          OrgPart:=OrgPart+')';
     END;

     { make sure the resulting header is not too long }
     IF (Length (Regel)+Length (OrgPart) > 79) THEN
        Regel:=Copy (Regel,1,79-Length (OrgPart)-2)+'..';

     TransFix_CompleteOrigin:=Regel+OrgPart;
END;


{--------------------------------------------------------------------------}
{ TransFix_FooterLine                                                      }
{                                                                          }
{ This routine replaces the *FTN* info in a footer line.                   }
{                                                                          }
FUNCTION TransFix_FooterLine (Regel : STRING) : STRING;
BEGIN
     IF (Copy (Regel,1,11) = ' * Origin: ') THEN
        Regel:=TransFix_CompleteOrigin (Regel)+#13;

     TransFix_FooterLine:=Regel;
END;


{--------------------------------------------------------------------------}
{ Unit Initialization                                                      }
{                                                                          }
BEGIN
     TransFix_Unload;
END.
