{ WaterGate text-based configuration importer / exporter                   }
PROGRAM TextCfg;

{$I platform.inc}

{$A+,F-,P-,Q-,R-,S-,V+,X+}

{$IFDEF PLATFORM_OS2_OR_WIN32}
{$M 16384}
{$ENDIF}

{$IFDEF PLATFORM_DOS_ALL}
{$M 16384,0,655360}
{$ENDIF}

{$IFNDEF TEXTCFG} ## Check your conditional defines! ## {$ENDIF}

{$IFNDEF PLATFORM_OS2_WIN32}
{$IFOPT G+}       ## Switch of 286 code generation! ## {$ENDIF}
{$ENDIF}

{$IFOPT B+}       ## DISABLE Complete Boolean Evaluation ## {$ENDIF}

USES Ramon,
     Database,
     Fido,
     Cfg,
     Tdb,
     FlexCfg,
     Globals;

{$I wtrhlp.inc}

CONST
     FidoSystemType_Str : ARRAY [FidoSystemType] OF STRING = ('Binkley', 'FrontDoor', 'DBridge');
     ArcMailType_Str    : ARRAY [ArcType] OF STRING = ('Normal', 'Hex', 'All');
     AddressComplete_Str: ARRAY [RMailCorrectType] OF STRING = ('No', 'AddSysDomain', 'ScanHeaders');
     OrgInOrigin_Str    : ARRAY [0..2] OF STRING = ('No', 'Yes', 'Override');
     FidoMsgStyle_Str   : ARRAY [FidoMsgStyleType] OF STRING = ('None', '*.MSG', 'Squish', 'JAM');
     SendType_Str       : ARRAY [SendType] OF STRING = ('Normal', 'Hold', 'Crash', 'Direct', 'Tunnel', 'SEAT');
     UseCompressType_Str: ARRAY [UseCompressType] OF STRING = ('None', 'Compress', 'GZip');
     SystemType_Str     : ARRAY [SystemType] OF STRING = ('FTN', 'UUCP', 'BAG', 'SMTP', 'POP3', 'BBSIF', 'SOUP', 'INETMAIL');
     PktFormatType_Str  : ARRAY [PktFormatType] OF STRING = ('PKT', 'PKT2000');
     AreaRecordType_Str : ARRAY [AreaRecordType] OF STRING = ('Echo', 'Net', 'Local', 'EMail');
     MapSearchWhere_Str : ARRAY [MapSearchWhereType] OF STRING = ('All', 'Body', 'Header', 'From', 'To', 'Subject');
     MapActionType_Str  : ARRAY [MapActionType] OF STRING = ('Move', 'Copy', 'Delete', 'Forward', 'CC', 'Bounce',
                                                             'BounceTo', 'ToFile', 'Save', 'None');
     ListAccessType_Str : ARRAY [ListAccessType] OF STRING = ('ReadWrite', 'ReadOnly', 'WriteOnly');
     ListConfirmType_Str: ARRAY [ListConfirmType] OF STRING = ('Never', 'Ok', 'Try1', 'Try2', 'Try3');

VAR
     VerboseOutput  : BOOLEAN;

{--------------------------------------------------------------------------}
{ Export_BeginSection                                                      }
{                                                                          }
{ Starts a new section in the configuratoin text file.                     }
{                                                                          }
PROCEDURE Export_BeginSection (VAR F: TEXT; Title: STRING);
BEGIN
     WriteLn (F, '; ' + RepChar (75, '='));
     WriteLn (F, '; ' + RepChar (37 - (Length (Title) DIV 2), ' ') + Title);
     WriteLn (F, '; ' + RepChar (75, '='));
END;

{--------------------------------------------------------------------------}
{ Export_BeginSubSection                                                   }
{                                                                          }
{ Starts a new subsection in the configuration text file.                  }
{                                                                          }
PROCEDURE Export_BeginSubSection (VAR F: TEXT; Title: STRING);
BEGIN
     Writeln (F);
     WriteLn (F, '; = '+Title + ' ' + RepChar (72 - Length (Title), '='));
END;

{--------------------------------------------------------------------------}
{ Export_BeginSubSubSEction                                                }
{                                                                          }
{ Starts a new sub-subsection in the configuration text file.              }
{                                                                          }
PROCEDURE Export_BeginSubSubSection (VAR F: TEXT; Title: STRING);
BEGIN
     Writeln (F);
     WriteLn (F, '; - '+Title + ' ' + RepChar (72 - Length (Title), '-'));
END;

{--------------------------------------------------------------------------}
{ Export_Keyword                                                           }
{                                                                          }
{ Writes a "keyword <data<" [...] n that is put into the exported file,    }
{ we also want to include.                                                 }
{                                                                          }
PROCEDURE Export_Keyword (VAR F: TEXT; Indenting: INTEGER; Keyword: STRING; Data: STRING; HelpIndex: LONGINT);
VAR
     Line: STRING;

BEGIN
     IF (VerboseOutput) AND (HelpIndex <> -1) THEN
     BEGIN
          WriteLn (F);
          WriteLn (F, '; <keyword help not implemented- #'+Long2HexString (HelpIndex)+'>');
     END;

     { Blank data in here == commented out }
     Data := DeleteFrontAndBackSpaces (Data);

     Line := AddUpWithSpaces (Indenting*5, ' ');
     Line := Line + AddUpWithSpaces (20, Keyword) + Data;

     IF (Data = '') THEN
          Line := ';' + Line;

     WriteLn (F, Line);
END;

{--------------------------------------------------------------------------}
{ Export_Keyword_NoData                                                    }
{                                                                          }
{ For each keyword/item combination that is put into the exported file,    }
{ we also want to include.                                                 }
{                                                                          }
PROCEDURE Export_Keyword_NoData (VAR F: TEXT; Indenting: INTEGER; Keyword: STRING; HelpIndex: LONGINT);
VAR
     Line: STRING;

BEGIN
     IF (VerboseOutput) AND (HelpIndex <> -1) THEN
     BEGIN
          WriteLn (F);
          WriteLn (F, '; <keyword help not implemented- #'+Long2HexString (HelpIndex)+'>');
     END;

     Line := AddUpWithSpaces (Indenting*5, ' ') + Keyword;
     WriteLn (F, Line);
END;

{--------------------------------------------------------------------------}
{ Export_GeneralConfig                                                     }
{                                                                          }
{ Looks after writing all the system-wide configuration infomration out.   }
{                                                                          }
PROCEDURE Export_GeneralConfig (VAR ConfigFile : TEXT);
VAR
     I         : INTEGER;
     Temp      : STRING;
     Archivers : FtnArchivers;
     ComprCount: CompressionType;
     AfixFwd   : AreaFixForwardRecord;
     NfixFwd   : NewsFixForwardRecord;
     Offset    : LONGINT;

     Groups_F,
     Groups_U  : STRING;
     
BEGIN
     Export_BeginSection (ConfigFile, 'GENERAL CONFIGURATION');

     { ******* GLOBAL SETTINGS ******************************************** }
     Export_BeginSubSection (ConfigFile, 'Global Settings');

     Export_Keyword (ConfigFile, 0, 'SystemDir', Config.SystemDir, htr_CFGGlobal_System_path);
     Export_Keyword (ConfigFile, 0, 'SysOp', Config.Sysop, htr_CFGGlobal_Sysop_name);

     Export_Keyword (ConfigFile, 0, 'DoDupeChecks', Boolean2YesNo (Config.DoDupeChk), htr_CFGGlobal_Dupe_Checking);
     Export_Keyword (ConfigFile, 0, 'OversizedPath', Config.TooLargePath, htr_CFGGlobal_Oversized_path);

     Export_Keyword (ConfigFile, 0, 'MaxTdbHandles', Byte2String (Config.MaxHandles), htr_CFGGlobAdv_Max_Open_Handles);
     Export_Keyword (ConfigFile, 0, 'CacheTDBs', Boolean2YesNo (Config.CacheTdbs), htr_CFGGlobAdv_Cache_TDB_Files);

     Export_BeginSubSubSection (ConfigFile, 'Logfile Settings');

     Export_Keyword (ConfigFile, 0, 'LogFile', Config.LogFilePath, htr_CFGGlobal_Logfile_path);
     Export_Keyword (ConfigFile, 0, 'Log_Debug', Boolean2YesNo (Config.LogDebug), htr_CFGGlobLog_LogDebug);
     Export_Keyword (ConfigFile, 0, 'Log_X&DTossed', Boolean2YesNo (Config.LogSpoolTossed), htr_CFGGlobLog_LogSpoolTossed);
     Export_Keyword (ConfigFile, 0, 'Log_ExtractFido', Boolean2YesNo (Config.LogFidoExtract), htr_CFGGlobLog_LogFidoExtract);
     Export_Keyword (ConfigFile, 0, 'Log_PktToss', Boolean2YesNo (Config.LogFidoTossed), htr_CFGGlobLog_LogFidoTossed);
     Export_Keyword (ConfigFile, 0, 'Log_AddrXlat', Boolean2YesNo (Config.LogTranslationFU), htr_CFGGlobLog_LogTranslationFU);
     Export_Keyword (ConfigFile, 0, 'Log_NewNGNameCheck', Boolean2YesNo (Config.LogCheckFilter),
                                                       htr_CFGGlobLog_LogCheckFilter);
     Export_Keyword (ConfigFile, 0, 'Log_XAddressFix', Boolean2YesNo (Config.LogXFix), htr_CFGGlobLog_LogXFix);
     Export_Keyword (ConfigFile, 0, 'Log_CopyHdrFU', Boolean2YesNo (Config.LogCopyHeaders), htr_CFGGlobLog_LogCopyHeaders);
     Export_Keyword (ConfigFile, 0, 'Log_IllegalCopyHdr', Boolean2YesNo (Config.LogIllegalHeaders),
                                                       htr_CFGGlobLog_LogIllegalHeaders);
     Export_Keyword (ConfigFile, 0, 'Log_AreaNewsFix', Boolean2YesNo (Config.LogAreafix), htr_CFGGlobLog_LogAreaFix);
     Export_Keyword (ConfigFile, 0, 'Log_Mapping', Boolean2YesNo (Config.LogMapApply), htr_CFGGlobLog_LogMapApply);
     Export_Keyword (ConfigFile, 0, 'Log_ImportNetmail', Boolean2YesNo (Config.LogNetmailImport),
                                                       htr_CFGGlobLog_LogNetmailImport);
     Export_Keyword (ConfigFile, 0, 'Log_ReadOnlyDenials', Boolean2YesNo (Config.LogRODeny),
                                                       htr_CFGGlobLog_LogRODeny);
     Export_Keyword (ConfigFile, 0, 'Log_EachMsgFromPkt', Boolean2YesNo (Config.LogPktEachEcho),
                                                       htr_CFGGlobLog_LogPktEachEcho);
     Export_Keyword (ConfigFile, 0, 'Log_CreateUUCPJob', Boolean2YesNo (Config.LogUUCPOutbound),
                                                       htr_CFGGlobLog_LogUUCPOutbound);
     Export_Keyword (ConfigFile, 0, 'Log_CreateSMTPJob', Boolean2YesNo (Config.LogSMTPOutbound),
                                                       htr_CFGGlobLog_LogSMTPOutbound);
     Export_Keyword (ConfigFile, 0, 'Log_ExportMessages', Boolean2YesNo (Config.LogExportedMsgs),
                                                       htr_CFGGlobLog_LogExportedMsgs);
     Export_Keyword (ConfigFile, 0, 'Log_ArticleNews', Boolean2YesNo (Config.LogErrNewsgroups),
                                                       htr_CFGGlobLog_LogErrNewsgroups);

     { ======= FTN SETTINGS =============================================== }
     Export_BeginSubSection (ConfigFile, 'FTN Settings');

     {## description of Address statements}
     WriteLn (ConfigFile, '; Address z:n/n.p@domain <pointnet>');
     FOR I := 1 TO MaxAkas DO
     BEGIN
          IF (NOT FidoCompare (Config.NodeNrs [I], NullAdres)) THEN
          BEGIN
               Temp := Fido2Str (Config.NodeNrs [I]);

               { Pointnets use:  1:163/585.10@fidonet.org 34000            }
               IF ((Config.NodeNrs [I].Point > 0) AND
                   (Config.PointNets [I] > 0)) THEN
                    Temp := Temp + ' ' + Word2String (Config.PointNets [I]);

               Export_Keyword (ConfigFile, 0, 'Address', Temp, -1);
          END;
     END;

     {## description of Inbound/SecureInbound statements}
     WriteLn (ConfigFile, '; [Secure]Inbound <path>');
     FOR I := 1 TO MaxInboundDirs DO
          IF (Config.Inbound_F [I] <> '') THEN
               IF (Config.Security_F [I] = Secure) THEN
                    Export_Keyword (ConfigFile, 0, 'SecureInbound', Config.Inbound_F [I], -1)
               ELSE
                    Export_Keyword (ConfigFile, 0, 'Inbound', Config.Inbound_F [I], -1);
                   
     Export_Keyword (ConfigFile, 0, 'Outbound', Config.Outbound_F, htr_SysFTN_Outbound);

     {## description of Origin statements}
     WriteLn (ConfigFile, '; DefOriginN <default origin line #n>');
     FOR I := 1 TO MaxOrigins DO
          IF (Config.Origins [I] <> '') THEN
               Export_Keyword (ConfigFile, 0, 'DefOrigin'+Integer2String (I), Config.Origins [I], -1);

     Export_Keyword (ConfigFile, 0, 'MailerType', FidoSystemType_Str [Config.FidoSystem], htr_SysFTN_Mailer_Type);
     IF (Config.FidoSystem = stDBridge) THEN
          Export_Keyword (ConfigFile, 0, 'DBridgeQueue', Config.DBridgeQueuePath, htr_SysFTN_DBridge_queue);
     {
     ELSE
          Export_Keyword (ConfigFile, 0, ';DBridgeQueue', ''htr_SysFTN_DBridge_queue);
     }

     Export_Keyword (ConfigFile, 0, 'MailerRescanFlag', Config.RescanFlagFile, htr_SysFTN_Rescan_files);
     Export_Keyword (ConfigFile, 0, 'EditorRescanFlag', Config.RescanFlagFile2, -1);

     Export_Keyword (ConfigFile, 0, 'MaxArchiveLen', Longint2String (Config.MaxFidoArcLen), htr_SysFTN_Maximum_archive_length);

     Export_Keyword (ConfigFile, 0, 'Mailer_Truncate', Boolean2YesNo (Config.Mailer_TFS), htr_SysFTN_ARCmail_flag);
     Export_Keyword (ConfigFile, 0, 'ArcmailExtension', ArcMailType_Str [Config.FidoArcmailExtension],
                                                       htr_SysFTN_ARCmail_extensions);

     { --------- ARCHIVER CONFIGURATION ----------------------------------- }
     Export_BeginSubSubSection (ConfigFile, 'FTN Archiver Configuration');
     Export_Keyword (ConfigFile, 0, 'DefaultArchiver', ComprDescr [Config.DefaultCompressor], htr_SysFTN_Default_archiver);

     WriteLn (ConfigFile);
     Flex_DosArchivers_Read (Archivers);
     FOR ComprCount := fctARC TO fctOP1 DO
          Export_Keyword (ConfigFile, 0, 'DOS_Compress_'+ComprDescr [ComprCount], Archivers.Archive [ComprCount], -1);

     FOR ComprCount := fctARC TO fctGUS DO
          Export_Keyword (ConfigFile, 0, 'DOS_Unpack_'+ComprDescr [ComprCount], Archivers.UnArchive [ComprCount], -1);

     WriteLn (ConfigFile);
     Flex_OS2Archivers_Read (Archivers);
     FOR ComprCount := fctARC TO fctOP1 DO
          Export_Keyword (ConfigFile, 0, 'OS2_Compress_'+ComprDescr [ComprCount], Archivers.Archive [ComprCount], -1);

     FOR ComprCount := fctARC TO fctGUS DO
          Export_Keyword (ConfigFile, 0, 'OS2_Unpack_'+ComprDescr [ComprCount], Archivers.UnArchive [ComprCount], -1);

     { --------- AREAFIX CONFIGURATION ------------------------------------ }
     Export_BeginSubSubSection (ConfigFile, 'Areafix Configuration');
     {## areafix name information}
     WriteLn (ConfigFile, ';AreafixName <name>');
     FOR I := 1 TO MaxAreafixNames DO
          IF (Config.AreafixNames [I] <> '') THEN
               Export_Keyword (ConfigFile, 0, 'AreafixName', Config.AreafixNames [I], -1);

     Export_Keyword (ConfigFile, 0, 'KillAfterAreafix', Boolean2YesNo (Config.KillAreafixMsgs),
                                                  htr_SysFTN_Kill_after_AreaFix);
     Export_Keyword (ConfigFile, 0, 'RescanMsgsLimit', Word2String (Config.RescanMsgsLimit),
                                                  htr_SysFTN_Rescan_Msgs_Limit);
     Export_Keyword (ConfigFile, 0, 'RescanDaysLimit', Word2String (Config.RescanDaysLimit),
                                                  htr_SysFTN_Rescan_Days_Limit);

     {## afix forward info}
     WriteLn (ConfigFile);
     WriteLn (ConfigFile, ';Areafix forward defs');
     IF Flex_AreaFixFwd_ReadFirst (AfixFwd, Offset) THEN
     BEGIN
          REPEAT
               WITH AfixFwd DO
               BEGIN
                    Export_Keyword_NoData (ConfigFile, 0, 'AreafixForward '+Fido2Str (UplinkAddress), -1);
                    Export_Keyword (ConfigFile, 1, 'ExportAKA', Fido2Str (Config.NodeNrs [ExportAKA]), -1);
                    IF (Unconditional) THEN
                         Export_Keyword_NoData (ConfigFile, 1, 'Unconditional', -1);

                    Export_Keyword (ConfigFile, 1, 'Arealist', ArealistPath, -1);
                    IF (AreaList = lstAREASBBS) THEN
                         Export_Keyword (ConfigFile, 1, 'ListType', 'AREAS.BBS', -1)
                    ELSE
                         Export_Keyword (ConfigFile, 1, 'ListType', 'NAMELIST', -1);
               
                    Export_Keyword (ConfigFile, 1, 'RobotName', AreaManager, -1);
                    Export_Keyword (ConfigFile, 1, 'Password', Password, -1);
                    Export_Keyword (ConfigFile, 1, 'Group', BuildSingleGroupDesc (Group), -1);
                    Export_Keyword (ConfigFIle, 1, 'AddPlus', Boolean2YesNo (AddPLus), -1);

                    Export_Keyword_NoData (ConfigFile, 0, 'EndForward', -1);
                    WriteLn (ConfigFile);
               END;
          UNTIL (NOT Flex_AreafixFwd_ReadNext (AFixFwd, Offset));
     END;

     { ======= RFC SETTINGS =============================================== }
     Export_BeginSubSection (ConfigFile, 'RFC/Internet Settings');
     Export_Keyword (ConfigFile, 0, 'Organization', Config.Organization, htr_SysRFC_Organization);
     Export_Keyword (ConfigFile, 0, 'SmartHost', Config.SmartHost, htr_SysRFC_SmartHost);
    
     {## domain info}
     WriteLn (ConfigFile, '; SysDomain <domain>');
     FOR I := 1 TO MaxSystemDomains DO
          IF (Config.Domains [I] <> '') THEN
               Export_Keyword (ConfigFile, 0, 'SysDomain', Config.Domains [I], -1);

     Export_Keyword (ConfigFile, 0, 'Timezone', Config.TimeZone, htr_SysRFC_Time_zone);
{## update
     Export_Keyword (ConfigFile, 0, 'BounceUndeliverable', Boolean2YesNo (Config.BounceUnknown),
                                                  htr_SysRFC_Undeliverable_mail);
}
     Export_Keyword (ConfigFile, 0, 'BounceSmall', Boolean2YesNo (Config.BounceSmall), htr_SysRFC_Bounce_small);
     Export_Keyword (ConfigFile, 0, 'XPostLimit', Byte2String (Config.MaxXPostNewsgroups),
                                                  htr_SysRFC_Cross_post_limit);

     { --------- NEWSFIX CONFIGURATION ------------------------------------ }
     Export_BeginSubSubSection (ConfigFile, 'Newsfix Configuration');
     Export_Keyword (ConfigFile, 0, 'NewsfixName', Config.NewsfixName, htr_SysRFC_Newsfix_name);
     {## newsfix forward info}
     Writeln (ConfigFile);
     WriteLn (ConfigFile, ';Newsfix forward defs');
     IF Flex_ReadNewsFixFwd_First (NFixFwd, Offset) THEN
     BEGIN
          REPEAT
               WITH NFixFwd DO
               BEGIN
                    Export_Keyword_NoData (ConfigFile, 0, 'NewsfixForward '+UUCPName, -1);

                    Export_Keyword (ConfigFile, 1, 'Newslist', ArealistPath, -1);
                    Export_Keyword (ConfigFile, 1, 'Group', BuildSingleGroupDesc (Group), -1);

                    Export_Keyword_NoData (ConfigFile, 0, 'EndForward', -1);
                    Writeln (ConfigFile);
               END;
          UNTIL (NOT Flex_ReadNewsFixFwd_Next (NFixFwd, Offset));
     END;

     Export_Keyword (ConfigFile, 0, 'SMTPForward', Config.SMTPForward, htr_SysRFC_SMTP_forward);
     Export_Keyword (ConfigFile, 0, 'AddressCompletion', AddressComplete_Str [Config.RMailCorrect],
                                                            htr_SysRFC_Address_completion);
     Export_Keyword (ConfigFile, 0, 'Backbone', Config.Backbone, htr_SysRFC_Backbone);
     Export_Keyword (ConfigFile, 0, 'RFCBadPath', Config.RFCBadPath, htr_SysRFC_RFCBadPath);

     { --------- UUCP SETTINGS -------------------------------------------- }
     Export_BeginSubSubSection (ConfigFile, 'UUCP Settings');
     Export_Keyword (ConfigFile, 0, 'SpoolDir', Config.SpoolBaseDir, htr_SysRFCUUCP_Spool_directory);

     IF (Config.UUPCMode) THEN
          Export_Keyword (ConfigFile, 0, 'SpoolType', 'UUPC', htr_SysRFCUUCP_SpoolMode)
     ELSE
          Export_Keyword (ConfigFile, 0, 'SpoolType', 'UUCP', htr_SysRFCUUCP_SpoolMode);

     Export_Keyword (ConfigFile, 0, 'UUCPName', Config.UUCPName, htr_SysRFCUUCP_UUCP_name);
     Export_Keyword (ConfigFile, 0, 'WorldRegistered', Boolean2YesNo (Config.WorldWide),
                                                       htr_SysRFCUUCP_World_registered);
     Export_Keyword (ConfigFile, 0, 'MaxDATLen', Longint2String (Config.MaxDatLength),
                                                       htr_SysRFCUUCP_Maximum_DAT_length);
     Export_Keyword (ConfigFile, 0, 'MaxRMailLen', Word2String (Config.MaxRMailLineLen),
                                                       htr_SysRFCUUCP_Maximum_rmail_length);
     Export_Keyword (ConfigFile, 0, 'ForceNoBitmask', Boolean2YesNo (Config.ForceNoBitMask),
                                                       htr_SysRFCUUCP_Force_no_bitmask);

     { --------- RFC COMPRESSOR CONFIGURATION ----------------------------- }
     Export_BeginSubSubSection (ConfigFile, 'RFC Compressor Configuration');
     {## compression program info (htr_SysRFC_UUCP_Compression_Programs)}

     Export_Keyword (ConfigFile, 0, 'Compress', Config.ComprPrg_U [Compress, Compr], -1);
     Export_Keyword (ConfigFile, 0, 'DeCompress', Config.ComprPrg_U [Compress, DeCompr], -1);
     Export_Keyword (ConfigFile, 0, 'GZip', Config.ComprPrg_U [GZip, Compr], -1);
     Export_Keyword (ConfigFile, 0, 'Un-GZip', Config.ComprPrg_U [GZip, DeCompr], -1);
         

     { ========= GATEWAY SETTINGS ========================================= }
     Export_BeginSubSection (ConfigFile, 'Gateway Settings');
     Export_BeginSubSubSection (ConfigFile, 'FTN -> RFC');

     Export_Keyword (ConfigFile, 0, 'GatewayAKA', Fido2Str (Config.NodeNrs [Config.GatewayAKA]), htr_SysGW_Gateway_AKA);
     Export_Keyword (ConfigFile, 0, 'GatewayUser', Config.GatewayUser, htr_SysGW_Gateway_User);
     Export_Keyword (ConfigFile, 0, 'Accept_To', Boolean2YesNo (Config.FidoAcceptTO), htr_SysGW_AcceptTo);
     Export_Keyword (ConfigFile, 0, 'KillGatedNetmail', Boolean2YesNo (Config.KillGatedNetmail), htr_SysGW_Kill_gated_netmail);
     Export_Keyword (ConfigFile, 0, 'AllowHeaders', Boolean2YesNo (Config.CopyHeaders_FU), htr_SysGW_Allow_headers);
     Export_Keyword (ConfigFile, 0, 'Allow8Bit', Boolean2YesNo (Config.Allow8Bit), htr_SysGW_Transport_limitation);
     Export_Keyword (ConfigFile, 0, 'AlwaysMimeQP', Boolean2YesNo (Config.AlwaysMimeQuotePrint),
                                                  htr_SysGW_Quoted_printable);
     Export_Keyword (ConfigFile, 0, 'LineWrap', Byte2String (Config.WrapLineLen), htr_SysGW_Line_wrap);

     Export_BeginSubSubSection (ConfigFile, 'FTN <-> RFC');
     Export_Keyword (ConfigFile, 0, 'SmallAddresses', Boolean2YesNo (Config.PackedAddresses),
                                                  htr_SysGW_Small_addresses);
     Temp := Config.NameSeparator;
     Export_Keyword (ConfigFile, 0, 'NameSeparator', Temp, htr_SysGW_Name_separator);

     Export_BeginSubSubSection (ConfigFile, 'RFC -> FTN');
     Export_Keyword (ConfigFile, 0, 'FSC-35', Boolean2YesNo (Config.ReplyFSC35), htr_SysGW_FSC35_Kludges);
     Export_Keyword (ConfigFile, 0, 'FromHasFullname', Boolean2YesNo (Config.HeaderFullname),
                                                  htr_SysGW_FTN_From);

     {## copy header info}
     FOR I := 1 TO MaxCopyHeaders DO
     BEGIN
          IF (Config.CopyHeaderNames [I] <> '') THEN
          BEGIN
               Temp := Config.CopyHeaderNames [I] + ' ';
               CASE Config.CopyHeaderHow [I] OF
                    chNot     :    Temp := Temp + 'No';
                    chKludge  :    Temp := Temp + 'Kludge';
                    chText    :    Temp := Temp + 'Text';
               END;
     
               Export_Keyword (ConfigFile, 0, 'GateCopyHeader', Temp, -1);
          END;
     END;

     IF (Config.GateMSGID = gmNot) THEN
          Export_Keyword (ConfigFile, 0, 'GateMessageID', 'No', htr_SysGW_MessageID_to_MSGID)
     ELSE
          Export_Keyword (ConfigFile, 0, 'GateMessageID', 'Yes', htr_SysGW_MessageID_to_MSGID);

     Export_Keyword (ConfigFile, 0, 'GateOrganization', OrgInOrigin_Str [Config.OrganizationInOrigin],
                                                  htr_SysGW_Organization_to_Origin);
     Temp := Config.TransChar2;
     Export_Keyword (ConfigFile, 0, 'NameSeparator2', Temp, htr_SysGW_Name_separator_2);

     { ========= MESSAGE BASE SETTINGS ==================================== }
     Export_BeginSubSection (ConfigFile, 'Message Base Settings');
     Temp := FidoMsgStyle_Str [Config.FidoNetmailType] + ' ' + Config.FidoNetmailPath;

     {## htr_sysmsg_netmail_path may not be entirely accurate for a one-   }
     {   line configuration!                                               }
     Export_Keyword (ConfigFile, 0, 'Netmail', Temp, htr_SysMsg_Netmail_path);
     Export_Keyword (ConfigFile, 0, 'DecodeFiles', Boolean2YesNo (Config.NetMailDecode), htr_SysMsg_Decode_files);
     IF (Config.NetmailDecode) THEN
          Export_Keyword (ConfigFile, 0, 'DecodePath', Config.NetmailDecodePath, htr_SysMsg_Files_path)
     ELSE
          Export_Keyword (ConfigFile, 0, 'DecodePath', '', htr_SysMsg_Files_path);

     { OPUS date option only applies to *.MSG areas                        }
     IF (Config.FidoNetmailType = FidoMsgType) THEN
          Export_Keyword (ConfigFile, 0, 'OpusDateFormat', Boolean2YesNo (Config.OpusDateFormat), htr_SysMsg_Opus_date_format)
     ELSE               
          Export_Keyword (ConfigFile, 0, 'OpusDateFormat', '', htr_SysMsg_Opus_date_format);

     Temp := FidoMsgStyle_Str [Config.FidoBadAreaType] + ' ' + Config.FidoBadPath;
     Export_Keyword (ConfigFile, 0, 'Badmail', Temp, htr_SysMsg_Badmail_path);

     Temp := FidoMsgStyle_Str [Config.FidoDupeAreaType] + ' ' + Config.FidoDupePath;
     Export_Keyword (ConfigFile, 0, 'Dupemail', Temp, htr_SysMsg_Dupemail_path);

     Export_Keyword (ConfigFile, 0, 'AutoLink', Boolean2YesNo (Config.AutoLink), htr_SysMsg_Auto_link);
     Export_Keyword (ConfigFile, 0, 'StripSeenBy', Boolean2YesNo (Config.StripSeenBy), htr_SysMsg_Strip_SEENBY);
     Export_Keyword (ConfigFile, 0, 'ReplaceTear', Boolean2YesNo (Config.ReplaceTear), htr_SysMsg_Replace_tear);

     {## msg size info}
     Export_Keyword (ConfigFile, 0, 'MaxMsgSize_SDM', Longint2String (Config.MaxFidoMsgLen), -1);
     Export_Keyword (ConfigFile, 0, 'MaxMsgSize_Squish', Longint2String (Config.MaxSquishMsgLen), -1);
     Export_Keyword (ConfigFile, 0, 'MaxMsgSize_JAM', Longint2String (Config.MaxJamMsgLen), -1);

     { ========= ADMINISTRATOR SETTINGS =================================== }
     Export_BeginSubSection (ConfigFile, 'Administrator Settings');

     {## admin info}
     IF (Config.AdminAddrType = 0) THEN
     BEGIN
          Export_Keyword (ConfigFile, 0, 'Admin_SendTo', 'No', htr_SysAdmin_AddressType);
          Export_Keyword (ConfigFile, 0, 'Admin_SendLog', '', htr_SysAdmin_SendLog);
          Export_Keyword (ConfigFile, 0, 'Admin_CCAfixReq', '', htr_SysAdmin_CCAFixFwd);
     END ELSE
     BEGIN
          IF (Config.AdminAddrType = 1 {Netmail}) THEN
               Export_Keyword (ConfigFIle, 0, 'Admin_SendTo', 'Netmail '+Config.AdminFidoName+'%'+
                                                                 Fido2Str (Config.AdminFidoAddr), -1)
          ELSE                { e-mail }
               Export_Keyword (ConfigFile, 0, 'Admin_SendTo', 'Email '+Config.AdminUUCPAddr, -1);

          Export_Keyword (ConfigFile, 0, 'Admin_SendLog', Boolean2YesNo (Config.AdminSendLog), htr_SysAdmin_SendLog);
          Export_Keyword (ConfigFile, 0, 'Admin_CCAfixReq', Boolean2YesNo (Config.AdminCCAfixFwd),
                                                                 htr_SysAdmin_CCAFixFwd);
     END;

     { ========= NEW USER DEFAULTS ======================================== }
     Export_BeginSubSection (ConfigFile, 'New User Defaults');

     { Build group lists }
     Groups_F := BuildGroupListDesc (Config.DefGroups_F, 200);
     Groups_U := BuildGroupListDesc (Config.DefGroups_U, 200);
    
     Export_Keyword (ConfigFile, 0, 'NewUser_Notify', Boolean2YesNo (Config.NewUserNotify), htr_SysNewUser_Notify);

     { --------- FTN USER DEFAULTS ---------------------------------------- }
     Export_BeginSubSubSection (ConfigFile, 'FTN User Defaults');
     Export_Keyword (ConfigFIle, 0, 'NewFtnUser_Groups', Groups_F, htr_SysNewUser_FTNGroups);
     Export_Keyword (ConfigFile, 0, 'NewFtnUser_Compress', ComprDescr [Config.NewUserFTNCompressor],
                                                       htr_SysNewUser_FTNCompression);
     Export_Keyword (ConfigFile, 0, 'NewFtnUser_SendFmt', SendType_Str [Config.NewUserSendFormat],
                                                       htr_SysNewUser_SendFormat);
     Export_Keyword (ConfigFile, 0, 'NewFtnUser_MaxPkt', Longint2String (Config.NewUserMaxPktSize),
                                                       htr_SysNewUser_MaxPktLength);
     Export_Keyword (ConfigFile, 0, 'NewFtnUser_MaxArc', Longint2String (Config.NewUserMaxArcSize),
                                                       htr_SysNewUser_MaxArcLength);

     { --------- RFC USER DEFAULTS ---------------------------------------- }
     Export_BeginSubSubSection (ConfigFile, 'RFC User Defaults');
     Export_Keyword (ConfigFIle, 0, 'NewRfcUser_Groups', Groups_U, htr_SysNewUser_RFCGroups);
     Export_Keyword (ConfigFile, 0, 'NewRfcUser_Compress', UseCompressType_Str [Config.NewUserUUCPCompress],
                                                       htr_SysNewUser_RFCCompression);
     Export_Keyword (ConfigFile, 0, 'NewRfcUser_AddBatch', Boolean2YesNo (Config.NewUserAddBatchHdr),
                                                       htr_SysNewUser_AddBatchHeader);
     Temp := Config.NewUserMailGrade;
     Export_Keyword (ConfigFile, 0, 'NewRfcUser_MailGrd', Temp, htr_SysNewUser_Mail_and_news_grades);
     Temp := Config.NewUserNewsGrade;
     Export_Keyword (ConfigFile, 0, 'NewRfcUser_NewsGrd', Temp, -1);

     { ========= NEW AREA DEFAULTS ======================================== }
     Export_BeginSubSection (ConfigFile, 'New Area Defaults');

     Export_Keyword (ConfigFile, 0, 'NewArea_Type', FidoMsgStyle_Str [Config.FidoAutoCreateType],
                                                            htr_SysNewArea_MsgBaseType);
     Export_Keyword (ConfigFile, 0, 'NewArea_MaxMsgs', Word2String (Config.DefNumbToKeep_F), 
                                                            htr_SysNewArea_DefaultNumber);
     Export_Keyword (ConfigFIle, 0, 'NewArea_MaxDays', Word2String (Config.DefDaysToKeep_F),
                                                            htr_SysNewArea_DefaultDays);
     Export_Keyword (ConfigFile, 0, 'NewArea_Path', Config.DefaultFidoMsgPath, htr_SysNewArea_DefaultNewPath);
END;

{--------------------------------------------------------------------------}
{ Export_GroupConfig                                                       }
{                                                                          }
{ Writes all of the group-descriptions to the text file.                   }
{                                                                          }
PROCEDURE Export_GroupConfig (VAR ConfigFile : TEXT);
VAR
     I         : INTEGER;
     GroupData : GroupDescRecord;
     Temp      : STRING;

BEGIN
     WriteLn (ConfigFile);
     Export_BeginSection (ConfigFile, 'GROUP CONFIGURATION');

     {## instructions}
     FOR I := 1 TO MaxGroups DO
     BEGIN

          ReadGroupDescRecord (I, GroupData);
          { GroupDef <group> <read only yes/no> <origin aka> <description..> }
          WITH GroupData DO
          BEGIN
               { If this group hasn't is the 'default' one, chances are it isn't }
               { in use.                                                         }
               IF NOT ((DeleteFrontAndBackSpaces (GroupDesc) = '<no description>')
                       AND (OriginAka = 1) AND (ReadOnly = FALSE)) THEN
               BEGIN
                    Temp := BuildSingleGroupDesc (I) + ' ' + Boolean2YesNo (ReadOnly) + ' ' +
                            Fido2Str (Config.NodeNrs [OriginAka]) + ' ' +
                            GroupDesc;

                    Export_Keyword (ConfigFile, 0, 'GroupDef', Temp, -1);
               END;
          END;
     END;
END;      

{--------------------------------------------------------------------------}
{ Export_Users                                                             }
{                                                                          }
{ Writes all of the user/link definitions to the text file.                }
{                                                                          }
PROCEDURE Export_Users (VAR ConfigFile : TEXT);
VAR
     I         : UserBaseRecordNrType;
     J         : INTEGER;
     UserRec   : UserBaseRecord;
     Temp      : STRING;

BEGIN
     WriteLn (ConfigFile);
     Export_BeginSection (ConfigFile, 'USER AND LINK DEFINITIONS');

     {## instructions}
     FOR I := 1 TO UserBaseRecCount DO
     BEGIN
          ReadUserBaseRecord (I, UserRec);
          IF (UserRec.Deleted) THEN
               Continue;

          WITH UserRec DO
          BEGIN
               Export_Keyword_NoData (ConfigFile, 0, 'Define '+SystemType_Str [System], -1);

               IF (System = _F) THEN
               BEGIN
                    Export_Keyword (ConfigFile, 1, 'Address', Fido2Str (Address), -1);
                    Export_Keyword (ConfigFile, 1, 'SysOp', Sysop, -1);
               END;

               Export_Keyword (ConfigFile, 1, 'Organization', Organization, -1);

               IF (NOT (System IN [_S, _P, _INETMAIL])) THEN
               BEGIN
                    Temp := BuildGroupListDesc (Groups, 200);
                    Export_Keyword (ConfigFile, 1, 'Groups', Temp, -1);
               END;

               IF (System = _F) THEN
               BEGIN
                    Export_Keyword (ConfigFile, 1, 'Areafix_Pwd', AreafixPwd, -1);
                    Export_Keyword (ConfigFile, 1, 'Areafix_Special', Boolean2YesNo (AllowFrom), -1);
                    Export_Keyword (ConfigFile, 1, 'AutoCreate', Boolean2YesNo (AllowCreate), -1);
                    Export_Keyword (ConfigFIle, 1, 'Passive', Boolean2YesNo (Passive), -1);
                    Export_Keyword (ConfigFile, 1, 'Notify', Boolean2YesNo (Notify_F), -1);
                    Export_Keyword (ConfigFile, 1, 'Pkt_Password', PacketPwd, -1);

                    IF (ExportAka = 0) THEN
                         Export_Keyword (ConfigFile, 1, 'ExportAKA', '', -1)
                    ELSE
                         Export_Keyword (ConfigFile, 1, 'ExportAKA', Fido2Str (Config.NodeNrs [ExportAKA]), -1);

                    Export_Keyword (ConfigFile, 1, 'MaxPktSize', Longint2String (MaxPktLength), -1);
                    Export_Keyword (ConfigFile, 1, 'MaxArcSize', Longint2String (MaxArcLength), -1);
                    Export_Keyword (ConfigFile, 1, 'PktType', PktFormatType_Str [PktFormat], -1);
                    Export_Keyword (ConfigFile, 1, 'PackWith', ComprDescr [Compression], -1);
                    Export_Keyword (ConfigFile, 1, 'SendFormat', SendType_Str [SendFormat], -1);
                    Export_Keyword (ConfigFile, 1, 'TunnelAddress', TunnelTo, -1);
                    Export_Keyword (ConfigFile, 1, 'DecodeFiles', Boolean2YesNo (DecodeFiles), -1);
               END; { _F }

               IF (System = _U) THEN
               BEGIN
                    Export_Keyword (ConfigFile, 1, 'Newsfix_Pwd', AreafixPwd, -1);
                    Export_Keyword (ConfigFile, 1, 'Newsfix_Special', Boolean2YesNo (AllowFrom), -1);
               END;

               IF (System IN [_SOUP, _U, _B]) THEN
                    Export_Keyword (ConfigFile, 1, 'AutoCreate', Boolean2YesNo (AllowCreate), -1);

               IF (System = _U) THEN
               BEGIN
                    Export_Keyword (ConfigFIle, 1, 'Passive', Boolean2YesNo (Passive), -1);
                    Export_Keyword (ConfigFile, 1, 'Notify', Boolean2YesNo (Notify_U), -1);
               END;

               IF (System = _S) THEN
               BEGIN
                    Export_Keyword (ConfigFile, 1, 'SmtpIn', SmtpInPath, -1);
                    Export_Keyword (ConfigFile, 1, 'SmtpOut', SmtpOutPath, -1);
               END;

               IF (System = _SOUP) THEN
               BEGIN
                    Export_Keyword (ConfigFile, 1, 'SoupIn', SoupInPath, -1);
                    Export_Keyword (ConfigFile, 1, 'SoupOut', SoupOutPath, -1);
               END;

               IF (System = _B) THEN
                    Export_Keyword (ConfigFile, 1, 'SearchPath', BagPath, -1);

               IF (System = _F) THEN
                    Export_Keyword (ConfigFile, 1, 'Outbound', NodeOutDir, -1);

               IF (System IN [_S, _U, _SOUP, _INETMAIL]) THEN
               BEGIN
                    IF (System = _U) THEN
                         Export_Keyword (ConfigFile, 1, 'UucpName', UUCPName, -1)
                    ELSE
                         Export_Keyword (ConfigFile, 1, 'SysName', UUCPName, -1);
               END;

               IF (System = _U) THEN
               BEGIN
                    Export_Keyword (ConfigFile, 1, 'Compress', UseCompressType_Str [Compress], -1);
                    Export_Keyword (ConfigFile, 1, 'AddBatchHdr', Boolean2YesNo (Cunbatch), -1);

                    Temp := MailGrade;
                    Export_Keyword (ConfigFile, 1, 'MailGrade', Temp, -1);

                    Temp := NewsGrade;
                    Export_Keyword (ConfigFile, 1, 'NewsGrade', Temp, -1);

                    Export_Keyword (ConfigFile, 1, 'GigoT_Special', Boolean2YesNo (GigoT), -1);
               END;

               IF (System = _B) THEN
                    Export_Keyword (ConfigFile, 1, 'ReturnSystem', BAGBackLink, -1);

               IF (System IN [_F, _U, _S]) THEN
               BEGIN
                    Export_Keyword (ConfigFile, 1, 'AllowSubdomains', Boolean2YesNo (AllowSubDomains), -1);

                    FOR J := 1 TO MaxUserDomains DO
                         IF (DeleteFrontAndBackSpaces (Domains [J]) <> '') THEN
                              Export_Keyword (ConfigFile, 1, 'Domain', Domains [J], -1);
               END;

               IF (System = _P) THEN
               BEGIN
                    Export_Keyword (ConfigFile, 1, 'MailboxPath', Pop3File, -1);
                    Export_Keyword (ConfigFile, 1, 'MsgSeparator', Pop3Separator, -1);
                    Export_Keyword (ConfigFile, 1, 'EnvelopeHeader', Pop3EnvelopeHdr, -1);
                    Export_Keyword (ConfigFile, 1, 'SingleRecipient', Pop3Recipient, -1);
               END;

               IF (System = _SOUP) THEN
               BEGIN
                    Export_Keyword (ConfigFile, 1, 'EnvelopeHeader', SoupEnvelopeHdr, -1);
                    Export_Keyword (ConfigFile, 1, 'SingleRecipient', SoupRecipient, -1);
                    Export_Keyword (ConfigFile, 1, 'WGSOUP', Boolean2YesNo (UsingWGSOUP), -1);
               END;

               IF (System = _INETMAIL) THEN
               BEGIN
                    Export_Keyword (ConfigFile, 1, 'Queue', InetMailQueue, -1);
                    Export_Keyword (ConfigFile, 1, 'SourceDomain', InetMailSourceDomain, -1);
               END;

               IF (System = _BBS) THEN
               BEGIN
                    Export_Keyword (ConfigFile, 1, 'SystemAKA', Fido2Str (Config.NodeNrs [SystemAKA]), -1);
                    Export_Keyword (ConfigFile, 1, 'FakeAKA', Word2String (FakeZone)+':'+
                                                              Word2String (FakeNet)+'/'+
                                                              Word2String (FakeNode), -1);
                    Export_Keyword (ConfigFile, 1, 'KeepSBP', Boolean2YesNo (KeepSBP), -1);
                    Export_Keyword (ConfigFile, 1, 'Inbound', Inbound, -1);
                    Export_Keyword (ConfigFile, 1, 'Extension', InboundExt, -1);
                    Export_Keyword (ConfigFile, 1, 'Outbound', Outbound, -1);
               END;

               Export_Keyword_NoData (ConfigFile, 0, 'EndDef', -1);

               WriteLn (ConfigFile);
          END;
     END;
END;      

{--------------------------------------------------------------------------}
{ Export_Areas                                                             }
{                                                                          }
{ Writes all of the area definitions to the text file.                     }
{                                                                          }
PROCEDURE Export_Areas (VAR ConfigFile : TEXT);
VAR
     I         : AreaBaseRecordNrType;
     J         : INTEGER;
     AreaRec   : AreaBaseRecord;
     Temp      : STRING;

BEGIN
     WriteLn (ConfigFile);
     Export_BeginSection (ConfigFile, 'AREA DEFINITIONS');

     {## instructions}
     FOR I := 1 TO AreaBaseRecCount DO
     BEGIN
          ReadAreaBaseRecord (I, AreaRec);
          IF (AreaRec.Deleted) THEN
               Continue;

          WITH AreaRec DO
          BEGIN
               Export_Keyword_NoData (ConfigFile, 0, 'Area '+AreaName_F + ' ' + AreaName_U, -1);
               Export_Keyword (ConfigFile, 1, 'Desc', Comment, -1);
               Export_Keyword (ConfigFile, 1, 'Type', AreaRecordType_Str [AreaType], -1);

               Export_Keyword (ConfigFile, 1, 'Groups', BuildGroupListDesc (IsInGroups, 200), -1);
               Export_Keyword (ConfigFIle, 1, 'AllowPassive', Boolean2YesNo (AllowPassive), -1);
               Export_Keyword (ConfigFile, 1, 'Passive', Boolean2YesNo (Passive), -1);
               Export_Keyword (ConfigFIle, 1, 'Mandatory', Boolean2YesNo (Mandatory), -1);
               Export_Keyword (ConfigFile, 1, 'Rules', RulesFile, -1);
               IF (OriginNr = 0) THEN
                    Export_Keyword (ConfigFile, 1, 'Origin', 'Custom '+Origin, -1)
               ELSE
                    Export_Keyword (ConfigFile, 1, 'Origin', '#'+Integer2String (OriginNr), -1);
               
               Export_Keyword (ConfigFIle, 1, 'Aka', Fido2Str (Config.NodeNrs [OriginAKA]), -1);

               FOR J := 1 TO MaxAKAs DO
                    IF HasSeenByBit (AddSeenByAkas, J) THEN
                         Export_Keyword (ConfigFile, 1, 'AddSeenBy', Fido2Str (Config.NodeNrs [J]), -1);

               Export_Keyword (ConfigFile, 1, 'Moderator', Moderator, -1);
               Export_Keyword (ConfigFile, 1, 'DupeWeeks', Byte2String (DupeAge), -1);
               Export_Keyword (ConfigFile, 1, 'Base', FidoMsgStyle_Str [FidoMsgStyle] + ' ' + FidoMsgPath, -1);
               Export_Keyword (ConfigFile, 1, 'MaxDays', Word2String (FidoMsgAge), -1);
               Export_Keyword (ConfigFile, 1, 'MaxMsgs', Word2String (FidoMsgLimit), -1);
               Export_Keyword (ConfigFile, 1, 'DecodeFiles', Boolean2YesNo (Decode), -1);
               Export_Keyword (ConfigFile, 1, 'DecodePath', DecodePath, -1);
               Export_Keyword (ConfigFile, 1, 'Charset_FTN', CharSet_FTN, -1);
               Export_Keyword (ConfigFile, 1, 'Charset_RFC', CharSet_RFC, -1);


               Export_Keyword_NoData (ConfigFile, 0, 'EndArea', -1);
               WriteLn (ConfigFile);
          END;
     END;
END;      

{--------------------------------------------------------------------------}
{ Export_Filters                                                           }
{                                                                          }
{ Writes all of the filter definitions to the text file.                   }
{                                                                          }
PROCEDURE Export_Filters (VAR ConfigFile : TEXT);
VAR
     Offset    : LONGINT;
     Mapper    : FilterRecord;
     Temp      : STRING;

BEGIN
     WriteLn (ConfigFile);
     Export_BeginSection (ConfigFile, 'FILTER DEFINITIONS');

     IF Flex_Filter_ReadFirst (Mapper, Offset) THEN
     BEGIN
          REPEAT
               Export_Keyword_NoData (ConfigFile, 0, 'Filter', -1);

               { Build 'Search' string }
               Temp := '';
               IF ((Mapper.Limit AND mltNetmail) > 0) THEN
                    Temp := Temp + 'Net ';

               IF ((Mapper.Limit AND mltEchomail) > 0) THEN
                    Temp := Temp + 'Echo ';

               IF ((Mapper.Limit AND mltEmail) > 0) THEN
                    Temp := Temp + 'Email ';

               IF ((Mapper.Limit AND mltNews) > 0) THEN
                    Temp := Temp + 'News';

               IF (Temp = '') THEN
                    Temp := '(disabled)';

               Export_Keyword (ConfigFile, 1, 'Search', Temp, -1);

               CASE Mapper.InOut OF
                    mioInbound     : Export_Keyword (ConfigFile, 1, 'Direction', 'Inbound', -1);
                    mioOutbound    : Export_Keyword (ConfigFile, 1, 'Direction', 'Outbound', -1);
                    mioBoth        : Export_Keyword (ConfigFile, 1, 'Direction', 'Both', -1);
               END;

               Export_Keyword (ConfigFile, 1, 'Field', MapSearchWhere_Str [Mapper.Where], -1);
               Export_Keyword (ConfigFile, 1, 'Criteria', Mapper.Search, -1);

               Export_Keyword (ConfigFile, 1, 'AddNote', Boolean2YesNo (Mapper.Note), -1);
               Temp := MapActionType_Str [Mapper.Action];

               IF (Mapper.Action IN [matMove, matCopy, matSave, matBounce,
                                     matBounceAddr, matToFile]) THEN
                    Temp := Temp + ' ' + Mapper.Argument;
                              
               Export_Keyword (ConfigFile, 1, 'Action', Temp, -1);
               IF (Mapper.Action IN [matForward, matCC, matBounceAddr]) THEN
               BEGIN
                    CASE Mapper.AddrType OF
                         madFTN    : Export_Keyword (ConfigFile, 1, 'ToFTN', Mapper.ToName+'%'+
                                                                      Fido2Str (Mapper.ToAKA), -1);
                         madRFC    : Export_Keyword (ConfigFile, 1, 'ToRFC', Mapper.ToEmail, -1);
                         madRemoteGW:Export_Keyword (ConfigFile, 1, 'ToRemoteGW', Mapper.ToName+'%'+
                                                                      Fido2Str (Mapper.ToAKA)+' '+Mapper.ToEmail, -1);
                    END;
               END;


               Export_keyword_NoData (configFile, 0, 'EndFilter', -1);
               WriteLn (ConfigFile);
          UNTIL (NOT Flex_Filter_ReadNext (Mapper, Offset));
     END;
END;      

{--------------------------------------------------------------------------}
{ Export_MailingLists                                                      }
{                                                                          }
{ Writes all of the mailing list definitions to the text file.             }
{                                                                          }
PROCEDURE Export_MailingLists (VAR ConfigFile : TEXT);
VAR
     ListRec   : MailingListRecord;
     Offset    : LONGINT;
     Temp      : STRING;

     J         : ListUserRecordNrType;
     ListUser  : ListUserRecord;

BEGIN
     WriteLn (ConfigFile);
     Export_BeginSection (ConfigFile, 'MAILING LIST DEFINITIONS');

     IF Flex_MailingList_ReadFirst (ListRec, Offset) THEN
     BEGIN
          REPEAT
               WITH ListRec DO
               BEGIN
                    Export_Keyword_NoData (ConfigFile, 0, 'MailingList '+Name, -1);

                    {## check to see where this is used}
                    Export_Keyword (ConfigFile, 1, 'ListID', Word2String (ListID), -1);

                    Export_Keyword (ConfigFile, 1, 'Desc', Description, -1);

                    Export_Keyword (ConfigFile, 1, 'PrivateList', Boolean2YesNo (PrivateList), -1);
                    Export_Keyword (ConfigFile, 1, 'OnlyKnown', Boolean2YesNo (OnlyKnown), -1);
                    Export_Keyword (ConfigFile, 1, 'Passive', Boolean2YesNo (Passive), -1);

                    Export_Keyword (ConfigFile, 1, 'ListAKA', Fido2Str (Config.NodeNrs [Aka]), -1);
                    Export_Keyword (ConfigFIle, 1, 'ListDomain', Config.Domains [HomeDomain], -1);

                    IF (MLAddress = laHigher) THEN
                         Export_Keyword (ConfigFile, 1, 'ListPriority', 'High', -1)
                    ELSE
                         Export_Keyword (ConfigFile, 1, 'ListPriority', 'Low', -1);

                    Export_Keyword (ConfigFile, 1, 'NameInSubject', Boolean2YesNo (NameInSubject), -1);
                    Export_Keyword (ConfigFile, 1, 'Welcome', WelcomeFile, -1);
                    Export_Keyword (ConfigFile, 1, 'Footer', FooterFile, -1);

                    Export_Keyword (ConfigFile, 1, 'ListArea', AreaName, -1);
                    Export_Keyword (ConfigFile, 1, 'ListToArea', Boolean2YesNo (ListToArea), -1);
                    Export_Keyword (ConfigFile, 1, 'AreaToList', Boolean2YesNo (AreaToList), -1);

                    Export_Keyword (ConfigFile, 1, 'DefaultAccess', ListAccessType_Str [DefaultAccess], -1);
                    Export_Keyword (ConfigFile, 1, 'ConfirmDays', Byte2String (ConfirmInterval), -1);

                    Export_Keyword (ConfigFile, 1, 'MessageCoutner', Boolean2YesNo (UseMessageCounter), -1);
                    Export_Keyword (ConfigFile, 1, 'LastMsgNumber', Longint2String (MessageCounter), -1);

                    { Subscribers }
                    FOR J := 1 TO ListUser_RecCount DO
                    BEGIN
                         ListUser_Read (J, ListUser);

                         IF (ListUser.ListID = ListID) AND (ListUser.UserType <> lutDeleted) THEN
                         BEGIN
                              IF (ListUser.UserType = lutFTN) THEN
                              BEGIN
                                   Export_Keyword_NoData (ConfigFile, 1, 'FTNSubscriber', -1);
                                   Export_Keyword (ConfigFile, 2, 'Name', ListUser.User, -1);
                                   Export_Keyword (ConfigFile, 2, 'Address', Fido2Str (ListUser.Aka), -1);
                              END ELSE IF (ListUser.UserType = lutRFC) THEN
                              BEGIN
                                   Export_Keyword_NoData (ConfigFile, 1, 'RFCSubscriber', -1);
                                   Export_Keyword (ConfigFile, 2, 'Address', ListUser.EMail, -1);
                              END ELSE
                              BEGIN
                                   Export_Keyword_NoData (ConfigFile, 1, 'GWSubscriber', -1);
                                   Export_Keyword (ConfigFile, 2, 'Name', ListUser.User, -1);
                                   Export_Keyword (ConfigFile, 2, 'Address', Fido2Str (ListUser.Aka), -1);
                                   Export_Keyword (ConfigFile, 2, 'Email', ListUser.EMail, -1);
                              END;

                              Export_Keyword (ConfigFile, 2, 'Access', ListAccessType_Str [ListUser.Access], -1);
                              Export_Keyword (ConfigFile, 2, 'ReceiveOwnMail', Boolean2YesNo (ListUser.ReceiveOwnMail), -1);
                              Export_Keyword (ConfigFile, 2, 'Subscribed', Longint2String (ListUser.SubscribedDate), -1);
                              Export_Keyword (ConfigFile, 2, 'Confirmed', Longint2String (ListUser.ConfirmedDate), -1);

                              IF (ListUser.ConfirmState <> lcNever) THEN
                              BEGIN
                                   Temp := ListConfirmType_Str [ListUser.ConfirmState] + ' ';
                                   IF (ListUser.ConfirmState <> lcOk) THEN
                                        Temp := Temp + Longint2string (ListUser.ConfirmReqDate) + ' ' +
                                                                      Long2HexString (ListUser.ConfirmCode);
                              END ELSE
                                   Temp := ListConfirmType_Str [lcNever];

                              Export_Keyword (ConfigFile, 2, 'Confirmation', Temp, -1);

                              Export_Keyword_NoData (ConfigFile, 1, 'EndSubscriber', -1);
                              WriteLn (ConfigFile);
                         END;
                    END;

                    Export_Keyword_NoData (ConfigFile, 0, 'EndList', -1);
                    WriteLn (ConfigFile);
               END;
          UNTIL (NOT Flex_MailingList_ReadNext (ListRec, Offset));
     END;
END;      

{--------------------------------------------------------------------------}
{ ExportConfigTo                                                           }
{                                                                          }
{ Oversees the generation of the configuration text file.                  }
{                                                                          }
PROCEDURE ExportConfigTo (Filename: STRING);
VAR
     ConfigFile     : TEXT;
     Error          : BOOLEAN;
     IORes          : INTEGER;

LABEL Finished;

BEGIN
     WriteLn ('Exporting configuration to '+Filename);

     Error := FALSE;

     IF (NOT ReadConfigFile) THEN
          Error := TRUE
     ELSE IF (NOT OpenDatabases) THEN
          Error := TRUE
     ELSE IF (NOT Flex_Init) THEN
          Error := TRUE;

     IF Error THEN
     BEGIN
          CloseDatabases;
          WriteLn;
          WriteLn ('# Unable to open/create configuration files', #7);
          WriteLn;
          Halt;
     END;

     Assign (ConfigFile, Filename);
     {$I-} Rewrite (ConfigFile); IORes := IOResult; {$I+}
     IF (IORes <> 0) THEN
     BEGIN
          WriteLn ('# Disk error #', IORes, ' writing to text config file!');
          GOTO Finished;
     END;

     Export_GeneralConfig (ConfigFile);
     Export_GroupConfig (ConfigFile);
     Export_Users (ConfigFile);
     Export_Areas (ConfigFile);
     Export_Filters (ConfigFile);
     Export_MailingLists (ConfigFile);

     Close (ConfigFile);

Finished:
     Flex_Done;
     CloseDatabases;
END;

{--------------------------------------------------------------------------}
{ Usage                                                                    }
{                                                                          }
{ Displays command-line usage information.                                 }
{                                                                          }
PROCEDURE Usage;
BEGIN
     WriteLn ('Usage: TEXTCFG' +
              {$IFDEF PLATFORM_OS2}   '2'+ {$ENDIF}
              {$IFDEF PLATFORM_WIN32} 'W'+ {$ENDIF}
              ' <command> <filename>');

     WriteLn;
     WriteLn (' IMPORT <filename>      Imports configuration from <filename> into the');
     WriteLn ('                         binary database.');
     Writeln;
     WriteLn (' EXPORT <filename>      Exports configuration from binary database into');
     WriteLn ('                         the specified text file.');
END;


LABEL Finished;

BEGIN
     VerboseOutput := TRUE;

     WriteLn (FullProgramName + ' v'+FullProgramVersion);
     WriteLn (CopyrightLine);
     WriteLn;

     {$IFNDEF PLATFORM_OS2_OR_WIN32}
     {$IFOPT G+}
     { check for PC/AT or higher }
     IF (Test8086 = 0) THEN
     BEGIN
          WriteLn (FullProgramName+' requires a PC/AT (286) or higher to run');
          Halt (1);
     END;
     {$ENDIF}
     {$ENDIF}

     IF (ParamCount < 2) THEN
     BEGIN
          Usage;
          Goto Finished;
     END;

     IF ((ParamCount = 3) AND ((UpCaseString (ParamStr (3)) = '/TERSE') OR
                               (UpCaseString (ParamStr (3)) = '-TERSE'))) THEN
          VerboseOutput := FALSE;

     IF (UpCaseString (ParamStr (1)) = 'IMPORT') THEN
     BEGIN
          Writeln ('Error: IMPORT not implemented yet!');
          Goto Finished;
     END;

     IF (UpCaseString (ParamStr (1)) = 'EXPORT') THEN
     BEGIN
          ExportConfigTo (ParamStr (2));
          Goto Finished;
     END;

     Writeln ('Error: Unknown command "'+ParamStr(1)+'"!');
     Usage;
     Goto Finished;
     
Finished:
     WriteLn ('Ending ',FullProgramName,' v',FullProgramVersion);
END.

