{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT SwapMem;

{$i platform.inc}

{ deze unit bevat niet veel, maar is wel handig om cross linked units }
{ te voorkomen.                                                       }

INTERFACE

PROCEDURE StartSwapfile (Filename : STRING; MaxLen : LONGINT);
PROCEDURE StopSwapfile;
PROCEDURE EmptySwapfile;

VAR SwapIsOpen : BOOLEAN;
    SwapTopUse,
    MaxSwapLen : LONGINT;
    SwapFile   : FILE;


IMPLEMENTATION

USES Dos,
     Logs,
     Ramon,
     Globals,
     Cfg;

{---------------------------------------------------------------------------}
{ StartSwapfile                                                             }
{                                                                           }
{ Deze routine start de swapfile. Als dit niet lukt, dan wordt een          }
{ foutmelding terug gegeven. Na terugkeer is SwapFile geopend en leeg.      }
{ Er is ook gecontroleerd of het wel mogelijk de gewenste grootte van de    }
{ swapfile aan te maken.                                                    }
{                                                                           }
PROCEDURE StartSwapfile (Filename : STRING; MaxLen : LONGINT);

VAR Drive  : BYTE;
{$IFNDEF PLATFORM_WIN32}
    Df     : LONGINT;
{$ELSE}
    Df     : int64;
{$ENDIF}

    IORes  : BYTE;

    Dir    : DirStr;
    Name   : NameStr;
    Ext    : ExtStr;

    SwapMB : STRING[10];

BEGIN
     SwapMB:='('+Byte2String (Round (MaxLen/1024/1024))+'Mb)';

     Assign (SwapFile,Filename);
     {$I-} ReWrite (SwapFile,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[STARTSWAPFILE] Cannot create swapfile '+Filename);
          Exit;
     END;

     {$IFDEF LogFileIO}PostOpenF (SwapFile);{$ENDIF}

     Filename:=UNC_FExpand (Filename);
     FSplit (Filename,Dir,Name,Ext);
     Drive:=Ord (Dir[1])-Ord ('A')+1;
     Df:=DiskFree (Drive);

     IF (Df < MaxLen) THEN
     BEGIN
          LogMessage (liFatal,'Not enough space '+SwapMB+' on swap device. Disabling swapfile!');

          {$IFDEF LogFileIO}PreCloseF (SwapFile);{$ENDIF}
          Close (SwapFile);

          Erase (SwapFile);
          Exit;
     END;

     LogMessage (liTrivialLog,'Using swapfile '+UNC_FExpand (Filename)+' '+SwapMB);
     MaxSwapLen:=MaxLen;
     SwapIsOpen:=TRUE;
END;


{---------------------------------------------------------------------------}
{ StopSwapfile                                                              }
{                                                                           }
{ Deze routine sluit de file van de Swapfile weer en gooit deze weg.        }
{                                                                           }
PROCEDURE StopSwapfile;

VAR IORes : BYTE;

BEGIN
     IF (NOT SwapIsOpen) THEN
        Exit;

     IF (FileSize (SwapFile) > SwapTopUse) THEN
        SwapTopUse:=FileSize (SwapFile);

     {$IFDEF LogFileIO}PreCloseF (SwapFile);{$ENDIF}
     {$I-} Close (Swapfile); {$I+} IORes:=IOResult;
     IF (IORes = 0) THEN
     BEGIN
          {$I-} Erase (Swapfile); {$I+} IORes:=IOResult;
     END;

     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'Error removing swapfile');

     SwapIsOpen:=FALSE;
END;


{---------------------------------------------------------------------------}
{ EmptySwapfile                                                             }
{                                                                           }
{ Deze routine maakt de swapfile leeg. Dit wordt gebruikt bij MsgsEmpty.    }
{                                                                           }
PROCEDURE EmptySwapfile;

VAR IORes : BYTE;
    SFS   : LONGINT;

BEGIN
     IF (NOT SwapIsOpen) THEN
        Exit; { mag voor niets aangeroepen worden! }

     SFS:=FileSize (SwapFile);

     IF (SFS = 0) THEN
        Exit;

     IF Config.LogDebug THEN
        LogMessage (liDebug,'Emptying swapfile (now '+Longint2String (SFS)+')');

     IF (SFS > SwapTopUse) THEN
        SwapTopUse:=FileSize (SwapFile);

     {$I-} Seek (SwapFile,0); {$I+} IORes:=IOResult;
     IF (IORes = 0) THEN
     BEGIN
          {$I-} Truncate (SwapFile); {$I+} IORes:=IOResult;
     END;

     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'Error emptying swapfile');
END;


{---------------------------------------------------------------------------}
{ unit initialization                                                       }
{                                                                           }
BEGIN
     SwapIsOpen:=FALSE;
     SwapTopUse:=0;
END.
