UNIT SEAT;

{$i platform.inc}

{ all SEAT code }

INTERFACE

USES Database,
     ReadRout;

FUNCTION  SEAT_CalcBaseFilename (VAR UserRec : UserBaseRecord) : STRING;
FUNCTION  SEAT_AddFile (Filename,ToEmail : STRING) : BOOLEAN;
PROCEDURE SEAT_ProcessMessage;
PROCEDURE SEAT_SendNow;


IMPLEMENTATION

USES Ramon,
     Logs,
     Usenet,
     Msgs,
     Deliver;

{--------------------------------------------------------------------------}
{ SEAT_CalcBaseFilename                                                    }
{                                                                          }
{ This routine calculates a 8 character filename to be used for the        }
{ archives for MailTunnel and SEAT destinations. The name starts with a T  }
{ followed by a base36 representation of the CRC32 over the Organization,  }
{ Sysop Name and AKA in string format.                                     }
{                                                                          }
FUNCTION SEAT_CalcBaseFilename (VAR UserRec : UserBaseRecord) : STRING;

VAR Help : STRING;
    CRC  : LONGINT;
    N    : BYTE;
    Min  : BOOLEAN;

BEGIN
     Help:=AddUpWithSpaces (MaxLenOrganization,UserRec.Organization)+
           AddUpWithSpaces (MaxLenSysopName,UserRec.Sysop)+
           AddUpWithPre0s (5,Word2String (UserRec.Address.Zone))+
           AddUpWithPre0s (5,Word2String (UserRec.Address.Net))+
           AddUpWithPre0s (5,Word2String (UserRec.Address.Node))+
           AddUpWithPre0s (5,Word2String (UserRec.Address.Point));

     CRC:=UpdateCRC32 ($EEEEEEEE,Help[1],Length (Help));
     Min:=(CRC < 0);
     CRC:=CRC AND $7FFFFFFF;

     { convert CRC value to base36 text }

     Help:='';
     REPEAT
           N:=CRC MOD 36;
           CRC:=CRC DIV 36;

           IF (N < 10) THEN
              N:=N+Ord ('0')
           ELSE
               N:=N+Ord ('A')-10;

           Help:=Chr (N)+Help;

     UNTIL (CRC = 0);

     { altijd 6 digits max }

     IF Min THEN Help:='1'+Help;

     SEAT_CalcBaseFilename:='T'+AddUpWithPre0s (7,Help);
END;


{--------------------------------------------------------------------------}
{ SEAT_AddFile                                                             }
{                                                                          }
{ This routine moves the given file to the SEAT tranport directory and     }
{ sends it off. The routine returns TRUE if the file could not be moved to }
{ the SEAT transport directory.                                            }
{                                                                          }
FUNCTION SEAT_AddFile (Filename,ToEmail : STRING) : BOOLEAN;
BEGIN
     LogMessage (liTrivial,'Tunneling (SEAT) '+Filename+' to '+ToEMail);
     LogMessage (liFatal,'** NOT IMPLEMENTED YET; STOP USING IT **');
     SEAT_AddFile:=FALSE; { no error }
END;


{--------------------------------------------------------------------------}
{ SEAT_SendNow                                                             }
{                                                                          }
{ This routine goes through all the records and creates e-mail messages    }
{ for all the destinations, with ack/nak lines in them where saved.        }
{                                                                          }
PROCEDURE SEAT_SendNow;

VAR Regel : STRING;

BEGIN
     (*
     RFC_StartSingleRecipientMessage (TunnelPtr^.EmailAddress, { to e-mail }
                                      'seat-server', { from e-mail }
                                      'WaterGate SEAT Server', { from name }
                                      'FTN Mail Transport'); { subject }

     {
     Ftn-File: AA3D1EAC.TH0
     Ftn-File-Id: AA3D1EAC.TH0.876796006.50DC7A2B
     Ftn-Date: 876796006
     Ftn-Crc32: 50DC7A2B
     Ftn-Encoding: uuencode
     Ftn-Seg: 1-1
     Ftn-Seg-Id: 50DC7A2B-1-1-brents@sk.sympatico.ca
     Ftn-Seg-Crc32: 50DC7A2B
     }

     MsgsAddLineTo (Body,'Ftn-File: '+Filename);
     MsgsAddLineTo (Body,'Ftn-File-Id: '+Filename+'...'+Long2HexString (0));
     MsgsAddLineTo (Body,'Ftn-Crc32: '+Long2HexString (0));
     MsgsAddLineTo (Body,'Ftn-Encoding: uuencode');
     MsgsAddLineTo (Body,'Ftn-Seg: 1-1');
     MsgsAddLineTo (Body,'Ftn-Seg-Id: '+Filename+Long2HexString (0)+'-1-1');
     MsgsAddLineTo (Body,'Ftn-Seg-Crc32: '+Long2HexString (0));

     DeliverNow (NILRecordNr{System Sends});
     *)
END;


{--------------------------------------------------------------------------}
{ SEAT_ProcessMsg                                                          }
{                                                                          }
{ This routine is called to process a received message, addressed to the   }
{ SEAT address and with a proper subject.                                  }
{                                                                          }
PROCEDURE SEAT_ProcessMessage;
BEGIN
END;

END.
