{--------------------------------------------------------------------------}
{ Export.Pas                                                               }
{                                                                          }
{ Routines om een complete WaterGate config naar een ASCII file op disk    }
{ te converteren, en weer terug te lezen.                                  }
{                                                                          }
{ MD 05/07/94 Eerste opzet                                                 }

UNIT CfgExport;

INTERFACE

USES Database,
     Cfg,
     AreaMgr;

TYPE  Exp_Array_Name = ( Exp_Section ,           Exp_Section_Config,     Exp_Sysop,              Exp_SystemDir,
                         Exp_DoDupeCheck,        Exp_DupeChecks,         Exp_MaxHandles,         Exp_TimeZone,
                         Exp_CacheTdbs,          Exp_ToolargePath,       Exp_LogFilePath,        Exp_NodeNr,
                         Exp_Inbound,            Exp_Outbound,           Exp_Comp_Arc,           Exp_Comp_Arj,
                         Exp_Comp_Lzh,           Exp_Comp_PAK,           Exp_Comp_ZIP,           Exp_Comp_ZOO,
                         Exp_Comp_OPT,           Exp_DeComp_Arc,         Exp_DeComp_Arj,         Exp_DeComp_Lzh,
                         Exp_DeComp_PAK,         Exp_DeComp_ZIP,         Exp_DeComp_ZOO,         Exp_DeComp_GUS,
                         Exp_MaxFidoMsgLen,      Exp_MaxFidoArcLen,      Exp_FidoSystem,         Exp_AcceptTo,
                         Exp_FidoNetmailType,    Exp_FidoNetmaiLPath,    Exp_FIdoBadAreaType,    Exp_FidoBadPath,
                         Exp_FidoDupeAreaType,   Exp_FidoDupePath,       Exp_FidoAutoCreateType, Exp_DefaultFidoMsgPath,
                         Exp_StripSeenBy,        Exp_AutoLink,           Exp_ReplaceTear,        Exp_ReplyKludges,
                         Exp_DefNumbToKeep_F,    Exp_DefDaysToKeep_F,    Exp_FidoArcmailExten,   Exp_UUCPGATEWAY,
                         Exp_NameSeparator,      Exp_UseGateFields,      Exp_GateWayUser,        Exp_Origins,
                         Exp_WorldWide,          Exp_DefGroups_U,        Exp_SpoolBaseDir,       Exp_MaxDatLength,
                         Exp_SmartHost,          Exp_UUCPName,           Exp_BackBone,           Exp_Organization,
                         Exp_Compress,           Exp_GZIP,               Exp_UnCompress,         Exp_UnGZIP,
                         Exp_PrivMailType,       Exp_PrivMaiLPath,       Exp_PrivMaiLOption,     Exp_MaxSquishMsgLen,
                         Exp_MaxJAMMsgLen,       Exp_DefaultCompressor );

    SUB_AFIX_F_NAME   =  ( SUB_AFIX_UPLINKADDRESS, SUB_AFIX_F_UNCONDITIONAL, SUB_AFIX_F_AREALISTPATH, SUB_AFIX_F_AREALIST,
                           SUB_AFIX_F_AREAMANAGER, SUB_AFIX_F_PASSWORD     , SUB_AFIX_F_GROUP       , SUB_AFIX_F_ADDPLUS );

    SUB_AFIX_U_NAME   =  ( SUB_UFIX_UUCPNAME     , SUB_UFIX_AREALISTPATH );

CONST Exp_Array : ARRAY [ Exp_Array_Name ] OF STRING[20] = (

                  'SECTION           ' , 'CONFIGURATION     ' ,  'SYSOP             ' , 'SYSTEMDIR         ' ,
                  'DODUPECHECK       ' , 'DUPECHECKS        ' ,  'MAXHANDLES        ' , 'TIMEZONE          ' ,
                  'CACHE             ' , 'TOOLARGEPATH      ' ,  'LOGFILEPATH       ' , 'NODENR            ' ,
                  'INBOUND           ' , 'OUTBOUND          ' ,  'COMP_ARC          ' , 'COMP_ARJ          ' ,
                  'COMP_LZH          ' , 'COMP_PAK          ' ,  'COMP_ZIP          ' , 'COMP_ZOO          ' ,
                  'COMP_OPT          ' , 'DECOMP_ARC        ' ,  'DECOMP_ARJ        ' , 'DECOMP_LZH        ' ,
                  'DECOMP_PAK        ' , 'DECOMP_ZIP        ' ,  'DECOMP_ZOO        ' , 'DECOMP_GUS        ' ,
                  'MAXFIDOMSGLEN     ' , 'MAXFIDOARCLEN     ' ,  'FIDOSYSTEM        ' , 'ACCEPTTO          ' ,
                  'FIDONETMAILTYPE   ' , 'FIDONETMAILPATH   ' ,  'FIDOBADAREATYPE   ' , 'FIDOBADPATH       ' ,
                  'FIDODUPEAREATYPE  ' , 'FIDODUPEPATH      ' ,  'FIDOAUTOCREATETYPE' , 'DEFAULTFIDOMSGPATH' ,
                  'STRIPSEENBY       ' , 'AUTOLINK          ' ,  'REPLACETEAR       ' , 'REPLYKLUDGES      ' ,
                  'DEFNUMBTOKEEP     ' , 'DEFDAYSTOKEEP     ' ,  'FIDOARCMAILEXT    ' , 'UUCPGATEWAY       ' ,
                  'NAMESEPARATOR     ' , 'USEGATEFIELDS     ' ,  'GATEWAYUSER       ' , 'ORIGINS           ' ,
                  'WORLDWIDE         ' , 'DEFGROUPS_U       ' ,  'SPOOLBASEDIR      ' , 'MAXDATLENGTH      ' ,
                  'SMARTHOST         ' , 'UUCPNAME          ' ,  'BACKBONE          ' , 'ORGANIZATION      ' ,
                  'COMPRESS          ' , 'GZIP              ' ,  'UNCOMPRESS        ' , 'UNGZIP            ' ,
                  'PRIVMAILTYPE      ' , 'PRIVMAILPATH      ' ,  'PRIVMAILOPTION    ' , 'MAXSQUISHMSGLEN   ' ,
                  'MAXJAMMSGLEN      ' , 'DEFAULTCOMPRESSOR ' );

       Sub_AFIX_F : ARRAY [ SUB_AFIX_F_NAME ] OF STRING[20] =
                    ( 'UPLINKADDRESS ' , 'UNCONDITIONAL     ' ,  'AREALISTPATH      ' , 'AREALIST          ' ,
                      'AREAMANAGER   ' , 'PASSWORD          ' ,  'GROUP             ' , 'ADDPLUS           ' );

       Sub_AFIX_U : ARRAY [ SUB_AFIX_U_NAME ] OF STRING[20] =
                    ( 'UUCPNAME      ' , 'AREALISTPATH      ' );

       BaseStr    : Array[ FidoMsgStyleType ] OF String[ 10 ] =
                    ( 'NONE' , 'FIDO' , 'SQUISH' , 'JAM');

       ReplyKludge: Array[ ReplyKludgeType ] OF String[20] =
                    ( 'FSC35' ,'SENDER_IN_BODY' , 'SENDER_IN_HEADER' , 'SENDER_IN_BODY_AND_HEAD');

       ArcExten   : Array[ ArcType ]  OF STRING[10] =
                    ( 'ARCMAIL' , 'HEX' ,'ALL' );

       PrivMailStr: Array[ PrivateMailType ] OF STRING[10] =
                    ( 'FROM' ,'TO','SUBJECT' );

       AreaListStr: Array [AreaListType] OF STRING[10] =
                    ( 'AREASBBS' ,'LIST');

PROCEDURE WriteConfiguration( FileName : String );

IMPLEMENTATION

USES Globals,
     Fido;

PROCEDURE WriteConfiguration( FileName : String );
VAR TargetFile : Text;
    Lp         : Byte;


  PROCEDURE SUBSECTION_AREAFIX_F( AF : AreafixForwardRecord );
   BEGIN
    WITH AF DO
      IF AF.UplinkAddress.Zone <> 0 THEN
      BEGIN
      Writeln( TargetFile );
      Writeln( TargetFile , 'SUB-SECTION FIDO-AREAFIX' );
      Writeln( TargetFile );
      Writeln( TargetFile , Sub_AFIX_F[SUB_AFIX_UPLINKADDRESS   ] , Fido2Str( UplinkAddress ));
      Writeln( TargetFile , Sub_AFIX_F[SUB_AFIX_F_UNCONDITIONAL ] , Unconditional );
      Writeln( TargetFile , Sub_AFIX_F[SUB_AFIX_F_AREALISTPATH  ] , Arealistpath  );
      Writeln( TargetFile , Sub_AFIX_F[SUB_AFIX_F_AREALIST      ] , AreaListStr[AreaList] );
      Writeln( TargetFile , Sub_AFIX_F[SUB_AFIX_F_AREAMANAGER   ] , AreaManager );
      Writeln( TargetFile , Sub_AFIX_F[SUB_AFIX_F_PASSWORD      ] , Password    );
      Writeln( TargetFile , Sub_AFIX_F[SUB_AFIX_F_GROUP         ] , Ord( Group ));
      Writeln( TargetFile , Sub_AFIX_F[SUB_AFIX_F_ADDPLUS       ] , AddPlus );
      Writeln( TargetFile );
      Writeln( TargetFile , 'END-SUBSECTION');
      Writeln( TargetFile );
     END;
    END;

   PROCEDURE SubSection_Areafix_U( UF : UsenetForwardRecord );
   BEGIN
    WITH UF DO
      IF UF.UUCPNAME <> '' THEN
      BEGIN
      Writeln( TargetFile );
      Writeln( TargetFile , 'SUB-SECTION USENET-AREAFIX' );
      Writeln( TargetFile );
      Writeln( TargetFile , Sub_AFIX_U[SUB_UFIX_UUCPNAME    ] , UUCPNAME );
      Writeln( TargetFile , Sub_AFIX_U[SUB_UFIX_AREALISTPATH] , ArealistPath );
      Writeln( TargetFile );
      Writeln( TargetFile , 'END-SUBSECTION');
      Writeln( TargetFile );
     END;
    END;





BEGIN

 Assign( TargetFile , FileName );
 {$I-} Rewrite( TargetFile ); {$I+}
 PeekFiles;

 { Schrijf de hoofd configuratie keyword voor keyword naar disk }

 { -- Header                                               }
 Writeln( TargetFile , ';' );
 Writeln( TargetFile , '; ', DesktopProgramName            );
 Writeln( TargetFile , '; version ' ,DesktopProgramVersion );
 Writeln( TargetFile , '; date    ' ,FidoCurrTime2Str      );
 Writeln( TargetFile , ';' );
 Writeln( TargetFile , ';' );

 { Begin van de SECTION Configuration                      }

 WITH Config DO
 BEGIN
  Writeln( TargetFile , Exp_Array[Exp_Section] , Exp_Array[Exp_Section_Config ]);
  Writeln( TargetFile , ';' );

  Writeln( TargetFile , Exp_Array[Exp_Sysop         ] , ' ', Sysop     );
  Writeln( TargetFile , ';' );
  Writeln( TargetFile , Exp_Array[Exp_SystemDir     ] , ' ', SystemDir );
  Writeln( TargetFile , Exp_Array[Exp_ToolargePath  ] , ' ', ToolargePath );
  Writeln( TargetFile , Exp_Array[Exp_LogFilePath   ] , ' ', LogFilePath  );
  Writeln( TargetFile , ';' );
  Writeln( TargetFile , Exp_Array[Exp_MaxHandles    ] , ' ', MaxHandles );
  Writeln( TargetFile , Exp_Array[Exp_CacheTdbs     ] , ' ', CacheTdbs);
  Writeln( TargetFile , Exp_Array[Exp_DoDupeCheck   ] , ' ', DoDupeChk );
  Writeln( TargetFile , Exp_Array[Exp_DupeChecks    ] , ' ', DupeChecks);


  Writeln( TargetFile , '; ' );
  Writeln( TargetFile , '; Up to 20 Aka''s can be defined' );
  Writeln( TargetFile , '; ' );

  FOR Lp := 1 TO MaxAkas DO
   IF NodeNrs[Lp].Zone <> 0 THEN
    IF PointNets[Lp] <> 0 THEN
     Writeln( TargetFile , Exp_Array[Exp_NodeNr        ] , ' ', Fido2Str( NodeNrs[Lp] ) ,',',PointNets[Lp])
    ELSE
     Writeln( TargetFile , Exp_Array[Exp_NodeNr        ] , ' ', Fido2Str( NodeNrs[Lp] ) );

    Writeln( TargetFile , ';');
    Writeln( TargetFile , '; General Fido settings');
    Writeln( TargetFile , ';');

    Write  ( TargetFile , Exp_Array[Exp_FidoSystem     ] , ' ' );
    CASE FidoSystem OF
     stBinkley   : Writeln( TargetFile , 'BINKLEY'   );
     stFrontdoor : Writeln( TargetFile , 'FRONTDOOR' );
    END;

    FOR Lp := 1 TO MaxOrigins DO
     IF Origins[Lp] <> '' THEN
      Writeln( TargetFile , Exp_Array[Exp_Origins           ] , ' ' , Origins[Lp] );

{  FOR Lp := 1 TO MaxInboundDirs DO
    Writeln( TargetFile , Exp_Array[Exp_Inbound        ] , ' ', Inbound_F[Lp] , ',' , Security_F[Lp] ); }

    Writeln( TargetFile , Exp_Array[Exp_Outbound       ] , ' ', Outbound_F );
    Writeln( TargetFile , Exp_Array[Exp_FidoNetmailType   ] , ' ' , BaseStr[ FidoNetmaiLType ] );
    Writeln( TargetFile , Exp_Array[Exp_FidoNetmaiLPath   ] , ' ' , FidoNetmaiLPath );
    Writeln( TargetFile , Exp_Array[Exp_FIdoBadAreaType   ] , ' ' , BaseStr[ FidoBadAreaType ] );
    Writeln( TargetFile , Exp_Array[Exp_FidoBadPath       ] , ' ' , FidoBadPath );
    Writeln( TargetFile , Exp_Array[Exp_FidoDupeAreaType  ] , ' ' , BaseStr[ FidoDupeAreaType] );
    Writeln( TargetFile , Exp_Array[Exp_FidoDupePath      ] , ' ' , FidoDupePath );
    Writeln( TargetFile , Exp_Array[Exp_FidoAutoCreateType] , ' ' , BaseStr[ FidoAutoCreateType] );
    Writeln( TargetFile , Exp_Array[Exp_DefaultFidoMsgPath] , ' ' , defaultFidoMsgPath );
    Writeln( TargetFile , Exp_Array[Exp_ReplaceTear       ] , ' ' , ReplaceTear );
    Writeln( TargetFile , Exp_Array[Exp_FidoArcmailExten  ] , ' ' , ArcExten[ FidoArcMailExtension ] );

    Writeln( TargetFile , ';' );
    Writeln( TargetFile , '; Fido Compression Programs' );
    Writeln( TargetFile , ';' );

    Writeln( TargetFile , Exp_Array[Exp_Comp_Arc       ] , ' ', ComprPrgs_F[Compr,ARC] );
    Writeln( TargetFile , Exp_Array[Exp_Comp_Arj       ] , ' ', ComprPrgs_F[Compr,ARJ] );
    Writeln( TargetFile , Exp_Array[Exp_Comp_Lzh       ] , ' ', ComprPrgs_F[Compr,LZH] );
    Writeln( TargetFile , Exp_Array[Exp_Comp_PAK       ] , ' ', ComprPrgs_F[Compr,PAK] );
    Writeln( TargetFile , Exp_Array[Exp_Comp_ZIP       ] , ' ', ComprPrgs_F[Compr,ZIP] );
    Writeln( TargetFile , Exp_Array[Exp_Comp_ZOO       ] , ' ', ComprPrgs_F[Compr,ZOO] );
    Writeln( TargetFile , Exp_Array[Exp_Comp_OPT       ] , ' ', ComprPrgs_F[Compr,OP1] );

    Writeln( TargetFile , Exp_Array[Exp_DeComp_Arc     ] , ' ', ComprPrgs_F[DeCompr,ARC] );
    Writeln( TargetFile , Exp_Array[Exp_DeComp_Arj     ] , ' ', ComprPrgs_F[DeCompr,ARJ] );
    Writeln( TargetFile , Exp_Array[Exp_DeComp_Lzh     ] , ' ', ComprPrgs_F[DeCompr,LZH] );
    Writeln( TargetFile , Exp_Array[Exp_DeComp_PAK     ] , ' ', ComprPrgs_F[DeCompr,PAK] );
    Writeln( TargetFile , Exp_Array[Exp_DeComp_ZIP     ] , ' ', ComprPrgs_F[DeCompr,ZIP] );
    Writeln( TargetFile , Exp_Array[Exp_DeComp_ZOO     ] , ' ', ComprPrgs_F[DeCompr,ZOO] );
    Writeln( TargetFile , Exp_Array[Exp_DeComp_GUS     ] , ' ', ComprPrgs_F[DeCompr,GUS] );
    Writeln( TargetFile , Exp_Array[Exp_DefaultCompressor],' ', PackedAddresses );

    Writeln( TargetFile , ';');
    Writeln( TargetFile , '; Message split settings');
    Writeln( TargetFile , ';');

    Writeln( TargetFile , Exp_Array[Exp_MaxFidoMsgLen  ] , ' ', MaxFidoMsgLen );
    Writeln( TargetFile , Exp_Array[Exp_MaxFidoArcLen  ] , ' ', MaxFidoArcLen );
    WriteLn( TargetFile , Exp_Array[Exp_MaxSquishMsgLen] , ' ', MaxSquishMsgLen );
    WriteLn( TargetFile , Exp_Array[Exp_MaxJAMMsgLen   ] , ' ', MaxJAMMsgLen  );

    Writeln( TargetFile , ';');
    Writeln( TargetFile , '; Message base default settings');
    Writeln( TargetFile , ';');

    Writeln( TargetFile , Exp_Array[Exp_DefNumbToKeep_F   ] , ' ' , DefNumbToKeep_F );
    Writeln( TargetFile , Exp_Array[Exp_DefDaysToKeep_F   ] , ' ' , DefDaysToKeep_F );
    Writeln( TargetFile , Exp_Array[Exp_StripSeenBy       ] , ' ' , StripSeenBy );
    Writeln( TargetFile , Exp_Array[Exp_AutoLink          ] , ' ' , AutoLink    );

    Writeln( TargetFile , ';');
    Writeln( TargetFile , '; General UUCP settings');
    Writeln( TargetFile , ';');


    Writeln( TargetFile   , Exp_Array[Exp_UUCPName          ] , ' ' , UUCPName     );
    Writeln( TargetFile   , Exp_Array[Exp_Organization      ] , ' ' , Organization );
    Writeln( TargetFile   , Exp_Array[Exp_SpoolBaseDir      ] , ' ' , SpoolBaseDir );
    Writeln( TargetFile   , Exp_Array[Exp_BackBone          ] , ' ' , BackBone     );
    Writeln( TargetFile   , Exp_Array[Exp_SmartHost         ] , ' ' , Smarthost    );
    Writeln( TargetFile   , Exp_Array[Exp_WorldWide         ] , ' ' , WorldWide   );
{   Writeln( TargetFile   , Exp_Array[Exp_DefGroups_U       ] , ' ' , GetGroups( DefGroups_U )); }
    Writeln( TargetFile   , Exp_Array[Exp_MaxDatLength      ] , ' ' , MaxDatLength );
    Writeln( TargetFile   , Exp_Array[Exp_Compress          ] , ' ' , ComprPrg_U[Compress, Compr ] );
    Writeln( TargetFile   , Exp_Array[Exp_GZIP              ] , ' ' , ComprPrg_U[GZIP    , Compr ] );
    Writeln( TargetFile   , Exp_Array[Exp_UnCompress        ] , ' ' , ComprPrg_U[Compress, DeCompr ] );
    Writeln( TargetFile   , Exp_Array[Exp_UnGZIP            ] , ' ' , ComprPrg_U[GZIP    , DeCompr ] );

    {Groups}
    Writeln( TargetFile , ';');
    Writeln( TargetFile , '; Gateway settings');
    Writeln( TargetFile , ';');

    Writeln( TargetFile , Exp_Array[Exp_TimeZone          ] , ' ' , TimeZone );
    Writeln( TargetFile , Exp_Array[Exp_UUCPGATEWAY       ] , ' ' , Fido2Str( NodeNrs[ UUCPGateWay ] ) );
    Writeln( TargetFile , Exp_Array[Exp_NameSeparator     ] , ' ' , NameSeparator );
{    Writeln( TargetFile , Exp_Array[Exp_UseGateFields     ] , ' ' , GetUseGateFields( UseGateFields )); }
    Writeln( TargetFile , Exp_Array[Exp_AcceptTo          ] , ' ' , FidoAcceptTo );
    Writeln( TargetFile , Exp_Array[Exp_GateWayUser       ] , ' ' , GatewayUser );
    Writeln( TargetFile , Exp_Array[Exp_ReplyKludges      ] , ' ' , ReplyKludge[ ReplyKludges ] );

    Writeln( TargetFile , ';');
    Writeln( TargetFile , '; Private mail settings');
    Writeln( TargetFile , ';');

    Writeln( TargetFile   , Exp_Array[Exp_PrivMailType      ] , ' ' , BaseStr[ PrivMaiLType ] );
    Writeln( TargetFile   , Exp_Array[Exp_PrivMaiLPath      ] , ' ' , PrivMaiLPath );

    FOR Lp:=1 TO MaxPrivMaiL DO
        IF (PrivMailOption[Lp] <> '') THEN
           WriteLn (TargetFile,Exp_Array[Exp_PrivMaiLOption],' ',
                               PrivMailOption[Lp],',',
                               PrivMailStr[PrivMailSelect[Lp]]);

    Writeln( TargetFile , ';');
    Writeln( TargetFile , '; Fido Areafix Forward settings');
    Writeln( TargetFile , ';');

    FOR Lp := 1 TO MaxAreaFixFwd DO
     SubSection_Areafix_F( AreaFixForward[Lp] );

    Writeln( TargetFile , ';');
    Writeln( TargetFile , '; Usenet Areafix Forward settings');
    Writeln( TargetFile , ';');

    FOR Lp := 1 TO MaxAreaFixFwd DO
     SubSection_Areafix_U( UsenetForward[Lp] );

{    SubSection_ConversionTable( ConversionTable ); }

    END; {With}

    Close( TargetFile );
    PeekFiles;

END;


END.

