UNIT Ramon;

{ kan niet in een overlay ivm desk10.obj die voor near gecompileerd is }

{$F-}  { Don't force far-calls }
{$A+}  { Word-align data }
{$IFOPT B+}  ### DISABLE Complete Boolean Evaluation! ### {$ENDIF}
{$I+}  { I/O checking ON }
{$P-}  { No open parameters }
{$T-}  { No pointer type-checking }
{$V-}  { No strict var strings }
{$X+}  { Extended syntax ON }

{$I platform.inc}

{==========================================================================}
{ (c) Copyright Waterline Software Developent V.O.F. 1990-1996             }
{                                                                          }
{    Waterline Software Development V.O.F.                                 }
{    Wouter Sluislaan 12                                                   }
{    1461 AC  Zuidoostbeemster                                             }
{    The Netherlands                                                       }
{                                                                          }
{ It not allowed to use this user interface in any program not owned by    }
{ the Waterline Software Development V.O.F.                                }
{ Special conditions apply to programs distributed by the Waterline        }
{ Software Development V.O.F. If the source code of any of these programs  }
{ is distributed as well, it is NOT allowed to use the user interface in   }
{ your own programs. Violators may be prosecuted!                          }
{                                                                          }
{ Please contact the Waterline Software Development V.O.F. at the above    }
{ address for your licence to use the "Ramon" user interface. You will get }
{ the most recent copy of the "Ramon" user interface and the "Ramon" user  }
{ interface expert for free. This program helps you design your user       }
{ interfaces at an instance.                                               }
{                                                                          }
{ This copyright notice should remain in this file and all files that are  }
{ part of the user interface "Ramon".                                      }
{==========================================================================}

{ Ramon zijn eigen routines }

{ History:

  171094: Desqview support ingebouwd.
  211094: Begonnen met deze history.
          Alle mouse-related zaken eruit gesloopt en file gedelete.
          List type toegevoegd voor dynamische lijsten en vervanging van
          Select lijsten.
  231094: DeleteFrontAndBackSpaces en assembly voor versnelling.
          (zie utility.inc history).
}

INTERFACE

{ $DEFINE ShowMemAvail}
{ zet een $ voor DEFINE voor afdruk MemAvail in ReadKey wachtlus }

{$DEFINE DateTimeStamp}
{ zet een $ voor DEFINE om de compilatie datum en tijd in de .EXE te laten }
{ zetten bij de eerste opstart van de .EXE file.                           }

{ de volgende constante wordt aangepast als het programma opgestart wordt  }
{ en wordt dan gevult met de huidige datum en tijd op dat moment. Dit kan  }
{ handig zijn voor 'About' meldingen die dan ook even de compilatie datum  }
{ en tijd laten zien.                                                      }
{ Dit KAN ellende geven met Virus Scanners...                              }
CONST CompileDateAndTimeLen = 19;

{$IFDEF Release}
      {$UNDEF DateTimeStamp}
      CompileDateAndTime : STRING[CompileDateAndTimeLen] = '29/01/1998 20:45:00';
                                                           {DD/MM/YYYY HH:MM:SS}
{$ELSE}
      CompileDateAndTime : STRING[CompileDateAndTimeLen] = 'COMPILE DATE & TIME';
                                                           {DD/MM/YYYY HH:MM:SS}
{$ENDIF}

{ $DEFINE CtrlF11IsScreenTextDump}
{ Als deze actief is kan met Ctrl+F11 een dump van het hele scherm naar }
{ de file APPSCRN.TXT gemaakt worden.                                   }

{ $DEFINE CtrlF12IsScreenDump}
{ Als deze actief is kan met Ctrl+F12 een dump van het hele scherm naar }
{ de file APPSCRN.DMP gemaakt worden voor de Application Expert.        }

{$DEFINE NoScrSaver}

{ $IFNDEF OS2}
{ $DEFINE DesqView}  { support for desqview when not under OS/2 }
{ $ENDIF}

{ Als deze actief is, dan wordt er rekening gehouden met DesqView. Dit is }
{ vereist voor WtrGate om slices vrij te kunnen geven en een buffer adres }
{ voor direct video writes op te kunnen vragen.                           }

{ $DEFINE UseIdleRoutine }
{ Zet een $ voor DEFINE als je bij de ReadKey routine tijdens het wachten  }
{ de idle routine wilt laten aanroepen. Meestal niet gewenst omdat         }
{ je dan teveel tijd snoept van programma's als OS/2, DesqView etc.        }

{$DEFINE F1IsHelp}
{ Als deze actief is, dan wordt bij alle keys lines ' ^F1 Help ' toegevoegd }

{=== KeysLines ============================================================}

{$IFDEF F1IsHelp}
CONST F1Help = ' ^F1 Help ';
{$ELSE}
CONST F1Help = '';
{$ENDIF}

{ maar een van de talen tegelijkertijd actief laten zijn! }
{ de nederlandse versie } {
CONST ORG_HelpKeysLine        = ' ^Esc Verlaat Help';
      ORG_MenuKeysLine        = F1Help+' ^Esc Terug  ^'#24#25' Kiezen  ^Enter Selecteren';
      ORG_FieldSelectKeysLine = F1Help+' ^Esc Terug  ^'#24#25' Kiezen  ^Enter Edit';
      ORG_FieldEditKeysLine   = F1Help+' ^Esc Terug  ^Enter Einde  ^Ctrl+End Wissen  ^Ins~ert aan/uit  ^Del~ete';
      ORG_SelectNoTagKeysLine = F1Help+' ^Esc Terug  ^'#24#25' Kiezen  ^Enter Selecteren';
      ORG_SelectTagKeysLine   = F1Help+' ^Esc Terug  ^'#24#25' Kiezen  ^Enter Selecteren  ^F5,6,7 (Un)tag (all)';
      ORG_ErrorKeysLine       = ' ^Esc Doorgaan';
}

{ de engelse versie }
CONST ORG_HelpKeysLine        = ' ^Esc Leave Help';
      ORG_MenuKeysLine        = F1Help+' ^Esc Return  ^'#24#25' Select  ^Enter Accept';
      ORG_FieldSelectKeysLine = F1Help+' ^Esc~,^F10 Return  ^'#24#25' Select  ^Enter Edit';
      ORG_FieldEditKeysLine   = F1Help+' ^Esc Restore old  ^Enter Accept  ^Ctrl+End Clear rest  ^F3 File Manager';
      ORG_ListNoTagKeysLine   = F1Help+' ^Esc Return  ^'#24#25' Select  ^Enter Accept';
      ORG_ListTagKeysLine     = F1Help+' ^Esc Return  ^'#24#25' Select  ^Enter Accept  ^F5,6,7 (Un)tag (all)';
      ORG_ErrorKeysLine       = ' ^Esc Continue';
      ORG_OnlineHelpKeysLine  = ' ^Esc Back  ^F1 Help on Help  ^Ctrl+F Search  ^F2 Global search  ^Enter Follow link';

{ STRING[100] is genoeg voor maximaal een scherm van 80 tekens }
{ breed plus nog eens 10 tekens voor ^ en ~ controletekens.    }

{ overnemen van de default }
CONST HelpKeysLine        : STRING[40] = ORG_HelpKeysLine;
      MenuKeysLine        : STRING[100] = ORG_MenuKeysLine;
      FieldSelectKeysLine : STRING[100] = ORG_FieldSelectKeysLine;
      FieldEditKeysLine   : STRING[100] = ORG_FieldEditKeysLine;
      ListTagKeysLine     : STRING[100] = ORG_ListTagKeysLine;
      ListNoTagKeysLine   : STRING[100] = ORG_ListNoTagKeysLine;
      ErrorKeysLine       : STRING[40] = ORG_ErrorKeysLine;
      OnlineHelpKeysLine  : STRING[90] = ORG_OnlineHelpKeysLine;
{$IFNDEF NoScrSaver}
      ScreenSaverMsg      : STRING[50]  = 'Screen Saver active, press any key';
{$ENDIF}

{=== Conversion Routines ==================================================}

{$IFDEF PLATFORM_OS2}
TYPE HexByteString = STRING;  { 00..FF }
     HexWordString = STRING;  { 0000..FFFF }
     HexLongString = STRING;  { 00000000..FFFFFFFF }
     ByteString    = STRING;  { 0..255 }
     IntegerString = STRING;  { -32768..32767 }
     WordString    = STRING;  { 0..65535 }
     LongintString = STRING;  { -2147483648..2147483647 }
     RealString    = STRING;  { 123456789.1234567890 of 1.123456789012345678 etc. }
     BinByteString = STRING;  { 00000000..11111111 }
     BinLongString = STRING;  { 00000000000000000000000000000000..11111111111111111111111111111111 }
     NrString      = STRING;  { -2.147.483.648..2.147.483.647 }
     ValNop        = LONGINT;
     {$IFNDEF FPC}
     WordLong      = LONGINT;
     {$ELSE}
     SmallWord     = WORD;
     WordLong      = WORD;
     {$ENDIF}
     ValErrType    = LONGINT;
{$ENDIF}
{$IFDEF PLATFORM_WIN32}
TYPE HexByteString = STRING[2];  { 00..FF }
     HexWordString = STRING[4];  { 0000..FFFF }
     HexLongString = STRING[8];  { 00000000..FFFFFFFF }
     ByteString    = STRING[3];  { 0..255 }
     IntegerString = STRING[6];  { -32768..32767 }
     WordString    = STRING[5];  { 0..65535 }
     LongintString = STRING[11]; { -2147483648..2147483647 }
     RealString    = STRING[20]; { 123456789.1234567890 of 1.123456789012345678 etc. }
     BinByteString = STRING[8];  { 00000000..11111111 }
     BinLongString = STRING[32]; { 00000000000000000000000000000000..11111111111111111111111111111111 }
     NrString      = STRING[14]; { -2.147.483.648..2.147.483.647 }
     ValNop        = INTEGER;
     ValErrType    = INTEGER;
     WordLong      = WORD;
{$ENDIF}
{$IFDEF PLATFORM_DOS_ALL}
TYPE HexByteString = STRING[2];  { 00..FF }
     HexWordString = STRING[4];  { 0000..FFFF }
     HexLongString = STRING[8];  { 00000000..FFFFFFFF }
     ByteString    = STRING[3];  { 0..255 }
     IntegerString = STRING[6];  { -32768..32767 }
     WordString    = STRING[5];  { 0..65535 }
     LongintString = STRING[11]; { -2147483648..2147483647 }
     RealString    = STRING[20]; { 123456789.1234567890 of 1.123456789012345678 etc. }
     BinByteString = STRING[8];  { 00000000..11111111 }
     BinLongString = STRING[32]; { 00000000000000000000000000000000..11111111111111111111111111111111 }
     NrString      = STRING[14]; { -2.147.483.648..2.147.483.647 }
     ValNop        = INTEGER;
     ValErrType    = INTEGER;
     WordLong      = WORD;
{$ENDIF}

FUNCTION Byte2HexString (Getal : BYTE) : HexByteString;
FUNCTION Word2HexString (Getal : WORD) : HexWordString;
FUNCTION Long2HexString (Getal : LONGINT) : HexLongString;
FUNCTION HexString2Long (HexStr : STRING) : LONGINT;
FUNCTION Byte2String (Getal : BYTE) : ByteString;
FUNCTION Integer2String (Getal : INTEGER) : IntegerString;
FUNCTION SignedInteger2String (Getal : INTEGER) : IntegerString;
FUNCTION Word2String (Getal : WORD) : WordString;
FUNCTION Longint2String (Getal : LONGINT) : LongintString;
FUNCTION Real2String (Getal : REAL; SumDigits,Decimals : BYTE) : RealString;
FUNCTION Byte2BinString (Getal : BYTE) : BinByteString;
FUNCTION Longint2BinString (Getal : LONGINT) : BinLongString;
FUNCTION Word2BinString (Getal: Word): BinLongString;
FUNCTION Longint2NrString (Getal : LONGINT) : NrString;
FUNCTION Ptr2Long (X : POINTER) : LONGINT;
FUNCTION Long2Ptr (L : LONGINT) : POINTER;
FUNCTION Boolean2YesNo (B : BOOLEAN) : STRING;


{=== Utility Routines =====================================================}

CONST MAXTIMER = 1573039;

FUNCTION  RepChar (Aantal : BYTE; Teken : CHAR) : STRING;
FUNCTION  Spaces (Aantal : BYTE) : STRING;
FUNCTION  AddUpWithSpaces (Len : BYTE; Tekst : STRING) : STRING;
FUNCTION  AddUpWithSpacesNoCut (Len : BYTE; Tekst : STRING) : STRING;
FUNCTION  DeleteBackSpaces (Tekst : STRING) : STRING;
FUNCTION  DeleteBackNulls (Tekst : STRING) : STRING;
FUNCTION  DeleteFrontSpaces (Tekst : STRING) : STRING;
FUNCTION  DeleteFrontAndBackSpaces (Tekst : STRING) : STRING;
FUNCTION  AddUpWithPre0s (Len : BYTE; Tekst : STRING) : STRING;
FUNCTION  AddUpWithPreSpaces (Len : BYTE; Tekst : STRING) : STRING;
{$IFDEF PLATFORM_DOS_NOT_DPMI}
PROCEDURE SetEnvStr (StrName : STRING; NewValue : STRING);
{$ENDIF}
FUNCTION  UpdateCRC32 (InitCRC : LONGINT; VAR InBuf; InLen : WORD) : LONGINT;
FUNCTION  LoCase (C : CHAR) : CHAR;
PROCEDURE SwapWords (VAR W1,W2 : WORD);
FUNCTION  UpCaseString (Tekst : STRING) : STRING;
FUNCTION  LoCaseString (Tekst : STRING) : STRING;
FUNCTION  GetTimer : LONGINT;
FUNCTION  CleanTabs (Tekst : STRING; WithNrSpaces : BYTE) : STRING;
FUNCTION  CaselessMatch (VAR Str1 : STRING; Str2 : STRING) : BOOLEAN;
FUNCTION  CaselessMatch_CC (Str1,Str2 : STRING) : BOOLEAN;
FUNCTION  CaselessStartMatch (VAR Str1 : STRING; Str2 : STRING) : BOOLEAN;
PROCEDURE DelayOneSecond;
PROCEDURE NewDelay (MS : WORD); { must be 6553 or lower! }
FUNCTION  _MemAvail : LONGINT;
FUNCTION  _MaxAvail : LONGINT;


{=== Desqview Routines ====================================================}

{$IFDEF DesqView}
CONST In_DV : BOOLEAN = TRUE;

FUNCTION  DV_Get_Version: WORD;
FUNCTION  DV_Get_Video_Buffer (VideoSeg: WORD) : WORD;
PROCEDURE DV_Pause;
PROCEDURE DV_Begin_Critical;
PROCEDURE DV_End_Critical;
{$ENDIF}


{=== Window Routines ======================================================}

TYPE XYType = BYTE;   { bij verandering in WORD moet er assembly overhoop! }

PROCEDURE WindowPush (X,Y,LX,LY : XYType);
PROCEDURE WindowPop;


{=== Screen Routines ======================================================}

CONST mBright = 8;
      mBlink  = 128;
     {mUnder  = 1;   werkt niet op monochroom VGA, alleen op MDA }
      mWhite  = 7;
      mBlack  = 0;

      cBlack    = 0;
      cBlue     = 1;
      cGreen    = 2;
      cCyan     = 3;
      cRed      = 4;
      cMagenta  = 5;
      cBrown    = 6;
      cLGray    = 7;
{ extra voorgrond kleuren }
      cDGray    = 8;
      cLBlue    = 9;
      cLGreen   = 10;
      cLCyan    = 11;
      cLRed     = 12;
      cLMagenta = 13;
      cYellow   = 14;
      cWhite    = 15;

      cBlink    = 128;

TYPE VideoArray  = ARRAY[0..16383] OF BYTE;

     VideoRecord = RECORD
                         Cols,
                         Rows    : XYType;
                         {$IFDEF PLATFORM_DOS_ALL}
                         Mode    : BYTE;
                         VGA     : BOOLEAN;
                         Base    : WORD;
                         {$ENDIF}
                         Color   : BOOLEAN;
                   END;

     ColorSet = (cDeskTop,cHeaders,cBoxLinesActive,cBoxLinesInactive,
                 cBoxBack,cBoxShadow,cBoxData,cBoxDataTagged,cMenuSelectBar,
                 cMenuSelected,cKeyName,cKeyDescr,cKeyBlink,cError,cMessage,
                 cFieldData,cFieldDisabled,cFieldCursor,cFieldCursorTagged,
                 cNotTagable,cCustom1,cCustom2,cCustom3,cHelp,cHelpBright,
                 cHelpLink,cScrSaver,cExitPrg,cNewHelpNormal,
                 cNewHelpHighlight,cNewHelpLink,cNewHelpLinkCursor,
                 cNewHelpTitle);

VAR Video        : VideoRecord;
    OldVideoMode : BYTE;    { video mode bij het aanroepen van OpenDesktop }
    GetColor     : ColorSet;

    CursorIsOn   : BOOLEAN;
    CursorX,
    CursorY      : XYTYPE;

CONST ChangedVideoMode : BOOLEAN = FALSE;


PROCEDURE IdentifyVideo;
{$IFDEF PLATFORM_DOS_ALL}
PROCEDURE SetVideo (Mode : BYTE);
{$ENDIF}
PROCEDURE ModifyColor (Color : ColorSet; Value : BYTE);
FUNCTION  GetColorValue (Color : ColorSet) : BYTE;
PROCEDURE SetColor (Color : ColorSet);
PROCEDURE FillVideo (X,Y,LX,LY : XYType; Teken : CHAR);
PROCEDURE PaintDesktop (X,Y,LX,LY : XYType);
PROCEDURE OpenDesktop (Titel, Version : STRING);
PROCEDURE CloseDesktop;
PROCEDURE RGotoXY (X,Y : XYType);
FUNCTION  RWhereX : XYType;
FUNCTION  RWhereY : XYType;
PROCEDURE RWrite (Tekst : STRING);
PROCEDURE RWritePC (Tekst : PChar);
PROCEDURE RWriteC (Color : ColorSet; Tekst : STRING);
PROCEDURE FWrite (Tekst : STRING); { laat de achtergrondkleur in tact }
PROCEDURE SneakWrite (X,Y : XYType; Tekst : STRING);
PROCEDURE ChangeColor (X,Y,LX : XYType; Color : ColorSet);
FUNCTION  ReadColor (X,Y : XYType) : ColorSet;
PROCEDURE WriteXY (X,Y : XYType; Tekst : STRING);
PROCEDURE WriteXYC (X,Y : XYType; Color: ColorSet; Tekst : STRING);
PROCEDURE CursorOn;
PROCEDURE CursorOff;
PROCEDURE CursorUpdatePos;
PROCEDURE CursorGotoXY (X,Y : XYType);
PROCEDURE ScrollUp (X,Y,LX,LY : XYType);
PROCEDURE ScreenDumpToFile (Filename : STRING);
PROCEDURE ScreenDumpToTextFile (Filename : STRING);
{$IFDEF PLATFORM_WIN32}
PROCEDURE Win32WriteNewAttribute (Attr: BYTE; X, Y, LX, LY: XYType);
{$ENDIF}

VAR DesktopCopyright : STRING[15];

{=== Box Routines =========================================================}

TYPE BoxLines = (Single,Double);

VAR Lb,        { Links Boven }
    Lon,       { Links Onder }
    Rb,        { Rechts Boven }
    Ro,        { Rechts Onder }
    Tb,        { T-stuk boven }
    Ton,       { T-stuk onder }
    Tl,        { T-stuk links }
    Tr,        { T-stuk rechts }
    Ho,        { Horizontaal }
    Vr,        { Vertikaal }
    Kr : CHAR; { Kruising }

PROCEDURE SetLines (Lines : BoxLines);
PROCEDURE BoxDraw (Lines : BoxLines; X,Y,LX,LY : XYType);
PROCEDURE BoxDrawOuter (Lines : BoxLines; X,Y,LX,LY : XYType);
PROCEDURE BoxDrawC (Color : ColorSet; Lines : BoxLines; X,Y,LX,LY : XYType);
PROCEDURE BoxDrawNS (Lines : BoxLines; X,Y,LX,LY : XYType);
PROCEDURE BoxDrawNSOuter (Lines : BoxLines; X,Y,LX,LY : XYType);
PROCEDURE BoxDrawCNS (Color : ColorSet; Lines : BoxLines; X,Y,LX,LY : XYType);
PROCEDURE BoxSetActive (X,Y,LX,LY : XYType);
PROCEDURE BoxSetInactive (X,Y,LX,LY : XYType);


{=== Screen Saver Routines ================================================}

{$IFNDEF NoScrSaver}
TYPE ScreenSaverOnOffType = (ssOn,ssOff);
     ScreenSaverStateType = (Blanked,Visible);

PROCEDURE ScreenSaver_SetState (OnOff : ScreenSaverOnOffType);
{$ENDIF}


{=== Keyboard Routines ====================================================}

{$I KEYSDEF.INC}

{$IFNDEF NoScrSaver}
TYPE IdleRoutineFunc = FUNCTION (ScreenSaverState : ScreenSaverStateType) : KeyType;
                       { moet wel een FAR zijn! }
{$ENDIF}

TYPE KeysSet = SET OF KeyType; { vb: [kEsc,kF1..kF4] }

VAR Key         : KeyType;
    AsciiKey    : CHAR;
    KbdScanCode : BYTE; { voor debuggen }
{$IFNDEF NoScrSaver}
    IdleRoutine : IdleRoutineFunc;
{$ENDIF}

FUNCTION  ReadKey : KeyType;
FUNCTION  KeyPressed : BOOLEAN;
{$IFNDEF NoScrSaver}
PROCEDURE SetAutoKey (AutoKey : KeyType; Timeout : BYTE{seconds});
FUNCTION  NoIdleRoutine (State : ScreenSaverStateType) : KeyType;
{$ENDIF}


{=== Online Help System Routines ==========================================}

{$I HLPSTRUC.INC}

PROCEDURE AssignHelpFile (Filename : STRING; Checksum : LONGINT);
PROCEDURE RequestHelp (HelpHandle : HelpHandleType);


{=== Menu Routines ========================================================}

VAR MenuQuit : BOOLEAN;

PROCEDURE MenuDefine (X,Y : XYType; KopTekst : STRING);
PROCEDURE MenuSetHelp (Handle : HelpHandleType);
PROCEDURE MenuAddItem (Tekst : STRING);
PROCEDURE MenuSetFirst (Nr : BYTE);
FUNCTION  MenuItemCount : BYTE;
PROCEDURE MenuShow;
PROCEDURE MenuErase;
FUNCTION  MenuSelect : KeyType;


{=== Fields Routines ======================================================}

CONST MaxFields = 30;

TYPE FieldNrType    = 0..MaxFields;
     StringPtr      = ^STRING;
     ProcedureType  = PROCEDURE;
     FieldCheckFunc = FUNCTION (Buffer : StringPtr) : BOOLEAN;
     FieldEditProc  = PROCEDURE (Buffer : StringPtr);
     FileMgrProc    = PROCEDURE (Buffer : StringPtr; CheckOnly : BOOLEAN);

VAR LastFieldNr : FieldNrType;

PROCEDURE FieldInit;

PROCEDURE FieldDefineOne (Nr : FieldNrType; X,Y,LX : XYType; U,D : FieldNrType; Buffer : StringPtr; Template : STRING);
PROCEDURE FieldDefineLongOne (Nr : FieldNrType; X,Y,LX,SX{on screen} : XYType; U,D : FieldNrType;
                              Buffer : StringPtr; Template : STRING);
PROCEDURE FieldDefineEdit (Nr : FieldNrType; X,Y,LX : XYType; U,D : FieldNrType; Buffer : StringPtr; ProcAd : FieldEditProc);
PROCEDURE FieldDefineList (Nr : FieldNrType; X,Y,LX : XYType; U,D : FieldNrType; Buffer : StringPtr; ProcAd : ProcedureType);
PROCEDURE FieldDefineCheckOne (Nr : FieldNrType; X,Y,LX : XYType; U,D : FieldNrType; Buffer : StringPtr; Template : STRING;
                               FuncAd : FieldCheckFunc);
PROCEDURE FieldDefineCheckLongOne (Nr : FieldNrType; X,Y,LX,SX{on screen} : XYType; U,D : FieldNrType;
                                   Buffer : StringPtr; Template : STRING; FuncAd : FieldCheckFunc);
PROCEDURE FieldDefineToggles (Nr : FieldNrType; X,Y : XYType; U,D : FieldNrType; VAR Keuze{BYTE}; Opties : STRING;
                              FirstValue : BYTE);
PROCEDURE FieldDefineTogglesCall (Nr : FieldNrType; X,Y : XYType; U,D : FieldNrType; VAR Keuze{BYTE}; Opties : STRING;
                                  FirstValue : BYTE; ProcAd : ProcedureType);
PROCEDURE FieldDefineFileMgr (Nr : FieldNrType; X,Y,LX,SX : XYType; U,D : FieldNrType;
                              Buffer : StringPtr; ProcAd : FileMgrProc; AllowSearchChars : BOOLEAN);

PROCEDURE FieldAutoDefineOne (X,Y : XYType; Buffer : StringPtr; Template : STRING);
PROCEDURE FieldAutoDefineLongOne (X,Y,SX{on screen} : XYType; Buffer : StringPtr; Template : STRING);
PROCEDURE FieldAutoDefineEdit (X,Y : XYType; Buffer : StringPtr; ProcAd : FieldEditProc);
PROCEDURE FieldAutoDefineList (X,Y : XYType; Buffer : StringPtr; ProcAd : ProcedureType);
PROCEDURE FieldAutoDefineCheckOne (X,Y : XYType; Buffer : StringPtr; Template : STRING; FuncAd : FieldCheckFunc);
PROCEDURE FieldAutoDefineCheckLongOne (X,Y,SX{on screen} : XYType; Buffer : StringPtr; Template : STRING;
                                       FuncAd : FieldCheckFunc);
PROCEDURE FieldAutoDefineToggles (X,Y : XYType; VAR Keuze; Opties : STRING; FirstValue : BYTE);
PROCEDURE FieldAutoDefineTogglesCall (X,Y : XYType; VAR Keuze; Opties : STRING; FirstValue : BYTE; ProcAd : ProcedureType);
PROCEDURE FieldAutoDefineFileMgr (X,Y,SX : XYType; Buffer : StringPtr; ProcAd : FileMgrProc; AllowSearchChars : BOOLEAN);

FUNCTION  FieldGetLastAutoFieldNr : FieldNrType;

PROCEDURE FieldDisableField (FieldNr : FieldNrType);
PROCEDURE FieldEnableField (FieldNr : FieldNrType);

PROCEDURE FieldSetPassword (FieldNr : FieldNrType);

PROCEDURE FieldSetFirst (Nr : FieldNrType);

PROCEDURE FieldUpdateOneField (FieldNr : FieldNrType);
PROCEDURE FieldUpdateScreen;

PROCEDURE FieldEditDirect;
PROCEDURE FieldEditDirectSpecial (SpecialKeys : KeysSet);
PROCEDURE FieldEditDirectWithStuffKey (Key : KeyType); { Byte (Key) moet < 32 !! }
PROCEDURE FieldEdit;

PROCEDURE FieldSetHelp (FieldNr : FieldNrType; HelpHandle : HelpHandleType);

PROCEDURE FieldPushAll;
PROCEDURE FieldPopAll;

FUNCTION  FieldCheckByteFunc (BufferPtr : StringPtr) : BOOLEAN; FAR;
FUNCTION  FieldCheckWordFunc (BufferPtr : StringPtr) : BOOLEAN; FAR;


{=== List Routines ========================================================}

{ deze kan naar behoefte aangepast worden, zodat een tussenlijst niet }
{ alle items kan laten zien, maar je er nog wel een selectie uit kan  }
{ maken en via een andere lijst er nog wat mee kan doen.              }
{ Bijvoorbeeld: Areas verplaatsen naar een andere groep in WtrConf.   }
CONST ListLowMemLimit : LONGINT = 4096;

TYPE ListAddType     = (Top,Bottom,Sorted,Convert);
     ListTagType     = (DoTag,NoTag); { bij select }
     ListConvertFunc = FUNCTION (Tekst : STRING) : STRING;
     ListAnchorType  = (Default{=TopLeft},TopLeft,TopRight,BottomLeft,BottomRight);
     ListSpecialKeys = KeysSet; { vb: [kEsc,kF1..kF4] }

VAR ListLastCursorY : XYType; { wordt ingevuld bij verlaten ListSelect }

PROCEDURE ListDefine (X,Y,MaxLX,MaxLY : XYType; Anchor : ListAnchorType; Kopje : STRING; Help : HelpHandleType);
PROCEDURE ListChangeTitle (NewTitle : STRING);
PROCEDURE ListSetConvertRoutine (NewRoutine : ListConvertFunc);
PROCEDURE ListAddItem (Tekst : STRING; ItemNr : WORD; AddMethod : ListAddType);
PROCEDURE ListAddItemToPrevList (Tekst : STRING; ItemNr : WORD; AddMethod : ListAddType);
PROCEDURE ListSortNow;
FUNCTION  ListItemNrInPrevList (ItemNr : WORD) : BOOLEAN;
PROCEDURE ListSetItemRef (ItemNr : WORD; Ref : LONGINT);
FUNCTION  ListGetItemRef (ItemNr : WORD) : LONGINT;
FUNCTION  ListGetItemTekst (ItemNr : WORD) : STRING;
PROCEDURE ListSetItemTekst (ItemNr : WORD; Tekst : STRING);
PROCEDURE ListRemoveItem (ItemNr : WORD);
PROCEDURE ListRemoveAllItems;
FUNCTION  ListItemCount : WORD;
FUNCTION  ListTagCount : WORD;
FUNCTION  ListGetTaggedItemNr (TagNr : WORD) : WORD;
FUNCTION  ListGetTaggedItemTekst (TagNr : WORD) : STRING;
PROCEDURE ListTagItem (ItemNr : WORD);
PROCEDURE ListUntagItem (ItemNr : WORD);
FUNCTION  ListSetCursorOnItem (ItemNr : WORD) : BOOLEAN; { TRUE = Found }
PROCEDURE ListShow (LineType : BoxLines; Active : BOOLEAN);
PROCEDURE ListHideWindow;
PROCEDURE ListUpdateWindow (Active : BOOLEAN; LineOffset : BYTE; CursorLine : INTEGER);
FUNCTION  ListSelect (CanTag : ListTagType; SpecialKeys : ListSpecialKeys) : WORD;
PROCEDURE ListErase;
FUNCTION  ListGetPrevItemNr (ItemNr : WORD) : WORD;
FUNCTION  ListGetNextItemNr (ItemNr : WORD) : WORD;


{=== Over All Routines ====================================================}

VAR MessageXB,
    MessageYB : XYType;

PROCEDURE WriteKeysLine (Line : STRING);
PROCEDURE PushKeysLine;
PROCEDURE PopKeysLine;
PROCEDURE Message (Tekst : STRING);
PROCEDURE Error (Tekst : STRING);
PROCEDURE Error2Lines (Tekst1,Tekst2 : STRING);


{=== Disk Routines ========================================================}

CONST NoPathChecking : BOOLEAN = FALSE;

FUNCTION TestIfExist (FilePath : STRING) : BOOLEAN;
FUNCTION LockFile (VAR Bestand : FILE) : BOOLEAN;
FUNCTION UnLockFile (VAR Bestand : FILE) : BOOLEAN;
FUNCTION CorrectPath (Path : STRING) : STRING;
FUNCTION CreatePath (Path : STRING) : BYTE;
FUNCTION CheckAndCreatePath (Path : STRING; IncludesFilename : BOOLEAN) : BOOLEAN;
FUNCTION FileManager (Input,SearchDescr,SearchExt : STRING) : STRING;
FUNCTION FilenameTo83 (Filename : STRING) : STRING;
FUNCTION FilenameTo83Instance (Path,Filename : STRING) : STRING;
FUNCTION ExtractPathPart (Filename : STRING) : STRING;
FUNCTION UNC_FExpand (Path : STRING) : STRING;


IMPLEMENTATION

USES Dos,
     Crt,
     {$IFDEF PLATFORM_OS2}
     {$IFNDEF FPC}
     OS2Base,
     VPUtils,
     {$ELSE}
     DosCalls,
     KbdCalls,
     VioCalls,
     {$ENDIF}
     {$ENDIF}
     {$IFDEF PLATFORM_WIN32}
     Windows,
     {$ENDIF}
     Strings;

VAR DesktopCopyrightYear : STRING[2];
    {$IFDEF PLATFORM_DOS_ALL}
    Regs                 : Registers;
    {$ENDIF}

{$I CONVERT.INC}   { Conversie Routines }
{$I UTILITY.INC}   { Utility Routines }

{ $IFDEF DesqView}
{ $I DESQVIEW.INC}  { DesqView communication routines }
{ $ENDIF}

{$IFNDEF NoScrSaver}
{$I SCRSAVER.INC}  { Screen Saver Routine, for Keyboard only }
{$ENDIF}

{$I KEYBOARD.INC}  { Keyboard Routines }
{$I WINDOWS.INC}   { Windows Routines }
{$I NEWHELP.INC}   { New Online Help System Routines }
{$I MENU.INC}      { Menu Routines }
{$I FIELDS.INC}    { Fields Routines }
{$I LIST.INC}      { List Routines }
{$I SCREEN.INC}    { Scherm Routines }
{$I BOX.INC}       { Box Routines }
{$I OVERALL.INC}   { OverAll Routines }
{$I DISK.INC}      { Disk Routines }
{$I SERIAL.INC}    { Zet de Compile Data & Time in de .EXE }


BEGIN
{$IFNDEF FPC}
     CheckBreak:=FALSE;
     DirectVideo:=TRUE;
     CheckSnow:=FALSE;
{$ENDIF}

{$IFNDEF NoScrSaver}
     IdleRoutine:=NoIdleRoutine;
{$ENDIF}

     { Compile Date&Time invullen als dat nog niet gedaan is               }
     { Niet de volledige string ter vergelijking hier invullen, dan kan de }
     { serialize routine in de war komen en de verkeerde veranderen...     }
     IF (Copy (CompileDateAndTime,1,7) = 'COMPILE') THEN
        Serialize;

{ Screen Init }
{$IFDEF DateTimeStamp}
     DesktopCopyrightYear:=Copy (CompileDateAndTime,9,2);
{$ELSE}
     DesktopCopyrightYear:='99'; { 1 keer per jaar aanpassen }
{$ENDIF}
     DesktopCopyright:='RvdW';

     KeyboardInit;
END.
