{ LIST.INC: Includefile van de Ramon Interface Unit }

{==========================================================================}
{ (c) Copyright Waterline Software Developent V.O.F. 1990-1994             }
{                                                                          }
{    Waterline Software Development V.O.F.                                 }
{    Wouter Sluislaan 12                                                   }
{    1461 AC  Zuidoostbeemster                                             }
{    The Netherlands                                                       }
{                                                                          }
{ It not allowed to use this user interface in any program not owned by    }
{ the Waterline Software Development V.O.F.                                }
{ Special conditions apply to programs distributed by the Waterline        }
{ Software Development V.O.F. If the source code of any of these programs  }
{ is distributed as well, it is NOT allowed to use the user interface in   }
{ your own programs. Violators may be prosecuted!                          }
{                                                                          }
{ Please contact the Waterline Software Development V.O.F. at the above    }
{ address for your licence to use the "Ramon" user interface. You will get }
{ the most recent copy of the "Ramon" user interface and the "Ramon" user  }
{ interface expert for free. This program helps you design your user       }
{ interfaces at an instance.                                               }
{                                                                          }
{ This copyright notice should remain in this file and all files that are  }
{ part of the user interface "Ramon".                                      }
{==========================================================================}

{ Definitie van de gewenste mogelijkheden:

Lijst waarin tekst regels opgeslagen kunnen worden. Iedere tekstregel krijgt
een eigen identificatiecode van 16 bits, die de aanroeper mag opgeven en die
gebruikt moet worden om het item te verwijderen en die teruggegeven wordt als
het item geselecteerd wordt.

De cursor staat op een van de items en wordt bij het toevoegen automatisch
aangepast: bij toevoegingen boven de cursor zakt deze mee omlaag, bij
toevoegingen onder de cursor blijft deze staan. Bij verwijdering van de
regel onder de cursor zakt de cursor een regel omlaag naar de volgende regel.

De grootte van de list moet aan een aantal maxima voldoen en kan verder
dynamisch groeien aan de hand van het aantal items dat erin zit. Bij het
verwijderen van items moet deze korter worden, bij het toevoegen van items
moet ie groter worden.

De regels in de lijst moeten dynamisch opgeslagen worden zodat ze niet meer
geheugen in beslag nemen dan nodig. Er geldt geen maximum voor de lengte,
behalve de maximale lengte van een string dan van 255 tekens. Als de regel
niet helemaal binnen het window past, dan kan met de cursor toetsen naar
links er rechts door de lijst gescrolled worden.

Links naast de items moet worden aangegeven of er nog meer items in de lijst
aanwezig zijn in de richtingen omhoog en omlaag. Als een item langer is dan
het window breed is, dan moet een pijl naar rechts over de itemtekst gezet
worden. Als het window naar rechts scrollt. Naar links moet dat niet gebeuren
want dan zouden alle items die pijl krijgen en dat is smerig.

Er moet getagged kunnen worden in de lijst: 1 item aan en uit en een groep
items met behulp van zoekteksten.

Er moet in de lijst gezocht kunnen worden door een zoekstring in te tikken.
Deze zoekstring wordt niet getoond, maar er wordt wel in de lijst gezocht
naar het eerste item van boven dat aan de criteria voldoet. Als geen van de
items eraan voldoet, dan moet NIET (net als bij de menus) de eerstevolgende
gezocht worden die aan dat teken voldoet.

De speciale toetsen die gebruikt kunnen worden in de lijst moeten kunnen
worden opgegeven. Dit zijn bijvoorbeeld de functietoetsen behalve F1 (als
help aan staat) en F5,F6,F7. Maar eventueel zou ook ALT-P mogelijk moeten
zijn.

Met behulp van interface routines kunnen items nu getagged en geuntagged
worden, zodat het programma de gebruiker nog beter kan helpen vanuit de
'global' functions.
}

{------------------------------------------------------
              HANDLEIDING GEBRUIK LISTS
 ------------------------------------------------------
 Hieronder volgt de juiste volgorde en een stukje voorbeeld code
 voor het gebruik van de list unit:

 ListDefine ()
 N x ListAddItem ()

 Quit:=FALSE;
 REPEAT
       Keuze:=ListSelect (DoTag,[])

       CASE Key OF
            kEsc : Quit:=TRUE;

            kRet : IF (ListTagCount = 0) THEN
                      Error ('Choice was: '+Word2String (Keuze))
                   ELSE
                       FOR Lp:=1 TO ListTagCount DO
                           Error ('One of the tagged choices was: '+Word2String (Keuze));

            kIns : ListAddItem ();

            kDel : ListRemoveItem ();
       END;

 UNTIL Quit;

 ListErase ();

 ----------------------------------------------
              EINDE HANDLEIDINKIE
 ----------------------------------------------
}

TYPE ListItemRecordPtr = ^ListItemRecord;
     ListItemRecord    = RECORD
                               Item        : PChar;
                               IsTagged    : BOOLEAN;
                               NextItemPtr : ListItemRecordPtr;
                               Nummer      : WORD;
                               Ref         : LONGINT;
                         END;

     ListRecordPtr = ^ListRecord;
     ListRecord    = RECORD
                           PrevListPtr  : ListRecordPtr;

                           FirstItemPtr,
                           LastItemPtr  : ListItemRecordPtr;
                           ItemCount    : WORD;
                           TagCount     : WORD;
                           ConvertFunc  : ListConvertFunc;
                           HelpHandle   : HelpHandleType;

                           { heeft te maken met het window }
                           Titel        : PChar;
                           AnchorHow    : ListAnchorType;
                           AnchorX,
                           AnchorY,
                           MaxW,
                           MaxH,
                           CurrX,
                           CurrY,
                           CurrW,
                           CurrH,
                           WidestItem   : XYType;
                           IsVisible    : BOOLEAN;

                           { heeft te maken met de cursor en items die }
                           { in beeld zijn.                            }
                           TopItemOffset : WORD; { 0-based }
                           BalkOffset    : BYTE; { 1-based, 0=invisible }
                           ShiftOffset   : BYTE; { 0..255 }

                           LowMem        : BOOLEAN;
                           ItemsNoMem    : WORD;
                     END;

VAR CurrListPtr       : ListRecordPtr;
    ListCursorItemPtr : ListItemRecordPtr;

{---------------------------------------------------------------------------}
{ ListDefine                                                                }
{                                                                           }
{ Met deze routine kan een nieuwe lijst aangemaakt worden. De oude lijst    }
{ wordt bewaard en wordt weer actief zodra deze lijst opgeruimd wordt met   }
{ ListErase.                                                                }
{                                                                           }
PROCEDURE ListDefine (X,Y,MaxLX,MaxLY : XYType; Anchor : ListAnchorType; Kopje : STRING; Help : HelpHandleType);

VAR NewListPtr : ListRecordPtr;

BEGIN
     { controleer invoer }
     IF (MaxLX < 4) THEN MaxLX:=4;
     IF (MaxLY < 5) THEN MaxLY:=5;

     GetMem (NewListPtr,SizeOf (ListRecord));

     WITH NewListPtr^ DO
     BEGIN
          PrevListPtr:=CurrListPtr;

          FirstItemPtr:=NIL;
          LastItemPtr:=NIL;
          ItemCount:=0;
          TagCount:=0;
          ConvertFunc:=NIL; { nog niet opgegeven }
          HelpHandle:=Help;

          GetMem (Titel,Length (Kopje)+1);
          StrPCopy (Titel,Kopje);

          AnchorHow:=Anchor;
          AnchorX:=X;
          AnchorY:=Y;
          MaxW:=MaxLX;
          MaxH:=MaxLY;
          CurrW:=0;
          CurrH:=0;
          WidestItem:=0;
          IsVisible:=FALSE;

          TopItemOffset:=0;
          BalkOffset:=1;
          ShiftOffset:=0;

          LowMem:=FALSE;
          ItemsNoMem:=0;
     END; { with }

     CurrListPtr:=NewListPtr;
END;


{---------------------------------------------------------------------------}
{ ListChangeTitle                                                           }
{                                                                           }
{ Met deze routine kan een nieuwe title boven de list gezet worden. Dit was }
{ nodig voor de FileManager.                                                }
{                                                                           }
PROCEDURE ListChangeTitle (NewTitle : STRING);
BEGIN
     IF (CurrListPtr = NIL) THEN
        Exit;

     WITH CurrListPtr^ DO
     BEGIN
          StrDispose (Titel);

          GetMem (Titel,Length (NewTitle)+1);
          StrPCopy (Titel,NewTitle);
     END; { with }
END;


{---------------------------------------------------------------------------}
{ ListSetConvertRoutine                                                     }
{                                                                           }
{ Met deze routine kan de conversie functie opgegeven wordt die gebruikt    }
{ moet worden bij het toevoegen van items op de Convert AddMethod.          }
{                                                                           }
PROCEDURE ListSetConvertRoutine (NewRoutine : ListConvertFunc);
BEGIN
     IF (CurrListPtr = NIL) THEN
        Exit;

     CurrListPtr^.ConvertFunc:=NewRoutine;
END;


{---------------------------------------------------------------------------}
{ ListAddItem                                                               }
{                                                                           }
{ Met deze routine kan een nieuw item aan de lijst worden toegevoegd.       }
{                                                                           }
PROCEDURE ListAddItem (Tekst : STRING; ItemNr : WORD; AddMethod : ListAddType);

VAR PrevItemPtr,
    HulpItemPtr,
    NewListItemPtr : ListItemRecordPtr;
    Converted      : STRING;

BEGIN
     IF (CurrListPtr = NIL) THEN
        Exit;

     IF (CurrListPtr^.ItemCount = 65535) THEN
        Exit; { list is full }

     IF (_MemAvail < ListLowMemLimit) THEN
     BEGIN
          Inc (CurrListPtr^.ItemsNoMem);
          CurrListPtr^.LowMem:=TRUE; { show error in ListSelect }
          Exit;
     END;

     GetMem (NewListItemPtr,SizeOf (ListItemRecord));

     WITH NewListItemPtr^ DO
     BEGIN
          Nummer:=ItemNr;
          Ref:=-2; { not filled in }
          IsTagged:=FALSE;

          GetMem (Item,Length (Tekst)+1);
          StrPCopy (Item,Tekst);

          NextItemPtr:=NIL;
     END; { with }

     WITH CurrListPtr^ DO
     BEGIN
          IF (Length (Tekst) > WidestItem) THEN
             WidestItem:=Length (Tekst);

          { maakt niet uit welke methode, maar als dit de eerste is, dan }
          { moet ie gewoon opgeslagen worden en kunnen we pleite.        }
          IF (FirstItemPtr = NIL) THEN
          BEGIN
               FirstItemPtr:=NewListItemPtr;
               LastItemPtr:=NewListItemPtr;
          END ELSE
              { nu aan de hand van de methode toevoegen }
              CASE AddMethod OF
                   Top :
                       BEGIN
                            NewListItemPtr^.NextItemPtr:=FirstItemPtr;
                            FirstItemPtr:=NewListItemPtr;
                       END;

                   Bottom :
                       BEGIN
                            LastItemPtr^.NextItemPtr:=NewListItemPtr;
                            LastItemPtr:=NewListItemPtr;
                       END;

                   Sorted :
                       BEGIN
                            PrevItemPtr:=NIL;
                            HulpItemPtr:=FirstItemPtr;

                            WHILE (HulpItemPtr <> NIL) AND
                                  (StrIComp (NewListItemPtr^.Item,HulpItemPtr^.Item) > 0) DO
                            BEGIN
                                 PrevItemPtr:=HulpItemPtr;
                                 HulpItemPtr:=HulpItemPtr^.NextItemPtr;
                            END; { while }

                            IF (PrevItemPtr = NIL) THEN
                            BEGIN
                                 { aan het begin toevoegen }
                                 NewListItemPtr^.NextItemPtr:=FirstItemPtr;
                                 FirstItemPtr:=NewListItemPtr;
                                 { laatste wijzigt niet }
                            END ELSE
                            BEGIN
                                 NewListItemPtr^.NextItemPtr:=HulpItemPtr;
                                 PrevItemPtr^.NextItemPtr:=NewListItemPtr;

                                 IF (HulpItemPtr = NIL) THEN
                                    LastItemPtr:=NewListItemPtr;
                            END;
                       END; { sorted }

                   Convert :
                       BEGIN
                            IF (@ConvertFunc = NIL) THEN
                               Exit; { kan niet }

                            { bijna zelfde als sorted }
                            Converted:=ConvertFunc (Tekst);
                            PrevItemPtr:=NIL;
                            HulpItemPtr:=FirstItemPtr;

                            WHILE (HulpItemPtr <> NIL) AND
                                  (Converted > ConvertFunc (StrPas (HulpItemPtr^.Item))) DO
                            BEGIN
                                 PrevItemPtr:=HulpItemPtr;
                                 HulpItemPtr:=HulpItemPtr^.NextItemPtr;
                            END; { while }

                            IF (PrevItemPtr = NIL) THEN
                            BEGIN
                                 { aan het begin toevoegen }
                                 NewListItemPtr^.NextItemPtr:=FirstItemPtr;
                                 FirstItemPtr:=NewListItemPtr;
                                 { laatste wijzigt niet }
                            END ELSE
                            BEGIN
                                 NewListItemPtr^.NextItemPtr:=HulpItemPtr;
                                 PrevItemPtr^.NextItemPtr:=NewListItemPtr;

                                 IF (HulpItemPtr = NIL) THEN
                                    LastItemPtr:=NewListItemPtr;
                            END;
                       END; { convert }

                   ELSE
                       Exit; { methode kennen we niet }
              END; { case }

          { item is nu toegevoegd }
          Inc (ItemCount);
     END; { with }
END;


{---------------------------------------------------------------------------}
{ ListAddItemToPrevList                                                     }
{                                                                           }
{ Deze routine voegt een item toe aan de vorige lijst. Let op! Dit kan      }
{ alleen als er een vorige lijst is. En er is ook nog zoiets als geheugen   }
{ dat het in beslag neemt, dus doet dit niet bij grote lijsten! In ieder    }
{ geval, je kan er items mee aan de vorige lijst toevoegen. Hierdoor wordt  }
{ het mogelijk vanuit de huidige lijst een lijst te tonen met items die nog }
{ niet zijn toegevoegd en waarin getagged kan worden. Daarna kan de hele    }
{ getagde lijst in een keer gekopieerd worden.                              }
{                                                                           }
PROCEDURE ListAddItemToPrevList (Tekst : STRING; ItemNr : WORD; AddMethod : ListAddType);

VAR TmpListPtr : ListRecordPtr;

BEGIN
     IF (CurrListPtr = NIL) THEN
        Exit;

     TmpListPtr:=CurrListPtr;
     CurrListPtr:=CurrListPtr^.PrevListPtr;

     ListAddItem (Tekst,ItemNr,AddMethod);

     CurrListPtr:=TmpListPtr;
END;


{---------------------------------------------------------------------------}
{ ListSortNow                                                               }
{                                                                           }
{ Deze routine sorteert de lijst in oplopende alfabetische volgorde. Aan    }
{ het eind wordt LastItemPtr pas weer goed gezet.                           }
{                                                                           }
PROCEDURE ListSortNow;

VAR Prev1ItemPtr,
    Hulp1ItemPtr,
    Prev2ItemPtr,
    Hulp2ItemPtr : ListItemRecordPtr;

    SubDone,
    AreasDone    : WORD;
    PercDone     : BYTE;

    FirstPtrs,
    ItemPtrs     : ARRAY[Ord ('A')-1..Ord ('Z')+1] OF ListItemRecordPtr;
    Lp           : BYTE;
    Letter       : BYTE;

BEGIN
     IF (CurrListPtr = NIL) THEN
        Exit;

     IF (CurrListPtr^.ItemCount = 0) THEN
        Exit;

     { see if the whole list is sorted already }
     Prev1ItemPtr:=CurrListPtr^.FirstItemPtr;
     Hulp1ItemPtr:=Prev1ItemPtr^.NextItemPtr;
     WHILE (Hulp1ItemPtr <> NIL) DO
     BEGIN
          IF (StrComp (Prev1ItemPtr^.Item,Hulp1ItemPtr^.Item) >= 0) THEN
             Break; { unsorted! }

          Prev1ItemPtr:=Hulp1ItemPtr;
          Hulp1ItemPtr:=Prev1ItemPtr^.NextItemPtr;
     END;

     IF (Hulp1ItemPtr = NIL) THEN
        Exit; { is already completely sorted. Bye! }

     Message ('Sorting...  (0%)  ');
     PushKeysLine;
     WriteKeysLine (' Please wait...');

     { now, split the list is separate pieces for each of the letters.   }
     { A will have everything above it and Z will have everything that's }
     { below it.                                                         }

     { initialize the list }
     FOR Lp:=Ord ('A')-1 TO Ord ('Z')+1 DO
     BEGIN
          FirstPtrs[Lp]:=NIL;
          ItemPtrs[Lp]:=NIL;
     END;

     { break the big thing apart into smaller lists for each of the letters }
     Hulp1ItemPtr:=CurrListPtr^.FirstItemPtr;
     WHILE (Hulp1ItemPtr <> NIL) DO
     BEGIN
          { add this one to the correct list }
          Letter:=Ord (Hulp1ItemPtr^.Item^);

          IF (Letter < Ord ('A')) THEN
             Letter:=Ord ('A')-1;

          IF (Letter > Ord ('Z')) THEN
             Letter:=Ord ('Z')+1;

          { add this item to the list. Notice that this turns an almost   }
          { sorted list up side down. Something should be done about that }
          { or else it will all get worse!                                }
          IF (FirstPtrs[Letter] = NIL) THEN
             FirstPtrs[Letter]:=Hulp1ItemPtr
          ELSE
              ItemPtrs[Letter]^.NextItemPtr:=Hulp1ItemPtr;

          ItemPtrs[Letter]:=Hulp1ItemPtr;

          { continue with the next item }
          Hulp1ItemPtr:=Hulp1ItemPtr^.NextItemPtr;
     END; { while }

     AreasDone:=0; { for the percdone counter }

     { sorteer nu ieder van de 28 stukken die we gecreerd hebben }
     FOR Lp:=Ord ('A')-1 TO Ord ('Z')+1 DO
         IF (FirstPtrs[Lp] <> NIL) THEN
         BEGIN
              { check if this sub-list is sorted already. If the newly }
              { added items are only in one of the groups that it      }
              { shouldn't be affecting the other groups.               }

              ItemPtrs[Lp]^.NextItemPtr:=NIL; { make sure the terminator is there }

              Prev1ItemPtr:=FirstPtrs[Lp];
              Hulp1ItemPtr:=Prev1ItemPtr^.NextItemPtr;
              SubDone:=1;
              WHILE (Hulp1ItemPtr <> NIL) DO
              BEGIN
                   IF (StrComp (Prev1ItemPtr^.Item,Hulp1ItemPtr^.Item) > 0) THEN
                      Break; { unsorted! }

                   Inc (SubDone);

                   Prev1ItemPtr:=Hulp1ItemPtr;
                   Hulp1ItemPtr:=Prev1ItemPtr^.NextItemPtr;
              END;

              IF (Hulp1ItemPtr = NIL) THEN
              BEGIN
                   { the whole thing is sorted already }
                   AreasDone:=AreasDone+SubDone;

                   PercDone:=Round ((AreasDone/CurrListPtr^.ItemCount)*100);
                   WriteXYC (38,MessageYB,cMessage,
                                            RepChar (PercDone DIV 10,'')+
                                            RepChar (10-(PercDone DIV 10),'')+
                                            ' ('+Byte2String (PercDone)+'%)');

                   Continue; { with the for }
              END;

              { tijdens het sorteren wordt steeds de pointer naar }
              { het vorige item bijgehouden omdat van daaruit de  }
              { NextItemPtr aangepast moet worden als een item    }
              { omgewisseld wordt.                                }

              { insertion sort }

              Prev1ItemPtr:=NIL;
              Hulp1ItemPtr:=FirstPtrs[Lp];

              WHILE (Hulp1ItemPtr^.NextItemPtr <> NIL) DO
              BEGIN
                   Prev2ItemPtr:=Hulp1ItemPtr;
                   Hulp2ItemPtr:=Hulp1ItemPtr^.NextItemPtr;

                   WHILE (Hulp2ItemPtr <> NIL) DO
                   BEGIN
                        IF (StrComp (Hulp1ItemPtr^.Item,Hulp2ItemPtr^.Item) > 0) THEN
                        BEGIN
                             { de tekst bij Item2 moet vOOr die van Item1 }

                             { haal Item2 uit de lijst }
                             Prev2ItemPtr^.NextItemPtr:=Hulp2ItemPtr^.NextItemPtr;

                             { en plaats deze vOOr Item1 }
                             IF (Prev1ItemPtr = NIL) THEN
                                FirstPtrs[Lp]:=Hulp2ItemPtr
                             ELSE
                                 Prev1ItemPtr^.NextItemPtr:=Hulp2ItemPtr;

                             Hulp2ItemPtr^.NextItemPtr:=Hulp1ItemPtr;

                             { en nu Hulp1 naar de nieuwe Item1 laten wijzen }
                             Hulp1ItemPtr:=Hulp2ItemPtr;

                             { en Hulp2 naar de nieuwe Item2 laten wijzen }
                             Hulp2ItemPtr:=Prev2ItemPtr^.NextItemPtr;
                        END ELSE
                        BEGIN
                             { doorschuiven naar de volgende hoeft NIET als er }
                             { net gewisseld is, want dan wijst Hulp2 al naar  }
                             { het nieuwe item.                                }
                             Prev2ItemPtr:=Hulp2ItemPtr;
                             Hulp2ItemPtr:=Hulp2ItemPtr^.NextItemPtr;
                        END;

                   END; { while }

                   {WriteXYC (1,25,cKeyDescr,AddUpWithSpaces (80,StrPas (Hulp1ItemPtr^.Item)));}

                   Inc (AreasDone);
                   PercDone:=Round ((AreasDone/CurrListPtr^.ItemCount)*100);
                   WriteXYC (38,MessageYB,cMessage,
                                            RepChar (PercDone DIV 10,'')+
                                            RepChar (10-(PercDone DIV 10),'')+
                                            ' ('+Byte2String (PercDone)+'%)');


                   Prev1ItemPtr:=Hulp1ItemPtr;
                   Hulp1ItemPtr:=Hulp1ItemPtr^.NextItemPtr;
              END; { while }

              { update the pointer to the last item }
              ItemPtrs[Lp]:=Hulp1ItemPtr;
         END; { if, for }

     { now link the whole thing back together }
     CurrListPtr^.FirstItemPtr:=NIL;
     CurrListPtr^.LastItemPtr:=NIL;
     FOR Lp:=Ord ('A')-1 TO Ord ('Z')+1 DO
         IF (FirstPtrs[Lp] <> NIL) THEN
         BEGIN
              IF (CurrListPtr^.FirstItemPtr = NIL) THEN
              BEGIN
                   CurrListPtr^.FirstItemPtr:=FirstPtrs[Lp];
                   CurrListPtr^.LastItemPtr:=ItemPtrs[Lp];
              END ELSE
              BEGIN
                   CurrListPtr^.LastItemPtr^.NextItemPtr:=FirstPtrs[Lp];
                   CurrListPtr^.LastItemPtr:=ItemPtrs[Lp];
              END;
         END; { if, for }

     CurrListPtr^.LastItemPtr^.NextItemPtr:=NIL;

     PopKeysLine;
     WindowPop;
END;


{---------------------------------------------------------------------------}
{ ListItemNrInPrevList                                                      }
{                                                                           }
{ Deze routine kijkt of het opgegeven nummer in de lijst voorkomt. Zoja,    }
{ dan wordt TRUE terug gegeven, anders FALSE. Dit wordt gebruikt als een    }
{ lijst met items gemaakt moet worden die nog niet in een andere lijst      }
{ zitten.                                                                   }
{                                                                           }
FUNCTION ListItemNrInPrevList (ItemNr : WORD) : BOOLEAN;

VAR HulpItemPtr : ListItemRecordPtr;

BEGIN
     ListItemNrInPrevList:=FALSE; { assume not }

     IF (CurrListPtr = NIL) THEN
        Exit;

     IF (CurrListPtr^.PrevListPtr = NIL) THEN
        Exit; { er is geen voorgaande lijst }

     HulpItemPtr:=CurrListPtr^.PrevListPtr^.FirstItemPtr;
     WHILE (HulpItemPtr <> NIL) DO
     BEGIN
          IF (HulpItemPtr^.Nummer = ItemNr) THEN
          BEGIN
               { gevonden! }
               ListItemNrInPrevList:=TRUE;
               Exit;
          END;

          HulpItemPtr:=HulpItemPtr^.NextItemPtr;
     END;

     IF (HulpItemPtr <> NIL) THEN
     BEGIN
     END;

     { niet gevonden. Resultaat was al FALSE }
END;


{---------------------------------------------------------------------------}
{ ListGetItemTekst                                                          }
{                                                                           }
{ Met deze routine kan in de lijst gezocht worden naar een item met het     }
{ opgegeven nummer, waarna de bijbehorende tekst teruggegeven wordt.        }
{                                                                           }
FUNCTION ListGetItemTekst (ItemNr : WORD) : STRING;

VAR HulpItemPtr : ListItemRecordPtr;

BEGIN
     IF (CurrListPtr = NIL) THEN
        Exit;

     HulpItemPtr:=CurrListPtr^.FirstItemPtr;

     WHILE (HulpItemPtr <> NIL) AND (HulpItemPtr^.Nummer <> ItemNr) DO
           HulpItemPtr:=HulpItemPtr^.NextItemPtr;

     IF (HulpItemPtr = NIL) THEN
        ListGetItemTekst:=''
     ELSE
         ListGetItemTekst:=StrPas (HulpItemPtr^.Item);
END;


{---------------------------------------------------------------------------}
{ ListSetItemTekst                                                          }
{                                                                           }
{ Met deze routine kan de tekst van een item vervangen worden. Daarvoor     }
{ moet het geheugen waarin de tekst staat opnieuw aangevraagd worden omdat  }
{ deze kan wijzigen. Ivm snelheid alleen opnieuw invragen als nodig.        }
{                                                                           }
PROCEDURE ListSetItemTekst (ItemNr : WORD; Tekst : STRING);

VAR HulpItemPtr : ListItemRecordPtr;
    ReCount     : BOOLEAN;
    Len         : BYTE;

BEGIN
     IF (CurrListPtr = NIL) THEN
        Exit;

     HulpItemPtr:=CurrListPtr^.FirstItemPtr;
     WHILE (HulpItemPtr <> NIL) AND (HulpItemPtr^.Nummer <> ItemNr) DO
           HulpItemPtr:=HulpItemPtr^.NextItemPtr;

     IF (HulpItemPtr = NIL) THEN
        Exit; { item niet gevonden }

     ReCount:=FALSE;

     WITH HulpItemPtr^ DO
     BEGIN
          IF (Length (Tekst) <> StrLen (Item)) THEN
          BEGIN
               { nieuwe lengte van de tekst; nieuw geheugen aanvragen }
               IF (StrLen (Item) = CurrListPtr^.WidestItem) THEN
                  ReCount:=TRUE;

               StrDispose (Item);
               GetMem (Item,Length (Tekst)+1);

               IF (Length (Tekst) > CurrListPtr^.WidestItem) THEN
               BEGIN
                    CurrListPtr^.WidestItem:=Length (Tekst);
                    ReCount:=FALSE;
               END;
          END;

          { nieuwe tekst opslaan }
          StrPCopy (Item,Tekst);
     END; { with }

     IF ReCount THEN
        WITH CurrListPtr^ DO
        BEGIN
             HulpItemPtr:=FirstItemPtr;
             WidestItem:=0;

             WHILE (HulpItemPtr <> NIL) DO
             BEGIN
                  Len:=StrLen (HulpItemPtr^.Item);

                  IF (Len > WidestItem) THEN
                     WidestItem:=Len;

                  HulpItemPtr:=HulpItemPtr^.NextItemPtr;
             END; { while }
        END; { with }
END;


{---------------------------------------------------------------------------}
{ ListSetItemRef                                                            }
{                                                                           }
{ This routine allows you to set the reference longint value for an item.   }
{                                                                           }
PROCEDURE ListSetItemRef (ItemNr : WORD; Ref : LONGINT);

VAR HulpItemPtr : ListItemRecordPtr;

BEGIN
     IF (CurrListPtr = NIL) THEN
        Exit;

     HulpItemPtr:=CurrListPtr^.FirstItemPtr;
     WHILE (HulpItemPtr <> NIL) AND (HulpItemPtr^.Nummer <> ItemNr) DO
           HulpItemPtr:=HulpItemPtr^.NextItemPtr;

     IF (HulpItemPtr = NIL) THEN
        Exit; { item niet gevonden }

     HulpItemPtr^.Ref:=Ref;
END;


{---------------------------------------------------------------------------}
{ ListGetItemRef                                                            }
{                                                                           }
{ This routine allows you to get the reference longint value for an item.   }
{                                                                           }
FUNCTION ListGetItemRef (ItemNr : WORD) : LONGINT;

VAR HulpItemPtr : ListItemRecordPtr;

BEGIN
     IF (CurrListPtr = NIL) THEN
        Exit;

     HulpItemPtr:=CurrListPtr^.FirstItemPtr;
     WHILE (HulpItemPtr <> NIL) AND (HulpItemPtr^.Nummer <> ItemNr) DO
           HulpItemPtr:=HulpItemPtr^.NextItemPtr;

     IF (HulpItemPtr = NIL) THEN
        ListGetItemRef:=-1  { item niet gevonden }
     ELSE
         ListGetItemRef:=HulpItemPtr^.Ref;
END;


{---------------------------------------------------------------------------}
{ ListRemoveItem                                                            }
{                                                                           }
{ Met deze routine kan een item uit de lijst verwijderd worden. Een lastig  }
{ klusje omdat daarbij rekening gehouden moet worden met getagde item, ze   }
{ kunnen aan het begin of aan het einde van de lijst staan (waarbij extra   }
{ pointers aangepast moeten worden) of anders staan ze 'gewoon' in het      }
{ midden waarbij ook wat pointers goed gelegd moeten worden.                }
{                                                                           }
{ RWI 950812: FromTop aangelegd om cursor op current item te houden als een }
{             reeks items verwijderd worden.                                }
{                                                                           }
PROCEDURE ListRemoveItem (ItemNr : WORD);

VAR PrevItemPtr,
    HulpItemPtr : ListItemRecordPtr;
    ReCount     : BOOLEAN;
    Len         : BYTE;
    FromTop     : WORD;

BEGIN
     IF (CurrListPtr = NIL) THEN
        Exit;

     WITH CurrListPtr^ DO
     BEGIN
          PrevItemPtr:=NIL;
          HulpItemPtr:=FirstItemPtr;
          FromTop:=1;

          WHILE (HulpItemPtr <> NIL) AND (HulpItemPtr^.Nummer <> ItemNr) DO
          BEGIN
               PrevItemPtr:=HulpItemPtr;
               HulpItemPtr:=HulpItemPtr^.NextItemPtr;
               Inc (FromTop);
          END; { while }

          IF (HulpItemPtr = NIL) THEN
             Exit; { niet gevonden }

          ReCount:=(StrLen (HulpItemPtr^.Item) = WidestItem);

          { FirstItemPtr updaten }
          { controleer of het te verwijderen item de eerste is }
          IF (PrevItemPtr = NIL) THEN
             FirstItemPtr:=HulpItemPtr^.NextItemPtr
          ELSE
              { vorige chainen aan onze opvolger }
              PrevItemPtr^.NextItemPtr:=HulpItemPtr^.NextItemPtr;

          { LastItemPtr updaten }
          { als het te verwijderen item de laatste is, dan wordt de }
          { new laatste PrevItemPtr^.                               }
          IF (LastItemPtr = HulpItemPtr) THEN
             LastItemPtr:=PrevItemPtr; { wordt automatisch NIL bij lege lijst }

          { als dit item getagged was dat de teller aanpassen }
          IF HulpItemPtr^.IsTagged THEN
             Dec (TagCount);

          { geheugen van dit item vrijgeven }
          WITH HulpItemPtr^ DO
               StrDispose (Item);

          FreeMem (HulpItemPtr,SizeOf (ListItemRecord));

          { nu een item minder in de lijst }
          Dec (ItemCount);

          { corrigeer zodat de cursor op het huidige item blijft staan }
          { Dit gaat alleen mis als er items vOOr de cursor regel      }
          { verwijderd zijn.                                           }
          IF (FromTop < TopItemOffset+BalkOffset) THEN
          BEGIN
               IF (TopItemOffset > 0) THEN
                  Dec (TopItemOffset)
               ELSE
                   Dec (BalkOffset);
          END ELSE
              { het gaat ook mis als de lijst nu korten is geworden en }
              { de inhoud van het window straks omlaag moet scrollen   }
              { om het gat weer te vullen.                             }
              IF (TopItemOffset > ItemCount-(CurrH-4)) THEN
              BEGIN
                   Dec (TopItemOffset);

                   { de cursor staat dus ook in dit deel en die }
                   { moet nu dus omlaag.                        }
                   {Inc (BalkOffset);}
              END;

          { cursor omhoog trekken als het nodig is }
          IF (TopItemOffset+BalkOffset > ItemCount) THEN
             IF (BalkOffset > 1) THEN
                IF (TopItemOffset > 0) THEN
                   Dec (TopItemOffset)
                ELSE
                    Dec (BalkOffset);

          IF ReCount THEN
          BEGIN
               WidestItem:=0;

               HulpItemPtr:=FirstItemPtr;
               WHILE (HulpItemPtr <> NIL) DO
               BEGIN
                    Len:=StrLen (HulpItemPtr^.Item);
                    IF (Len > WidestItem) THEN
                       WidestItem:=Len;
                    HulpItemPtr:=HulpItemPtr^.NextItemPtr;
               END; { while }
          END; { if recount }
     END; { with }
END;


{---------------------------------------------------------------------------}
{ ListRemoveAllItems                                                        }
{                                                                           }
{ Deze routine verwijderd alle items uit de lijst en geeft het geheugen     }
{ ervan weer vrij en zet de lijst dan weer in de uitgangspositie als na een }
{ ListDefine. Het window blijft staan.                                      }
{                                                                           }
PROCEDURE ListRemoveAllItems;

VAR HulpItemPtr,
    EraseItemPtr : ListItemRecordPtr;

BEGIN
     IF (CurrListPtr = NIL) THEN
        Exit;

     WITH CurrListPtr^ DO
     BEGIN
          HulpItemPtr:=FirstItemPtr;
          WHILE (HulpItemPtr <> NIL) DO
          BEGIN
               EraseItemPtr:=HulpItemPtr;
               HulpItemPtr:=HulpItemPtr^.NextItemPtr;

               StrDispose (EraseItemPtr^.Item);
               FreeMem (EraseItemPtr,SizeOf (ListItemRecord));
          END; { while }

          FirstItemPtr:=NIL;
          LastItemPtr:=NIL;
          ItemCount:=0;
          TagCount:=0;
     END; { with }
END;


{---------------------------------------------------------------------------}
{ ListItemCount                                                             }
{                                                                           }
{ Deze routine geeft het aantal items dat op dit moment in de lijst zit     }
{ terug.                                                                    }
{                                                                           }
FUNCTION ListItemCount : WORD;
BEGIN
     IF (CurrListPtr = NIL) THEN
        ListItemCount:=0
     ELSE
         ListItemCount:=CurrListPtr^.ItemCount;
END;


{---------------------------------------------------------------------------}
{ ListTagCount                                                              }
{                                                                           }
{ Deze routine geeft terug hoeveel items in de lijst getagged zijn.         }
{                                                                           }
FUNCTION ListTagCount : WORD;
BEGIN
     IF (CurrListPtr = NIL) THEN
        ListTagCount:=0
     ELSE
         ListTagCount:=CurrListPtr^.TagCount;
END;


{---------------------------------------------------------------------------}
{ ListGetTaggedItemNr                                                       }
{                                                                           }
{ Deze routine geeft het item nummer terug van het n-de getagde item. Let   }
{ op dat als de items verwijderd worden waarvan hier het nummer is          }
{ opgevraagd, dat dan alle TagNr's ook 1 opschuiven. Vraag in dat geval     }
{ steeds het item nummer van het eerste getagde item op zolang er nog items }
{ getagged zijn (ListTagCount <> 0).                                        }
{                                                                           }
FUNCTION ListGetTaggedItemNr (TagNr : WORD) : WORD;

VAR HulpItemPtr : ListItemRecordPtr;

BEGIN
     ListGetTaggedItemNr:=0;

     IF (CurrListPtr = NIL) OR (TagNr = 0) OR (TagNr > CurrListPtr^.TagCount) THEN
        Exit;

     HulpItemPtr:=CurrListPtr^.FirstItemPtr;
     WHILE (HulpItemPtr <> NIL) AND (TagNr > 0) DO
     BEGIN
          IF (HulpItemPtr^.IsTagged) THEN
          BEGIN
               Dec (TagNr);
               IF (TagNr = 0) THEN
                  ListGetTaggedItemNr:=HulpItemPtr^.Nummer;
          END;

          HulpItemPtr:=HulpItemPtr^.NextItemPtr;
     END; { while }
END;


{---------------------------------------------------------------------------}
{ ListGetTaggedItemTekst                                                    }
{                                                                           }
{ Met deze routine kan van het n-de getagde item de tekst verkregen worden. }
{                                                                           }
FUNCTION ListGetTaggedItemTekst (TagNr : WORD) : STRING;

VAR HulpItemPtr : ListItemRecordPtr;

BEGIN
     ListGetTaggedItemTekst:='';

     IF (CurrListPtr = NIL) OR (TagNr = 0) OR (TagNr > CurrListPtr^.TagCount) THEN
        Exit;

     HulpItemPtr:=CurrListPtr^.FirstItemPtr;
     WHILE (HulpItemPtr <> NIL) AND (TagNr > 0) DO
     BEGIN
          IF (HulpItemPtr^.IsTagged) THEN
          BEGIN
               Dec (TagNr);
               IF (TagNr = 0) THEN
                  ListGetTaggedItemTekst:=StrPas (HulpItemPtr^.Item);
          END;

          HulpItemPtr:=HulpItemPtr^.NextItemPtr;
     END; { while }
END;


{---------------------------------------------------------------------------}
{ ListTagItem                                                               }
{                                                                           }
{ Met deze routine kan een item de 'tagged' status gegeven worden. No       }
{ worries als het item al getagged was, dan is er niets aan het handje.     }
{                                                                           }
PROCEDURE ListTagItem (ItemNr : WORD);

VAR HulpItemPtr : ListItemRecordPtr;

BEGIN
     IF (CurrListPtr = NIL) THEN
        Exit;

     HulpItemPtr:=CurrListPtr^.FirstItemPtr;
     WHILE (HulpItemPtr <> NIL) AND (HulpItemPtr^.Nummer <> ItemNr) DO
           HulpItemPtr:=HulpItemPtr^.NextItemPtr;

     IF (HulpItemPtr = NIL) OR (HulpItemPtr^.IsTagged) THEN
        Exit;

     HulpItemPtr^.IsTagged:=TRUE;
     Inc (CurrListPtr^.TagCount);
END;


{---------------------------------------------------------------------------}
{ ListUntagItem                                                             }
{                                                                           }
{ Met deze routine kan de tagged vlag van een item verwijderd worden.       }
{                                                                           }
PROCEDURE ListUntagItem (ItemNr : WORD);

VAR HulpItemPtr : ListItemRecordPtr;

BEGIN
     IF (CurrListPtr = NIL) THEN
        Exit;

     HulpItemPtr:=CurrListPtr^.FirstItemPtr;
     WHILE (HulpItemPtr <> NIL) AND (HulpItemPtr^.Nummer <> ItemNr) DO
           HulpItemPtr:=HulpItemPtr^.NextItemPtr;

     IF (HulpItemPtr = NIL) OR (NOT HulpItemPtr^.IsTagged) THEN
        Exit;

     HulpItemPtr^.IsTagged:=FALSE;
     Dec (CurrListPtr^.TagCount);
END;


{---------------------------------------------------------------------------}
{ ListCalcWindowPos                                                         }
{                                                                           }
{ Deze routine berekend de positie van het huidige lijst op het scherm aan  }
{ de hand van CurrW, CurrH, AnchorX, AnchorY en AnchorHow.                  }
{                                                                           }
PROCEDURE ListCalcWindowPos (VAR X,Y : XYType);
BEGIN
     IF (CurrListPtr = NIL) THEN
     BEGIN
          X:=1;
          Y:=1;
          Exit;
     END;

     WITH CurrListPtr^ DO
          CASE AnchorHow OF
               Default,
               TopLeft :
                   BEGIN
                        { de standaard manier }
                        X:=AnchorX;
                        Y:=AnchorY;
                   END;

               TopRight :
                   BEGIN
                        X:=AnchorX-CurrW+1;
                        Y:=AnchorY;
                   END;

               BottomLeft :
                   BEGIN
                        X:=AnchorX;
                        Y:=AnchorY-CurrH+1;
                   END;

               BottomRight :
                   BEGIN
                        X:=AnchorX-CurrW+1;
                        Y:=AnchorY-CurrH+1;
                   END;
          END; { case }
END;


{---------------------------------------------------------------------------}
{ ListCalcWindowSize                                                        }
{                                                                           }
{ Deze routine berekend voor de huidige lijst de benodigde afmetingen en    }
{ geeft deze terug. Er zijn minimale afmetingen die de lijst moet hebben en }
{ maximale afmetingen die opgegeven zijn bij de definitie.                  }
{                                                                           }
PROCEDURE ListCalcWindowSize (VAR W,H : XYType);

VAR HulpItemPtr : ListItemRecordPtr;
    NrsW        : BYTE;

BEGIN
     W:=4;
     H:=5;

     IF (CurrListPtr = NIL) THEN
        Exit;

     WITH CurrListPtr^ DO
     BEGIN
          { maximum breedte }
          IF (StrLen (Titel) <> 0) THEN
             W:=4+StrLen (Titel); { zowiezo nodig }

          { kijk hoeveel ruimte the item+tag counters nodig hebben }
          NrsW:=4+Length (Word2String (ItemCount))+2{haakjes};

          IF (TagCount > 0) THEN
             NrsW:=NrsW+1{spatie}+Length (Word2String (TagCount))+2{haakjes};

          IF (NrsW > W) THEN
             W:=NrsW;

          IF (4+WidestItem > W) THEN
             W:=4+WidestItem;

          IF (W > MaxW) THEN W:=MaxW;

          { hoogte }
          IF (4+ItemCount > MaxH) THEN
             H:=MaxH { maximale lengte }
          ELSE
              H:=4+ItemCount; { nieuw langer dan nodig }
     END;
END;


{---------------------------------------------------------------------------}
{ ListSetCursorOnItem                                                       }
{                                                                           }
{ Deze routine verplaatst de cursor naar het opgegeven item. Als het item   }
{ nummer niet bestaat, dan blijft de cursor op het huidige item staan. Er   }
{ wordt geprobeerd de cursor in het midden van de select list te houden.    }
{                                                                           }
FUNCTION ListSetCursorOnItem (ItemNr : WORD) : BOOLEAN;

VAR ZoekItemPtr : ListItemRecordPtr;
    W,H,HalfH   : XYType;

BEGIN
     ListSetCursorOnItem:=FALSE; { assume not found }

     IF (CurrListPtr = NIL) THEN
        Exit;

     ZoekItemPtr:=CurrListPtr^.FirstItemPtr;
     WHILE (ZoekItemPtr <> NIL) AND (ZoekItemPtr^.Nummer <> ItemNr) DO
           ZoekItemPtr:=ZoekItemPtr^.NextItemPtr;

     IF (ZoekItemPtr = NIL) THEN
        Exit;

     WITH CurrListPtr^ DO
     BEGIN
          ListCalcWindowSize (W,H);
          HalfH:=(H-4) DIV 2;

          TopItemOffset:=0;
          BalkOffset:=1;

          ZoekItemPtr:=CurrListPtr^.FirstItemPtr;
          WHILE (ZoekItemPtr^.Nummer <> ItemNr) DO
          BEGIN
               IF (BalkOffset < HalfH) THEN
                  Inc (BalkOffset)
               ELSE
                   IF (TopItemOffset < ItemCount-(H-4)) THEN
                      Inc (TopItemOffset)
                   ELSE
                       Inc (BalkOffset); { bij laatste items vd lijst }

               ZoekItemPtr:=ZoekItemPtr^.NextItemPtr;
          END; { while }
     END; { with }

     ListSetCursorOnItem:=TRUE; { found }
END;


{---------------------------------------------------------------------------}
{ ListShow                                                                  }
{                                                                           }
{ Deze routine tekent op het scherm het window waarin de lijst komt te      }
{ staan. Deze komt in enkele omlijning te staan en de afmetingen worden     }
{ opgeslagen. Als het straks nodig is de afmetingen aan te passen dan kan   }
{ dat aan de hand van deze opgeslagen gegeven gebeuren. Het aanpassen aan   }
{ het vorige window gebeurd hier ook meteen. Het List window moet dan ook   }
{ als laatste op de window stack staan.                                     }
{                                                                           }
{ De combinatie ListShow met ListUpdateWindow is bedoeld voor gebruik       }
{ zonder de ListSelect routine om een dynamische lijst met gegeven te tonen }
{ aan de gebruiker. Bijvoorbeeld de nodes die nog geupdate moeten worden.   }
{                                                                           }
{ LineType bepaald of er enkele of dubbele lijnen gebruikt gaan worden.     }
{ Active bepaald de kleur waarin de box getekend wordt. ListSelect doet het }
{ als volgt: bij binnenkomst Double,TRUE en bij vertrek Double,FALSE.       }
{ Single is bedoelde voor informatie windows.                               }
{                                                                           }
PROCEDURE ListShow (LineType : BoxLines{Single/Double}; Active : BOOLEAN);

VAR NewW,NewH,
    NewX,NewY : XYType;
    Title     : STRING;

BEGIN
     ListCalcWindowSize (NewW,NewH);

     WITH CurrListPtr^ DO
     BEGIN
          IF (NewW <> CurrW) OR (NewH <> CurrH) THEN
             IF IsVisible THEN
             BEGIN
                  WindowPop;
                  IsVisible:=FALSE;
             END;

          CurrW:=NewW;
          CurrH:=NewH;

          ListCalcWindowPos (NewX,NewY);

          IF (NewX <> CurrX) OR (NewY <> CurrY) THEN
             IF IsVisible THEN
             BEGIN
                  WindowPop;
                  IsVisible:=FALSE;
             END;

          CurrX:=NewX;
          CurrY:=NewY;

          IF (NOT IsVisible) THEN
          BEGIN
               WindowPush (CurrX,CurrY,CurrW,CurrH);
               IsVisible:=TRUE;

               { het hele window even blauw maken }
               SetColor (cBoxBack);
               FillVideo (CurrX-1,CurrY-1,CurrW,CurrH,' ');
          END;

          { de omlijning tekenen }
          SetLines (LineType); { single/double }
          IF Active THEN BoxSetActive (CurrX,CurrY,CurrW,CurrH)
                    ELSE BoxSetInActive (CurrX,CurrY,CurrW,CurrH);

          { dwarsbalk opnieuw tekenen }
          WriteXY (CurrX,CurrY+2,TL+RepChar (CurrW-2,HO)+TR);

          { title erin schrijven }
          WriteXY (CurrX+(CurrW DIV 2)-(StrLen (Titel) DIV 2),CurrY+1,StrPas (Titel));

          { gebruik nu zelf ListUpdateWindow om de items erin te zetten }
     END; { with }
END;


{---------------------------------------------------------------------------}
{ ListUpdateWindow                                                          }
{                                                                           }
{ Deze routine drukt de huidige set items in het window af ahv de huidige   }
{ top-of-list instellingen. LineOffset is de shift die alle regels naar     }
{ links maken (scrollen naar rechts dus) en CursorLine is de regel waarop   }
{ de cursor komt te staan en moet 1 tot en met CurrH-4 zijn. 0 betekend dat }
{ er geen cursor in beeld komt. Als CursorLine een illegale waarde bevat    }
{ (groter dan CurrH-4), dan wordt ie 0 gemaakt.                             }
{ Na aanroep van deze routine bevatten ListCursorItemPtr en ListLastCursorY }
{ weer up to date values.                                                   }
{                                                                           }
PROCEDURE ListUpdateWindow (Active : BOOLEAN; LineOffset : BYTE; CursorLine : INTEGER);

VAR ItemsStr    : STRING[9]; { max: " (65535) " }
    TopItemPtr  : ListItemRecordPtr;
    Teller      : WORD;
    PrintItem   : STRING;
    Rest        : INTEGER;
    ScrollIndex : BYTE;

BEGIN
     IF (CurrListPtr = NIL) THEN
        Exit;

     ListCursorItemPtr:=NIL; { in case the cursor doesn't show up }

     WITH CurrListPtr^ DO
     BEGIN
          { aantal items afdrukken }
          IF Active THEN SetColor (cBoxLinesActive)
                    ELSE SetColor (cBoxLinesInActive);

          WriteXY (CurrX+1,CurrY,' ('+Word2String (ItemCount)+') ');

          { als er items getagged zijn, dan dat aantal ook op de regel }
          { zetten (als dit een actief window is, dan in groen, anders }
          { in wit).                                                   }
          IF (TagCount > 0) THEN
          BEGIN
               IF Active THEN
                  SetColor (cBoxDataTagged);

               RWrite ('('+Word2String (TagCount)+') ');

               IF Active THEN
                  SetColor (cBoxLinesActive);
          END;

          { rest van de lijn aanvullen }
          RWrite (RepChar (CurrW-(RWhereX-CurrX)-1,HO));

          { controleren of TopItemOffset legaal is }
          IF (CursorLine > CurrH-4) THEN
             CursorLine:=0; { uitzetten }

          IF (TopItemOffset > ItemCount-(CurrH-4)) THEN
             TopItemOffset:=ItemCount-(CurrH-4);

          { nu de items er nog in afdrukken }

          { TopItemOffset bepaald het eerste item dat in beeld komt }
          TopItemPtr:=FirstItemPtr;
          Teller:=TopItemOffset;

          WHILE (TopItemPtr <> NIL) AND (Teller <> 0) DO
          BEGIN
               TopItemPtr:=TopItemPtr^.NextItemPtr;
               Dec (Teller);
          END; { while }

          IF (TopItemPtr = NIL) THEN
          BEGIN
               { vul het window in een rood kleurtje }
               SetColor (cError);
               FillVideo (CurrX,CurrY+2,CurrW-2,CurrH-4,'X');
               Exit; { probleem met list routines }
          END;

          IF (ItemCount = (CurrH-4)) THEN
             ScrollIndex:=0
          ELSE
              ScrollIndex:=1+Trunc ((TopItemOffset/(ItemCount-(CurrH-4)))*(CurrH-5));

          FOR Teller:=1 TO CurrH-4 DO
          BEGIN
               RGotoXY (CurrX+1,CurrY+2+Teller);
               SetColor (cBoxData);

               IF (Teller = 1) AND (TopItemOffset > 0) THEN
                  { eerste regel }
                  RWrite ('')
               ELSE
                   { tussen regels }
                   IF (Teller = ScrollIndex) THEN
                      RWrite ('')
                   ELSE
                       IF (Teller < CurrH-4) THEN
                          RWrite ('')
                       ELSE
                           { laatste regel }
                           IF (TopItemPtr^.NextItemPtr = NIL) THEN RWrite ('')
                                                              ELSE RWrite ('');

               PrintItem:=Copy (StrPas (TopItemPtr^.Item),LineOffset+1,255);
               IF (Length (PrintItem) > CurrW-3) THEN
                  PrintItem:=Copy (PrintItem,1,CurrW-4)+''
               ELSE
                   PrintItem:=AddUpWithSpaces (CurrW-3,PrintItem);

               IF (TopItemPtr^.Nummer >= 65000) THEN
                  SetColor (cNotTagable)
               ELSE
                   IF TopItemPtr^.IsTagged THEN SetColor (cBoxDataTagged)
                                           ELSE SetColor (cBoxData);

               IF (Teller = CursorLine) THEN
               BEGIN
                    ListCursorItemPtr:=TopItemPtr;
                    ListLastCursorY:=RWhereY;

                    IF TopItemPtr^.IsTagged THEN SetColor (cFieldCursorTagged)
                                            ELSE SetColor (cFieldCursor);

                    IF (LineOffset > 0) THEN
                       PrintItem[1]:='';
               END;

               IF (Teller = -CursorLine) THEN
               BEGIN
                    { in het geel, voor als we de lijst verlaten }
                    SetColor (cMenuSelected);
               END;

               RWrite (PrintItem);

               TopItemPtr:=TopItemPtr^.NextItemPtr;
          END; { for }
     END; { with }
END;


{---------------------------------------------------------------------------}
{ ListHideWindow                                                            }
{                                                                           }
{ Deze routine verwijderd het list window van het scherm en onthoudt dit.   }
{ Bij de eerstvolgende aanroep van ListShow wordt ie weer neergezet.        }
{                                                                           }
PROCEDURE ListHideWindow;
BEGIN
     IF (CurrListPtr = NIL) THEN
        Exit;

     WITH CurrListPtr^ DO
          IF IsVisible THEN
          BEGIN
               WindowPop;
               IsVisible:=FALSE;
          END;
END;


{--------------------------------------------------------------------------}
{ MultipleTag                                                              }
{                                                                          }
{ Met deze routine kan een tag of untag uitgevoerd worden om meerdere      }
{ items tegelijk. Welke items wordt bepaald door het Tag argument.         }
{                                                                          }
PROCEDURE MultipleTag (NewTagValue : BOOLEAN);

CONST Xb = 30;
      Yb = 10;
      Xl = 20;
      Yl = 5;

VAR TagItemPtr  : ListItemRecordPtr;
    TagArgument : STRING;
    ItemStr     : STRING;

BEGIN
     { get tag argument }
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     IF NewTagValue THEN WriteXY (Xb+2,Yb+1,'Tag argument?')
                    ELSE WriteXY (Xb+2,Yb+1,'Untag argument?');

     FieldPushAll;
     FieldInit;
     TagArgument:=Spaces (254);

     FieldDefineLongOne (1,Xb+2,Yb+3,254,16,0,0,@TagArgument,RepChar (254,'$'));
     FieldEditDirect;

     TagArgument:=UpCaseString (DeleteBackSpaces (TagArgument));

     IF (Key = kRet) THEN
     BEGIN
          TagItemPtr:=CurrListPtr^.FirstItemPtr;
          WHILE (TagItemPtr <> NIL) DO
                WITH TagItemPtr^ DO
                BEGIN
                     ItemStr:=UpCaseString (StrPas (Item));

                     IF (Nummer < 65000) AND
                        ((TagArgument = '') OR
                         (Pos (TagArgument,ItemStr) <> 0)) THEN
                     BEGIN
                          IF IsTagged THEN Dec (CurrListPtr^.TagCount);
                          IsTagged:=NewTagValue;
                          IF IsTagged THEN Inc (CurrListPtr^.TagCount);
                     END;

                     TagItemPtr:=NextItemPtr;
                END; { with, while }
     END; { if }

     FieldPopAll;
     WindowPop;
END;


{---------------------------------------------------------------------------}
{ ListSelect                                                                }
{                                                                           }
{ Met deze routine kan een keuze uit de list gemaakt worden. Met de cursor  }
{ toetsen kan door de lijst gelopen worden en met enter wordt een keuze     }
{ gemaakt. Als CanTag gelijk is aan DoTag, dan kan er ook getagged worden   }
{ en de SpecialKeys worden teruggegeven als ze ingedrukt worden. De waarde  }
{ van Key bevat de toets die gebruikt is om uit de lijst te komen. Het      }
{ resultaat van deze functie is het item nummer van het gekozen item. Bij   }
{ taggen geldt dat ListTagCount het aantal items bevat, waarna met          }
{ ListGetTaggedItemNr en ListGetTaggedItemTekst de gegevens opgehaalde      }
{ kunnen worden van het n-de getagde item.                                  }
{ Aanroep van ListShow of ListUpdateWindow is niet nodig, dat doet deze     }
{ routine zelf. Pas als de lijst niet meer nodig is moet ListErase          }
{ aangeroepen worden.                                                       }
{                                                                           }
FUNCTION ListSelect (CanTag : ListTagType; SpecialKeys : ListSpecialKeys) : WORD;

VAR SpecialQuit,
    Quit,
    ReSearch          : BOOLEAN;
    ZoekStr           : STRING;
    PrevTopItemOffset : WORD;
    PrevBalkOffset,
    PrevShiftOffset   : BYTE;
    ForceKey          : KeyType; { voor kDown na kF5 (tag) }
    PrevNr,ItemNr     : WORD;
    SearchItemPtr     : ListItemRecordPtr;

BEGIN
     WITH CurrListPtr^ DO
          IF LowMem THEN
             Error2Lines ('There was not enough memory to show all the '+
                          Word2String (ItemCount+ItemsNoMem)+' items for this list.',
                          'You will only see the first '+Word2String (ItemCount)+' items.');

     ListShow (Double,TRUE{active});

     { keysline na de ListShow aanroepen }
     PushKeysLine;
     IF (CanTag = DoTag) THEN WriteKeysLine (ListTagKeysLine)
                         ELSE WriteKeysLine (ListNoTagKeysLine);

     ZoekStr:='';
     ReSearch:=FALSE;
     Quit:=FALSE;
     ForceKey:=kUnknown;

     PrevTopItemOffset:=0;
     PrevBalkOffset:=0; { moet bij lijst altijd >0 zijn }
     PrevShiftOffset:=0;

     WITH CurrListPtr^ DO
          REPEAT
                IF ReSearch THEN
                BEGIN
                     SearchItemPtr:=FirstItemPtr;
                     TopItemOffset:=0;
                     BalkOffset:=1;

                     WHILE (SearchItemPtr <> NIL) DO
                     BEGIN
                          IF (UpCaseString (Copy (StrPas (SearchItemPtr^.Item),1,Length (ZoekStr))) = ZoekStr) THEN
                              Break; { repeat/until }

                           IF (BalkOffset < CurrH-4) THEN
                              Inc (BalkOffset)
                           ELSE
                               Inc (TopItemOffset);

                           SearchItemPtr:=SearchItemPtr^.NextItemPtr;
                     END; { while }

                     IF (SearchItemPtr = NIL) THEN
                     BEGIN
                          TopItemOffset:=PrevTopItemOffset;
                          BalkOffset:=PrevBalkOffset;
                          Delete (ZoekStr,Length (ZoekStr),1);
                          Write (#7); { beep }
                     END;

                     ReSearch:=FALSE;
                END;

                { bij het zoeken het window automatisch shiften }
                IF (Length (ZoekStr) > CurrW-5) THEN
                   ShiftOffset:=Length (ZoekStr)-(CurrW-5);

                { items in het window (opnieuw) afdrukken }
                IF (PrevTopItemOffset <> TopItemOffset) OR
                   (PrevBalkOffset <> BalkOffset) OR
                   (PrevShiftOffset <> ShiftOffset) THEN
                BEGIN
                     ListUpdateWindow (TRUE,ShiftOffset,BalkOffset);

                     PrevTopItemOffset:=TopItemOffset;
                     PrevBalkOffset:=BalkOffset;
                     PrevShiftOffset:=ShiftOffset;
                END;

                { cursor bij het zoeken op de juiste positie zetten }
                IF (ZoekStr <> '') THEN
                BEGIN
                     CursorGotoXY (CurrX+Length (ZoekStr)+2-ShiftOffset,ListLastCursorY);
                     CursorOn;
                END;

                { toetsdruk vragen }
                IF (ForceKey <> kUnknown) THEN
                BEGIN
                     Key:=ForceKey;
                     ForceKey:=kUnknown;
                END ELSE
                    ReadKey;

                CursorOff;

                SpecialQuit:=(Key IN SpecialKeys);

                CASE Key OF
                     kEsc : Quit:=TRUE;

                     kUp : BEGIN
                                ZoekStr:='';

                                IF (BalkOffset > 1) THEN
                                   Dec (BalkOffset)
                                ELSE
                                    IF (TopItemOffset > 0) THEN
                                       Dec (TopItemOffset);
                           END; { kUp }

                     kDown : BEGIN
                                  ZoekStr:='';

                                  IF (BalkOffset < CurrH-4) THEN
                                     Inc (BalkOffset)
                                  ELSE
                                      IF (TopItemOffset < ItemCount-BalkOffset) THEN
                                         Inc (TopItemOffset);

                             END; { kDown }

                     kPgUp : BEGIN
                                  ZoekStr:='';

                                  IF (BalkOffset > 1) THEN
                                     BalkOffset:=1
                                  ELSE
                                      IF (TopItemOffset > (CurrH-4)) THEN
                                         Dec (TopItemOffset,CurrH-4)
                                      ELSE
                                          TopItemOffset:=0;
                             END; { kPgUp }

                     kPgDn : BEGIN
                                  ZoekStr:='';

                                  IF (BalkOffset < CurrH-4) THEN
                                     BalkOffset:=CurrH-4
                                  ELSE
                                      IF (TopItemOffset < ItemCount-BalkOffset) THEN
                                         Inc (TopItemOffset,BalkOffset)
                                      ELSE
                                          TopItemOffset:=ItemCount-BalkOffset;
                             END; { kPgDn }

                     kCtrlHome,
                     kCtrlPgUp : BEGIN
                                      ZoekStr:='';
                                      TopItemOffset:=0;
                                      BalkOffset:=1;
                                 END; { kCtrlPgUp }

                     kCtrlEnd,
                     kCtrlPgDn : BEGIN
                                      ZoekStr:='';
                                      BalkOffset:=CurrH-4;
                                      TopItemOffset:=ItemCount-BalkOffset;
                                 END; { kCtrlPgDn }

                     kLeft : BEGIN
                                  ZoekStr:='';

                                  IF (ShiftOffset > 0) THEN
                                     Dec (ShiftOffset);
                             END; { kLeft }

                     kRight : BEGIN
                                   ZoekStr:='';

                                   IF (ShiftOffset < WidestItem-(CurrW-3)) THEN
                                      Inc (ShiftOffset);
                              END; { kRight }

                     kCtrlLeft : BEGIN
                                      ZoekStr:='';

                                      IF (ShiftOffset > (CurrW-3)) THEN
                                         Dec (ShiftOffset,(CurrW-3))
                                      ELSE
                                          ShiftOffset:=0;
                                 END; { kCtrlLeft }

                     kCtrlRight : BEGIN
                                       ZoekStr:='';

                                       IF (ShiftOffset < WidestItem-(CurrW*2-6)) THEN
                                          Inc (ShiftOffset,CurrW-3)
                                       ELSE
                                           ShiftOffset:=WidestItem-(CurrW-3);
                                  END; { kCtrlRight }

                     kHome : BEGIN
                                  ZoekStr:='';
                                  ShiftOffset:=0;
                             END;

                     kEnd : BEGIN
                                 ZoekStr:='';
                                 IF ((CurrW-3) <= WidestItem) THEN
                                    ShiftOffset:=WidestItem-(CurrW-3);
                            END;

                     kAltPgUp : BEGIN
                                     ZoekStr:='';
                                     PrevNr:=0; { nog niets gevonden }
                                     ItemNr:=1;

                                     ListCursorItemPtr:=FirstItemPtr;
                                     WHILE (ListCursorItemPtr <> NIL) AND
                                           (ItemNr < TopItemOffset+BalkOffset) DO
                                     BEGIN
                                          IF (ListCursorItemPtr^.IsTagged) THEN
                                             PrevNr:=ItemNr;

                                          ListCursorItemPtr:=ListCursorItemPtr^.NextItemPtr;
                                          Inc (ItemNr);
                                     END;

                                     IF (PrevNr <> 0) THEN
                                        WHILE (TopItemOffset+BalkOffset <> PrevNr) DO
                                              IF (BalkOffset > 1) THEN
                                                 Dec (BalkOffset)
                                              ELSE
                                                  IF (BalkOffset = 1) AND (TopItemOffset > 0) THEN
                                                     Dec (TopItemOffset);

                                     ShiftOffset:=0;
                                END;

                     kAltPgDn : BEGIN
                                     ZoekStr:='';

                                     REPEAT
                                           IF (BalkOffset < CurrH-4) THEN
                                           BEGIN
                                                Inc (BalkOffset);
                                           END ELSE
                                               Inc (TopItemOffset);

                                           ListCursorItemPtr:=ListCursorItemPtr^.NextItemPtr;

                                     UNTIL (ListCursorItemPtr = NIL) OR
                                           (ListCursorItemPtr^.IsTagged);

                                     IF (ListCursorItemPtr = NIL) THEN
                                     BEGIN
                                          BalkOffset:=PrevBalkOffset;
                                          TopItemOffset:=PrevTopItemOffset;
                                          PrevShiftOffset:=1; { force redraw }
                                     END;

                                     ShiftOffset:=0;
                                END;

                     kRet : IF (ListCursorItemPtr^.Nummer < 65000) THEN
                               Quit:=TRUE;

                     kBs : IF (ZoekStr <> '') THEN
                           BEGIN
                                Delete (ZoekStr,Length (ZoekStr),1);
                                ReSearch:=TRUE;
                           END;

                     kF1 : IF (HelpHandle <> 0) THEN
                              RequestHelp (HelpHandle)
                           ELSE
                               Quit:=SpecialQuit;

                     kF5 : IF (CanTag = DoTag) THEN
                           BEGIN
                                IF (ListCursorItemPtr <> NIL) THEN
                                   WITH ListCursorItemPtr^ DO
                                        IF (Nummer < 65000) THEN
                                        BEGIN
                                             IF IsTagged THEN Dec (TagCount);
                                             IsTagged:=NOT (IsTagged);
                                             IF IsTagged THEN Inc (TagCount);

                                             Inc (PrevBalkOffset); { force reprint }
                                             ForceKey:=kDown;
                                        END;
                           END ELSE
                               Quit:=SpecialQuit;

                     kF6 : IF (CanTag = DoTag) THEN
                           BEGIN
                                MultipleTag (TRUE);
                                Inc (PrevShiftOffset); { force redraw }
                           END ELSE
                               Quit:=SpecialQuit;

                     kF7 : IF (CanTag = DoTag) THEN
                           BEGIN
                                MultipleTag (FALSE);
                                Inc (PrevShiftOffset); { force redraw }
                           END ELSE
                               Quit:=SpecialQuit;

                     kUnknown : IF (AsciiKey IN [' '..'~']) THEN
                                BEGIN
                                     ZoekStr:=ZoekStr+UpCase (AsciiKey);
                                     ReSearch:=TRUE;
                                END;

                     ELSE Quit:=SpecialQuit;

                END; { case }

          UNTIL Quit; { en with }

     ListSelect:=ListCursorItemPtr^.Nummer;
     WITH CurrListPtr^ DO
          ListUpdateWindow (FALSE{inactive},ShiftOffset,-BalkOffset{in het geel});
     ListShow (Double,FALSE{inactive});
     PopKeysLine;
END;


{---------------------------------------------------------------------------}
{ ListErase                                                                 }
{                                                                           }
{ Alle items van deze lijst vrijgeven en daarna de lijst zelf ook weggooien }
{ en de vorige lijst weer actief maken.                                     }
{                                                                           }
PROCEDURE ListErase;

VAR HulpItemPtr,
    EraseItemPtr : ListItemRecordPtr;
    EraseListPtr : ListRecordPtr;

BEGIN
     IF (CurrListPtr = NIL) THEN
        Exit;

     Message ('Destroying list, please wait...');

     HulpItemPtr:=CurrListPtr^.FirstItemPtr;
     WHILE (HulpItemPtr <> NIL) DO
     BEGIN
          EraseItemPtr:=HulpItemPtr;
          HulpItemPtr:=HulpItemPtr^.NextItemPtr;

          { item tekst opslag vrijgeven }
          StrDispose (EraseItemPtr^.Item);

          { item opslag vrijgeven }
          FreeMem (EraseItemPtr,SizeOf (ListItemRecord));
     END; { while }

     WITH CurrListPtr^ DO
     BEGIN
          StrDispose (Titel);

          IF IsVisible THEN
             WindowPop;
     END; { with }

     EraseListPtr:=CurrListPtr;
     CurrListPtr:=CurrListPtr^.PrevListPtr;

     FreeMem (EraseListPtr,SizeOf (ListRecord));

     WindowPop;
END;


{--------------------------------------------------------------------------}
{ ListGetPrevItemNr                                                        }
{                                                                          }
{ Met deze routine kan het item nummer opgehaald worden van het item dat   }
{ voor dit item in de lijst staat. Als er geen vorige item is, dan wordt   }
{ hetzelfde item nummer terug gegeven. Dit kan gebruikt worden om de       }
{ gesorteerde lijst ergens anders voor de misbruiken. Als dit nummer niet  }
{ bestaat, dan wordt hetzelfde nummer terug gegeven.                       }
{                                                                          }
FUNCTION ListGetPrevItemNr (ItemNr : WORD) : WORD;

VAR HulpItemPtr : ListItemRecordPtr;

BEGIN
     ListGetPrevItemNr:=ItemNr; { assume not found }

     IF (CurrListPtr = NIL) THEN
        Exit; { er is niet eens een lijst }

     HulpItemPtr:=CurrListPtr^.FirstItemPtr;
     WHILE (HulpItemPtr <> NIL) AND (HulpItemPtr^.NextItemPtr <> NIL) AND (HulpItemPtr^.NextItemPtr^.Nummer <> ItemNr) DO
           HulpItemPtr:=HulpItemPtr^.NextItemPtr;

     IF (HulpItemPtr <> NIL) AND (HulpItemPtr^.NextItemPtr <> NIL) AND (HulpItemPtr^.NextItemPtr^.Nummer = ItemNr) THEN
        ListGetPrevItemNr:=HulpItemPtr^.Nummer;
END;


{--------------------------------------------------------------------------}
{ ListGetNextItemNr                                                        }
{                                                                          }
{ Met deze routine kan het item nummer opgehaald worden van het item dat   }
{ volgt op dit item. Als het resultaat hetzelfde nummer is, dan is er      }
{ geen opvolger. Dit kan gebruikt worden om de gesorteerde lijst te        }
{ misbruiken. Als dit nummer niet bestaat wordt hetzelfde nummer terug     }
{ gegeven.                                                                 }
{                                                                          }
FUNCTION ListGetNextItemNr (ItemNr : WORD) : WORD;

VAR HulpItemPtr : ListItemRecordPtr;

BEGIN
     ListGetNextItemNr:=ItemNr; { assume not found }

     IF (CurrListPtr = NIL) THEN
        Exit;

     HulpItemPtr:=CurrListPtr^.FirstItemPtr;
     WHILE (HulpItemPtr <> NIL) AND (HulpItemPtr^.Nummer <> ItemNr) DO
           HulpItemPtr:=HulpItemPtr^.NextItemPtr;

     { als ie gevonden is en er een opvolger is, geef dat nummer dan terug }
     IF (HulpItemPtr <> NIL) AND (HulpItemPtr^.NextItemPtr <> NIL) THEN
        ListGetNextItemNr:=HulpItemPtr^.NextItemPtr^.Nummer;
END;

{ einde LIST.INC }
