{ Startup WtrGate                                                       }
{                                                                       }
{ Deze routine controleerd of de configuratie file in orde is, en of    }
{ er genoeg geheugen is om door te gaan.                                }

{ Include file voor WtrGate.PAS }

{ RWI 950524: was 200000. Omlaag gehaald omdat we nu een swapfile hebben }
{ RWI 961012: was 120000. Omlaag gehaald omdat we nu een beter met ons   }
{                         geheugen om gaan en makkelijk met 80kb uit de  }
{                         voeten kunnen.                                 }
CONST MemNeeded = LONGINT(80000);

{ functie om bestaan directory te controleren }
FUNCTION DirExist (Dir : STRING) : BOOLEAN;

VAR FindFile : SearchRec;

BEGIN
     DirExist:=FALSE;

     IF (Dir[Length(Dir)] = '\') THEN
        Dec (Dir[0]);

     IF (DiskFree (Ord (Dir[1])-64) = -1) THEN
        Exit;

     IF (Length (Dir) > 3) THEN
     BEGIN
          FindFirst (Dir,Directory,FindFile);
          IF (DosError <> 0) THEN
          BEGIN
               FindClose (FindFile);
               Exit;
          END;
          FindClose (FindFile);
     END;

     DirExist:=TRUE;
END;


{--------------------------------------------------------------------------}
{ StartUpWtrGate                                                           }
{                                                                          }
FUNCTION StartUpWtrGate : BOOLEAN;

VAR LoopVar : WORD;

BEGIN
     StartUpWtrGate:=TRUE; { assume ok }

     WITH Config DO
     BEGIN
          { controleer of de systeem directory wel bestaat }
          IF (NOT DirExist (SystemDir)) THEN
          BEGIN
               WriteLn ('  Unable to find System directory!');
               StartUpWtrGate:=FALSE;
          END;

          IF (Fido2Str (Config.NodeNrs[1]) = '0') THEN
          BEGIN
               WriteLn ('  Primary FTN system node number is not defined!');
               StartUpWtrGate:=FALSE;
          END;

          { Controleer of de TooLarge directory wel bestaat }
          IF (NOT DirExist (TooLargePath)) THEN
          BEGIN
               Writeln('  Unable to find directory for too big messages!');
               StartUpWtrGate:=FALSE;
          END;

          { Controleer of de Inbound directory's wel bestaan }
          FOR LoopVar:=1 TO MaxInboundDirs DO
              IF (DeleteBackSpaces (Inbound_F[LoopVar]) <> '') THEN
                 IF (NOT DirExist (Inbound_F[LoopVar])) THEN
                 BEGIN
                      WriteLn ('  FTN directory does not exist!');
                      StartUpWtrGate:=FALSE;
                 END;

          { Controleer of de Outbound directory wel bestaat }
          IF (NOT DirExist (Outbound_F)) THEN
          BEGIN
               WriteLn ('  FTN outbound directory does not exist!');
               StartUpWtrGate:=FALSE;
          END;

          { Controleer of de spool base directory wel bestaat }
          IF (SpoolBaseDir <> '') THEN
             IF (NOT DirExist (SpoolBaseDir)) THEN
             BEGIN
                  WriteLn ('  UUCP spool directory does not exist!');
                  StartUpWtrGate:=FALSE;
             END;

          { Controleer of er wel een TimeZone string is }
          { non-fatal error                             }
          IF (DeleteBackSpaces (TimeZone) = '') THEN
             TimeZone:='GMT';

     END; { with }
END;

{ end of include file WTRSTART.PAS }
