UNIT Usenet;

{ Routines om Usenet pakketten in te lezen en weg te schrijven }

{ History

RvdW 20-02-93 History gestart.
     27-02-93 Locale buffer routines verwijderd en aan FBuffer geknoopt.
              Read ahead buffer van 1K naar 10000 bytes vergroot.
     02-04-93 Datum wordt vanaf alleen nog bij de start van de toss in de log
              gezet.
     16-05-93 Foutje verwijderd uit de filename munging routine
              FilenameUnix2Waffle.
     25-05-93 Verwijderen van .X en .D files ingebouwd. Zet de Define
              DelFiles uit om ze weer te bewaren.
              WaitKey als parameter ingevoerd zodat bij een commandline
              optie niet op een toets wordt gewacht.
     06-06-93 UsenetSplit en UsenetIsOurDomain geschreven voor de mail
              verwerking.
     12-06-93 FidoPack wordt nu aangeroepen aan het einde van de toss.
     17-06-93 GetUsenetUniqueName aangemaakt die een breedere codering
              gebruikt, waardoor de naam korter wordt. Afgeleid van de Fido
              versie.
MD   11-07-93 Aan UsenetRouteMail begonnen, nadat een mailtje naar school
              terugging naar waffle...
              Figures, zit ik hier een complete usenet mailer te schrijven
              met slechts een paar mailtjes gegenereerd door Waffle, nu is
              het tijd voor een beetje Zen.
     17-07-93 Major rewrite van de Usenet routing routine, het is nog
              steeds een hoop magie, maar nu in ieder geval gestructureerde
              magie. Na het lezen van enige honderden Kb's aan C source
              heb ik nog steeds het idee dat Usenet mail gewoon via een
              random routine wordt geroute...
     21-07-93 Bang path routing toegevoegt. (en het schijnt echt te werken!)
     08-10-93 DeCunBatch is nu intern,... scheelt een HOOP tijd
     06-11-93 Allow SubDomains check toegevoegt
     01-01-94 !!! Happy NewYear !!! Toevoegen van Usenet ListServer
     11-03-94 Usenet BAG file support toegevoegt
     06-04-94 Nu ook onderzoeken of we een 'gunbatch' (GZip) string
              tegenkomen
}

{$DEFINE DelFiles}
{ Verwijder de $ om de .X en .D files NIET te laten wissen }

INTERFACE

USES Msgs,
     Cun,
     Database;

PROCEDURE UucpToss;
PROCEDURE BagToss;
PROCEDURE UsenetSplit (Adres : STRING; VAR Domain : UsenetDomainNameString; VAR User : UsenetUserNameString);
FUNCTION  UsenetArpaNetDate : String;
FUNCTION  UseGetAddress (Source : STRING) : STRING;
FUNCTION  UseScanForPrivate : BOOLEAN;
FUNCTION  GetUsenetUniqueName (Grade : CHAR; ForceNoBitmask : BOOLEAN) : STRING;
FUNCTION  UseGetSystemFromName : STRING;
FUNCTION  UseGetUserFromName (UserData : UserBaseRecord) : STRING;
PROCEDURE UsenetRouteMail;
PROCEDURE UsenetBuildMail (DoelDomain,SUser,SFullName,Subject : STRING);
PROCEDURE UsenetBounceMail (Reason : STRING);
FUNCTION  UsenetReplyAdres : STRING;
FUNCTION  UseCRCMessage : LONGINT;
FUNCTION  UsenetIsOurDomain (Domain : STRING) : BOOLEAN;

{$IFDEF WtrTest}
PROCEDURE FinishUsenetMsgBuildup;
{$ENDIF}

{ voor SMTP }
PROCEDURE AddTossedRegel (VAR Regel : STRING; VAR PrevHad13 : BOOLEAN);
PROCEDURE GoProcess;

VAR AddWhereTo : WhereToType;  { voor AddTossedRegel }


IMPLEMENTATION

USES Dos,
     Globals,
     Ramon,
     Cfg,
     Logs,
     FBuffer,
     AreaBase,
     UserBase,
     FidoMsg,
     Crt,
     Routing,
     DupeChk,
     Keys,
     NewExec,
     MakeOut,
     AreaMgr,
     Stats,
     Fido,
     UseAdres,
     Translat,
     UUCPRout,
     Squish,
     ListSrv,
     SwapMem,
     Language,
     PCBoard,
     JAM,
     Start;

CONST DatReadBufferSize = 10000;

VAR HulpAddrType       : EForm;
    UsenetUniqueTeller : LONGINT;
    LastDFilenameTry   : BYTE;
    DFile              : FBufferType;
    TossWhat           : BYTE; { 0=.X with email, 1=.X with rnews, 2=.BAG }
    BagOutFile         : TEXT;

{--------------------------------------------------------------------------}
{ UseGetAddress                                                            }
{                                                                          }
{ Martijnd@Solist.Htsa.Aha.Nl  (Big Dijk) -> Martijnd@Solist.Htsa.Aha.Nl   }
{ <Big Dijk> Martijnd@Solist.Htsa.Aha.Nl  -> Martijnd@Solist.Htsa.Aha.Nl   }
{ <foold@notknown.dijkline.wlink.nl>      -> fool@dijkline.wlink.nl        }
{ rmburns   <rmburns@vela.acs.oakland.edu>-> rmburns@vela.oakland.edu      }
{ Martijnd@Solist.Htsa.Aha.Nl             -> Martijnd@Solist.Htsa.Aha.Nl   }
{ <fool@something> (Big Fool Is Here)     -> fool@something   (RWI 950217) }
{                                                                          }
FUNCTION UseGetAddress (Source : STRING) : STRING;

VAR X,Y : BYTE;

BEGIN
     Source:=DeleteBackSpaces (DeleteFrontSpaces (Source));
     X:=Pos ('<',Source);
     Y:=Pos ('>',Source);

     IF (X = 1) THEN
     BEGIN
          { RWI 950217: nieuwe optie: <email> (Full Name) }
          IF (Pos ('(',Source) > Y) THEN
             { RWI 950122: changed Y+1 to Y, anders stond er een spatie }
             {             achter: "<ramon@wsd> " en ging de length     }
             {             vergelijking mis.                            }
             Source:=Copy (Source,1,Y); { full name eraf knippen }

          IF (Y = Length (Source)) THEN
             { "<ramon@wsd.wlink.nl>" }
             UseGetAddress:=DeleteFrontAndBackSpaces (Copy (Source,X+1,Y-X-1))
          ELSE
              { "<Ramon van der Winkel> ramon@wsd.wlink.nl" }
              UseGetAddress:=DeleteFrontAndBackSpaces (Copy (Source,Y+1,255));
     END ELSE
         IF (X > 1) THEN
            { "Ramon van der Winkel <ramon@wsd.wlink.nl>" }
            UseGetAddress:=DeleteBackspaces (Copy (Source,X+1,Y-X-1))
         ELSE
             { geen < teken }
             IF (Pos ('(',Source ) > 0) THEN
                { "ramon@wsd.wlink.nl (Ramon van der Winkel)" }
                UseGetAddress:=DeleteBackspaces (Copy (Source,1,Pos ('(',Source)-1))
             ELSE
                 { geen ( teken, moet dus "ramon@wsd.wlink.nl" zijn }
                 UseGetAddress:=DeleteBackspaces (Source);
END;


{--------------------------------------------------------------------------}
{ UsenetArpaNetDate                                                        }
{                                                                          }
{ Creer een nieuwe Arpanet compatible datum, doen we niet moeilijk over.   }
{                                                                          }
FUNCTION UsenetArpaNetDate : STRING;

VAR Year,Months,Days,Dow,
    Hour,Minute,Second   : WordLong;
    LocalTime            : STRING;

TYPE Pre0sString = STRING[2];

    {----------------------------------------------------------------------}
    { Pre0s                                                                }
    {                                                                      }
    FUNCTION Pre0s (Getal : BYTE) : Pre0sString;

    VAR Tmp : Pre0sString;

    BEGIN
         Str (Getal,Tmp);
         IF (Getal < 10) THEN
            Tmp:='0'+Tmp;
         Pre0s:=Tmp;
    END;

BEGIN
     GetTime (Hour,Minute,Second,Dow{dummy});
     GetDate (Year,Months,Days,Dow);

     { Dit programma heeft de toekomst, wel tot 2099                }
     { maar dan houdt de systeem klok er ook mee op dus, who cares? }
     IF (Year > 1999) THEN
        Year:=1900; {# wat is dit nou? dan doet ie het niet meer na 1999#}

     LocalTime:=Day[Dow]+', '+Pre0s (Days)+' '+Month[Months]+' '+
                Pre0s (Year-1900)+' '+
                Pre0s (Hour)+':'+Pre0s (Minute)+':'+Pre0s (Second)+
                ' '+Config.TimeZone;

     UsenetArpaNetDate:=LocalTime;
END;


{--------------------------------------------------------------------------}
{ UsenetSplit                                                              }
{                                                                          }
{ Deze routine splitst de opgegeven domain adres met user naam op in de    }
{ juiste stukken en geeft deze terug. Eventuele andere methoden kunnen     }
{ hier nu eenvoudig toegevoegd worden.                                     }
{ De conversies:                                                           }
{ newsfix@wlink.nl         -> wlink.nl, newsfix                            }
{ Strlnd!newsfix           -> Strlnd, newsfix                              }
{ contrast.wlink.nl!sander -> contrast.wlink.nl, sander                    }
{ newsfix                  -> newsfix                                      }
{                                                                          }
PROCEDURE UsenetSplit (Adres : STRING; VAR Domain : UsenetDomainNameString; VAR User : UsenetUserNameString);

VAR P : BYTE;

BEGIN
     IF (Pos ('!',Adres) > 0) THEN
     BEGIN
          { laatste stuk is de user naam, rest is het pad }
          P:=Length (Adres);
          WHILE (Adres[P] <> '!') DO
                Dec (P);

          User:=Copy (Adres,P+1,255);
          Domain:=Copy (Adres,1,P-1);
          Exit;
     END;

     P:=Pos ('@',Adres);
     IF (P > 0) THEN
     BEGIN
          User:=Copy (Adres,1,P-1);
          Domain:=Copy (Adres,P+1,255);
          Exit;
     END;

     Domain:='';
     User:=Adres;
END;


{--------------------------------------------------------------------------}
{ UsenetIsOurDomain                                                        }
{                                                                          }
{ Deze routine geeft TRUE terug als het opgegeven domain in onze domains   }
{ lijst staat.                                                             }
{                                                                          }
FUNCTION UsenetIsOurDomain (Domain : STRING) : BOOLEAN;

VAR Lp : AkaIndexType;

BEGIN
     UsenetIsOurDomain:=TRUE;

     IF (Domain = '') THEN
        LogMessage ('Unexpected situation in OurDomain check. ** PLEASE REPORT **');

     Domain:=UpCaseString (DeleteBackSpaces (Domain));

     { RWI 960604: WorldWide conditie verwijderd }
     IF (UpCaseString (Config.UUCPName) = Domain) THEN
        Exit; { TRUE }

     FOR Lp:=1 TO MaxDomains DO
         IF (UpCaseString (Config.Domains[Lp]) = Domain) THEN
            Exit; { TRUE }

     UsenetIsOurDomain:=FALSE;
END;


{--------------------------------------------------------------------------}
{ FinishUsenetMsgBuildup                                                   }
{                                                                          }
{ Deze routine maakt de universele msg af met de Usenet gegevens. Deze     }
{ worden hier uit het header blok gehaald en geinterpreteerd. Hierbij      }
{ wordt Unfolding toegepast op velden die langer zijn dan een regel.       }
{ Voor de regels die aangepast moeten worden zodat het lijkt dat ie door   }
{ ons verwerkt is, worden hier de aanpassingen gemaakt.                    }
{                                                                          }
{ SWAPCOMMENT: Dit is een zelfstandige routine en hoeft daarom niet bij te }
{              houden WAAR in de swapfile ie bezig was.                    }
{                                                                          }
{ RWI 950803: controle op domain-loze naam in Msg.XqtTo_U en vervanging    }
{             door wat er in het To: veld staat.                           }
{                                                                          }
PROCEDURE FinishUsenetMsgBuildup;

VAR Kludge,
    Regel              : STRING;
    InToBlock          : BOOLEAN;
    CurrRegelRecordPtr : EenRegelRecordPtr;

    {----------------------------------------------------------------------}
    { UnSpace                                                              }
    {                                                                      }
    { deze routine haalt de troep weg de Pegasus Mail geproduceert heeft.  }
    { Daar staat bijvoorbeeld: "From:       <naam>". Hier worden al die    }
    { spaties weggehaald.                                                  }
    { Nu wordt ook de #13 aan het einde van de regel verwijderd.           }
    {                                                                      }
    FUNCTION UnSpace (Regel : STRING) : STRING;

    VAR P : BYTE;

    BEGIN
         IF (Regel[Length (Regel)] = #13) THEN
            Delete (Regel,Length (Regel),1);

         { let op: onderstaande methode vervangt alleen de spaties achter }
         { de EERSTE dubbele punt! Niet een Pos (': ',Regel) gebruiken!!  }
         P:=Pos (':',Regel);
         IF (P > 0) THEN
            WHILE (Length (Regel) > P+2) AND (Regel[P+2] = ' ') DO
                  Delete (Regel,P+2,1);

         UnSpace:=Regel;
    END;

    {----------------------------------------------------------------------}
    { FindEmail                                                            }
    {                                                                      }
    { Deze routine verwerkt een regel die een deel van de To: header       }
    { bevat. Deze wordt van tabs ontdaan, spaties eraf gehakt en daarna op }
    { eventuele kommas in stukjes gehakt. Ieder stukje wordt bekeken op    }
    { het gedeeltelijke e-mail adres. Als dat erin zit, dan wordt het      }
    { overgenomen en TRUE terug gegeven. Anders komt FALSE terug.          }
    {                                                                      }
    FUNCTION FindEMail (Regel : STRING) : BOOLEAN;

    VAR Email,
        Part,
        Zoek : STRING;
        SysD : BOOLEAN;
        Lp   : 1..MaxDomains;

    BEGIN
         Zoek:=UpCaseString (Msg.XqtTo_U);

         IF (Regel[Length (Regel)] = #13) THEN
            Delete (Regel,Length (Regel),1);

         Regel:=DeleteFrontAndBackSpaces (CleanTabs (Regel,1));

         WHILE (Regel <> '') DO
         BEGIN
              IF (Pos (',',Regel) > 0) THEN
              BEGIN
                   Part:=DeleteBackSpaces (Copy (Regel,1,Pos (',',Regel)-1));
                   Delete (Regel,1,Pos (',',Regel));
                   Regel:=DeleteFrontSpaces (Regel);
              END ELSE
              BEGIN
                   Part:=Regel;
                   Regel:='';
              END;

              IF (Pos (Zoek,UpCaseString (Part)) > 0) THEN
              BEGIN
                   EMail:=UseGetAddress (Part);

                   { "postmaster" is ook wel eens de full-name, dus nog }
                   { maar een check.                                    }

                   { Doublequote check is voor MHS/X.400 systemen die een  }
                   { To: hebben die het e-mail address tussen quotes op de }
                   { eerste regel zetten als "user name" en op de volgende }
                   { regel het echt e-mail adres.                          }
                   IF (EMail[1] <> '"') AND (Pos (Zoek,UpCaseString (EMail)) > 0) THEN
                   BEGIN
                        { RWI 960914: check voor system domain address erin!       }
                        {             anders wordt mailing list adres zelf genomen }
                        SysD:=FALSE;
                        FOR Lp:=1 TO MaxDomains DO
                            IF (Config.Domains[Lp] <> '') AND
                               (Pos (UpCaseString (Config.Domains[Lp]),UpCaseString (EMail)) > 0) THEN
                            BEGIN
                                 SysD:=TRUE;
                                 Break;
                            END;

                        { check the system uucp name }
                        IF (NOT SysD) AND (Config.UUCPName <> '') AND
                           (Pos (UpCaseString (Config.UUCPName)+'!',UpCaseString (EMail)) > 0)
                        THEN
                            SysD:=TRUE;

                        { check for routed downlinks }
                        IF (NOT SysD) AND (GetUUCPRoute (EMail) <> NILRecordNr) THEN
                           SysD:=TRUE;

                        IF SysD THEN
                        BEGIN
                             { found it! }
                             IF (Config.LogXFix) THEN
                             BEGIN
                                  LogMessage ('Found complete to-address in headers:');
                                  LogExtraMessage (Msg.XqtTo_U+' -> '+EMail);
                             END;

                             { we vervangen ook de Usenet To: zodat we een }
                             { full name voor de Fido To: krijgen.         }
                             { DIRTY! This breaks CopyHeaders.. }
                             Msg.ToUser_U:='To: '+Part;
                             Msg.XqtTo_U:=EMail;
                             FindEmail:=TRUE; { hoeft niet verder te zoeken }
                             Exit;
                        END ELSE
                            IF Config.LogXFix THEN
                               LogMessage ('Close hit but not local: '+EMail);
                   END;
              END;
         END; { while }

         FindEMail:=FALSE; { einde nog niet gevonden }
    END;

    (*
    {----------------------------------------------------------------------}
    { StripKomma                                                           }
    {                                                                      }
    { Hier is het nieuwste geintje: de To: regel van een mail message kan  }
    { nu twee e-mail adressen bevatten met een komma ertussen. Very kut,   }
    { want WaterGate neemt de hele regel als het doel adres. Nu nemen we   }
    { dus het stuk waarin de Msg.XqtTo_U voorkomt.                         }
    { Op dit moment ondersteunen we alleen een constructie waarbij twee    }
    { e-mail adressen door een komma gescheiden worden.                    }
    { Een ding: de Msg.XqtTo_U _kwam_ voor in deze regel, dus die moet er  }
    { nu ook weer in voorkomen.                                            }
    {                                                                      }
    { RWI 960226: aangepast. We doorlopen nu iedere substring en kijken    }
    {             of het e-mail adres daarin voorkomt.                     }
    {                                                                      }
    FUNCTION StripKomma (T : STRING) : STRING;

    VAR Part : STRING;

    BEGIN
         IF (Pos (',',T) = 0) THEN
         BEGIN
              StripKomma:=UseGetAddress (T);
              Exit;
         END;

         WHILE (T <> '') DO
         BEGIN
              IF (Pos (',',T) > 0) THEN
              BEGIN
                   Part:=DeleteBackSpaces (Copy (T,1,Pos (',',T)-1));
                   Delete (T,1,Pos (',',T));
                   T:=DeleteFrontSpaces (T);
              END ELSE
              BEGIN
                   Part:=T;
                   T:='';
              END;

              { RWI 960226: Hier stond UseGetAddress (T)... Oeps... }
              Part:=UseGetAddress (Part);
              IF (Pos (UpCaseString (Msg.XqtTo_U),UpCaseString (Part)) > 0) THEN
              BEGIN
                   StripKomma:=Part;
                   Exit;
              END;
         END; { while }

         { shit. Hier mogen we dus eigenlijk helemaal niet komen }
         StripKomma:=Msg.XqtTo_U+'@'+Config.Domains[1];
    END; { StripKomma }
    *)

{FinishUsenetMsgBuildup}
BEGIN
     {$IFNDEF WtrTest}
     IF (Msg.HeaderTop_U <> NIL) THEN
     BEGIN
          CurrRegelRecordPtr:=Msg.HeaderTop_U^.FirstRegelRecordPtr;
          MsgsNewSeek (CurrRegelRecordPtr);
          InToBlock:=FALSE;

          WHILE (CurrRegelRecordPtr <> NIL) DO
          BEGIN
               CASE CurrRegelRecordPtr^.Waar OF
                   wMem :
                       BEGIN
                            Regel:=CurrRegelRecordPtr^.RegelPtr^;
                            CurrRegelRecordPtr:=CurrRegelRecordPtr^.NextRegelRecordPtr;
                            MsgsNewSeek (CurrRegelRecordPtr);
                       END;

                   wSwapped :
                       BEGIN
                            { lengte inlezen }
                            BlockRead (SwapFile,Regel[0],1);

                            { einde van het swap blok? }
                            IF (Regel[0] = #0) THEN
                            BEGIN
                                 { jep, einde. Pak de volgende regel }
                                 CurrRegelRecordPtr:=CurrRegelRecordPtr^.NextRegelRecordPtr;
                                 MsgsNewSeek (CurrRegelRecordPtr);
                                 Continue; { met de while }
                            END;

                            BlockRead (SwapFile,Regel[1],Byte (Regel[0]));
                       END;
               END; { case }

               {unfolding}
               Kludge:=UpCaseString (Copy (Regel,1,Pos (':',Regel)-1));

               IF (Kludge = 'TO') THEN
               BEGIN
                    Msg.ToUser_U:=UnSpace (Regel); { normaal behandeling }

                    { incomplete e-mail adres correctie }

                    IF (Msg.Ready_U = Mail) AND
                       (Config.RMailCorrect = ctScanHeaders) AND
                       (Msg.XqtTo_U <> '') AND
                       (Pos ('@',Msg.XqtTo_U) = 0) AND (Pos ('!',Msg.XqtTo_U) = 0) THEN
                    BEGIN
                         InToBlock:=TRUE; { controleer deze plus volgregels }

                         { To: weghalen en een spatie ervoor zetten }
                         Regel:=' '+Copy (Regel,4,255);
                         { checks are done below }
                    END;
               END;

               IF (Kludge = 'CC') OR (Kludge = 'BCC') THEN
               BEGIN
                    { incomplete e-mail adres correctie }

                    IF (Msg.Ready_U = Mail) AND
                       (Config.RMailCorrect = ctScanHeaders) AND
                       (Msg.XqtTo_U <> '') AND
                       (Pos ('@',Msg.XqtTo_U) = 0) AND (Pos ('!',Msg.XqtTo_U) = 0) THEN
                    BEGIN
                         InToBlock:=TRUE; { controleer deze plus volgregels }

                         { To: weghalen en een spatie ervoor zetten }
                         Regel:=' '+Copy (Regel,Length (Kludge)+2,255);
                         { checks are done below }
                    END;
               END;

               IF InToBlock THEN
               BEGIN
                    IF (Regel[1] IN [' ',#9]) THEN
                    BEGIN
                         IF FindEmail (Regel) THEN
                            InToBlock:=FALSE;  { stop checking }
                    END ELSE
                        InToBlock:=FALSE; { einde van To: blok }
               END;

               { RWI 960601 }
               IF (Kludge = '') THEN
                  Continue;

               IF (Kludge = 'ORGANIZATION') THEN Msg.Organization_U:=UnSpace (Regel);
               IF (Kludge = 'MESSAGE-ID')   THEN Msg.MessageID_U:=UnSpace (Regel);
               IF (Kludge = 'IN-REPLY-TO')  THEN Msg.InReplyTo_U:=UnSpace (Regel); { RWI 960404: toegevoegd }
               IF (Kludge = 'PATH')         THEN Msg.Path_U:=UnSpace (Regel);
               IF (Kludge = 'FROM')         THEN Msg.FromUser_U:=UnSpace (Regel);
               IF (Kludge = 'SENDER')       THEN Msg.Sender_U:=UnSpace (Regel);
               IF (Kludge = 'SUBJECT')      THEN Msg.Subj_U:=UnSpace (Regel);
               IF (Kludge = 'DATE')         THEN Msg.Date_U:=UnSpace (Regel);
               IF (Kludge = 'MIME-VERSION') THEN Msg.IsMime:=TRUE;

               IF (Kludge = 'NEWSGROUPS') THEN
               BEGIN
                    { RWI 950217: de #13 aan het einde van de newsgroup }
                    {             header wordt nu behouden, zodat we    }
                    {             kunnen detecteren of een newsgroup    }
                    {             naam is afgebroken.                   }
                    {             UnSpace verwijderd namelijk de #13.   }
                    IF (Regel[Length (Regel)] = #13) THEN
                       Msg.Newsgroups_U:=UnSpace (Regel)+#13 { behouden! }
                    ELSE
                        Msg.Newsgroups_U:=UnSpace (Regel);
               END;

               IF (Kludge = 'REPLY-TO')        THEN Msg.ReplyTo_U:=UnSpace (Regel);
               IF (Kludge = 'REFERENCES')      THEN Msg.References_U:=Unspace (Regel);
               IF (Kludge = 'APPROVED')        THEN Msg.Approved_U:=TRUE;
               IF (Kludge = 'APPARENTLY-TO')   THEN Msg.ApparentlyTo:=UnSpace (Regel);
               IF (Kludge = 'APPARENTLY-FROM') THEN Msg.ApparentlyFrom:=UnSpace (Regel);
               IF (Kludge = 'CONTROL')         THEN Msg.Control:=UnSpace (Regel);

          END; { while }
     END; { if }
     {$ELSE (WtrTest)}
     IF (Msg.Ready_U = Mail) AND { dus mail }
        (Msg.XqtTo_U <> '') AND { if it is empty, then don't even think about it! }
        (Pos ('@',Msg.XqtTo_U) = 0) AND (Pos ('!',Msg.XqtTo_U) = 0) THEN
     BEGIN
          FindEMail (Copy (Msg.ToUser_U,4,255));
     END;
     {$ENDIF (ndef WtrTest)}

     { hieronder komt ie alleen nog als er geen To: header gevonden is, }
     { of als de geadresserde niet in de To: (of vervolg) headers voorkwam }
     IF (Msg.Ready_U = Mail) AND { dus mail }
        (Msg.XqtTo_U <> '') AND { if it is empty, then don't even think about it! }
        (Pos ('@',Msg.XqtTo_U) = 0) AND (Pos ('!',Msg.XqtTo_U) = 0) THEN
     BEGIN
          { de naam van de "C rmail xxxx" regel uit de .X file is niet compleet }

          { dit gaat het worden: }
          Kludge:=Msg.XqtTo_U+'@'+Config.Domains[1];

          { controleer nog even op de Apparently-To: header }
          { note: dit is een single-liner.                  }
          IF (Config.RMailCorrect = ctScanHeaders) AND (Msg.ApparentlyTo <> '') THEN
          BEGIN
               { altijd fijn voor als er geen To: header was }
               IF (Msg.ToUser_U = '') THEN
                  Msg.ToUser_U:=Copy (Msg.ApparentlyTo,12,255); { keeps To: }

               Regel:=UseGetAddress (Copy (Msg.ApparentlyTo,15,255));
               IF (Pos (UpCaseString (Msg.XqtTo_U),UpCaseString (Regel)) > 0) THEN
               BEGIN
                    IF Config.LogXFix THEN
                    BEGIN
                         LogMessage ('Fixing incomplete to-address using Apparently-To:');
                         LogExtraMessage (Msg.XqtTo_U+' -> '+Regel);
                    END;

                    Msg.XqtTo_U:=Regel;
                    Kludge:=''; { niet meer nodig }
               END;
          END;

          IF (Kludge <> '') THEN
          BEGIN
               IF Config.LogXFix THEN
               BEGIN
                    IF (Config.RMailCorrect <> ctAddDomain) THEN
                       LogMessage ('Incomplete to-address and nothing found in headers');
                    LogExtraMessage ('Adding 1st system domain: '+Msg.XqtTo_U+' -> '+Kludge);
               END;

               Msg.XqtTo_U:=Kludge;
          END;
     END; { if no correct e-mail address }

     IF (Msg.ApparentlyFrom <> '') AND (Msg.FromUser_U = '') THEN
        Msg.FromUser_U:=Copy (Msg.ApparentlyFrom,12,255); { keep "From: " }
END;


{--------------------------------------------------------------------------}
{ GoProcess_WriteBagOut                                                    }
{                                                                          }
{ This routine is called for each line in the header and body of the mail  }
{ message. The line is written to the current BagOutFile, which should be  }
{ open.                                                                    }
{                                                                          }
PROCEDURE GoProcess_WriteBagOut (VAR OrigRegel : STRING); FAR;

VAR P     : BYTE;
    Regel : STRING;

BEGIN
     { Let op: _GEEN_ WriteLn gebruiken }
     { vertaal alle CR's in LF's }

     { the nice, easy and slow way... }
     P:=Pos (#13,Regel);

     IF (P = 0) THEN
     BEGIN
          Write (BagOutFile,OrigRegel);
          Exit;
     END;

     Regel:=OrigRegel;

     WHILE (P > 0) DO
     BEGIN
          Regel[P]:=#10;
          P:=Pos (#13,Regel);
     END;

     Write (BagOutFile,Regel);
END;


{--------------------------------------------------------------------------}
{ GoProcess                                                                }
{                                                                          }
{ This routine processed an mail or news messages that is now in memory.   }
{ It updates the screen statistics, checks for dupes in news and then      }
{ exports the message. For mail it exports it to all recipient in          }
{ Msg.XqtTo_U.                                                             }
{                                                                          }
PROCEDURE GoProcess;

VAR IORes   : BYTE;
    Name    : STRING[8];
    OutName : STRING[80];
    Hulp    : STRING[2];
    Old     : BOOLEAN;

LABEL SingleExport;

BEGIN
     { RWI 960915: controle op leeg bericht toegevoegd }
     IF (Msg.HeaderTop_U = NIL) THEN
        Msg.Ready_U:=NotReady;

     IF (Msg.Ready_U = NotReady) THEN
     BEGIN
          { it is normal to get here with a NotReady state for the first }
          { UUCP news message in a batch. It finds the "#! rnews" and    }
          { calls this routine.                                          }
          IF (Msg.BodyTop <> NIL) THEN
             LogMessage ('[GoProcess] Ready_U not set. Dropping message!');
          Exit;
     END;

     FinishUsenetMsgBuildup;

     CASE PacketUserData.System OF
          _U : UpdateInfoNr (INFO_UucpIn_Msgs,1);
          _S : UpdateInfonr (INFO_SmtpIn_Msgs,1);
          _B : UpdateInfoNr (INFO_BagIn_Msgs,1);
          _P : UpdateInfoNr (INFO_Pop3In_Msgs,1);
     END;

     IF (Msg.Ready_U = Mail) THEN
     BEGIN
          UpdateUserStats (UserDataRecNr,MailFrom,Msg.MsgSize);

          CASE PacketUserData.System OF
               _U : UpdateInfoNr (INFO_UucpIn_Mail,1);
               _S : UpdateInfonr (INFO_SmtpIn_Mail,1);
               _B : UpdateInfoNr (INFO_BagIn_Mail,1);
               _P : UpdateInfoNr (INFO_Pop3In_Mail,1);
          END;
     END;

     IF (Msg.Ready_U = News) THEN
     BEGIN
          { always count the statistics, whether dupe or not }
          UpdateUserStats (UserDataRecNr,NewsFrom,Msg.MsgSize);

          IF Config.DoDupeChk AND DupeCheckExist (UseCRCMessage) THEN
             Msg.Ready_U:=Dupe;

          IF (PacketUserData.System = _B) THEN
             UpdateInfoNr (INFO_BagIn_News,1)
          ELSE
              UpdateInfoNr (INFO_UucpIn_News,1);
     END;

     IF (TossWhat <> 2{bag}) OR (Msg.Ready_U <> Mail) THEN
     BEGIN
          MsgsExport;
          Exit;
     END;

     { e-mail from a BAG system. We are in deep shit if this message }
     { contains multiple recipients. We then have to write it to a   }
     { disk file for later processing.                               }

     { check for multiple receipient... }
     IF (Pos (' ',Msg.XqtTo_U) = 0) THEN
     BEGIN
          { single: process immediately }
          MsgsExport;
          Exit;
     END;

     { delayed, dus weer even herstellen! }
     UpdateInfoNr (INFO_BagIn_Mail,-1);
     UpdateInfoNr (INFO_BagIn_Msgs,-1);

     Name:=GetUsenetUniqueName ('A',{bitmask}FALSE{must!!});

     Old:=Config.ForceNoBitmask;
     Config.ForceNoBitmask:=FALSE; { must create with "0" in front! }
     OutName:=Config.SpoolBaseDir+PacketUserData.UUCPname+'\'+CalcOutBitmask (Name);
     Config.ForceNoBitmask:=Old;

     { create .D file }
     Assign (BagOutFile,OutName+'.D');
     {$I-} ReWrite (BagOutFile); {$I+} IORes:=IOResult;
     PeekFiles;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[BagMail] Error creating '+OutName+'.D');
          GOTO SingleExport;
     END;

     MsgsForEach (Msg.HeaderTop_U,GoProcess_WriteBagOut);

     { write empty line in between }
     Hulp:=#13;
     GoProcess_WriteBagOut (Hulp);

     MsgsForEach (Msg.BodyTop,GoProcess_WriteBagOut);

     Close (BagOutFile);
     PeekFiles;

     { create .X file }
     Assign (BagOutFile,OutName+'.X');
     {$I-} ReWrite (BagOutFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[BagMail] Error creating '+OutName+'.X');
          GOTO SingleExport;
     END;

     Write (BagOutFile,'U wtrgate '+LoCaseString (PacketUserData.UUCPname)+#10);
     Write (BagOutFile,'Z'+#10);
     Write (BagOutFile,'I D.'+LoCaseString (Copy (PacketUserData.UUCPname,1,6))+Name+#10);
     Write (BagOutFile,'C rmail '+Msg.XqtTo_U+#10);
     Close (BagOutFile);

     PeekFiles;

     { these files will be processed later }
     IF Config.LogSpoolTossed THEN
        LogExtraMessage ('  Wrote multiple recipients e-mail to .X/.D file for later processing');

     Exit;

SingleExport:
     LogExtraMessage ('Falling back to immediate export to single receipient');

     IF (Pos (' ',Msg.XqtTo_U) > 0) THEN
     BEGIN
          LogExtraMessage ('Loosing receipients: '+Copy (Msg.XqtTo_U,Pos (' ',Msg.XqtTo_U)+1,255));
          Msg.XqtTo_U:=Copy (Msg.XqtTo_U,1,Pos (' ',Msg.XqtTo_U)-1);
          LogExtraMessage ('Kept receipient: '+Msg.XqtTo_U);
     END;

     MsgsExport;
END;


{--------------------------------------------------------------------------}
{ AddTossedRegel                                                           }
{                                                                          }
{ Met deze routine wordt een regel die zojuist uit een .D file is binnen   }
{ gekomen naar in de universele msg gezet. Als de regel te lang is worden  }
{ er meerdere regels van gemaakt, met uitzondering van een aantal kludges. }
{ Als het een kludge regel bevat, dan komt deze in de header.              }
{ De Regel is als VAR meegegeven omdat dan alleen een pointer wordt mee-   }
{ gegeven en niet een kopie van de tekst, die daarna toch weer weggegooid  }
{ wordt.                                                                   }
{ Als deze routine het einde van een bericht tegenkomt wordt het bericht   }
{ verwerkt door MsgsExport aan te roepen. Het einde van een bericht is     }
{ gedefinieerd als "#! rnews" of het einde van de file, maar dat wordt in  }
{ een andere routine bepaald.                                              }
{ De scheiding tussen header en body wordt gemaakt door een lege regel.    }
{                                                                          }
PROCEDURE AddTossedRegel (VAR Regel : STRING; VAR PrevHad13 : BOOLEAN);

VAR Test : LONGINT;
    Nop  : ValNop;
    P    : BYTE;
    Temp : STRING;

BEGIN
     IF (TossWhat <> 0){not mail} AND (Copy (Regel,1,8) = '#! rnews') THEN
     BEGIN
          { er komt een nieuw bericht aan. Maak de vorige af en verwerk die }
          {Msg.Ready_U:=News; RWI 960222: set already! Prev might be mail!! }

          GoProcess;

          MsgsEmpty;
          AddWhereTo:=Header_U;
          Msg.Ready_U:=News; { expecting news }
          Exit;
     END;

     IF (TossWhat = 2{BAG}) AND (Copy (Regel,1,8) = '#! rmail') THEN
     BEGIN
          { zou alleen bij .BAG files voor moeten komen }
          { er komt een nieuw e-mail bericht aan }

          GoProcess;

          MsgsEmpty;
          AddWhereTo:=Header_U;
          Msg.Ready_U:=Mail; { expecting mail }

          { stop de rest van de rmail regel in de Xqt_To voor naar disk }
          { schrijven of verwerken in een latere fase.                  }
          Delete (Regel,1,9);
          IF (Regel[Length (Regel)] = #13) THEN
             Delete (Regel,Length (Regel),1);

          Regel:=DeleteFrontAndBackSpaces (Regel);

          { ivm KA9Q: als de regel nu een 10-cijferig nummer bevat, dan }
          { strippen we die.                                            }
          { RWI961214: alle nummers verwijderen, ook korte nummers,     }
          { maar nog wel nummers in e-mail adressen ondersteunen. Er    }
          { moet dus een spatie achter de nummers staan.                }
          P:=Pos (' ',Regel);
          IF (P > 0) THEN
          BEGIN
               { kijk of het een nummer is }
               Val (Copy (Regel,1,P-1),Test,Nop);
               IF (Nop = 0) THEN
                  Delete (Regel,1,P);

               Regel:=DeleteFrontSpaces (Regel);
          END;
          (*
          IF (Length (Regel) > 11) AND (Regel[11] = ' ') THEN
          BEGIN
               Val (Copy (Regel,1,10),Test,Nop);
               IF (Nop = 0) THEN
               BEGIN
                    { valid number; strip it }
                    Delete (Regel,1,11);
                    Regel:=DeleteFrontSpaces (Regel);
               END;
          END;
          *)

          Msg.XqtTo_U:=Regel;
          Exit;
     END;

     IF (AddWhereTo = Header_U) THEN
     BEGIN
          IF (PrevHad13) AND (Regel = #13) THEN
          BEGIN
               { overgang van header naar body }
               AddWhereTo:=Body;

               { deze legel regel NIET opslaan! MakeOut maakt em wel weer aan }
               Exit;
          END;

          PrevHad13:=(Regel[Length (Regel)] = #13);

          IF (UpCaseString (Copy (Regel,1,6)) = 'PATH: ') THEN
          BEGIN
               (*
               IF Config.WorldWide THEN
                  Regel:=Copy (Regel,1,6)+Config.UUCPName+'!'+Copy (Regel,7,255)
               ELSE
                   Regel:=Copy (Regel,1,6)+Config.Domains[1]+'!'+Copy (Regel,7,255);
               *)

               IF Config.WorldWide THEN
                  Temp:=Config.UUCPName
               ELSE
                   Temp:=Config.Domains[1];

                     {Path: }
               Temp:=Copy (Regel,1,6)+Temp+'!';
               Delete (Regel,1,6);

               IF (Length (Regel)+Length (Temp) > 255) THEN
               BEGIN
                    { split in tweeen }
                    Temp:=Temp+Copy (Regel,1,100);
                    MsgsAddLineToNoEOL (AddWhereTo,Temp);
                    Delete (Regel,1,100);
               END ELSE
                   Regel:=Temp+Regel;
          END;
     END;

     MsgsAddLineToNoEOL (AddWhereTo,Regel);
END;


{--------------------------------------------------------------------------}
{ FilenameUnix2Waffle                                                      }
{                                                                          }
{ Deze routine doet een filename conversie net als Waffle. Het algoritme   }
{ is als volgt: Zet de extensie die nu vooraan staat achteraan, haal de    }
{ systeem naam weg en neem het restant. Geef alle lowercase chrs een 1 en  }
{ alle uppercase en nummers een 0. Doet dit alleen met de laatste 5 tekens }
{ en maak hiervan een bitmap. De waarde van de bitmap is geeft een teken   }
{ dat ervoor moet worden gezet. Na 0..9 komt A..Z.                         }
{ Voorbeeld: D.ozoneBC0312 -> \SPOOL\OZONE\0BC0312.D                       }
{            X.ozoneXC0312 -> \SPOOL\OZONE\0XC0312.X                       }
{            D.ozoneB7n72  -> \SPOOL\OZONE\4S7N72.D                        }
{            X.ozoneX7pt0  -> \SPOOL\OZONE\6X7PT0.X                        }
{ Dit wordt ook wel Filename Munging genoemd.                              }
{                                                                          }
{ RvdW 16-05-93 Foutje verbeterd. Aan het einde wordt gekeken of door de   }
{               bepaalde bitmask een cijfer of een letter voor de naam     }
{               gezet moet worden. 0..8 werden slechts gebruikt, 9 niet.   }
{               Door de vergelijking van "< 9" in "< 10" te veranderen was }
{               de fout verholpen. Door de fout kwamen .D filenamen voor   }
{               die begonnen met een @...                                  }
{                                                                          }
FUNCTION FilenameUnix2Waffle (OrgUnixFilename : STRING; UUCPName : UUCPNameString) : FilenameString;

VAR NewName      : STRING;
    UnixFilename : STRING[79];
    Lp,
    BitMask      : BYTE;

BEGIN
     UnixFilename:=OrgUnixFilename;

     IF (Pos ('.',UnixFilename) > 0) THEN
     BEGIN
          NewName:='.'+Copy (UnixFilename,1,Pos ('.',UnixFilename)-1);
          Delete (UnixFilename,1,Pos ('.',UnixFilename));
     END ELSE
     BEGIN
          NewName:='';
          {LogMessage ('[FilenameUnix2Waffle] Period (.) not in unix style name: '+OrgUnixFilename);}
     END;

     {[MD] BugFix Usenet Domain namen worden door Waffle afgekort tot de }
     {     standaard maximum van 7 tekens.                               }
     IF (Length (UUCPName) > 7) THEN
        IF (UpCaseString (Copy (UnixFilename,1,7)) = Copy (UUCPName,1,7)) THEN
           Delete (UnixFilename,1,7)
        ELSE BEGIN
             { Ander formaat, nodes die een verkorte UUCP name in een file }
             { name gebruiken werden niet correct geparsed... hopelijk     }
             { werkt die wel we strippen nu het gedeelte dat overeenkomt   }
             { met de UUCP name van de filename af.                        }
             FOR Lp:=1 TO Length (UUCPName) DO
                 IF (UpCase (UnixFileName[1]) = UpCase (UUCPName[Lp])) THEN
                    Delete (UnixFileName,1,1)
                 ELSE
                     Break; { uit de for }
        END ELSE
            {LogMessage ('[FilenameUnix2Waffle] UUCPName ('+UUCPName+') not in unix style name: '+OrgUnixFilename)}
            IF (UpCaseString (Copy (UnixFilename,1,Length (UUCPName))) = UUCPName) THEN
               Delete (UnixFilename,1,Length (UUCPName))
            ELSE
                FOR Lp:=1 TO Length (UUCPName) DO
                    IF Upcase(UnixFileName[1]) = Upcase(UUCPName[Lp]) THEN
                       Delete (UnixFileName,1,1)
                    ELSE
                        Break; { uit de for }

     {LogMessage ('[FilenameUnix2Waffle] UUCPName ('+UUCPName+') not in unix style name: '+OrgUnixFilename); }

     BitMask:=0;

     { Bugfix: De teller liep van (X) tot (X-5), ofwel 6            }
     { verschillende waardes terwijl er maar 5 geteld mogen worden. }
     FOR Lp:=Length (UnixFileName) DOWNTO Length (UnixFilename)-4 DO
     BEGIN
          IF (UnixFilename[Lp] IN ['a'..'z']) THEN
             BitMask:=BitMask OR (1 SHL (Length (UnixFilename)-Lp));
     END;

     { Is dit de oplossing ???????                                   }
     { Er zijn maximaal 36 mogenlijke tekens, maar 255 verschillende }
     { waardes.                                                      }

     { BitMask := BitMask MOD 36; }

     IF (BitMask < 10) THEN UnixFilename:=Chr (48+BitMask)+UnixFilename
                       ELSE UnixFilename:=Chr (55+BitMask)+UnixFilename;

     FilenameUnix2Waffle:=UpCaseString (Copy (UnixFilename,1,8))+NewName;
END;


{--------------------------------------------------------------------------}
{ OpenDFile                                                                }
{                                                                          }
{ Deze routine gaat op zoek naar de juiste D filename en de methode om die }
{ te bepalen. Na de eerste keer onthoudt ie welke methode gebruikt is en   }
{ die wordt bij de volgende doorgang weer gebruikt, zodat het geheel       }
{ sneller doorlopen wordt. Als de file geopend kon worden, dan wordt TRUE  }
{ terug gegeven en in DFilename de uiteindelijke naam, anders FALSE.       }
{                                                                          }
FUNCTION OpenDFile (Path : PathString;           { spool dir path, incl. \ }
                    UUCPName,                    { uit user record }
                    Filename,                    { .X I-regel }
                    OtherUUCPName : STRING;      { UUCPname uit .X U-regel }
                    VAR DFilename : STRING) : BOOLEAN;

VAR Tried    : ARRAY[1..4] OF BOOLEAN;
    TryNames : STRING;
    Lp       : BYTE;
    CurrTry  : BYTE;
    BitMask  : BYTE;

BEGIN
     FOR Lp:=1 TO 4 DO
         Tried[Lp]:=FALSE;

     CurrTry:=LastDFilenameTry;
     TryNames:='';

     WHILE TRUE DO
     BEGIN
          { stel de DFilename samen op deze manier }

          CASE CurrTry OF

                   { met de UUCPname uit het user record }
               1 : DFilename:=FileNameUnix2Waffle (FileName,UUCPName);

                   { met de UUCPname uit de U-regel van de .X file }
               2 : DFilename:=FileNameUnix2Waffle (FileName,OtherUUCPName);

                   { met onze systeem UUCPname }
               3 : DFilename:=FileNameUnix2Waffle (FileName,Config.UUCPName);

                   { met een speciale conversie: munged laatste 7 tekens uit I regel }
               4 : BEGIN
                        { deze actie kan ook een deel van de UUCPname }
                        { meenemen. Bijvoorbeeld:                     }
                        { D.chard4bc2  -> ard4bc2  -> MARD4BC2        }

                        DFilename:=Copy (Filename,Length (Filename)-6,7);

                        { nu nog mungen }
                        BitMask:=0;

                        FOR Lp:=Length (DFileName) DOWNTO Length (DFilename)-4 DO
                        BEGIN
                             IF (DFilename[Lp] IN ['a'..'z']) THEN
                                BitMask:=BitMask OR (1 SHL (Length (DFilename)-Lp));
                        END;

                        IF (BitMask < 10) THEN DFilename:=Chr (48+BitMask)+DFilename
                                          ELSE DFilename:=Chr (55+BitMask)+DFilename;

                        IF (Pos ('.',Filename) > 0) THEN
                           DFilename:=DFilename+'.'+Copy (Filename,1,Pos ('.',Filename)-1)
                        ELSE
                            DFilename:=DFilename+'.';

                        DFilename:=UpCaseString (DFilename);
                   END;
          END; { case }

          { filename is nu samengesteld. Kijk of deze ook voorkomt in het }
          { rijtje met namen die we al geprobeerd hebben, want dan slaan  }
          { we deze gewoon over.                                          }

          IF (TryNames = '') OR (Pos (DFilename,TryNames) = 0) THEN
          BEGIN
               { nog niet geprobeerd met deze naam }
               IF FBufferOpen (DFile,Path+DFilename,DatReadBufferSize,0) THEN
               BEGIN
                    { gelukt! }

                    { onthoud welke methode succesvol was }
                    LastDFilenameTry:=CurrTry;

                    OpenDFile:=TRUE;
                    Exit;
               END;

               { mislukt. Vergeet nu niet te sluiten }
               FBufferClose (DFile);

               IF (TryNames <> '') THEN
                  TryNames:=TryNames+', ';

               TryNames:=TryNames+DFilename;

          END; { filename niet al geprobeerd }

          { niet gelukt op deze manier }
          Tried[CurrTry]:=TRUE;

          CurrTry:=0;
          FOR Lp:=1 TO 4 DO
              IF (NOT Tried[Lp]) THEN
              BEGIN
                   CurrTry:=Lp;
                   Break; { uit de for }
              END;

          IF (CurrTry = 0) THEN
          BEGIN
               { allemaal gehad. Keer terug met FALSE }
               LogMessage ('[OpenDFile] Failed to find .D file. Tried: '+TryNames);
               OpenDFile:=FALSE;
               Exit;
          END;
     END; { while }
END;


{--------------------------------------------------------------------------}
{ UsenetTossNewsDFile                                                      }
{                                                                          }
{ Deze routine leest een .D file met Usenet NEWS in. Deze file             }
{ heeft als EOF teken een #22. Mocht deze er niet staan, dan wordt het     }
{ fysieke einde van de file ook als EOF gezien.                            }
{ Deze routine geeft sinds RWI950322 een byte terug ipv een boolean. De    }
{ volgende return waarden zijn mogelijk:                                   }
{                                                                          }
{ 0 - .D file is verwerkt en verwijderd -> .X file mag nu ook weg.         }
{ 1 - .D file kon niet gevonden worden  -> .X file moet nog even blijven.  }
{ 2 - Problem bij het verwerken van de                                     }
{     .D en is hernoemd naar .DRR       -> .X ook hernoemen (naar .XRR)    }
{                                                                          }
FUNCTION UsenetTossNewsDFile (Path : PathString;
                              UUCPName,Filename,OtherUUCPName : STRING;
                              VAR DFilename : STRING) : BYTE;

VAR Regel      : STRING;
    CunBatch,
    DeGZip,
    DeCompress : BOOLEAN;
    AFile      : FILE;
    IORes      : BYTE;
    PrevHad13  : BOOLEAN;  { RWI 960601 }

BEGIN
     UsenetTossNewsDFile:=1; { assume .D file could not be found }

     IF (NOT OpenDFile (Path,UUCPName,Filename,OtherUUCPName,DFilename)) THEN
        Exit; { met exit code 1 }

     IF Config.LogSpoolTossed THEN
        LogMessage ('  Processing (news) '+DFilename);

     UpdateReadFile ('(news) '+Path+DFilename,FileSize (DFile.Bestand));

     UsenetTossNewsDFile:=2; { assume problems (case "rename em") }

     { kijken of er nog gepreprocessed moet worden }
     IF (NOT FBBlockPeek (DFile,Regel[1],13)) THEN
     BEGIN
          FBufferClose (DFile);
          LogMessage ('[UsenetTossNewsDFile] Peek error 1 with '+Path+DFilename+', skipping file');
          Exit;
     END;

     Regel[0]:=#11; { lengte van de string invullen }

     IF (Regel = '#! cunbatch') OR (Regel = '#! gunbatch') OR (Regel = '#! zunbatch') THEN
     BEGIN
          CunBatch:=TRUE;
          FBBlockRead (DFile,Regel[1],12); { lees de CunBatch+#13/#10 weg }

          { RWI 961029: Now allowing CR,LF }
          IF (Regel[12] = #13) THEN
             FBBlockRead (DFile,Regel[13],1);

          IF (NOT FBBlockPeek (DFile,Regel[1],2)) THEN
          BEGIN
               FBufferClose (DFile);
               LogMessage ('[UsenetTossNewsDFile] Peek error 2 with '+Path+DFilename+', skipping file');
               Exit;
          END;

          DeCompress:=((Regel[1] = #31) AND (Regel[2] = #157));
          DeGZip:=((Regel[1] = #31) AND (Regel[2] = #139));
     END ELSE
     BEGIN
          CunBatch:=FALSE;
          DeCompress:=((Regel[1] = #31) AND (Regel[2] = #157));
          DeGZip:=((Regel[1] = #31) AND (Regel[2] = #139));
     END;

     FBufferClose (DFile);

     { CunBatch verwijderen met check of het gelukt is }
     IF CunBatch THEN
        IF NOT DelCun (Path+DFilename) THEN
        BEGIN
             LogMessage ('Execution of DeCunBatch failed, skipping file: '+Path+DFilename);
             Exit;
        END;

     { decompress de file, met check of het gelukt is }
     IF DeCompress THEN
     BEGIN
          Assign (AFile,Path+DFilename);
          {$I-} Rename (AFile,Path+Copy (DFilename,1,Pos ('.',DFilename))+'DZ'); {$I+} IORes:=IOResult;
          IF (IORes <> 0) THEN
          BEGIN
               LogDiskIOError (IORes,'[UsenetTossNewsDFile] Renaming to .DZ failed, skipping file: '+Path+DFilename);
               Exit;
          END;

          GoExec (Config.ComprPrg_U[Compress,DeCompr],Path+DFilename+'Z','Decompressing news archive');

          IF (ExecRes <> 0) THEN
          BEGIN
               LogMessage ('[UsenetTossNewsDFile] Execution of de-compress failed, skipping file: '+Path+DFilename);
               Exit;
          END;

          IF (NOT FBufferOpen (DFile,Path+DFilename,DatReadBufferSize,0)) THEN
          BEGIN
               FBufferClose (DFile);
               LogMessage ('[UsenetTossNewsDFile] Cannot open file (after decompressing): '+Path+DFilename);
               Exit;
          END;

          { RWI 960322: lege files worden nu verwijderd en ignored }
          IF (FileSize (DFile.Bestand) = 0) THEN
          BEGIN
               LogMessage ('Skipping empty news batch');
               FBufferClose (DFile);
               {$I-} Erase (DFile.Bestand); {$I+} IORes:=IOResult;
               IF (IORes <> 0) THEN
                  LogDiskIOError (IORes,'Error deleting empty news batch');
               UsenetTossNewsDFile:=0; { verwerkt -> verwijder .X file }
               Exit;
          END;

          IF (NOT FBBlockPeek (DFile,Regel[1],2)) THEN
          BEGIN
               FBufferClose (DFile);
               LogMessage ('[UsenetTossNewsDFile] Peek error 2 with '+Path+DFilename+' (after decompressing), skipping file');
               Exit;
          END;

          FBufferClose (DFile);

          IF ((Regel[1] = #31) AND (Regel[2] = #157)) THEN
          BEGIN
               LogMessage ('[UsenetTossNewsDFile] DeCompress failed, skipping file: '+Path+DFilename);
               Exit;
          END;
     END;

     IF DeGZip THEN
     BEGIN
          Assign (AFile,Path+DFilename);
          {$I-} Rename (AFile,Path+Copy (DFilename,1,Pos ('.',DFilename))+'DZ'); {$I+} IORes:=IOResult;
          IF (IORes <> 0) THEN
          BEGIN
               LogDiskIOError (IORes,'[UsenetTossNewsDFile] Renaming to .DZ failed, skipping file: '+Path+DFilename);
               Exit;
          END;

          GoExec (Config.ComprPrg_U[GZip,DeCompr],Path+DFilename+'Z','UnZipping news archive');

          IF (ExecRes <> 0) THEN
          BEGIN
               LogMessage ('[UsenetTossNewsDFile] Execution of unZip failed, skipping file: '+Path+DFilename);
               Exit;
          END;

          IF (NOT FBufferOpen (DFile,Path+DFilename,DatReadBufferSize,0)) THEN
          BEGIN
               FBufferClose (DFile);
               LogMessage ('[UsenetTossNewsDFile] Cannot open file (after unGZip): '+Path+DFilename);
               Exit;
          END;

          { RWI 960322: lege files worden nu verwijderd en ignored }
          IF (FileSize (DFile.Bestand) = 0) THEN
          BEGIN
               LogMessage ('Skipping empty news batch');
               FBufferClose (DFile);
               {$I-} Erase (DFile.Bestand); {$I+} IORes:=IOResult;
               IF (IORes <> 0) THEN
                  LogDiskIOError (IORes,'Error deleting empty news batch');
               UsenetTossNewsDFile:=0; { verwerkt -> verwijder .X file }
               Exit;
          END;

          IF (NOT FBBlockPeek (DFile,Regel[1],2)) THEN
          BEGIN
               FBufferClose (DFile);
               LogMessage ('[UsenetTossNewsDFile] Peek error 2 with '+Path+DFilename+' (after ungzipping), skipping file');
               Exit;
          END;

          FBufferClose (DFile);

          IF ((Regel[1] = #31) AND (Regel[2] = #139)) THEN
          BEGIN
               LogMessage ('[UsenetTossNewsDFile] unGZip failed, skipping file: '+Path+DFilename);
               Exit;
          END;
     END;

     { verwerk de nu gedecunbatchte en gedecompressde file }
     IF (NOT FBufferOpen (DFile,Path+DFilename,DatReadBufferSize,0)) THEN
     BEGIN
          FBufferClose (DFile);
          LogMessage ('[UsenetTossNewsDFile] Cannot open just decompressed file '+Path+DFilename);
          Exit;
     END;

     UpdateInfoNr (INFO_UucpIn_Jobs,1);

     MsgsEmpty;
     AddWhereTo:=Header_U; { gebeurd anders bij "#! rnews" detectie }
     PrevHad13:=FALSE;

     WHILE FBReadLnLF (DFile,Regel) AND (Regel <> #0) DO
           AddTossedRegel (Regel,PrevHad13);

     Msg.Ready_U:=News;  { should be set already! .. not for test jobs }
     GoProcess;

     MsgsEmpty;            { geheugen van laatste msg weer vrij geven }

     UpdateInfoNr (INFO_UucpIn_Bytes,FileSize (DFile.Bestand));

     FBufferClose (DFile);

{$IFDEF DelFiles}
     { .D file laten wissen }
     {$I-} Erase (DFile.Bestand); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'[UsenetTossNewsDFile] Cannot delete .D file: '+Path+DFilename);
{$ENDIF}

     UsenetTossNewsDFile:=0; { verwerkt -> verwijder .X file }
END;


{--------------------------------------------------------------------------}
{ UsenetTossBAGFile                                                        }
{                                                                          }
{ Verwerkt een binnen gekomen NEWS0000.BAG file, en tossed 'm bijna net    }
{ zoals een gewone Usenet bundle.                                          }
{                                                                          }
{ RWI 950322: geeft nu ook 0=ok;del,1=keep,2=rename terug.                 }
{                                                                          }
PROCEDURE UsenetTossBAGFile (Path : PathString);

VAR DFile     : FBufferType;
    Regel     : STRING;
    IORes     : BYTE;
    PrevHad13 : BOOLEAN; { RWI 960601 }

BEGIN
     IF (NOT CheckMinDiskFree) THEN
        Exit;

     IF (NOT FBufferOpen (DFile,Path,DatReadBufferSize,0)) THEN
     BEGIN
          FBufferClose (DFile);
          LogDiskIOError (LastFBufferError,'Failed to open BAG file: '+Path);
          Exit;
     END;

     IF Config.LogSpoolTossed THEN
        LogMessage ('  Processing (bag) '+Path);

     MsgsEmpty;
     AddWhereTo:=Header_U; { just in case this is an invalid message }
     PrevHad13:=FALSE;

     FBReadLnLF (DFile,Regel);
     IF (UpCaseString (Copy (Regel,1,4)) <> '#! R') THEN
     BEGIN
          LogMessage ('BAG file misses "#! rmail" or "#! rnews" at begin');
          FBufferClose (DFile);

          Regel:=Path;
          WHILE (Regel <> '') AND (Regel[Length (Regel)] <> '.') DO
                Delete (Regel,Length (Regel),1);
          Regel:=Regel+'ERR';

          LogMessage ('Renaming '+Path+' to .ERR');

          {$I-} Rename (DFile.Bestand,Path); {$I+} IORes:=IOResult;
          IF (IORes <> 0) THEN
             LogDiskIOError (IORes,'Rename failed');

          Exit;
     END;

     { RWI961102: deze regel met #rmail of #rnews nog wel verwerken!! }
     AddTossedRegel (Regel,PrevHad13);

     WHILE FBReadLnLF (DFile,Regel) AND (Regel <> #0) DO
           AddTossedRegel (Regel,PrevHad13);

     {Msg.Ready_U:=News;  is set when #! rnews or #! rmail was found }
     GoProcess;

     { geheugen van laatste msg weer vrij geven }
     MsgsEmpty;

     UpdateInfoNr (INFO_BagIn_Bytes,FileSize (DFile.Bestand));

     FBufferClose (DFile);

{$IFDEF DelFiles}
     { .D file laten wissen }
     {$I-} Erase (DFile.Bestand); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'Cannot delete .BAG file: '+Path);
{$ENDIF}
END;


{--------------------------------------------------------------------------}
{ UsenetTossMailDFile                                                      }
{                                                                          }
{ Deze routine leest een .D file met mail in en haalt relevante gegevens   }
{ uit de header.                                                           }
{ RWI 950322: geeft nu ook 0=ok,del; 1=keep, 2=rename terug.               }
{                                                                          }
FUNCTION UsenetTossMailDFile (Path : PathString; UUCPName,Filename,OtherUUCPName : STRING;
                              More : BOOLEAN; VAR DFilename : STRING) : BYTE;

VAR Regel     : STRING;
    DeleteEm  : BOOLEAN;
    IORes     : BYTE;
    PrevHad13 : BOOLEAN;
    FromLine  : STRING;
    P         : BYTE;

BEGIN
     UsenetTossMailDFile:=1; { .X laten staan, .D was er (nog) niet }

     IF (NOT OpenDFile (Path,UUCPName,Filename,OtherUUCPName,DFilename)) THEN
        Exit; { met exit code 1 }

     IF Config.LogSpoolTossed THEN
        LogMessage ('  Processing (mail) '+DFilename);

     UsenetTossMailDFile:=2; { renamen in geval van problemen }

     UpdateReadFile ('(mail) '+Path+DFilename,FileSize (DFile.Bestand));

     UpdateInfoNr (INFO_UucpIn_Jobs,1);

     { initialiseer envelope }
     MsgsEmpty;
     AddWhereTo:=Header_U; { gebeurt bij news anders bij "#! rnews" detectie }

     { Toevoegingen :                                          }
     {  - Pluk de From regel van de netmail af                 }
     {    en voeg ons systeem via een bangpath toe (Waffle)    }
     {  - Voeg reclame , en via informatie aan het bericht toe }

     FBReadLnLF (DFile,Regel);

     {#1# hier kan de controle komen voor afzender systeem aanwezigheid }
     { hier kan ook de bounce prevention komen (dit is mail he?) }
     { RWI 9601213: Check op domain adres toegevoegd }
     IF (Pos ('@',Regel) = 0) AND (Copy (Regel,1,5) = 'From ') THEN
     BEGIN
          { From mail.zodiac.de!kruemel.zodiac.de!keks  }
          { Fri Sep 20 19:31:11 1996 remote from Mail.NetUSE.de }

          { RWI 960921: stopped adding as it corrupted it and it doesn't   }
          {             contain the names of all the intermediate systems  }
          {             as soon as it has gone from UUCP to SMTP transport }
          {             so we can't insert our system name...              }
          {             Except when it comes from below us!!               }
          {             Maar dat is slecht te detecteren...                }

          { het enige belang van deze regel zijn list servers die een  }
          { antwoord sturen naar iets wat in deze From_ header staat   }
          { en als daar "keks remote from kruemel.zodiac.de" staat dan }
          { zal het toch wel goed gaan?                                }

          {Insert (UseGetSystemFromName+'!',Regel,6);}
     END;

     PrevHad13:=FALSE;
     AddTossedRegel (Regel,PrevHad13);

     { Received: by dijkline.wlink.nl (0.01 beta/WaterGate) }
     {           via UUCP; Sat, 10 Jul 93 00:06:50 +0100    }
     {           for martijnd@htsa.aha.nl                   }

     { niks geen controle. Gewoon meteen achter de eerste header regel poten }
     {IF Copy( Regel , 1 , 10 ) = 'Received: ' THEN
     BEGIN}
     Regel:='Received: by '+UseGetSystemFromName+' ('+Copy (FidoTear,5,255)+')'+#13;
     AddTossedRegel (Regel,PrevHad13);

     IF (PacketUserData.System = _B) THEN
        Regel:='BAG'
     ELSE
         Regel:='UUCP';

     Regel:='          via '+Regel+'; '+UsenetArpaNetDate+#13;
     AddTossedRegel (Regel,PrevHad13);
     Regel:='          for '+Msg.XqtTo_U+#13;
     AddTossedRegel (Regel,PrevHad13);
     {END;}

     WHILE FBReadLnLF (DFile,Regel) AND (Regel <> #0) DO
           AddTossedRegel (Regel,PrevHad13);

     Msg.Ready_U:=Mail; { RWI 960224: is nog niet ingevuld.. }

     { RWI 960315: restored; instead of GoProcess }
     FinishUsenetMsgBuildup;       { verwerk laatste nog aanwezige bericht }

     UpdateUserStats (UserDataRecNr,MailFrom,Msg.MsgSize);

     Msg.ToSystem_U:=PacketUserData.UUCPName;                { ivm ForceFileFull }
     IF (Msg.FromUser_U <> '') THEN { altijd bij mail; als het goed is tenminste }
     BEGIN
          MsgsExport;

          DeleteEm:=More; { alleen als ie niet meer nodig is }
          IF (NOT DeleteEm) THEN
             UsenetTossMailDFile:=4; { niet verwijderd ivm multiple receipents }
     END ELSE
     BEGIN
          LogMessage ('[UsenetTossMailDFile] From User not found in mail .D file '+Path+DFilename);
          DeleteEm:=FALSE;          { laat de .D staan, dan wordt het .BAD }
     END;

     MsgsEmpty;                 { geheugen van laatste msg weer vrij geven }

     UpdateInfoNr (INFO_UucpIn_Bytes,FileSize (DFile.Bestand));

     FBufferClose (DFile);

     { .D file wissen als er geen fouten waren }
     IF DeleteEm THEN
     BEGIN
          {$I-} Erase (DFile.Bestand); {$I+} IORes:=IOResult;
          IF (IORes <> 0) THEN
             LogDiskIOError (IORes,'[UsenetTossMailDFile] Could not delete '+DFilename);

          UsenetTossMailDFile:=0; { delete X (was 2: rename both) }
     END;
     { ELSE keep return status 4 (misschien ook wel 2) }
END;


{--------------------------------------------------------------------------}
{ UsenetTossXFile                                                          }
{                                                                          }
{ Deze routine verwerkt de gevonden .X file.                               }
{                                                                          }
PROCEDURE UsenetTossXFile (XDPath : STRING; XFileName : FilenameString; UUCPName : UUCPNameString);

VAR XFile  : FBufferType;
    Regel  : STRING;
    CmdCh  : CHAR;

    Data_F        : STRING; { strings later op lengte maken }
    Data_I        : STRING;
    Data_C        : STRING;
    Data_R        : STRING;
    Data_U_Login  : STRING;
    Data_U_System : STRING[MaxLenUUCPName];
    DFilename     : STRING[79];

    AFile  : FILE;
    Search : SearchRec;
    IORes  : BYTE;
    Error  : BYTE;

    {----------------------------------------------------------------------}
    { RenameXFile .D -> .BAD en .X->.BAX                                   }
    {                                                                      }
    PROCEDURE RenameXFileAndDFile;

    VAR NewName : STRING[15];
        AddedZ  : BOOLEAN;

    BEGIN
         AddedZ:=TRUE;

         { zowel .X file renamen naar *.BAX }
         LogExtraMessage ('  Renaming '+XFilename+' to .BAX');
         NewName:=Copy (XFilename,1,Pos ('.',XFilename))+'BAX';

         Assign (AFile,XDPath+XFileName);
         {$I-} Rename (AFile,XDPath+NewName); {$I+} IORes:=IOResult;
         IF (IORes <> 0) THEN
            LogDiskIOError (IORes,'[DeleteXFile] Error renaming file '+
                                  XDPath+XFileName+' to '+XDPath+NewName);

         { RAWI 971010 }
         IF (DFilename = '') THEN
            Exit;

         LogExtraMessage ('  Renaming '+DFilename+' to .BAD');
         NewName:=Copy (DFilename,1,Pos ('.',DFilename))+'BAD';

         Assign (AFile,XDPath+DFilename);
         {$I-} Rename (AFile,XDPath+NewName); {$I+} IORes:=IOResult;
         IF (IORes = 2) THEN
         BEGIN
              { probeer het nog eens, maar nu met .DZ }
              DFilename:=DFilename+'Z';
              AddedZ:=TRUE;
              Assign (AFile,XDPath+DFilename);
              {$I-} Rename (AFile,XDPath+NewName); {$I+} IORes:=IOResult;
         END;

         IF (IORes <> 0) THEN
            LogDiskIOError (IORes,'[DeleteDFile] Error renaming file '+
                                  XDPath+DFilename+' to '+XDPath+NewName);

         { restore DFilename file is modified }
         IF AddedZ THEN
            Delete (DFilename,Length (DFilename),1);
    END;

    {----------------------------------------------------------------------}
    { DeleteXFile                                                          }
    {                                                                      }
    { Beide files zijn gebruikt voor verwerking en kunnen nu fietsen.      }
    {                                                                      }
    PROCEDURE DeleteXFile;

    VAR AFile : FILE;
        IORes : BYTE;

    BEGIN
         {$IFDEF DelFiles}
         Assign (AFile,XDPath+XFilename);
         {$I-} Erase (AFile); {$I+} IORes:=IOResult;
         IF (IORes <> 0) THEN
            LogDiskIOError (IORes,'[DeleteXFile] Error deleting file '+XDPath+XFilename);
         {$ENDIF}
    END;

{ UsenetTossXFile }
BEGIN
     IF (NOT CheckMinDiskFree) THEN
        Exit;

     {XDPath:=Config.SpoolBaseDir+UUCPName+'\';}
     IF (NOT FBufferOpen (XFile,XDPath+XFilename,256,0)) THEN
     BEGIN
          FBufferClose (XFile);
          LogMessage ('[UsenetTossXFile] Cannot open just found .X file: '+
                      XDPath+XFileName);
          Exit;
     END;

     IF Config.LogSpoolTossed THEN
        LogMessage ('  Processing '+XFilename);

     Data_C:='';
     Data_I:='';        { invoer file, voor inlezen .D file }
     Data_F:='';
     Data_R:='';
     Data_U_Login:='';
     Data_U_System:=''; { UUCPName van het sturende systeem }
     DFilename:=''; { RAWI 971010 }

     WHILE FBReadLnLF (XFile,Regel) DO
     BEGIN
          IF (Regel[Length (Regel)] = #13) THEN
             Delete (Regel,Length (Regel),1);

          Regel:=DeleteBackSpaces (Regel);

          IF (Regel = '') THEN
             Continue;

          CmdCh:=Regel[1];

          { RWI 950214: nu worden alle spaties verwijderd. Was een }
          {             probleem... Overal hieronder maar even     }
          {             DeleteFrontSpaces ingebakken en hierboven  }
          {             een DeleteBackSpaces. Hope this helps!
          Delete (Regel,1,2);
          }
          Delete (Regel,1,1);
          Regel:=DeleteFrontSpaces (Regel);

          CASE CmdCh OF
               'C' :
                   BEGIN { Command line }
                        IF (Pos (' ',Regel) = 0) THEN
                        BEGIN
                             Data_C:=UpCaseString (Regel);
                             Regel:='';
                        END ELSE
                        BEGIN
                             Data_C:=UpCaseString (Copy (Regel,1,Pos (' ',Regel)-1));
                             Delete (Regel,1,Pos (' ',Regel));
                             Regel:=DeleteFrontSpaces (Regel);

                             IF (Data_C = 'RMAIL') THEN
                             BEGIN
                                  (* RWI 950803: uitgezet. Wordt nu in
                                                 TossNewsDFile gedaan zodat
                                                 het ook werkt bij multiple
                                                 receipants

                                  { RWI 950627 }

                                  { controleren of er wel een domain naam }
                                  { of bang path in deze regel staat. Zo  }
                                  { niet, dan nemen we het eerste systeem }
                                  { domain adres.                         }
                                  IF (Pos ('@',Regel) = 0) AND (Pos ('!',Regel) = 0) THEN
                                     Regel:=Regel+'@'+Config.Domains[1];
                                  *)

                                  { RWI961230 ivm GIGOT jobs.. :( }
                                  { Remove "C rmail 0 ramon@wsd.wline.se" }
                                  {    and "C rmail U ramon@wsd.wline.se" }
                                  IF (Length (Regel) > 2) AND (Regel[2] = ' ') AND (Regel[3] <> ' ') THEN
                                     Delete (Regel,1,2);

                                  Msg.XqtTo_U:=Regel;

                                  Regel:='';
                             END; { if "C rmail" }
                        END; { if spatie in "C" regel }
                   END; { C }

               'I' :
                   Data_I:=Regel; { Standard Input }

               'F' :
                   BEGIN { Required file filename-to-use }
                        { kan twee argumenten hebben, neem altijd de 1e }
                        IF (Pos (' ',Regel) = 0) THEN
                           Regel:=Regel+' ';
                        Data_F:=Copy (Regel,1,Pos (' ',Regel));
                   END;

               'R' :
                   Data_R:=Regel; { requestor address } { voor terugsturen mail? }

               'U' :
                   BEGIN { user system }
                        IF (Pos (' ',Regel) = 0) THEN
                           Regel:=Regel+' ';
                        Data_U_Login:=Copy (Regel,1,Pos (' ',Regel)-1);
                        Delete (Regel,1,Pos (' ',Regel));

                        IF (Pos (' ',Regel) = 0) THEN
                           Regel:=Regel+' ';
                        Data_U_System:=Copy (Regel,1,Pos (' ',Regel)-1);
                        Delete (Regel,1,Pos (' ',Regel));
                   END;

               'N' :; { no acknowledge on failure }

               'Z','O','n','B',
               'e','E','M'     :; {('[UsenetTossXFile] Cannot process .X-file code ('+CmdCh+') yet, skipping');}

               '#' :; { remark, skip this line }

             {  ELSE
                   LogMessage ('[UsenetTossXFile] Unknown cmdcode ('+CmdCh+') in '+
                               Config.SpoolBaseDir+UUCPName+'\'+XFileName);         }
          END; { case }
     END; { while }

     FBufferClose (XFile);

     {DFilename:=FilenameUnix2Waffle (Data_I,UUCPName);}
     {WriteXY (46,5,AddUpWithSpaces (12,DFilename));}

     Data_U_System:=UpCaseString (DeleteBackSpaces (Data_U_System));

     IF (Data_C = 'RNEWS') THEN
     BEGIN
          { RWI 951231: geen new tossen als -NONEWSTOSS opgegeven is }
          IF (NOT ForceNoNewsToss) THEN
          BEGIN
               TossWhat:=1; { .X with with rnews }

               { RWI 950212: als pad wordt nu altijd het pad van de .X file }
               {             genomen. Het maakt dan dus niet meer uit       }
               {             welke naam in het U veld stond. Die wordt nu   }
               {             wel gebruikt voor het decoderen van de naam.   }
               CASE UsenetTossNewsDFile (XDPath,
                                         UUCPName,
                                         Data_I,
                                         Data_U_System,
                                         DFilename)
               OF
                    0 : DeleteXFile; { delete de .X file als de .D nu ook weg is }
                    1 : {niks mee doen, gewoon laten staan};
                    2 : RenameXFileAndDFile;

               END; { case }

          END ELSE
              IF Config.LogSpoolTossed THEN
                 LogMessage ('  Skipping news');

     END ELSE
         IF (Data_C = 'RMAIL') THEN
         BEGIN
              Regel{misbruik}:=DeleteBackSpaces (Msg.XqtTo_U);

              IF (Pos ('@@',Regel) > 0) THEN
              BEGIN
                   LogMessage ('Invalid e-mail address in on rmail line: '+Regel);
                   RenameXFileAndDFile;
                   Exit;
              END;

              Error:=0;
              REPEAT
                    IF (Pos (' ',Regel) > 0) THEN
                    BEGIN
                         Msg.XqtTo_U:=Copy (Regel,1,Pos (' ',Regel)-1);
                         Delete (Regel,1,Pos (' ',Regel));
                         Regel:=DeleteFrontSpaces (Regel);
                    END ELSE
                    BEGIN
                         Msg.XqtTo_U:=Regel;
                         Regel:='';
                    END;

                    TossWhat:=0; { .X file with email }

                    { alleen als ze allemaal goed verwerkt zijn komt er }
                    { uit Error de waarde 0 en wordt de .D verwijderd.  }
                    { Dit kan we wat dubbele mail opleveren, dus loggen }
                    { we eventuele problemen.                           }
                    Error:=Error OR UsenetTossMailDFile (XDPath,
                                                         UUCPName,
                                                         Data_I,
                                                         Data_U_System,
                                                         (Regel = ''),
                                                         DFilename);
              UNTIL (Regel = '');

              { RWI 960315 }
              { filter de error eruit die aangeeft dat de .D file niet }
              { verwijderd was ivm multiple recipients van hetzelfde   }
              { bericht. Dit zou verdwaalde .X files op moeten lossen. }
              Error:=Error AND (255-4);

              IF (Error = 0) THEN
                 DeleteXFile;

              {
               LogMessage ('[UsenetTossXFile] Error sending mail to all .X file receipants.');
               LogExtraMessage ('Renaming '+XFilename+' to prevent duplicates');
               RenameXFileAndDFile;
              }
         END ELSE
         BEGIN
              LogMessage ('[UsenetTossXFile] Unknown C command in .X file '+XDPath+XFilename);
              RenameXFileAndDFile;
         END;
END;


{--------------------------------------------------------------------------}
{ SearchXFiles                                                             }
{                                                                          }
PROCEDURE SearchXFiles (Path : STRING);

VAR Search : SearchRec;
    IORes  : BYTE;

BEGIN
     { alle .X files aflopen }
     FindFirst (Path+'*.X',Archive,Search);
     IF (DosError <> 0) AND (DosError <> 18{no more files}) THEN
        LogDiskIOError (DosError,'Cannot find spool path '+Path)
        { note: would say "spool" for BAG 'cause path's already checked }
     ELSE BEGIN
          IF (DosError = 0) THEN
             LogMessage ('Tossing for '+PacketUserData.UUCPName);

          WHILE (DosError = 0) AND (NOT KeyPressed) DO
          BEGIN
               PeekMem;
               UpdateReadFile (Path+Search.Name,Search.Size);

               UsenetTossXFile (Path,Search.Name,PacketUserData.UUCPName);

               FindNext (Search);
          END; { while .x files }
     END; { not deleted and _U or _B }

     FindClose (Search);
END;


{--------------------------------------------------------------------------}
{ UucpToss                                                                 }
{                                                                          }
{ Deze routine zoekt in de spool directories van alle nodes naar .X files  }
{ waarin de namen van de .D files waarin de mail zit. Deze wordt doorgege- }
{ ven aan TossDATFile.                                                     }
{                                                                          }
PROCEDURE UucpToss;

VAR Lp : UserBaseRecordNrType;

BEGIN
     LogMessage ('UUCP toss started on '+DateStamp);

     FOR Lp:=1 TO UserBaseRecCount DO
         IF (NOT KeyPressed) THEN
         BEGIN
              ReadUserBaseRecord (Lp,PacketUserData);

              IF (NOT PacketUserData.Deleted) AND (PacketUserData.System = _U) THEN
              BEGIN
                   UserDataRecNr:=Lp; { voor MsgsExport }
                   AreaCreatorUserBaseRecNr:=Lp;
                   PacketUserData.UUCPName:=UpCaseString (PacketUserData.UUCPName);

                   UpdateAction ('Search spool directory for "'+PacketUserData.UUCPName+'"');

                   SearchXFiles (Config.SpoolBaseDir+PacketUserData.UUCPName+'\');
              END; { if }
         END; { if, for }

     LogMessage ('UUCP toss finished');
END;


{--------------------------------------------------------------------------}
{ BagToss                                                                  }
{                                                                          }
PROCEDURE BagToss;

VAR Lp     : UserBaseRecordNrType;
    Search : SearchRec;
    IORes  : BYTE;
    Path   : STRING;
    Dir    : DirStr;
    Name   : NameStr;
    Ext    : ExtStr;

    {OldMail2News : STRING[MaxLenDomain];}

BEGIN
     LogMessage ('BAG toss started on '+DateStamp);

     FOR Lp:=1 TO UserBaseRecCount DO
         IF (NOT GlobalAbort) THEN
         BEGIN
              ReadUserBaseRecord (Lp,PacketUserData);

              IF (NOT PacketUserData.Deleted) AND (PacketUserData.System = _B) THEN
              BEGIN
                   {
                   OldMail2News:=Mail2NewsAddress;
                   Mail2NewsAddress:='';

                   IF (OldMail2News <> '') AND Config.LogDebug THEN
                      LogMessage ('Temporarily disabling mail2news');
                   }

                   UserDataRecNr:=Lp; { voor MsgsExport }
                   AreaCreatorUserBaseRecNr:=Lp;
                   PacketUserData.UUCPName:=UpCaseString (PacketUserData.UUCPName);

                   UpdateAction ('BAG search for '+PacketUserData.UUCPName);

                   Path:=FExpand (PacketUserData.BagPath);
                   FSplit (Path,Dir,Name,Ext);

                   { Handling exeption: "C:\NEWS" -> "C:\NEWS\*.BAG" }
                   IF (Ext = '') AND (Name <> '') AND (Pos ('*',Name) = 0) AND (Pos ('?',Name) = 0) THEN
                      Path:=Path+'\*.BAG'
                   ELSE BEGIN
                        IF (Name = '') AND (Ext = '') THEN
                           Path:=Path+'*.BAG';
                   END;

                   { split again to get the directory }
                   FSplit (Path,Dir,Name,Ext);

                   { alle .BAG files aflopen }
                   FindFirst (Path,Archive,Search);

                   IF (DosError <> 0) AND (DosError <> 18{no more files}) THEN
                   BEGIN
                        LogDiskIOError (DosError,'Cannot find BAG path '+Dir);
                        FindClose (Search);
                        Continue; { for }
                   END;

                   IF (DosError = 0) THEN
                      LogMessage ('Searching BAG files for '+PacketUserData.UUCPName);

                   WHILE (DosError = 0) AND (NOT GlobalAbort) DO
                   BEGIN
                        IF KeyPressed THEN
                        BEGIN
                             GlobalAbort:=TRUE;
                             ReadKey; { weglezen }
                        END ELSE
                        BEGIN
                             UpdateInfoNr (INFO_BagIn_Jobs,1);
                             UpdateReadFile (Dir+Search.Name,Search.Size);

                             TossWhat:=2; { BAG files }
                             UsenetTossBAGFile (Dir+Search.Name);

                             FindNext (Search);
                        END; { if, while }
                   END;

                   FindClose (Search);

                   {
                   IF (OldMail2News <> '') THEN
                   BEGIN
                        Mail2NewsAddress:=OldMail2News;
                        IF Config.LogDebug THEN
                           LogMessage ('Re-enabled mail2news');
                   END;
                   }

                   { RWI 960222: New: Bag suppliers can now have .X and .D files }
                   IF (NOT GlobalAbort) THEN
                      SearchXFiles (Config.SpoolBaseDir+PacketUserData.UUCPname+'\');

              END; { if not deleted *and* _B }

              IF KeyPressed THEN
              BEGIN
                   GlobalAbort:=TRUE;
                   Ramon.ReadKey; { weglezen }
              END;

         END; { if, for }

     LogMessage ('BAG toss finished');
END;


{--------------------------------------------------------------------------}
{ UsenetUniqueNameInit                                                     }
{                                                                          }
{ Deze routine initialiseert een teller aan de hand van de Maand, Dag en   }
{ aantal tikken vandaag.                                                   }
{                                                                          }
{ MD> Leuke routine maar als de waarde <0 dan gaan er allerlei dingen      }
{     verkeerd...                                                          }
{                                                                          }
PROCEDURE UsenetUniqueNameInit;

VAR Maand,Dag,Nop : WordLong;

BEGIN
     GetDate (Nop,Maand,Dag,Nop);

     UsenetUniqueTeller:=GetTimer AND ((1 SHL 22) -1) SHL 2; { 18.2 keer/sec ++ }
     UsenetUniqueTeller:=UsenetUniqueTeller OR (Longint (Dag) SHL 23);
     UsenetUniqueTeller:=UsenetUniqueTeller OR (Longint (Maand) SHL 28);

     IF (UsenetUniqueTeller < 0) THEN
        UsenetUniqueTeller:=-UsenetUniqueTeller;
END;


{--------------------------------------------------------------------------}
{ GetUsenetUniqueName                                                      }
{                                                                          }
{ Deze routine bepaald de naam van het volgende .DAT file. De bij het      }
{ opgestarten van het programma bepaalde teller wordt hier met een (1)     }
{ verhoogd en omgezet in een string. Er wordt een 36 tekens codering per   }
{ digit gebruikt, waardoor er maar 6 tekens nodig zijn om te de code op te }
{ bouwen.                                                                  }
{                                                                          }
{ Het leading character wordt nu voorzien van een 'Z' voor news, en een    }
{ 'A' voor mail berichten, zodat een mail bericht hogere prioriteit krijgt }
{ dan een news bundel.                                                     }
{                                                                          }
{ RWI 960224: Mail en News grade geintroduceerd. De A en Z zijn nu in te   }
{             stellen.                                                     }
{                                                                          }
FUNCTION GetUsenetUniqueName (Grade : CHAR; ForceNoBitmask : BOOLEAN) : STRING;

VAR Res    : STRING[8];
    Getal  : LONGINT;
    MaxLen : BYTE;

BEGIN
     Inc (UsenetUniqueTeller);
     Getal:=UsenetUniqueTeller;
     Res:='';

     IF ForceNoBitmask THEN
        MaxLen:=5
     ELSE
         MaxLen:=4;

     { getal met base 36 omzetting naar een string }
     WHILE (Getal <> 0) AND (Length (Res) < MaxLen) DO
     BEGIN
          IF ((Getal MOD 36) < 10) THEN
             Res:=Chr (Ord ('0')+(Getal MOD 36))+Res
          ELSE
              Res:=Chr (Ord ('A')-10+(Getal MOD 36))+Res;

          Getal:=Getal DIV 36;
     END;

     GetUsenetUniqueName:=Grade+Res;
END;


{--------------------------------------------------------------------------}
{ UseScanForPrivate                                                        }
{                                                                          }
{ Deze routine controleert of een Usenet MAIL of NEWS bericht iets bevat   }
{ dat ingesteld is in de Scan Private Mail opties. Zoja, dan wordt TRUE    }
{ terug gegeven en kan het bericht na vertaling geimporteerd worden.       }
{                                                                          }
{ RWI 950624: dit was UseWritePrivate (ofzo), maar die verkrachtte het     }
{             bericht nogal omdat het vertaald werd naar een echomail en   }
{             daarna geimporteerd. Dit is wel even netter.                 }
{                                                                          }
FUNCTION UseScanForPrivate : BOOLEAN;

VAR PrivMailTeller : 1..MaxPrivMail;

BEGIN
     { Wat doen we hier ? }
     IF NOT (Msg.Ready_U IN [Mail,News]) THEN
     BEGIN
          UseScanForPrivate:=FALSE;   { RWI 960127: added }
          Exit;
     END;

     UseScanForPrivate:=TRUE;

     WITH Config DO
          FOR PrivMailTeller:=1 TO MaxPrivMail DO
              IF (PrivMailOption[PrivMailTeller] <> '') THEN
                 CASE PrivMailSelect[PrivMailTeller] OF
                      PvtFrom :
                          IF (Pos (PrivMailOption[PrivMailTeller],UpCaseString (Msg.FromUser_U)) <> 0) THEN
                             Exit; { TRUE }

                      PvtTo :
                          IF (Pos (PrivMailOption[PrivMailTeller],UpCaseString (Msg.ToUser_U)) <> 0) THEN
                             Exit; { TRUE }

                      PvtSubj :
                          IF (Pos (PrivMailOption[PrivMailTeller],UpCaseString (Msg.Subj_F)) <> 0) THEN
                             Exit; { TRUE }
                 END; { case, if, for, with }

     UseScanForPrivate:=FALSE;
END;


{-------------------------------------------------------------------------}
{ UsenetGetUUCPName                                                       }
{                                                                         }
{ Geeft de UUCP name van een domain adres terug.                          }
{                                                                         }
{ Waterland.Wlink.Nl -> Waterland                                         }
{                                                                         }
FUNCTION UsenetGetUUCPName (Domain : STRING) : STRING;

VAR Loc : BYTE;

BEGIN
     { Splits op de eerste punt }
     Loc:=Pos ('.',Domain);

     IF (Loc <> 0) THEN
        UsenetGetUUCPName:=Copy (Domain,1,Loc-1)
     ELSE
         UsenetGetUUCPName:=Domain;
END;


{--------------------------------------------------------------------------}
{ UsenetReplyAdres                                                         }
{                                                                          }
{ Deze routine maakt een keuze uit de beschikbare terugzend adressen,      }
{ en geeft degene met de hoogste prioriteit terug.                         }
{                                                                          }
FUNCTION UsenetReplyAdres : STRING;

VAR Tmp : STRING;

BEGIN
     { RWI 960320: added prevention against empty header lines, like }
     {             "Reply-To: ".                                     }

     Tmp:='';

     IF (Msg.ReplyTo_U <> '') THEN
        Tmp:=UseGetAddress (Copy (Msg.ReplyTo_U,Length ('Reply-To: ')+1,255));

     IF (Tmp = '') AND (Msg.Sender_U <> '') THEN
        Tmp:=UseGetAddress (Copy (Msg.Sender_U,Length ('Sender: ')+1,255));

     IF (Tmp = '') AND (Msg.FromUser_U <> '') THEN
        Tmp:=UseGetAddress (Copy (Msg.FromUser_U,Length ('From: ')+1,255));

     { to add: "From " header handling? }

     UsenetReplyAdres:=Tmp;
END;


{--------------------------------------------------------------------------}
{ UsenetBounceMail                                                         }
{                                                                          }
{ Een bericht wordt om een of andere reden terug gestuurd aan de afzender  }
{                                                                          }
PROCEDURE UsenetBounceMail (Reason : STRING);

VAR EenRegel  : EenRegelRecordPtr;
    MsgOrigTo,
    MsgTo     : STRING;

    (* RWI950415  van voor de tijd van MoveRegelsToLineBuffer...
    {----------------------------------------------------------------------}
    { CopyMsgBuffer2LineBuffer                                             }
    {                                                                      }
    PROCEDURE CopyMsgBuffer2LineBuffer (EenRegel : EenRegelRecordPtr);
    BEGIN
         WHILE (EenRegel <> NIL) DO
         BEGIN
              { RWI 941127: NoEOL toegevoegd }
              AddToLineBufferNoEOL (LineBuffer,EenRegel^.RegelPtr^);
              EenRegel:=EenRegel^.NextRegelRecordPtr;
         END; { while }
    END;
    *)

{ UsenetBounceMail }
BEGIN
{$IFDEF WtrTest}
     LogMessage ('Target: Mail bounce ('+Reason+')');
{$ELSE}

     { Returned to sender                                           }
     { Wauw, jammer dat er geen postzegel van elvis opzat <grinnik> }
     MsgTo:=UsenetReplyAdres;

     MsgOrigTo:=Msg.XqtTo_U;

     IF (MsgTo = MsgOrigTo) THEN
     BEGIN
          LogMessage ('Sender is recipient; avoiding bounce loop');
          Exit;
     END;

     { De header moet nu naar het begin van de body ,... ooops }
     { Doe dat als volgt :                                     }
     {  - Geef de error melding in de linebuffer               }
     {  - Plak daar de header + bericht onder                  }
     {  - Dump eigenlijke header & body                        }
     {  - Creer nieuwe header, en plaats de linebuffer op      }
     {    plaats van de oude body.                             }

     LineBuffer:=NIL;

     { Stap - 1                          }
     { Geef de foutmelding aan het begin }
     AddToLineBuffer (LineBuffer,'');
     AddToLineBuffer (LineBuffer,UseGetSystemFromName+' bounced a message back to '+MsgTo);
     AddToLineBuffer (LineBuffer,'');
     AddToLineBuffer (LineBuffer,Reason);
     AddToLineBuffer (LineBuffer,'');
     AddToLineBuffer (LineBuffer,RepChar (79,'-'));

     IF Config.BounceSmall THEN
        AddToLineBuffer (LineBuffer,'Start of original message follows below:')
     ELSE
         AddToLineBuffer (LineBuffer,'Original message follows below:');

     AddToLineBuffer (LineBuffer,RepChar (79,'-'));
     AddToLineBuffer (LineBuffer,'');

     { Plak de orignele header en body eronder }
     MoveRegelsToLineBuffer (Msg.HeaderTop_U,LineBuffer);

     { empty line between header and body }
     AddToLineBuffer (LineBuffer,'');

     { RWI 951024: added BounceSmall }
     IF Config.BounceSmall THEN
     BEGIN
          IF (Msg.BodyTop <> NIL) THEN
          BEGIN
               IF CopyNLinesToLineBuffer (Msg.BodyTop^.FirstRegelRecordPtr,LineBuffer,20) THEN
               BEGIN
                    AddToLineBuffer (LineBuffer,'');
                    AddToLineBuffer (LineBuffer,'*** truncated rest of message ***');
               END;

               MsgsReleaseLines (Msg.BodyTop); { RWI 970211 }
          END;
     END ELSE
         MoveRegelsToLineBuffer (Msg.BodyTop,LineBuffer);

     { Msg.BodyTop moet nu NIL zijn }

     (*
     CopyMsgBuffer2LineBuffer (Msg.HeaderTop_U^.FirstRegelRecordPtr);
     MsgsReleaseLines (Msg.HeaderTop_U);   { dump de orginele header }
     CopyMsgBuffer2LineBuffer (Msg.BodyTop^.FirstRegelRecordPtr);
     MsgsReleaseLines (Msg.BodyTop);       { dump de orginele body }
     *)

     { pas de interne vlaggen aan }
     Msg.FromUser_U:='From: postmaster';
     {UseAdresParse ( MsgTo , string(Msg.ToSystem_U) , string(Msg.ToUser_U) );}

     { RWI 950202: "Subject: " toegevoegd voor TranslateMail2Netmail }
     {             Idem voor Date_U                                  }
     { RWI 950605: Maar in de opbouw van de header stonden ze nog en   }
     {             niemand heeft er in die vier maanden over geklaagd. }
     {             BONER!                                              }
     Msg.Subj_U:='Subject: Bounced Message to '+MsgOrigTo;
     Msg.Date_U:='Date: '+UsenetArpanetDate;
     Msg.XqtTo_U:=MsgTo;

     { creer een nieuwe header }
     MsgsAddLineTo (Header_U,'From '+UseGetSystemFromName+'!postmaster '+UsenetArpanetDate);
     { RWI 950623: niet meer voor door ons gecreerde mail
     MsgsAddLineTo (Header_U,'Received: by '+UseGetSystemFromName+' ('+Copy (FidoTear,5,255)+')');
     MsgsAddLineTo (Header_U,'          via UUCP; '+UsenetArpanetDate);
     MsgsAddLineTo (Header_U,'          for '+MsgTo);
     }
     MsgsAddLineTo (Header_U,+Msg.Date_U);
     MsgsAddLineTo (Header_U,'From: postmaster@'+Config.Domains[1]);
     MsgsAddLineTo (Header_U,'Message-ID: <'+GetFidoPktName+'@'+Config.Domains[1]+'>');
     MsgsAddLineTo (Header_U,'To: '+MsgTo);
     MsgsAddLineTo (Header_U,+Msg.Subj_U);

     { plak de line buffer aan het bericht }
     Msg.BodyTop:=LineBuffer;
     LineBuffer:=NIL; { RWI 960104 }

     Msg.Routed_U:=0; { new chance }

     { en probeer het (nogmaals) te versturen }
     IF (Msg.XqtTo_U <> '') THEN
        UsenetRouteMail
     ELSE
         LogMessage ('Bounce failed because the sender could not be determined');

{$ENDIF (!WtrTest)}
END;


{--------------------------------------------------------------------------}
{ OurDomainAtEnd                                                           }
{                                                                          }
{ This routine checks whether our domain is at the end of the given domain }
{ and verifies that a "." or "@" is in front. This avoid triggering on     }
{ "moredomain.se" when our domain is "domain.se". Returns TRUE if it is a  }
{ match. Both inputs are in upper case already.                            }
{                                                                          }
FUNCTION OurDomainAtEnd (OurDomain,CheckDomain : STRING) : BOOLEAN;

VAR P : BYTE;

BEGIN
     OurDomainAtEnd:=FALSE; { assume not }

     P:=Pos (OurDomain,CheckDomain);

     IF (P > 1) THEN
        IF (CheckDomain[P-1] <> '.') THEN
           P:=0;

     OurDomainAtEnd:=(P <> 0);
END;


{--------------------------------------------------------------------------}
{ UsenetRouteMail                                                          }
{                                                                          }
{ Deze routine probeert een bericht te versturen via het juiste systeem    }
{ Gekeken word of het bericht voor een intern programma (Areafix)          }
{ lokaal of een externe node bestemd is.                                   }
{                                                                          }
PROCEDURE UsenetRouteMail;

VAR RecNr          : UserBaseRecordNrType;

    HulpUserUp,
    HulpUser,      {: {UsenetUserNameString;}
    HulpDomain     : STRING;{UsenetDomainNameString;}

    FidoAdresStr,
    LocalDomain    : STRING;
    Found_FidoString,
    FoundTarget    : BOOLEAN;
    Lp,
    AliasTeller    : INTEGER;
    FoundOurDomainAtTheEndOfTheAdres : BOOLEAN;

    TargetAddr     : FidoAddrType;

    PrevUserDataRecNr : UserBaseRecordNrType;

BEGIN
     { Om oneindige loops te voorkomen, check of we al een keer de routing }
     { routines gelopen zijn met dit bericht.                              }

     Inc (Msg.Routed_U); { RWI 960817 }

     IF (Msg.Routed_U > 2) THEN
     BEGIN
          LogMessage ('[RouteMail] Detected routing loop; trashing message');
          Exit;
     END;

     { voer eerst de mapping uit en daarna pas de BOUNCE, SAVE, etc. }
     { zodat met de MAP-UUCP statements alles naar e'e'n adres       }
     { geroute kan worden.                                           }
     MapUUCP;

     IF (Msg.XqtTo_U = '!') OR (Msg.XqtTo_U = '@') OR (Pos ('@@',Msg.XqtTo_U) > 0) THEN
     BEGIN
          LogMessage ('Invalid e-mail address; ignoring message: '+Msg.XqtTo_U);
          Exit;
     END;

     IF (NOT Msg.ListServer) THEN
     BEGIN
          { RWI 951117: sendfile verplaatst. Werkt nu op alle system domains }
          IF UsenetSaveMessage OR UsenetBounce OR UsenetMailTunnel THEN
             Exit;

          IF UsenetMapArea THEN
          BEGIN
               {$IFDEF WtrTest}
               LogMessage ('Target: News because of MAP-AREA');
               {$ELSE}

               { AreaRecNr ingevuld }
               TranslateMail2News;

               { !!!! RWI 960323: moeten we herstellen }
               PrevUserDataRecNr:=UserDataRecNr;
               UserDataRecNr:=NILRecordNr; { distribute to all }

               MsgsExport;

               UserDataRecNr:=PrevUserDataRecNr; { !!!! RWI 960323 }
               {$ENDIF}
               Exit;
          END;
     END;

     { De functie van XqtTo is wat vaag geworden, om het allemaal simpel }
     { te maken, XqtTo is een XqtTo type string die het volledige        }
     { TO Adres van de doel node bevat !                                 }
     { Ala :                                                             }
     { MartijnD@Solist.Htsa.Aha.Nl                                       }

     HulpAddrType:=UseAdresParse (Msg.XqtTo_U,HulpDomain,HulpUser);
     HulpUserUp:=UpCaseString (HulpUser);

     { RWI 950212: nadat take!takev@wsd.uucp niet goed verwerkt werd, }
     {             heb ik hier maar eens keihard een controle op de   }
     {             username ingebouwd. Ik denk dat UseAdresParse nog  }
     {             eens structureel onderuit gehaald moet worden.     }
     { RWI 950902: dit zou nu niet meer nodig moeten zijn }
     IF (Pos ('!',HulpUser) > 0) OR (Pos ('@',HulpUser) > 0) THEN
        HulpAddrType:=UUCP; { forceer routing }

     { RWI 960604: als het een bij ons bekend domain / UUCPname is, dan }
     {             het bericht als local behandelen.                    }
     IF UsenetIsOurDomain (HulpDomain) THEN
        HulpAddrType:=LOKAAL;

     { Stap 0                                  }
     {                                         }
     { Kijk of het bericht lokaal bestemd is   }
     { Bijv. MARTIJND                          }

     IF (HulpAddrType = LOKAAL) THEN
     BEGIN
          { RW961213: voorkom dat netmails tijdens een list    }
          {           distributie gegate worden want dat duidt }
          {           op een configuratie fout en zorgt voor   }
          {           grote problemen!                         }
          IF Msg.ListServer THEN
          BEGIN
               LogMessage ('ERROR: Gateway is closed during (mail) list distribution!');
               LogExtraMessage ('Recipient: '+Msg.XqtTo_U);
               Exit;
          END;

          { oplossing 1: het bericht is aan newsfix gericht }
          IF (HulpUserUp = UpCaseString (Config.NewsfixName)) THEN
          BEGIN
               LogMessage ('Found e-mail for newsfix from '+UsenetReplyAdres);
               {$IFDEF WtrTest}
               LogMessage ('Target: Newsfix');
               {$ELSE}
               UUCPAreafix;
               {$ENDIF}
               Exit;
          END;

          { controleer of het voor een van de mailing lists is }
          IF ListServerSearchName (HulpUserUp) THEN
          BEGIN
               LogMessage ('Found e-mail for mailing list "'+HulpUser+'" from '+UsenetReplyAdres);
               {$IFDEF WtrTest}
               LogMessage ('Target: Mailing list');
               {$ELSE}
               ListServerDistributeMailToAll;
               {$ENDIF}
               Exit;
          END;

          { kijk of het voor de list server robot is }
          { RWI 960614: vergelijking op ListServ2 was tegen HulpUser }
          IF (HulpUserUp = ListServer1) OR (HulpUserUp = ListServer2) THEN
          BEGIN
               LogMessage ('Found e-mail for the listserver from '+UsenetReplyAdres);
               {$IFDEF WtrTest}
               LogMessage ('Target: List Server');
               {$ELSE}
               ListServerUsenetFix;
               {$ENDIF}
               Exit;
          END;

          IF UsenetSendFile (HulpUser) THEN
             Exit;

          IF TranslateMail2Netmail (Config.NodeNrs[Config.GatewayAKA],HulpUser) THEN
             FidoRouteNetmail;

          Exit;
     END;

     (* RWI 960604: is nu gelijk aan stap 0 door detectie lokale domains
     { Stap 1                                  }
     { Kijk of het bericht voor ons bestemd is }
     { RWI 950212: controle op <> UUCP toegevoegd }
     IF (HulpAddrType <> UUCP) AND UsenetIsOurDomain (HulpDomain) THEN
     BEGIN
          { Oplossing 1 : Het bericht is aan areafix gericht    }
          IF (HulpUserUp = UpCaseString (Config.NewsfixName)) THEN
          BEGIN
               LogMessage ('Found e-mail for newsfix from '+UsenetReplyAdres);
               {$IFDEF WtrTest}
               LogMessage ('Target: Newsfix');
               {$ELSE}
               UUCPAreaFix;
               {$ENDIF}
               Exit;
          END;

          { Controleer of het voor de listserver is }
          IF ListServerSearchName (HulpUserUp) THEN
          BEGIN
               LogMessage ('Found e-mail for mailing list "'+HulpUser+'" from '+UsenetReplyAdres);
               {$IFDEF WtrTest}
               LogMessage ('Target: Mailing list');
               {$ELSE}
               ListServerDistributeMailToAll;
               {$ENDIF}
               Exit;
          END;

          IF (HulpUserUp = ListServer1) OR (HulpUserUp = ListServer2) THEN
          BEGIN
               LogMessage ('Found e-mail for the listserver from '+UsenetReplyAdres);
               {$IFDEF WtrTest}
               LogMessage ('Target: List Server');
               {$ELSE}
               ListServerUsenetFix;
               {$ENDIF}
               Exit;
          END;

          IF UsenetSendFile (HulpUser) THEN
             Exit;

          { Nee dus, aangezien lokale berichten niet ondersteund worden }
          { moet het bericht dus maar gebounced worden.                 }
          IF TranslateMail2Netmail (Config.NodeNrs[Config.GatewayAKA],UsenetReplyAdres,HulpUser) THEN
             FidoRouteNetmail;

          Exit;
     END;
     *)

     { Stap 2                                                            }
     {                                                                   }
     { Probeer of we het doel adres gewoon kennen, in dat geval gaan we  }
     { niet moeilijk doen.                                               }
     RecNr:=GetUucpRoute (STRING (Msg.XqtTo_U){,Config.UUCPName});
     IF (RecNr <> NILRecordNr) THEN
     BEGIN
          ReadUserBaseRecord (RecNr,UserData);

          { Als het doel systeem een usenet type systeem is hoeft er niets }
          { te worden omgebouwd.                                           }
          IF (UserData.System IN [_U,_S]) THEN
          BEGIN
               LogMessage ('Sending e-mail for '+Msg.XqtTo_U+' to '+UserData.UUCPName);
               Msg.ToSystem_U:=UserData.UUCPName;

               { Verander SUN4NL!JAAP!MARTIJN  --> JAAP!MARTIJN     }
               { !Test met waffle liet zien dat de TO: regel        }
               { in het bericht zelf niet hoeft aangepast te worden }

               {$IFDEF WtrTest}
               LogMessage ('Target: Outgoing Mail');
               {$ELSE}
               StatUsenetSendMail;
               MsgsExportUsenetMail;
               {$ENDIF}
               Exit;
          END ELSE
          BEGIN
               { RW961213: voorkom dat netmails tijdens een list    }
               {           distributie gegate worden want dat duidt }
               {           op een configuratie fout en zorgt voor   }
               {           grote problemen!                         }
               IF Msg.ListServer THEN
               BEGIN
                    LogMessage ('ERROR: Gateway is closed during (mail) list distribution!');
                    LogExtraMessage ('Recipient: '+Msg.XqtTo_U);
                    Exit;
               END;

               TargetAddr:=UserData.Address;

               { kijk of dit een e-mail aan een point van deze node }
               { is. Zoja, dan moeten we het point nummer invullen. }
               IF (TargetAddr.Point = 0) AND (FindUUCPRoutePoint <> 0) THEN
               BEGIN
                    IF Config.LogMapApply THEN
                       LogMessage ('Found e-mail for point '+Word2String (FindUUCPRoutePoint)+
                                   ' of node '+Fido2Str (TargetAddr));

                    TargetAddr.Point:=FindUUCPRoutePoint; { let's pray it's the right one! }
               END;

               { als het echter een fido systeem is zitten we in de problemen }
               IF TranslateMail2Netmail (TargetAddr,HulpUser) THEN
                  FidoRouteNetmail;

               Exit;
          END;
     END;

     Msg.ToSystem_U:=HulpDomain;
     LocalDomain:=UpCaseString (HulpDomain);
     FoundTarget:=FALSE;

     FoundOurDomainAtTheEndOfTheAdres:=FALSE;

     { Stap - 3                                                       }
     {                                                                }
     { Probeer te bekijken of het bericht mischien aan                }
     { martijn_dijksterhuis@p6.f802.n280.z2.wlink.nl gericht is       }
     FOR AliasTeller:=1 TO MaxDomains DO
         IF OurDomainAtEnd (UpCaseString (Config.Domains[AliasTeller]),LocalDomain) THEN
         BEGIN
              FoundOurDomainAtTheEndOfTheAdres:=TRUE;

              { We hebben dus ons domain aan het einde van de string }
              { gevonden. Probeer er wat van te brouwen.             }
              { Formaat : p<point>.f<node>.n<net>.z<zone>            }

              FidoAdresStr:=Copy (LocalDomain,1,(Length (LocalDomain)-Length (Config.Domains[AliasTeller]))-1);

              (* RWI 941210: hier stond het volgende:

              {FidoSplit( '0' , Msg.ToAddr_F ); }
              Msg.ToAddr_F:=Config.NodeNrs[Config.UUCPGateWay];

              Maar dat gaf problemen bij het een adressering als

              Ramon_van_der_Winkel@z2.n280.f802.wsd.wlink.nl

              Daar werd namelijk het point nummer van mijn gateway aan
              toegevoegd en dat moet natuurlijk niet. Ik snap dat dit
              er stond omdat er ook met korte adressen gewerkt moet
              kunnen worden. Maar dat betekent dus dat je gateway geen
              point adres mag zijn.

              Groot gelijk eigenlijk. Tijd om dat hard te maken en in
              de docs te zetten en het adres bij het editten ook meteen
              het point nummer eraf te laten hakken.

              Oplossing is echter geworden het point adres van de gateway
              hier op 0 te zetten voor het default adres, zodat met
              een small address ook goed gaat. Als afzender wordt dan het
              volledige gateway adres gebruikt en als geaddresseerde het
              gevormde bericht, zonder het point nummer.
              *)

              Msg.ToAddr_F:=Config.NodeNrs[Config.GatewayAKA];
              Msg.ToAddr_F.Point:=0;

              Found_FidoString:=FALSE;
              FOR Lp:=1 TO Length (FidoAdresStr) DO
              BEGIN
                   { de volgende check is nodig omdat het verhogen van Lp  }
                   { na het vinden van een P4 bijvoorbeeld, er vanuit gaat }
                   { dat er nog een sectie volgt en stapt alvast voorbij   }
                   { de punt. Een controle aldaar kost meer als een kleine }
                   { controle hier, dus...                                 }
                   IF (Lp > Length (FidoAdresStr)) THEN
                      Break; { einde van de reis }

                   { Kijk of we een point gevonden hebben }

                   IF (FidoAdresStr[Lp] = 'P') THEN
                      IF (FidoAdresStr[Lp+1] IN ['0'..'9']) THEN
                      BEGIN
                           Found_FidoString:=TRUE;
                           Lp:=Lp+1+Atoi (Copy (FidoAdresStr,Lp+1,255),Msg.ToAddr_F.Point);
                           Continue;
                      END ELSE
                      BEGIN
                           Found_FidoString:=FALSE;
                           Break;
                      END;

                   IF (FidoAdresStr[Lp] = 'F') THEN
                      IF (FidoAdresStr[Lp+1] IN ['0'..'9']) THEN
                      BEGIN
                           Found_FidoString:=TRUE;
                           Lp:=Lp+1+Atoi (Copy (FidoAdresStr,Lp+1,255),Msg.ToAddr_F.Node);
                           Continue;
                      END ELSE
                      BEGIN
                           Found_FidoString:=FALSE;
                           Break;
                      END;

                   IF (FidoAdresStr[Lp] = 'N') THEN
                      IF (FidoAdresStr[Lp+1] IN ['0'..'9']) THEN
                      BEGIN
                           Found_FidoString:=TRUE;
                           Lp:=Lp+1+Atoi (Copy (FidoAdresStr,Lp+1,255),Msg.ToAddr_F.Net);
                           Continue;
                      END ELSE
                      BEGIN
                           Found_FidoString:=FALSE;
                           Break;
                      END;

                   IF (FidoAdresStr[Lp] = 'Z') THEN
                      IF (FidoAdresStr[Lp+1] IN ['0'..'9']) THEN
                      BEGIN
                           Found_FidoString:=TRUE;
                           Lp:=Lp+1+Atoi (Copy (FidoAdresStr,Lp+1,255),Msg.ToAddr_F.Zone);
                           Continue;
                      END ELSE
                      BEGIN
                           Found_FidoString:=FALSE;
                           Break;
                      END;

                   { he... it is not a P,F,N or Z... that means it is }
                   { crap!! Dump the bitch...                         }
                   Found_FidoString:=FALSE;
                   Break; { uit de for }

              END; { For }

              { Adres 0 mag niet doorkomen }
              WITH Msg.ToAddr_F DO
                   IF (Zone = 0) AND (Node = 0) AND (Net = 0) AND (Point = 0) THEN
                      Found_FidoString:=FALSE;

              IF (NOT Found_FidoString) THEN
                 Break; { uit de for }

              { Blijkbaar hebben we een echt fido adres gevonden. Stuur }
              { het bericht naar de gelukkige geadresseerde.            }
              LogMessage ('Found e-mail for '+Fido2Str (Msg.ToAddr_F));

              IF Msg.ListServer THEN
              BEGIN
                   LogExtraMessage ('Gateway is closed during mailing list distribution though');
                   LogExtraMessage ('Please subscribe '+Msg.ToUser_F+' at '+Fido2Str (Msg.ToAddr_F)+
                                    ' to the list as a FidoNet style subscriber');
                   Exit;
              END;

              IF TranslateMail2Netmail (Msg.ToAddr_F,HulpUser) THEN
                 FidoRouteNetmail;

              Exit;
         END; { if, for }

     { Stap 4: RWI 951024
     {
     { Het bericht is niet bestemd voor een van onze bekende systemen,  }
     { maar meteen terug sturen naar de smarthost is niet slim. Als     }
     { het adres aanduid dat het een van onze systeem moet zijn (onder  }
     { ons), dan moet het in ieder geval niet terug gestuurd worden.    }

     { RWI 960713: wat bevat Msg.ToAddr_F nu? Is het mogelijk dat ie niet }
     {             ingevuld is? Kan er een gateway AKA in staan die half  }
     {             overschreven is tijdens het decoderen van z.f.n.p?     }
     {             Ja dus!                                                }

     IF FoundOurDomainAtTheEndOfTheAdres THEN
     BEGIN
          LogMessage ('Found undeliverable mail for '+Msg.XqtTo_U);

          { als BounceUnknown op YES staat, dan sturen we het bericht terug }
          IF Config.BounceUnknown THEN
          BEGIN
               LogExtraMessage ('Bouncing message to sender ('+UsenetReplyAdres+')');
               UsenetBounceMail (GetLang0 (102));
               Exit;
          END;

          LogExtraMessage ('Writing to netmail area');

          Msg.ToAddr_F:=Config.NodeNrs[Config.GatewayAKA]; { RWI 960713 }

          IF TranslateMail2Netmail (Msg.ToAddr_F,HulpUser) THEN
          BEGIN
               IF (GetLang0 (103) <> '') THEN
               BEGIN
                    MsgsAddFirstLineTo (Body,'');
                    MsgsAddFirstLineTo (Body,GetLang1 (103,Msg.XqtTo_U));
               END;

               {$IFDEF WtrTest}
               LogMessage ('Target: Import in netmail area');
               {$ELSE}
               Msg.Attr_F:=Msg.Attr_F OR MSGHOLD;
               FidoImportNetmail;
               {$ENDIF}
               Exit;
          END;

          Exit;
     END;

     { Stap - 5                                                          }
     { We zijn er nog steeds, blijkbaar is het bericht niet voor een van }
     { onze bekende systemen bestemd. Stuur het door naar het systeem    }
     { dat aangewezen is als smarthost.                                  }

     { RWI 950605: UpCaseString er omheen getimmerd }
     IF (UpCaseString (Msg.Sender_U) = UpCaseString (Config.SmartHost)) THEN
     BEGIN
          LogMessage ('Unable to transport e-mail message, originating from smart host');
          UsenetBounceMail ('Reason: System unknown');
          Exit;
     END;

{ hier moet nog eens een controle komen of het laatste deel van het adres }
{ ons eigen domain bevat. Zoja, dan moet het bericht niet terug gestuurd  }
{ worden, maar doorgestuurd.                                              }

     { RAWI 971116: safe current user }
     PrevUserDataRecNr:=UserDataRecNr;

     Msg.ToSystem_U:=Config.SmartHost;
     Msg.ToUser_U:='To: '+Msg.XqtTo_U; { RWI 960928: added 'To: ' }

     { laad de Userbase record van het TO system }
     IF FindUserBaseRecordByUUCPName (Config.SmartHost,UserDataRecNr) THEN
     BEGIN
          LogMessage ('Sending e-mail for '+Msg.XqtTo_U+' to the smarthost');
          {$IFDEF WtrTest}
          LogMessage ('Target: Outgoing Mail');
          Exit;
          {$ELSE}
          ReadUserBaseRecord (UserDataRecNr,UserData);
          StatUsenetSendMail;
          MsgsExportUsenetMail;
          {$ENDIF}
     END ELSE
         LogMessage('[RouteMail] Serious config error! Smarthost not in UserBase!');

     { RAWI 971116: restore UserDataRecNr }
     UserDataRecNr:=PrevUserDataRecNr;

     {$IFDEF WtrTest}
     LogMessage ('Target: Eh...');
     {$ENDIF}
END;


{--------------------------------------------------------------------------}
{ UseCRCMessage                                                            }
{                                                                          }
{ Creer een CRC over een binnengekomen Usenet bericht.                     }
{                                                                          }
FUNCTION UseCRCMessage : LONGINT;

VAR Help : STRING;

BEGIN
     Help:=AddUpWithSpaces (255,Msg.MessageID_U);
     UseCRCMessage:=UpdateCRC32 ($FFFFFFFF,Help[1],255);
END;


{--------------------------------------------------------------------------}
{ UseGetSystemFromName                                                     }
{                                                                          }
{ Aangezien we onze UUCP name alleen mogen gebruiken als ie uniek is       }
{ bepaal hier welke string we op die plaats moeten zetten.                 }
{                                                                          }
FUNCTION UseGetSystemFromName : STRING;
BEGIN
     IF Config.WorldWide THEN
        UseGetSystemFromName:=Config.UUCPName
     ELSE
         UseGetSystemFromName:=Config.Domains[1];
END;


{---------------------------------------------------------------------------}
{ UseGetUserFromName                                                        }
{                                                                           }
{ Deze routine geeft de domain naam aan de hand van het opgegeven userbase  }
{ record terug. Als de user worldreg is, dan wordt het zijn/haar uucpname,  }
{ anders het eerste domain adres.                                           }
{                                                                           }
FUNCTION UseGetUserFromName (UserData : UserBaseRecord) : STRING;
BEGIN
     IF UserData.WorldReg THEN
        UseGetUserFromName:=UserData.UUCPName
     ELSE
         UseGetUserFromName:=UserData.Domains[1];
END;


{---------------------------------------------------------------------------}
{ UsenetBuildMail                                                           }
{                                                                           }
PROCEDURE UsenetBuildMail (DoelDomain,SUser,SFullName,Subject : STRING);
BEGIN
     MsgsEmpty; { Zorg dat we met een schone lei beginnen }

     Msg.XqtTo_U:=DoelDomain;
     MsgsReleaseLines (Msg.HeaderTop_U);

     { RWI 960811: controle op @ maar ingevoerd ivm problemen.. }
     IF (Pos ('@',SUser) = 0) THEN
        SUser:=UseGetSystemFromName+'!'+SUser;

     MsgsAddLineTo (Header_U,'From '+SUser+' '+UsenetArpaNetDate);

     { RWI 950623: niet meer in door ons gegenereerde berichten!
     MsgsAddLineTo (Header_U,'Received: by '+Sender+' ('+Copy (FidoTear,5,255)+')');
     MsgsAddLineTo (Header_U,'          via UUCP; '+UsenetArpaNetDate);
     MsgsAddLineTo (Header_U,'          for '+DoelDomain);
     }

     Msg.Date_U:='Date: '+UsenetArpaNetDate; { RWI 951117 }
     MsgsAddLineTo (Header_U,Msg.Date_U);

     IF (SFullName <> '') THEN
        SFullName:=' ('+SFullName+')';

     { bouw ook FromUser_U op, want die wordt gebruikt door TransMail->Net }
     { om de naam van de zender uit te vissen.                             }
     { RWI 960918: comment ivm wsd.wline.se!infoserver@wsd.wline.se }
     Msg.FromUser_U:='From: '+SUser+{'@'+RWI960918Config.Domains[1]+}SFullName;
     MsgsAddLineTo (Header_U,Msg.FromUser_U);

     Msg.MessageId_U:='Message-ID: <'+GetFidoPktName+'@'+Config.Domains[1]+'>'; { RWI 951117 }
     MsgsAddLineTo (Header_U,Msg.MessageId_U);

     Msg.ToUser_U:='To: '+DoelDomain; { RWI 951117 } { RWI 960928: added "To: " }
     MsgsAddLineTo (Header_U,Msg.ToUser_U);

     Msg.Subj_U:='Subject: '+Subject; { RWI 951117 }
     MsgsAddLineTo (Header_U,Msg.Subj_U);

     { RWI 970120: removed empty line addition }
     { RWI 970120: status now set to Mail for file encoding routines }
     {             and working together with charsets.               }
     Msg.Ready_U:=Mail;
END;



{--------------------------------------------------------------------------}
{ unit initialization                                                      }
{                                                                          }
BEGIN
     UsenetUniqueNameInit;
     LastDFilenameTry:=1;
END.
