{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT Translat;

{ Deze unit bevat alle routines om berichten tussen de verschillende  }
{ berichten formaten te kunnen converteren.                           }
{                                                                     }
{ Aparte routines voor News + Mail , Echomail + Netmail aangezien     }
{ ze allen op elkaar lijken, maar net even anders zijn.               }

{ History:

MD   20-03-93 Deze unit gemaakt en in gebruik genomen.
RvdW 02-04-93 Opgepoetst en News2Echo afgemaakt.
     16-05-93 TranslateNews2Echomail aangepast ivm x-posts.
MD   ??-07-93 Toevoegen van Mail2Netmail & Netmail2Mail
     08-08-93 Toevoegen van Usenet Organization kludges
                                   MessageID
     23-11-93 Conversie tabel in de configuratie geduwt
     12-02-94 Bugfix, een bekend systeem ZONDER domain[] definitie wordt
              nu ook van ons domain adres voorzien.

RWI  950601 Hele vertaling netmail->mail en echomail->news opnieuw gedaan
            en unified. Er is nu e'e'n routine die alle addres mappings
            uitvoert en headers aanmaakt. De echomail liep echt gigantisch
            achter op wat de netmail vertaling deed...
}


INTERFACE

USES Database,
     Msgs,
     UU;

PROCEDURE TranslateNews2Echomail (CrossPosted : STRING);
PROCEDURE TranslateEchomail2News;
FUNCTION  TranslateNetmail2Mail (ToUser : STRING) : BOOLEAN;
FUNCTION  TranslateMail2Netmail (FidoToAddr : FidoAddrType; ToUserUsenet : STRING) : BOOLEAN;

{ voor de list server }
PROCEDURE TranslateNetmail2Echomail (AreaRecNr : AreaBaseRecordNrType);
PROCEDURE TranslateEchomail2Netmail;
PROCEDURE Translate_PatchEchomail;
PROCEDURE TranslateNews2Mail;

{ voor map-area }
PROCEDURE TranslateMail2News;

{SubFuncties}
FUNCTION Usenet2FidoUserName (LenName : Integer; VAR Invoer : UseNetUserNameString) : STRING;
FUNCTION CleanFidoName (Invoer : STRING; DoUnderScore : BOOLEAN) : STRING;
FUNCTION BuildFidonetInternetAdres (Source : FidoAddrType; AddPunt : STRING) : STRING;
FUNCTION RemovePathsFromSubject (Subj : STRING; FABit : BYTE) : STRING;


IMPLEMENTATION

USES AreaBase,
     Fido,
     Cfg,
     Globals,
     Logs,
     Ramon,
     UserBase,
     UseAdres,
     Usenet,
     Routing,
     SwapMem,
     ListSrv,
     Language,
     CharSets,
     SeenBy;

VAR KludgeBuffer,
    NormalBuffer   : TopRegelRecordPtr;
    BodyLinesCount : LONGINT;

      { tijdelijk, voor subject, from, to, etc. }
CONST CnstTekens : TekenArrayType = (
 {128..136} {}'c',{}'u',{}'e',{}'a',{}'a',{}'a',{}'a',{}'c',{}'e',
 {137..145} {}'e',{}'e',{}'i',{}'i',{}'i',{}'A',{}'A',{}'E',{}'*',
 {146..154} {}'A',{}'o',{}'o',{}'o',{}'u',{}'u',{}'y',{}'O',{}'U',
 {155..163} {}'*',{}'*',{}'*',{}'*',{}'f',{}'a',{}'i',{}'o',{}'u',
 {164..172} {}'e',{}'N',{}'*',{}'*',{}'?',{}'+',{}'+',{}'*',{}'*',
 {173..181} {}'!',{}'<',{}'>',{}'*',{}'*',{}'*',{}'|',{}'+',{}'+',
 {182..190} {}'+',{}'+',{}'+',{}'+',{}'|',{}'+',{}'+',{}'+',{}'+',
 {191..199} {}'+',{}'+',{}'+',{}'+',{}'+',{}'-',{}'+',{}'+',{}'+',
 {200..208} {}'+',{}'+',{}'+',{}'+',{}'+',{}'-',{}'+',{}'+',{}'+',
 {209..217} {}'+',{}'+',{}'+',{}'+',{}'+',{}'+',{}'+',{}'+',{}'+',
 {218..226} {}'+',{}'*',{}'*',{}'*',{}'*',{}'*',{}'a',{}'b',{}'c',
 {227..235} {}'d',{}'E',{}'*',{}'*',{}'*',{}'*',{}'*',{}'*',{}'*',
 {236..244} {}'*',{}'*',{}'*',{}'*',{}'=',{}'*',{}'*',{}'*',{}'*',
 {245..253} {}'*',{}'*',{}'=',{}'*',{}'*',{}'*',{}'*',{}'*',{}'*',
 {254..255} {}'*',{}'*');


{=====================================================================}
{ MSGID <-> Message-ID mapping                                        }
{                                                                     }
{ 1) MSGID moet het Internet op kunnen en bij terugkomst gedetecteerd }
{    worden en weer netjes omgezet worden.                            }
{                                                                     }
{ 2) Niet-FTN MSGID kludges moeten gecodeerd worden in een Message-ID }
{    header en bij terugkomst weer gedecodeerd worden. Lijkt op 1)    }
{    maar kan een andere kodering gebruiken.                          }
{                                                                     }
{ 3) Message-IDs die eens omgezet zijn in een MSGID en nu op de terug }
{    weg zijn moeten weer netjes terug omgezet worden.                }
{                                                                     }
{ Message-ID: codering: Zet er "wgid$" voor en neem de rest over en   }
{                       voeg een CRC32 over dit stuk toe.             }
{                                                                     }
{ MSGID codering: als er wgid$ voor staat en de CRC32 klopt, neem dan }
{                 de rest over.                                       }
{                                                                     }
{=====================================================================}


{--------------------------------------------------------------------------}
{ MsgID2MessageID                                                          }
{                                                                          }
{ Deze routine vertaalt de fido MSGID kludge in een legale Message-ID      }
{ header en geeft deze terug (zonder de "Message-ID: ") voor toevoeging    }
{ aan de mail/news header.                                                 }
{                                                                          }
{ Message-ID codering in de MSGID kludge wordt gedetecteerd en vertaald in }
{ de originele header. Anders wordt de MSGID kludge gecodeerd en terug     }
{ gegeven.                                                                 }
{                                                                          }
FUNCTION MsgID2MessageID (MsgID : STRING) : STRING;

VAR Res : STRING;
    Lp  : BYTE;
    C   : CHAR;
    AKA : FidoAddrType;

BEGIN
     { Msg.MsgID_F bevat "anything crc32". }

     IF (Msg.MsgID_F = '') THEN
     BEGIN
          MsgID2MessageID:='<none_'+GetFidoPktName+'@'+Config.Domains[1]+'>';
          Exit;
     END;

     { splitsen van "anything" en crc32 (de laatste 8 tekens met een }
     { spatie ervoor zodat we een gecodeerde Message-ID: kunnen      }
     { herstellen.                                                   }
     IF (Length (MsgID) > 9) AND (MsgID[Length (MsgID)-8] = ' ') AND (Copy (MsgID,1,6) = 'wgmid$') THEN
     BEGIN
          { lekker makkelijk: een Message-ID: op de terugweg }
          MsgID2MessageID:=Copy (MsgID,7,Length (MsgID)-8-7);
          Exit;
     END;

     { RWI 970112: kijk of dit al een gecodeerde, vroeger Message-ID is }
     IF (Copy (MsgID,1,6) = 'wgmid$') THEN
     BEGIN
          Delete (MsgID,1,6);
          MsgID2MessageID:=MsgID;
          Exit;
     END;

     { ietwat meer werk: codering van een generiek MSGID }

     Res:='wgcid$';  { coded id }
     FOR Lp:=1 TO Length (MsgID) DO
     BEGIN
          C:=MsgID[Lp];

          CASE C OF
               'A'..'Z',
               'a'..'z',
               '0'..'9',
               '-' : Res:=Res+C;

               ':' : Res:=Res+'$g';
               '/' : Res:=Res+'$h';
               '.' : Res:=Res+'$i';
               ' ' : Res:=Res+'$j';
               '@' : Res:=Res+'$k';

               ELSE
                   Res:=Res+'$'+LoCaseString (Byte2HexString (Byte (C)));
          END; { case }
     END; { for }

     MsgID2MessageID:='<'+Res+'@'+Config.Domains[1]+'>';
END;


{--------------------------------------------------------------------------}
{ TestMessageID2MsgID                                                      }
{                                                                          }
{ Deze routine controleert of een Message-ID:, In-Reply-To: or References: }
{ header contains a valid Message Identification that can be copied into   }
{ the MSGID or REPLY kludge of a fido message. If so, returns TRUE.        }
{                                                                          }
FUNCTION TestMessageID2MsgID (ID : STRING) : BOOLEAN;

VAR P1,P2,P3 : BYTE;

BEGIN
     TestMessageID2MsgID:=FALSE;

     IF (ID = '') THEN
        Exit;

     P1:=Pos ('<',ID);
     P2:=Pos ('@',ID);
     P3:=Pos ('>',ID);

     IF (P1 > 0) AND (P2 > P1) AND (P3 > P2) THEN
        TestMessageID2MsgID:=TRUE; { give it a try }
END;


{--------------------------------------------------------------------------}
{ MessageID2MsgID                                                          }
{                                                                          }
{ Deze routine vertaalt de inhoud van een Message-ID header (en andere) in }
{ de inhoud voor een MSGID of REPLY etc.                                   }
{                                                                          }
{ Deze routine zal nog wel geleerd moeten worden om onnodige informatie te }
{ strippen. Voorlopig wordt gewoon de eerste <*@*> combinatie genomen.     }
{                                                                          }
FUNCTION MessageID2MsgID (Debug : CHAR; MessageID : STRING; IsXPost : BOOLEAN; AreaName : STRING; OriginAKA : BYTE) : STRING;

VAR P1,P2,P3 : BYTE;
    Res      : STRING;
    Lp       : BYTE;

BEGIN
     P1:=Pos ('<',MessageID);
     P2:=Pos ('@',MessageID);
     P3:=Pos ('>',MessageID);

     IF (P1 > 0) AND (P2 > P1) AND (P3 > P2) THEN
     BEGIN
          { strip het stuk dat we gaan bekijken }
          MessageID:=Copy (MessageID,P1,P3-P1+1);
          P2:=Pos ('@',MessageID);

          {LogMessage ('MID: "'+MessageID+'"');}

          IF (Copy (MessageID,1,7) = '<wgcid$') AND (Copy (MessageID,P2+1,Length (Config.Domains[1])) = Config.Domains[1]) THEN
          BEGIN
               { een door ons gecodeerde MSGID: decoderen met die hap! }
               MessageID:=Copy (MessageID,8,P2-8);
               {LogMessage ('wgcid: "'+MessageID+'"');}

               Res:='';
               FOR Lp:=1 TO Length (MessageID) DO
               BEGIN
                    IF (MessageID[Lp] = '$') THEN
                    BEGIN
                         CASE MessageID[Lp+1] OF
                              'g' :
                                  BEGIN
                                       Res:=Res+':';
                                       Inc (Lp);
                                  END;

                              'h' :
                                  BEGIN
                                       Res:=Res+'/';
                                       Inc (Lp);
                                  END;

                              'i' :
                                  BEGIN
                                       Res:=Res+'.';
                                       Inc (Lp);
                                  END;

                              'j' :
                                  BEGIN
                                       Res:=Res+' ';
                                       Inc (Lp);
                                  END;

                              'k' :
                                  BEGIN
                                       Res:=Res+'@';
                                       Inc (Lp);
                                  END;

                              ELSE BEGIN
                                   Res:=Res+Char (Byte (HexString2Long (Copy (MessageID,Lp+1,2))));
                                   Inc (Lp,2);
                              END;
                         END; { case }

                    END ELSE
                        Res:=Res+MessageID[Lp];
               END;

               MessageID2MsgID:=Res;
               Exit;
          END;

          { RWI 960505: dit geeft zware problemen... met sommige tossers }
          {             ja, dus is het nu een optie, zoals alles hier..  }
          IF (Config.GateMsgId = gmNot) THEN
          BEGIN
               IF (MessageID <> '') AND (NOT IsXPost) THEN

                  MessageID2MsgID:=Fido2Str (Config.NodeNrs[OriginAKA])+' '+
                                   Long2HexString (UpDateCRC32 ($FFFFFFFF,MessageID[1],Length (MessageID)))
               ELSE
                   MessageID2MsgID:=Fido2Str (Config.NodeNrs[OriginAKA])+' '+GetFidoPktName;
          END ELSE
          BEGIN
               { instead of the MessageID en AreaName aan elkaar (MSGID,DOC) }
               { tellen we gewoon de twee CRC32's op.                        }
               MessageID2MsgID:='wgmid$'+MessageID+' '+LoCaseString (Long2HexString (
                                                         UpdateCRC32 (0,MessageID[1],Length (MessageID))+
                                                         UpdateCRC32 (0,AreaName[1],Length (AreaName))
                                                         ));
          END;

          Exit;
     END;

     Res:='?';
     IF Debug = 'M' THEN Res:='Message-ID';
     IF Debug = 'I' THEN Res:='In-Reply-To';
     IF Debug = 'R' THEN Res:='References';

     LogMessage ('Cannot UF invalid '+Res+': "'+MessageID+'"');

     { terug vallen op "normale" message ID }
     IF (NOT IsXPost) THEN
        MessageID2MsgID:=Fido2Str (Config.NodeNrs[OriginAKA])+' '+
                         Long2HexString (UpDateCRC32 ($FFFFFFFF,MessageID[1],Length (MessageID)))
     ELSE
         MessageID2MsgID:=Fido2Str (Config.NodeNrs[OriginAKA])+' '+GetFidoPktName;
END;


{--------------------------------------------------------------------------}
{ BuildPIDKludge                                                           }
{                                                                          }
{ This routine returns the PID line to put in the message. It is extracted }
{ from the tear line.                                                      }
{                                                                          }
FUNCTION BuildPIDKludge : STRING;
BEGIN
     BuildPIDKludge:=#1'PID: '+ProgramPID; {Copy (FidoTear,5,255);}
END;


{--------------------------------------------------------------------------}
{ AddFilesToBody                                                           }
{                                                                          }
{ Deze routine loopt de opgegeven regel en breekt deze op de spaties. Het  }
{ resultaat wordt daarna als filename geinterpreteerd en UU-encoded in de  }
{ body van het bericht opgenomen.                                          }
{                                                                          }
PROCEDURE AddFilesToBody (Filenames : STRING);

VAR Name : STRING;

BEGIN
     Filenames:=DeleteFrontAndBackSpaces (Filenames);
     WHILE (Pos ('  ',Filenames) > 0) DO
           Delete (Filenames,Pos ('  ',Filenames),1);

     WHILE (Filenames <> '') DO
     BEGIN
          IF (Pos (' ',Filenames) > 0) THEN
          BEGIN
               Name:=Copy (Filenames,1,Pos (' ',Filenames)-1);
               Delete (Filenames,1,Pos (' ',Filenames));
          END ELSE
          BEGIN
               Name:=Filenames;
               Filenames:='';
          END;

          XX_FileToBody (Name,FALSE,FALSE);
     END; { while }

     MsgsAddLineTo (Body,''); { lege regel na 'end' nodig }
END;


{--------------------------------------------------------------------------}
{ RemovePathsFromSubject                                                   }
{                                                                          }
{ This routine is called from TranslateNetmail2Mail to clean the subjecgt  }
{ from the paths to the files. It is only called when the netmail has      }
{ the file attach flag.                                                    }
{                                                                          }
FUNCTION RemovePathsFromSubject (Subj : STRING; FABit : BYTE) : STRING;

VAR Name,
    NewSubj : STRING;

BEGIN
     IF (FABit = 0) THEN
     BEGIN
          { no file attach bit set, return original subject }
          RemovePathsFromSubject:=Subj;
          Exit;
     END;

     Subj:=DeleteFrontAndBackSpaces (Subj);
     WHILE (Pos ('  ',Subj) > 0) DO
           Delete (Subj,Pos ('  ',Subj),1);

     NewSubj:='';
     WHILE (Subj <> '') DO
     BEGIN
          IF (Pos (' ',Subj) > 0) THEN
          BEGIN
               Name:=Copy (Subj,1,Pos (' ',Subj)-1);
               Delete (Subj,1,Pos (' ',Subj));
          END ELSE
          BEGIN
               Name:=Subj;
               Subj:='';
          END;

          { split the path and filename parts }
          WHILE (Pos ('\',Name) > 0) DO
                Delete (Name,1,Pos ('\',Name));

          IF (Name <> '') THEN
          BEGIN
               IF (NewSubj <> '') THEN
                  NewSubj:=NewSubj+' ';

               NewSubj:=NewSubj+Name;
          END;
     END; { while }

     RemovePathsFromSubject:=NewSubj;
END;


{--------------------------------------------------------------------------}
{ CopyHeadersFromFidoBody                                                  }
{                                                                          }
{ Deze routine bekijkt de body van het bericht en haalt daaruit e-mail     }
{ header regels en plaatst deze in de header van de e-mail. Alleen niet-   }
{ systeem headers worden toegestaan.                                       }
{ Het zoeken gaat door tot een lege regel uit de body verwijderd is, of    }
{ een niet-legale header regel gevonden is. Legale header regels beginnen  }
{ met een hoofdletter, hebben geen spatie in zich en eindigen met een      }
{ dubbele punt en een spatie, gevolgd door text.                           }
{                                                                          }
{ RWI 960310: Subject, Newsgroups and Organization are now buffered in     }
{             the Msg record and added when this routine returns.          }
{                                                                          }
PROCEDURE CopyHeadersFromFidoBody;

VAR EenRegelPtr : EenRegelRecordPtr;
    RegelLen    : BYTE;
    UpRegel,
    Regel       : STRING;
    P           : BYTE;

LABEL Done;

BEGIN
     {$IFNDEF WtrTest}
     IF (NOT Config.CopyHeaders_FU) THEN
        Exit;

     { RAWI 980105: would crash on empty-bodies echomail messages }
     IF (Msg.BodyTop = NIL) THEN
        Exit;

     EenRegelPtr:=Msg.BodyTop^.FirstRegelRecordPtr;
     MsgsNewSeek (EenRegelPtr);

     WHILE (EenRegelPtr <> NIL) DO
     BEGIN
          { haal de data op voor onderzoek }

          CASE EenRegelPtr^.Waar OF
               wMem :
                   Regel:=EenRegelPtr^.RegelPtr^;

               wSwapped :
                   BEGIN
                        BlockRead (SwapFile,RegelLen,1);
                        IF (RegelLen = 0) THEN
                        BEGIN
                             EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                             MsgsNewSeek (EenRegelPtr);
                             Continue;
                        END;

                        BlockRead (SwapFile,Regel[1],RegelLen);
                        Regel[0]:=Char (RegelLen);
                   END;
          END; { case }

          { dangerous: als twee regels aan elkaar geknoopt zaten }
          { (wat watergate nu nog niet doet), dan kan hier de    }
          { tweede en verdere regel verloren gaan.               }
          IF (Pos (#13,Regel) > 0) THEN
             Regel:=Copy (Regel,1,Pos (#13,Regel)-1);

          { onderzoek deze regel en kijk of het een mogelijke header is }

          { lege regel betekend het einde van de headers die we kopieren }
          IF (Regel = '') THEN
          BEGIN
               { eerste lege regel verwijderen we altijd }
               MsgsDeleteFirstRowFromBody;
               Exit;
          END;

          { een header moet uit minimaal twee tekens bestaan,   }
          { gevolgd door een dubbele punt, een spatie, minimaal }
          { een teken tekst en een enter. Dus 2+2+1+1 = 6.      }
          { Vergeet de enter even.                              }
          IF (Length (Regel) < 5) THEN
             Exit;

          { moet beginnen met een hoofdletter }
          IF NOT (Regel[1] IN ['A'..'Z']) THEN
             Exit;

          { kijk of de header afgesloten is met een ": " }
          P:=Pos (': ',Regel);

          { header moet minimaal 2 letters lang zijn, dus de : }
          { kan niet vOOr de derde positie beginnen.           }
          IF (P < 3) THEN
             Exit;

          { en als die ": " er staat, dan mag er geen spatie }
          { vOOr die dubbele punt voorkomen.                 }
          IF (Pos (' ',Regel) < P) THEN
             Exit;

          { RWI 951117: haal extra spaties achter de dubbele punt weg }
          WHILE (Pos (':  ',Regel) > 0) DO
                Delete (Regel,Pos (':  ',Regel)+1,1);

          { sommige systeem headers staan we niet toe }
          UpRegel:=UpCaseString (Copy (Regel,1,Pos (': ',Regel)-1));

          IF (UpRegel = 'MESSAGE-ID') OR
             (UpRegel = 'FROM') OR
             (UpRegel = 'TO') OR
            {(UpRegel = 'NEWSGROUPS') OR    RWI 960310: now allowed }
             (UpRegel = 'PATH') OR
            {(UpRegel = 'SUBJECT') OR       RWI 960310: now allowed }
             (UpRegel = 'DATE') THEN
          BEGIN
               { deze header niet toestaan. Eventueel loggen }
               { maar wel gewoon doorgaan met andere headers }
               IF Config.LogIllegalHeaders THEN
                  LogMessage ('Not copying system header: "'+Regel+'"');
          END ELSE
          BEGIN
               { legale header gevonden. Overnemen die hap en daarna }
               { verwijderen uit de body.                            }
               IF (UpRegel = 'ORGANIZATION') THEN
               BEGIN
                    Msg.Organization_U:=Regel;
                    GOTO Done;
               END;

               IF (UpRegel = 'SUBJECT') THEN
               BEGIN
                    Msg.Subj_U:=Regel;
                    GOTO Done;
               END;

               IF (UpRegel = 'NEWSGROUPS') THEN
               BEGIN
                    Msg.Newsgroups_U:=Regel;
                    GOTO Done;
               END;

               MsgsAddLineTo (Header_U,Regel);

         Done:
               IF Config.LogCopyHeaders THEN
                  LogMessage ('Copying header: "'+Regel+'"');
          END;

          { verwijder deze regel }
          MsgsDeleteFirstRowFromBody;

          { pak opnieuw de eerste regel }
          EenRegelPtr:=Msg.BodyTop^.FirstRegelRecordPtr;
          MsgsNewSeek (EenRegelPtr);
     END; { while }
     {$ENDIF}
END;


{--------------------------------------------------------------------------}
{ WashFidoName                                                             }
{                                                                          }
{ Deze routine loop een naam af op underscores en vervangt deze door       }
{ spaties, om tegelijkertijd de letters volgend op de spaties te vervangen }
{ door hoofdletters.                                                       }
{                                                                          }
{ martijn_dijksterhuis ---> Martijn Dijksterhuis                           }
{                                                                          }
{ RWI 281094: Tegenwoordig hebben een variabel vertaalteken, maar die werd }
{             hier nog niet gebruikt. Hier werd nog van de underscore uit- }
{             gegaan, tewijl dat tegenwoordig ook een minteken of punt kan }
{             zijn. Verbeterd.                                             }
{                                                                          }
{ RWI 950910: Als er een < aan het begin van de naam staat, dan wordt die  }
{             nu verwijderd. Dit komt eigenlijk omdat Usenet2FidoUserName  }
{             de constructie "From: <ramon@wsd.wline.se>" niet goed aan    }
{             kan en "<ramon" als full name eruit haalt. Dat lossen we     }
{             hier dus maar op (vies he?).                                 }
{                                                                          }
FUNCTION WashFidoName (Invoer : STRING) : STRING;

VAR Lp,A : BYTE;

BEGIN
     { RWI 950910 }
     IF (Invoer[1] = '<') THEN
        Delete (Invoer,1,1);

     { RAWI 970619 }
     IF (Invoer[1] = '"') THEN
        Delete (Invoer,1,1);

     REPEAT
           A:=Pos (Config.NameSeparator,Invoer);

           IF (A > 0) THEN
              Invoer[A]:=' ';

     UNTIL (A = 0);

     WashFidoName:=Invoer; { tussen resultaat }

     { alle alle letters volgend op een spatie nu klein zijn, zet ze dan }
     { dan allemaal om in een hoofdletter. Al gecapitaliseerde namen     }
     { blijven dus in tact (Ramon van der Winkel)                        }

     { bevat de naam een hoofdletter? }
     FOR Lp:=1 TO Length (Invoer)-1 DO
         IF (Invoer[Lp] IN ['A'..'Z']) THEN
            Exit;

     { alles lowercase, dan letters na een spatie omzetten in hoofdletter }
     FOR Lp:=1 TO Length (Invoer) DO
         IF (Invoer[Lp] = ' ') THEN
            Invoer[Lp+1]:=UpCase (Invoer[Lp+1]);

     { begin letter ook }
     Invoer[1]:=UpCase (Invoer[1]);

     WashFidoName:=Invoer;
END;


{--------------------------------------------------------------------------}
{ Usenet2FidoUserName                                                      }
{                                                                          }
{ Deze routine haalt uit de From: kludge van een Usenet bericht de user    }
{ naam en geeft deze terug. Er zijn twee mogelijkheden:                    }
{                                                                          }
{ From: ramon@wlink.nl (Ramon van der Winkel)    --> Ramon van der Winkel  }
{ From: <ramon@wsd.wlink.nl> (Ramon vd Winkel)   --> Ramon vd Winkel       }
{ From: <Martijn Dijksterhuis> martijn@wlink.nl  --> Martijn Dijksterhuis  }
{ From: A B (123) C D (456) <ramon@wsd>          --> A B                   }
{ From: martijn_dijksterhuis@wlink.nl            --> Martijn Dijksterhuis  }
{ From: "Ramon van der Winkel (ECS)" <ramon@..>  --> Ramon van der Winkel  }
{ From: "User.Name@domain"@other.domain          --> User Name
{                                                                          }
{ Nog op te lossen: Door de vertaling van de ' en ` naar " wordt er soms   }
{                   verkeerd vertaald waardoor de tekst What's in a name   }
{                   in de From: regel komt te staan als What"s in a name.  }
{                                                                          }
FUNCTION Usenet2FidoUserName (LenName : Integer; VAR Invoer : UseNetUserNameString) : STRING;

VAR P    : BYTE;
    Name : STRING;

    PROCEDURE CleanName;
    BEGIN
         { vertaling ' en ` naar " zodat we algemene routine kunnen houden }
         { RWI 960113 niet meer nodig...
         WHILE (Pos ('''',Name) > 0) DO
               Name[Pos ('''',Name)]:='"';

         WHILE (Pos ('`',Name) > 0) DO
               Name[Pos ('`',Name)]:='"';
         }

         { vieze quotes om de naam vandaan halen }
         IF (Name[1] IN ['"','''','`']) AND
            (Name[Length (Name)] IN ['"','''','`']) THEN
         BEGIN
              Delete (Name,1,1);
              Delete (Name,Length (Name),1);
         END;

         {RAWI981212: check for MIME encoded name }
         IF (Copy (Name,1,2) = '=?') THEN
            Name:=MimeHeaderToFTN (Name); { does further checks as well }

         { RvdW 16-05-93: job omschrijving weghalen, achter een - teken }
         IF (Pos ('-',Name) > 0) THEN
            Name:=Copy (Name,1,Pos ('-',Name)-1);

         IF (Pos ('(',Name) > 0) THEN
            Name:=Copy (Name,1,Pos ('(',Name)-1);

         IF (Pos (',',Name) > 0) THEN
            Name:=Copy (Name,1,Pos (',',Name)-1);

         { bijnamen die tussen " en " staan weghalen }
         IF (Pos ('"',Name) > 0) AND
            (Pos ('"',Copy (Name,Pos ('"',Name)+1,255)) > 0)
         THEN
             Name:=Copy (Name,1,Pos ('"',Name)-1)+
                   Copy (Name,Pos ('"',Name)+Pos ('"',Copy (Name,Pos ('"',Name)+1,255))+1,255);

         { dubbele spaties verwijderen, komen voor na verwijderen "tekst" }
         WHILE (Pos ('  ',Name) > 0) DO
               Delete (Name,Pos ('  ',Name),1);

         { "Ramon van der Winkel (ECS)" <ramon@...> wordt door de haakjes  }
         { omgezet in "Ramon van der Winkel en dat is natuurlijk niet mooi }
         { net als de parsing van de haakjes niet mooi is.. Weg met die "  }

         { enkele aanhalingsteken aan het begin verwijderen }
         IF (Name[1] = '"') AND (Pos ('"',Copy (Name,2,255)) = 0) THEN
            Delete (Name,1,1);

         Name:=DeleteFrontAndBackSpaces (Name); { nodig om lege namen te detecteren }
    END;

{ Usenet2FidoUserName }
BEGIN
     { Naam zit tussen ( ) ? }
     IF (Pos ('(',Invoer) > 0) THEN
     BEGIN
          P:=Pos ('(',Invoer)+1;

          IF (Pos ('<',Invoer) > P) THEN
          BEGIN
               { situatie From: A B (123) C D (456) <ramon@wsd> }
               Name:=Copy (Invoer,1,P-1);
               Delete (Name,1,LenName);  { RWI 960212: toegevoegd. "From:" bleef staan }
               Name:=DeleteFrontAndBackSpaces (Name);
          END ELSE
              { normal }
              Name:=Copy (Invoer,P,Pos (')',Invoer)-P);

          CleanName;
          IF (Name <> '') THEN  { RWI 281094: voorkoming haakjes met niets ertussen }
          BEGIN
               Usenet2FidoUserName:=Name;
               Exit;
          END;
     END;

     { Als er < > haken in de tekst zitten, staat de }
     { naam direct achter de From: regel             }
     IF (Pos ('<',Invoer) > 0) THEN
     BEGIN
          P:=Pos (':',Invoer)+2;
          Name:=Copy (Invoer,P,Pos ('<',Invoer)-1-P);

          CleanName;
          IF (Name <> '') THEN { RWI 281094: voorkoming haakjes met niets ertussen }
          BEGIN
               Usenet2FidoUserName:=Name;
               Exit;
          END;
     END;

     IF (Pos ('@',Invoer) > 0) THEN
        Usenet2FidoUserName:=WashFidoName (DeleteFrontSpaces (Copy (Invoer,LenName+2,Pos ('@',Invoer)-(LenName+2))))
     ELSE
         { RWI 950202: in plaats van "Unknown" wordt nu gewoon het adres }
         {             genomen. Dit kan soms resulteren in dikke bang-   }
         {             paths, maar we zullen het eens testen.            }
        {Usenet2FidoUserName:='Unknown';}
         Usenet2FidoUserName:=Copy (Invoer,LenName+2,255); { geen translaties }
END;


{--------------------------------------------------------------------------}
{ DayOfWeek                                                                }
{                                                                          }
{ Deze routine bepaald de dag van de week in 0 voor maandag tot en met 6   }
{ voor zondag aan de hand van een dag nummer in de huidige maand.          }
{                                                                          }
{ RWI 950527: Overgenomen uit mijn verlof administratie programma, want    }
{             dit is zwaar klote werk!                                     }
{                                                                          }
FUNCTION DayOfWeek (Dag,Maand : BYTE; Jaar : WORD) : BYTE;

CONST DagenPerMaand : ARRAY[1..12] OF BYTE = (31,28,31,30,31,30,31,31,30,31,30,31);

VAR DagenSinds010180 : LONGINT;

BEGIN
     { normaal: 365 dagen/jaar. Schrikkel: 366 }
     DagenSinds010180:=0; { 1 jan 1980 was op een ... }

     WHILE (Maand > 1) DO
     BEGIN
          Dec (Maand);

          IF (Maand = 2) AND
             ((Jaar MOD 4) = 0) AND
             ( ((Jaar MOD 100) <> 0) OR ((Jaar MOD 400) = 0) )
          THEN
              Inc (DagenSinds010180);

          DagenSinds010180:=DagenSinds010180+DagenPerMaand[Maand];
     END;

     WHILE (Jaar > 1980) DO
     BEGIN
          Dec (Jaar);

          IF ((Jaar MOD 4) = 0) AND
              ( ((Jaar MOD 100) <> 0) OR ((Jaar MOD 400) = 0) )
          THEN
              Inc (DagenSinds010180);

          DagenSinds010180:=DagenSinds010180+365;
     END;

     DagenSinds010180:=DagenSinds010180+Dag;

     DayOfWeek:=(DagenSinds010180 MOD 7);
END;


{--------------------------------------------------------------------------}
{ Fido2UsenetDate                                                          }
{                                                                          }
{ Converteerd het Fido datum formaat naar een Usenet formaat               }
{ We houden het voorlopig simpel, verschil met TZ's rekenen we nog niet    }
{ mee.                                                                     }
{                                                                          }
{ Fido   : "01 Jan 86  02:34:56"                                           }
{ UseNet : "Fri, 19 Nov 93 04:38:38 GMT"                                   }
{                                                                          }
{ RWI 950527: Nu wordt ook de dag van de week toegevoegd. Dat zal wat      }
{             problemen oplossen met die stomme verwerk punten die tijd    }
{             over hebben en formaten staan te controleren!                }
{                                                                          }
{ RAWI 971206: Added support for "01 Jan 100  00:01:1".                    }
{                                                                          }
FUNCTION Fido2UsenetDate (WerkRegel : STRING) : STRING;

VAR Jaar     : WORD;
    Lp,
    Maand,
    Dag,
    Dow      : BYTE;
    MaandStr : STRING[3];
    Nop      : ValNop;

BEGIN
     Val (Copy (WerkRegel,1,2),Dag,Nop);
     IF (Nop <> 0) THEN
        LogMessage ('[Fido2UsenetDate] Error getting day from "'+WerkRegel+'"');

     MaandStr:=Copy (WerkRegel,4,3);

     IF (WerkRegel[10] = ' ') THEN
        Val (Copy (WerkRegel,8,2),Jaar,Nop)
     ELSE
         Val (Copy (WerkRegel,8,3),Jaar,Nop);   { "100" situation }

     IF (Nop <> 0) THEN
        LogMessage ('[Fido2UsenetDate] Error getting year from "'+WerkRegel+'"');

     Jaar:=Jaar+1900;              { 100 -> 2000 }
     IF (Jaar < 1980) THEN         { RWI 960105: was 80... }
        Jaar:=Jaar+100; { 2000+ }

     Maand:=0;
     MaandStr:=UpCaseString (MaandStr);
     FOR Lp:=1 TO 12 DO
         IF (MaandStr = UpCaseString (Month[Lp])) THEN
         BEGIN
              Maand:=Lp;
              Break;
         END;

     IF (Maand = 0) THEN
     BEGIN
          LogMessage ('[MonthString2Nr] Cannot handle "'+Copy (WerkRegel,4,3)+'", assuming Sunday');
          Dow:=0;
     END ELSE
     BEGIN
          Dow:=DayOfWeek (Dag,Maand,Jaar);
          { 0=Maandag ipv Zondag... aanpassen }
          Dow:=(Dow+1) MOD 7;
     END;

     { extract the time parts }
     IF (Pos ('  ',WerkRegel) > 0) THEN
        Delete (WerkRegel,1,Pos ('  ',WerkRegel)+1)
     ELSE BEGIN
          LogMessage ('[Ftn2RfcDate] No double space in "'+WerkRegel+'", taking 00:00:00');
          WerkRegel:='00:00:00'; { force correct time }
     END;

     WHILE (WerkRegel[Length (WerkRegel)] IN [' ',#0]) AND (Length (WerkRegel) > 0) DO
           Delete (WerkRegel,Length (WerkRegel),1);

     IF (Length (WerkRegel) < 8{hh:mm:s}) THEN
        WerkRegel:=WerkRegel+'0';

     { RWI 950528: Toevoeging dag van de week }
     Fido2UsenetDate:=Day[Dow]+', '+Byte2String (Dag)+' '+Month[Maand]+' '+Word2String (Jaar)+' '+
                      WerkRegel+' '+Config.TimeZone;
END;


{--------------------------------------------------------------------------}
{ Usenet2FidoDate                                                          }
{                                                                          }
{ Converteert de Usenet datum formaten naar het fido formaat.              }
{                                                                          }
{ UseNet : "Fri, 19 Nov 93 04:38:38 GMT"                                   }
{ Fido   : "01 Jan 86  02:34:56 "                                          }
{                                                                          }
FUNCTION Usenet2FidoDate (Oud : STRING) : FidoDateType;

VAR P     : BYTE;
    Datum : STRING[9];
    Tijd  : STRING[8];

BEGIN
     { RWI 950506: een bericht zonder datum kan voorkomen (ik had er zelf }
     {             een gemaakt ;-)                                        }
     IF (Oud = '') THEN
     BEGIN
          Usenet2FidoDate:=FidoCurrTime2Str;
          Exit;
     END;

     { Strip de kludge indicator uit OrgOud: "Date: ..." }
     Oud:=Copy (Oud,Pos (':',Oud)+2,Length (Oud));

     P:=Pos (',',Oud);
     IF (P > 0) THEN { Formaat 1: "Fri, 19 Mrt 93 16:14:55 GMT" }
        Delete (Oud,1,Pos (',',Oud));

     { eventuele voorloopspaties weghalen }
     WHILE (Oud[1] = ' ') DO
           Delete (Oud,1,1);

     { eventuele achtervoeg spaties weghalen }
     WHILE (Oud[Length (Oud)] = ' ') DO
           Delete (Oud,Length (Oud),1);

     { als het jaartal er in vier cijfers staat, dan naar twee omzetten }
     { zorg dat de software meer dan een eeuw mee kan }
     IF (Pos ('199',Oud) > 0) THEN
        Delete (Oud,Pos ('199',Oud),2); { 1993 -> 93 }

{## improve this shit}
     IF (Pos ('200',Oud) > 0) THEN
        Delete (Oud,Pos ('200',Oud),2); { 2000 -> 00 }

     IF (Pos ('201',Oud) > 0) THEN
        Delete (Oud,Pos ('201',Oud),2); { 2010 -> 10 }

     IF (Pos ('202',Oud) > 0) THEN
        Delete (Oud,Pos ('202',Oud),2); { 2020 -> 20 }

     IF (Pos ('203',Oud) > 0) THEN
        Delete (Oud,Pos ('203',Oud),2); { 2030 -> 30 }

     IF (Pos ('204',Oud) > 0) THEN
        Delete (Oud,Pos ('204',Oud),2); { 2040 -> 40 }

     { eventuele dubbele spatie tussen de datum en tijd weghalen }
     WHILE (Pos ('  ',Oud) > 0) DO
           Delete (Oud,Pos ('  ',Oud),1);

     { voorloop nul bij de uren invullen }
     IF (Oud[Pos (':',Oud)-2] = ' ') THEN
        Insert ('0',Oud,Pos (':',Oud)-1);

     { alle troep is er nu uit, nu kunnen we de rest overnemen }
     P:=Pos (':',Oud)-3;  { zoek het eind van de datum op }
     Datum:=Copy (Oud,1,P);
     Delete (Oud,1,P);

     IF (Pos (' ',Oud) > 0) THEN { "16:34:11 GMT" of "16:34:11 +0100" }
        Tijd:=Copy (Oud,1,Pos (' ',Oud)-1)
     ELSE
         Tijd:=Oud;

     { voorloop nul bij de dagen invullen }
     IF (Datum[2] = ' ') THEN
        Insert ('0',Datum,1);

     { voorloop nul bij de minuten invullen }
     IF (Tijd[Pos (':',Tijd)+2] = ':') THEN
        Insert ('0',Tijd,Pos (':',Tijd)+1);

     { voorloop nul bij de seconden invullen }
     IF (Tijd[Length (Tijd)-1] = ':') THEN
        Insert ('0',Tijd,Length (Tijd));

     IF (Length (Tijd) = 5) THEN { geen seconden deel }
        Tijd:=Tijd+':00';

     UseNet2FidoDate:=Datum+'  '+Tijd; { 19 tekens, zonder #0 afsluiter }
END;


{--------------------------------------------------------------------------}
{ Usenet2FidoSubj                                                          }
{                                                                          }
{ Deze routine vervormt het UseNet subject in een die in de Fido Subj line }
{ past.                                                                    }
{                                                                          }
FUNCTION Usenet2FidoSubj (UseNetSubj : STRING) : STRING;

VAR Subj : STRING;

BEGIN
     Subj:=Copy (UsenetSubj,Pos (':',UseNetSubj)+2,MaxLenSubj_F);

     { haal de oude subj. naam weg bij een verandering van subject }
     IF (Pos ('(Was',Subj) > 0) THEN
        Subj:=Copy (Subj,1,Pos ('(Was',Subj)-1);

     IF (Pos ('(was',Subj) > 0) THEN
        Subj:=Copy (Subj,1,Pos ('(was',Subj)-1);

     Usenet2FidoSubj:=Subj;
END;


{--------------------------------------------------------------------------}
{ FindAndCopyHeader                                                        }
{                                                                          }
{ Deze routine gaat in de header van het usenet bericht op zoek naar de    }
{ gevraagde kludge. Als die gevonden wordt, dan beland er een kopie op de  }
{ gewenste wijze in het fido bericht.                                      }
{ Dit is nu een aparte functie, omdat ie door zowel mail->netmail als      }
{ news->echomail gebruikt wordt.                                           }
{                                                                          }
{ TFirst is voor de controle of er wel een lege regel in de body zit       }
{ tussen de gekopieerde header lines en de eerst echt body regel.          }
{ Als ie TRUE is, dan hoeft er geen lege regel (meer) toegevoegd te worden }
{ aan de body, voordat de eerste header gekopieerd wordt.                  }
{                                                                          }
PROCEDURE FindAndCopyHeader (HeaderName : STRING; CopyHow : CopyHeaderHowType; VAR TFirst : BOOLEAN);

VAR RegelPtr    : EenRegelRecordPtr;
    RegelLength : BYTE;
    Regel       : STRING; { RWI 950506: zo lang mogelijk, want hier moet de hele header line in! }

BEGIN
     IF (Msg.HeaderTop_U = NIL) THEN
        Exit;

     IF (Msg.Ready_U = News) AND
        (Config.OrganizationInOrigin = 2{override copy header}) AND
        (HeaderName = 'ORGANIZATION: ')
     THEN
         Exit;

     RegelPtr:=Msg.HeaderTop_U^.FirstRegelRecordPtr;
     MsgsNewSeek (RegelPtr);

     WHILE (RegelPtr <> NIL) DO
     BEGIN
          CASE RegelPtr^.Waar OF
               wMem :
                   BEGIN
                        Regel:=RegelPtr^.RegelPtr^;
                        RegelPtr:=RegelPtr^.NextRegelRecordPtr;
                        MsgsNewSeek (RegelPtr);
                   END;

               wSwapped :
                   BEGIN
                        { lees de lengte van de regel in }
                        BlockRead (SwapFile,RegelLength,1);

                        { einde van het swapped blok? }
                        IF (RegelLength = 0) THEN
                        BEGIN
                             { ja, ga naar de volgende regel }
                             RegelPtr:=RegelPtr^.NextRegelRecordPtr;
                             MsgsNewSeek (RegelPtr);
                             Continue; { met de while }
                        END;

                        { lees de regel zelf in }
                        BlockRead (SwapFile,Regel[1],RegelLength);
                        Regel[0]:=Char (RegelLength);
                   END; { swap }
          END; { case }

          IF (UpCaseString (Copy (Regel,1,Length (HeaderName))) = HeaderName) THEN
          BEGIN
               IF (CopyHow = chKludge) THEN
                  Regel:=#1+Regel;

               { RWI 951117 corrigeer lelijke headers }
               { Subject:       dit is een subject }
               WHILE (Pos (':  ',Regel) > 0) DO
                     Delete (Regel,Pos (':  ',Regel)+1,1);

               { als er nog geen enter achter stond (bij een afgebroken }
               { header), voeg die dan toe.                             }
               IF (Regel[Length (Regel)] <> #13) THEN
                  Regel:=Regel+#13;

               { als de string te lang was om deze #13 toe te voegen, }
               { vervang dan gewoon het laatste teken van de regel.   }
               IF (Regel[Length (Regel)] <> #13) THEN
                  Regel[Length (Regel)]:=#13;

               IF (CopyHow = chKludge) THEN
                  MsgsAddLineToNoEOL (Header_F,Regel)
               ELSE BEGIN
                    { make sure that there is always an empty line before }
                    { the header starts.                                  }
                    IF (NOT TFirst) THEN
                    BEGIN
                         { of ie die header nou vindt of niet... }
                         MsgsAddFirstLineToNoEOL (Body,#13);
                         TFirst:=TRUE;
                    END;

                    { dit draait wel de volgorde om }
                    MsgsAddFirstLineToNoEOL (Body,Regel);
               END;
          END;
     END; { while }

     { niet gevonden. pech }
END;


{--------------------------------------------------------------------------}
{ FirstBodyLineIsEmpty                                                     }
{                                                                          }
FUNCTION FirstBodyLineIsEmpty : BOOLEAN;

VAR EenRegelPtr : EenRegelRecordPtr;
    Test        : CHAR;

BEGIN
     { als er nog geen body is, dan is ie empty }
     IF (Msg.BodyTop = NIL) THEN
     BEGIN
          FirstBodyLineIsEmpty:=TRUE;
          Exit;
     END;

     EenRegelPtr:=Msg.BodyTop^.FirstRegelRecordPtr;

     { als ie in het geheugen staat, dan is het simpel }
     IF (EenRegelPtr^.Waar = wMem) THEN
     BEGIN
          FirstBodyLineIsEmpty:=(EenRegelPtr^.RegelPtr^[1] = #13);
          Exit;
     END;

     { lees die regel uit de swapfile }
     MsgsNewSeek (EenRegelPtr);
     BlockRead (SwapFile,Test,1);

     FirstBodyLineIsEmpty:=(Test = #13);
END;


{--------------------------------------------------------------------------}
{ AddReplyAlsoKludges                                                      }
{                                                                          }
{ Deze routine checkt de mail/news header voor andere reply adressen die   }
{ niet overeen komen met die al in REPLYADDR zit en voegt daarvoor de      }
{ REPLYALSO kludges toe.                                                   }
{                                                                          }
PROCEDURE AddReplyAlsoKludges (ReplyAddr : STRING);

VAR Done1,
    Done2,
    Tmp   : STRING;

BEGIN
     Done1:='';
     Done2:='';

     IF (Msg.ReplyTo_U <> '') THEN
     BEGIN
          Tmp:=UseGetAddress (Copy (Msg.ReplyTo_U,Length ('Reply-To: ')+1,255));
          IF (Tmp <> ReplyAddr) THEN
          BEGIN
               MsgsAddLineTo (Header_F,#1+'REPLYALSO '+Tmp);
               Done1:=Tmp;
          END;
     END;

     IF (Msg.Sender_U <> '') THEN
     BEGIN
          Tmp:=UseGetAddress (Copy (Msg.Sender_U,Length ('Sender: ')+1,255));
          IF (Tmp <> ReplyAddr) AND (Tmp <> Done1) THEN
          BEGIN
               MsgsAddLineTo (Header_F,#1+'REPLYALSO '+Tmp);
               Done2:=Tmp;
          END;
     END;

     IF (Msg.FromUser_U <> '') THEN
     BEGIN
          Tmp:=UseGetAddress (Copy (Msg.FromUser_U,Length ('From: ')+1,255));
          IF (Tmp <> ReplyAddr) AND (Tmp <> Done1) AND (Tmp <> Done2) THEN
             MsgsAddLineTo (Header_F,#1+'REPLYALSO '+Tmp);
     END;
END;


{--------------------------------------------------------------------------}
{ TranslateNews2Echomail                                                   }
{                                                                          }
{ Haalt de informatie voor het bericht uit de usenet informatie, en bouw   }
{ de fido info daarmee. Bij aanroep moet AreaData de gegevens van deze de  }
{ area waarin de msg gepost wordt bevatten.                                }
{                                                                          }
{ RvdW 16-05-93: Header_F en Footer_F worden nu weggegooid bij iedere      }
{                aanroep naar deze routine, want bij x-posts werden deze   }
{                op een gegeven moment zelfs in 7-voud opgenomen in de msg }
{                en kon de hele body er niet meer bij ivm een MaxMsgLen    }
{                van 5000... Resulteerde in een oneindige lus.             }
{                                                                          }
{ RWI 950527: Merk op dat de Usenet header gewoon in takt blijft. Bij een  }
{             tweede en verdere aanroep wordt de fido header weggegooid    }
{             en op nieuw opgebouwd uit de nog steeds bestaande usenet     }
{             header. Dit gebeurd bij cross-posts in Usenet.               }
{                                                                          }
{ RWI 960202: Vanaf nu wordt deze routine alleen nog maar aangeroepen voor }
{             de eerste vertaling van een news in echomail. Daarna wordt   }
{             Translate_PatchEchomail gebruikt om het bericht aan te       }
{             passen voor een andere area.                                 }
{                                                                          }
PROCEDURE TranslateNews2Echomail (CrossPosted : STRING);

VAR FromF,
    Tmp    : STRING;
    Lp     : BYTE;
    TFirst : BOOLEAN;
    MSend  : STRING;

BEGIN
     { ivm x-posts de eventuele vorige fido header en footer weggooien }
     MsgsReleaseLines (Msg.HeaderTop_F);
     MsgsReleaseLines (Msg.FooterTop_F);

     { loopt de hele Usenet Header af naar bepaalde regels }
     WITH Msg DO
     BEGIN
          { Voeg een unieke ^MSGID flag toe }
          { RWI 941126: Kan niet aan de hand van het Usenet MsgID, want  }
          {             bij cross-posts krijgen verschillende berichten  }
          {             dan hetzelfde MSGID, en daar gaan andere tossers }
          {             van flippen. Beproefd :-(... Dus unieke ID's in  }
          {             dat geval.                                       }
          { Toegevoegd: vergelijking op CrossPosted = ''                 }

          MsgsAddLineTo (Header_F,#1'MSGID: '+MessageID2MsgID ('M',Msg.MessageID_U,CrossPosted <> '',
                                                               AreaData.AreaName_F,AreaData.OriginAKA));

          { Optioneel een REPLY kludge }
          IF TestMessageID2MsgID (Msg.InReplyTo_U) THEN
             MsgsAddLineTo (Header_F,#1'REPLY: '+MessageID2MsgID ('I',Msg.InReplyTo_U,CrossPosted <> '',
                                                                  AreaData.AreaName_F,AreaData.OriginAKA))
          ELSE
              IF TestMessageID2MsgID (Msg.References_U) THEN
                 MsgsAddLineTo (Header_F,#1'REPLY: '+MessageID2MsgID ('R',Msg.References_U,CrossPosted <> '',
                                                                      AreaData.AreaName_F,AreaData.OriginAKA));


          (*
          IF (Msg.MsgID_U <> '') AND (CrossPosted = '') THEN

             MsgsAddLineTo (Header_F,#1+'MSGID: '+Fido2Str (Config.NodeNrs[AreaData.OriginAKA])+' '+
                                     Long2HexString (UpDateCRC32 ($FFFFFFFF,Msg.MSGID_U[1],Length (Msg.MsgID_U))))
          ELSE
              MsgsAddLineTo (Header_F,#1+'MSGID: '+Fido2Str (Config.NodeNrs[AreaData.OriginAKA])+' '+GetFidoPktName);

          { Kijk of we ook een unieke REPLY kludge kunnen toevoegen }
          IF (Msg.References_U <> '') THEN
             MsgsAddlineTo (Header_F,#1+'REPLY: '+Fido2Str (Config.NodeNrs[AreaData.OriginAKA])+' '+
                                     Long2HexString (UpDateCRC32 ($FFFFFFFF,Msg.References_U[1],Length (Msg.References_U))));
          *)

          { Uitbreiding 13/02/94 FTSC support nu optioneel }

          { RWI 960116: hier werd altijd de From: regel gebruikt, }
          {             maar dit zou natuurlijk in de volgende    }
          {             volgorde moeten:                          }
          {             Reply-To:, Sender:, From:.                }
          {             We laten het maar even zo en stoppen het  }
          {             "echte" of "juiste" reply adres maar in   }
          {             de REPLYALSO.                             }

          { RWI 960304: toch aangepast
          Tmp:=UseGetAddress (Copy (FromUser_U,Length ('FROM: ')+1,255));
          }

          { RWI 960314: was uninitialized! }
          Tmp:='';

          { RWI 960304: ondersteuning van geforceerd REPLYADDR bij MAP-AREA }
          IF (Msg.MapAreaReplyAddrPtr <> NIL) THEN
             Tmp:=MapAreaReplyAddrPtr^;

          IF (Tmp = '') THEN
             Tmp:=UsenetReplyadres;

          { RWI 950524: FSC35 en From: zijn nu apart te selecteren }
          { eigenlijk is FSC35 bullshit bij echomail, maar goed... }
          { Laat maar aanwezig ivm de ListServer (echo->netmail)   }
          IF (Config.ReplyFSC35) THEN
          BEGIN
               { ^Reply-To kludge   }
               { RWI 960118: dubbelepunt achter kludge naam verwijderd! }
               MsgsAddLineTo (Header_F,#1+'REPLYTO '+Fido2Str (Config.NodeNrs[AreaData.OriginAKA])+' '+Config.GatewayUser);

               { ^Reply-Addr Kludge }
               { RWI 960118: dubbelepunt achter kludge naam verwijderd! }
               MsgsAddLineTo (Header_F,#1+'REPLYADDR '+Tmp);

               { RWI 960118: added REPLYALSO kludge }
               { see if there is a Sender: or Reply-To: line that is  }
               { different from the above address and can be used for }
               { the REPLYALSO kludge.                                }
               AddReplyAlsoKludges (Tmp);
          END;

          MSend:='';

          { Full name }
          IF (Config.HeaderFullname) THEN
             FromUser_F:=Copy (Usenet2FidoUserName (Length ('FROM:'),FromUser_U),1,MaxLenFromUser_F-1)
          ELSE BEGIN
               { het e-mail adres moet in de fido From: regel }

               { RWI 960601: nu wordt de From: regel gebruikt
                             ipv het reply adres..
               FromUser_F:=Tmp;
               }

               { RWI 960714: netjes het e-mail adres eruit halen en dus }
               {             niet het e-mail adres _en_ (afgekapt!) de  }
               {             full-name erbij. Bah! Nu veel beter!       }

               FromF:=UseGetAddress (Copy (Msg.FromUser_U,6,255));

               IF (Length (FromF) >= MaxLenFromUser_F) THEN
               BEGIN
                    { dan moet ie ook nog eens duidelijk in de body }
                    { zodat we er handmatig op kunnen replyen }

                    { RWI 950527: dit werd eerst aan de body toegevoegd, }
                    {             maar dan komt het er bij crossposts    }
                    {             net zo vaak in!                        }
                    MSend:='Message sender: '+FromF;

                    { we houden er geen rekening mee hier dat het ook }
                    { nog eens geconfigureerd kan zijn om de From:    }
                    { header in de body te kopieren. In dat geval zal }
                    { ook niet nog eens geselecteerd zijn om het      }
                    { volledige adres in de From: regel te zetten...  }

                    { ff wat aanpassen zodat het duidelijk afgebroken is }
                    FromUser_F:=Copy (FromF,1,MaxLenFromUser_F-4)+'...';
               END ELSE
                   FromUser_F:=FromF;
          END;

          { Toevoegen van een ^PID lijn (!) }
          MsgsAddLineTo (Header_F,BuildPIDKludge);

          MsgsAddLineTo (Header_F,BuildCHRSKludge);

          { Als er meer areas in een string zitten een XPOST }
          { kludge meegeven...                               }
          IF (CrossPosted <> '') THEN
             MsgsAddLineTo (Header_F,#1'XPOST: '+CrossPosted);

          { RWI 950621: nu worden eerst alle kludge regel gekopieerd en }
          {             daarna pas de text regels.                      }
          TFirst:=TRUE;
          FOR Lp:=1 TO MaxCopyHeaders DO
              IF (Config.CopyHeaderHow[Lp] = chKludge) AND (Config.CopyHeaderNames[Lp] <> '') THEN
                 FindAndCopyHeader (UpCaseString (Config.CopyHeaderNames[Lp])+' ',chKludge,TFirst);

          { RAWI 980201: Add message sender _after_ all kludges }
          IF (MSend <> '') THEN
          BEGIN
               MsgsAddLineTo (Header_F,'');
               MsgsAddLineTo (Header_F,MSend);
               MsgsAddLineTo (Header_F,'');
          END;

          TFirst:=FirstBodyLineIsEmpty;
          FOR Lp:=1 TO MaxCopyHeaders DO
              IF (Config.CopyHeaderHow[Lp] = chText) AND (Config.CopyHeaderNames[Lp] <> '') THEN
                 FindAndCopyHeader (UpCaseString (Config.CopyHeaderNames[Lp])+' ',chText,TFirst);

          IF (FromUser_F = '') THEN
             FromUser_F:='Unknown';

          { TO }
          IF (Config.HeaderFullname) THEN
             ToUser_F:=Copy (Usenet2FidoUserName (Length ('TO:'),ToUser_U),1,MaxLenToUser_F-1)
          ELSE BEGIN
               { het e-mail adres moet in de fido To: regel }
               { RWI 960824: UseGetAddress ingevoegd }
               FromF{misbruik}:=UseGetAddress (Copy (ToUser_U,4,255));

               IF (Length (FromF) >= MaxLenToUser_F) THEN
                  { ff wat aanpassen zodat het duidelijk afgebroken is }
                  ToUser_F:=Copy (FromF,1,MaxLenToUser_F-3)+'...'
               ELSE
                   ToUser_F:=FromF;
          END;

          IF (ToUser_F = '') THEN
             ToUser_F:='All';

          { SUBJECT }
          Subj_F:=Copy (Usenet2FidoSubj (Msg.Subj_U),1,MaxLenSubj_F-1);

          { converteer de usenet datum naar de fido datum }
          Date_F:=Usenet2FidoDate (Date_U);

          FromAddr_F:=Config.NodeNrs[AreaData.OriginAKA];
          ToAddr_F:=FromAddr_F;
          Attr_F:=0;

          { Voeg Tearline + Origin lijn toe }
          { RWI 950218: #13+ weggehaald }
          MsgsAddlineTo (Footer_F,{#13+}FidoTear);

          TFirst:=TRUE; { need origin }
          IF (Config.OrganizationInOrigin <> 0{no}) THEN
          BEGIN
               Tmp:=DeleteFrontAndBackSpaces (Copy (Msg.Organization_U,15,255));
               IF (Tmp <> '') THEN
               BEGIN
                    Tmp:=GetLang1 (105,Tmp);
                    TFirst:=FALSE { have origin now }
               END;
          END;

          IF TFirst THEN
          BEGIN
               IF (AreaData.OriginNr = 0) THEN
                  Tmp:=AreaData.Origin
               ELSE
                   Tmp:=Config.Origins[AreaData.OriginNr];

               { RWI 960904: added check for empty system origin lines }
               IF (Tmp = '') THEN
                  Tmp:='Another WaterGate Site!';
          END;

          MsgsAddLineTo (Footer_F,FidoBuildOrigin (Tmp,Config.NodeNrs[AreaData.OriginAKA]));

          { RWI 950621: deze wordt nu als laatste actie, maar zeker weten }
          {             als eerste regel aan het bericht toegevoegd.      }
          { AREA - Moet vooraan, als eerste regel in de fido Header }
          Area_F:=AreaData.AreaName_F;
          MsgsAddFirstLineTo (Header_F,'AREA:'+Area_F);
     END; { with }

     { vertaal de body van MIME formaat naar FTN formaat }
     { maar behoudt nog wel de encoded files             }
     IF Msg.IsMime THEN
        MimeBodyToFtn;

     { klaar ! }
     Msg.Ready_F:=Echomail;
     Msg.Ready_U:=NotReady;

     { Omdat we nu nieuwe mailtjes exporteren moet hierover ook een }
     { CRC berekend worden.                                         }
     {DupeCheckAdd (FidoCRCMessage);}
END;


{--------------------------------------------------------------------------}
{ TransPatchEcho_CopyHeader                                                }
{                                                                          }
{ - Dump de AREA:                                                          }
{ - MSGID: vervangen                                                       }
{                                                                          }
PROCEDURE TransPatchEcho_CopyHeader (VAR Regel : STRING); FAR;
BEGIN
     IF (Copy (Regel,1,5) = 'AREA:') THEN
        Exit;

     IF (Copy (Regel,1,7) = #1'MSGID:') THEN
     BEGIN
          MsgsAddLineTo (Header_F,#1+'MSGID: '+Fido2Str (Config.NodeNrs[AreaData.OriginAKA])+' '+GetFidoPktName);
          Exit;
     END;

     MsgsAddLineToNoEOL (Header_F,Regel);
END;


{--------------------------------------------------------------------------}
{ TransPatchEcho_CopyFooter                                                }
{                                                                          }
{ - Replace Origin                                                         }
{ - Dump SEENBY                                                            }
{ - Dump PATH                                                              }
{                                                                          }
PROCEDURE TransPatchEcho_CopyFooter (VAR Regel : STRING); FAR;
BEGIN
     IF (Copy (Regel,1,7) = ' * Origin: ') THEN
     BEGIN
          IF (AreaData.OriginNr = 0) THEN
             MsgsAddlineTo (Footer_F,FidoBuildOrigin (AreaData.Origin,Config.NodeNrs[AreaData.OriginAKA]))
          ELSE
              MsgsAddlineTo (Footer_F,FidoBuildOrigin (Config.Origins[AreaData.OriginNr],Config.NodeNrs[AreaData.OriginAKA]));

          Exit;
     END;

     IF (Copy (Regel,1,8) = 'SEEN-BY:') THEN
        Exit;

     IF (Copy (Regel,1,6) = #1'PATH:') THEN
        Exit;

     MsgsAddLineToNoEOL (Footer_F,Regel);
END;


{--------------------------------------------------------------------------}
{ Translate_PatchEchomail                                                  }
{                                                                          }
{ Deze routine wordt door de news distributie routine gebruikt om een      }
{ naar echomail vertaald newsje aan te passen voor de area waarin deze     }
{ gedistribueerd moet worden. AreaData moet de nieuwe gegevens bevatten.   }
{ Hier worden de volgende aanpassingen aan de header en footer gemaakt:    }
{                                                                          }
{ - Nieuwe MSGID kludge                                                    }
{ - Nieuwe Origin line                                                     }
{ - Nieuwe AREA kludge                                                     }
{ - Nieuwe SEEN-BY kludge                                                  }
{ - Nieuwe PATH kludge                                                     }
{                                                                          }
PROCEDURE Translate_PatchEchomail;

VAR OldLines : TopRegelRecordPtr;

BEGIN
     OldLines:=Msg.HeaderTop_F;
     Msg.HeaderTop_F:=NIL;

     { voeg de AREA: kludge als eerste toe }
     MsgsAddLineTo (Header_F,'AREA:'+AreaData.AreaName_F);

     { check en kopieer de gewenste oude header lines }
     MsgsForEachKill (OldLines,TransPatchEcho_CopyHeader);

     Msg.FromAddr_F:=Config.NodeNrs[AreaData.OriginAKA];
     Msg.ToAddr_F:=Msg.FromAddr_F;
     Msg.Attr_F:=0;

     { nu de footer nog ----------- }

     OldLines:=Msg.FooterTop_F;
     Msg.FooterTop_F:=NIL;
     MsgsForEachKill (OldLines,TransPatchEcho_CopyFooter);
END;


{--------------------------------------------------------------------------}
{ TranslateMail2Netmail                                                    }
{                                                                          }
{ Verstouw een mailtje dusdanig dat het als een legitiem netmail bericht   }
{ zijn reis over de wereld kan voort zetten.                               }
{                                                                          }
FUNCTION TranslateMail2Netmail (FidoToAddr : FidoAddrType; ToUserUsenet : STRING) : BOOLEAN;

VAR MatchAddr    : FidoAddrType;
    Tmp          : STRING;
    SenderInBody : BOOLEAN;
    Lp           : BYTE;
    TFirst       : BOOLEAN;

BEGIN
     { Controleer eerst of het bericht wel verzonden kan worden }
     { Doe dit door HIER al te kijken of het bericht            }
     { a) Voor ons                                              }
     { b) Voor een van onze points                              }
     { c) Voor een routable node                                }
     { bestemd is.                                              }

     { Eerst MatchAdres, die is later nog nodig! }
     { RWI 960113: hoezo? een search for MatchAdres levert niets op! }
     IF (NOT FidoMapPoint (FidoToAddr,WashFidoName (ToUserUsenet))) THEN
        IF FidoOurAdres (FidoToAddr) THEN
           MatchAddr:=Config.NodeNrs[Config.GatewayAKA]
        ELSE
            IF (FindRoute (FidoToAddr,MatchAddr) = 0) THEN
            BEGIN
                 LogMessage ('Bouncing mail for '+Fido2Str (FidoToAddr));
                 UsenetBounceMail ('Reason: Unable to transport message to '+Fido2Str (FidoToAddr));
                 TranslateMail2Netmail:=FALSE;
                 Exit;
            END;

     LogMessage ('Translating Mail -> Netmail');

     { Stap 2                              }
     {                                     }
     { Vul de fidonet headers met gegevens }

     { Let op! Die fido header moet natuurlijk wel eerst leeg zijn..... }
     { Voor als maffe freako's binnen watergate gaan bouncen...         }
     MsgsReleaseLines (Msg.HeaderTop_F);
     MsgsReleaseLines (Msg.FooterTop_F);

     { RWI 950524: mail->netmail gelijk getrokken aan news->echomail }
     WITH Msg DO
     BEGIN
          { TO }
          IF (ToUserUsenet <> '') THEN
             ToUser_F:=Copy (WashFidoName (ToUserUsenet),1,MaxLenToUser_F-1)
          ELSE
              ToUser_F:=Copy (Usenet2FidoUserName (Length ('TO:'),ToUser_U),1,MaxLenToUser_F-1);

          { SUBJECT }
          Subj_F:=Copy (Usenet2FidoSubj (Subj_U),1,MaxLenSubj_F-1);

          { TIME }
          Date_F:=Usenet2FidoDate (Date_U);

          { Uitbreiding 13/02/94 FTSC support nu optioneel }

          { RWI 950524: FSC35 en From: zijn nu apart te selecteren }
          { RWI 960304: nu wordt het reply adres genomen!
          Tmp:=UseGetAddress (Copy (FromUser_U,Length ('FROM: ')+1,255));
          }
          Tmp:=UsenetReplyAdres;

          { LET OP: het invullen van FromUser_F moet vOOr de BuildNetmail! }

          { Full name }
          SenderInBody:=FALSE;
          IF (Config.HeaderFullname) THEN
             FromUser_F:=Copy (Usenet2FidoUserName (Length ('FROM:'),FromUser_U),1,MaxLenFromUser_F-1)
          ELSE BEGIN
               { het e-mail adres moet in de fido From: regel }
               FromUser_F:=Tmp;

               IF (Length (Tmp) >= MaxLenFromUser_F) THEN
               BEGIN
                    { ff wat aanpassen zodat het duidelijk afgebroken is }
                    FromUser_F:=Copy (FromUser_F,1,MaxLenFromUser_F-4)+'...';

                    SenderInBody:=TRUE; { volgt nog, na de BuildNetmail }
               END;
          END;

          IF (FromUser_F = '') THEN
             FromUser_F:='Unknown';

          { Creer een schoon netmail bericht }
          { Afzender is onze UUCP gateway!   }
          { Tear-line komt eronder erbij     }
          FidoBuildNetmail (FALSE,Config.NodeNrs[Config.GatewayAKA],FidoToAddr,FromUser_F,ToUser_F,Subj_F);

          { eerst alle kludges }

          { RWI 960404: Aanmaken van MSGID an REPLY kludges }
          MsgsAddLineTo (Header_F,#1+'MSGID: '+MessageID2MsgID ('M',Msg.MessageID_U,FALSE{not crossposted},
                                     ''{areaname},Config.GatewayAKA));

          IF TestMessageID2MsgID (Msg.InReplyTo_U) THEN
             MsgsAddLineTo (Header_F,#1+'REPLY: '+MessageID2MsgID ('I',Msg.InReplyTo_U,FALSE{not crossposted},
                                        ''{areaname},Config.GatewayAKA));

          { Vul de header aan met extra fancy fido kludges (ala fredmail) }
          { Dit werkt echt! Tof, TimEd reageerd erop...                   }
          IF (Config.ReplyFSC35) THEN
          BEGIN
               { ^Reply-To kludge }
               { RWI 950612: The node number used came from AreaData.OriginAKA }
               { RWI 960118: dubbelepunt achter kludge naam verwijderd! }
               MsgsAddLineTo (Header_F,#1+'REPLYTO '+Fido2Str (Config.NodeNrs[Config.GatewayAKA])+' '+Config.GatewayUser);

               { ^ReplyAddr Kludge }
               { RWI 960118: dubbelepunt achter kludge naam verwijderd }
               MsgsAddLineTo (Header_F,#1+'REPLYADDR '+Tmp);

               { RWI 960304: REPLYALSO kludges toegevoegd }
               AddReplyAlsoKludges (Tmp);
          END;

          { Toevoegen van een ^PID lijn (!) }
          MsgsAddLineTo (Header_F,BuildPIDKludge);

          MsgsAddLineTo (Header_F,BuildCHRSKludge);

          IF SenderInBody THEN
          BEGIN
               { dan moet ie ook nog eens duidelijk in de body }
               { zodat we er handmatig op kunnen replyen }
               MsgsAddFirstLineTo (Body,'');
               MsgsAddFirstLineTo (Body,'Message sender: '+Tmp);
               MsgsAddFirstLineTo (Body,'');

               { we houden er geen rekening mee hier dat het ook }
               { nog eens geconfigureerd kan zijn om de From:    }
               { header in de body te kopieren. In dat geval zal }
               { ook niet nog eens geselecteerd zijn om het      }
               { volledige adres in de From: regel te zetten...  }
          END;
     END; { with }

     { RAWI 970617: do MIME -> FTN translation first so single-part }
     {              encoding headers are copied before CopyHeaders  }
     {              adds more lines to the body (always at the top) }

     { Note: This might fail when we start to translate MIME headers }

     { vertaal de body van MIME formaat naar FTN formaat }
     { maar behoudt nog wel de encoded files             }
     IF Msg.IsMime THEN
        MimeBodyToFtn;

     { RWI 950621: nu worden eerst alle kludge regel gekopieerd en }
     {             daarna pas de text regels.                      }
     TFirst:=TRUE;
     FOR Lp:=1 TO MaxCopyHeaders DO
         IF (Config.CopyHeaderHow[Lp] = chKludge) AND (Config.CopyHeaderNames[Lp] <> '') THEN
            FindAndCopyHeader (UpCaseString (Config.CopyHeaderNames[Lp])+' ',Config.CopyHeaderHow[Lp],TFirst);

     TFirst:=FirstBodyLineIsEmpty;
     FOR Lp:=1 TO MaxCopyHeaders DO
         IF (Config.CopyHeaderHow[Lp] = chText) AND (Config.CopyHeaderNames[Lp] <> '') THEN
            FindAndCopyHeader (UpCaseString (Config.CopyHeaderNames[Lp])+' ',Config.CopyHeaderHow[Lp],TFirst);

     { oude mail header weggooien }
     MsgsReleaseLines (Msg.HeaderTop_U);

     { Klaar! }
     Msg.Ready_F:=Netmail;
     Msg.Ready_U:=NotReady;
     Msg.WasGated:=TRUE;

     {$IFDEF WtrTest}
     LogExtraMessage ('Netmail: From: "'+Msg.FromUser_F+'"%'+Fido2Str (Msg.FromAddr_F));
     LogExtraMessage ('           To: "'+Msg.ToUser_F+'"%'+Fido2Str (Msg.ToAddr_F));
     {$ENDIF}

     TranslateMail2Netmail:=TRUE;
END;


{---------------------------------------------------------------------------}
{ TransMailToNews_CopyHeader                                                }
{                                                                           }
PROCEDURE TransMailToNews_CopyHeader (VAR Regel : STRING); FAR;
BEGIN
     IF (Copy (Regel,1,12) = 'Newsgroups: ') THEN
        Exit;

     IF (Copy (Regel,1,5) = 'From ') THEN
        Exit;

     IF (Copy (Regel,1,6) = 'Path: ') THEN
        Exit;

     IF (Copy (Regel,1,7) = 'Lines: ') THEN
        Exit;

     IF (Regel = '') OR (Regel = #13) THEN
        Exit;

     MsgsAddLineToNoEOL (Header_U,Regel);
END;


{---------------------------------------------------------------------------}
{ TransMailToNews_CountBody                                                 }
{                                                                           }
PROCEDURE TransMailToNews_CountBody (VAR Regel : STRING); FAR;

VAR R : STRING;

BEGIN
     R:=Regel;

     WHILE (Pos (#13,R) > 0) DO
     BEGIN
          Inc (BodyLinesCount);
          Delete (R,1,Pos (#13,R));
     END;
END;


{--------------------------------------------------------------------------}
{ TranslateMail2News                                                       }
{                                                                          }
{ Deze routine zet een mailtje om in een newsje. Niet veel te doen         }
{ (eindelijk eens!) behalve het toevoegen van een Newsgroups: header met   }
{ de naam die nu in het AreaData record staat en daarna de Ready_U         }
{ veranderen. Oh ja, de From header moet er ook uit en een Lines header    }
{ erin.                                                                    }
{ Dit wordt gebruikt om e-mail naar een area te pompen.                    }
{                                                                          }
PROCEDURE TranslateMail2News;

VAR OldLines : TopRegelRecordPtr;

BEGIN
     LogMessage ('Translating Mail -> News');

     OldLines:=Msg.HeaderTop_U;
     Msg.HeaderTop_U:=NIL;

     MsgsForEach (OldLines,TransMailToNews_CopyHeader);

     MsgsReleaseLines (OldLines);

     { tel het aantal regels in de body }
     BodyLinesCount:=0;
     MsgsForEach (Msg.BodyTop,TransMailToNews_CountBody);

     Msg.NewsGroups_U:='Newsgroups: '+LoCaseString (AreaData.AreaName_U)+#13;
     MsgsAddFirstLineToNoEOL (Header_U,Msg.NewsGroups_U);

     MsgsAddFirstLineTo (Header_U,'Path: '+UseGetSystemFromName);
     MsgsAddLineTo (Header_U,'Lines: '+Longint2String (BodyLinesCount));
     MsgsAddLineTo (Header_U,'');

     Msg.Ready_U:=News;
END;


{===========================================================================}
{                         FIDO -> USENET                                    }
{===========================================================================}

(*
{--------------------------------------------------------------------------}
{ CleanupFidoBody                                                          }
{                                                                          }
{ Deze routine loopt alle regels in de body van een bericht af, en conver- }
{ teerd alle 8-bits tekens naar 7-bits tekens.                             }
{ De functie geeft het aantal verwerkte regels terug.                      }
{                                                                          }
FUNCTION CleanUpFidoBody : WORD;

VAR Rijen       : WORD;
    Lp          : BYTE;
    EenRegelPtr : EenRegelRecordPtr;
    RegelLength : BYTE;
    Regel       : STRING;
    Changed     : BOOLEAN;
    SwapPos     : LONGINT;
    Teken       : BYTE;

BEGIN
     Rijen:=0;

     IF (Msg.BodyTop = NIL) THEN
        EenRegelPtr:=NIL
     ELSE
         EenRegelPtr:=Msg.BodyTop^.FirstRegelRecordPtr;

     MsgsNewSeek (EenRegelPtr);

     WHILE (EenRegelPtr <> NIL) DO
     BEGIN
          CASE EenRegelPtr^.Waar OF
               wMem :
                   WITH EenRegelPtr^ DO
                   BEGIN
                        FOR Lp:=1 TO Length (RegelPtr^) DO
                        BEGIN
                             Teken:=Byte (RegelPtr^[Lp]);

                             IF (Teken >= 128) THEN
                             BEGIN
                                  { van FTN set naar interne set }


                                  { nu in interne formaat }
                             END;

                            {IF (RegelPtr^[Lp] >= #128) THEN
                                RegelPtr^[Lp]:=Config.ConversionTabel[Ord (RegelPtr^[Lp])];}
                        END;

                        Inc (Rijen);
                        EenRegelPtr:=NextRegelRecordPtr;
                        MsgsNewSeek (EenRegelPtr);
                   END;

               wSwapped :
                   BEGIN
                        BlockRead (SwapFile,RegelLength,1);

                        IF (RegelLength = 0) THEN
                        BEGIN
                             { einde van het swapped blok }
                             EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                             MsgsNewSeek (EenRegelPtr);
                             Continue;
                        END;

                        { bewaar de positie voor als we weer moeten schrijven }
                        SwapPos:=FilePos (SwapFile);

                        { lees de regel zelf in }
                        BlockRead (SwapFile,Regel[1],RegelLength);

                        Changed:=FALSE;
                        FOR Lp:=1 TO RegelLength DO
                            IF (Regel[Lp] > #127) THEN
                            BEGIN
                                 Regel[Lp]:=Config.ConversionTabel[Ord (Regel[Lp])];
                                 Changed:=TRUE;
                            END;

                        IF Changed THEN
                        BEGIN
                             Seek (SwapFile,SwapPos);
                             BlockWrite (SwapFile,Regel[1],RegelLength);
                        END;

                        Inc (Rijen);
                   END; { wSwapped }
          END; { case }
     END; { while }

     CleanupFidoBody:=Rijen;
END;
*)

{--------------------------------------------------------------------------}
{ BuildFidonetInternetAdres                                                }
{                                                                          }
{ Maakt een internet adres van een gegeven fido adres.                     }
{ 2:512/17.6 ->  p6.f17.n512.z2                                            }
{                                                                          }
{ RWI 960512: "p0" wordt nu toegevoegd als de gateway aka een point bevat. }
{                                                                          }
FUNCTION BuildFidonetInternetAdres (Source : FidoAddrType; AddPunt : STRING) : STRING;

VAR Adres : STRING;

BEGIN
     Adres:='';

     IF (NOT Config.PackedAddresses) THEN
     BEGIN
          WITH Source DO
          BEGIN
               { RWI 960512: gateway aka controle op point toegevoegd }
               IF (Point <> 0) OR (Config.NodeNrs[Config.GatewayAKA].Point <> 0) THEN
                  Adres:='p'+Word2String (Point)+'.';

               Adres:=Adres+'f'+Word2String (Node)+
                           '.n'+Word2String (Net)+
                           '.z'+Word2String (Zone);
          END;
     END ELSE
         WITH Source DO
         BEGIN
              { RWI 960331: nu in p.f.n.z formaat ipv z.n.f.p formaat! }
              { RWi 970126: weer veranderd om p.f.n.z te krijgen.. }

              Adres:='';

              IF (Zone <> Config.NodeNrs[Config.GatewayAKA].Zone) THEN
                 Adres:='.z'+Word2String (Zone)+Adres;

              IF (Net <> Config.NodeNrs[Config.GatewayAKA].Net) THEN
                 Adres:='.n'+Word2String (Net)+Adres;

              IF (Node <> Config.NodeNrs[Config.GatewayAKA].Node) THEN
                 Adres:='.f'+Word2String (Node)+Adres;

              { het maakt niet uit of de gateway nu wel of niet een     }
              { point nummer heeft. Deze moet altijd in het adres omdat }
              { bij de terugvertaling het gateway aka point nummer op   }
              { nul wordt geforceerd.                                   }

              { RWI 960512: gateway aka controle op point toegevoegd }
              IF (Point <> 0) OR (Config.NodeNrs[Config.GatewayAKA].Point <> 0) THEN
                 Adres:='.p'+Word2String (Point)+Adres;

              Delete (Adres,1,1); { verwijder de voorste punt }

         END; { with }

     { merk op dat dit adres leeg kan zijn als SmallAddresses aan staat }
     { en het adres in de mapping hetzelfde is als een van onze systeem }
     { AKA's.                                                           }

     { RWI 950312: hier is de fix }
     IF (Adres <> '') THEN
        { RWI 950316: AddPunt stond ervoor... :-((( }
        Adres:=Adres+AddPunt; { niet als ie leeg is }

     BuildFidonetInternetAdres:=Adres;
END;


{--------------------------------------------------------------------------}
{ CleanFidoName                                                            }
{                                                                          }
{ Deze routine veranderd spaties in de naam naar underscores, en           }
{ verwijdert illegale highascii uit de naam. Dit kan problemen bij het     }
{ terugzetten van de originele naam geven, maar dat probleem is voor de    }
{ *(&(*& *( Fido programma's die dit soort dingen toestaan.                }
{                                                                          }
FUNCTION CleanFidoName (Invoer : STRING; DoUnderScore : BOOLEAN) : STRING;

VAR Teller : BYTE;

BEGIN
    Invoer:=DeleteBackSpaces (Invoer);

    FOR Teller:=1 TO Length (Invoer) DO
    BEGIN
         CASE Invoer[Teller] OF
              { vervang spaties door underscores }
              ' ' :
                  IF DoUnderScore THEN
                     Invoer[Teller]:=Config.NameSeparator;

              { Verwijder grappen als 'Tom Jones (Weird Tom)' }
              { Uit de fido naam string.                      }
              '(' :
                  BEGIN
                       Delete (Invoer,Teller,255);
                       Break;
                  END;

              { Verwijder alle High Ascii uit de regel }
              #127..#255 :
                  Invoer[Teller]:=CnstTekens[Ord (Invoer[Teller])];
         END; { case }
    END; { for }

    CleanFidoName:=Invoer;
END;


{--------------------------------------------------------------------------}
{ CleanSubject                                                             }
{                                                                          }
{ Verwijderd alle Hi-Ascii rommel uit een regel.                           }
{                                                                          }
FUNCTION CleanSubject (Invoer : STRING) : STRING;

VAR Teller : BYTE;

BEGIN
     DeleteBackSpaces (Invoer);

     FOR Teller:=1 TO Length (Invoer) DO
         IF (Invoer[Teller] >= #128) THEN
            Invoer[Teller]:=CnstTekens[Ord (Invoer[Teller])];

     CleanSubject:=Invoer;
END;


{---------------------------------------------------------------------------}
{ TranslateFromAddressFU                                                    }
{                                                                           }
{ Deze routine doet de vertaling van het From address voor Fido naar Usenet }
{ en wordt gebruikt bij de vertaling van Netmail naar Mail, maar ook voor   }
{ Echomail naar News.                                                       }
{                                                                           }
{ Wat er gebruikt wordt:                                                    }
{                                                                           }
{ Msg.FromAddr_F: De AKA van de zender van het bericht.                     }
{ Msg.FromUser_F: De full name van de zender van het bericht                }
{                                                                           }
{ Wat er terug gegeven wordt:                                               }
{                                                                           }
{ Organization: voor in de Organization: header line. Kan de system regel   }
{               of de user-defined regel zijn.                              }
{                                                                           }
{ BangFrom: Het hele adres in bangpath vorm. Dit moet als laatste deel van  }
{           het bang path gebruikt worden. Ons systeem domain adres zit er  }
{           al bij in.                                                      }
{                                                                           }
{ MailFromAdres: Het complete e-mail adres met een @ erin, na de vertaling. }
{                                                                           }
{ RWI 960313: points van een in de userbase gedefinieerde node worden nu    }
{             automatisch op het daar gedefinieerde domain adres gemapped.  }
{                                                                           }
{ RWI 960313: points van ons systeem worden nu op ons eerste systeem        }
{             domain adres gedefinieerd.                                    }
{                                                                           }
PROCEDURE TranslateFromAddressFU (VAR Organization,BangFrom,MailFromAdres : STRING);

VAR KnownUser       : BOOLEAN;
    UserRecNr       : UserBaseRecordNrType;
    UserRec         : UserBaseRecord;
    HulpAddr        : FidoAddrType;
    BangFromUser    : STRING;
    BangFromDomain  : STRING;
    CleanedFidoName : STRING;

BEGIN
     Organization:='';
     BangFromUser:='';   { nog geen naam voor in het bang path }
     BangFromDomain:=''; { nog geen domain voor in het bang path }

     { RWI 960113: opzoeken van bekende users naar boven gehaald zodat }
     {             de organization line gebruikt kan worden, zelfs als }
     {             er een MAP-UUCP statement gedefinieerd is.          }
     KnownUser:=FindUserBaseRecordByFidoAddress (Msg.FromAddr_F,UserRecNr);

     { RWI 960313: point worden nu bij hun node gemapped }
     IF (NOT KnownUser) AND (Msg.FromAddr_F.Point <> 0) THEN
     BEGIN
          HulpAddr:=Msg.FromAddr_F;
          HulpAddr.Point:=0;  { find the node }
          KnownUser:=FindUserBaseRecordByFidoAddress (HulpAddr,UserRecNr);
     END;

     IF KnownUser THEN
        ReadUserBaseRecord (UserRecNr,UserRec);

     { Kijk of er een override gedefinieerd is }
     IF (NOT GetFIDO_2_UUCP (MailFromAdres)) THEN
     BEGIN
          { RWI 950605: dit stuk overnieuw gedaan. De oude code ging er }
          {             vanuit dat er niet zoiets als "small addresses" }
          {             bestaat en hield daarom rekening met points.    }
          {             Dit doen we nu niet meer, dus zijn de volgende  }
          {             situaties overgebleven:                         }
          {                                                             }
          { 1) We zijn het zelf, geen subsysteem van ons.               }
          {                                                             }
          { 2) User is niet bekend.                                     }
          {    User is wel bekend, maar record heeft geen domain adres. }
          {                                                             }
          { 3) User is bekend en heeft een domain adres in zijn record. }
          {                                                             }
          { Situatie 1): Neem ons eerste systeem domain adres. Deze     }
          {              hoeft niet in het bang path komen te staan.    }
          {                                                             }
          { Situatie 2): Volledig of gedeeltelijk (small addresses) AKA }
          {              in het adres stoppen en ons eerste systeem     }
          {              domain adres toevoegen. Het eerste deel moet   }
          {              in het bangpath komen te staan.                }
          {                                                             }
          { Situatie 3): Het domain adres uit het record nemen. Deze    }
          {              moet ook in het bang path komen te staan.      }

          { Situatie 1 }
          IF FidoOurAdres (Msg.FromAddr_F) THEN
          BEGIN
               { van ons eigen adres -> neem ons eigen domain }

               MailFromAdres:=Config.Domains[1];

               { BangFromDomain blijft leeg, want adres komt ons adres }
               { twee keer in het bang path. Nou ja, oke, er is een    }
               { controle. Dit helpt en versnelt.                      }

               IF FidoOurPoint (Msg.FromAddr_F) THEN
               BEGIN
                    { we gaan er maar even van uit dat het adres al  }
                    { omgezet is naar een niet-3D adres, want dit    }
                    { gaat nu mis bij post van eens van onze systeem }
                    { AKA's zelf..                                   }
                    { Eigenlijk moeten die 3D addressen toch niet in }
                    { een netmail...                                 }
                    (*
                    IF (Msg.FromAddr_F.Point = 0) THEN
                       { 3D point }
                       MailFromAdres:='p'+Word2String (Msg.FromAddr_F.Node)+'.'+MailFromAdres
                    ELSE
                    *)

                    IF (Msg.FromAddr_F.Point <> 0) THEN
                    BEGIN
                         { 4D point }
                         MailFromAdres:='p'+Word2String (Msg.FromAddr_F.Point)+'.'+MailFromAdres;
                    END;

                    { nu moet dit domain adres WEL in het bang!path }
                    BangFromDomain:=MailFromAdres;
               END;

          END ELSE
          BEGIN
               { Situatie 2/3 }

               { check if this AKA is defined in our Userbase. If so, we    }
               { might be able to get some personal translation information }
               { from that record.                                          }
               { RWI 960113: hierboven al gedaan...
               KnownUser:=FindUserBaseRecordByFidoAddress (Msg.FromAddr_F,UserRecNr);
               IF KnownUser THEN
                  ReadUserBaseRecord (UserRecNr,UserRec);
               }

               { Situatie 3 }
               IF KnownUser AND (UserRec.Domains[1] <> '') THEN
               BEGIN
                    { dit adres staat in onze userbase en daar staat ook }
                    { een domain adres dat gebruikt moet worden. Dit     }
                    { domain adres moet ook in het bang path, tenzij het }
                    { ons systeem domain adres is (some people...).      }

                    MailFromAdres:=UserRec.Domains[1];

                    { RWI 960313: Als dit een point van deze node is, dan }
                    { moeten we het point adres even toevoegen. Wel even  }
                    { controleren of deze user zelf geen point is, want   }
                    { anders plakken we altijd de p#. eraan...            }
                    IF (Msg.FromAddr_F.Point <> 0) AND (UserRec.Address.Point = 0) THEN
                       MailFromAdres:='p'+Word2String (Msg.FromAddr_F.Point)+'.'+MailFromAdres;

                    BangFromDomain:=MailFromAdres;

                    { we kunnen de custom origanization line uit het user }
                    { record gebruiken, of die nou leeg is of niet.       }

                    { RWI 950627: UserRec was UserData. Veroorzaakte }
                    {             verkeerde organization lines...    }
                    Organization:=UserRec.Organization;
               END ELSE
               { Situatie 2 }
               BEGIN
                    { we kennen de node niet of het is een user van ons }
                    { zonder domain adres in het record. Nu moeten we   }
                    { zelf wat verzinnen en het hele of gedeeltelijke   }
                    { AKA moet in het adres, zodat erop gereageerd kan  }
                    { worden. Dit moet ook in het bang path.            }

                    MailFromAdres:=BuildFidonetInternetAdres (Msg.FromAddr_F,'.')+Config.Domains[1];
                    BangFromDomain:=MailFromAdres;
               END;
          END; { situatie 2/3 }

          (* oude code...
          { Kijk of we het zelf zijn ! }
          IF FidoOurAdres (Msg.FromAddr_F) THEN
          BEGIN
               MailFromAdres:=Config.Domains[1];
               { RWI 950317: geen BangFromDomain nodig! }
               LogExtraMessage ('Message from our system to '+MailToAdres);
          END ELSE
              { het is niet van onszelf }

              { als we de node niet kennen, of als we hem/haar wel kennen }
              { maar het is een node (geen point) en het domain adres is  }
              { niet ingevuld.                                            }

              IF (NOT NodeKnownToUs) OR
                 (NodeKnownToUs AND (UserData.Domains[1] = ''){ AND (NOT FidoOurPoint (UserData.Address))}) THEN
              BEGIN
                   { Onbekende node of wel een node van ons, maar zonder   }
                   { een domain adres, dit betekent dat we wat moeten gaan }
                   { ombouwen. Hiervoor gebruiken we ons HOOFD domain.     }
                   MailFromAdres:=BuildFidonetInternetAdres (Msg.FromAddr_F,'.')+Config.Domains[1];
                   BangFromDomain:=MailFromAdres;

                   (* doet BuildFidonetInternetAdres al...
                   IF FromAddr_F.Point > 0 THEN
                      MailFromAdres := 'p' + Word2String( FromAddr_F.Point ) + '.'
                   ELSE
                        MailFromAdres := '';

                   { MailTOAdres : Martijn_Dijksterhuis@p6.f802.n280.z2.waterland.wlink.nl }

                   { Aangezien mail naar waterland.wlink.nl gestuurd wordt }
                   { zien wij het en moeten we in staat zijn om het        }
                   { orginele adres te reconstureren.                      }

                   MailFromAdres :=  MailFromAdres +  'f' +  Word2String( FromAddr_F.Node ) +
                                                     '.n' + Word2String( FromAddr_F.Net  ) +
                                                     '.z' + Word2String( FromAddr_F.Zone ) +
                                                     '.'  + Config.Domains[1];
                   *)
                   (*
                   LogExtraMessage ('Message from '+Fido2Str (Msg.FromAddr_F));
              END ELSE
              BEGIN
                   { Bekende node, we nemen zijn/haar eigen adres als     }
                   { afzendpunt. Dat Jaap_Aap@sternode.wlink.nl eigenlijk }
                   { op 60:100/110 zit hoeft dus niemand ooit te weten.   }

                   { We hoeven niet te controleren of dit een UseNetNode }
                   { is aangezien het record door FindByFidoAdres        }
                   { aangeleverd is.                                     }

                   IF FidoOurPoint (UserData.Address) THEN
                   BEGIN
                        { RWI 941127: toegevoegd na report "user@p0.domain" }
                        IF (UserData.Address.Point <> 0) THEN
                        BEGIN
                             MailFromAdres:='p'+Word2String (UserData.Address.Point)+'.'+Config.Domains[1];
                             BangFromDomain:=MailFromAdres; { RWI 9501317}
                        END ELSE
                            MailFromAdres:=Config.Domains[1];
                            { RWI 950317: geen BangFromDomain nodig! }

                        LogExtraMessage ('Message from '+MailFromAdres);
                   END ELSE
                   BEGIN
                        MailFromAdres:=UserData.Domains[1];
                        BangFromDomain:=MailFromAdres;
                        LogExtraMessage ('Message from a neighbour system ('+MailFromAdres+')');
                        Organization:=UserData.Organization;
                   END;
              END;
          *)
     END ELSE
     BEGIN
          { mapping is gelukt, dus stond daar misschien wel een username in }

          { RWI 950317: bewaar nu ook het domain deel van het adres }
          {             voor in het bang path.                      }

          { oude code:
          AtPos:=Pos ('@',MailFromAdres);
          IF (AtPos > 0) THEN
             BangFromUser:=Copy (MailFromAdres,1,AtPos-1);
          }

          UsenetSplit (MailFromAdres,BangFromDomain,BangFromUser);

          { RWI 950605: dit ging mis als er geen usernaam in de mapping     }
          {             stond. Dat gebeurd bij MAP-UUCP mappings voor een   }
          {             domain naar een AKA. UsenetSplit gaat er dan vanuit }
          {             dat het de hele string de usernaam is ("newsfix"),  }
          {             terwijl dat het domain adres is. Hier corrigeren we }
          {             dat hardhandig.                                     }
          IF (BangFromDomain = '') THEN
          BEGIN
               BangFromDomain:=BangFromUser;
               BangFromUser:='';
          END;

          { RWI 960113: toegevoegd }
          IF KnownUser THEN
             Organization:=UserRec.Organization;
     END; { was een mapping }

     { nu de naam nog even erbij nemen, voor het geval die niet is }
     { Deze nemen we uit de full name van de zender, die we netjes }
     { omzetten met underscores (of wat dan ook) erin.             }
     CleanedFidoName:=CleanFidoName (Msg.FromUser_F,TRUE);

     { RWI 291094: Bugfix. "From wsd!Ramon_van_der_Winkel <datum>" werd er }
     {             in de header gezet, maar mijn adres was via een map     }
     {             ingesteld op ramon@wsd.wlink.nl, dat wil ik er dan ook  }
     {             wel boven hebben. Er stond dus '!'+CleanedFidoName en   }
     {             dat is nu veranderd in BangFromUser die onderweg        }
     {             bepaald wordt.                                          }

     IF (BangFromUser = '') THEN
        BangFromUser:=CleanedFidoName;

     { RWI 950317: bang pad bevat nu ook het BangFromDomain als die bekend is }

     { RWI 950529: Check toegevoegd om te controleren of BangFromDomain }
     {             en BangFrom gelijk waren. Dit komt voor bij lokaal   }
     {             gegenereerde netmailtjes waar een mapping aanwezig   }
     {             was voor een bepaald persoon, met daarin een domain  }
     {             gelijk aan het systeem domain. Dit gaat nu dus mis   }
     {             als er een sub-domain is met dezelfde naam, maar dat }
     {             mag geloof ik niet eens. Ff denken... gelijken UUCP- }
     {             namen mogen niet en gelijke (complete) domain namen  }
     {             is al helemaal onmogelijk.                           }

     { zet nu het bangpath adres op dat terug gegeven gaat worden }
     BangFrom:=UseGetSystemFromName; { ons eerste domain of onze UUCPname }

     IF (BangFromDomain <> '') AND (BangFromDomain <> BangFrom) THEN
        BangFrom:=BangFrom+'!'+BangFromDomain;

     BangFrom:=BangFrom+'!'+BangFromUser;

     { als het MailFromAdres door de mapping al een usernaam gekregen }
     { heeft, dan hoeft de username er niet nog eens voor. Zeker niet }
     { deze vieze vertaalde naam die we hier hebben. Dus controleer   }
     { eerst even.                                                    }
     { RAWI 970507: Als de CleanedFidoName al een @ or ! bevat, dan   }
     { moet er ook geen domain meer aan toegevoegd worden..           }
     IF (Pos ('@',MailFromAdres) = 0) THEN
     BEGIN
          IF (Pos ('@',CleanedFidoName) = 0) AND (Pos ('!',CleanedFidoName) = 0) THEN
             MailFromAdres:=CleanedFidoName+'@'+MailFromAdres
          ELSE
              MailFromAdres:=CleanedFidoName;
     END;

     { use the system organization by default }
     IF (Organization = '') THEN
        Organization:=Config.Organization;

     { nu is het MailFromAdres compleet en kunnen we loggen }
     IF Config.LogTranslationFU THEN
     BEGIN
          LogExtraMessage ('Translation: "'+Msg.FromUser_F+'"%'+Fido2Str (Msg.FromAddr_F));
          LogExtraMessage ('       into: '+MailFromAdres);
     END;
END;


{--------------------------------------------------------------------------}
{ BuildFromHeader                                                          }
{                                                                          }
{ Deze routine retourneerd "From: <email> (<comment>)", maar laat het      }
{ comment deel weg als het precies hetzelfde is als het e-mail adres.      }
{                                                                          }
FUNCTION BuildFromHeader (Email,Comment : STRING) : STRING;
BEGIN
     IF (Comment = Email) THEN
        BuildFromHeader:='From: '+Email
     ELSE
        BuildFromHeader:='From: '+Email+' ('+Comment+')';
END;


{--------------------------------------------------------------------------}
{ TranslateEchomail2News                                                   }
{                                                                          }
{ Converteren van Echomail naar Usenet News. FromUserData moet de gegevens }
{ van de afzender bevatten.                                                }
{                                                                          }
{ Aanpassing: We moeten nu de correcte newsgroup naam aan het bericht      }
{ meegeven.                                                                }
{                                                                          }
{ RWI 950627: bij distributie van de listserver kan het voorkomen dat er   }
{             nog een oude mail header rondhangt. In dat geval kunnen we   }
{             daar nog nuttige informatie van de zender uit halen voordat  }
{             die header opgeruimd wordt.                                  }
{                                                                          }
PROCEDURE TranslateEchomail2News;

VAR Organization,
    BangFrom,
    MailFromAdres : STRING;
    DelCount      : BYTE;
    EenRegelPtr   : EenRegelRecordPtr;
    Lp            : BYTE;
    Found         : BOOLEAN;
    Lines         : LONGINT;

BEGIN
     { UserData afzender zit al in het geheugen        }
     { WtrLnd moet uit de (Usenet/StrLnd) config komen }

     IF Msg.ListServer AND (Msg.FromUser_U <> '') THEN
     BEGIN
          LogExtraMessage ('Intelligently using old Mail header to build the News header');

          { speciale actie: de "distributed by" ook omzetten }
          MsgsDeleteFirstRowFromBody;
          MsgsDeleteFirstRowFromBody;
          MsgsDeleteFirstRowFromBody;

          MsgsReleaseLines (Msg.HeaderTop_U); { just in case.. }

          { plug onze systeem naam in de path line }
          MsgsAddLineTo (Header_U,'Path: '+UseGetSystemFromName+'!'+ListMainRec.ListName);

          IF (Msg.FromUser_U <> '') THEN
             MsgsAddLineTo{NoEOL} (Header_U,Msg.FromUser_U);

          IF (Msg.Sender_U <> '') THEN
             MsgsAddLineTo{NoEOL} (Header_U,Msg.Sender_U);

          IF (Msg.ReplyTo_U <> '') THEN
             MsgsAddLineTo{NoEOL} (Header_U,Msg.ReplyTo_U);

          IF (Msg.ToUser_U <> '') THEN
             MsgsAddLineTo{NoEOL} (Header_U,Msg.ToUser_U);

          IF (Msg.Date_U <> '') THEN
             MsgsAddLineTo{NoEOL} (Header_U,Msg.Date_U);

          IF (Msg.MessageID_U <> '') THEN
             MsgsAddLineTo{NoEOL} (Header_U,Msg.MessageID_U);

          IF (Msg.Subj_U <> '') THEN
             MsgsAddLineTo{NoEOL} (Header_U,Msg.Subj_U);

          IF (Msg.Organization_U <> '') THEN
             MsgsAddLineTo{NoEOL} (Header_U,Msg.Organization_U);

          { omdat het bericht als eens van Mail naar Netmail vertaald }
          { is, kunnen er headers aan het begin van het bericht staan }
          { en die willen we er niet dubbel in hebben. Afschieten met }
          { die hap dus. We vergelijken ze against de Msg.*_U die we  }
          { hebben.                                                   }

          { we houden een maximum bij, want we willen geen 2 meg doorlopen }
          DelCount:=0;
          WHILE (DelCount < MaxCopyHeaders) DO
          BEGIN
               EenRegelPtr:=Msg.BodyTop^.FirstRegelRecordPtr;
               MsgsNewSeek (EenRegelPtr);

               CASE EenRegelPtr^.Waar OF
                    wMem :
                        BEGIN
                             BangFrom{misbruik}:=EenRegelPtr^.RegelPtr^;
                        END;

                    wSwapped :
                        BEGIN
                             BlockRead (SwapFile,BangFrom[0],1);
                             IF (BangFrom[0] = #0) THEN
                                Break; { overgang naar swap blok is niet ondersteund }

                             BlockRead (SwapFile,BangFrom[1],Byte (BangFrom[0]));
                        END;
               END; { case }

               IF (BangFrom = #13) THEN
                  Break; { einde van de header }

               { see if this line matches one of the copy headers }
               BangFrom:=UpCaseString (BangFrom);

               Found:=FALSE;
               WITH Config DO
                    FOR Lp:=1 TO MaxCopyHeaders DO
                        IF (CopyHeaderHow[Lp] <> chNot) AND
                           (CopyHeaderNames[Lp] <> '') AND
                           (Copy (BangFrom,1,Length (CopyHeaderNames[Lp])+1) = (UpCaseString (CopyHeaderNames[Lp])+' ')) THEN
                        BEGIN
                             { gotcha! Verwijderen en volgende controleren }
                             {LogMessage ('Deleting "'+BangFrom+'"');}
                             MsgsDeleteFirstRowFromBody;
                             Inc (DelCount);
                             Found:=TRUE;
                             Break;
                        END;

               { niet gevonden }
               IF (NOT Found) THEN
                  Break; { uit de while }

          END; { while }

          { de list server header weer toevoegen }
          MsgsAddFirstLineTo (Body,'');
          MsgsAddFirstLineTo (Body,ListMainRec.ListName+'@'+Config.Domains[1]);
          MsgsAddFirstLineTo (Body,'This message was distributed by the mailing list:');
     END ELSE
     BEGIN
          { zelf aanmaken die hap }

          { RWI 950605: deze vertaling is nu dezelfde als bij Netmail->Mail, }
          {             zodat alles nu op een lijn zit en het scheelt wat    }
          {             dubbele code.                                        }

          TranslateFromAddressFU (Organization,BangFrom,MailFromAdres);

          { if there was an organization line, then override it }
          IF (Organization <> '') THEN
             Msg.Organization_U:='Organization: '+Organization;

          Msg.FromUser_U:=BuildFromHeader (MailFromAdres,CleanFidoName (Msg.FromUser_F,FALSE));
          Msg.NewsGroups_U:='Newsgroups: '+LoCaseString (AreaData.AreaName_U)+#13{RWI950217};
          Msg.Subj_U:='Subject: '+CleanSubject (Msg.Subj_F);
          Msg.Date_U:='Date: '+Fido2UsenetDate (Msg.Date_F);

          { plug onze systeem naam in de path line }
          MsgsAddLineTo (Header_U,'Path: '+BangFrom);

          { Plaats de From: regel in het bericht }
          MsgsAddLineTo (Header_U,Msg.FromUser_U);

          MsgsAddLineTo (Header_U,Msg.Date_U);

          { Plaats de Message-ID lijn in het bericht }
          MsgsAddLineTo (Header_U,'Message-ID: '+MsgID2MessageID (Msg.MsgID_F));

          { Plaats de Message-ID lijn in het bericht }
          IF (Msg.ReplyID_F <> '') THEN
             MsgsAddLineTo (Header_U,'References: '+MsgID2MessageID (Msg.ReplyID_F));

          { now copy the headers. Some will fill in the Subject,   }
          { Organization and Newsgroups fields in the Msg record.  }
          { Others go directly into the header. The Msg.XXX fields }
          { are thus overriding the otherwise used value.          }
          CopyHeadersFromFidoBody;

          { Plaats de NewsGroups regel in het bericht }
          { RWI 950217: controle op #13, dan via NoEOL toevoegen }
          IF (Msg.Newsgroups_U[Length (Msg.Newsgroups_U)] = #13) THEN
             MsgsAddLineToNoEOL (Header_U,Msg.Newsgroups_U)
          ELSE
              MsgsAddLineTo (Header_U,Msg.Newsgroups_U);

          { Plaats de Subject line in het bericht }
          MsgsAddLineTo (Header_U,Msg.Subj_U);

          { organization kludge, optioneel }
          IF (Msg.Organization_U <> '') THEN
             MsgsAddLineTo (Header_U,Msg.Organization_U);
     END;

     { RWI 960310: stond eerst helemaal aan het begin, maar kapte lange }
     {             headers af die nog in het bericht moesten komen.     }
     { RWI961231: Doet MIME encoding nu
     UnParagraphBody;
     }

     IF Msg.ListServer THEN
     BEGIN
          { zorg dat de Signature triggert op the list aka en list naam }
          { zoals bijvoorbeeld WaterGate 1:2/3.4... this is COOOL!      }
          Msg.FromAddr_F:=Config.NodeNrs[ListMainRec.ListAKA];
          Msg.FromUser_F:=ListMainRec.ListName;
     END;

     AddSignature;

     { Dubbele functie, de routine die alle regels afloopt op illegale }
     { tekens telt ook meteen het aantal regels.                       }
     { Aangezien deze echo blijkbaar door Usenet lezer gelezen wordt,  }
     { maak het bericht schoon van alle 8-bits tekens.                 }
     Lines:=FtnBodyToMime;

     { MIME headers toevoegen }
     AddStandardMimeHeaders;

     MsgsAddLineTo (Header_U,'Lines: '+Longint2String (Lines));

     { Lege regel sluit de header af }
     { niet zeker of deze hier moet. Eigenlijk beter tijdens export.. }
     { RWI970116: goed gedacht! We doen het nu niet meer...
     MsgsAddLineTo (Header_U,'');
     }

     { Klaar! }
     Msg.Ready_F:=NotReady;
     Msg.Ready_U:=News;

     (* RWI 950605: oude code...
     { !Onze! Points horen tot hun host systeem }
     IF GetFIDO_2_UUCP (Afzender) THEN
     BEGIN
          IF FidoOurAdres (Msg.FromAddr_F) THEN
          BEGIN
               IF (Pos ('@',Afzender) = 0) THEN
                  Path:=Afzender+'!'+CleanFidoName (Msg.FromUser_F,TRUE)
               ELSE BEGIN
                    { username@domain.adres -->  domain.adres!username }
                    UseAdresParse (Afzender,Domain,UserName);
                    Path:=Domain+'!'+UserName;
               END;
          END ELSE
          BEGIN
               { Mogelijke fix: Als een bericht van een node kwam die in }
               {                de map-uucp routing gedefinieerd stond   }
               {                werd ons eigen systeem ook vermeld.      }
               {                volgens mij kan ik hier zwaar problemen  }
               {                mee krijgen.                             }
               { RWI 950317: nee hoor. Zo hoort het juist! }
               IF (Pos ('@',Afzender) = 0) THEN
                  Path:=UseGetSystemFromName+'!'+Afzender+'!'+CleanFidoName (Msg.FromUser_F,TRUE)
               ELSE BEGIN
                    { username@domain.adres -->  domain.adres!username }
                    UseAdresParse (Afzender,Domain,UserName);
                    { RWI 950317: UseGetSystemFromName+'!' stond tussen accolades }
                    Path:=UseGetSystemFromName+'!'+Domain+'!'+UserName;
               END;
          END;

          Organization:=Config.Organization;
     END ELSE
         { er was geen MAP-UUCP commando voor deze node }

         { Is het van ons eigen systeem, of een point van ons systeem? }
         IF FidoOurPoint (Msg.FromAddr_F) OR
            FidoOurAdres (Msg.FromAddr_F) THEN
         BEGIN
              IF FidoOurPoint (Msg.FromAddr_F) THEN {# lekker twee keer FidoOurPoint aanroepen #}
              BEGIN
                   { RWI 941127: controle op 0 na melding van "user@p0.domain" }
                   IF (Msg.FromAddr_F.Point = 0) THEN
                      Afzender:=Config.Domains[1]
                   ELSE
                       Afzender:='p'+Word2String (Msg.FromAddr_F.Point)+'.'+Config.Domains[1]
              END ELSE
                  Afzender:=Config.Domains[1];

              { RWI 950317: Afzender wordt nu ook in de Path regel }
              {             opgenomen als het niet ons domain is.  }
              Path:=UseGetSystemFromName;
              IF (Afzender <> Config.Domains[1]) THEN
                 Path:=Path+'!'+Afzender;
              Path:=Path+'!'+CleanFidoName (Msg.FromUser_F,TRUE);  {OurSystem;}
              Organization:=Config.Organization;
         END ELSE
         BEGIN
              { Nu wordt het problematisch, het is dus niet van ons eigen }
              { systeem maar van een ander. Als het van een bekende node  }
              { is, gebruik dan de instellingen van die node, als dat     }
              { niet het geval is gebruik dan onze instellingen voor de   }
              { gateway.                                                  }

              { 1. Controleer of we de afzender kennen }
              IF FindUserBaseRecordByFidoAddress (Msg.FromAddr_F,UserBaseRec) THEN
              BEGIN
                   { 1.1 Laad het juiste userbase record }
                   ReadUserBaseRecord (UserBaseRec,UserData);

                   { 1.2 Heeft de user een eigen domain definitie? }
                   IF (UseGetUserFromName (UserData) <> '') THEN
                   BEGIN
                        { Afzender wordt gebruikt om de FROM: header in }
                        { elkaar te zetten. Hiervoor wordt de EERSTE    }
                        { userdate definitie gebruikt.                  }
                        Afzender:=UserData.Domains[1];
                        Path:=UseGetSystemFromName+
                              '!'+UseGetUserFromName (UserData)+
                              '!'+CleanFidoName (Msg.FromUser_F,TRUE);
                   END ELSE
                   BEGIN
                        { user heeft geen eigen domain definitie, dus }
                        { krijgt ie er een van ons.                   }
                        Afzender:=BuildFidonetInternetAdres (Msg.FromAddr_F,'.')+Config.Domains[1];
                        { RWI 950317: Afzender staat nu ook in het Path }
                        Path:=UseGetSystemFromName+'!'+Afzender+'!'+CleanFidoName (Msg.FromUser_F,TRUE);
                   END;

                   Organization:=UserData.Organization;
              END ELSE
              BEGIN
                   { wij zijn dus de pineut }
                   Afzender:=BuildFidonetInternetAdres (Msg.FromAddr_F,'.')+Config.Domains[1];
                   { RWI 950317: +'!'+Afzender toegevoegd }
                   Path:=UseGetSystemFromName+'!'+Afzender+'!'+CleanFidoName (Msg.FromUser_F,TRUE);
                   Organization:=Config.Organization;
              END;  { if }
         END; { if }

     IF (Pos ('@',Afzender) = 0) THEN
        Msg.FromUser_U:='From: '+DeleteBackspaces (CleanFidoName (Msg.FromUser_F,TRUE)+'@'+Afzender)+' ('+Msg.FromUser_F+')'
     ELSE
         Msg.FromUser_U:='From: '+Afzender+' ('+Msg.FromUser_F+')';
     *)
END;


{--------------------------------------------------------------------------}
{ TranslateNetmail2Mail                                                    }
{                                                                          }
{ Deze routine kan een netmail bericht zo veranderen dat het als een       }
{ legitiem Mail bericht over de wereld zal verzonden worden.               }
{                                                                          }
FUNCTION TranslateNetmail2Mail (ToUser : STRING) : BOOLEAN;

VAR Regel          : STRING;
    EenRegelPtr    : EenRegelRecordPtr;
    Organization,
    MailToAdres,
    MailFromAdres,
    BangFrom       : STRING;
    Lp,
    DelCount       : BYTE;
    Found          : BOOLEAN;
    Again,
    FDBug          : BOOLEAN;

BEGIN
     TranslateNetmail2Mail:=FALSE;

     { of het nu mis gaat of niet, deze netmail was bedoelde voor  }
     { Usenet en kan dus uit de netmail area verwijderd worden als }
     { KillGatedNetmail gezet is.                                  }
     Msg.WasGated:=TRUE;

     { kijk of het doel adres van het bericht al bekend is }
     IF (ToUser = '') THEN
     BEGIN
          { Stap 1 - Kijk of de eerste Body regel van het bericht een }
          { 'TO:' kludge bevat.                                       }
          { Later kunnen we misschien ook andere kludges doorlaten,   }
          { maar op dit moment worden die toch nog door niemand       }
          { ondersteund.                                              }

          FDBug:=FALSE; { geen lege regel overgeslagen }

          IF (Msg.BodyTop <> NIL) THEN
          BEGIN
               EenRegelPtr:=Msg.BodyTop^.FirstRegelRecordPtr;
               MsgsNewSeek (EenRegelPtr);

               Again:=TRUE;

               WHILE Again DO
               BEGIN
                    CASE EenRegelPtr^.Waar OF
                         wMem :
                              BEGIN
                                   Regel:=EenRegelPtr^.RegelPtr^;
                                   { voorbereiden om eventueel nog een regel in te lezen }
                                   EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                                   MsgsNewSeek (EenRegelPtr);
                              END;

                         wSwapped :
                             BEGIN
                                  { lengte van de regel inlezen }
                                  BlockRead (SwapFile,Regel[0],1);

                                  { als dit een leeg administratief record was, }
                                  { dan zitten we diep in de stront... :-(      }
                                  IF (Regel[0] = #0) THEN
                                  BEGIN
                                       EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                                       Continue;
                                  END;

                                  { regel zelf inlezen }
                                  BlockRead (SwapFile,Regel[1],Byte (Regel[0]));
                             END;
                    END; { case }

                    IF (Regel = #13) AND (Config.FidoSystem = stFrontDoor) AND (NOT FDBug){niet twee keer!} THEN
                       { controleer de tweede regel ook }
                       FDBug:=TRUE
                    ELSE
                        Again:=FALSE;

               END; { while}

          END ELSE { if bodytop <> nil }
              Regel:='';

          IF (UpCaseString (Copy (Regel,1,3)) <> 'TO:') THEN
          BEGIN
               { 'Missing TO: <domain address> on the first message line' }
               FidoBounceNetmail (Config.GatewayUser,FALSE,GetLang0 (108));
               Exit;
          END;

          { Stap 2 - Haal het TO adres uit de regel }
          MailToAdres:=DeleteFrontAndBackSpaces (Copy (Regel,4,255));
          IF (MailToAdres[Length (MailToAdres)] = #13) THEN
             Delete (MailToAdres,Length (MailToAdres),1);

          IF (MailToAdres = '') THEN
          BEGIN
               LogExtraMessage ('TO: line is missing a domain-style address (user@domain)');
               { 'TO: line is missing a domain style adres (user@domain)' }
               FidoBounceNetmail (Config.GatewayUser,FALSE,GetLang0 (109));
               Exit;
          END;

          { Haal de TO kludge weg uit het bericht }
          MsgsDeleteFirstRowFromBody;

          { bij de FD bug twee regels weghalen }
          IF FDBug THEN
             MsgsDeleteFirstRowFromBody; { nog een keer }
     END ELSE { touser = '' }
         MailToAdres:=ToUser;

     LogMessage ('Gating netmail for '+MailToAdres+' to mail');

     { Creer de UsenetMail header }

     { Voor maffe figuren, gooi de header alvast maar bij het grof vuil }
     { Dit om dubbele header bij bouncen binnen Wtrgate te voorkomen.   }
     MsgsReleaseLines (Msg.HeaderTop_U) ;

     IF (Msg.ListServer) AND (Msg.FromUser_U <> '') THEN
     BEGIN
          LogMessage ('Intelligently using old News header to build the Mail header');

          { plug onze systeem naam in de path line }
          MsgsAddLineTo (Header_U,'From '+UseGetSystemFromName+'!'+ListMainRec.ListName+' '+UsenetArpanetDate);

          IF (Msg.FromUser_U <> '') THEN
             MsgsAddLineTo{NoEOL} (Header_U,Msg.FromUser_U);

          IF (Msg.Sender_U <> '') THEN
             MsgsAddLineTo{NoEOL} (Header_U,Msg.Sender_U);

          IF (Msg.ReplyTo_U <> '') THEN
             MsgsAddLineTo{NoEOL} (Header_U,Msg.ReplyTo_U);

          IF (Msg.ToUser_U <> '') THEN
             MsgsAddLineTo{NoEOL} (Header_U,Msg.ToUser_U);

          IF (Msg.Date_U <> '') THEN
             MsgsAddLineTo{NoEOL} (Header_U,Msg.Date_U);

          IF (Msg.MessageID_U <> '') THEN
             MsgsAddLineTo{NoEOL} (Header_U,Msg.MessageID_U);

          IF (Msg.Subj_U <> '') THEN
             MsgsAddLineTo{NoEOL} (Header_U,Msg.Subj_U);

          IF (Msg.Organization_U <> '') THEN
             MsgsAddLineTo{NoEOL} (Header_U,Msg.Organization_U);

          { omdat het bericht als eens van News naar Echomail vertaald }
          { is, kunnen er headers aan het begin van het bericht staan  }
          { en die willen we er niet dubbel in hebben. Afschieten met  }
          { die hap dus. We vergelijken ze against de Msg.*_U die we   }
          { hebben.                                                    }

          { we houden een maximum bij, want we willen geen 2 meg doorlopen }
          DelCount:=0;
          WHILE (DelCount < MaxCopyHeaders) DO
          BEGIN
               EenRegelPtr:=Msg.BodyTop^.FirstRegelRecordPtr;
               MsgsNewSeek (EenRegelPtr);

               CASE EenRegelPtr^.Waar OF
                    wMem :
                        BEGIN
                             Regel{misbruik}:=EenRegelPtr^.RegelPtr^;
                        END;

                    wSwapped :
                        BEGIN
                             BlockRead (SwapFile,Regel[0],1);
                             IF (Regel[0] = #0) THEN
                                Break; { overgang naar swap blok is niet ondersteund }

                             BlockRead (SwapFile,Regel[1],Byte (Regel[0]));
                        END;
               END; { case }

               IF (Regel = #13) THEN
                  Break; { einde van de header }

               { see if this line matches one of the copy headers }
               Regel:=UpCaseString (Regel);

               Found:=FALSE;
               WITH Config DO
                    FOR Lp:=1 TO MaxCopyHeaders DO
                        IF (CopyHeaderHow[Lp] <> chNot) AND
                           (CopyHeaderNames[Lp] <> '') AND
                           (Copy (Regel,1,Length (CopyHeaderNames[Lp])+1) = (UpCaseString (CopyHeaderNames[Lp])+' ')) THEN
                        BEGIN
                             { gotcha! Verwijderen en volgende controleren }
                             {LogMessage ('Deleting "'+BangFrom+'"');}
                             MsgsDeleteFirstRowFromBody;
                             Inc (DelCount);
                             Found:=TRUE;
                             Break;
                        END;

               { niet gevonden }
               IF (NOT Found) THEN
                  Break; { uit de while }

          END; { while }

          { als de eerste regel van de body nu leeg is, dan moet die even }
          { weggehaald worden. Bij het verspreiden in Mail vorm wordt     }
          { namelijk een header bovenop het bericht gezet, die ook een    }
          { lege regel heeft. Deze lege regel is hier gekomen bij het     }
          { kopieren van de header lines.                                 }

          IF FirstBodyLineIsEmpty THEN
             MsgsDeleteFirstRowFromBody;

          { voor de XQT file }
          IF (Msg.Subj_U <> '') THEN
             Msg.Subj_U:='Subj: ';

          IF (Msg.Date_U = '') THEN
             Msg.Date_U:='Date: ';

     END ELSE
     BEGIN
          TranslateFromAddressFU (Organization,BangFrom,MailFromAdres);

          MsgsAddLineTo (Header_U,'From '+BangFrom+' '+UsenetArpanetDate);

          { deze kludge moeten we nog eens zien te onderdrukken... }
          MsgsAddLineTo (Header_U,'Received: by '+UseGetSystemFromName+' ('+Copy (FidoTear,5,255)+')');
          MsgsAddLineTo (Header_U,'          via FTN; '+UsenetArpanetDate);
          MsgsAddLineTo (Header_U,'          for '+MailToAdres);

          { RWI 950317: nu nemen we de datum uit de netmail }
          MsgsAddLineTo (Header_U,'Date: '+Fido2UsenetDate (Msg.Date_F){UsenetArpaNetDate});

          { RWI 281094: Bij de 'From: ' kludge werd de fullname (die tussen }
          {             haakjes staat) genomen van CleanedFidoName, waar    }
          {             de spaties vervangen waren door punten. Wat         }
          {             remarked erachter stond, is wat het nu weer is.     }
          MsgsAddLineTo (Header_U,BuildFromHeader (MailFromAdres,CleanFidoName (Msg.FromUser_F,FALSE)));

          { RWI 950605: Het MsgID uit het fido bericht wordt nu gebruikt }
          { RWI 960417: Msg.MessageID_U wordt nu ook ingevuld. Anders    }
          {             gaat een internet netmail->mail->netmail mis.    }
          Msg.MessageID_U:='Message-ID: '+MsgID2MessageID (Msg.MsgID_F);
          MsgsAddLineTo (Header_U,Msg.MessageID_U);

          IF (Msg.ReplyID_F <> '') THEN
          BEGIN
               { RWI 960417: Msg.InReplyTo_U wordt nu ook ingevuld }
               Msg.InReplyTo_U:='In-Reply-To: '+MsgID2MessageID (Msg.ReplyID_F);
               MsgsAddLineTo (Header_U,Msg.InReplyTo_U);
          END;

          MsgsAddLineTo (Header_U,'To: '+MailToAdres);

          { organization alleen toevoegen als ie ingevuld is. Als de systeem    }
          { organization header altijd aanwezig is, maar we hebben een override }
          { met een userrecord, dan kan ie nu wel leeg zijn.                    }
          IF (Organization <> '') THEN
             Msg.Organization_U:='Organization: '+Organization;

          { voor de XQT file }
          Msg.FromUser_U:=BuildFromHeader (MailFromAdres,CleanFidoName (Msg.FromUser_F,FALSE));
          Msg.Subj_U:='Subject: '+RemovePathsFromSubject (Msg.Subj_F,Msg.Attr_F AND MSGFILE);
          Msg.Date_U:='Date: '+Fido2UsenetDate (Msg.Date_F); { vertaling gebeurt nu dubbel! }

          { override the Newsgroups, Subject and Organization headers }
          CopyHeadersFromFidoBody;

          MsgsAddLineTo (Header_U,Msg.Subj_U);

          IF (Msg.Organization_U <> '') THEN
             MsgsAddLineTo (Header_U,Msg.Organization_U);

          { Plaats de NewsGroups regel in het bericht }
          { RWI 960717: zorgde voor een lege regel in mail zonder newsgroups_U.. }
          IF (Msg.Newsgroups_U <> '') THEN
          BEGIN
               { RWI 950217: controle op #13, dan via NoEOL toevoegen }
               IF (Msg.Newsgroups_U[Length (Msg.Newsgroups_U)] = #13) THEN
                  MsgsAddLineToNoEOL (Header_U,Msg.Newsgroups_U)
               ELSE
                   MsgsAddLineTo (Header_U,Msg.Newsgroups_U);
          END;
     END;

     { RWI970116: niet meer nodig..
     MsgsAddLineTo (Header_U,''); { Lege lijn sluit header }

     { RWI961231: doet MIME encoding nu...
     UnParagraphBody;
     }

     { Vul de envelope in zodat de usenet router ook weet waar ie aan toe is }

     UseAdresParse (MailToAdres,STRING (Msg.XqtTo_U),STRING (Msg.ToUser_U));
     Msg.XqtTo_U:=MailToAdres;
     Msg.ToUser_U:='To: '+MailToAdres;

     IF Msg.ListServer THEN
     BEGIN
          { zorg dat de Signature triggert op the list aka en list naam }
          { zoals bijvoorbeeld WaterGate 1:2/3.4... this is COOOL!      }
          Msg.FromAddr_F:=Config.NodeNrs[ListMainRec.ListAKA];
          Msg.FromUser_F:=ListMainRec.ListName;
     END;

     { kijk of er een file attach bij het bericht zit. Zoja, dan moeten }
     { we alle files in de subject regel overnemen in het mail bericht. }
     IF ((Msg.Attr_F AND MSGFILE) > 0) THEN
     BEGIN
          { UU-encoded file in het bericht opnemen }
          {$IFNDEF WtrTest}
          AddFilesToBody (Msg.Subj_F);
          {$ENDIF}
          Msg.Attr_F:=Msg.Attr_F XOR MSGFILE;  { wis de f/a vlag }
     END;

     AddSignature;

     { Zorg ervoor dat het bericht verschoont blijft van 8 bits Ascii }
     { Dit aangezien we alleen 7 bits codes usenet mogen insturen     }
     FtnBodyToMime;

     { MIME headers toevoegen }
     AddStandardMimeHeaders;

     { klaar ! }
     Msg.Ready_F:=NotReady;
     Msg.Ready_U:=Mail;

     {$IFDEF WtrTest}
     LogExtraMessage ('Mail: Main to = '+Msg.XqtTo_U);
     LogExtraMessage ('  '+Msg.FromUser_U);
     LogExtraMessage ('  '+Msg.ToUser_U);
     IF (Organization = '') THEN
        LogExtraMessage ('  No organization line')
     ELSE
         LogExtraMessage ('  Organization: '+Organization);
     {$ENDIF}

     TranslateNetmail2Mail:=TRUE;
END;


{---------------------------------------------------------------------------}
{ TransNetToEcho_CopyHeader                                                 }
{                                                                           }
PROCEDURE TransNetToEcho_CopyHeader (VAR Regel : STRING); FAR;
BEGIN
     IF (Copy (Regel,1,5) = #1'TOPT') THEN
        Exit;

     IF (Copy (Regel,1,5) = #1'FMPT') THEN
        Exit;

     IF (Copy (Regel,1,5) = #1'INTL') THEN
        Exit;

     MsgsAddLineToNoEOL (Header_F,Regel);
END;


{---------------------------------------------------------------------------}
{ TransNetToEcho_CopyFooter                                                 }
{                                                                           }
PROCEDURE TransNetToEcho_CopyFooter (VAR Regel : STRING); FAR;
BEGIN
     IF (Copy (Regel,1,4) = #1'Via') THEN
        Exit;

     { eigenlijk willen we alleen een tear-line overhouden }
     IF (Copy (Regel,1,3) <> '---') THEN
        LogMessage ('[Net2Echo] Keeping footer line '+Regel);

     MsgsAddLineToNoEOL (Footer_F,Regel);
END;


{---------------------------------------------------------------------------}
{ TranslateNetmail2Echomail                                                 }
{                                                                           }
{ Deze routine mag alleen worden aangeroepen door de list server.           }
{                                                                           }
{ Deze routine vertaalt een netmail naar een echomail voor de opgegeven     }
{ area name. De acties die hierop uitgevoerd worden zijn:                   }
{                                                                           }
{ - verwijder kludges INTL, FMPT en TOPT                                    }
{ - voeg een AREA: kludge toe                                               }
{                                                                           }
PROCEDURE TranslateNetmail2Echomail (AreaRecNr : AreaBaseRecordNrType);

VAR OldLines : TopRegelRecordPtr;
    AreaRec  : AreaBaseRecord;

BEGIN
     LogMessage ('Translating Netmail -> Echomail');

     { AreaRecNr = NILRecordNr is al op gecontroleerd }

     ReadAreaBaseRecord (AreaRecNr,AreaRec);

     OldLines:=Msg.HeaderTop_F;
     Msg.HeaderTop_F:=NIL;

     { voeg de AREA: kludge toe }
     MsgsAddLineTo (Header_F,'AREA:'+AreaRec.AreaName_F);

     { check en kopieer de gewenste oude header lines }
     MsgsForEach (OldLines,TransNetToEcho_CopyHeader);

     { gooi de oude header lines nu weg }
     MsgsReleaseLines (OldLines);

     { nu de footer nog ----------- }

     OldLines:=Msg.FooterTop_F;
     Msg.FooterTop_F:=NIL;
     MsgsForEachKill (OldLines,TransNetToEcho_CopyFooter);

     { netmail heeft (en mag geen) origin line hebben. Echomail moet }
     { er echter wel een hebben, dus voegen we de systeem origin     }
     { line maar toe.                                                }
     MsgsAddLineTo (Footer_F,FidoBuildOrigin (Config.Origins[1],Config.NodeNrs[ListMainRec.ListAKA]));

     { zorg dat er geen troep vlaggen meer staat die te maken hebben }
     { met netmail...                                                }
     Msg.Attr_F:=MSGLOCAL;

     { nog even een helpertje voor de export }
     Msg.Area_F:=UpCaseString (AreaRec.AreaName_F);

     Msg.Ready_F:=Echomail; { not Local: that doesn't get imported }
END;


{---------------------------------------------------------------------------}
{ TransEchoToNet_CopyHeader                                                 }
{                                                                           }
PROCEDURE TransEchoToNet_CopyHeader (VAR Regel : STRING); FAR;
BEGIN
     { AREA: dumpen }
     { XPOST: dumpen }

     IF (Copy (Regel,1,5) = 'AREA:') THEN
        Exit;

     IF (Copy (Regel,1,6) = 'XPOST:') THEN
        Exit;

     { Pid eruit halen }

     MsgsAddLineToNoEOL (Header_F,Regel);
END;


{---------------------------------------------------------------------------}
{ TransEchoToNet_CopyFooter                                                 }
{                                                                           }
PROCEDURE TransEchoToNet_CopyFooter (VAR Regel : STRING); FAR;
BEGIN
     { dump de PATH: en SEEN-BY regels }
     IF (Copy (Regel,1,6) = #1'PATH:') THEN
        Exit;

     IF (Copy (Regel,1,8) = 'SEEN-BY:') THEN
        Exit;

     { Origin line mag niet in netmail }
     IF (Copy (Regel,1,10) = ' * Origin:') THEN
        Exit;

     { "Via" dumpen? }

     { Origin aanpassen ivm AKA? }
     { Replace Tear-line? }

     MsgsAddLineToNoEOL (Footer_F,Regel);
END;


{---------------------------------------------------------------------------}
{ TranslateEchomail2Netmail                                                 }
{                                                                           }
{ Deze routine mag alleen worden aangeroepen door de list server.           }
{                                                                           }
{ Deze routine vertaalt een echomail naar een netmail door deze aan alle    }
{ kanten te strippen. De INTL, TOPT en FMPT kludges worden later nog        }
{ toegevoegd door de zender (de listserver).                                }
{                                                                           }
PROCEDURE TranslateEchomail2Netmail;

VAR OldLines : TopRegelRecordPtr;

BEGIN
     LogMessage ('Translating Echomail -> Netmail');

     OldLines:=Msg.HeaderTop_F;
     Msg.HeaderTop_F:=NIL;

     { toevoegen van INTL, FMPT en TOPT komt bij de distributie pas }

     { kopieer de rest wat we willen }
     MsgsForEach (OldLines,TransEchoToNet_CopyHeader);
     MsgsReleaseLines (OldLines);

     OldLines:=Msg.FooterTop_F;
     Msg.FooterTop_F:=NIL;
     MsgsForEach (OldLines,TransEchoToNet_CopyFooter);
     MsgsReleaseLines (OldLines);

     Msg.Ready_F:=Netmail;
END;


{---------------------------------------------------------------------------}
{ TransNewsToMail_CopyHeader                                                }
{                                                                           }
PROCEDURE TransNewsToMail_CopyHeader (VAR Regel : STRING); FAR;
BEGIN
     IF (Copy (Regel,1,12) = 'Newsgroups: ') THEN
        Exit;

     IF (Copy (Regel,1,6) = 'Path: ') THEN
        Exit;

     IF (Copy (Regel,1,7) = 'Lines: ') THEN
        Exit;

     MsgsAddLineToNoEOL (Header_U,Regel);
END;


{---------------------------------------------------------------------------}
{ TranslateNews2Mail                                                        }
{                                                                           }
{ Deze routine mag alleen worden aangeroepen door de list server.           }
{                                                                           }
{ Deze routine vertaalt een newsje in een mail compliant bericht door       }
{ verschillende headers eruit te slopen.                                    }
{                                                                           }
PROCEDURE TranslateNews2Mail;

VAR OldLines : TopRegelRecordPtr;

BEGIN
     LogMessage ('Translating News -> Mail');

     OldLines:=Msg.HeaderTop_U;
     Msg.HeaderTop_U:=NIL;

     MsgsAddLineTo (Header_U,'From '+UseGetSystemFromName+'!'+ListMainRec.ListName+' '+UsenetArpanetDate);
     MsgsAddLineTo (Header_U,'To: '+ListMainRec.ListName+'@'+Config.Domains[1]);

     MsgsForEach (OldLines,TransNewsToMail_CopyHeader);

     MsgsReleaseLines (OldLines);

     Msg.Ready_U:=Mail;
END;


END.
