{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT Textfile;

{ MD  01-04-93  Begin aan de token routine                                }
{ MD  07-04-93  TokenString verplaatst zodat zij ook aan te passen is     }
{               vanuit andere routines.                                   }
{ RvdW 18-02-95 Uitbreiding voor Usenet: invullen UserName achtigen.      }

INTERFACE

USES Database,
     Msgs;

{ Textfile interface                                                      }
{                                                                         }
{ Geeft de mogenlijkheid om tekstfiles te importeren in een bericht en zo }
{ op een nette manier antwoord te geven op fouten.                        }

{ Zoek en vervang keywords :                                              }
{                                                                         }
{ FirstUserName  - Voornaam                                               }
{ LastUserName   - Achternaam                                             }
{ UserName       - Voor + Achternaam                                      }
{ Subject        - Onderwerp van het bericht                              }
{ Password       - Gebruikte AFix password                                }
{                                                                         }
{ Date           - Huidige SysteemDatum       ( Europees formaat ! )      }
{ Time           - Huidige Systeemtijd                                    }
{ OurAddress     - Gebruikte AKA                                          }
{ FromAddress    - Aka afzender                                           }
{                                                                         }
{ Sysop          - In config ingevoerde System operator                   }
{ SysopFirst     - Voornaam van de Sysop                                  }
{ AreaName       - Huidige Area                                           }
{ PID            - Programma naam   ( StrGate )                           }
{ Version        - Programma versie ( 1.00    )                           }
{                                                                         }
{ Tokens komen voor in de vorm @Sysop@ in een tekstfile                   }

TYPE Tokens =  (FirstUserName, LastUserName, UserName,
                Subject,       Password,     Date,
                Time,         {OurAddress,}  FromAddress,
                ToAddress,     ToUserName,   Sysop,
                SysopFirst,    AreaName,     PID,
                Version,       WeekDay,      DaysLeft);

    TokenSubSet = SET OF Tokens;

PROCEDURE InitTokens (System : SystemType);
PROCEDURE SetToken (Token : Tokens; TokenStr : STRING);
FUNCTION  AddFileToMsg (VAR Buffer : TopRegelRecordPtr; FileName : STRING) : BOOLEAN;


IMPLEMENTATION

USES Globals,
     Ramon,
     Cfg,
     Dos,
     Fido,
     FBuffer,
     Logs,
     Translat;

CONST TokenStr: ARRAY[Tokens] OF STRING[13] =
                ('FIRSTUSERNAME',
                 'LASTUSERNAME',
                 'USERNAME',
                 'SUBJECT',
                 'PASSWORD',
                 'DATE',
                 'TIME',                    {'OURADDRESS',}
                 'FROMADDRESS',
                 'TOADDRESS',
                 'TOUSERNAME',
                 'SYSOP',
                 'SYSOPFIRST',
                 'AREANAME',
                 'PID',
                 'VERSION',
                 'WEEKDAY',
                 'DAYSLEFT'
                );

      Days : ARRAY[0..6] OF STRING[9] = ('Sunday','Monday','Tuesday',
                                         'Wednesday','Thursday','Friday',
                                         'Saturday');


VAR TokenString : ARRAY[Tokens] OF STRING[50];

{-------------------------------------------------------------------------}
{ FirstName                                                               }
{                                                                         }
{ Haalt de eerste naam uit een string, en geeft die terug.                }
{ Martijn Dijksterhuis -> Martijn                                         }
{                                                                         }
FUNCTION FirstName (Name : STRING) : STRING;

VAR X : BYTE;

BEGIN
     X:=Pos (' ',Name);
     IF (X > 0) THEN
        FirstName:=Copy (Name,1,X-1)
     ELSE
         FirstName:=Name;
END;


{--------------------------------------------------------------------------}
{ LastName                                                                 }
{                                                                          }
{ Doet hetzelfde als firstname, maar dan voor het achterste gedeelte van   }
{ de naam.                                                                 }
{                                                                          }
FUNCTION LastName (Name : STRING) : STRING;

VAR X : BYTE;

BEGIN
     X:=Pos (' ',Name);
     IF (X > 0) THEN
        LastName:=Copy (Name,X,255)
     ELSE
         LastName:='';
END;


{--------------------------------------------------------------------------}
{ SetToken                                                                 }
{                                                                          }
{ Geef andere units de mogenlijkheid om een token aan te spreken.          }
{ zonder dat meteen de hele tabel (70*20 ofzo) global gemaakt moet worden  }
{                                                                          }
PROCEDURE SetToken (Token : Tokens; TokenStr : STRING);
BEGIN
     TokenString[Token]:=TokenStr;
END;


{--------------------------------------------------------------------------}
{ InitTokens                                                               }
{                                                                          }
{ Vult de token strings met nuttige informatie.                            }
{                                                                          }
PROCEDURE InitTokens (System : SystemType);

VAR Yea,Mon,Day,Dow : WordLong;
    Hou,Min,Sec,Hun : WordLong;
    Loc             : INTEGER;
    Tel             : Tokens;
    MatchAddr       : FidoAddrType;

BEGIN
     { maak alle strings schoon }
     FOR Tel:=FirstUserName TO DaysLeft DO
         TokenString[Tel]:='';

     { If FIDO }
     IF (System = _F) THEN
     BEGIN
          { namen }
          TokenString[UserName]:=Msg.FromUser_F;

          { Als er een spatie in de voornaam zit, dan splitst dit }
          { voor + achternaam.                                    }
          TokenString[FirstUserName]:=FirstName (Msg.FromUser_F);
          TokenString[LastUserName]:=LastName (Msg.FromUser_F);
          TokenString[ToUserName]:=Msg.ToUser_F;

          { bericht info }
          TokenString[Subject]:=Msg.Subj_F;
          TokenString[Password]:={Areafix.Password;}''; { komt nog }

          IF Msg.Ready_F IN [Local_Netmail,Netmail] THEN
             TokenString[AreaName]:='Netmail'
          ELSE
              TokenString[AreaName]:=Msg.Area_F;

         {FidoMatchAddress( Msg.FromAddr_F , MatchAddr );}
         {TokenString[ OurAddress ] := Fido2Str( MatchAddr );}
          TokenString[FromAddress]:=Fido2Str (Msg.FromAddr_F);
          TokenString[ToAddress]:=Fido2Str (Msg.ToAddr_F);
     END ELSE
     BEGIN
          { usenet }
          TokenString[ToAddress]:=Msg.XqtTo_U;
          TokenString[FromAddress]:=Msg.FromUser_U;

          IF (Msg.Ready_U = Mail) THEN
             TokenString[AreaName]:='E-mail'
          ELSE BEGIN
               TokenString[AreaName]:=Msg.NewsGroups_U;

               { RWI 950217: eventuele terminating #13 weghalen }
               IF (Msg.NewsGroups_U[Length (Msg.NewsGroups_U)] = #13) THEN
                  Delete (TokenString[AreaName],Length (TokenString[AreaName]),1);
          END;

          TokenString[Subject]:=Msg.Subj_U;

          { namen }
          TokenString[UserName]:=Usenet2FidoUserName (Length ('FROM:'),Msg.FromUser_U);

          { Als er een spatie in de voornaam zit, dan splitst dit }
          { voor + achternaam.                                    }
          TokenString[FirstUserName]:=FirstName (TokenString[UserName]);
          TokenString[LastUserName]:=LastName (TokenString[UserName]);
          TokenString[ToUserName]:=Msg.ToUser_U;

          { bericht info }
          TokenString[Subject]:=Msg.Subj_F;
          TokenString[Password]:={newsfix pwd}''; { komt nog }
     END;

     { Globals }
     { Datum + Tijd }
     GetDate (Yea,Mon,Day,Dow);
     TokenString[Date]:=Word2String (Day)+' '+Month[Mon]+' '+Word2String (Yea);
     TokenString[WeekDay]:=Days[Dow];

     GetTime (Hou,Min,Sec,Hun);
     TokenString[Time]:=Word2String (Hou);
     IF (Min < 10) THEN
        TokenString[Time]:=TokenString[Time]+':0'+Word2String (Min)
     ELSE
         TokenString[Time]:=TokenString[Time]+':'+Word2String (Min);

     { Etc }
     TokenString[Version]:=MainVersionNr;
     TokenString[PID]:=DesktopProgramName;
     TokenString[Sysop]:=Config.Sysop;
     TokenString[SysopFirst]:=FirstName (Config.Sysop);
END;


{--------------------------------------------------------------------------}
{ AddFileToMsg                                                             }
{                                                                          }
{ Deze routine probeert een tekstfile te open in de systeem directory      }
{ en deze toe te voegen aan het te versturen bericht. De tekstfile         }
{ hierbij doorlopen op zoek naar @Tokens.                                  }
{                                                                          }
{ De routine geeft False terug als de file niet geopend kon worden.        }
{                                                                          }
FUNCTION AddFileToMsg (VAR Buffer : TopRegelRecordPtr; FileName : STRING) : BOOLEAN;

CONST REPLACER = #0;

VAR Textfile  : TEXT;
    Token,
    Regel     : STRING;
    IORes     : INTEGER;
    Found     : BOOLEAN;
    Tel_Token : Tokens;
    Tel_Char  : BYTE;

BEGIN
     { - Probeer de tekstfile te openen }
     { Gebruik niet de buffer routine, omdat die op hol slaat bij }
     { CR/LF combinaties.                                         }

     IF (Pos ('\',FileName) = 0) THEN
        Assign (TextFile,Config.SystemDir+'TXTS\'+FileName)
     ELSE
         Assign (TextFile,FileName);

     {$I-} Reset (TextFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          { Textfiles zijn meestal optioneel }
          AddFileToMsg:=FALSE;
          Exit;
     END;

     { - Bingo ! Probeer hem in te lezen }
     WHILE (NOT Eof (Textfile)) DO
     BEGIN
          { lees een regel in uit de tekstfile }
          ReadLn (Textfile,Regel);

          { scannen op tokens }
          WHILE (Pos ('@',Regel) > 0) DO
          BEGIN
               Tel_Char:=Pos ('@',Regel);

               { probeer token uit de string te snijden }
               Token:=Copy (Regel,Tel_Char+1,Length (Regel));
               Token:=Copy (Token,1,Pos ('@',Token)-1);
               Regel[Pos ('@',Regel)]:=REPLACER; { Bugfix, anders oneindige lus }
               Token:=UpCaseString (Token);

               { En kijk welk teken we gaan vervangen  }
               FOR Tel_Token:=FirstUserName TO DaysLeft DO
                   IF (Token = TokenStr[Tel_Token]) THEN
                   BEGIN
                        Delete (Regel,Tel_Char,Length (Token)+2);
                        Insert (TokenString[Tel_Token],Regel,Tel_Char);
                        Break; { uit de for }
                   END;
          END; { while }

          { nu alle REPLACER tekens weer terug vervangen in @-tjes }
          WHILE (Pos (REPLACER,Regel) > 0) DO
                Regel[Pos (REPLACER,Regel)]:='@';

          AddToLineBuffer (Buffer,Regel);
     END; { while not eof }

     Close (Textfile);
     AddFileToMsg:=TRUE; { done that }
END;


END.
