{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT Stats;

{ statistieken unit van WtrGate }

{ History:

RvdW 06-06-93 Met deze unit en de statistieken uberhaupt begonnen.
MD   16-09-93 Bugfix, Word2String waar een LongInt2String hoorde
                      hierdoor kreeg >64Kb een overflow. Ik zocht de
                      bug eerst ergens anders, waardoor ook de Squish
                      routines nu een major bug minder bevatten.
RvdW 941126 Statistics file wordt nu gemaakt ahv logfile path, maar dan
            met .STA als extensie.
}

{ positie van de UpdateXXXXStats calls:

User:
MailTo    MSGS    MsgsExportUsenetMail
MailFrom  USENET  UseNetTossMailDFile
NetTo     nog nergens
NetFrom   nog nergens
NewsTo    MSGS    MsgsExportInUseNetStyle
NewsFrom  MSGS    MsgsExport
EchoTo    MSGS    MsgsExportInFidoStyle
EchoFrom  FIDO    ProcessPktFile

Area:
AreaFlow  FIDO  ProcessPktFile
NewsFlow  MSGS  MsgsExportInUseNetStyle

}


INTERFACE

USES Database;

CONST UserSegSize = 10;    { max 255, ivm BYTE teller }
      AreaSegSize = 50;    { max 255, ivm BYTE teller }

TYPE StatsUpdateUserType = (MailTo,MailFrom,NewsTo,NewsFrom, { usenet }
                            NetTo,NetFrom,EchoTo,EchoFrom);  { fido }

     AreaSegDataRecord = RECORD
                               AreaRecNr : AreaBaseRecordNrType;
                               Flow      : LONGINT;
                               Count     : WORD; { aantal berichten }
                         END;

     UserSegDataRecord = RECORD
                               UserRecNr : UserBaseRecordNrType;

                               { lengte van de berichten }
                               lMailTo,
                               lMailFrom,
                               lNewsTo,
                               lNewsFrom,
                               lNetTo,
                               lNetFrom,
                               lEchoTo,
                               lEchoFrom  : LONGINT;

                               { aantal berichten }
                               nMailTo,
                               nMailFrom,
                               nNewsTo,
                               nNewsFrom,
                               nNetTo,
                               nNetFrom,
                               nEchoTo,
                               nEchoFrom  : WORD;
                         END;

     UserSegmentPtr = ^UserSegment;
     UserSegment = RECORD
                         UsersCount     : BYTE;
                         Users          : ARRAY[1..UserSegSize] OF UserSegDataRecord;
                         NextUserSegPtr : UserSegmentPtr;
                   END;

     {AreaSegDataRecord = RECORD
                               AreaRecNr : AreaBaseRecordNrType;
                               Flow      : LONGINT;
                         END;}

     AreaSegmentPtr = ^AreaSegment;
     AreaSegment = RECORD
                         AreasCount     : BYTE;
                         Areas          : ARRAY[1..AreaSegSize] OF AreaSegDataRecord;
                         NextAreaSegPtr : AreaSegmentPtr;
                   END;

VAR FirstUserSegPtr : UserSegmentPtr;
    FirstAreaSegPtr : AreaSegmentPtr;


PROCEDURE StatsInit;
PROCEDURE StatsEnd;

PROCEDURE StatFidoSendNetmail;
PROCEDURE StatUsenetSendMail;

(*
PROCEDURE StatNetmail ( FromAddr , FromUser , ToAddr , ToUser )
PROCEDURE StatEMail   ( FromAddr , FromUser , ToAddr , ToUser )
*)

PROCEDURE UpdateUserStats (UserRecNr  : UserBaseRecordNrType;
                           UpdateWhat : StatsUpdateUserType;
                           Aantal     : LONGINT);
PROCEDURE UpdateAreaStats (AreaRecNr : AreaBaseRecordNrType;
                           Aantal    : LONGINT);


IMPLEMENTATION

USES Dos,
     Cfg,
     Logs,
     AreaBase,
     UserBase,
     Ramon,
     Fido,
     Globals,
     Msgs,
     Usenet,
     ListSrv;

{CONST StatsFilename = 'WTRGATE.STA'; komt nu bij logfile path als .STA }

VAR OutFile : TEXT;

{--------------------------------------------------------------------------}
{ StatsInit                                                                }
{                                                                          }
{ Deze routine moet worden aangeroepen om de statistieken te op te starten }
{ voordat het tossen begint. Er wordt om te beginnen 1 segment aangemaakt  }
{ waarin areanaam indexen en aantallen opgeslagen kunnen worden voor de    }
{ newsgroups en hetzelfde voor de nodes. Deze tabellen kunnen onderweg met }
{ een segment worden uitgebreid als er meer gegevens langskomen. Ieder     }
{ segment heeft het SegUserSize of SegAreaSize aantal entries.             }
{                                                                          }
PROCEDURE StatsInit;

VAR Dir     : DirStr;
    Name    : NameStr;
    Ext     : ExtStr;
    StaPath : FilePathStr;
    IORes   : BYTE;
    NewFile : BOOLEAN;

BEGIN
     GetMem (FirstUserSegPtr,SizeOf (UserSegment));
     WITH FirstUserSegPtr^ DO
     BEGIN
          UsersCount:=0;
          NextUserSegPtr:=NIL;
     END; { with }

     GetMem (FirstAreaSegPtr,SizeOf (AreaSegment));
     WITH FirstAreaSegPtr^ DO
     BEGIN
          AreasCount:=0;
          NextAreaSegPtr:=NIL;
     END; { with }

     PeekMem;

     NewFile:=FALSE;

     { Creeren van de statistieken file hiernaar toe verplaatst }
     FSplit (FExpand (Config.LogfilePath),Dir,Name,Ext);
     StaPath:=Dir+Name+'.STA';
     Assign (OutFile,StaPath);
     {$I-} Append (OutFile); {$I+} IORes:=IOResult;
     IF (IORes = 2) THEN
     BEGIN
          {$I-} ReWrite (OutFile); {$I+} IORes:=IOResult;
          IF (IORes <> 0) THEN
             LogDiskIOError (IORes,'Error creating stats file '+StaPath);
          NewFile:=TRUE;
     END ELSE
         IF (IORes <> 0) THEN
            LogDiskIOError (IORes,'Error appending to file '+StaPath);

     IF (IORes = 0) THEN
     BEGIN
          WriteLn (OutFile,'Statistics report of toss on '+DateStamp+' '+TimeStamp);

          IF NewFile THEN
          BEGIN
               WriteLn (OutFile,'Order: u MailToFlow  MailFromFlow  NewsToFlow  NewsFromFlow  ...');
               WriteLn (OutFile,'         NetToFlow   NetFromFlow   EchoToFlow  EchoFromFlow  SystemName');
               WriteLn (OutFile,'       v MailToCount MailFromCount NewsToCount NewsFromCount ...');
               WriteLn (OutFile,'         NetToCount  NetFromCount  EchoToCount EchoFromCount SystemName');
               WriteLn (OutFile,'       b Msgs Flow FidoAreaName [UUCPAreaName]');
               Writeln (OutFile,'       n/m MsgSize MsgTo (MsgFrom@System | MsgFrom%FidoAddr)');
          END;
     END;
END;


{--------------------------------------------------------------------------}
{ StatsEnd                                                                 }
{                                                                          }
{ Deze routine moet worden aangeroepen als het tossen beeindigd wordt. De  }
{ gelogde gegevens worden hier naar disk geschreven, naar de file die      }
{ in de constante globale variabele StatsFilename staat. Voor iedere       }
{ newsgroup waarin iets is langsgekomen wordt de naam + aantal bytes in    }
{ de log geschreven, in tekst vorm. Voor iedere node die news of mail      }
{ heeft gestuurd of gekregen gebeurt hetzelfde. Aan het einde wordt al het }
{ geheugen weer vrijgegeven. De databases moeten nog open zijn bij aanroep }
{ van deze routine.                                                        }
{                                                                          }
PROCEDURE StatsEnd;

CONST WRITE_STA_MSG = 'Writing to the statistics file';

VAR ErasePtr       : POINTER;
    IORes          : BYTE;
    Lp             : BYTE;
    CurrUserSegPtr : UserSegmentPtr;
    CurrAreaSegPtr : AreaSegmentPtr;
    SysDescr       : STRING;
    MemStats       : LONGINT;

BEGIN
     { RWI 961109: ivm met crashes in dit gebied, schrijf naar de logfile }
     {             dat de statistieken naar disk worden geschreven. Sluit }
     {             daarna de logfile, zodat er niets achter blijft.       }
     LogMessage (WRITE_STA_MSG);
     LogClose; { flush to disk, in case of crashes }

     Message (WRITE_STA_MSG);

     CurrUserSegPtr:=FirstUserSegPtr;
     WHILE (CurrUserSegPtr <> NIL) DO
           WITH CurrUserSegPtr^ DO
           BEGIN
                FOR Lp:=1 TO UsersCount DO
                BEGIN
                     SysDescr:='?';  { RWi 961103: added for security }

                     { maak de system description }
                     IF (Users[Lp].UserRecNr = NILRecordNr) THEN
                        SysDescr:='LOCAL ('+DeleteBackSpaces (Config.Sysop)+')'
                     ELSE BEGIN
                          ReadUserBaseRecord (Users[Lp].UserRecNr,UserData);

                          CASE UserData.System OF
                               _F :
                                   SysDescr:=Fido2Str (UserData.Address)+
                                             ' ('+DeleteBackSpaces (UserData.Sysop)+')';

                               _B : { RWI 950603: _B toegevoegd }
                                   SysDescr:='BAG: '+UserData.UUCPName+' ('+UserData.Organization+')';

                               _S : { RWI 961102: _S toegevoegd }
                                   SysDescr:='SMTP: '+UserData.UUCPName+' ('+UserData.Organization+')';

                               _U :
                                   SysDescr:=UserData.UUCPName+' ('+UserData.Organization+')';

                               _P :
                                   SysDescr:=UserData.Recipient+' (POP3)';

                               _BBS :
                                   SysDescr:=Word2String (UserData.FakeZone)+':'+
                                             Word2String (UserData.FakeNet)+'/'+
                                             Word2String (UserData.FakeNode)+' (BBS Interface)';
                          END;
                     END; { IF Local }

                     { RWI 961102: added WITH }
                     WITH Users[Lp] DO
                     BEGIN
                          WriteLn (OutFile,'u '+Longint2String (lMailTo),' ',
                                                Longint2String (lMailFrom),' ',
                                                Longint2String (lNewsTo),' ',
                                                Longint2String (lNewsFrom),' ',
                                                Longint2String (lNetTo),' ',
                                                Longint2String (lNetFrom),' ',
                                                Longint2String (lEchoTo),' ',
                                                Longint2String (lEchoFrom),' ',
                                                SysDescr);

                          WriteLn (OutFile,'v '+Longint2String (nMailTo),' ',
                                                Longint2String (nMailFrom),' ',
                                                Longint2String (nNewsTo),' ',
                                                Longint2String (nNewsFrom),' ',
                                                Longint2String (nNetTo),' ',
                                                Longint2String (nNetFrom),' ',
                                                Longint2String (nEchoTo),' ',
                                                Longint2String (nEchoFrom),' ',
                                                SysDescr);
                     END; { with }
                END; { for }

                CurrUserSegPtr:=NextUserSegPtr;
           END; { with, while }

     CurrAreaSegPtr:=FirstAreaSegPtr;
     WHILE (CurrAreaSegPtr <> NIL) DO
           WITH CurrAreaSegPtr^ DO
           BEGIN
                FOR Lp:=1 TO AreasCount DO
                BEGIN
                     ReadAreaBaseRecord (Areas[Lp].AreaRecNr,AreaData);
                     {
                     WriteLn (OutFile,'a '+LongInt2String (Areas[Lp].Flow)+' '+AreaData.AreaName_F);
                     }
                     SysDescr:=AreaData.AreaName_F;
                     IF (AreaData.AreaName_F <> AreaData.AreaName_U) THEN
                        SysDescr:=SysDescr+' '+AreaData.AreaName_U;

                     WriteLn (OutFile,'b '+Longint2string (Areas[Lp].Count),' ',
                                           LongInt2String (Areas[Lp].Flow),' ',
                                           SysDescr);
                END;

                CurrAreaSegPtr:=NextAreaSegPtr;
           END; { with, while }

     WriteLn (OutFile);
     Close (OutFile);

     MemStats:=0;

     WHILE (FirstUserSegPtr <> NIL) DO
     BEGIN
          ErasePtr:=FirstUserSegPtr;
          FirstUserSegPtr:=FirstUserSegPtr^.NextUserSegPtr;
          FreeMem (ErasePtr,SizeOf (UserSegment));
          Inc (MemStats,SizeOf (UserSegment));
     END; { while }

     WHILE (FirstAreaSegPtr <> NIL) DO
     BEGIN
          ErasePtr:=FirstAreaSegPtr;
          FirstAreaSegPtr:=FirstAreaSegPtr^.NextAreaSegPtr;
          FreeMem (ErasePtr,SizeOf (AreaSegment));
          Inc (MemStats,SizeOf (AreaSegment));
     END; { while }

     IF DebugMem THEN
        LogExtraMessage (MEMUSEFOR+'Statistics = '+Longint2String (MemStats));

     WindowPop; { message }
END;


{--------------------------------------------------------------------------}
{ UpdateUserStats                                                          }
{                                                                          }
{ Met deze routine kunnen de user statistieken worden geupdate. De enum    }
{ geeft aan welke teller verhoogd moet worden. Deze routine zoekt het      }
{ record van de user, mits deze bestaat, anders wordt ie aangemaakt.       }
{ Daarna worden de juiste gegevens verhoogd.                               }
{                                                                          }
PROCEDURE UpdateUserStats (UserRecNr  : UserBaseRecordNrType;
                           UpdateWhat : StatsUpdateUserType;
                           Aantal     : LONGINT);

VAR CurrUserSegPtr : UserSegmentPtr;
    Found          : BOOLEAN;
    Lp             : BYTE;

BEGIN
     CurrUserSegPtr:=FirstUserSegPtr;

     Found:=FALSE;
     WHILE (CurrUserSegPtr <> NIL) DO
           WITH CurrUserSegPtr^ DO
           BEGIN
                FOR Lp:=1 TO UsersCount DO
                    IF (Users[Lp].UserRecNr = UserRecNr) THEN
                    BEGIN
                         Found:=TRUE;
                         Break; { for }
                    END;

                IF Found THEN
                   Break; { while }

                CurrUserSegPtr:=CurrUserSegPtr^.NextUserSegPtr;
           END; { with, while }

     IF (NOT Found) THEN
     BEGIN
          { zoek naar een plekje in een van de segmenten }
          CurrUserSegPtr:=FirstUserSegPtr;

          WHILE (CurrUserSegPtr <> NIL) DO
                WITH CurrUserSegPtr^ DO
                BEGIN
                     IF (UsersCount < UserSegSize) THEN
                     BEGIN
                          Inc (UsersCount);

                          Users[UsersCount].UserRecNr:=UserRecNr;
                          WITH Users[UsersCount] DO
                          BEGIN
                               lMailTo:=0;
                               lMailFrom:=0;
                               lNewsTo:=0;
                               lNewsFrom:=0;
                               lNetTo:=0;
                               lNetFrom:=0;
                               lEchoTo:=0;
                               lEchoFrom:=0;

                               nMailTo:=0;
                               nMailFrom:=0;
                               nNewsTo:=0;
                               nNewsFrom:=0;
                               nNetTo:=0;
                               nNetFrom:=0;
                               nEchoTo:=0;
                               nEchoFrom:=0;
                          END; { with 2 }

                          Lp:=UsersCount;
                          Break; { while }
                     END; { plekje vrij }

                     IF (NextUserSegPtr = NIL) THEN
                     BEGIN
                          { aan het einde, maak een nieuw segment aan }
                          GetMem (NextUserSegPtr,SizeOf (UserSegment));
                          NextUserSegPtr^.UsersCount:=0;
                          NextUserSegPtr^.NextUserSegPtr:=NIL;
                     END;

                     CurrUserSegPtr:=NextUserSegPtr;
                END; { with, while }
     END; { not found }

     { CurrUserSegPtr, Lp = Index to user data }
     WITH CurrUserSegPtr^ DO
          CASE UpdateWhat OF
               MailTo   : BEGIN
                               Inc (Users[Lp].lMailTo,Aantal);
                               Inc (Users[Lp].nMailTo);
                          END;

               MailFrom : BEGIN
                               Inc (Users[Lp].lMailFrom,Aantal);
                               Inc (Users[Lp].nMailFrom);
                          END;

               NewsTo   : BEGIN
                               Inc (Users[Lp].lNewsTo,Aantal);
                               Inc (Users[Lp].nNewsTo);
                          END;

               NewsFrom : BEGIN
                               Inc (Users[Lp].lNewsFrom,Aantal);
                               Inc (Users[Lp].nNewsFrom);
                          END;

               NetTo    : BEGIN
                               Inc (Users[Lp].lNetTo,Aantal);
                               Inc (Users[Lp].nNetTo);
                          END;

               NetFrom  : BEGIN
                               Inc (Users[Lp].lNetFrom,Aantal);
                               Inc (Users[Lp].nNetFrom);
                          END;

               EchoTo   : BEGIN
                               Inc (Users[Lp].lEchoTo,Aantal);
                               Inc (Users[Lp].nEchoTo);
                          END;

               EchoFrom : BEGIN
                               Inc (Users[Lp].lEchoFrom,Aantal);
                               Inc (Users[Lp].nEchoFrom);
                          END;

          END; { case,with }
END;


{--------------------------------------------------------------------------}
{ UpdateAreaStats                                                          }
{                                                                          }
{ Deze routine houdt de gegevens bij voor de areas. Aan de hand van het    }
{ database record nummer wordt het bijbehorende record opgezocht en als    }
{ het nog niet bestaat, aangemaakt. Daarna wordt de flow-teller verhoogd   }
{ met het opgegeven aantal.                                                }
{                                                                          }
PROCEDURE UpdateAreaStats (AreaRecNr : AreaBaseRecordNrType;
                           Aantal    : LONGINT);

VAR CurrAreaSegPtr : AreaSegmentPtr;
    Found          : BOOLEAN;
    Lp             : BYTE;

BEGIN
     CurrAreaSegPtr:=FirstAreaSegPtr;

     Found:=FALSE;
     WHILE (CurrAreaSegPtr <> NIL) DO
           WITH CurrAreaSegPtr^ DO
           BEGIN
                FOR Lp:=1 TO AreasCount DO
                    IF (Areas[Lp].AreaRecNr = AreaRecNr) THEN
                    BEGIN
                         Found:=TRUE;
                         Break;
                    END;

                IF Found THEN
                   Break;

                CurrAreaSegPtr:=NextAreaSegPtr;
           END; { with, while }

     IF (NOT Found) THEN
     BEGIN
          { zoek een record met plaats, of maak een nieuwe aan }
          CurrAreaSegPtr:=FirstAreaSegPtr;

          WHILE (CurrAreaSegPtr <> NIL) DO
                WITH CurrAreaSegPtr^ DO
                BEGIN
                     IF (AreasCount < AreaSegSize) THEN
                     BEGIN
                          Inc (AreasCount);

                          Areas[AreasCount].AreaRecNr:=AreaRecNr;
                          Areas[AreasCount].Flow:=0;
                          Areas[AreasCount].Count:=0;

                          Lp:=AreasCount; { voor gebruik buiten dit block }
                          Break; { while }
                     END; { plekje vrij }

                     IF (NextAreaSegPtr = NIL) THEN
                     BEGIN
                          { nieuw segment aanmaken }
                          GetMem (NextAreaSegPtr,SizeOf (AreaSegment));
                          NextAreaSegPtr^.AreasCount:=0;
                          NextAreaSegPtr^.NextAreaSegPtr:=NIL;
                     END;

                     CurrAreaSegPtr:=NextAreaSegPtr;
                END; { with, while }
     END; { not found }

     { CurrAreaRecPtr en Lp zijn de indexen }
     Inc (CurrAreaSegPtr^.Areas[Lp].Flow,Aantal);
     Inc (CurrAreaSegPtr^.Areas[Lp].Count);
END;


{-------------------------------------------------------------------------}
{ StatFidoSendNetmail                                                     }
{                                                                         }
{ Schrijft een entry naar de logfile met informatie over een verzonden    }
{ netmail bericht.                                                        }
{                                                                         }
{ m <MsgSize> <ToAddr> <User@Domain|User%FidoAddr>                        }
{                                                                         }
PROCEDURE StatFidoSendNetmail;

VAR Regel : STRING;
    Sum   : LONGINT;
    IORes : BYTE;

BEGIN
     { RWI 960310: controle op NIL voor ieder blok, ivm rare tellingen }
     {             bij lege berichten.                                 }
     Sum:=0;

     IF (Msg.HeaderTop_F <> NIL) THEN
        Sum:=Sum+Msg.HeaderTop_F^.TotalRegelLength;

     IF (Msg.BodyTop <> NIL) THEN
        Sum:=Sum+Msg.BodyTop^.TotalRegelLength;

     IF (Msg.FooterTop_F <> NIL) THEN
        Sum:=Sum+Msg.FooterTop_F^.TotalRegelLength;

     Regel:='n '+Longint2String (Sum)+' '+Msg.ToUser_F+'%'+Fido2Str (Msg.ToAddr_F)+' (';

     { als het een usenet source bericht was, dan is Ready_U gezet }
     IF Msg.ListServer THEN
        Regel:=Regel+'Mailing list '+ListMainRec.ListName+')'
     ELSE BEGIN
          IF (Msg.Ready_U = Mail) THEN
             Regel:=Regel+UseGetAddress (Copy (Msg.FromUser_U,7,255))+')'
          ELSE
              Regel:=Regel+Msg.FromUser_F+'%'+Fido2Str (Msg.FromAddr_F)+')';
     END;

     {$I-} WriteLn (OutFile,Regel); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'Error writing to stats file');
END;


{-------------------------------------------------------------------------}
{ StatUsenetSendMail                                                      }
{                                                                         }
{ Schrijft een entry naar de logfile met informatie over een verzonden    }
{ netmail bericht.                                                        }
{                                                                         }
{ m <MsgSize> <ToAddr_U> <User@Domain|User%FidoAddr>                      }
{                                                                         }
PROCEDURE StatUsenetSendMail;

VAR Regel : STRING;
    Sum   : LONGINT;

BEGIN
     { RWI 960310: controle op NIL }
     Sum:=0;
     IF (Msg.HeaderTop_U <> NIL) THEN
        Sum:=Sum+Msg.HeaderTop_U^.TotalRegelLength;
     IF (Msg.BodyTop <> NIL) THEN
        Sum:=Sum+Msg.BodyTop^.TotalRegelLength;

     Regel:='m '+Longint2String (Sum)+' '+Msg.XqtTo_U+' (';

     { Als het een usenet source bericht was, dan is Ready_U gezet }

     IF Msg.ListServer THEN
        Regel:=Regel+'Mailing list '+ListMainRec.ListName+')'
     ELSE BEGIN
          IF (Msg.Ready_F  IN [NetMail,Local_Netmail]) THEN
             Regel:=Regel+Msg.FromUser_F+'%'+Fido2Str (Msg.FromAddr_F)+')'
          ELSE
              Regel:=Regel+UseGetAddress (Copy (Msg.FromUser_U,7,255))+')';
     END;

     WriteLn (OutFile,Regel);
END;


{--------------------------------------------------------------------------}
{ unit initialization                                                      }
{                                                                          }
{ Hier worden de First pointers op NIL gezet, zodat StatsInitEnd niet op   }
{ zijn bek kan gaan.                                                       }
{                                                                          }
BEGIN
     FirstUserSegPtr:=NIL;
     FirstAreaSegPtr:=NIL;
END.
