{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT ReadRout;

{ deze file bevat de code die de routing table inleest. Aangezien dit }
{ alleen aan het begin van wtrgate.exe nodig is, gaat deze code in de }
{ overlay en wordt ie maar e'e'n keer aangeroepen.                    }

INTERFACE

USES Ramon,
     Database;


PROCEDURE InitRoutingTable;
PROCEDURE JunkRoutingTable;


TYPE RouteRecordPtr = ^RouteRecord;
     RouteRecord    = RECORD
{ 1 = 2:All 2 = 2:280/All } Level              : BYTE;
{ adres masker }            MaskFidoAddr,
{ via adres }               ViaFidoAddr        : FidoAddrType;
                            NextRouteRecordPtr : RouteRecordPtr;
                      END;

     MapValidType   = (UUCP_Map_Both,UUCP_Map_FU,UUCP_Map_UF);
     MapRecordPtr   = ^MapRecord;
     MapNameField   = STRING[60];

     MapRecord = RECORD
                       LType,
                       RType       : BYTE;
                       MapType     : MapValidType;
                       LFidoAddr,
                       RFidoAddr   : FidoAddrType;
                       LName,
                       RName       : MapNameField;
                 END;

     SignaturePtr    = ^SignatureRecord;
     SignatureRecord = RECORD
                             Level    : BYTE;        { 255 = e-mail address }
                             Address  : FidoAddrType;
                             UserName : STRING[80];  { now user@adress or User Name }
                             Path     : STRING[79];
                       END;

     FilterOptionType = (foEXACT,foPLUSBELOW,foBELOWONLY);

     FilterPtr    = ^FilterRecord;
     FilterRecord = RECORD
                          NamePtr : StringPtr;
                          Allow   : BOOLEAN; { FALSE = Exclude }
                          Option  : FilterOptionType;
                          LineNr  : WORD;
                          PathPtr : StringPtr;
                    END;

     SendFilePtr    = ^SendFileRecord;
     SendFileRecord = RECORD
                            Username  : STRING[MaxLenUserName];
                            FilePath  : STRING[80];
                            ForceText : BOOLEAN;
                      END;

     SaveFilePtr    = ^SaveFileRecord;
     SaveFileRecord = RECORD
                            EmailAddress : STRING[60];
                            Directory    : STRING[80];
                            SaveFrom     : BOOLEAN;
                      END;

     BouncePtr    = ^BounceRecord;
     BounceRecord = RECORD
                          EmailAddress : STRING[60];
                          Reason       : STRING[80];
                          FromBounce   : BOOLEAN;
                          WildMatch    : BOOLEAN; { * aan begin? }
                    END;

     MapAreaPtr    = ^MapAreaRecord;
     MapAreaRecord = RECORD
                           EMailAddress : STRING[60];
                           AreaIndex    : LONGINT;
                           ReplyAddr    : STRING[60];
                     END;

     MailTunnelIOType = (mtFrom,mtTo);
     MailTunnelPtr    = ^MailTunnelRecord;
     MailTunnelRecord = RECORD
                              FromOrTo     : MailTunnelIOType;
                              FidoAddress  : FidoAddrType;
                              EMailAddress : STRING[60];
                              ArchiveName  : STRING[8];
                              MinimumSize  : BYTE; { 0..255 kb }
                              ExtractPath  : FilePathStr;
                        END;

     ForcePackPtr    = ^ForcePackRecord;
     ForcePackRecord = RECORD
                             FidoAddr : FidoAddrType;
                       END;

IMPLEMENTATION

USES Dos,
     Fido,
     UserBase,
     UUCPRout,
     Routing,
     Logs,
     Globals,
     Cfg,
     Gateway,
     MakeOut;

CONST NotRegMaxLimit = 'statements when not registered!';

VAR MemSignatures,
    MemRouting,
    MemMapping,
    MemSendfile,
    MemFilter,
    MemTunnel       : LONGINT;


{--------------------------------------------------------------------------}
{ SubStractMapField                                                        }
{                                                                          }
FUNCTION SubStractMapField (VAR Inf : STRING) : STRING;

VAR P : BYTE;

BEGIN
     Inf:=DeleteFrontSpaces (DeleteBackSpaces (Inf));

     { Zoek naar de volgende string: }
     {                               }
     { domainadres                   }
     { user@domainadres              }
     { "user"                        }
     { "user"@fidoadres              }

     { Zoek naar de '"' }
     P:=1;
     IF (Inf[1] = '"') THEN
     BEGIN
          P:=2;

          WHILE (P <= Length (Inf)) AND (Inf[P] <> '"') DO
                Inc (P);

          IF (P = Length (Inf)) AND (Inf[P] <> '"') THEN   {invalid?}
          BEGIN
               Inf:=''; {invalid!}
               Exit;
          END;
     END;

     { Zoek naar een spatie of het einde van de string }
     WHILE (P <= Length (Inf)) AND (Inf[P] <> ' ') DO
           Inc (P);

     SubStractMapField:=DeleteBackSpaces (Copy (Inf,1,P));
     { Inf := Copy( Inf , P + 1 , 255 ); }
END;


{--------------------------------------------------------------------------}
{ ParseMapLine                                                             }
{                                                                          }
{ Een veld kan de volgende formaten hebben :                               }
{                                                                          }
{  1 - "UserName"           2 - domainadres       3 - user@domainadres     }
{    - "UserName"%FidoAddr                                                 }
{    - FidoAddr (contains ':' or '/' ?)                                    }
{                                                                          }
PROCEDURE ParseMapLine (OrgInf : STRING; VAR Tiepe : BYTE; VAR Name : MapNameField; VAR Adres : FidoAddrType);

VAR X   : BYTE;
    Inf : STRING;

BEGIN
     Name:='';
     Inf:=DeleteBackSpaces (OrgInf);
     FidoSplit ('0',Adres);

     { Kijk of we " " tegenkomen }
     IF (Inf[1] = '"') THEN
     BEGIN
          Tiepe:=1;
          X:=Pos ('"',Copy (Inf,2,42));
          IF (X = 0) THEN
          BEGIN
               LogMessage ('Invalid name in following MAP line:');
               LogExtraMessage (OrgInf);
               Exit;
          END;

          Name:=Copy (Inf,2,X-1);
          X:=Pos ('%',Inf);
          IF (X > 0) THEN
          BEGIN
               FidoSplit (Copy (Inf,X+1,255),Adres);
               IF (Adres.Zone = 0) THEN
               BEGIN
                    LogMessage ('Invalid Fido adres in following MAP line:');
                    LogExtraMessage (OrgInf);
               END;
          END;

          Exit;
     END;

     IF (Pos ('/',Inf) > 0) THEN                { z:n/n.p ? }
     BEGIN
          FidoSplit (Inf,Adres);
          Tiepe:=1;
     END ELSE
     BEGIN
          Name:=Inf;
          IF (Pos ('@',Inf) > 0) THEN           { jaap@aap ? }
             Tiepe:=3
          ELSE
              Tiepe:=2;                         { aap.wlink? }
     END;
END;


{--------------------------------------------------------------------------}
{ CleanMapRecord                                                           }
{                                                                          }
PROCEDURE CleanMapRecord (MapPtr : MapRecordPtr);
BEGIN
     WITH MapPtr^ DO
     BEGIN
          LType:=0;
          RType:=0;
          FidoSplit ('0',LFidoAddr);
          FidoSplit ('0',RFidoAddr);
          LName:='';
          RName:='';
     END;
END;


{--------------------------------------------------------------------------}
{ AddMapFidoLine                                                           }
{                                                                          }
{ Voegt een lijn met een fidoadres toe aan het geheel.                     }
{                                                                          }
PROCEDURE AddMapFidoLine (OrgLine : STRING);

VAR Zoek,
    Tmp      : MapRecordPtr;
    FidoAddr : FidoAddrType;
    TmpLine  : STRING;
    Line     : STRING;

LABEL ClearUp,
      ClearUp2;

BEGIN
     Line:=OrgLine;
     GetMem (Tmp,SizeOf (MapRecord));
     CleanMapRecord (Tmp);

     TmpLine:=SubStractMapField (Line);

     IF (Line = '') THEN
        GOTO ClearUp;

     ParseMapLine (TmpLine,Tmp^.LType,Tmp^.LName,Tmp^.LFidoAddr);
     Tmp^.MapType:=UUCP_Map_Both;
     Delete (Line,1,Length (Tmpline));

     IF (Tmp^.LType <> 1) THEN
        GOTO ClearUp;

     TmpLine:=SubStractMapField (Line);

     IF (TmpLine = '') THEN
        GOTO ClearUp;

     ParseMapLine (TmpLine,Tmp^.RType,Tmp^.RName,Tmp^.RFidoAddr);

     IF (Tmp^.LType = 2) THEN
        GOTO ClearUp;

     { kijk of deze al bestaat }
     Zoek:=FidoMappingList.GetFirstItem;
     WHILE (Zoek <> NIL) DO
     BEGIN
          IF (Tmp^.MapType = Zoek^.MapType) AND
             (Tmp^.LType   = Zoek^.LType) AND
             (Tmp^.LName   = Zoek^.LName) AND
             (Tmp^.RType   = Zoek^.RType) AND
             (Tmp^.RName   = Zoek^.RName) AND
             FidoCompare (Tmp^.LFidoAddr,Zoek^.LFidoAddr) AND
             FidoCompare (Tmp^.RFidoAddr,Zoek^.RFidoAddr) THEN
          BEGIN
               LogMessage ('Following MAP-FIDO line is a duplicate:');
               GOTO ClearUp2;
          END;

          Zoek:=FidoMappingList.GetNextItem;
     END;

     FidoMappingList.Add (Tmp);
     Inc (MemMapping,SizeOf (MapRecord)+4);
     Exit;

ClearUp:
     LogMessage ('Following MAP-FIDO line is invalid:');

ClearUp2:
     LogExtraMessage (OrgLine);

     FreeMem (Tmp,SizeOf (MapRecord));
END;


{--------------------------------------------------------------------------}
{ AddMapUUCPLine                                                           }
{                                                                          }
{ Voegt een lijn met een fidoadres toe aan het geheel.                     }
{                                                                          }
PROCEDURE AddMapUUCPLine (OrgLine : STRING);

VAR Zoek,
    Tmp      : MapRecordPtr;
    FidoAddr : FidoAddrType;
    TmpLine  : STRING;
    Line     : STRING;

LABEL ClearUp,
      ClearUp2;

BEGIN
     Line:=OrgLine;
     GetMem (Tmp,SizeOf (MapRecord));
     CleanMapRecord (Tmp);

     TmpLine:=SubStractMapField (Line);

     IF (Line = '') THEN
        GOTO ClearUp;

     { Kijk of er aan het begin van de lijn mapping restricties staan }
     {                                                                }
     { -FU   dit commando geld alleen voor Fido -> Usenet mappings    }
     { -UF   dit commando geld alleen voor Usenet -> Fido mappings    }
     Tmp^.MapType:=UUCP_Map_Both;

     IF (UpCaseString (Copy (TmpLine,1,3)) = '-FU') THEN
     BEGIN
          Delete (Line,1,3);
          Tmp^.MapType:=UUCP_Map_FU;
     END;

     IF (UpCaseString (Copy (TmpLine,1,3)) = '-UF') THEN
     BEGIN
          Delete (Line,1,3);
          Tmp^.MapType:=UUCP_Map_UF;
     END;

     TmpLine:=SubStractMapField (Line);

     { Verwerk de regel door beide velden uit de regel te halen }
     {                                                          }
     { Verwerk de linkerkant van de regel                       }

     ParseMapLine (TmpLine,Tmp^.LType,Tmp^.LName,Tmp^.LFidoAddr);

     Delete (Line,1,Length (TmpLine));        { Haal eerste deel weg }
     TmpLine:=SubStractMapField (Line);       { Pak het tweede deel  }

     IF (TmpLine = '') THEN
        GOTO ClearUp;

     { verwerk de rechterkant van de regel }
     ParseMapLine (TmpLine,Tmp^.RType,Tmp^.RName,Tmp^.RFidoAddr);

     { kijk of deze al bestaat }
     Zoek:=UUCPMappingList.GetFirstItem;
     WHILE (Zoek <> NIL) DO
     BEGIN
          IF (Tmp^.MapType = Zoek^.MapType) AND
             (Tmp^.LType   = Zoek^.LType) AND
             (Tmp^.LName   = Zoek^.LName) AND
             (Tmp^.RType   = Zoek^.RType) AND
             (Tmp^.RName   = Zoek^.RName) AND
             FidoCompare (Tmp^.LFidoAddr,Zoek^.LFidoAddr) AND
             FidoCompare (Tmp^.RFidoAddr,Zoek^.RFidoAddr) THEN
          BEGIN
               LogMessage ('Following MAP-UUCP line is a duplicate:');
               GOTO ClearUp2;
          END;

          Zoek:=UUCPMappingList.GetNextItem;
     END;

     { voeg de regel toe aan de lijst in het geheugen }

     { RWI 951117: added check for the key }
     {$IFNDEF WtrTest}
     IF (regKeyNumber < $FFFE) OR (UUCPMappingList.ItemCount < 5) THEN
     {$ENDIF}
     BEGIN
          Inc (MemMapping,SizeOf (MapRecord)+4);
          UUCPMappingList.Add (Tmp);
          Exit;
     END;

     LogMessage ('Max 5 MAP-UUCP '+NotRegMaxLimit);
     GOTO ClearUp2;

ClearUp:
     LogMessage ('Following MAP-UUCP line is invalid:');

ClearUp2:
     LogExtraMessage (OrgLine);

     FreeMem (Tmp,SizeOf (MapRecord));
END;


{--------------------------------------------------------------------------}
{ AddMapAreaLine                                                           }
{                                                                          }
PROCEDURE AddMapAreaLine (Line : STRING);

VAR Tmp  : MapAreaPtr;
    Area : STRING;

BEGIN
     IF (Pos (' ',Line) = 0) THEN
     BEGIN
          LogMessage ('Following MAP-AREA line is invalid:');
          LogExtraMessage (Line);
          Exit; { RWI 960304 }
     END;

     GetMem (Tmp,SizeOf (MapAreaRecord));

     Tmp^.EMailAddress:=UpCaseString (Copy (Line,1,Pos (' ',Line)-1));
     Delete (Line,1,Pos (' ',Line));
     Line:=DeleteFrontSpaces (Line);

     Line:=Line+' ';
     Tmp^.AreaIndex:=GetAreaNameIndexValue (UpCaseString (Copy (Line,1,Pos (' ',Line)-1)));
     Delete (Line,1,Pos (' ',Line));
     Line:=DeleteFrontSpaces (Line);

     IF (Pos (' ',Line) > 0) THEN
        Line:=Copy (Line,1,Pos (' ',Line)-1);
     Tmp^.ReplyAddr:=Line;

     Inc (MemMapping,SizeOf (MapAreaRecord)+4);
     MapAreaList.Add (Tmp);
END;


{--------------------------------------------------------------------------}
{ GetNextFtnAddrPart                                                       }
{                                                                          }
{ RWI961230: point deel wordt nu geinterpreteerd en Val() resultaat        }
{ gecontroleerd.                                                           }
{                                                                          }
{ Legale mogelijkheden                                                     }
{                                                                          }
{ Text                  FAdr       Return code    Zeker                    }
{ *                     0:0/0.0    1              Ja                       }
{ z                     z:0/0.0    4                                       }
{ z:                    z:0/0.0    4                                       }
{ z:*                   z:0/0.0    1                                       }
{ z:                    z:0/0.0    4                                       }
{ z:n                   z:n/0.0    4                                       }
{ z:n/                  z:n/0.0    4                                       }
{ z:/                   z:0/0.0    4                                       }
{ z:n/*                 z:n/0.0    2                                       }
{ z:n/f                 z:n/f.0    4                                       }
{ z:n/f.                z:n/f.0    4                                       }
{ z:n/f.*               z:n/f.0    3                                       }
{ z:n/f.p               z:n/f.p    4                                       }
{                                                                          }
FUNCTION GetNextFtnAddrPart (VAR Invoer : STRING; VAR FAdr : FidoAddrType) : INTEGER;

VAR Start,
    Z,N,
    Level : INTEGER;
    Error : ValNop;
    Adres : STRING;

BEGIN
     Invoer:=DeleteFrontSpaces (Invoer);

     IF (Pos (' ',Invoer) > 0) THEN
     BEGIN
          Adres:=Copy (Invoer,1,Pos (' ',Invoer)-1);
          Invoer:=Copy (Invoer,Pos (' ',Invoer),Length (Invoer));
     END ELSE
     BEGIN
          Adres:=Invoer;
          Invoer:='';
     END;

     IF (Adres = '') THEN
     BEGIN
          GetNextFtnAddrPart:=0;
          Exit;
     END;

     { Invoer Adres op 0 zetten }
     FidoSplit ('0',FAdr);
     FAdr.Domain:='';
     GetNextFtnAddrPart:=4;

     { is there a :? }
     Z:=Pos (':',Adres);
     IF (Z > 0) THEN
        { yes, extract the zone part (2:??? etc) }
        Val (Copy (Adres,1,Z-1),FAdr.Zone,Error);

     { 0+1 = 1 -> "*" of "zzz:*" is dus alle mogelijke adressen }
     { zone dus altijd gebruikt want kan geen 0 terug geven!    }
     IF (Adres[Z+1] = '*') THEN
     BEGIN
          { "zzz:*" or "*" }
          GetNextFtnAddrPart:=1;
          Exit;
     END;

     { kijk of er een net deel is }
     N:=Pos ('/',Adres);
     IF (N > 0) THEN
        { "2:3/" of "3/" }
        Val (Copy (Adres,Z+1,N-(Z+1)),FAdr.Net,Error)
     ELSE
         { 2:3 }
         Val (Copy (Adres,Z+1,Length (Adres)),FAdr.Net,Error);
         { niet meteen fout! Kan ook een * zijn }

     { ???/* }
     IF (Adres[N+1] = '*') THEN
     BEGIN
          GetNextFtnAddrPart:=2;
          Exit;
     END;

     { kijk of er een point deel is }
     Z:=Pos ('.',Adres);
     IF (Z > 0) THEN
        { "???/n.???" }
        Val (Copy (Adres,N+1,Z-(N+1)),FAdr.Node,Error)
     ELSE
         { "???/n" }
         Val (Copy (Adres,N+1,Length (Adres)),FAdr.Node,Error);

     { ???/n.*, triggered niet als er geen "." was, dus Z=0 }
     IF (Adres[Z+1] = '*') THEN
     BEGIN
          GetNextFtnAddrPart:=3;
          Exit;
     END;

     { RWI961230: interpreteer point deel }
     Val (Copy (Adres,Z+1,255),FAdr.Point,Error);
END;


{--------------------------------------------------------------------------}
{ AddSignatureToList                                                       }
{                                                                          }
{ Voegt een Signature toe aan de lijst in het geheugen, een signature is   }
{ hier een verwijzing naar een disk bestandje dat toegevoegt wordt aan     }
{ een fido user als deze een bericht Fido->Usenet stuurt.                  }
{                                                                          }
{ Formaat:                                                                 }
{                                                                          }
{ SIGNATURE <filepath> <(partitial) address> [<UserName>]                  }
{ SIGNATURE <filepath> <e-mail address or domain>                          }
{                                                                          }
PROCEDURE AddSignatureToList (OrgRegel : STRING);

VAR Tmp   : SignaturePtr;
    Regel : STRING;

LABEL BadSig;

BEGIN
     Regel:=OrgRegel;
     GetMem (Tmp,SizeOf (SignatureRecord));

     CleanTabs (Regel,1);

     IF (Pos (' ',Regel) = 0) THEN
        GOTO BadSig;

     Tmp^.Path:=Copy (Regel,1,Pos (' ',Regel)-1);
     Regel:=DeleteFrontSpaces (Copy (Regel,Pos (' ',Regel)+1,255));

     IF (NOT TestIfExist (Tmp^.Path)) THEN
     BEGIN
          LogMessage ('Cannot open signature file '+Tmp^.Path);
          FreeMem (Tmp,SizeOf (SignatureRecord));
          Exit;
     END;

     IF (NOT (Regel[1] IN ['0'..'9','*'])) THEN
     BEGIN
          { assume e-mail address / domain }
          Tmp^.Level:=255;
          Tmp^.UserName:=UpCaseString (Regel);
          Tmp^.Address:=NullAdres;
     END ELSE
     BEGIN
          { fido style adres + optional user name }
          IF (Regel[1] = '*') THEN
          BEGIN
               Tmp^.Level:=0;
               Delete (Regel,1,1);

               IF (Regel[1] <> ' ') THEN
                  GOTO BadSig;
          END ELSE
              Tmp^.Level:=GetNextFtnAddrPart (Regel,Tmp^.Address);

          Tmp^.UserName:=UpCaseString (DeleteFrontAndBackSpaces (Regel));
     END;

     Inc (MemSignatures,SizeOf (SignatureRecord)+4);

     SignatureList.Add (Tmp);
     Exit;

BadSig:

     LogMessage ('Invalid SIGNATURE line format in following line:');
     LogExtraMessage (OrgRegel);
     FreeMem (Tmp,SizeOf (SignatureRecord));
END;


{--------------------------------------------------------------------------}
{ AddSaveFileToList                                                        }
{                                                                          }
{ SAVE <address> <directory>                                               }
{                                                                          }
PROCEDURE AddSaveFileToList (SaveFrom : BOOLEAN; Regel : STRING);

VAR Tmp    : SaveFilePtr;
    Search : SearchRec;

BEGIN
     GetMem (Tmp,SizeOf (SaveFileRecord));

     CleanTabs (Regel,1);
     Regel:=Regel+' ';

     Tmp^.SaveFrom:=SaveFrom;
     Tmp^.EmailAddress:=UpCaseString (Copy (Regel,1,Pos (' ',Regel)-1));
     Regel:=DeleteFrontSpaces (Copy (Regel,Pos (' ',Regel)+1,255));

     Tmp^.Directory:=UpCaseString (Copy (Regel,1,Pos (' ',Regel)-1));
     IF (Tmp^.Directory[Length (Tmp^.Directory)] <> '\') THEN
        Tmp^.Directory:=Tmp^.Directory+'\';

     { controleer of het pad bestaat }
     FindFirst (Tmp^.Directory+'*.*',$3F,Search);
     IF (NOT (DosError IN [0,18])) THEN
     BEGIN
          LogDiskIOError (DosError,'Cannot access SAVE directory '+Tmp^.Directory);
          FreeMem (Tmp,SizeOf (SaveFileRecord));
          FindClose (Search);
          Exit;
     END;

     FindClose (Search);

     SaveFileList.Add (Tmp);
END;


{--------------------------------------------------------------------------}
{ AddSendFileToList                                                        }
{                                                                          }
{ SENDFILE <address> <filename path>                                       }
{                                                                          }
PROCEDURE AddSendFileToList (Regel : STRING; ForceText : BOOLEAN);

VAR Tmp : SendFilePtr;

BEGIN
     GetMem (Tmp,SizeOf (SendFileRecord));
     Tmp^.ForceText:=ForceText;

     CleanTabs (Regel,1);
     Regel:=Regel+' ';

     Tmp^.UserName:=UpCaseString (Copy (Regel,1,Pos (' ',Regel)-1));
     Regel:=DeleteFrontSpaces (Copy (Regel,Pos (' ',Regel)+1,255));

     Tmp^.FilePath:=Copy (Regel,1,Pos (' ',Regel)-1);

     { controleer of de file aanwezig is }
     IF (NOT TestIfExist (Tmp^.FilePath)) THEN
     BEGIN
          LogMessage ('Cannot access SENDFILE: '+Tmp^.FilePath);
          FreeMem (Tmp,SizeOf (SendFileRecord));
          Exit;
     END;

     Inc (MemSendfile,SizeOf (SendFileRecord)+4);
     SendFileList.Add (Tmp);
END;


{--------------------------------------------------------------------------}
{ AddBounceToList                                                          }
{                                                                          }
{ BOUNCE <address>                                                         }
{                                                                          }
PROCEDURE AddBounceToList (FromBounce : BOOLEAN; OrgRegel : STRING);

VAR Tmp   : BouncePtr;
    Regel : STRING;

BEGIN
     Regel:=OrgRegel;
     GetMem (Tmp,SizeOf (BounceRecord));

     CleanTabs (Regel,1);
     Regel:=Regel+' ';

     Tmp^.EmailAddress:=UpCaseString (Copy (Regel,1,Pos (' ',Regel)-1));
     Tmp^.WildMatch:=FALSE;

     IF (Tmp^.EMailAddress[1] = '*') THEN
     BEGIN
          Tmp^.WildMatch:=TRUE;
          Delete (Tmp^.EMailAddress,1,1);
     END;

     Regel:=DeleteFrontSpaces (Copy (Regel,Pos (' ',Regel)+1,255));

     Tmp^.Reason:='Ask system administrator for reason';
     Tmp^.FromBounce:=FromBounce;

     IF (Regel[1] <> '"') THEN
     BEGIN
          LogMessage ('Missing " at start of bounce reason in the following line:');
          LogExtraMessage (OrgRegel);
     END ELSE
     BEGIN
          Delete (Regel,1,1);
          IF (Pos ('"',Regel) = 0) THEN
          BEGIN
               LogMessage ('Missing " at end of bounce reason in the following line:');
               LogExtraMessage (OrgRegel);
          END ELSE
              Tmp^.Reason:=Copy (Regel,1,Pos ('"',Regel)-1);
     END;

     BounceList.Add (Tmp);
END;


{--------------------------------------------------------------------------}
{ AddFilterToList                                                          }
{                                                                          }
{ Deze routine voegt een filter toe aan de filter lijst. Alles wordt       }
{ omgezet in hoofdletters.                                                 }
{                                                                          }
{ Formaat:                                                                 }
{                                                                          }
{ [!]<partitial newsgroup name>["." | ".*"]                                }
{                                                                          }
PROCEDURE AddFilterToList (Filter,Path : STRING; LineNr : WORD);

VAR Tmp  : FilterPtr;

BEGIN
     GetMem (Tmp,SizeOf (FilterRecord));

     Tmp^.LineNr:=LineNr;

     { controleer op het uitroepteken aan het begin van de filter }
     Tmp^.Allow:=(Filter[1] <> '!');
     IF (NOT Tmp^.Allow) THEN
        Delete (Filter,1,1);

     { als er niets achter de naam staat, dan geldt alles plus eronder }
     Tmp^.Option:=foPLUSBELOW;

     { maar.. als er een punt achter staat, dan geldt alleen deze naam }
     IF (Filter[Length (Filter)] = '.') THEN
     BEGIN
          Delete (Filter,Length (Filter),1);
          Tmp^.Option:=foEXACT;
     END ELSE
         { RWI 950827: added check for '*' }
         IF (Filter = '*') THEN
         BEGIN
              Filter:='';
              Tmp^.Option:=foBELOWONLY; { no empty names }
         END ELSE
             { als de laatste twee tekens een punt en een astriks zijn, }
             { dan geldt alles hieronder, maar niet deze naam zelf.     }
             IF (Copy (Filter,Length (Filter)-1,2) = '.*') THEN
             BEGIN
                  Delete (Filter,Length (Filter)-1,2);
                  Tmp^.Option:=foBELOWONLY;
             END;

     { nu is de naam schoongemaakt }

     { geheugen aanvragen voor de Name }
     GetMem (Tmp^.NamePtr,Length (Filter)+1);
     Tmp^.NamePtr^:=UpCaseString (Filter);

     { geheugen aanvragen voor de path }
     IF (Path = '') THEN
        Tmp^.PathPtr:=NIL
     ELSE BEGIN
          GetMem (Tmp^.PathPtr,Length (Path)+1);
          Tmp^.PathPtr^:=UpCaseString (Path);
     END;

     Inc (MemFilter,SizeOf (FilterRecord)+4+Length (Path)+1+Length (Filter)+1);
     FilterList.Add (Tmp);
END;


{--------------------------------------------------------------------------}
{ ProcessFilterFile                                                        }
{                                                                          }
{ Deze routine leest de filter file van disk en verwerkt alle regels die   }
{ zich daarin bevinden.                                                    }
{                                                                          }
PROCEDURE ProcessFilterFile (Filename : STRING);

VAR FilterFile : TEXT;
    IORes      : BYTE;
    Filter,
    Regel      : STRING;
    LineNr     : WORD;

BEGIN
{$IFDEF WtrTest}
     Exit;
{$ENDIF}

     Assign (FilterFile,Filename);
     {$I-} Reset (FilterFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          IF (IORes = 2) THEN
             LogMessage ('Cannot find filter file '+Filename)
          ELSE
              LogDiskIOError (IORes,'Cannot open filter file '+Filename);
          Exit;
     END;

     LogMessage ('Reading new newsgroup names filter file '+Filename);

     LineNr:=0;
     WHILE (NOT Eof (FilterFile)) DO
     BEGIN
          ReadLn (FilterFile,Regel);
          Inc (LineNr);

          IF (Pos (';',Regel) > 0) THEN
             Regel:=Copy (Regel,1,Pos (';',Regel)-1);

          Regel:=DeleteFrontAndBackSpaces (CleanTabs (Regel,1));

          IF (Regel = '') THEN
             Continue;

          IF (Pos (' ',Regel) > 0) THEN
          BEGIN
               Filter:=Copy (Regel,1,Pos (' ',Regel)-1);
               Delete (Regel,1,Pos (' ',Regel));
               Regel:=DeleteFrontSpaces (Regel);
          END ELSE
          BEGIN
               Filter:=Regel;
               Regel:='';
          END;

          AddFilterToList (Filter,Regel,LineNr);

     END; { while }

     Close (FilterFile);
END;


{--------------------------------------------------------------------------}
{ AddMailTunnel                                                            }
{                                                                          }
{ Deze routine interpreteert een mail tunnel entry en voegt deze toe.      }
{                                                                          }
PROCEDURE AddMailTunnel (IO : MailTunnelIOType; OrigRegel : STRING);

VAR Regel : STRING;
    Tmp   : MailTunnelPtr;
    P     : BYTE;
    MSize : LONGINT;
    Nop   : ValNop;

LABEL Abort;

BEGIN
     Regel:=OrigRegel;
     Delete (Regel,1,Pos (' ',Regel));
     Regel:=DeleteFrontAndBackSpaces (Regel);

     IF (Pos (' ',Regel) = 0) THEN
     BEGIN
          LogMessage ('Error in '+OrigRegel);
          Exit;
     END;

     GetMem (Tmp,SizeOf (MailTunnelRecord));

     Tmp^.FromOrTo:=IO;
     Tmp^.EmailAddress:=Copy (Regel,1,Pos (' ',Regel)-1);
     Tmp^.MinimumSize:=0;
     Tmp^.ArchiveName:='';
     Tmp^.ExtractPath:='';

     Delete (Regel,1,Pos (' ',Regel));
     Regel:=DeleteFrontSpaces (Regel);

     IF (IO = mtTo) THEN
     BEGIN
          P:=Pos (' ',Regel);
          IF (P = 0) THEN
          BEGIN
               LogMessage ('Error in '+OrigRegel);
               FreeMem (Tmp,SizeOf (MailTunnelRecord));
               Exit;
          END;

          { extract the fido address }
          FidoSplit (Copy (Regel,1,P-1),Tmp^.FidoAddress);
          Delete (Regel,1,P);
          Regel:=DeleteFrontSpaces (Regel);

          { extract the filename }
          P:=Pos (' ',Regel);
          IF (P > 9) OR ((P = 0) AND (Length (Regel) > 8)) THEN
          BEGIN
               LogMessage ('Filename error in '+OrigRegel);
               GOTO Abort;
          END;

          IF (P > 0) THEN
          BEGIN
               { extract filename }
               Tmp^.ArchiveName:=Copy (Regel,1,P-1);
               Delete (Regel,1,P);
               Regel:=DeleteFrontSpaces (Regel);

               { extract minimum size }
               Val (Regel,MSize,Nop);
               IF (Nop <> 0) THEN
               BEGIN
                    LogMessage ('MinimumSize error in '+OrigRegel);
                    GOTO Abort;
               END;

               IF (MSize < 0) OR (MSize > 255) THEN
               BEGIN
                    LogMessage ('MinimumSize range is 0 to 255 (Kb) in '+OrigRegel);
                    GOTO Abort;
               END;

               Tmp^.MinimumSize:=MSize;
          END ELSE
              { filename only }
              Tmp^.ArchiveName:=Regel;
     END ELSE
     BEGIN
          FidoSplit ('0:0/0',Tmp^.FidoAddress);
          Tmp^.ExtractPath:=CorrectPath (Regel);
     END;

     { RWI 951117: added check for the key }
     {$IFNDEF WtrTest}
     IF (regKeyNumber < $FFFE) OR (MailTunnelList.ItemCount < 4) THEN
     {$ENDIF}
     BEGIN
          MailTunnelList.Add (Tmp);
          Inc (MemTunnel,SizeOf (MailTunnelRecord)+4);
          Exit;
     END;

     LogMessage ('Max 4 TUNNEL-xxx '+NotRegMaxLimit);
     LogExtraMessage ('  Ignoring: '+OrigRegel);

Abort:
     FreeMem (Tmp,SizeOf (MailTunnelRecord));
END;


{--------------------------------------------------------------------------}
{ AddForcePack                                                             }
{                                                                          }
{ Deze routine interpreteert een FORCEPACK entry en voegt deze toe.        }
{                                                                          }
PROCEDURE AddForcePack (Regel : STRING);

VAR Tmp : ForcePackPtr;

BEGIN
     GetMem (Tmp,SizeOf (ForcePackRecord));

     FidoSplit (Regel,Tmp^.FidoAddr);
     WITH Tmp^.FidoAddr DO
          IF (Zone = 0) AND (Net = 0) AND (Node = 0) AND (Point = 0) THEN
          BEGIN
               { vast verkeerd }
               FreeMem (Tmp,SizeOf (ForcePackRecord));
               LogMessage ('Error interpreting FORCEPACK line: '+Regel);
               Exit;
          END;

     ForcePackList.Add (Tmp);
END;


{--------------------------------------------------------------------------}
{ Schedule                                                                 }
{                                                                          }
{ Kijkt of een gegeven schedule op dit tijdstip actief is, en dus verwerkt }
{ mag worden.                                                              }
{                                                                          }
{ Formaat:                                                                 }
{                                                                          }
{ Sched <tag> [day] [start] [end]                                          }
{                                                                          }
{ Start en eind tijden zijn in 24 uurs formaat (eg 00:00 - 23:59)          }
{ Day kan 'Mon' zijn, maar ook 'Tue|Sat|Sun' of 'All'                      }
{                                                                          }
FUNCTION Schedule (Regel : STRING) : BOOLEAN;

VAR DagF  : STRING[3];
    DagS,
    Tag   : STRING;
    Hour,
    Min,
    DoW,
    Dum   : WordLong;
    e     : ValNop;
    SHour,
    SMin  : WORD;
    Space : BYTE;

BEGIN
     Schedule:=TRUE;

     Regel:=UpCaseString (DeleteFrontAndBackSpaces (CleanTabs (Regel,1)));
     Space:=Pos (' ',Regel);
     IF (Space = 0) THEN
        Tag:=Regel   { alleen een tag op de regel }
     ELSE BEGIN
          Tag:=Copy (Regel,1,Space-1);
          Delete (Regel,1,Space-1);
     END;

     { Voorlopig negeren we de tag }
     IF (Regel = '') THEN
        Exit;

     { Haal de huidige dag en tijd uit de systeem klok }
     GetDate (Dum,Dum,Dum,DoW);
     GetTime (Hour,Min,Dum,Dum);

     Regel:=DeleteFrontSpaces (Regel);
     Space:=Pos (' ',Regel);
     IF (Space = 0) THEN
        DagS:=Regel                       { Alleen een dag op de regel   }
     ELSE BEGIN
          DagS:=Copy (Regel,1,Space-1);
          Delete (Regel,1,Space-1);
     END;

     DagF:=UpCaseString (Day[Dow]);

     IF (Pos (DagF,DagS) = 0) THEN       { Zit vandaag er tussen ?      }
        IF (Pos ('ALL',DagS) = 0) THEN     { Probeer of ALL er tussen zit }
        BEGIN
             Schedule:=FALSE;      { nee dus, pech gehad }
             Exit;
        END;

     IF (Regel = '') THEN        { niets meer op de regel? }
        Exit;

     Regel:=DeleteFrontSpaces (Regel);
     DagS:=Copy (Regel,1,2);      { Haal uur van de regel        }
     Val (DagS,SHour,e);
     DagS:=Copy (Regel,4,2);      { Haal minuut van de regel     }
     Val (Dags,SMin,e);

     IF (Hour < SHour) OR ((SHour = Hour) AND (Min < SMin)) THEN
     BEGIN
          Schedule:=FALSE;
          Exit;
     END;

     Space:=Pos (' ',Regel);
     IF (Space = 0) THEN
        Exit;

     Regel:=DeleteFrontSpaces (Copy (Regel,6,255));
     DagS:=Copy (Regel,1,2);      { Haal uur van de regel        }
     Val (Dags,SHour,e);
     DagS:=Copy (Regel,4,2);      { Haal minuut van de regel     }
     Val (Dags,SMin,e);

     { Kijk of de eind tijd van het schedule wel geldig is }
     IF (SHour < Hour) OR ((Shour = Hour) AND (SMin < Min)) THEN
     BEGIN
          Schedule:=FALSE;
          Exit;
     END;
END;


{--------------------------------------------------------------------------}
{ InitRoutingTable                                                         }
{                                                                          }
{ Bouwt de fido netmail routing tabel uit alle fido adressen in de         }
{ Userbase en alle routing informatie die in de config is opgegeven.       }
{                                                                          }
PROCEDURE InitRoutingTable;

CONST RoutingBufSize = 4048;

VAR UserLp            : UserBaseRecordNrType;
    NewRouteRecordPtr : RouteRecordPtr;
    Verder            : BOOLEAN;
    NextRout          : RouteRecordPtr;
    RouteFile         : TEXT;
    IORes             : BYTE;
    NoUpperCaseRegel,
    TmpUUCPName,
    InvoerRegel       : STRING;
    CntDomains,
    InvoerLevel       : INTEGER;
    InvoerAdres,
    TempAdres,
    RouteToAdres      : FidoAddrType;
    B                 : CHAR;
    Nop               : ValNop;

LABEL NoRouteTdb;

VAR Keyword : STRING[30];

{ InitRoutingTable }
BEGIN
     MemSignatures:=0;
     MemRouting:=0;
     MemMapping:=0;
     MemSendfile:=0;
     MemFilter:=0;
     MemTunnel:=0;

     { Vul de routing table eerst met alle entries uit de UserBase }
     FOR UserLp:=1 TO UserBaseRecCount DO
     BEGIN
          ReadUserBaseRecord (UserLp,UserData);

          { Zorg ervoor dat BAG file suppliers NIET in de routing worden }
          { opgenomen.                                                   }
          IF (NOT UserData.Deleted) AND (UserData.System <> _B) THEN
          BEGIN
               { Voor alle system die niet gedelete zijn, en een UUCP name }
               { hebben:                                                   }
               { RWI 950212: mag dit wel? Het mag toch alleen als dat }
               {             systeem een worldreg systeempje is? Nu   }
               {             gaat take!takev@wsd.uucp goed, terwijl   }
               {             take niet worldreg is... Ik kan alleen   }
               {             geen reden bedenken waarom het niet zou  }
               {             mogen...                                 }
               IF (UserData.UUCPName <> '') THEN
                  Inc (MemRouting,AddUUCPRouteLine (UserLp,UserData.UUCPName));

               { Voeg alle domain addressen toe zover die gedefinieerd zijn }
               { Controleer of voor de domains sub domains zijn toegestaan  }
               FOR CntDomains:=1 TO MaxDomains DO
                   IF (UserData.Domains[CntDomains] <> '') THEN
                      { RWI 950524: AllowSubDomains weer ingevoerd }
                      IF (UserData.AllowSubDomains AND (UserData.Domains[CntDomains,1] <> '.')) THEN
                         { .A.B.C is inclusief A.B.C zelf. Zie UUCPROUT.PAS }
                         Inc (MemRouting,AddUUCPRouteLine (UserLp,'.'+UserData.Domains[CntDomains]))
                      ELSE
                          Inc (MemRouting,AddUUCPRouteLine (UserLp,UserData.Domains[CntDomains]));

               { voeg alle fido addressen toe als die er zijn }
               IF (UserData.System = _F) THEN
               BEGIN
                    IF (FirstRouteRecordPtr = NIL) THEN
                    BEGIN
                         GetMem (FirstRouteRecordPtr,SizeOf (RouteRecord));
                         NewRouteRecordPtr:=FirstRouteRecordPtr;
                    END ELSE
                    BEGIN
                         GetMem (NewRouteRecordPtr^.NextRouteRecordPtr,SizeOf (RouteRecord));
                         NewRouteRecordPtr:=NewRouteRecordPtr^.NextRouteRecordPtr;
                    END;

                    WITH NewRouteRecordPtr^ DO
                    BEGIN
                         Level:=4;                       { check level }
                         MaskFidoAddr:=UserData.Address; { mask }
                         ViaFidoAddr:=UserData.Address;  { via }
                         NextRouteRecordPtr:=NIL;
                    END;
               END; { not deleted and fido system }

          END; { Not Deleted en niet een bag supplier }
     END; { for }

     PeekMem;

     { Kijk dan of er in de systeem directory \ROUTE.TDB bestaat }
     { Deze bevat alle andere routing informatie. In tekst vorm! }

     Verder:=TRUE;
     IF (NOT TestIfExist (Config.SystemDir+'ROUTE.TDB')) THEN
     BEGIN
          { RWI 950604: "[InitRoutingTabel]" verwijderd. Staat wat beter zo. }
          LogMessage ('Unable to locate ROUTE.TDB');
          GOTO NoRouteTdb;
     END;

     Assign (RouteFile,Config.SystemDir+'ROUTE.TDB');
     {$I-} Reset (RouteFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'Error opening ROUTE.TDB');
          GOTO NoRouteTdb;
     END;

     WHILE (NOT Eof (RouteFile)) DO
     BEGIN
          ReadLn (RouteFile,InvoerRegel);

          InvoerRegel:=DeleteBackSpaces (InvoerRegel); { RWI 960219 }

          IF (InvoerRegel = '') OR (InvoerRegel[1] = ';') THEN
             Continue;

          InvoerRegel:=CleanTabs (InvoerRegel,1);
          NoUpperCaseRegel:=InvoerRegel;

          { UPCASE een eventueel keyword }
          IF (Pos (' ',InvoerRegel) > 0) THEN
             Keyword:=UpCaseString (Copy (InvoerRegel,1,Pos (' ',InvoerRegel)-1))
          ELSE
              Keyword:=UpCaseString (InvoerRegel);

          IF (Keyword = 'SCHEDULE') THEN
          BEGIN
               InvoerRegel:=DeleteFrontSpaces (Copy (InvoerRegel,9,255));
               Verder:=Schedule (InvoerRegel);
          END;

          { Als we een schedule tegen gekomen zijn die ons niet }
          { toestaat om verder te lezen, negeren we alle regels }
          { tot een volgende schedule                           }
          IF (NOT Verder) THEN
             Continue;

          IF (Keyword = 'SIGNATURE') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               InvoerRegel:=DeleteFrontSpaces (Copy (InvoerRegel,10,255));
               AddSignatureToList (InvoerRegel);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'NEWSFILTER') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               InvoerRegel:=DeleteFrontSpaces (Copy (InvoerRegel,11,255));
               IF (Pos ('\',InvoerRegel) = 0) THEN
                  InvoerRegel:=Config.SystemDir+InvoerRegel;

               ProcessFilterFile (UpCaseString (InvoerRegel));
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'MAP-UUCP') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               NoUpperCaseRegel:=DeleteFrontSpaces (Copy (NoUpperCaseRegel,9,255));
               AddMapUUCPLine (NoUpperCaseRegel);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'MAP-FIDO') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               NoUpperCaseRegel:=DeleteFrontSpaces (Copy (NoUpperCaseRegel,9,255));
               AddMapFidoLine (NoUpperCaseRegel);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'MAP-AREA') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               NoUpperCaseRegel:=DeleteFrontSpaces (Copy (NoUpperCaseRegel,9,255));
               AddMapAreaLine (NoUpperCaseRegel);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'ALLOW-FIDO') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               AddAllowFIDOLine (InvoerRegel);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'FORBID-FIDO') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               AddDisallowFIDOLine (InvoerRegel);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'ROUTE-UUCP') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               InvoerRegel:=DeleteFrontSpaces (Copy (InvoerRegel,11,255));
               TmpUUCPName:=Copy (InvoerRegel,1,Pos (' ',InvoerRegel)-1);
               InvoerRegel:=DeleteFrontSpaces (Copy (InvoerRegel,Length (TmpUUCPName)+1,255));

               { Controleer of deze UUCP name wel bestaat }
               IF FindUserBaseRecordByUUCPName (TmpUUCPName,UserLp) THEN
                  Inc (MemRouting,AddUUCPRouteLine (UserLp,InvoerRegel))
               ELSE
                   LogMessage ('Found unknown ROUTE-UUCP address '+TmpUUCPName+' in ROUTE.TDB ');

               {$ENDIF}
               Continue;
          END;

          { Route Commando }
          IF (Keyword = 'ROUTE-FIDO') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               { Snij het route commando uit de regel }
               InvoerRegel:=DeleteFrontSpaces (Copy (InvoerRegel,11,255));

               { Het eerste adres is het Route-To adres }
               GetNextFtnAddrPart (InvoerRegel,RouteToAdres);
               TempAdres:=RouteToAdres;

               { Controleer of dat adres bestaat ! Het  }
               { moet namelijk een van onze buren zijn  }

               IF FindUserBaseRecordByFidoAddress (RouteToAdres,UserLp) THEN
                  WHILE (InvoerRegel <> '') DO
                  BEGIN
                       InvoerLevel:=GetNextFtnAddrPart (InvoerRegel,InvoerAdres);
                       FidoMergeAdres (TempAdres,InvoerAdres);

                       IF (InvoerLevel > 0) THEN
                       BEGIN
                            IF (FirstRouteRecordPtr = NIL) THEN
                            BEGIN
                                 GetMem (FirstRouteRecordPtr,SizeOf (RouteRecord));
                                 NewRouteRecordPtr:=FirstRouteRecordPtr;
                            END ELSE
                            BEGIN
                                 GetMem (NewRouteRecordPtr^.NextRouteRecordPtr,SizeOf (RouteRecord));
                                 NewRouteRecordPtr:=NewRouteRecordPtr^.NextRouteRecordPtr;
                            END;

                            WITH NewRouteRecordPtr^ DO
                            BEGIN
                                 Level:=InvoerLevel;
                                 MaskFidoAddr:=InvoerAdres; { mask }
                                 ViaFidoAddr:=RouteToAdres; { via }
                                 NextRouteRecordPtr:=NIL;
                            END;
                       END ELSE
                       BEGIN
                            LogMessage ('Unable to complete parse of '+InvoerRegel);
                            InvoerRegel:='';
                       END;
                  END { while }
               ELSE
                   LogMessage ('Unknown ROUTE-FIDO destination '+Fido2Str (RouteToAdres));

               {$ENDIF}
               Continue;
          END; { if ROUTE-FIDO found on this line }

          IF (Keyword = 'SAVE') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               InvoerRegel:=UpCaseString (DeleteFrontSpaces (Copy (InvoerRegel,6,255)));
               AddSaveFileToList (FALSE,InvoerRegel);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'SAVEFROM') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               InvoerRegel:=UpCaseString (DeleteFrontSpaces (Copy (InvoerRegel,10,255)));
               AddSaveFileToList (TRUE,InvoerRegel);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'SENDFILE') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               InvoerRegel:=UpCaseString (DeleteFrontSpaces (Copy (InvoerRegel,10,255)));
               AddSendFileToList (InvoerRegel,FALSE);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'SENDTEXTFILE') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               InvoerRegel:=UpCaseString (DeleteFrontSpaces (Copy (InvoerRegel,14,255)));
               AddSendFileToList (InvoerRegel,TRUE);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'BOUNCE') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               InvoerRegel:=DeleteFrontSpaces (Copy (InvoerRegel,8,255));
               AddBounceToList (FALSE,InvoerRegel);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'BOUNCEFROM') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               InvoerRegel:=DeleteFrontSpaces (Copy (InvoerRegel,12,255));
               AddBounceToList (TRUE,InvoerRegel);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'GZIPBATCH') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               IF (Pos (' ',InvoerRegel) > 0) THEN
                  B:=LoCase (InVoerRegel[Pos (' ',InvoerRegel)+1]);

               IF (B IN ['a'..'z']) THEN
               BEGIN
                    GZipBatchLetter:=B;
                    {LogMessage ('GZip Batch letter set to '+GZipBatchLetter);}
               END ELSE
                   LogMessage ('Ignoring invalid GZIPBATCH letter! ('+B+')');

               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'FORCENOBITMASK') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               LogMessage ('FORCENOBITMASK is now an option in WtrConf,System Configuration,UUCP Settings');
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'NOTESTORIGADDR') THEN
          BEGIN
               {$IFNDEF WtrTest}
               {$IFNDEF WtrUtil}
               LogMessage ('Will use original OrigNet/Node in packed message header');
               TestOrigAddr:=FALSE;
               {$ENDIF}
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'NOLOCALFLAG') THEN
          BEGIN
               {$IFNDEF WtrTest}
               {$IFNDEF WtrUtil}
               NoLocalFlag:=TRUE;
               {$ENDIF}
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'TUNNEL-TO') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               AddMailTunnel (mtTo,InvoerRegel);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'TUNNEL-FROM') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               AddMailTunnel (mtFrom,InvoerRegel);
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'FORCEPACK') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               Delete (InvoerRegel,1,10);
               AddForcePack (DeleteFrontSpaces (InvoerRegel));
               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'IGNOREFIDOUSER') THEN
          BEGIN
               IF (CustomSkipCount = MAX_CUSTOMSKIPUSERNAMES) THEN
                  LogMessage ('Only '+Byte2String (MAX_CUSTOMSKIPUSERNAMES)+
                              ' IGNOREFIDOUSER statements possible!')
               ELSE BEGIN
                    Delete (InvoerRegel,1,15);
                    Inc (CustomSkipCount);
                    CustomSkipUsernames[CustomSkipCount]:=UpCaseString (InvoerRegel);
               END;

               Continue;
          END;

          IF (Keyword = 'GIGOTERROR') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               Delete (InvoerRegel,1,10);
               GigoMinusFLine:=DeleteFrontAndBackSpaces (InvoerRegel);

               IF (GigoMinusFLine <> '') THEN
               BEGIN
                    IF (Pos ('@',GigoMinusFLine) = 0) AND (Pos ('!',GigoMinusFLine) = 0) THEN
                    BEGIN
                         LogMessage ('GIGOTERROR: invalid error address');
                         GigoMinusFLine:='';
                    END;
               END;

               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'MAIL2NEWS') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               Delete (InvoerRegel,1,10);
               Mail2NewsAddress:=DeleteFrontSpaces (InvoerRegel);

               IF (Mail2NewsAddress = '') THEN
               BEGIN
                    LogMessage ('MAIL2NEWS misses e-mail address argument');
                    Continue;
               END;

               LogMessage ('Enabled mail2news via '+Mail2NewsAddress);

               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'BBS-AREA') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               Delete (InvoerRegel,1,9);
               InvoerRegel:=UpCaseString (DeleteFrontSpaces (InvoerRegel));

               BBSNormalAreaRecNr:=GetAreaBaseRecordNrByAreaName_F (InvoerRegel);

               IF (BBSNormalAreaRecNr = NILRecordNr) THEN
                  LogMessage ('Cannot find BBS-AREA "'+InvoerRegel+'"');

               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'BBS-EMAILAREA') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               Delete (InvoerRegel,1,14);
               InvoerRegel:=UpCaseString (DeleteFrontSpaces (InvoerRegel));

               BBSEMailAreaRecNr:=GetAreaBaseRecordNrByAreaName_F (InvoerRegel);

               IF (BBSEMailAreaRecNr = NILRecordNr) THEN
                  LogMessage ('Cannot find BBS-EMAILAREA "'+InvoerRegel+'"');

               {$ENDIF}
               Continue;
          END;

          IF (Keyword = 'BBS-VIA') THEN
          BEGIN
               {$IFNDEF WtrUtil}
               Delete (InvoerRegel,1,8);
               FidoSplit (DeleteFrontSpaces (InvoerRegel),InvoerAdres);

               FOR UserLp:=1 TO UserBaseRecCount DO
               BEGIN
                    ReadUserBaseRecord (UserLp,UserData);

                    IF (NOT UserData.Deleted) THEN
                       IF (UserData.System = _F) AND
                          FidoCompare (UserData.Address,InvoerAdres) THEN
                       BEGIN
                            BBSViaRecNr:=UserLp;
                            Break; { for }
                       END ELSE
                           IF (UserData.System = _BBS) AND
                              (InvoerAdres.Point = 0) AND
                              (InvoerAdres.Net = UserData.FakeNet) AND
                              (InvoerAdres.Node = UserData.FakeNode) AND
                              (InvoerAdres.Zone = UserData.FakeZone) THEN
                           BEGIN
                                BBSViaRecNr:=UserLp;
                                Break; { for }
                           END;
               END; { for }

               IF (BBSViaRecNr = NILRecordNr) THEN
                  LogMessage ('Cannot find user with BBS-VIA node number '+InvoerRegel);

               {$ENDIF}
               Continue;
          END;

          LogMessage ('ROUTE.TDB: Don''t know how to handle "'+NoUppercaseRegel+'"');
     END; { while not eof }

     Close (RouteFile);

     IF (BBSViaRecNr <> NILRecordNr) AND
        ((BBSNormalAreaRecNr <> NILRecordNr) OR (BBSEMailAreaRecNr <> NILRecordNr))
     THEN
         LogMessage ('Found both BBS-(EMAIL)AREA and BBS-VIA. Latter will be used.');

NoRouteTdb:

     { als er geen NEWSFILTER commando was, of de file niet geopend kon }
     { worden, of er geen ROUTE.TDB file was, dan staan we toch alle    }
     { newsgroup namen toe door een * toe te voegen.                    }

     { in plaats van regel nummer 0 kunnen we nog eens iets speciaals }
     { toevoegen, zoals 65535 en dan een speciale melding in de log.  }
     IF (FilterList.FirstItem = NIL) THEN
     BEGIN
          {$IFNDEF WtrUtil}
          {$IFNDEF WtrTest}
          IF Config.LogDebug THEN
             LogMessage ('Allowing all new newsgroup names');
          {$ENDIF}
          {$ENDIF}
          AddFilterToList ('*','',0);
     END;

     IF (GigoMinusFLine = '') THEN
        GigoMinusFLine:='wtrgate@'+Config.Domains[1];

     PeekMem;

     IF DebugMem THEN
     BEGIN
          LogExtraMessage (MEMUSEFOR+'Signatures = '+Longint2String (MemSignatures));
          LogExtraMessage (MEMUSEFOR+'Mapping = '+Longint2String (MemMapping));
          LogExtraMessage (MEMUSEFOR+'Routing = '+Longint2String (MemRouting));
          LogExtraMessage (MEMUSEFOR+'Sendfile = '+Longint2String (MemSendfile));
          LogExtraMessage (MEMUSEFOR+'NewsFilter = '+Longint2String (MemFilter));
          LogExtraMessage (MEMUSEFOR+'MailTunnels = '+Longint2String (MemTunnel));
     END;
END;


{--------------------------------------------------------------------------}
{ JunkRoutingTable                                                         }
{                                                                          }
{ Geeft het geheugen van de routing table weer vrij.                       }
{                                                                          }
PROCEDURE JunkRoutingTable;

VAR EraseRouteRecordPtr : RouteRecordPtr;

BEGIN
     WHILE (FirstRouteRecordPtr <> NIL) DO
     BEGIN
          EraseRouteRecordPtr:=FirstRouteRecordPtr;
          FirstRouteRecordPtr:=FirstRouteRecordPtr^.NextRouteRecordPtr;
          FreeMem (EraseRouteRecordPtr,SizeOf (RouteRecord));
     END;

     FidoMappingList.Clear;
     UUCPMappingList.Clear;
     SignatureList.Clear;
     FilterList.Clear;
     SaveFileList.Clear;
     SendFileList.Clear;
     BounceList.Clear;
     MapAreaList.Clear;
     MailTunnelList.Clear;
     ForcePackList.Clear;
END;


{--------------------------------------------------------------------------}
{ FreeFilterRecord                                                         }
{                                                                          }
{ This is routine is called by the DList routine to clean up a record that }
{ contains pointers to dynamically allocated memory, so all that memory    }
{ gets freed as well.                                                      }
{                                                                          }
PROCEDURE FreeFilterRecord (VAR Tmp : POINTER); FAR;
BEGIN
     WITH FilterRecord (Tmp^) DO
     BEGIN
          FreeMem (NamePtr,Length (NamePtr^)+1);
          IF (PathPtr <> NIL) THEN
             FreeMem (PathPtr,Length (PathPtr^)+1);
     END;
END;


{ Unit Initialization }
BEGIN
     FidoMappingList.Init (SizeOf (MapRecord),NIL);
     UUCPMappingList.Init (SizeOf (MapRecord),NIL);
     SignatureList.Init (SizeOf (SignatureRecord),NIL);
     FilterList.Init (SizeOf (FilterRecord),FreeFilterRecord);
     SaveFileList.Init (SizeOf (SaveFileRecord),NIL);
     SendFileList.Init (SizeOf (SendFileRecord),NIL);
     BounceList.Init (SizeOf (BounceRecord),NIL);
     MapAreaList.Init (SizeOf (MapAreaRecord),NIL);
     MailTunnelList.Init (SizeOf (MailTunnelRecord),NIL);
     ForcePackList.Init (SizeOf (ForcePackRecord),NIL);
END.
