UNIT ProbFind;

{ History:

RvdW 21-05-93 Deze unit begonnen. Er waren problemen met de Origin Akas die
              onder de UseNet newsgroups stonden, na export naar Echomail.
              Bleek dat door de overnamen uit GEcho er heel veel verkeerde
              Origin Aka's waren. SpecialAreaListing lost dit nu op.
}

INTERFACE

PROCEDURE ProblemFindersMenu;


IMPLEMENTATION

USES Ramon,DataBase,AreaBase,Fido,Cfg;


{--------------------------------------------------------------------------}
{ SpecialAreaListing                                                       }
{                                                                          }
{ Met deze routine kan een speciale vorm van area listing verkregen worden }
{ aan de hand waarvan snel verschillen tussen areas te zien zijn. Een      }
{ voorbeeld is een verkeerde Origin Aka onder een bericht. Met deze lijst  }
{ is direct te zien waar de fout zit omdat de origin aka's in lijst staan. }
{ Door een area uit te kiezen en op enter te drukken kan direct het record }
{ gewijzigd worden. Door meerdere areas te taggen en daarna op enter te    }
{ drukken kunnen ze allemaal in 1 keer een nieuw Origin Aka krijgen, welke }
{ uit te kiezen is uit de lijst met systeem NodeNrs. Hierbij wordt ook de  }
{ SeenByAka aangepast, net als bij enkel-editten.                          }
{                                                                          }
PROCEDURE SpecialAreaListing;

VAR Groups       : GroupFlagType;
    Lp           : AreaBaseRecordNrType;
    Keuze        : SelectItemNrType;
    GroupData    : GroupDescRecord;
    First,
    Rebuild,
    Quit         : BOOLEAN;
    NewOriginAka : BYTE;

BEGIN
     SelectDefine (3,3,37,21,'Select one group');

     FOR Lp:=1 TO 25 DO
     BEGIN
          ReadGroupDescRecord (Lp,GroupData);
          SelectAddItemAtBottom (Chr (64+Lp)+': '+GroupData.GroupDesc,Lp);
     END;

     SelectShow;

     Quit:=FALSE;
     REPEAT
           Keuze:=SelectSelect (DoTag);

           CASE Key OF
                kEsc : BEGIN
                            SelectErase;
                            Quit:=TRUE;
                       END;

                kRet : BEGIN
                            IF (SelectTagCount = 0) THEN
                            BEGIN
                                 Groups:=0;
                                 AddGroupToGroupList (Groups,Keuze);
                            END ELSE
                            BEGIN
                                 Groups:=0;
                                 FOR Lp:=1 TO SelectTagCount DO
                                     AddGroupToGroupList (Groups,SelectGetTaggedItemNr (Lp));
                            END;

                            SelectErase;

                            First:=TRUE;
                            Rebuild:=TRUE;
                            Quit:=FALSE;
                            REPEAT
                                  IF Rebuild THEN
                                  BEGIN
                                       IF First THEN First:=FALSE
                                                ELSE SelectErase;

                                       Message ('Reading area data');

                                       SelectDefine (2,3,70,20,'AreaName                        OriginAka');

                                       FOR Lp:=1 TO AreaBaseRecCount DO
                                       BEGIN
                                            ReadAreaBaseRecord (Lp,AreaData);

                                            IF (NOT AreaData.Deleted) AND ((AreaData.IsInGroups AND Groups) > 0) THEN
                                               SelectAddItemSorted (AddUpWithSpaces (40,AreaData.AreaName)+' '+
                                                                    Fido2Str (Config.NodeNrs[AreaData.OriginAka]),Lp);
                                       END;

                                       WindowPop; { message }
                                       IF (SelectItemCount = 0) THEN
                                          SelectAddItemAtBottom ('<no areas found in group '+Chr (64+Keuze)+'>',65534);
                                       SelectShow;

                                       Rebuild:=TRUE;
                                  END;

                                  Keuze:=SelectSelect (DoTag);

                                  CASE Key OF
                                       kEsc : Quit:=TRUE;
                                       kRet : BEGIN
                                                   IF (SelectTagCount = 0) THEN
                                                      Rebuild:=EditAreaBaseRecord (Keuze)
                                                   ELSE BEGIN
                                                        MenuDefine (30,7,'Select a new Origin Aka');
                                                        FOR Lp:=1 TO 10 DO
                                                            MenuAddItem (Fido2Str (Config.NodeNrs[Lp]));
                                                        MenuShow;
                                                        NewOriginAka:=0;
                                                        CASE MenuSelect OF
                                                             mOpt01 : NewOriginAka:=1;
                                                             mOpt02 : NewOriginAka:=2;
                                                             mOpt03 : NewOriginAka:=3;
                                                             mOpt04 : NewOriginAka:=4;
                                                             mOpt05 : NewOriginAka:=5;
                                                             mOpt06 : NewOriginAka:=6;
                                                             mOpt07 : NewOriginAka:=7;
                                                             mOpt08 : NewOriginAka:=8;
                                                             mOpt09 : NewOriginAka:=9;
                                                             mOpt10 : NewOriginAka:=10;
                                                        END; { case }
                                                        MenuErase;

                                                        IF (NewOriginAka <> 0) THEN
                                                        BEGIN
                                                             Message ('Updating Origin Aka''s and SeenBy Aka''s');

                                                             FOR Lp:=1 TO SelectTagCount DO
                                                             BEGIN
                                                                  ReadAreaBaseRecord (SelectGetTaggedItemNr (Lp),AreaData);
                                                                  AreaData.OriginAka:=NewOriginAka;
                                                                  AreaData.SeenByAkas:=1 SHL (NewOriginAka-1);
                                                                  WriteAreaBaseRecord (SelectGetTaggedItemNr (Lp),AreaData);
                                                             END;

                                                             WindowPop; { message }
                                                             Rebuild:=TRUE;
                                                        END;
                                                   END; { multiple tags }
                                              END; { kRet }
                                  END; { case }
                            UNTIL Quit;

                            SelectErase;
                            Quit:=TRUE;
                       END;
           END; { case }
     UNTIL Quit;
END;


{--------------------------------------------------------------------------}
{ ProblemFindersMenu                                                       }
{                                                                          }
{ Vanuit dit menu kunnen allerlei overzichten verkregen worden aan de hand }
{ waarvan eenvoudig problemen kunnen worden gelocaliseerd.                 }
{                                                                          }
PROCEDURE ProblemFindersMenu;

VAR Quit : BOOLEAN;

BEGIN
     MenuDefine (2,3,'Problem Finders');
     MenuAddItem ('Origin Akas listing');
     MenuShow;

     Quit:=FALSE;
     REPEAT
           CASE MenuSelect OF
                kEsc   : Quit:=TRUE;
                mOpt01 : SpecialAreaListing;
           END; { case }
     UNTIL Quit;

     MenuErase;
END;

END.
