{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT MakeOut;

{ Deze unit bevat alle routines om Fido .PKTs in de outbound aan te maken }
{ en UUCP .DAT files in de spool directories te schrijven.                }

{ Few issues for future implementations:

  Max job name length = 14 chars long (or was it 15?) (old unix limitation)
  Including .D and .X etc. ??
  When using bitmask, the job can only be 4 digits, otherwise 5
  Use 14-6 = 8 chars of the uucpname.
}

{ History:

RvdW 02-03-93 Begonnen met deze unit ahv outbound routines van MD
     05-03-93 Afgemaakt en CloseAllOpenHandles toegevoegd.
     30-03-93 UseNet .DAT schrijf routines toegevoegd.
     02-04-93 ExportedUseNet en ExportedFido toegevoegd.
     03-04-93 WriteEnding0sToAllPkts doet dat vanaf nu alleen nog maar bij
              _F systems en dus niet maar aan de .DAT files.
              Na het schrijven van de vier nullen wordt de .PKT meteen
              dicht gegooid.
     16-05-93 Controle op maximale lengte van .DAT en .PKT files ingebouwd.
              Als de file vol is wordt deze weggewerkt (archive, compress)
              en een nieuwe file gestart.
              Het controleren op het vol zijn van een van de file gebeurd
              met een aparte routine die aangeroepen wordt na het exporteren
              van een bericht. Dit voorkomt dat er midden in een bericht
              wordt gekapt met de file.
     17-05-93 Compress en CunBatch toegevoegd. Bij CloseAllOpenHandles
              worden nu alle files gesloten en daarna eventueel nog
              gecomprimeerd.
              Er worden nu ook .XQT en .CMD files aangemaakt.
     31-05-93 Voor het schrijven van een usenet mailtje kan nu een nieuwe
              .DAT file geforceerd worden.
              Voordat een .XQT of .CMD wordt gemaakt, wordt nu eerst zeker
              gesteld dat er een vrij handle is om een file te openen.
              procedure: CheckFreeHandle.
     06-06-93 XqtLineC toegevoegd.
     17-06-93 Vanaf nu wordt GetUseNetUniqueName gebruikt voor de .DAT etc
              filenamen, in plaats van GetFidoPktName.

     960716   Add WriteToSmtp for mail export to SMTP queue.
}


INTERFACE

USES Database,
     Fido,
     FidoPkt;

PROCEDURE WriteEnding0sToAllPkts;
PROCEDURE CloseAllOpenHandles;
PROCEDURE WriteMsgToPkt (VAR MsgStatus : FidoMsgStatus; VAR UserData : UserBaseRecord; PktSenderAdres : FidoAddrType;
                         VAR PackedMsg; PackedMsgLen : WORD);
PROCEDURE WriteMsgToDat (VAR UserData : UserBaseRecord;
                         VAR PackedMsg; PackedMsgLen : WORD; Mail : BOOLEAN);
PROCEDURE WriteMsgToSmtp (VAR USerData : UserBaseRecord;
                          VAR PackedMsg; PackedMsgLen : WORD);
PROCEDURE CheckExportFilesFull;
PROCEDURE ExportForceFileFull (UUCPName : UUCPNameString);
FUNCTION  CalcOutBitmask (Name : STRING) : STRING;

VAR XqtLineC        : STRING[80]; { rnews / rmail <address> }
    WrkFileFrom     : STRING;
    GZipBatchLetter : CHAR;
    GigoMinusFLine  : STRING[80];


IMPLEMENTATION

USES Dos,
     Ramon,
     Logs,
     Cfg,
     Globals,
     NewExec,
     UserBase,
     Usenet,
     Cun,
     Start,
     UseAdres;

CONST {FourZeros : LONGINT = 0;}
      TwoZeros : WORD = 0;
      BailingOut = 'Bailing out!';

TYPE InfoListRecordPtr = ^InfoListRecord;
     InfoListRecord = RECORD
                            NextInfoListRecordPtr : InfoListRecordPtr;

                            OutName  : STRING[79+1+12];{ naam de .PKT/.DAT }
                            OutSize  : LONGINT;   { voor max .PKT/.DAT len }
                            OutFile  : FILE;              { output sluisje }
                            Opened   : BOOLEAN;           { is ie nu open? }
                            Accessed : BYTE;

                            System   : SystemType;    { voor het afsluiten }

                            MaxLen   : LONGINT;
                            FileFull : BOOLEAN;

                            CASE SystemType OF
                                 _F : (Adres  : FidoAddrType;
                                       Status : FidoMsgStatus);

                                 _U : (UUCPName   : UUCPNameString;
                                       DoCompress : UseCompressType;
                                       CunBatch   : BOOLEAN);
                       END;

     HandleIndexType = 1..MostHandles;

     HandleActionType = (Normal,ForceClose);

VAR FirstInfoListRecordPtr : InfoListRecordPtr;
    Handles                : ARRAY[HandleIndexType] OF InfoListRecordPtr;


{--------------------------------------------------------------------------}
{ RenameToCMD                                                              }
{                                                                          }
{ Deze routine wordt gebruikt om een spool sub-directory te doorzoeken op  }
{ .CM$ files en deze te renamen in .CMD zodat de mailer zo op kan pikken.  }
{                                                                          }
PROCEDURE RenameToCMD (Path : STRING);

VAR RenFile : FILE;
    IORes   : BYTE;
    Search  : SearchRec;

BEGIN
     { rename all .CM$ files to .CMD }
     FindFirst (Path+'*.CM$',Archive,Search);
     WHILE (DosError = 0) DO
     BEGIN
          Assign (RenFile,Path+Search.Name);
          {$I-} Rename (RenFile,Path+Copy (Search.Name,1,Length (Search.Name)-1)+'D'); {$I+} IORes:=IOResult;
          IF (IORes <> 0) THEN
             LogDiskIOError (IORes,'Failed to rename '+Path+Search.Name+' to .CMD');

          FindNext (Search);
     END;

     FindClose (Search);
END;


{--------------------------------------------------------------------------}
{ CalcOutBitmask                                                           }
{                                                                          }
{ Deze routine berekent de bitmask voor uitgaande files. Dit is de eerste  }
{ letter voor de echte naam.                                               }
{                                                                          }
FUNCTION CalcOutBitmask (Name : STRING) : STRING;
BEGIN
     { dit is heel simpel, want we gebruiken nog geen kleine letters  }
     { in de namen die we aanmaken. We moeten alleen even met de vlag }
     { rekening houden die ons forceert de oude method te gebruiken   }
     { in plaats van de nieuwe.                                       }
     IF Config.ForceNoBitmask THEN
        CalcOutBitmask:=Name
     ELSE BEGIN
          { toch maar even checken }
          IF (Name <> UpCaseString (Name)) THEN
             LogMessage ('WARNING: Bitmask will fail!');

          { omdat er geen kleine lettertjes in zitten is de mask '0' }
          CalcOutBitmask:='0'+Name;
     END;
END;


{=== InfoList routines ====================================================}

{--------------------------------------------------------------------------}
{ AddInfoListRecord                                                        }
{                                                                          }
{ Deze routine maakt een nieuw InfoList record aan op de heap en voegt     }
{ deze aan het begin van de lijst toe.                                     }
{                                                                          }
PROCEDURE AddInfoListRecord (Info : InfoListRecord; VAR NewInfoListRecordPtr : InfoListRecordPtr);
BEGIN
     GetMem (NewInfoListRecordPtr,SizeOf (InfoListRecord));
     PeekMem;
     Move (Info,NewInfoListRecordPtr^,SizeOf (InfoListRecord));
     NewInfoListRecordPtr^.NextInfoListRecordPtr:=FirstInfoListRecordPtr;
     FirstInfoListRecordPtr:=NewInfoListRecordPtr;
END;


{--------------------------------------------------------------------------}
{ DeleteAllInfoListRecords                                                 }
{                                                                          }
{ Deze routine verwijderd alle aanwezige InfoListRecords.                  }
{                                                                          }
PROCEDURE DeleteAllInfoListRecords;

VAR DeleteInfoListRecordPtr : InfoListRecordPtr;

BEGIN
     WHILE (FirstInfoListRecordPtr <> NIL) DO
     BEGIN
          DeleteInfoListRecordPtr:=FirstInfoListRecordPtr;
          FirstInfoListRecordPtr:=FirstInfoListRecordPtr^.NextInfoListRecordPtr;
          FreeMem (DeleteInfoListRecordPtr,SizeOf (InfoListRecord));
     END;
END;


{--------------------------------------------------------------------------}
{ FindFidoInfoListRecord                                                   }
{                                                                          }
{ Zoek of het opgegeven fido adres voorkomt in de lijst met info over de   }
{ aangemaakte / aan te maken .PKT files.                                   }
{                                                                          }
FUNCTION FindFidoInfoListRecord (Adres : FidoAddrType;
                                 VAR FoundFidoInfoListRecordPtr : InfoListRecordPtr;
                                 Status : FidoMsgStatus ) : BOOLEAN;
BEGIN
     FoundFidoInfoListRecordPtr:=FirstInfoListRecordPtr;

     WHILE (FoundFidoInfoListRecordPtr <> NIL) AND
           (NOT ((FoundFidoInfoListRecordPtr^.System = _F) AND
                 (Status = FoundFidoInfoListRecordPtr^.Status) AND
                 FidoCompare (FoundFidoInfoListRecordPtr^.Adres,Adres)))
     DO
       FoundFidoInfoListRecordPtr:=FoundFidoInfoListRecordPtr^.NextInfoListRecordPtr;

     FindFidoInfoListRecord:=(FoundFidoInfoListRecordPtr <> NIL);
END;


{--------------------------------------------------------------------------}
{ FindUUCPInfoListRecord                                                   }
{                                                                          }
{ Zoek of het opgegeven Usenet UUCPName voorkomt in de lijst met info over }
{ de aangemaakte / aan te maken .DAT files. De opgegeven zoek-UUCPName     }
{ moet in hoofdletters zijn. Dit was een bug op 161094.                    }
{                                                                          }
FUNCTION FindUUCPInfoListRecord (UUCPName : UUCPNameString; VAR FoundUUCPInfoListRecordPtr : InfoListRecordPtr) : BOOLEAN;
BEGIN
     FoundUUCPInfoListRecordPtr:=FirstInfoListRecordPtr;
     UUCPName:=UpCaseString (DeleteBackSpaces (UUCPName));

     WHILE (FoundUUCPInfoListRecordPtr <> NIL) AND
           (NOT ((FoundUUCPInfoListRecordPtr^.System = _U) AND
                 (FoundUUCPInfoListRecordPtr^.UUCPName = UUCPName)))
     DO
       FoundUUCPInfoListRecordPtr:=FoundUUCPInfoListRecordPtr^.NextInfoListRecordPtr;

     FindUUCPInfoListRecord:=(FoundUUCPInfoListRecordPtr <> NIL);
END;


{--------------------------------------------------------------------------}
{ FindSmtpInfoListRecord                                                   }
{                                                                          }
{ Zoek of het opgegeven UUCPName voorkomt in de lijst met info over de     }
{ aangemaakte / aan te maken files. De opgegeven zoek-UUCPName moet in     }
{ hoofdletters zijn.                                                       }
{                                                                          }
FUNCTION FindSmtpInfoListRecord (UUCPName : UUCPNameString; VAR FoundSmtpInfoListRecordPtr : InfoListRecordPtr) : BOOLEAN;
BEGIN
     FoundSmtpInfoListRecordPtr:=FirstInfoListRecordPtr;
     UUCPName:=UpCaseString (DeleteBackSpaces (UUCPName));

     WHILE (FoundSmtpInfoListRecordPtr <> NIL) AND
           (FoundSmtpInfoListRecordPtr^.System <> _S) AND
           (FoundSmtpInfoListRecordPtr^.UUCPName <> UUCPName)
     DO
       FoundSmtpInfoListRecordPtr:=FoundSmtpInfoListRecordPtr^.NextInfoListRecordPtr;

     FindSmtpInfoListRecord:=(FoundSmtpInfoListRecordPtr <> NIL);
END;


{--------------------------------------------------------------------------}
{ FindOldestHandle                                                         }
{                                                                          }
{ Deze routine zoekt in de handles tabel naar de oudste handle die erin    }
{ voorkomt en geeft het index nummer daarvan terug.                        }
{                                                                          }
FUNCTION FindOldestHandle (HandleAction : HandleActionType) : HandleIndexType;

VAR Oldest : BYTE;
    Lp     : HandleIndexType;

BEGIN
     Oldest:=255;

     FOR Lp:=1 TO Config.MaxHandles DO
         IF (Handles[Lp] = NIL) AND (HandleAction = Normal) THEN
         BEGIN
              FindOldestHandle:=Lp;
              Exit;
         END ELSE
             IF (Handles[Lp] <> NIL) AND (Handles[Lp]^.Accessed < Oldest) THEN
             BEGIN
                  FindOldestHandle:=Lp;
                  Oldest:=Handles[Lp]^.Accessed;
             END;

     IF (Oldest = 255) THEN
        Error ('[FindOldestHandle] No handles left to force closing');
END;


{--------------------------------------------------------------------------}
{ OpenOutputFile                                                           }
{                                                                          }
{ Deze routine opent de output file. Hiervoor wordt eerst een plekje       }
{ gezocht in de Handles tabel. Als die vol is, dan moet er een uitgegooid  }
{ worden en komt deze in de plaats. Als het openen daarna niet lukt, dan   }
{ wordt er nog een uit de lijst gegooid, net zolang tot het openen wel     }
{ lukt. Bij het uit de lijst gooien worden de files ook meteen gesloten.   }
{                                                                          }
{ RWI 960716: made into a function and now returning TRUE on serious       }
{             errors that can occur in network configurations or simply    }
{             paths that don't exist and will never show up.               }
{                                                                          }
FUNCTION OpenOutputFile (ToOpenInfoListRecordPtr : InfoListRecordPtr) : BOOLEAN;

VAR Lp,
    Handle,
    FilledInHandle : HandleIndexType;
    FilledIn       : BOOLEAN;
    IORes          : BYTE;
    HandleAction   : HandleActionType;

BEGIN
     UpdateWriteFile (ToOpenInfoListRecordPtr^.OutName,0);

     IF (ToOpenInfoListRecordPtr^.Opened = TRUE) THEN
     BEGIN
          OpenOutputFile:=TRUE; { RWI 960819: added }
          Exit; { is open en staat ook nog op eof }
     END;

     FilledIn:=FALSE;
     HandleAction:=Normal;
     ToOpenInfoListRecordPtr^.Accessed:=255;
     REPEAT
           Handle:=FindOldestHandle (HandleAction);

           IF (Handles[Handle] <> NIL) THEN
           BEGIN
                WITH Handles[Handle]^ DO
                BEGIN
                     IF Opened THEN
                     BEGIN
                          Close (OutFile);
                          PeekFiles;
                     END;
                     Opened:=FALSE;
                     Accessed:=255;
                END; { with }

                Handles[Handle]:=NIL;

                FOR Lp:=1 TO Config.MaxHandles DO
                    IF (Handles[Lp] <> NIL) THEN
                       Dec (Handles[Lp]^.Accessed);
           END;

           IF (NOT FilledIn) THEN
           BEGIN
                Handles[Handle]:=ToOpenInfoListRecordPtr;
                FilledInHandle:=Handle;
                FilledIn:=TRUE;
           END;

           WITH Handles[FilledInHandle]^ DO
           BEGIN
                {$I-} Reset (OutFile,1); {$I+} IORes:=IOResult;
                PeekFiles;

                IF (IORes = 2) THEN { file not found; aanmaken dus }
                BEGIN
                     {$I-} ReWrite (OutFile,1); {$I+} IORes:=IOResult;
                     PeekFiles;
                END;

                IF (IORes = 4) THEN { too much open files, een sluiten dus }
                   HandleAction:=ForceClose;

                IF (IORes <> 0) AND (IORes <> 2) AND (IORes <> 4) THEN
                BEGIN
                     LogDiskIOError (IORes,'Serious: cannot open/create '+OutName);
                     OpenOutputFile:=FALSE;
                     Exit;
                END;

                IF (IORes = 0) THEN
                   Opened:=TRUE;
                { anders nog een zoeken en eruit gooien }
           END; { with }

     UNTIL ToOpenInfoListRecordPtr^.Opened;

     ToOpenInfoListRecordPtr^.Accessed:=0;
     FOR Lp:=1 TO Config.MaxHandles DO
         IF (Handles[Lp] <> NIL) THEN
            Inc (ToOpenInfoListRecordPtr^.Accessed);

     ToOpenInfoListRecordPtr^.OutSize:=FileSize (ToOpenInfoListRecordPtr^.OutFile);
     Seek (ToOpenInfoListRecordPtr^.OutFile,ToOpenInfoListRecordPtr^.OutSize);

     OpenOutputFile:=TRUE;
END;


{--------------------------------------------------------------------------}
{ CloseOutputFile                                                          }
{                                                                          }
{ Deze routine sluit de opgegeven file en geeft de handle weer vrij.       }
{                                                                          }
PROCEDURE CloseOutputFile (Info : InfoListRecordPtr);

VAR Lp : HandleIndexType;

BEGIN
     WITH Info^ DO
     BEGIN
          IF Opened THEN
          BEGIN
               Close (OutFile);
               Opened:=FALSE;
          END;

          FOR Lp:=1 TO MostHandles DO
              IF (Handles[Lp] = Info) THEN
                 Handles[Lp]:=NIL;
     END; { with }

     PeekFiles;
END;


{--------------------------------------------------------------------------}
{ CheckFreeHandle                                                          }
{                                                                          }
{ Deze routine kijkt of het mogelijk is om een file te openen. Als dat     }
{ niet zo is, dan wordt er een dichtgegooid volgens het gebruikelijke      }
{ algoritme: oudste eerst.                                                 }
{                                                                          }
PROCEDURE CheckFreeHandle;

VAR IORes    : BYTE;
    TestFile : FILE;

BEGIN
     REPEAT
           Assign (TestFile,TempPath+'TESTFILE');
           {$I-} ReWrite (TestFile); {$I+} IORes:=IOResult;
           PeekFiles;

           IF (IORes <> 0) THEN
              CloseOutputFile (Handles[FindOldestHandle (ForceClose)]);
     UNTIL (IORes = 0);

     Close (TestFile);
     PeekFiles;
     Erase (TestFile);
END;


{--------------------------------------------------------------------------}
{ CloseAllOpenHandles                                                      }
{                                                                          }
{ Deze routine sluit alle open handles en roept daarna                     }
{ DeleteAllInfoListRecords aan om alle aangemaakte records te verwijderen. }
{ Deze routine moet aangeroepen worden als er niets meer naar de OutFiles  }
{ geschreven hoeft te worden, bijvoorbeeld als alle pakketten verwerkt     }
{ zijn.                                                                    }
{                                                                          }
PROCEDURE CloseAllOpenHandles;

VAR Lp       : HandleIndexType;
    CurrList : InfoListRecordPtr;
    OldDir   : STRING[100];
    Name     : STRING[12];
    RenFile  : FILE;
    IORes    : BYTE;

BEGIN
     FOR Lp:=1 TO Config.MaxHandles DO
         IF (Handles[Lp] <> NIL) THEN
         BEGIN
              WITH Handles[Lp]^ DO
                   IF Opened THEN
                   BEGIN
                        Close (OutFile);
                        Opened:=FALSE;
                   END;

              Handles[Lp]:=NIL;
         END;

     PeekFiles;

     CurrList:=FirstInfoListRecordPtr;
     WHILE (CurrList <> NIL) DO
     BEGIN
          WITH CurrList^ DO
          BEGIN
               { RWI 951127: "OR CunBatch" verwijderd }
               IF (System = _U) THEN
               BEGIN
                    { voorbereiden compress / cunbatch }
                    GetDir (0,OldDir);

                    { naam destileren uit de OutName }
                    Name:=Copy (OutName,Length (OutName)-11,12);
                    WHILE (Pos ('\',Name) > 0) DO
                          Delete (Name,1,1);

                    { compressen }
                    IF (DoCompress <> USE_NONE) THEN
                    BEGIN
                         IF (DoCompress = USE_COMPRESS) THEN
                            GoExec (Config.ComprPrg_U[Compress,Compr],Config.SpoolBaseDir+UUCPName+'\'+Name,
                                    'Compressing for '+UUCPName)
                         ELSE
                             GoExec (Config.ComprPrg_U[GZip,Compr],Config.SpoolBaseDir+UUCPName+'\'+Name,
                                     'GZipping for '+UUCPName);

                         { rename de gemaakte .DAZ weer naar .DAT }
                         Assign (RenFile,Config.SpoolBaseDir+UUCPName+'\'+Copy (Name,1,Length (Name)-1)+'Z');
                         {$I-} Rename (RenFile,Config.SpoolBaseDir+UUCPName+'\'+Name); {$I+} IORes:=IOResult;
                         IF (IORes <> 0) THEN
                            LogDiskIOError (IORes,'Compressed .DAZ file not found for renaming');

                         { RWI 950727: binnen de "if compress at all"    }
                         {             gehaald om CunBatch op een niet-  }
                         {             gecomprimeerde file te voorkomen. }

                         { cunbatch toevoegen aan het begin van de file }
                         IF CunBatch THEN
                         BEGIN
                              ChDir (Config.SpoolBaseDir+UUCPName);

                              IF (DoCompress = USE_COMPRESS) THEN
                                 AddCun (Name,'c')    { c = cunbatch }
                              ELSE
                                  AddCun (Name,GZipBatchLetter);

                              {GoExec (Config.CunBatchPrg[Compr],Name);}
                              ChDir (OldDir);
                         END;

                    END; { if compress at all }

                    RenameToCMD (Config.SpoolBaseDir+UUCPName+'\');

               END; { if _U }

               CurrList:=NextInfoListRecordPtr;
          END; { with }
     END;

     DeleteAllInfoListRecords;
END;


{--------------------------------------------------------------------------}
{ WriteEnding0sToAllPkts                                                   }
{                                                                          }
{ Deze routine schrijft aan het einde van alle .PKTs die in deze sessie    }
{ zijn aangemaakt een reeks van 2 nullen om het einde van het pakket aan   }
{ te duiden.                                                               }
{ In de InfoList records staan alle namen van de PKTs die aangemaakt zijn. }
{                                                                          }
{ RvdW 03-04-93 controle op _F ingebouwd. Anders werden de .DAT files ook  }
{               voorzien van vier nullen aan het einde... :-)              }
{ RWI 950312: Nu worden er maar 2 nullen geschreven. Het waren er vier...  }
{             Een andere tosser begon te klagen!                           }
{                                                                          }
PROCEDURE WriteEnding0sToAllPkts;

VAR CurrInfoListRecordPtr : InfoListRecordPtr;
    IORes                 : BYTE;

BEGIN
     { als er nog open .PKT files zijn, sluit er dan eerst een om niet }
     { over het maximum aantal open files heen te knallen.             }
     CurrInfoListRecordPtr:=FirstInfoListRecordPtr;
     WHILE (CurrInfoListRecordPtr <> NIL) DO
     BEGIN
          IF CurrInfoListRecordPtr^.Opened THEN
          BEGIN
               CloseOutputFile (CurrInfoListRecordPtr);
               CurrInfoListRecordPtr:=NIL; { stop met zoeken }
          END ELSE
              CurrInfoListRecordPtr:=CurrInfoListRecordPtr^.NextInfoListRecordPtr;
     END;

     CurrInfoListRecordPtr:=FirstInfoListRecordPtr;
     WHILE (CurrInfoListRecordPtr <> NIL) DO
     BEGIN
          IF (CurrInfoListRecordPtr^.System = _F) THEN
             IF OpenOutputFile (CurrInfoListRecordPtr) { en ga naar eof } THEN
             BEGIN
                  {$I-} BlockWrite (CurrInfoListRecordPtr^.OutFile,TwoZeros,2); {$I+}
                  IORes:=IOResult;
                  IF (IORes <> 0) THEN
                     LogDiskIOError (IORes,'[MAKEOUT.PAS] Error writing ending zeros to .PKT file');

                  UpdateInfoNr (INFO_PktOut_Bytes,2);

                  CloseOutputFile (CurrInfoListRecordPtr);
             END ELSE
                 LogExtraMessage ('Failed to write ending zeros to that file');

          CurrInfoListRecordPtr:=CurrInfoListRecordPtr^.NextInfoListRecordPtr;
     END;
END;


{--------------------------------------------------------------------------}
{ WriteMsgToPkt                                                            }
{                                                                          }
{ Deze routine verstuurt een blok gegevens naar een fido outbound .PKT     }
{ bestand. Als dat bestand nog niet bestaat dan wordt deze aangemaakt en   }
{ er een informatie record over in het geheugen aangemaakt.                }
{ Opgegeven moet worden: het userbase record van de user, een pointer naar }
{ de al ingepakte msg en het aantal bytes dat de ingepakte msg lang is.    }
{ Hiervan wordt een msg header gemaakt en als de .PKT nog niet bestond ook }
{ een packet header.                                                       }
{                                                                          }
{ Let op! Omdat het heel goed mogelijk is dat een onbekende node DIRECT    }
{ een meeltje gestuurd krijgt, kan het zijn dat het userdata record alleen }
{ het allernoodzakelijkste bevat : Address + MaxPktLen + PktPassword !!!!  }
{                                                                          }
PROCEDURE WriteMsgToPkt (VAR MsgStatus : FidoMsgStatus;
                         VAR UserData : UserBaseRecord;
                         PktSenderAdres : FidoAddrType;
                         VAR PackedMsg; PackedMsgLen : WORD);

VAR FoundInfoListRecordPtr : InfoListRecordPtr;
    NewInfoListRecord      : InfoListRecord;
    IORes                  : BYTE;

    {----------------------------------------------------------------------}
    { WritePktHeader                                                       }
    {                                                                      }
    { Schrijft een fido header naar de .PKT en zet daarin de opgegeven AKA }
    { van ons als afzender adres. Als destination adres moet het adres van }
    { de user komen te staan.                                              }
    {                                                                      }
    PROCEDURE WritePktHeader;

    VAR cYear,cMonth,cDay,
        cHour,cMin,cSec,
        Nop              : WordLong;
        Len,Lp           : BYTE;
        Header           : FidoPktHdr;

    BEGIN
         GetDate (cYear,cMonth,cDay,Nop);
         GetTime (cHour,cMin,cSec,Nop);

         { Output van type 2+ pakketten                                   }
         {                                                                }
         { Vraag niet waarom, als ik me aan FSC-0039 of FSC-0048 hou, dan }
         { herkent Squish het niet als een 2+ pakket, als ik echter       }
         { na wat random geklooi met Squish PKT's dit formaat gebruikt    }
         { loopt het wel....                                              }
         {                                                                }
         WITH Header DO
         BEGIN
              Orig_Zone:=PktSenderAdres.Zone;
              Orig_Net:=PktSenderAdres.Net;
              Orig_Node:=PktSenderAdres.Node;
              Orig_Point:=PktSenderAdres.Point;

              Qm_Orig_Zone:=PktSenderAdres.Zone;

              IF (UserData.System = _BBS) THEN
              BEGIN
                   Dest_Zone:=Config.NodeNrs[UserData.SystemAka].Zone;
                   Dest_Net:=Config.NodeNrs[UserData.SystemAka].Net;
                   Dest_Node:=Config.NodeNrs[UserData.SystemAka].Node;
                   Dest_Point:=0;
                   Qm_Dest_Zone:=Config.NodeNrs[UserData.SystemAka].Zone;
              END ELSE
              BEGIN
                   Dest_Zone:=UserData.Address.Zone;
                   Dest_Net:=UserData.Address.Net;
                   Dest_Node:=UserData.Address.Node;
                   Dest_Point:=UserData.Address.Point;
                   Qm_Dest_Zone:=UserData.Address.Zone;
              END;

              Year:=cYear;
              Month:=cMonth -1;
              Day:=cDay;
              Hour:=cHour;
              Minute:=cMin;
              Second:=cSec;

              Baud:=0;
              Ver:=2;

              Product:=OurFidoProductCode;
              Rev_lev:=OurFidoRevLevel;

              F48_AuxNet:=PktSenderAdres.Net;
              F48_ValidationCopy:=$100; {Squish?}
              F48_ProduktCode:=00;   {OurFidoProductCode;}
              F48_Revision:=00;   {OurFidoRevLevel;}
              F48_Capability:=1;

              IF (UserData.System = _F) THEN
              BEGIN
                   UserData.PacketPwd:=DeleteBackSpaces (UserData.PacketPwd);
                   Len:=Length (UserData.PacketPwd);
                   Move (UserData.PacketPwd[1],Password,8);
              END ELSE
                  Len:=0; { _BBS: no password }

              IF (Len < 8) THEN
                 FOR Lp:=Len+1 TO 8 DO Password[Lp]:=0;

         END; { with }

         {$I-} BlockWrite (FoundInfoListRecordPtr^.OutFile,Header,SizeOf (FidoPktHdr)); {$I-}
         IORes:=IOResult;
         IF (IORes <> 0) THEN
            LogDiskIOError (IORes,'Error writing PKT header');

         UpdateInfoNr (INFO_PktOut_Bytes,SizeOf (FidoPktHdr));
         UpdateInfoNr (INFO_PktOut_Jobs,1);
    END;

{WriteMsgToPkt}
BEGIN
     { een InfoList record aanmaken als die er nog niet is voor deze node }
     IF (NOT FindFidoInfoListRecord (UserData.Address,FoundInfoListRecordPtr,MsgStatus)) THEN
     BEGIN
          WITH NewInfoListRecord DO
          BEGIN
               NextInfoListRecordPtr:=NIL;       { is eigenlijk niet nodig }
               Opened:=FALSE;
               Adres:=UserData.Address;
               System:=_F;
               Status:=MsgStatus;
               MaxLen:=UserData.MaxPktLength;
               FileFull:=FALSE;
          END;

          AddInfoListRecord (NewInfoListRecord,FoundInfoListRecordPtr);
          WITH FoundInfoListRecordPtr^ DO
          BEGIN
               IF (UserData.System = _BBS) THEN
                  OutName:=UserData.Outbound
               ELSE
                   OutName:=Config.Outbound_F;

               OutName:=OutName+GetFidoPktName;

               IF (MsgStatus = FidoMsgCrash) THEN
                  OutName:=OutName+'.CQQ'
               ELSE
                   OutName:=OutName+'.QQQ';

               Assign (OutFile,OutName);
          END;

          IF (NOT OpenOutputFile (FoundInfoListRecordPtr)) THEN
          BEGIN
               LogExtraMessage ('[WriteToPkt] '+BailingOut);
               Exit;
          END;

          WritePktHeader;
     END;

     IF (NOT OpenOutputFile (FoundInfoListRecordPtr) { en seek eof }) THEN
     BEGIN
          LogExtraMessage ('[WriteToPkt] '+BailingOut);
          Exit;
     END;

     IF FoundInfoListRecordPtr^.FileFull THEN
        WITH FoundInfoListRecordPtr^ DO
        BEGIN
             { nieuwe file beginnen }
             { staat nog aan het einde van de file door de OpenOutputFile }
             { van hierboven. Schrijf de 4 ending zeros naar de file.     }
             {$I-} BlockWrite (OutFile,TwoZeros,2); {$I+}
             IORes:=IOResult;
             IF (IORes <> 0) THEN
                LogDiskIOError (IORes,'[WriteToPkt] Error writing ending zeros to .PKT file');

             UpdateInfoNr (INFO_PktOut_Bytes,2);

             CloseOutputFile (FoundInfoListRecordPtr);

             { nu is ie niet meer "vol" }
             FileFull:=FALSE;

             { nieuwenaam bedenken }
             IF (UserData.System = _BBS) THEN
                OutName:=UserData.Outbound
             ELSE
                 OutName:=Config.Outbound_F;

             OutName:=OutName+GetFidoPktName;

             IF (MsgStatus = FidoMsgCrash) THEN
                OutName:=OutName+'.CQQ'
             ELSE
                 OutName:=OutName+'.QQQ';

             { nieuwe file aanmaken en de header erin schrijven }
             Assign (OutFile,OutName);
             IF (NOT OpenOutputFile (FoundInfoListRecordPtr)) THEN
             BEGIN
                  LogExtraMessage ('[WriteToPkt] '+BailingOut);
                  Exit;
             END;

             WritePktHeader;

        END; { with, if  }

     {$I-} BlockWrite (FoundInfoListRecordPtr^.OutFile,PackedMsg,PackedMsgLen); {$I+}
     IORes:=IOResult;
     UpdateInfoNr (INFO_PktOut_Bytes,PackedMsgLen);

     IF (IORes <> 0) THEN
        LogDiskIoError (IORes,'[ExportMsgToPkt] Packed message write error');

     WITH FoundInfoListRecordPtr^ DO
          OutSize:=FileSize (OutFile);
END;


{--------------------------------------------------------------------------}
{ GetNextSmtpOutSequence                                                   }
{                                                                          }
{ Deze routine leests de sequence.seq file in verhoogt deze met 1 en geeft }
{ dat nummer terug na het weer in de file geschreven te hebben.            }
{                                                                          }
FUNCTION GetNextSmtpOutSequence (Path : STRING) : STRING;

VAR Nr      : LONGINT;
    SeqFile : TEXT;
    IORes   : BYTE;

BEGIN
     Path:=Path+'SEQUENCE.SEQ';
     Nr:=1; { in case it doesn't exist yet }

     Assign (SeqFile,Path);
     {$I-} Reset (SeqFile); {$I+} IORes:=IOResult;
     IF (IORes = 0) THEN
        ReadLn (SeqFile,Nr)
     ELSE
         IF (IORes <> 2) THEN
            LogDiskIOError (IORes,'Failed to open '+Path);

     { dit nummer gebruiken }
     GetNextSmtpOutSequence:=Longint2String (Nr);

     { en daarna pas verhogen }
     Inc (Nr);

     { Close And Rewrite }
     {$I-} ReWrite (SeqFile); {$I+} IORes:=IOResult;
     IF (IORes = 0) THEN
     BEGIN
          WriteLn (SeqFile,Nr);
          Close (SeqFile);
          PeekFiles;
     END ELSE
     BEGIN
          LogDiskIOError (IORes,'Failed to create '+Path);

          { close, just in case }
          {$I-} Close (SeqFile); {$I+} IORes:=IOResult;
     END;

     UpdateInfoNr (INFO_SmtpOut_Jobs,1);
END;


{--------------------------------------------------------------------------}
{ WriteMsgToSmtp                                                           }
{                                                                          }
{ Deze routine exporteert een Internet mail message naar de SMTP-Out queue }
{ van deze user.                                                           }
{                                                                          }
PROCEDURE WriteMsgToSmtp (VAR UserData : UserBaseRecord;
                          VAR PackedMsg;
                          PackedMsgLen : WORD);

VAR FoundInfoListRecordPtr : InfoListRecordPtr;
    NewInfoListRecord      : InfoListRecord;
    IORes                  : BYTE;
    WrkFile                : TEXT;
    Domain,User            : STRING;
    CreateJob              : BOOLEAN;

BEGIN
     CreateJob:=FALSE;

     { een InfoList record aanmaken als die er nog niet is voor deze node }
     IF (NOT FindSmtpInfoListRecord (UserData.UUCPName,FoundInfoListRecordPtr)) THEN
     BEGIN
          WITH NewInfoListRecord DO
          BEGIN
               NextInfoListRecordPtr:=NIL;       { is eigenlijk niet nodig }
               UUCPName:=UpCaseString (DeleteBackSpaces (UserData.UUCPName));
               System:=_S;
               MaxLen:=0;    { alles in e'e'n file }

               CreateJob:=TRUE;
          END; { with }

          AddInfoListRecord (NewInfoListRecord,FoundInfoListRecordPtr);
     END ELSE
         IF FoundInfoListRecordPtr^.FileFull THEN
            CreateJob:=TRUE;

     WITH FoundInfoListRecordPtr^ DO
          IF CreateJob THEN
          BEGIN
               UserData.SmtpOutPath:=CorrectPath (UserData.SmtpOutPath);

               OutName:=GetNextSmtpOutSequence (UserData.SmtpOutPath);

               IF Config.LogSMTPOutbound THEN
                  LogMessage ('Created SMTP job '+OutName+' for '+UUCPname);

               OutName:=UserData.SmtpOutPath+OutName;

               Opened:=FALSE;
               FileFull:=FALSE;

               CheckFreeHandle;

               { .LCK file zetten? }

               { maak een .WRK file aan }
               Assign (WrkFile,OutName+'.WRK');
               {$I-} ReWrite (WrkFile); {$I+} IORes:=IOResult;
               IF (IORes <> 0) THEN
                  LogDiskIOError (IORes,'Failed to create '+OutName+'.WRK')
               ELSE BEGIN
                    XqtLineC:=Copy (XqtLineC,Pos (' ',XqtLineC)+1,255);

                    IF (Config.SmtpForward = '') THEN
                    BEGIN
                         UseAdresParse (XqtLineC,Domain,User);
                         WriteLn (WrkFile,Domain);
                    END ELSE
                        WriteLn (WrkFile,Config.SmtpForward);

                    WriteLn (WrkFile,WrkFileFrom);
                    WriteLn (WrkFile,XqtLineC);
                    Close (WrkFile);
               END;

               PeekFiles;

               { voor later gebruik }
               OutName:=OutName+'.TXT';
               Assign (OutFile,OutName);
          END; { CreateJob, with }

     IF (NOT OpenOutputFile (FoundInfoListRecordPtr){en seek eof}) THEN
     BEGIN
          LogExtraMessage ('[WriteToSmtp] '+BailingOut);
          Exit;
     END;

     {$I-} BlockWrite (FoundInfoListRecordPtr^.OutFile,PackedMsg,PackedMsgLen); {$I+}
     IORes:=IOResult;

     UpdateInfoNr (INFO_SmtpOut_Bytes,PackedMsgLen);

     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'[WriteMsgToSmtp] Write error');

     WITH FoundInfoListRecordPtr^ DO
          OutSize:=FileSize (OutFile);
END;


{--------------------------------------------------------------------------}
{ MakeXqtfile                                                              }
{                                                                          }
{ Deze routine maakt een .XQT file aan voor de opgegeven .DAT naam. Er     }
{ wordt nog vanuit gegaan dat het om een NEWS file gaat. Om ook MAIL te    }
{ kunnen verwerken moet straks dus iets uitgevonden worden.                }
{ Verder wordt hier nu ook .CMD files aangemaakt voor UUCICO.              }
{                                                                          }
{ RvdW 31-05-93 CheckFreeHandle ingebouwd.                                 }
{                                                                          }
PROCEDURE MakeXqtFile (DatName : STRING; GIGOT : BOOLEAN);

VAR XqtName : STRING[100];
    XqtFile : TEXT;
    IORes   : BYTE;
    Name    : STRING[8];
    UUCPName: STRING;      { RWI 960323: nu hele naam!  RWI 960305: veranderd van 6 in 7 }
    P       : BYTE;        { RWI 960323: voor ForceNoBitmask }
    CmdName : STRING[100];
    CmdFile : TEXT;

BEGIN
     CheckFreeHandle;

     { RWI 960325: vanaf nu zetten we de hele UUCPname erin! }
     UUCPName:=Config.UUCPName;
     P:=2;

     IF Config.ForceNoBitmask THEN
     BEGIN
          UUCPName:=Copy (UUCPName,1,6);
          P:=1;
     END;

     { extract the .DAT filename from the entire path }
     Name:=Copy (DatName,Length (DatName)-11,8);

     { RWI 960323: while veranderd in IF en delete (x,1,1) ook }
     IF (Pos ('\',Name) > 0) THEN
        Delete (Name,1,Pos ('\',Name));

     XqtName:=Copy (DatName,1,Length (DatName)-3)+'XQT';
     Assign (XqtFile,XqtName);
     {$I-} ReWrite (XqtFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'Cannot create '+XqtName)
     ELSE BEGIN
          IF GIGOT THEN
             Write (XqtFile,'#-f '+GigoMinusFLine+#10); { errors-to-addres }

          Write (XqtFile,'U '+ProgramUserName+' '+Config.UUCPName+#10);
          Write (XqtFile,'Z'+#10);
          Write (XqtFile,'F D.'+UUCPName+Copy (Name,P,255)+#10);
          Write (XqtFile,'I D.'+UUCPName+Copy (Name,P,255)+#10);
          Write (XqtFile,'C '+XqtLineC+#10);
          Close (XqtFile);
     END;

     PeekFiles;

     IF (NOT GIGOT) THEN
     BEGIN
          CmdName:=Copy (DatName,1,Length (DatName)-3)+'CM$';
          Assign (CmdFile,CmdName);
          {$I-} ReWrite (CmdFile); {$I+} IORes:=IOResult;
          IF (IORes <> 0) THEN
             LogDiskIOError (IORes,'Cannot create '+CmdName)
          ELSE BEGIN
               Write (CmdFile,'S '+Name+'.DAT D.'+UUCPName+Copy (Name,P,255)+' '+ProgramUserName+' - '+Name+'.DAT 0666'+#10);
               Write (CmdFile,'S '+Name+'.XQT X.'+UUCPName+Copy (Name,P,255)+' '+ProgramUserName+' - '+Name+'.XQT 0666'+#10);
               Close (CmdFile);
          END;
     END;

     PeekFiles;

     UpdateInfoNr (INFO_UucpOut_Jobs,1);
END;


{--------------------------------------------------------------------------}
{ WriteMsgToDat                                                            }
{                                                                          }
{ Deze routine exporteert een berichtje naar een UUCP .DAT file voor de    }
{ opgegeven node.                                                          }
{                                                                          }
PROCEDURE WriteMsgToDat (VAR UserData : UserBaseRecord;
                         VAR PackedMsg; PackedMsgLen : WORD;
                         Mail : BOOLEAN);

VAR FoundInfoListRecordPtr : InfoListRecordPtr;
    NewInfoListRecord      : InfoListRecord;
    IORes                  : BYTE;
    OldDir                 : STRING[100];
    Name                   : STRING[12];
    RenFile                : FILE;
    Grade                  : CHAR;

BEGIN
     IF Mail THEN
        Grade:=UserData.MailGrade
     ELSE
         Grade:=UserData.NewsGrade;

     { een InfoList record aanmaken als die er nog niet is voor deze node }
     IF (NOT FindUUCPInfoListRecord (UserData.UUCPName,FoundInfoListRecordPtr)) THEN
     BEGIN
          WITH NewInfoListRecord DO
          BEGIN
               NextInfoListRecordPtr:=NIL;       { is eigenlijk niet nodig }
               {RWI 161094: UpCaseString() toegevoegd}
               UUCPName:=UpCaseString (DeleteBackSpaces (UserData.UUCPName));
               System:=_U;
               IF Mail THEN MaxLen:=0 { alles in 1 file bij mail }
                       ELSE MaxLen:=Config.MaxDatLength;
               FileFull:=FALSE;

               OutName:=CalcOutBitmask (GetUsenetUniqueName (Grade,Config.ForceNoBitmask));

               IF Config.LogUUCPOutbound THEN
                  LogMessage ('Created UUCP job '+OutName+' for '+UUCPname);

               OutName:=Config.SpoolBaseDir+UUCPName+'\'+OutName+'.DAT';

               Opened:=FALSE;
               DoCompress:=UserData.Compress;
               CunBatch:=UserData.CunBatch;
          END;

          AddInfoListRecord (NewInfoListRecord,FoundInfoListRecordPtr);
          WITH FoundInfoListRecordPtr^ DO
               Assign (OutFile,OutName);

          { maak een .XQT file }
          MakeXqtFile (FoundInfoListRecordPtr^.OutName,UserData.GigoT);
     END;

     IF (NOT OpenOutputFile (FoundInfoListRecordPtr) { en seek eof }) THEN
     BEGIN
          LogExtraMessage ('[WriteToDat] '+BailingOut);
          Exit;
     END;

     IF FoundInfoListRecordPtr^.FileFull THEN
        WITH FoundInfoListRecordPtr^ DO
        BEGIN
             { .DAT file zit vol; nieuwe file beginnen }

             { komt zoooo vaak voor...
             LogMessage ('.DAT full at '+Longint2String (OutSize));
             }

             CloseOutputFile (FoundInfolistRecordPtr);

             { RWI 951127: "OR CunBatch" verwijderd }
             IF (DoCompress <> USE_NONE) THEN
             BEGIN
                  { voorbereiden compress / cunbatch }
                  GetDir (0,OldDir);

                  { naam destileren uit de OutName }
                  Name:=Copy (OutName,Length (OutName)-11,12);
                  WHILE (Pos ('\',Name) > 0) DO Delete (Name,1,1);

                  { compress-en }
                  IF (DoCompress <> USE_NONE) THEN
                  BEGIN
                      IF DoCompress = USE_COMPRESS THEN
                         GoExec (Config.ComprPrg_U[Compress,Compr],Config.SpoolBaseDir+UUCPName+'\'+Name,
                                 'Compressing for '+UUCPName)
                      ELSE
                          GoExec (Config.ComprPrg_U[GZip,Compr],Config.SpoolBaseDir+UUCPName+'\'+Name,
                                  'Zipping for '+UUCPName);

                      { rename de gemaakte .DAZ weer naar .DAT }
                      Assign (RenFile,Config.SpoolBaseDir+UUCPName+'\'+Copy (Name,1,Length (Name)-1)+'Z');
                      {$I-} Rename (RenFile,Config.SpoolBaseDir+UUCPName+'\'+Name); {$I+} IORes:=IOResult;
                      IF (IORes <> 0) THEN
                         LogDiskIOError (IORes,'Compressed .DAZ file not found for renaming');

                      { cunbatch toevoeging binnen de compress if }
                      { gehaald, zodat ie alleen bij compressen   }
                      { toegevoegd wordt.                         }

                      { cunbatch toevoegen aan het begin van de file }
                      IF CunBatch THEN
                      BEGIN
                           ChDir (Config.SpoolBaseDir+UserData.UUCPName);

                           IF (DoCompress = USE_COMPRESS) THEN
                              AddCun (Name,'c')       { c = cunbatch }
                           ELSE
                               AddCun (Name,GZipBatchLetter);

                         { GoExec (Config.CunBatchPrg[Compr],Name); }
                           ChDir (OldDir);
                      END;
                  END; { compress }
             END;

             { nieuwe file opzetten }
             OutName:=CalcOutBitmask (GetUsenetUniqueName (Grade,Config.ForceNoBitmask));

             { RWI 960402: logging toegevoegd }
             IF Config.LogUUCPOutbound THEN
                LogMessage ('Created UUCP job '+OutName+' for '+UUCPname);

             OutName:=Config.SpoolBaseDir+UUCPName+'\'+OutName+'.DAT';


             Assign (OutFile,OutName);
             Opened:=FALSE;
             IF Mail THEN MaxLen:=0 { mailtje moet in 1 .DAT file }
                     ELSE MaxLen:=Config.MaxDatLength;
             DoCompress:=UserData.Compress{=USE_COMPRESS)}; { ivm uncompressed mail export }
             CunBatch:=UserData.CunBatch; { idem }

             FileFull:=FALSE;

             IF (NOT OpenOutputFile (FoundInfoListRecordPtr)) THEN
             BEGIN
                  LogExtraMessage ('[WriteToDat] '+BailingOut);
                  Exit;
             END;

             { maak .XQT file }
             MakeXqtFile (OutName,UserData.GigoT);
        END; { with }

     {$I-} BlockWrite (FoundInfoListRecordPtr^.OutFile,PackedMsg,PackedMsgLen); {$I+}
     IORes:=IOResult;
     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'[ExportMsgToDat] Write error');

     UpdateInfoNr (INFO_UucpOut_Bytes,PackedMsgLen);

     WITH FoundInfoListRecordPtr^ DO
          OutSize:=FileSize (OutFile);
END;


{--------------------------------------------------------------------------}
{ CheckExportFilesFull                                                     }
{                                                                          }
{ Deze routine wordt aangeroepen na een export naar een Fido .PKT of een   }
{ Usenet .DAT file. Als de file vol zit, dan wordt de FileFull boolean     }
{ in het infolistrecord gezet. Bij de volgende export wordt dan een nieuwe }
{ file begonnen.                                                           }
{                                                                          }
PROCEDURE CheckExportFilesFull;

VAR CurrList : InfoListRecordPtr;

BEGIN
     CurrList:=FirstInfoListRecordPtr;

     WHILE (CurrList <> NIL) DO
           WITH CurrList^ DO
           BEGIN
                IF (MaxLen <> 0) AND (OutSize > MaxLen) THEN
                   FileFull:=TRUE;

                CurrList:=NextInfoListRecordPtr;
           END; { with }
END;


{--------------------------------------------------------------------------}
{ ExportForceFileFull                                                      }
{                                                                          }
{ Deze routine doet geforceert de .DAT van de opgegeven uucpname dicht,    }
{ zodat er de volgende keer met een nieuwe .DAT file wordt begonnen.       }
{                                                                          }
PROCEDURE ExportForceFileFull (UUCPName : UUCPNameString);

VAR FoundInfoListRecordPtr : InfoListRecordPtr;

BEGIN
     IF FindUUCPInfoListRecord (UUCPName,FoundInfoListRecordPtr) OR
        FindSmtpInfoListRecord (UUCPName,FoundInfoListRecordPtr) THEN
     BEGIN
          FoundInfoListRecordPtr^.FileFull:=TRUE;
          CloseOutputFile (FoundInfoListRecordPtr);  { RWI 960304 }
          { remove .LCK file for SMTP? }
     END;
END;


{--------------------------------------------------------------------------}
{ unit initialization                                                      }
{                                                                          }

VAR Lp : HandleIndexType;

BEGIN
     FirstInfoListRecordPtr:=NIL;                  { nog geen Info Records }

     FOR Lp:=1 TO MostHandles DO
         Handles[Lp]:=NIL;                              { nog geen handles }

     XqtLineC:='dumbo!';
     GZipBatchLetter:='g';
     GigoMinusFLine:='';
END.
