{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT JAM;

{ Routines om WtrGate ook naar de JAM base te laten schrijven.           }
{ Gebasseerd op informatie uit het 'JAM message base proposal'           }
{                                                                        }
{       JAM(mbp) - The Joaquim-Andrew-Mats Message Base Proposal         }
{                                                                        }
{ Copyright 1993 Joaquim Homrighausen, Andrew Milner, Mats Birch, and    }
{                     Mats Wallin. ALL RIGHTS RESERVED.                  }
{                                                                        }
{ MD 10-09-93 In luxemburg de API opgepikt, en begonnen met een          }
{             stuk try-out code, object georienteerd omdat ik van plan   }
{             ben veel meer binnen objecten in te kapselen.              }
{ MD 12-09-93 Jippie ! RA slikt alles wat ik 'm voer, reidexen loopt nu  }
{             ook als een zonnetje.                                      }
{    15-09-93 Alles schijnt nu te werken. Alleen de link routine         }
{             ontbreekt nog.                                             }
{    16-09-93 Link routine is er nu ook... beetje buggy dacht ik zo      }
{             -Fixed.. Linken loopt ook lekker                           }
{    24-10-93 Bug fix in de JAM header & footer routines, af en toe      }
{             creerden ze niet bestaande headers (met dank aan TMail)    }
{    04-07-93 Small fix in de JAM inlees routine...                      }

{ RWI '94   Een aantal veranderingen ivm de onderdrukking van $8D en     }
{           het supporten van interne paragrafen.                        }
{    950120 Bugfix in export routine: er stonden linefeeds in de msgbase }
{           die overgeslagen werden, maar waarvan de BytesToRead niet    }
{           gecompenseerd werd. Dit leidde tot gekoppelde berichten.     }
{    950121 Bugfixes in de renumber routine. Automatisch hernummeren bij }
{           purgen van JAM-base.                                         }

INTERFACE

USES DList,
     Msgs,
     Fido,
     Database;

CONST JamBaseMaximumLockTrys = 50;

TYPE JAMBufPtr    = ^JAMBUF;
     JAMBuf       = ARRAY[0..$FFFD] OF CHAR;
     FILENAMETYPE = STRING[200];
     ASCIIZ       = ARRAY[1..255] OF CHAR;
     ARRAY4       = ARRAY[1..4] OF CHAR;

TYPE JAMHDRINFO = RECORD
                        Signature   : ARRAY4;  { <J><A><M> followed by <NUL> }
                        DateCreated : LONGINT; { Creation date }
                        ModCounter  : LONGINT; { Last processed counter }
                        ActiveMsgs  : LONGINT; { Number of active (not deleted) messages }
                        PasswordCRC : LONGINT; { CRC-32 of password to access, or -1 if none }
                        BaseMsgNum  : LONGINT; { Lowest message number in index file }
                        Reserved    : ARRAY[1..1000] OF CHAR;
                  END; {JAMHDRINFO}

     JAMHDR = RECORD
                    Signature     : ARRAY4;    { <J><A><M> followed by <NUL> }
                    Revision      : WORD;      { CurrentRevLev }
                    ReservedWord  : WORD;      { Reserved for future use }
                    SubfieldLen   : LONGINT;   { Length of subfields }
                    TimesRead     : LONGINT;   { Number of times message read }
                    MsgIdCRC      : LONGINT;   { CRC-32 of MSGID line }
                    ReplyCRC      : LONGINT;   { CRC-32 of REPLY line }
                    ReplyTo       : LONGINT;   { This msg is a reply to.. }
                    Reply1st      : LONGINT;   { First reply to this msg }
                    ReplyNext     : LONGINT;   { Next msg in reply chain }
                    DateWritten   : LONGINT;   { When msg was written }
                    DateReceived  : LONGINT;   { When msg was received/read }
                    DateProcessed : LONGINT;   { When msg was processed by packer }
                    MsgNum        : LONGINT;   { Message number (1-based) }
                    Attribute     : LONGINT;   { Msg attribute, see "Status bits" }
                    Attribute2    : LONGINT;   { Reserved for future use }
                    TxtOffset     : LONGINT;   { Offset of text in text file }
                    TxtLen        : LONGINT;   { Length of message text }
                    PasswordCRC   : LONGINT;   { CRC-32 of password to access msg }
                    Cost          : LONGINT;   { Cost of message }
              END; {JAMHDR}

     JLRRecord = RECORD
                       UserCRC     : LONGINT;
                       UserID      : LONGINT;
                       LastReadMsg : LONGINT;
                       HighReadMsg : LONGINT;
                 END;

     JamBase = OBJECT
                     { Standaard info }
                     AreaName : STRING;
                     AreaPath : STRING;

                     Jam_JHR_header : JAMHDRINFO;
                     Jam_MSG_header : JAMHDR;

                     JamSubFieldList     : List;
                     TotalSubFieldSize   : LONGINT;
                     SplitParts,
                     SplitCurrent        : WORD;
                     JamMsgHeaderOffset,
                     JamMsgSize          : LONGINT;

                     ImportMsgs          : BOOLEAN;  { Lees niet alleen bericht headers }
                                                     { maar ook naar het MSG formaat.   }
                     HdrFile,
                     IdxFile,
                     TxtFile             : FILE;

                     CurrentMessage,
                     CurrentHeader       : LONGINT;

                    {IsLocked            : Boolean;}
                     IsOpen              : BOOLEAN;
                     TouchCounter        : BYTE;

                     CONSTRUCTOR InitBase;
                     DESTRUCTOR  DeInitBase;

                     FUNCTION  CreateBase : BOOLEAN;
                     PROCEDURE FillMsgHeader;
                     PROCEDURE FillSubFields;

                     FUNCTION  GetAttributes : LONGINT;
                     FUNCTION  SetAttributes : WORD;

                     FUNCTION  GetHighMsgNum : LONGINT;
                     FUNCTION  GetFirstMessage : BOOLEAN;
                     FUNCTION  GetNextMessage : BOOLEAN;
                     FUNCTION  FindByIndex (Msg : LONGINT) : BOOLEAN;

                     FUNCTION  GetLineCRC (Source : WhereToType; ZoekString : STRING) : LONGINT;
                     FUNCTION  OpenBase (DenyAll : BOOLEAN; Area_Name, Area_Path : STRING) : BOOLEAN;
                     PROCEDURE CloseBase;
                     FUNCTION  SaveFile (FileName : STRING; VAR Buffer; Length : LONGINT) : WORD;
                     FUNCTION  TransLateDate (Source : FidoDateType) : LONGINT;

                     PROCEDURE ScanArea (AreaData : AreaBaseRecord; IsPrimaryNetmailArea : BOOLEAN);

                     FUNCTION  ReadJamHeader : WORD;
                     FUNCTION  ReadHeaderEntry : BOOLEAN;
                     FUNCTION  ReadJAMSubFields (Import : BOOLEAN) : BOOLEAN;
                     FUNCTION  ReadJAMSubField0003 : STRING;

                     PROCEDURE WriteMessage (Area_Name,Area_Path : STRING);
                     FUNCTION  WriteJAMHeader : WORD;
                     FUNCTION  WriteIndexEntry (Source : STRING; Offset : LONGINT) : Boolean;
                     FUNCTION  WriteHeaderEntry : BOOLEAN;

                     PROCEDURE ReIndexArea (AreaData : AreaBaseRecord);
                     PROCEDURE PackArea (AreaData : AreaBaseRecord);
                     FUNCTION  Synchronize (VAR Invoer : FILE; VAR ZoekString; Length : BYTE) : BOOLEAN;

                     FUNCTION  LockBase : BOOLEAN;
                     FUNCTION  UnlockBase : BOOLEAN;

                     PROCEDURE GuessSplitParts;

                     FUNCTION  LinkArea (AreaData : AreaBaseRecord) : BOOLEAN;
                     FUNCTION  DiskLinkArea (AreaData : AreaBaseRecord) : BOOLEAN;
                     FUNCTION  MemLinkArea (AreaData : AreaBaseRecord) : BOOLEAN;

                     PROCEDURE AddToSubField (Id : WORD; Buffer : STRING);

                     PROCEDURE RenumberArea (VAR AreaRec : AreaBaseRecord);
               END;

VAR JamMsgBase : JamBase;


IMPLEMENTATION

USES Cfg,
     Crt,
     Ramon,
     Dos,
     UnixTime,
     SwapMem,
     FBuffer,
     Slice,
     Stats,
     MsgUtil,
     Globals,
     Logs,
     ListSrv,
     UserBase,
     Start,
     Decode;

CONST EXT_HDRFILE = '.JHR';
      EXT_TXTFILE = '.JDT';
      EXT_IDXFILE = '.JDX';
      EXT_LRDFILE = '.JLR';

      HEADERSIG : ARRAY4 = ('J','A','M',#0);

      CurrentRevLev = 001;

{-Header file information block, stored first in all .JHR files}

{-Message status bits}

CONST JMSG_LOCAL       = $00000001; {Msg created locally}
      JMSG_INTRANSIT   = $00000002; {Msg is in-transit}
      JMSG_PRIVATE     = $00000004; {Private}
      JMSG_READ        = $00000008; {Read by addressee}
      JMSG_SENT        = $00000010; {Sent to remote}
      JMSG_KILLSENT    = $00000020; {Kill when sent}
      JMSG_ARCHIVESENT = $00000040; {Archive when sent}
      JMSG_HOLD        = $00000080; {Hold for pick-up}
      JMSG_CRASH       = $00000100; {Crash}
      JMSG_IMMEDIATE   = $00000200; {Send Msg now, ignore restrictions}
      JMSG_DIRECT      = $00000400; {Send directly to destination}
      JMSG_GATE        = $00000800; {Send via gateway}
      JMSG_FILEREQUEST = $00001000; {File request}
      JMSG_FILEATTACH  = $00002000; {File(s) attached to Msg}
      JMSG_TRUNCFILE   = $00004000; {Truncate file(s) when sent}
      JMSG_KILLFILE    = $00008000; {Delete file(s) when sent}
      JMSG_RECEIPTREQ  = $00010000; {Return receipt requested}
      JMSG_CONFIRMREQ  = $00020000; {Confirmation receipt requested}
      JMSG_ORPHAN      = $00040000; {Unknown destination}
      JMSG_ENCRYPT     = $00080000; {Msg text is encrypted}
      JMSG_COMPRESS    = $00100000; {Msg text is compressed}
      JMSG_ESCAPED     = $00200000; {Msg text is seven bit ASCII}
      JMSG_FPU         = $00400000; {Force pickup}
      JMSG_TYPELOCAL   = $00800000; {Msg is for local use only (not for export)}
      JMSG_TYPEECHO    = $01000000; {Msg is for conference distribution}
      JMSG_TYPENET     = $02000000; {Msg is direct network mail}
      JMSG_NODISP      = $20000000; {Msg may not be displayed to user}
      JMSG_LOCKED      = $40000000; {Msg is locked, no editing possible}
      JMSG_DELETED     = $80000000; {Msg is deleted}

{-Message header}
{-Message header subfield types}

CONST JAMSFLD_OADDRESS    = 0;
      JAMSFLD_DADDRESS    = 1;
      JAMSFLD_SENDERNAME  = 2;
      JAMSFLD_RECVRNAME   = 3;
      JAMSFLD_MSGID       = 4;
      JAMSFLD_REPLYID     = 5;
      JAMSFLD_SUBJECT     = 6;
      JAMSFLD_PID         = 7;
      JAMSFLD_TRACE       = 8;
      JAMSFLD_ENCLFILE    = 9;
      JAMSFLD_ENCLFWALIAS = 10;
      JAMSFLD_ENCLFREQ    = 11;
      JAMSFLD_ENCLFILEWC  = 12;
      JAMSFLD_ENCLINDFILE = 13;
      JAMSFLD_EMBINDAT    = 1000;
      JAMSFLD_FTSKLUDGE   = 2000;
      JAMSFLD_SEENBY2D    = 2001;
      JAMSFLD_PATH2D      = 2002;
      JAMSFLD_FLAGS       = 2003;
      JAMSFLD_TZUTCINFO   = 2004;
      JAMSFLD_UNKNOWN     = $FFFF;

{-Message header subfield}

TYPE JAMSUBFIELDPTR = ^JAMSUBFIELD;
     JAMSUBFIELD    = RECORD
                            LoID   : WORD;   {Field ID, 0 - $ffff}
                            Buffer : STRING; {Data buffer}
                      END; {JAMSUBFIELD}

     JAMBINSUBFIELDPTR = ^JAMSUBFIELD;
     JAMBINSUBFIELD    = RECORD
                               LoID   : WORD;    {Field ID, 0 - $ffff}
                               HiID   : WORD;    {Reserved for future use}
                               DatLen : LONGINT; {Length of buffer that follows}
                         END; {JAMSUBFIELD}

{-Message index record}

     JAMIDXREC = RECORD
                       UserCRC   : LONGINT; {CRC-32 of destination username (lowercase)}
                       HdrOffset : LONGINT; {Offset of header in .JHR file}
                 END; {JAMIDXREC}

{-Lastread structure, one per user}

     JAMLREAD = RECORD
                      UserCRC     : LONGINT; {CRC-32 of username (lowercase)}
                      UserID      : LONGINT; {Unique UserID}
                      LastReadMsg : LONGINT; {Last read message number}
                      HighReadMsg : LONGINT; {Highest read message number}
                END; {JAMLREAD}

{ Strategie :                                                        }
{                                                                    }
{   Creer een JamBase :   1. Schrijf in HeaderInfo naar *.JHR        }
{                         2. Creer nul files voor *.JDT              }
{                                                 *.JDX              }
{                                                 *.JLR              }
{                                                                    }
{   Schrijf Bericht   :   1. Lock de Base                            }
{                         2. Append headerinfo                       }
{                         3. Append Text                             }
{                         4. Append Index                            }
{                         5. Geef base weer vrij                     }
{                                                                    }
{   Lees bericht      :   1. Lees Headers                            }
{                         2. Lees bericht                            }


{--------------------------------------------------------------------------}
{ InitJamBase                                                              }
{                                                                          }
{ Doet een reset van de interne variabelen van de Jam Base.                }
{                                                                          }
CONSTRUCTOR JamBase.InitBase;
BEGIN
     AreaName:='';
     AreaPath:='';
     IsOpen:=FALSE;
     ImportMsgs:=TRUE;
     TouchCounter:=0;

     JamSubFieldList.Init (SizeOf (JAMSUBFIELD),NIL);
     TotalSubFieldSize:=0;
END;


{--------------------------------------------------------------------------}
{ DeInitBase                                                               }
{                                                                          }
{ Zorgt ervoor dat de file handles aan het einde ook nog worden vrij       }
{ gegeven.                                                                 }
{                                                                          }
DESTRUCTOR JamBase.DeInitBase;
BEGIN
     CloseBase;
END;


{--------------------------------------------------------------------------}
{ GetFirstMessage                                                          }
{                                                                          }
{ Zet de index pointer op het begin van de indexfile, en laat              }
{ GetNextMessage de echte entry inlezen.                                   }
{                                                                          }
FUNCTION JamBase.GetFirstMessage : BOOLEAN;

VAR IORes : BYTE;

BEGIN
     {$I-} Seek (IdxFile,0); {$I+} IORes:=IOResult;

     IF (IORes <> 0) OR (FileSize (IdxFile) = 0) THEN
        GetFirstMessage:=FALSE
     ELSE
         GetFirstMessage:=GetNextMessage;
END;


{--------------------------------------------------------------------------}
{ GetNextMessage                                                           }
{                                                                          }
{ Leest het volgende bericht in, controleert of het niet een lege          }
{ entry is en zet de HdrFile pointer op de juiste plaatst.                 }
{                                                                          }
FUNCTION JamBase.GetNextMessage : BOOLEAN;

VAR IdxRec : JAMIDXREC;
    IORes  : BYTE;

BEGIN
     GetNextMessage:=FALSE;

     WHILE (NOT Eof (IdxFile)) DO
     BEGIN
          {$I-} BlockRead (IdxFile,IdxRec,SizeOf (IdxRec)); {$I+} IORes:=IOResult;
          IF (IORes <> 0) THEN
             Exit;

          { Lege index posities hebben een positie met de waarde $FFFFFFFF }
          { deze skippen we.                                               }
          IF (IdxRec.HdrOffSet <> $FFFFFFFF) THEN
          BEGIN
               GetNextMessage:=TRUE;
               {$I-} Seek (HdrFile,IdxRec.hdrOffset); {$I+}
               IORes:=IOResult; { negeer het resultaat }
               Break; { uit de while }
          END;
     END; { while }

     CurrentMessage:=(FilePos (IdxFile) DIV SizeOf (IdxRec))+Jam_JHR_Header.basemsgnum;
     CurrentHeader:=IdxRec.HdrOffset;
END;


{--------------------------------------------------------------------------}
{ FindByIndex                                                              }
{                                                                          }
{ Zoekt een bericht nummer op in de index tabel en plaatst daar de         }
{ filepointer van de headerfile op.                                        }
{                                                                          }
FUNCTION JAMBASE.FindByIndex (Msg : LONGINT) : BOOLEAN;

VAR RealMsg : LONGINT;
    IdxRec  : JAMIDXREC;
    IORes   : BYTE;

BEGIN
     FindByIndex:=FALSE;
     RealMsg:=Msg-Jam_JHr_header.baseMsgNum;

     IF (RealMsg < 0) THEN
        Exit;

     {$I-} Seek (IdxFile,SizeOf (JAMIDXREC)*RealMsg); {$I+} IORes:=IOResult;

     IF (IORes = 0) THEN
     BEGIN
          {$I-} BlockRead (IdxFile,IdxRec,SizeOf (IdxRec)); {$I+} IORes:=IOResult;
     END;

     IF (IORes = 0) THEN
     BEGIN
          {$I-} Seek (HdrFile,IdxRec.HdrOffset); {$I+} IORes:=IOResult;
     END;

     CurrentHeader:=IdxRec.HdrOffset;

     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[JAM] Error reading index record');
          Exit;
     END;

     FindByIndex:=TRUE;
END;


{--------------------------------------------------------------------------}
{ ReadJamHeader                                                            }
{                                                                          }
{ Leest de statische header van de Jam base *.JHR file.                    }
{                                                                          }
FUNCTION JamBase.ReadJamHeader : WORD;
BEGIN
    {$I-}
    IF (FilePos (HdrFile) <> 0) THEN
       Seek (HdrFile,0);

    BlockRead (HdrFile,Jam_JHR_header,SizeOf (Jam_JHR_header));
    {$I+}

    ReadJamHeader:=IOResult;
END;


{--------------------------------------------------------------------------}
{ CreateBase                                                               }
{                                                                          }
{ Creert een nieuwe JamBase, door een header file te creeren, en enkele    }
{ lege bestanden.                                                          }
{                                                                          }
FUNCTION JamBase.CreateBase : BOOLEAN;

VAR IORes : BYTE;

BEGIN
     Inc (TouchCounter);

     { Vul de file header met informatie en    }
     { schrijf deze naar disk door het creeren }
     { van nieuwe JamBase files.               }
     WITH Jam_JHR_header DO
     BEGIN
          Signature:=HeaderSig;   { JAM#0 }
          DateCreated:=GetCurrentUnixTime;
          ModCounter:=0;
          ActiveMsgs:=0;
          PasswordCRC:=$FFFFFFFF;
          BaseMsgNum:=1;
          FillChar (Reserved,1000,0);
     END; { with }

     { Schrijf Header info file naar disk }
     IORes:=SaveFile (AreaPath+EXT_HDRFILE,Jam_JHR_header,SizeOf (Jam_JHR_header));

     { Schrijf Index,TextBody en LastRead files naar disk }
     IF (IORes = 0) THEN IORes:=SaveFile (AreaPath+EXT_TXTFILE,IORes,0);
     IF (IORes = 0) THEN IORes:=SaveFile (AreaPath+EXT_IDXFILE,IORes,0);
     IF (IORes = 0) THEN IORes:=SaveFile (AreaPath+EXT_LRDFILE,IORes,0);

     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[JAM] Error creating messagebase '+AreaPath);
          CreateBase:=FALSE;
     END ELSE
     BEGIN
          CreateBase:=TRUE;
          LogMessage ('Created JAM messagebase for '+AreaName);
     END;
END;


{-------------------------------------------------------------------------}
{ GetAttributes                                                           }
{                                                                         }
{ Vertaald Fido attributen naar JAM base flaggen.                         }

FUNCTION JamBase.GetAttributes : LONGINT;

VAR TempFlag : LONGINT;

BEGIN
     TempFlag:=0;

     { Vertaal standaard FTN flag velden }


     { Private }
     IF ((Msg.Attr_F AND MSGPRIVATE) <> 0) THEN
        TempFlag:=TempFlag OR JMSG_PRIVATE;

     { Read }
     IF ((Msg.Attr_F AND MSGREAD) <> 0) THEN
        TempFlag:=TempFlag OR JMSG_READ;

     { Sent }
     IF ((Msg.Attr_F AND MSGSENT) <> 0) THEN
        TempFlag:=TempFlag OR JMSG_SENT;

     { File Attach }
     IF ((Msg.Attr_F AND MSGFILE) > 0) THEN
        TempFlag:=TempFlag OR JMSG_FILEATTACH;

     { Kill / Sent }
     IF ((Msg.Attr_F AND MSGKILL) <> 0) THEN
        TempFlag:=TempFlag OR JMSG_KILLSENT;

     { Local }
     IF ((Msg.Attr_F AND MSGLOCAL) <> 0) THEN
        TempFlag:=TempFlag OR JMSG_LOCAL;

     { File request }
     IF ((Msg.Attr_F AND MSGFRQ) <> 0) THEN
        TempFlag:=TempFlag OR JMSG_FILEREQUEST;

     { Return Request }
     IF ((Msg.Attr_F AND MSGRRQ) <> 0) THEN
        TempFlag:=TempFlag OR JMSG_RECEIPTREQ;

     IF ((Msg.Attr_F AND MSGORPHAN) <> 0) THEN
        TempFlag:=TempFlag OR JMSG_ORPHAN;
(*
  { Vertaal FSC-0053 velden }
  IF (Msg.ExtAttr_F AND EXTMSGHLD)>0 THEN   { Hold           }
   TempFlag := TempFlag OR JMSG_HOLD;
  IF (Msg.ExtAttr_F AND EXTMSGCRA)>0 THEN   { Crash          }
   TempFlag := TempFlag OR JMSG_CRASH;
  IF (Msg.ExtAttr_F AND EXTMSGK_S)>0 THEN   { Kill/Sent      }
   TempFlag := TempFlag OR JMSG_KILLSENT;
  IF (Msg.ExtAttr_F AND EXTMSGSNT)>0 THEN   { Sent           }
   TempFlag := TempFlag OR JMSG_SENT;
  IF (Msg.ExtAttr_F AND EXTMSGRCV)>0 THEN   { Received       }
   TempFlag := TempFlag OR JMSG_READ;
  IF (Msg.ExtAttr_F AND EXTMSGA_S)>0 THEN   { Archive Sent   }
   TempFlag := TempFlag OR JMSG_ARCHIVESENT;
  IF (Msg.ExtAttr_F AND EXTMSGDIR)>0 THEN   { Direct         }
   TempFlag := TempFlag OR JMSG_DIRECT;
  IF (Msg.ExtAttr_F AND EXTMSGFIL)>0 THEN   { File Attach    }
   TempFlag := TempFlag OR JMSG_FILEATTACH;
  IF (Msg.ExtAttr_F AND EXTMSGFRQ)>0 THEN   { File Request   }
   TempFlag := TempFlag OR JMSG_FILEREQUEST;
  IF (Msg.ExtAttr_F AND EXTMSGIMM)>0 THEN   { Immediate      }
   TempFlag := TempFlag OR JMSG_IMMEDIATE;
  IF (Msg.ExtAttr_F AND EXTMSGKFS)>0 THEN   { Kill/File/Sent }
   TempFlag := TempFlag OR JMSG_KILLFILE;
  IF (Msg.ExtAttr_F AND EXTMSGKFS)>0 THEN   { Lock           }
   TempFlag := TempFlag OR JMSG_LOCKED;
  IF (Msg.ExtAttr_F AND EXTMSGRRQ)>0 THEN   { ReceiptReq     }
   TempFlag := TempFlag OR JMSG_RECEIPTREQ;
  IF (Msg.ExtAttr_F AND EXTMSGCFM)>0 THEN   { Confirmation   }
   TempFlag := TempFlag OR JMSG_CONFIRMREQ;
*)

     { Echomail / Lokaal? / Netmail }
     IF (Msg.Ready_F IN [Echomail,Local_Echomail]) THEN
        TempFlag:=TempFlag OR JMSG_TYPEECHO
     ELSE
         TempFlag:=TempFlag OR JMSG_TYPENET;

     GetAttributes:=TempFlag;
END;


{------------------------------------------------------------------------}
{ SetAttributes                                                          }
{                                                                        }
{ Vertaald de attributen in een Jam Flags veld naar een standaard        }
{ fido vlag veld. Voorlopig worden hier een hoop vlaggen                 }
{ genegeerd.                                                             }
{                                                                        }
FUNCTION JamBase.SetAttributes : WORD;

VAR TempFlag : WORD;

BEGIN
     TempFlag:=0;

     { Strip local }
     IF ((Jam_Msg_Header.Attribute AND JMSG_LOCAL) <> 0) THEN
        TempFlag:=TempFlag OR MSGLOCAL;

     IF ((Jam_Msg_Header.Attribute AND JMSG_PRIVATE) <> 0) THEN
        TempFlag:=TempFlag OR MSGPRIVATE;

     IF ((Jam_Msg_Header.Attribute AND JMSG_CRASH) <> 0) THEN
        TempFlag:=TempFlag OR MSGCRASH;

     IF ((Jam_Msg_Header.Attribute AND JMSG_READ) <> 0) THEN
        TempFlag:=TempFlag OR MSGREAD;

     IF ((Jam_Msg_Header.Attribute AND JMSG_FILEATTACH) <> 0) THEN
        TempFlag:=TempFlag OR MSGFILE;

     IF ((Jam_Msg_Header.Attribute AND JMSG_ORPHAN) <> 0) THEN
        TempFlag:=TempFlag OR MSGORPHAN;

     IF ((Jam_Msg_Header.Attribute AND JMSG_KILLSENT) <> 0) THEN
        TempFlag:=TempFlag OR MSGKILL;

     IF ((Jam_Msg_Header.Attribute AND JMSG_FILEREQUEST) <> 0) THEN
        TempFlag:=TempFlag OR MSGFRQ;

     IF ((Jam_Msg_Header.Attribute AND JMSG_RECEIPTREQ) <> 0) THEN
        TempFlag:=TempFlag OR MSGRRQ;

     SetAttributes:=TempFlag;
END;


{--------------------------------------------------------------------------}
{ GetHighMsgNum                                                            }
{                                                                          }
{ Geeft het hoogste berichtnummer terug.                                   }
{                                                                          }
FUNCTION JamBase.GetHighMsgNum : LongInt;
BEGIN
     IF IsOpen THEN
        GetHighMsgNum:=Jam_JHR_header.BaseMsgNum+(FileSize (IdxFile) DIV SizeOf (JAMIDXREC))-1;
END;


{--------------------------------------------------------------------------}
{ GetLineCRC                                                               }
{                                                                          }
{ Geeft de CRC terug van een gezochte regel in het bericht.                }
{ BugFix: Geeft nu -1 (of $FFFFFFFF) terug als er niets gevonden werd.     }
{                                                                          }
FUNCTION JamBase.GetLineCRC (Source : WhereToType; ZoekString : STRING) : LONGINT;

VAR Regel : STRING;

BEGIN
     Regel:=DeleteBackSpaces (LoCaseString (MsgsSearchLine (Source,ZoekString,FALSE)));

     IF (Regel <> '') THEN
        GetLineCRC:=UpdateCRC32 ($FFFFFFFF,Regel[1],Length (Regel))
     ELSE
         GetLineCRC:=-1;
END;


{--------------------------------------------------------------------------}
{ FillHeader                                                               }
{                                                                          }
{ Converteert de gegevens uit het interne bericht formaat naar eem JAM     }
{ header.                                                                  }
{                                                                          }
PROCEDURE JamBase.FillMsgHeader;
BEGIN
     WITH Jam_MSG_header DO
     BEGIN
          Signature:=HeaderSig;
          Revision:=CurrentRevLev;
          ReservedWord:=0;
          SubfieldLen:=TotalSubFieldSize;
          TimesRead:=0;
          MsgIdCRC:=GetLineCRC (Header_F,#1'MSGID: ');
          ReplyCRC:=GetLineCRC (Header_F,#1'REPLY: ');
          ReplyTo:=0;
          Reply1st:=0;
          ReplyNext:=0;
          DateWritten:=TranslateDate (Msg.Date_F);
          DateReceived:=0;
          DateProcessed:=GetCurrentUnixTime;
          MsgNum:=GetHighMsgNum;
          Attribute:=GetAttributes;
          Attribute2:=0;

          IF (JamMsgSize > 0) THEN
          BEGIN
               TxtOffset:=FileSize (txtFile)-JamMsgSize;
               TxtLen:=JamMsgSize;
          END ELSE
          BEGIN
               TxtOffset:=0;
               TxtLen:=0;
          END;

          PasswordCRC:=$FFFFFFFF;
          Cost:=Msg.Cost_F;
     END; { with }
END;


{--------------------------------------------------------------------------}
{ AddToSubField                                                            }
{                                                                          }
{ Voegt een subfield toe aan de lijst in het geheugen.                     }
{                                                                          }
PROCEDURE JamBase.AddToSubField (Id : WORD; Buffer : STRING);

VAR Tmp : JAMSUBFIELDPTR;

BEGIN
     IF (Buffer[Length (Buffer)] = #13) THEN
        Delete (Buffer,Length (Buffer),1);

     GetMem (Tmp,SizeOf (JAMSUBFIELD));
     Tmp^.LoId:=Id;
     Tmp^.Buffer:=Buffer;
     JamSubFieldList.Add (Tmp);
     TotalSubFieldSize:=TotalSubFieldSize+Length (Buffer)+SizeOf (JAMBINSUBFIELD);
END;


{--------------------------------------------------------------------------}
{ FillSubArray                                                             }
{                                                                          }
{ Vult de subarray met regels uit het bericht.                             }
{                                                                          }
PROCEDURE JamBase.FillSubFields;

    {----------------------------------------------------------------------}
    { ProcessHeaderLine                                                    }
    {                                                                      }
    { Routine om een regel te verwerken, zowel direct uit het geheugen als }
    { vanaf de swapfile. De hoofdlus heeft em ingelezen, of geeft een      }
    { pointer naar de regel. Hier wordt ie verwerkt. Spaart dubbele code.  }
    {                                                                      }
    PROCEDURE ProcessHeaderLine (VAR Regel : STRING); FAR;
    BEGIN
         CASE FidoGetKludgeID (Regel) OF
              klArea  : {de Area kludge wordt gestript};

              { RWI 950605: berichten in de JAM base krijgen nu ook een }
              {             uniek MSGID per gespleten part.             }
              klMsgID :
                  IF (SplitParts = 1) THEN
                     AddToSubField (0004,Copy (Regel,9,255))
                  ELSE
                      AddToSubField (0004,GetFidoPktName);

              klReply :
                  AddToSubField (0005,Copy (Regel,9,255));

              klPid :
                  AddToSubField (0007,Copy (Regel,7,255));

              klFlags :
                  AddToSubField (2003,Copy (Regel,7,255));

              { INTL,TOPT & FMPT velden mogen niet bewaard worden! }
              ELSE
                  { Bugfix : haal de ^A voor het veld weg! }
                  AddToSubField (2000,Copy (Regel,2,255)); { Alle andere kludges }
         END; { case }
    END;

    {----------------------------------------------------------------------}
    { ProcessFooterLine                                                    }
    {                                                                      }
    { Zelfde als hierboven, maar dan voor een footer regel.                }
    {                                                                      }
    PROCEDURE ProcessFooterLine (VAR Regel : STRING); FAR;
    BEGIN
         CASE FidoGetKludgeID (Regel) OF
              klSeenBy :
                  IF (NOT Config.StripSeenBy) THEN
                     AddToSubField (2001,Copy (Regel,10,255));

              klPath :
                  AddToSubField (2002,Copy (Regel,8,255));
         END; { case }
    END;

{ FillSubFields }

VAR EenRegelPtr : EenRegelRecordPtr;
    RegelLength : BYTE;
    Regel,
    SubjectLine : STRING;

BEGIN
     { Zorg voor een schone sub field lijst }
     JamSubFieldList.Clear;
     TotalSubFieldSize:=0;

     AddToSubField (0000,Fido2Str (Msg.FromAddr_F));
     AddToSubField (0001,Fido2Str (Msg.ToAddr_F));
     AddToSubField (0002,Msg.FromUser_F);
     AddToSubField (0003,Msg.ToUser_F);

     IF ((Msg.Attr_F AND MSGFILE) = 0) THEN     { De subject line mag niet }
     BEGIN
          IF (SplitParts > 1) THEN
          BEGIN
               Inc (SplitCurrent);
               SubjectLine:='('+Byte2String (SplitCurrent)+
                            '/'+Byte2String (SplitParts)+
                            ') '+Msg.Subj_F;
               AddToSubField (2000,Copy (FidoCreateSplitLine (SplitCurrent,SplitParts),2,255));
          END ELSE
              SubjectLine:=Msg.Subj_F;

          AddToSubField (0006,SubjectLine);     { gebruikt worden voor     }
     END ELSE                                   { file attaches !          }
     BEGIN
          AddToSubField (0009,Msg.Subj_F);

          { RWI961213: Sommige programma's laten de filename niet in de }
          {            subject regel zien voor attached files...        }
          AddToSubField (0003,Msg.Subj_F);
     END;

     { Doorloop de fido header voor kludges en plaats ze in het goede  }
     { type SUBFIELD. Als we een header hebben, tenminste.             }
     IF (Msg.HeaderTop_F <> NIL) THEN
     BEGIN
          EenRegelPtr:=Msg.HeaderTop_F^.FirstRegelRecordPtr;
          MsgsNewSeek (EenRegelPtr);

          WHILE (EenRegelPtr <> NIL) DO
          BEGIN
               CASE EenRegelPtr^.Waar OF
                    wMem :
                        BEGIN
                             ProcessHeaderLine (EenRegelPtr^.RegelPtr^);
                             EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                             MsgsNewSeek (EenRegelPtr);
                        END;

                    wSwapped :
                        BEGIN
                             { lees de lengte van de regel in }
                             BlockRead (SwapFile,RegelLength,1);

                             { einde van het swapped blok? }
                             IF (RegelLength = 0) THEN
                             BEGIN
                                  { ja, ga naar de volgende regel }
                                  EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                                  MsgsNewSeek (EenRegelPtr);
                                  Continue;
                             END;

                             { lees de regel zelf in }
                             BlockRead (SwapFile,Regel[1],RegelLength);
                             Regel[0]:=Char (RegelLength);

                             { verwerk de regel }
                             ProcessHeaderLine (Regel);
                        END;
               END; { case }
          END; { while }
     END; { has header }

     { Doorloop de fido footer, voor kludges en plaats ze in het goede }
     { type SUBFIELD. Als er een footer is tenminste }
     IF (Msg.FooterTop_F <> NIL) THEN
     BEGIN
          EenRegelPtr:=Msg.FooterTop_F^.FirstRegelRecordPtr;
          MsgsNewSeek (EenRegelPtr);

          WHILE (EenRegelPtr <> NIL) DO
          BEGIN
               CASE EenRegelPtr^.Waar OF
                    wMem :
                        BEGIN
                             ProcessFooterLine (EenRegelPtr^.RegelPtr^);
                             EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                             MsgsNewSeek (EenRegelPtr);
                        END;

                    wSwapped :
                        BEGIN
                             { lees de lengte van de regel in }
                             BlockRead (SwapFile,RegelLength,1);

                             { einde van het swapped blok? }
                             IF (RegelLength = 0) THEN
                             BEGIN
                                  { ja, ga naar de volgende regel }
                                  EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                                  MsgsNewSeek (EenRegelPtr);
                                  Continue;
                             END;

                             { lees de regel zelf in }
                             BlockRead (SwapFile,Regel[1],RegelLength);
                             Regel[0]:=Char (RegelLength);

                             { verwerk de regel }
                             ProcessFooterLine (Regel);
                        END;
               END; { case }
          END; { while }
     END; { has footer }
END;


{--------------------------------------------------------------------------}
{ OpenBase                                                                 }
{                                                                          }
{ Opent de base header, body en index ; en initialiseerd het object.       }
{                                                                          }
FUNCTION JamBase.OpenBase (DenyAll : BOOLEAN; Area_Name,Area_Path : STRING) : BOOLEAN;

VAR IORes : BYTE;

BEGIN
     { RWI 951023: moved the DeleteBackSpaces overhere to improve the check }
     Area_Name:=DeleteBackSpaces (Area_Name);
     Area_Path:=DeleteBackSpaces (Area_Path);

     UpdateReadFile (Area_Path,0);

     { Zorg ervoor dat we alleen opnieuw reseten als de areaname anders is }
     IF IsOpen THEN
        { RWI 951023: Check is now performed on the path instead of the name }
        {IF (Area_Name = AreaName) THEN}
        IF (Area_Path = AreaPath) THEN
           Exit
        ELSE
            CloseBase;

     Inc (TouchCounter);

     { RWI 951023: removed DeleteBackSpaces, since it is done above now }
     AreaName:=Area_Name;
     AreaPath:=Area_Path;
     OpenBase:=FALSE;

     (* RWI 960811: niet meer: te veel file access
     { Als de base nog niet bestaat, creer er dan een }
     IF (NOT BaseExists) THEN
        IF (NOT CreateBase) THEN
           Exit;
     *)

     IF DenyAll THEN
        FileMode:=fmReadWrite+fmDenyAll
     ELSE
         FileMode:=fmReadWrite+fmDenyNone;

     { Open de benodigde bestanden in DenyNone Share mode }
     Assign (HdrFile,AreaPath+EXT_HDRFILE);
     {$I-} Reset (HdrFile,1); {$I+} IORes:=IOResult;
     PeekFiles;

     { RWI 960811: geen pre-existing check, dus *nu* aanmaken als ie mist }
     IF (IORes = 2) THEN
     BEGIN
          CreateBase;
          {$I-} Reset (HdrFile,1); {$I+} IORes:=IOResult;
          PeekFiles;
     END;

     IF (IORes <> 0) THEN
     BEGIN
          IF (IORes = 3) THEN
             LogMessage ('[JAM] Path not found for '+AreaPath+EXT_HDRFILE)
          ELSE
              LogDiskIOError (IORes,'[JAM] Could not open/create '+AreaPath+EXT_HDRFILE);
          Exit;
     END;

     { Probeer de Area header in te lezen }
     IORes:=ReadJamHeader;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[JAM] Error reading header');
          Close (HdrFile);
          PeekFiles;
          Exit;
     END;

     { Open de index file }
     Assign (IdxFile,AreaPath+EXT_IDXFILE);
     {$I-} Reset (IdxFile,1); {$I+} IORes:=IOResult;
     PeekFiles;

     IF (IORes <> 0) THEN
     BEGIN
          { .JHR exists, create .JDX if "not found" }
          IF (IORes <> 2) THEN
          BEGIN
               LogDiskIOError (IORes,'[JAM] Error opening '+AreaPath+EXT_IDXFILE);
               Close (HdrFile);
               PeekFiles;
               Exit;
          END;

          { IORes=2 }
          {$I-} ReWrite (IdxFile,1); {$I+} IORes:=IOResult;
          IF (IORes <> 0) THEN
          BEGIN
               LogDiskIOError (IORes,'[JAM] Error creating '+AreaPath+EXT_IDXFILE);
               Close (HdrFile);
               PeekFiles;
               Exit;
          END;
     END;

     { Open de text file }
     Assign (TxtFile,AreaPath+EXT_TXTFILE);
     {$I-} Reset (TxtFile,1); {$I+} IORes:=IOResult;
     PeekFiles;

     IF (IORes <> 0) THEN
     BEGIN
          IF (IORes <> 2) THEN
          BEGIN
               LogDiskIOError (IORes,'[JAM] Error opening '+AreaPath+EXT_TXTFILE);
               Close (IdxFile);
               Close (HdrFile);
               PeekFiles;
               Exit;
          END;

          { IORes=2 }
          {$I-} ReWrite (TxtFile,1); {$I+} IORes:=IOResult;
          IF (IORes <> 0) THEN
          BEGIN
               LogDiskIOError (IORes,'[JAM] Error creating '+AreaPath+EXT_TXTFILE);
               Close (IdxFile);
               Close (HdrFile);
               PeekFiles;
               Exit;
          END;
     END;

     { geef het resultaat terug }
     IsOpen:=TRUE;
     OpenBase:=TRUE;
END;


{--------------------------------------------------------------------------}
{ CloseBase                                                                }
{                                                                          }
{ Geeft alle file handles en interne buffers weer vrij.                    }
{                                                                          }
PROCEDURE JamBase.CloseBase;
BEGIN
     Inc (TouchCounter);

     AreaName:='';
     AreaPath:='';

     JamSubFieldList.Clear;

     IF (NOT IsOpen) THEN
        Exit;

     Close (HdrFile);
     Close (TxtFile);
     Close (IdxFile);

     PeekFiles;

     IsOpen:=FALSE;
END;


{--------------------------------------------------------------------------}
{ GuessSplitParts                                                          }
{                                                                          }
{ Probeer het aantal delen te bepalen waarin het bericht gesplitst op      }
{ disk bewaard zal worden.                                                 }
{                                                                          }
PROCEDURE JAMBase.GuessSplitParts;

VAR FidoBodyLen,
    FidoFooterLen  : LONGINT;
    SplitParts_R   : REAL;

BEGIN
     { kijk of we de limiet gaan overschrijven }
     IF (Msg.BodyTop <> NIL) THEN
        FidoBodyLen:=Msg.BodyTop^.TotalRegelLength
     ELSE
         FidoBodyLen:=0;

     IF (Msg.FooterTop_F <> NIL) THEN
        FidoFooterLen:= Msg.FooterTop_F^.TotalRegelLength
     ELSE
         FidoFooterLen:=0;

     { bereken het aantal delen waarin het bericht gesplitst gaat worden }
     SplitCurrent:=0;
     SplitParts:=0;

     IF (Config.MaxJAMMsgLen > 0) THEN
     BEGIN
          SplitParts_R:=FidoBodyLen / (Config.MaxJAMMsgLen-FidoFooterLen);
          SplitParts:=Trunc (SplitParts_R);
          IF (SplitParts < SplitParts_R) THEN
             Inc (SplitParts);
     END;
END;


{--------------------------------------------------------------------------}
{ WriteMessage                                                             }
{                                                                          }
{ Schrijft het bericht zoals zich dat in het interne bericht formaat       }
{ bevindt naar de messagebase.                                             }
{                                                                          }
{ RWI 950506: WriteBodyEntry en StartLine uit de object structuur gehaald  }
{             en het schrijven van het bericht (eventueel gesplitst) hier  }
{             naartoe gehaald, zodat we zekerheden in kunnen bouwen over   }
{             de positie in de swapfile.                                   }
{                                                                          }
PROCEDURE JamBase.WriteMessage (Area_Name,Area_Path : STRING);

VAR TweeRegelPtr,
    EenRegelPtr  : EenRegelRecordPtr;
    Regel        : STRING;
    RegelLength  : BYTE;
    SwapPos      : LONGINT;
    WriteBufPtr  : JamBufPtr;
    WriteBufSize : WORD;
    WriteBufPos  : WORD;
    FooterLine   : STRING; { ivm controle op SEEN-BY of ^APATH }
    SplitLength  : LONGINT;  { RWI 950625 }

LABEL Einde;

BEGIN
     { Zorg ervoor dat de base open is }
     (*
     IF (Area_Name = '') AND (SystemMode = smNORMAL) THEN
     BEGIN
          Area_Name:='STR_NETMAIL';
          Area_Path:=Config.FidoNetmailPath;
     END;
     *)

     IF (NOT OpenBase (FALSE,Area_Name,Area_Path)) THEN
     BEGIN
          LogMessage ('[JAM] Unable to access '+AreaName);
          Exit;
     END;

     IF (NOT LockBase) THEN
     BEGIN
          LogMessage ('[JAM] Timeout on file lock request for '+AreaPath);
          {CloseBase... ??}
          Exit;
     END;

     UpdateWriteFile (Area_Path,0);

     WriteBufPtr:=NIL; { nog geen geheugen voor aangevraagd }

     { vraag geheugen voor een buffer aan waarin we regels voor de JAM }
     { msg file gaan bufferen.                                         }
     (*
     { dit moet mooier kunnen met een repeat ofzo... }
     IF (MaxAvail > SizeOf (JAMBuf)) THEN                    { 64Kb buffer }
        WriteBufSize:=SizeOf (JAMBuf)
     ELSE
         IF (MaxAvail > (SizeOf (JAMBuf) DIV 2)) THEN        { 32Kb buffer }
            WriteBufSize:=SizeOf (JAMBuf) DIV 2
         ELSE
             IF (MaxAvail > (SizeOf (JAMBuf) DIV 4)) THEN    { 16Kb buffer }
                WriteBufSize:=SizeOf (JAMBuf) DIV 4
             ELSE
                 IF (MaxAvail > (SizeOf (JAMBuf) DIV 8)) THEN  { 8Kb buffer }
                    WriteBufSize:=SizeOf (JAMBuf) DIV 8
                 ELSE BEGIN
                      LogMessage ('[JAM] Not enough memory (8Kb) for write buffer!');
                      GOTO Einde;
                 END;
     *)

     IF (NOT CalcMaxAllowedMem (WriteBufSize,8192,65520)) THEN
     BEGIN
          LogMessage ('[JAM] Not enough memory for write buffer!');
          GOTO Einde;
     END;

     { en vraag het geheugen aan }
     GetMem (WriteBufPtr,WriteBufSize);
     PeekMem;

     { zorg dat we verse informatie hebben }
     ReadJamHeader;

     { wijs naar het begin van de body }
     IF (Msg.BodyTop <> NIL) THEN
        EenRegelPtr:=Msg.BodyTop^.FirstRegelRecordPtr
     ELSE
         EenRegelPtr:=NIL;

     { bepaal en bewaar de swapfile positie }
     IF SwapIsOpen THEN
     BEGIN
          MsgsNewSeek (EenRegelPtr);
          SwapPos:=FilePos (SwapFile);
     END;

     { Probeer het aantal delen waarin het bericht gesplitst zal worden }
     { te bepalen.                                                      }
     GuessSplitParts;

     REPEAT
           { schrijf de body naar disk }
           JamMsgSize:=0;

           { zorgt dat we aan het einde van de base toevoegen }
           Seek (TxtFile,FileSize (TxtFile));

           { herstel de positie in de swapfile voor het geval die veranderd }
           { is door het schrijven van een header ofzo.                     }
           IF SwapIsOpen THEN
              Seek (SwapFile,SwapPos);

           { schrijf nu het hele bericht of een deel ervan naar de msgbase }
           SplitLength:=0;
           WriteBufPos:=0;

           { RWI 960118: bugfix. Hier stond A and (B and C), want   }
           { natuurlijk altijd FALSE is als MaxJAMMsgLen=0... oeps! }
           WHILE (EenRegelPtr <> NIL) AND
                 ((Config.MaxJAMMsgLen = 0) OR (SplitLength < Config.MaxJAMMsgLen)) DO
           BEGIN
                ExtractFile (EenRegelPtr,Regel);

                RegelLength:=Length (Regel);
                Move (Regel[1],WriteBufPtr^[WriteBufPos],RegelLength);
                Inc (WriteBufPos,RegelLength);
                Inc (SplitLength,RegelLength);

                { kijk of WriteBuf vol begint te raken }
                IF (WriteBufPos > WriteBufSize-256) THEN
                BEGIN
                     BlockWrite (TxtFile,WriteBufPtr^[0],WriteBufPos);
                     UpdateInfoNr (INFO_JamSave_Bytes,WriteBufPos);
                     JamMsgSize:=JamMsgSize+WriteBufPos;
                     WriteBufPos:=0; { zo, nu is ie weer leeg }
                END;
           END; { while not end of lines or split part full }

           { bewaar de positie in de swapfile weer }
           IF SwapIsOpen THEN
              SwapPos:=FilePos (SwapFile);

           { Uit de fido footer alle regels toevoegen, behalve SEENBY en }
           { PATH regels. Hier gebruiken we een andere EenRegelPtr voor, }
           { omdat die al voor de (nu gedeeltelijk verwerkte?) body is.  }
           IF (Msg.FooterTop_F <> NIL) THEN
           BEGIN
                TweeRegelPtr:=Msg.FooterTop_F^.FirstRegelRecordPtr;
                MsgsNewSeek (TweeRegelPtr);

                { alle regels verwerken. Geen lengte beperking dus! }
                WHILE (TweeRegelPtr <> NIL) DO
                BEGIN
                     CASE TweeRegelPtr^.Waar OF
                          wMem :
                              BEGIN
                                   IF (Copy (TweeRegelPtr^.RegelPtr^,1,7) <> 'SEEN-BY') AND
                                      (Copy (TweeRegelPtr^.RegelPtr^,1,6) <> #1'PATH:') THEN
                                   BEGIN
                                        RegelLength:=Length (TweeRegelPtr^.RegelPtr^);

                                        Move (TweeRegelPtr^.RegelPtr^[1],WriteBufPtr^[WriteBufPos],RegelLength);
                                        WriteBufPos:=WriteBufPos+RegelLength;
                                   END;

                                   TweeRegelPtr:=TweeRegelPtr^.NextRegelRecordPtr;
                                   MsgsNewSeek (TweeRegelPtr);
                              END;

                          wSwapped :
                              BEGIN
                                   BlockRead (SwapFile,RegelLength,1);

                                   IF (RegelLength = 0) THEN
                                   BEGIN
                                        TweeRegelPtr:=TweeRegelPtr^.NextRegelRecordPtr;
                                        MsgsNewSeek (TweeRegelPtr);
                                        Continue;
                                   END;

                                   BlockRead (SwapFile,FooterLine[1],RegelLength);
                                   FooterLine[0]:=Char (RegelLength);

                                   { geen seenby en path regels toevoegen! }
                                   IF (Copy (FooterLine,1,7) <> 'SEEN-BY') AND
                                      (Copy (FooterLine,1,6) <> #1'PATH:') THEN
                                   BEGIN
                                        Move (FooterLine[1],WriteBufPtr^[WriteBufPos],RegelLength);
                                        WriteBufPos:=WriteBufPos+RegelLength;
                                   END;
                              END; { wSwapped }
                     END; { case }

                     { kijk of WriteBuf vol begint te raken }
                     IF (WriteBufPos > WriteBufSize-256) THEN
                     BEGIN
                          BlockWrite (TxtFile,WriteBufPtr^[0],WriteBufPos);
                          UpdateInfoNr (INFO_JamSave_Bytes,WriteBufPos);
                          JamMsgSize:=JamMsgSize+WriteBufPos;
                          WriteBufPos:=0; { zo, nu is ie weer leeg }
                     END;
                END; { while }
           END; { er is een footer }

           { kijk of er nog wat in WriteBuf zit }
           IF (WriteBufPos > 0) THEN
           BEGIN
                BlockWrite (TxtFile,WriteBufPtr^[0],WriteBufPos);
                UpdateInfoNr (INFO_JamSave_Bytes,WriteBufPos);
                JamMsgSize:=JamMsgSize+WriteBufPos;
                WriteBufPos:=0; { overbodig, maar goed... }
           END;

           JamMsgHeaderOffset:=FileSize (HdrFile);

           { schrijf een index entry naar disk }
           IF (NOT WriteIndexEntry (Msg.ToUser_F,JamMsgHeaderOffset)) THEN
           BEGIN
                LogMessage ('[JAM] Unable to update index for '+AreaName);
                Exit;
           END;

           { bouw de bericht headers in het geheugen }
           FillSubFields; { kan swapfile positie wijzigen }
           FillMsgHeader;

           { schrijf de header naar disk }
           IF (NOT WriteHeaderEntry) THEN
           BEGIN
                LogMessage ('[JAM] Unable to update header for '+AreaName);
                Exit;
           END;

           Inc (Jam_JHR_Header.ActiveMsgs);

           { update de fixed header }
           WriteJamHeader;

           UpdateInfoNr (INFO_JamSave_Msgs,1);

     UNTIL (EenRegelPtr = NIL); { totdat de hele body verwerkt is }

Einde:
     IF (WriteBufPtr <> NIL) THEN
     BEGIN
          FreeMem (WriteBufPtr,WriteBufSize);
          WriteBufPtr:=NIL;
     END;

     { verwijder het slot... }
     UnlockBase;

     CloseBase; { RWI 950506: toegevoegd }
END;


{--------------------------------------------------------------------------}
{ WriteIndexEntry                                                          }
{                                                                          }
{ Voegt een index entry toe aan het einde van het index bestand voor het   }
{ bericht zoals dat nu in het geheugen staat.                              }
{                                                                          }
FUNCTION JamBase.WriteIndexEntry (Source : STRING; Offset : LONGINT) : BOOLEAN;

VAR TmpIdx : JAMIDXREC;
    Regel  : STRING;

BEGIN
     WriteIndexEntry:=FALSE; { assume failure }

     IF (NOT IsOpen) THEN
        Exit;

     Regel:=LoCaseString (DeleteBackSpaces (Source));

     IF (Source <> '') THEN
        TmpIdx.UserCRC:=UpdateCRC32 ($FFFFFFFF,Regel[1],Length (Source))
     ELSE
         TmpIdx.UserCRC:=$FFFFFFFF;

     TmpIdx.HdrOffset:=Offset;
     {$I-}
     IF (FileSize (IdxFile) <> FilePos (IdxFile)) THEN
        Seek (IdxFile,FileSize (IdxFile));
     BlockWrite (IdxFile,TmpIdx,SizeOf (JAMIDXREC));
     {$I+}
     WriteIndexEntry:=(IOResult = 0);
END;


{--------------------------------------------------------------------------}
{ WriteHeaderEntry                                                         }
{                                                                          }
{ Schrijft een JamBase header naar disk.                                   }
{                                                                          }
FUNCTION JamBase.WriteHeaderEntry : BOOLEAN;

VAR TmpSubField : JAMBINSUBFIELD;
    Current     : JAMSUBFIELDPTR;
    IORes       : BYTE;

BEGIN
     WriteHeaderEntry:=FALSE;

     IF (NOT IsOpen) THEN
        Exit;

     { Het simpele gedeelte, ofwel het schrijven van de vaste header naar }
     { disk.                                                              }

     {$I-}
     { skip onnodige seek acties }
     IF (FilePos (HdrFile) <> Filesize (HdrFile)) THEN
        Seek (HdrFile,FileSize (HdrFile));
     BlockWrite (HdrFile,Jam_MSG_Header,SizeOf (Jam_MSG_Header));
     {$I+}
     IORes:=IOResult;

     { Schrijf nu alle SubFields naar disk }
     IF (IORes = 0) THEN
     BEGIN
          Current:=JamSubfieldList.GetFirstItem;
          WHILE (Current <> NIL) DO
          BEGIN
               WITH TmpSubField DO
               BEGIN
                    LoID:=Current^.LoID;
                    HiID:=0;              { Reserved }
                    DatLen:=Length (Current^.Buffer);
               END;

               {$I-}
               BlockWrite (HdrFile,TmpSubField,SizeOf (TmpSubField));
               BlockWrite (HdrFile,Current^.Buffer[1],Length (Current^.Buffer));
               UpdateInfoNr (INFO_JamSave_Bytes,SizeOf (TmpSubField)+Length (Current^.Buffer));
               {$I+}
               IORes:=IOResult;

               Current:=JamSubFieldList.GetNextItem;
          END; { while }
     END; { if }

     WriteHeaderEntry:=(IORes = 0);
END;


{--------------------------------------------------------------------------}
{ WriteJAMHeader                                                           }
{                                                                          }
{ Schrijft een verse JAM header naar de *.JHR file.                        }
{                                                                          }
FUNCTION JamBase.WriteJAMHeader : WORD;
BEGIN
     {$I-}
     Seek (HdrFile,0);
     Inc (Jam_JHR_header.modcounter);
     BlockWrite (HdrFile,Jam_JHR_header,SizeOf (Jam_JHR_header));
     {$I+}
     WriteJamHeader:=IOResult;
END;


{--------------------------------------------------------------------------}
{ ReadHeader                                                               }
{                                                                          }
{ Leest een JAM base header + alle subfields in het geheugen. De subfields }
{ die gebruikt kunnen worden, worden omgezet in het interne formaat.       }
{                                                                          }
FUNCTION JamBase.ReadHeaderEntry : BOOLEAN;

VAR IORes : BYTE;

BEGIN
     ReadHeaderEntry:=FALSE;

     { controleer of de bestanden wel open zijn }
     IF (NOT IsOpen) THEN
        Exit;

     { we beginnen simpel, lees de vaste header in }
     JamMsgHeaderOffset:=FilePos (HdrFile);

     {$I-} BlockRead (HdrFile,Jam_MSG_Header,SizeOf (Jam_MSG_Header)); {$I+}
     IORes:=IOResult;

     IF (IORes <> 0) THEN
        Exit; { false }

     { controleer of de header wel klopt }
     IF (Jam_MSG_Header.Signature <> HeaderSig) THEN
        Exit; { false }

     ReadHeaderEntry:=TRUE;
END;


{---------------------------------------------------------------------------}
{ ReadJAMSubFields                                                          }
{                                                                           }
{ Leest de header subfields in en vertaald de gegevens naar het interne     }
{ *.MSG formaat.                                                            }
{                                                                           }
FUNCTION JamBase.ReadJAMSubFields (Import : BOOLEAN) : BOOLEAN;

VAR SubFieldLen : LONGINT;
    SubFieldBin : JAMBINSUBFIELD;
    Ignore,
    Buffer      : STRING;
    IORes       : BYTE;
    HadFromAddr : BOOLEAN;

BEGIN
     ReadJAMSubFields:=TRUE;
     Ignore:='';
     SubFieldLen:=Jam_MSG_Header.SubFieldLen;
     HadFromAddr:=FALSE;

     WHILE (SubFieldLen > SizeOf (JAMBINSUBFIELD)) DO
     BEGIN
          { Lees het binaire header gedeelte gevolgt door de buffer }
          {$I-} BlockRead (HdrFile,SubFieldBin,SizeOf (JAMBINSUBFIELD));

          { Controlleer of SubfieldLen wel een geldige waarde heeft ! }
          { Als die echter troep bevat ging hij mooi door de buffer   }
          { heen, met als gevolg dat het programma vastliep !         }

          IF (SubFieldBin.DatLen > 255) THEN
          BEGIN
               LogMessage ('[JAM] Damaged (too long) message header found in '+AreaName);
               ReadJAMSubFields:=FALSE;
               Break;
          END;

          BlockRead (HdrFile,Buffer[1],SubFieldBin.DatLen); {$I+}
          Buffer[0]:=Char (SubFieldBin.DatLen);
          IORes:=IOResult;
          IF (IORes <> 0) THEN
          BEGIN
               LogDiskIOError (IORes,'[JAM] Fatal error reading subfield in '+AreaName);
               ReadJAMSubFields:=FALSE;
               Exit;
          END;

          CASE SubFieldBIN.LoID OF
{ From Adres } 0000 :
                   BEGIN
                        FidoSplit (Buffer,Msg.FromAddr_F);
                        HadFromAddr:=TRUE;
                   END;

{ To   Adres } 0001 : FidoSplit (Buffer,Msg.ToAddr_F);
{ From User  } 0002 : Msg.FromUser_F:=Buffer;
{ To   User  } 0003 : Msg.ToUser_F:=Buffer;
          END; { case }

          { RWI 941214: waar nodig #13 toegevoegd. Stond nog nergens,   }
          {             waardoor de tear & origin aan elkaar zaten etc. }
          IF Import THEN
             CASE SubFieldBIN.LoID OF
   { MsgID }      0004 :
                      BEGIN
                           FidoAddLineToMessage (#1'MSGID: '+Buffer+#13,Ignore);

                           { RWI 960821: added support for missing 0000 }
                           IF (NOT HadFromAddr) AND (Buffer[1] IN ['0'..'9']) AND (Pos (' ',Buffer) > 0) THEN
                              FidoSplit (Copy (Buffer,1,Pos (' ',Buffer)-1),Msg.FromAddr_F);
                      END;

   { Reply }      0005 : FidoAddLineToMessage (#1'REPLY: '+Buffer+#13,Ignore);
 { Subject }      0006 : Msg.Subj_F:=Buffer;
     { PID }      0007 : FidoAddLineToMessage (#1'PID: '+Buffer+#13,Ignore);
   { Trace }      0008 : FidoAddLineToMessage (#1'Via: '+Buffer+#13,Ignore);
{ Enclosed }      0009 :
                      BEGIN
                           Msg.Subj_F:=Buffer;
                           Msg.Attr_F:=Msg.Attr_F OR MSGFILE;
                      END;

     { FTS }      2000 : FidoAddLineToMessage (#1+Buffer+#13,Ignore);
  { SeenBy }      2001 : FidoAddLineToMessage ('SEEN-BY: '+Buffer+#13,Ignore);
    { Path }      2002 : FidoAddLineToMessage (#1'PATH: '+Buffer+#13,Ignore);
   { Flags }      2003 : FidoAddLineToMessage (#1'FLAGS: '+Buffer+#13,Ignore);
             END; { case, if }

             Dec (SubFieldLen,SubFieldBin.DatLen+SizeOf (JAMBINSUBFIELD));
     END; { while }

     IF (SubFieldLen > 0) THEN
     BEGIN
          {
          LogMessage ('[JAM] Trying to work around SubFields length error in '+AreaName+
                      ' (off by '+Longint2String (SubFieldLen)+')');
          }
          Seek (HdrFile,FilePos (HdrFile)+SubFieldLen);
     END;
END;


{---------------------------------------------------------------------------}
{ ReadJAMSubField0003                                                       }
{                                                                           }
{ Leest de header subfields op zoek naar nummer 0003. Deze is bevat de      }
{ to-user en wordt gebruikt in de index.                                    }
{                                                                           }
FUNCTION JamBase.ReadJAMSubField0003 : STRING;

VAR SubFieldLen : LONGINT;
    SubFieldBin : JAMBINSUBFIELD;
    Buffer      : STRING;

BEGIN
     ReadJAMSubField0003:='';

     SubFieldLen:=Jam_MSG_Header.SubFieldLen;

     WHILE (SubFieldLen > SizeOf (JAMBINSUBFIELD)) DO
     BEGIN
          { Lees het binaire header gedeelte gevolgt door de buffer }
          {$I-} BlockRead (HdrFile,SubFieldBin,SizeOf (JAMBINSUBFIELD)); {$I+}
          IF (IOResult <> 0) THEN
             Exit;

          IF (SubFieldBin.DatLen > 255) THEN
             Exit;

          BlockRead (HdrFile,Buffer[1],SubFieldBin.DatLen); {$I+}
          Buffer[0]:=Char (SubFieldBin.DatLen);
          IF (IOResult <> 0) THEN
             Exit;

          IF (SubFieldBIN.LoID = 0003) THEN
          BEGIN
               { gevonden! }
               ReadJAMSubField0003:=Buffer;
               Exit;
          END;

          Dec (SubFieldLen,SubFieldBin.DatLen+SizeOf (JAMBINSUBFIELD));
     END; { while }
END;


{--------------------------------------------------------------------------}
{ ScanArea                                                                 }
{                                                                          }
{ Scant een JAM area op lokale berichten die nog niet verstuurd zijn.      }
{                                                                          }
PROCEDURE JamBase.ScanArea (AreaData : AreaBaseRecord; IsPrimaryNetmailArea : BOOLEAN);

VAR BodyFile    : FBufferType;
    DatumTijd   : DateTime;
    BytesToRead : LONGINT;
    Regel,
    LastRegel   : STRING;
    RealLen     : BYTE;
    TrashCount  : WORD;
    IORes       : BYTE;
    OldIdxPos   : LONGINT;
    PrevTouch   : BYTE;
    FirstExport : BOOLEAN;

LABEL GaVerder;

BEGIN
     FirstExport:=TRUE;

     { at export: this message is not from a user, but from a msgbase }
     UserDataRecNr:=NILRecordNr;

     IF (NOT OpenBase (FALSE,AreaData.AreaName_F,AreaData.FidoMsgPath)) THEN
     BEGIN
          LogMessage ('[JAM] Unable to access '+AreaData.AreaName_F);
          Exit;
     END;

     ReadJamHeader;     { zorg dat we verse informatie hebben }
     ImportMsgs:=TRUE;  { zorg dat we alles lezen }

     { zoekt in de index en geeft de pointer naar het eerste bericht }
     IF (NOT GetFirstMessage) THEN
     BEGIN
          { er zijn geen berichten aanwezig }
          CloseBase;
          Exit;
     END;

     REPEAT
           { Lees de bericht header en subfields in het geheugen }
           IF (NOT ReadHeaderEntry) THEN
           BEGIN
                LogMessage ('[JAM] Error reading message header for '+AreaName+' in msg '+
                            Word2String (Currentmessage)+', possible index failure?');

                { einde area }
                CloseBase;
                Exit;
           END;

           { Controleer of het bericht                    }
           {   a) de local vlag heeft                     }
           {   b) niet de sent vlag                       }
           {   c) niet de deleted vlag heeft              }
           {   d) niet de Hold vlag heeft (RWI 950531)    }
           { want ga dan verder met het volgende bericht  }
           IF ((Jam_MSG_header.Attribute AND JMSG_LOCAL) = 0) OR
              ((Jam_MSG_header.Attribute AND JMSG_SENT) <> 0) OR
              ((Jam_MSG_header.Attribute AND JMSG_DELETED) <> 0) OR { RWI 941130: changed to <> 0 }
              ((Jam_MSG_header.Attribute AND JMSG_HOLD) <> 0) OR
              ((Jam_MSG_header.Attribute AND JMSG_LOCKED) <> 0) OR { RAWI 970804 }
              ((Jam_MSG_header.Attribute AND JMSG_FILEREQUEST) <> 0)
           THEN
               GOTO GaVerder;

           { lees alleen de header in }

           MsgsEmpty;

           CASE AreaData.AreaType OF
                Area_Netmail:
                    Msg.Ready_F:=Local_Netmail;

                Area_EMail:
                    BEGIN
                         { RWI 970223: now using AreaData Origin AKA for From }
                         Msg.FromAddr_F:=Config.NodeNrs[AreaData.OriginAKA];
                         Msg.Ready_F:=Local_Netmail;
                    END;

                ELSE BEGIN
                     Msg.Ready_F:=Local_Echomail;
                     { Stop de AREA: kludge in de eerste regel van het bericht }
                     Msg.Area_F:=AreaData.AreaName_F;
                     MsgsAddLineTo (Header_F,'AREA:'+Msg.Area_F);
                END;
           END; { case }

           { als er subfields waren, lees die dan ook in }
           IF (Jam_MSG_Header.SubFieldLen > 0) THEN
              ReadJAMSubFields (ImportMsgs);

           { Voeg INTL, TOPT en FMPT regels toe }
           IF (AreaData.AreaType = Area_EMail) THEN
           BEGIN
                IF (Msg.ToUser_F = '') THEN
                   { expecting To: on first line }
                   Msg.ToUser_F:=Config.GatewayUser
                ELSE
                    IF (UpCaseString (Msg.ToUser_F) <> Config.GatewayUser) THEN
                    BEGIN
                         IF (Pos ('@',Msg.ToUser_F) = 0) AND (Pos ('!',Msg.ToUser_F) = 0) THEN
                         BEGIN
                              IF Config.LogDebug THEN
                                 LogMessage ('JAM['+AreaData.AreaName_F+'] Msg '+Longint2String (Jam_Msg_Header.MsgNum)+
                                             ': No e-mail address in To: ("'+Msg.ToUser_F+'")');
                              GOTO GaVerder;  { geen e-mail! }
                         END;

                         IF Config.LogExportedMsgs THEN
                         BEGIN
                              IF FirstExport THEN
                              BEGIN
                                   FirstExport:=FALSE;
                                   LogMessage ('Exporting from '+AreaData.AreaName_F+' (JAM)');
                              END;

                              LogMessage ('  Exporting e-mail for '+Msg.ToUser_F);
                         END;

                         MsgsAddFirstLineTo (Body,'To: '+Msg.ToUser_F);
                         Msg.ToUser_F:=Config.GatewayUser;
                    END;
                    { else assume To: in body }

                { zoek het bijpassende system node nummer voor in de To: }
                FidoMatch (Msg.FromAddr_F,Msg.ToAddr_F);
                Msg.Ready_F:=Local_Netmail;
           END;

           { converteer de Jam_Header naar de interne structuur }
           Msg.Attr_F:=SetAttributes;

           { Als dit een netmail bericht is en we draaien in frontdoor mode }
           { mag het bericht alleen verstuurd worden als het a) voor ons    }
           { bestemd is, en b) voor postmaster is !                         }

           IF (Msg.Ready_F = Local_Netmail) AND { RWI 941102: toegevoegd, anders krijg echomail geen sent flag }
              (NOT FidoCheckNetmail (IsPrimaryNetmailArea)) { gaf ook TRUE terug voor Local msgs }
           THEN
               { body file is al dicht... }
               GOTO GaVerder; { netmail voor FD. Bye! }

           { ok, fine ... lees het bericht maar in }

           IF (AreaData.AreaType <> Area_Echo) THEN
           BEGIN
                { dus net of e-mail, local komt niet voor }
                MsgsAddlineTo (Header_F,#1'INTL '+Fido23DStr (Msg.ToAddr_F)+' '+
                                        Fido23DStr (Msg.FromAddr_F));

                IF (Msg.ToAddr_F.Point > 0) THEN
                   MsgsAddLineTo (Header_F,#1'TOPT '+Word2String (Msg.ToAddr_F.Point));

                IF (Msg.FromAddr_F.Point > 0) THEN
                   MsgsAddLineTo (Header_F,#1'FMPT '+Word2String (Msg.FromAddr_F.Point));
           END;

           { converteer de JAM Header naar de fido stijl header }
           UnixToDos (Jam_MSG_header.DateWritten,DatumTijd);

           { stel de datum in }
           WITH DatumTijd DO
                Msg.Date_F:=FidoTime2Str (Day,Month,Year,Hour,Min,Sec);

           Msg.Cost_F:=jam_MSG_header.Cost;

           { open de invoer file }
           IF (NOT FBufferOpen (BodyFile,AreaPath+EXT_TXTFILE,10000,0)) THEN
           BEGIN
                LogMessage ('[JAM] Unable to open area '+AreaName);
                FBufferClose (BodyFile);
                CloseBase; { RWI 941102 }
                Exit;
           END;

           IF (NOT FBSeek (BodyFile,Jam_MSG_header.TxtOffset)) THEN
           BEGIN
                LogMessage ('[JAM] Error seeking position '+Longint2String (Jam_MSG_header.TxtOffset)+
                            ' in '+AreaPath+EXT_TXTFILE);
                FBufferClose (BodyFile);
                CloseBase;
                Exit;
           END;

           { lees het bericht regel voor regel in }
           BytesToRead:=Jam_MSG_header.TxtLen;

           { --- Init boolean variabelen }
           Found_SeenBy:=FALSE;
           Found_Path:=FALSE;
           Found_Origin:=FALSE;
           Found_Tear:=FALSE;

           { RWI 950120: BytesToRead controle weer ingebouwd en }
           {             FBReadLnCRTell gemaakt voor correcte   }
           {             telling.                               }
           WHILE (BytesToRead > 0) AND
                 FBReadLnCRTell (BodyFile,Regel,TrashCount) AND
                 (Regel <> #0) DO
           BEGIN
                { RWI 960715: Als de body van een JAM bericht eindigt op }
                {             een #0 dan gaat alles goed. Maar als ie op }
                {             een LF eindigt dan wordt die pas bij het   }
                {             ophalen van de volgende regel als Trash    }
                {             terug gegeven, samen met de eerste regel   }
                {             van het volgende bericht.                  }
                {             De volgende control lost dit netjes op en  }
                {             voorkomt uitzonderingssituaties.           }
                IF (BytesToRead = 1) AND (TrashCount > 0) THEN
                   Break; { reached end of message }

                Dec (BytesToRead,Length (Regel)+TrashCount);

                { filter alle soft CR's eruit }
                WHILE (Pos (#$8D,Regel) > 0) DO
                      Delete (Regel,Pos (#$8D,Regel),1);

                { FidoAddLineToMessage gaat er vanuit dat de nodige }
                { cr,lf enzo al in Regel zitten. Dat hebben we dus  }
                { precies nodig om regels langer dan 255 tekens toe }
                { te kunnen voegen...                               }
                FidoAddLineToMessage (Regel,LastRegel);
           END; { while }

           { RWI 960821: de laatste CR wordt soms gestript in JAM bases, }
           {             en dan wordt onze Via kludge aan de laatste     }
           {             kludge vastgeplakt, dus we zorgen er hier voor  }
           {             dat de laatste kludge een #13 had.              }
           IF (LastRegel[Length (LastRegel)] <> #13) AND (PrevKludgeID <> klNone) THEN
              MsgsAddLineToNoEOL (Footer_F,#13);

           FidoAddLastLine (LastRegel);

           { de body hebben we nu niet meer nodig... }
           FBufferClose (BodyFile);

           { fix het bericht door ontbrekende delen bij te vullen }
           IF (NOT Found_Tear) THEN
              MsgsAddLineTo (Footer_F,FidoTear);

           { Zorg dat er een tearline wordt toegevoegd, een origin line }
           { zodat we een 'echt' fido bericht krijgen.                  }
           IF (AreaData.AreaType = Area_Echo) THEN
              FidoFinishEchomailExport;

           { er trad hier een lock error op omdat MsgsExport de base }
           { weer gesloten had. Nu gebruiken we een andere base voor }
           { het lezen en schrijven van berichten en het locking     }
           { mechanisme houdt ze uit elkaar.                         }

           { update de header met een SENT vlag }
           Jam_MSG_Header.Attribute:=Jam_MSG_Header.Attribute OR JMSG_SENT;

           { check voor een KillSent vlag }
           IF (Msg.WasGated AND Config.KillGatedNetmail) OR
              ((Jam_MSG_Header.Attribute AND JMSG_KILLSENT) <> 0)
           THEN
               Jam_MSG_Header.Attribute:=Jam_MSG_Header.Attribute OR JMSG_DELETED;

           { schrijf de header naar disk }
           IF (NOT LockBase) THEN
              LogMessage ('[JAM.SCANAREA] Cannot lock area to update Flags')
           ELSE BEGIN
                {$I-}
                Seek (HdrFile,CurrentHeader);
                BlockWrite (HdrFile,Jam_MSG_Header,SizeOf (Jam_MSG_Header));
                {$I+}
                IORes:=IOResult;

                UnlockBase;
           END;

           { -- Exporteer het bericht    }
           {Inc (FidoProcessStatus.BytesCount,Msg.MsgSize);}
           {FidoProcessStatusShow;}

           { nu wordt het tricky, want MsgsExport kan een JAM base     }
           { gebruiken. Bijvoorbeeld als we een bericht terug krijgen, }
           { maar ook als de listserver zijn werk doet..               }
           { DUS, moeten we van alles doen om er zeker van te zijn dat }
           { we straks weer verder kunnen. Het sluiten van de base     }
           { gebeurt vanzelf als het nodig is. We moeten dus alleen    }
           { positionele gegevens bijhouden.                           }

           PrevTouch:=TouchCounter;
           OldIdxPos:=FilePos (IdxFile);

           UpdateInfoNr (INFO_JamScan_Msgs,1);

           IF FirstExport THEN
           BEGIN
                FirstExport:=FALSE;
                LogMessage ('Exporting from '+AreaData.AreaName_F+' (JAM)');
           END;

           IF (Msg.Ready_F = Local_Netmail) THEN
           BEGIN
                UpdateInfoNr (INFO_JamScan_Net,1);

                IF Config.LogExportedMsgs AND (AreaData.AreaType <> Area_Email) THEN
                   LogMessage ('  Exporting netmail for "'+Msg.ToUser_F+'"%'+Fido2Str (Msg.ToAddr_F));
           END ELSE
           BEGIN
                UpdateInfoNr (INFO_JamScan_Echo,1);

                UpdateAreaStats (GetAreaBaseRecordNrByAreaName_F (AreaData.AreaName_F),Msg.MsgSize);
                UpdateUserStats (NILRecordNr{=Local},EchoFrom,Msg.MsgSize); { RWI950603: regel toegevoegd }

                IF Config.LogExportedMsgs THEN
                   LogMessage ('  Exporting echomail for "'+Msg.ToUser_F+'"');
           END;

           MsgsExport;

           IF (TouchCounter <> PrevTouch) THEN
           BEGIN
                { Er is iets gebeurt met de JAM-base object instantie. }
                { Nu moeten we de boel herstellen.                     }

                IF (NOT OpenBase (FALSE,AreaData.AreaName_F,AreaData.FidoMsgPath)) THEN
                BEGIN
                     LogMessage ('[JAM] Unable to re-access '+AreaData.AreaName_F);
                     Exit;
                END;

                ReadJamHeader;     { zorg dat we verse informatie hebben }
                ImportMsgs:=TRUE;  { zorg dat we alles lezen }

                { herstel nu de file pointer in de index file, want die }
                { gebruikt GetNextMessage.                              }
                Seek (IdxFile,OldIdxPos);
           END;

GaVerder:

     UNTIL (NOT GetNextMessage);

     { Einde area }
     CloseBase;
END;


{--------------------------------------------------------------------------}
{ ReIndexJamArea                                                           }
{                                                                          }
{ Creert een nieuwe index voor een JAM area.                               }
{                                                                          }
PROCEDURE JamBase.ReIndexArea (AreaData : AreaBaseRecord);

VAR NextEntry : LONGINT;
    First     : BOOLEAN;
    IORes     : BYTE;
    TmpIdx    : JAMIDXREC;

LABEL GaVerder;

BEGIN
     { zorg ervoor dat de base open is }
     ImportMsgs:=TRUE; { zorg dat we alleen header lezen }

     IF (NOT OpenBase (TRUE,AreaData.AreaName_F,AreaData.FidoMsgPath)) THEN
     BEGIN
          LogMessage ('[JAM] Unable to access '+AreaData.AreaName_F);
          Exit;
     END;

     { zorg dat andere programma niet meer kunnen }
     IF (NOT LockBase) THEN
     BEGIN
          LogMessage ('[JAM] Area locked tight ('+AreaName+'); reindex failed');
          CloseBase;
          Exit;
     END;

     { overschrijf de indexfile }
     {$I-} ReWrite (IdxFile,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[JAM] Unable to recreate index file for '+AreaName);
          CloseBase;
          Exit;
     END;

     { zorg voor up-to-date informatie }
     ReadJAMHeader;

     First:=TRUE;

     Status.DezeArea:=0;
     Status.DezeTodo:=0; {Jam_MSG_Header.ActiveMsgs;}

     WHILE (NOT Eof (HdrFile)) DO
     BEGIN
          IF (NOT ReadHeaderEntry) THEN
          BEGIN
               { probeer het volgende intacte frame te vinden }
               IF (NOT Synchronize (HdrFile,HeaderSig,SizeOf (HeaderSig))) THEN
               BEGIN
                    LogMessage ('[JAM] Error reading message header in '+Areaname);
                    CloseBase; { RWI 970204 }
                    Exit;
               END;

               Continue; { resynchronized }
          END;

          { Pas de base message teller aan aan het eerste bericht  }
          { Deze teller bevat tenslotte het nummer van het laagste }
          { bericht.                                               }
          IF First THEN
          BEGIN
               JAM_JHR_header.BaseMsgNum:=JAM_MSG_Header.MsgNum;
               First:=FALSE;
          END;

          { Voeg een bericht toe als het niet gedelete is       }
          { En het een geldig nummer heeft, ergo .. groter dan  }
          { het base number.                                    }
          IF ((Jam_MSG_header.Attribute AND JMSG_DELETED) <> 0) THEN
             GOTO GaVerder;

          {
          IF ((Jam_MSG_header.MsgNum < JAM_JHR_header.BaseMsgNum)) THEN
             Continue;
          }

          { Als het bericht nummer groter is dan het vorige bericht nummer }
          { vul de header aan met lege records.                            }
          NextEntry:=(Jam_Msg_Header.MsgNum-Jam_JHR_header.BaseMsgNum)*SizeOf (JAMIDXREC);

          IF (NextEntry < FileSize (IdxFile)) THEN
          BEGIN
               { Een bericht dat niet in de goede volgorde staat .. }
               { Skippen... dat wordt bij de volgende purge wel     }
               { meegenomen.                                        }
               { RWI 941115: loggen toegevoegd }
               LogMessage ('[JAM] Wrong order for message '+Longint2String (Jam_Msg_header.MsgNum)+'; Skipping for now;');
               LogExtraMessage ('Please renumber '+AreaName);
               GOTO GaVerder;
          END;

          IF (NextEntry-FileSize (IdxFile) > 8192) THEN
             LogMessage ('[JAM] Advise: renumber '+AreaName+' to save space');

          { Vul de index aan met blanke entry's voor alle bericht nummers }
          { die blijkbaar niet voorkomen.                                 }
          { RWI 941115: aangepast zodat er niet meer gekeken wordt naar   }
          {             de grootte van het gat.                           }
          WHILE (NextEntry > FileSize (IdxFile)) DO
                IF (NOT WriteIndexEntry ('',$FFFFFFFF)) THEN
                BEGIN
                     LogMessage ('[JAM] Unable to append to index file '+AreaName);
                     Exit;
                END; { if, while }

          { voeg een index entry toe }
          IF (NOT WriteIndexEntry (ReadJamSubField0003,JamMsgHeaderOffset)) THEN
          BEGIN
               LogMessage ('[JAM] Unable to append to index file '+AreaName);
               Exit;
          END;

          Inc (Status.DezeArea);
          IF ((Status.DezeArea MOD 24) = 1) THEN
          BEGIN
               UtilUpdateProgress;
               Slice_Now;
          END;

     GaVerder:

          { subfields blok overslaan, klaar zetten voor volgende header }
          Seek (HdrFile,JamMsgHeaderOffset+SizeOf (Jam_MSG_Header)+Jam_MSG_Header.SubFieldLen);

     END; { while }

     { RWI 941115: update de header, want daarin staat het eventuele }
     {             nieuwe BaseMsgNum.                                }
     IF (NOT First) THEN
        WriteJAMHeader;

     { geef de base weer vrij voor gebruik }
     UnlockBase;
     CloseBase;
END;


{--------------------------------------------------------------------------}
{ PackArea                                                                 }
{                                                                          }
{ Verwijderd oude en/of deleted berichten uit de base. Dit door een nieuwe }
{ header en body te creeren en berichten te kopieren.                      }
{                                                                          }
{ RWI 960928: aangepast omdat berichten verwijderd werden bij >max.        }
{             Hierbij worden de 128 oudste berichten tijdens een run       }
{             bewaards voor de volgende run. Bij gelijke data worden de    }
{             eerst voorkomende verwijderd.                                }
{                                                                          }
PROCEDURE JamBase.PackArea (AreaData : AreaBaseRecord);

CONST MaxPacks = 128;

VAR PackDates   : ARRAY[1..MaxPacks] OF LONGINT;
    PackFPos    : ARRAY[1..MaxPacks] OF LONGINT;
    IdxRec      : JAMIDXREC;
    OldSize,
    NewSize     : LONGINT;

    {----------------------------------------------------------------------}
    { AddPack                                                              }
    {                                                                      }
    { Voeg een entry toe aan de het Pack array dat straks gebruikt wordt   }
    { om extra entries af te schieten, mocht dat nodig zijn. Deze wordt    }
    { ingevoegd, mocht ie niet jonger dan de jongste zijn.                 }
    {                                                                      }
    PROCEDURE AddPack (FPos,Date : LONGINT);

    VAR Lp,Lp2 : 1..MaxPacks;

    BEGIN
         FOR Lp:=1 TO MaxPacks DO
             IF (Date < PackDates[Lp]) THEN
             BEGIN
                  FOR Lp2:=MaxPacks-1 DOWNTO Lp DO
                  BEGIN
                       PackDates[Lp2+1]:=PackDates[Lp2];
                       PackFPos[Lp2+1]:=PackFPos[Lp2];
                  END;

                  PackDates[Lp]:=Date;
                  PackFPos[Lp]:=FPos;

                  Exit;
             END;
    END;

    {----------------------------------------------------------------------}
    { ReadIndexEntry                                                       }
    {                                                                      }
    { Net als GetNextMessage, maar dan lokaal zodat de hele index entry    }
    { op de stack bewaard kan worden en naar de nieuwe index geschreven    }
    { kan worden.                                                          }
    {                                                                      }
    FUNCTION ReadIndexEntry : BOOLEAN;

    VAR IORes : BYTE;

    BEGIN
         ReadIndexEntry:=FALSE; { assume failure }

         WHILE (NOT Eof (IdxFile)) DO
         BEGIN
              {$I-} BlockRead (IdxFile,IdxRec,SizeOf (IdxRec)); {$I+} IORes:=IOResult;
              IF (IORes <> 0) THEN
                 Exit; { read past end of file? }

              { Lege index posities hebben een positie met de waarde }
              { $FFFFFFFF deze skippen we.                           }
              IF (IdxRec.HdrOffSet <> $FFFFFFFF) THEN
              BEGIN
                   {$I-} Seek (HdrFile,IdxRec.hdrOffset); {$I+}
                   IORes:=IOResult; { negeer het resultaat }

                   CurrentMessage:=(FilePos (IdxFile) DIV SizeOf (IdxRec))+Jam_JHR_Header.basemsgnum;
                   CurrentHeader:=IdxRec.HdrOffset;

                   ReadIndexEntry:=TRUE;
                   Exit; { uit de while }
              END;
         END; { while }
    END;

    PROCEDURE PrintStats;
    BEGIN
         LogExtraMessage ('JAM    Old: '+AddUpWithPreSpaces (8,Longint2String (OldSize))+
                               'b New: '+AddUpWithPreSpaces (8,Longint2String (NewSize))+
                             'b Saves: '+AddUpWithPreSpaces (3,Byte2String (UtilPercSaved (OldSize,NewSize)))+
                                 '% in '+AreaData.AreaName_F);
    END;

VAR NewHeader,
    NewIndex,
    NewBody     : FILE;
    IORes       : BYTE;
    OldOffset,
    NewActive,
    NewBaseMsg,
    DayToDelete,
    NumToDelete : LONGINT;
    NumBU,Lp    : 1..MaxPacks;
    Found       : BOOLEAN;
    NextEntry   : LONGINT;
    TmpIdxRec   : JAMIDXREC;

LABEL AbortE,  { erase temp files + below }
      AbortU,  { unlock base + below }
      AbortC;  { close base }

BEGIN
     { Vul het status window }
     WriteXY (SXb2,SYb+2,'JAM       ');

     { Bereken de datum waarop een bericht als te oud kan worden      }
     { beschouwd. Als er geen limiet bestaat, word MaxLongInt genomen }
     { dat zou de datum tot ongeveer 100 jaar in de toekomst moeten   }
     { verschuiven.                                                   }
     IF (AreaData.FidoMsgAge > 0) THEN
        DayToDelete:=GetCurrentUnixTime-(Longint (AreaData.FidoMsgAge)*SEC_Dag)
     ELSE
         DayToDelete:=0;

     { RWI 960928: er zijn nu twee doorgangen door de purge code. De }
     {             eerste verwijdert deleted berichten en op datum   }
     {             en als er dan nog te veel berichten zijn, dan     }
     {             verwijdert de tweede nog meer. De eerste doorgang }
     {             legt daarvoor een index op datum aan.             }

     NumToDelete:=0; { tijdens tweede doorgang pas }
     OldSize:=0;     { voor de statistieken }

     FOR Lp:=1 TO MaxPacks DO
     BEGIN
          PackDates[Lp]:=MAXLONGINT;
          PackFPos[Lp]:=-1; { unused }
     END;

     TmpIdxRec.UserCRC:=$FFFFFFFF;
     TmpIdxRec.HdrOffset:=$FFFFFFFF;

     REPEAT
           IF (NumToDelete > 0) THEN
              WriteXY (SXb2,SYb+6,'Extended purge    ')
           ELSE
               WriteXY (SXb2,SYb+6,'Purge             ');

           NumBU:=NumToDelete;

           { zorg ervoor dat de base open is }
           IF NOT OpenBase (TRUE,AreaData.AreaName_F,AreaData.FidoMsgPath) THEN
           BEGIN
                LogMessage ('[JAM] Unable to access '+AreaData.AreaName_F);
                Exit;
           END;

           IF (OldSize = 0) THEN
           BEGIN
                OldSize:=FileSize (IdxFile)+FileSize (TxtFile)+FileSize (HdrFile);
                NewSize:=OldSize; { in case of immediate abort }
           END;

           { En als er helemaal geen berichten zijn, waarom zouden we ons }
           { dan drukmaken ?                                              }
           IF (FileSize (IdxFile) = 0) THEN
           BEGIN
                PrintStats;
                GOTO AbortC;
           END;

           {$I-} Seek (IdxFile,0); {$I+} IORes:=IOResult;
           IF (IORes <> 0) THEN
           BEGIN
                LogDiskIOError (IORes,'[JAMPurge] Error accessing index file');
                GOTO AbortC;
           END;

           { lees de huidige header informatie }
           ReadJamHeader;
           ImportMsgs:=FALSE; { Zorg dat we alleen header lezen }

           { begin met de base te locken }
           IF (NOT LockBase) THEN
           BEGIN
                LogMessage ('[JAM] Time-out on file lock request for '+AreaPath);
                GOTO AbortC;
           END;

           { Open een nieuwe header, en een nieuwe body file onder }
           { de eigenlijke base namen.                             }
           Assign (NewHeader,AreaPath+'.$$H');
           {$I-} ReWrite (NewHeader,1); {$I+} IORes:=IOResult;
           PeekFiles;

           IF (IORes = 0) THEN
           BEGIN
                Assign (NewBody,AreaPath+'.$$T');
                {$I-} ReWrite (NewBody,1); {$I+} IORes:=IOResult;
                PeekFiles;

                IF (IORes = 0) THEN
                BEGIN
                     Assign (NewIndex,AreaPath+'.$$I');
                     {$I-} ReWrite (NewIndex,1); {$I+} IORes:=IOResult;
                     PeekFiles;
                END;
           END;

           IF (IORes <> 0) THEN
           BEGIN
                LogDiskIOError (IORes,'[JAM] Unable to create new base for '+AreaName);
                GOTO AbortE;
           END;

           { aktief aantal berichten }
           NewActive:=0;
           NewBaseMsg:=-1;

           { schrijf een lege header aan het begin van de nieuwe header }
           {$I-} BlockWrite (NewHeader,Jam_JHR_Header,SizeOf (Jam_JHR_Header)); {$I+}
           IORes:=IOResult;
           IF (IORes <> 0) THEN
           BEGIN
                LogDiskIOError (IORes,'[JAM] Error writing header at beginning of new file '+AreaPath);
                GOTO AbortU;
           END;

           Status.DezeTodo:=0; { geen % }
           Status.DezeArea:=0;

           WHILE ReadIndexEntry DO
           BEGIN
                Inc (Status.DezeArea);

                IF ((Status.DezeArea MOD 25) = 1) THEN
                   Slice_Now;

                { Lees de bericht header en subfields in het geheugen }
                IF (NOT ReadHeaderEntry) THEN
                BEGIN
                     { Einde area }
                     LogMessage ('[JAM] Error reading  header for msg '+Word2String (Currentmessage)+' in');
                     LogExtraMessage (areaName+', possible index failure?');
                     GOTO AbortE;
                END;

                { RWI 960928: deleted berichten zitten niet in de active }
                {             set, dus niet NumToDelete verlagen.        }
                IF ((JAM_Msg_Header.Attribute AND JMSG_DELETED) <> 0) THEN
                   Continue; { met de inner repeat }

                { RWI 960928: bij verwijdering op datum *wel* NumToDelete }
                {             verlagen.                                   }
                IF (DayToDelete <> 0) AND
                   (Jam_Msg_Header.DateProcessed <> 0) AND { RWI 961110 }
                   (Jam_MSG_Header.DateProcessed < DayToDelete)
                THEN
                    Continue; { met de inner repeat }

                { RWI 960928: als we op aantal verwijderen, dan hier checken }
                IF (NumToDelete <> 0) THEN
                BEGIN
                     Found:=FALSE;
                     FOR Lp:=1 TO NumBU DO
                         IF (PackFPos[Lp] = JamMsgHeaderOffset) THEN
                         BEGIN
                              PackFPos[Lp]:=-1;
                              PackDates[Lp]:=MAXLONGINT;
                              Dec (NumToDelete);
                              Found:=TRUE;
                         END;

                     IF Found THEN
                        Continue;
                END;

                UtilUpdateProgress;
                Slice_Now;

                IF KeyPressed AND (ReadKey = kEsc) THEN
                BEGIN
                     GlobalAbort:=TRUE;
                     GOTO AbortE;
                END;

                { Als we hier aankomen mag het bericht dus blijven }
                OldOffSet:=Jam_MSG_Header.TxtOffset;
                Jam_MSG_Header.TxtOffset:=FileSize (NewBody);

                Inc (NewActive);
                IF (NewBaseMsg = -1) THEN
                   NewBaseMsg:=Jam_MSG_Header.MsgNum;

                NextEntry:=(Jam_Msg_Header.MsgNum-NewBaseMsg)*SizeOf (JAMIDXREC);
                IF (NextEntry < FilePos (NewIndex)) THEN
                BEGIN
                     LogMessage ('[JAM] Error in message order; cannot pack or index;');
                     LogExtraMessage ('Please renumber '+AreaName);
                     GOTO AbortE;
                END;

                IF (NextEntry-FileSize (NewIndex) > 8192) THEN
                   LogMessage ('Advise: renumber '+AreaName+' (JAM) to save space');

                WHILE (NextEntry > FileSize (NewIndex)) DO
                BEGIN
                     {$I-} BlockWrite (NewIndex,TmpIdxRec,SizeOf (JAMIDXREC)); {$I+} IORes:=IOResult;
                     IF (IORes <> 0) THEN
                     BEGIN
                          LogDiskIOError (IORes,'Error padding new index file');
                          GOTO AbortE;
                     END;
                END;

                { schrijf een nieuw index record }
                IdxRec.HdrOffset:=FilePos (NewHeader);
                {$I-} BlockWrite (NewIndex,IdxRec,SizeOf (JAMIDXREC)); {$I+} IORes:=IOResult;
                IF (IORes <> 0) THEN
                BEGIN
                     LogDiskIOError (IORes,'[JAM] Error writing new index entry for '+AreaName);
                     GOTO AbortE;
                END;

                AddPack (FilePos (NewHeader),Jam_MSG_Header.DateProcessed);

                { schrijft de nieuwe header naar disk }
                {$I-} BlockWrite (NewHeader,Jam_MSG_Header,SizeOf (Jam_MSG_Header)); {$I+}
                IORes:=IOResult;
                IF (IORes <> 0) THEN
                BEGIN
                     LogDiskIOError (IORes,'[JAM] Error writing to new areabase files in '+AreaName);
                     GOTO AbortE;
                END;

                { Kopieer de header en body naar de nieuwe base }
                IF (NOT CopyFromFile (HdrFile,NewHeader,CurrentHeader+SizeOf (Jam_MSG_Header),Jam_MSG_Header.SubFieldLen)) OR
                   (NOT CopyFromFile (TxtFile,NewBody,OldOffset,Jam_MSG_Header.TxtLen)) THEN
                BEGIN
                     LogMessage ('[JAM] Error copying to new base for '+AreaName);
                     GOTO AbortE;
                END;

           END; { while }

           { RWI 961021: voorkom dat BaseMsgNum -1 wordt!! }
           IF (NewBaseMsg = -1) THEN
              NewBaseMsg:=1;

           { schrijf opnieuw een header naar disk, maar nu met nieuwe gegevens }
           WITH Jam_JHR_header DO
           BEGIN
                Inc (ModCounter);
                ActiveMsgs:=NewActive;
                BaseMsgNum:=NewBaseMsg;
           END; { with }

           { Schrijf de nieuwe JAM header naar disk. Letop! Dit moet naar }
           { de NIEUWE database, dus niet WriteJamHeader gebruiken! }
           {$I-}
           Seek (NewHeader,0);
           BlockWrite (NewHeader,Jam_JHR_Header,SizeOf (Jam_JHR_Header));
           {$I+}
           IORes:=IOResult;
           IF (IORes <> 0) THEN
           BEGIN
                LogDiskIOError (IORes,'[JAM] Error rewriting header at beginning of new file '+AreaPath);
                GOTO AbortE;
           END;

           { sluit de Base files }
           UnlockBase;
           CloseBase;
           AreaPath:=AreaData.FidoMsgPath;

           { statistieken }
           NewSize:=FileSize (NewIndex)+FileSize (NewBody)+FileSize (NewHeader);

           { Probeer de originele files te verwijderen }
           {$I-}
           Close (NewHeader);
           Close (NewBody);
           Close (NewIndex);
           PeekFiles;

           Erase (HdrFile);
           Erase (TxtFile);
           Erase (IdxFile);

           Rename (NewHeader,AreaPath+EXT_HDRFILE);
           Rename (NewBody,AreaPath+EXT_TXTFILE);
           Rename (NewIndex,AreaPath+EXT_IDXFILE);
           {$I+}
           IORes:=IOResult;
           IF (IOResult <> 0) THEN
           BEGIN
                LogDiskIOError (IORes,'[JAM] Error while putting new base in place for '+AreaName);
                Exit;
           END;

           { RIW 960928: Als er meer Active messages zijn, dan er maximaal }
           {             toegestaan zijn, bereken dan hoeveel berichten    }
           {             het loodje moeten leggen.                         }

           IF (AreaData.FidoMsgLimit > 0) THEN
           BEGIN
                NumToDelete:=Jam_JHR_header.ActiveMsgs-AreaData.FidoMsgLimit;

                { RWI 960928: controle toegevoegd! }
                IF (NumToDelete < 0) THEN
                   NumToDelete:=0;

                { RWI 960928: meer dan we bijgehouden hebben kunnen we in }
                {             e'e'n run niet verwijderen, dus limiteer.   }
                IF (NumToDelete > MaxPacks) THEN
                   NumToDelete:=MaxPacks;
           END ELSE
               NumToDelete:=0;

     UNTIL (NumToDelete = 0);

     { beetje statistieken }
     Status.SavedBytes:=Status.SavedBytes+(OldSize-NewSize);

     PrintStats;

     Exit;

AbortE:

     {$I-}
     Close (NewHeader); IORes:=IOResult;

     IF (IORes = 0) THEN
     BEGIN
          Erase (NewHeader);
          IORes:=IOResult;
     END;

     Close (NewBody); IORes:=IOResult;

     IF (IORes = 0) THEN
     BEGIN
          Erase (NewBody);
          IORes:=IOResult;
     END;

AbortU:
     UnlockBase; { RWI 960928 }

AbortC:
     CloseBase;  { RWI 960928 }
END;


{--------------------------------------------------------------------------}
{ LockBase                                                                 }
{                                                                          }
{ Probeert een gegeven aantal maal de area base af te sluiten, de routine  }
{ geeft het resultaat via een boolean terug.                               }
{                                                                          }
FUNCTION JamBase.LockBase : BOOLEAN;

VAR LockTry : WORD;

BEGIN
     { simpel no fuss }
     LockBase:=TRUE;
     IF LockFile (HdrFile) THEN
        Exit;

     { problem! }
     Message ('[JAM] Found '+Areaname+' locked, retrying');

     FOR LockTry:=1 TO JamBaseMaximumLockTrys DO
     BEGIN
          IF LockFile (HdrFile) THEN
             Break;

          DelayOneSecond;
     END;

     WindowPop; { haal bericht weg }

     { als het niet gelukt is, geef dat dan ff door }
     IF (LockTry >= JamBaseMaximumLockTrys) THEN
        LockBase:=FALSE;
END;


{--------------------------------------------------------------------------}
{ UnlockBase                                                               }
{                                                                          }
{ Geeft de Jam Base weer vrij voor andere programma's.                     }
{                                                                          }
FUNCTION JamBase.UnlockBase : BOOLEAN;
BEGIN
     UnlockBase:=UnlockFile (hdrFile);
END;


{--------------------------------------------------------------------------}
{ TranslateDate                                                            }
{                                                                          }
FUNCTION JamBase.TranslateDate (Source : FidoDateType) : LONGINT;

VAR DatumTijd : DateTime;
    Months,
    Error     : ValNop;
    Temp      : LONGINT;

BEGIN
     WITH DatumTijd DO
     BEGIN
          Val (Copy (Source,1,2),Day,Error);
          Val (Copy (Source,8,2),Year,Error);
          Val (Copy (Source,12,2),Hour,Error);
          Val (Copy (Source,15,2),Min,Error);
          Val (Copy (Source,18,2),Sec,Error);
          Months:=1; { just in case }
     END;

     FOR Months:=1 TO 12 DO
         IF (Month[Months] = Copy (Source,4,3)) THEN
         BEGIN
              DatumTijd.Month:=Months;
              Break;
         END;

     IF (DatumTijd.Year > 79) THEN
        Inc (DatumTijd.Year,1900)
     ELSE
         Inc (DatumTijd.Year,2000);

     DosToUnix (DatumTijd,Temp);

     TranslateDate:=Temp;
END;


{--------------------------------------------------------------------------}
{ SaveFile                                                                 }
{                                                                          }
{ Deze functie opent een file, voegt daar gegevens aan toe, en sluit deze  }
{ weer. Het resultaat wordt terug gegeven.                                 }
{                                                                          }
FUNCTION JamBase.SaveFile (FileName : STRING; VAR Buffer; Length : LONGINT) : WORD;

VAR TmpFile : FILE;

BEGIN
     Assign (TmpFile,FileName);
     {$I-}
     ReWrite (TmpFile,1);
     BlockWrite (TmpFile,Buffer,Length);
     Close (TmpFile);
     {$I+}
     SaveFile:=IOResult;
END;


{--------------------------------------------------------------------------}
{ Synchonize                                                               }
{                                                                          }
{ Zoekt in een file naar een bepaalde string, om zo eventuele goede        }
{ headers te vinden die niet goed doorverwerzen worden.                    }
{                                                                          }
FUNCTION JamBase.Synchronize (VAR Invoer : FILE; VAR ZoekString; Length : BYTE) : BOOLEAN;

VAR Teken,NextTeken : CHAR;
    SearchVar       : JAMBuf ABSOLUTE ZoekString;
    Teller          : BYTE;
    IORes           : BYTE;

BEGIN
     Synchronize:=FALSE;
     WHILE (NOT Eof (Invoer)) DO
     BEGIN
          {$I-} BlockRead (Invoer,Teken,1); {$I+} IORes:=IOResult;
          IF (IORes <> 0) THEN
          BEGIN
               LogDiskIOError (IORes,'[JAM] Error while synchonizing on header file in '+AreaName);
               Exit;
          END;

          IF (Teken = SearchVar[0]) THEN
          BEGIN
               FOR Teller:=1 TO (Length-1) DO
               BEGIN
                    {$I-} BlockRead (Invoer,Teken,1); {$I+} IORes:=IOResult;
                    IF (Teken <> SearchVar[Teller]) THEN
                       Break; { uit de for }
               END; { for }

               IF (Teller = (Length-1)) THEN
               BEGIN
                    Seek (Invoer,FilePos (Invoer)-Length);
                    Synchronize:=TRUE;
                    Exit;
               END;
          END; { if }
     END; { while }
END;


{ ------------------------------------------------------------------------ }
{ JAM LINK ROUTINE                                                         }
{                                                                          }
{ Jam gebruikt een uitgebreide link routine, dat het mogenlijk maakt om    }
{ meerdere reply's op een bericht te geven.                                }
{ Omdat een Jam base in principe ongelimiteerd is, moeten we gebruik       }
{ maken van een tijdelijke file op disk, als er meer dan 2700 berichten    }
{ in een gebied staan, of als we weinig geheugen meer hebben.              }

TYPE ReplyRecord = RECORD
                         xOffSet,
                         xMsgID,
                         xReplyID,
                         xReplyTo,
                         xReply1,
                         xReply2   : LONGINT;
                   END;

FUNCTION JamBase.LinkArea (AreaData : AreaBaseRecord) : BOOLEAN;
BEGIN
     LinkArea:=FALSE; { not aborted }

     { Probeer de database te openen }
     IF (NOT OpenBase (FALSE,AreaData.AreaName_F,AreaData.FidoMsgPath)) THEN
     BEGIN
          LogMessage ('[JAMLink] Unable to open '+AreaName);
          Exit;
     END;

     { RWI 950901: iets bijgeschaafd. De memlink routine vraagt namelijk }
     {             65300 bytes aan, dus de controle is niet veilig.      }
     {             64000 verandert in 66000.                             }
     IF (MaxAvail < 66000) OR (Jam_JHR_Header.ActiveMsgs > 2700) THEN
        LinkArea:=DiskLinkArea (AreaData)
     ELSE
         LinkArea:=MemLinkArea (AreaData);

     CloseBase;
END;


{--------------------------------------------------------------------------}
{ JamBase.DiskLinkArea                                                     }
{                                                                          }
FUNCTION JamBase.DiskLinkArea (AreaData : AreaBaseRecord) : BOOLEAN;

VAR TmpFile   : FILE;
    ReadEntry,
    FoundItem : ReplyRecord;
    Res,
    Pos       : LONGINT;
    IORes     : BYTE;

    { Zoek door de lijst naar een MsgId dat klopt, tegelijkertijd ook }
    { op zoek naar een ReplyId ... scheelt een loop door de file.     }

    FUNCTION FindItem (MsgId : LONGINT; VAR Found : ReplyRecord; VAR Pos : LONGINT) : WORD;

    VAR Temp : ReplyRecord;
        Flag : LONGINT;

    BEGIN
         Flag:=-1;
         FindItem := 0 {False};
         Seek (TmpFile,0);

         WHILE (NOT Eof (TmpFile)) DO
         BEGIN
              Pos:=FilePos (TmpFile);
              BlockRead (TmpFile,Temp,SizeOf (ReplyRecord));

              IF (Temp.xMsgId = MsgId) THEN
              BEGIN
                   Found:=Temp;
                   FindItem:=1{=Found};
                   Exit;
              END;

              IF (Temp.xReplyID = MsgId) AND (Flag = -1) THEN
              BEGIN
                   FindItem:=2; { Found secondary }
                   Flag:=Pos;
                   Found:=Temp;
              END;
         END; { while }

         IF (Flag <> -1) THEN
            Pos:=Flag;
    END;

    FUNCTION ReadItem (Id : LONGINT; VAR Invoer : ReplyRecord; VAR Pos : LONGINT) : BOOLEAN;
    BEGIN
         IF (Id <> 0) THEN
         BEGIN
              ReadItem:=TRUE;

              {$I-} Seek (TmpFile,0); {$I+}
              WHILE (NOT Eof (TmpFile)) DO
              BEGIN
                   Pos:=FilePos (TmpFile);
                   BlockRead (TmpFile,Invoer,SizeOf (Invoer));
                   IF (Invoer.xOffset = Id) THEN
                   BEGIN
                        Seek (TmpFile,Pos);
                        Exit;
                   END;
              END; { while }
         END;

         ReadItem:=FALSE;
    END;

    PROCEDURE SaveItem (P : LONGINT; Uitvoer : ReplyRecord);
    BEGIN
         IF (P <> FilePos (TmpFile)) THEN
            Seek (TmpFile,P);
         Blockwrite (TmpFile,Uitvoer,SizeOf (Uitvoer));
    END;

{ DiskLinkArea }

LABEL Verder,AbortHere;

VAR Aborted : BOOLEAN;

BEGIN
     DiskLinkArea:=FALSE; { not aborted }

     { Vul het status window }
     WriteXY (SXb2,SYb+2,'JAM (Disk)');
     WriteXY (SXb2,SYb+6,'Scanning');

     { Doorloop de area bericht voor bericht }
     IF (NOT GetFirstMessage) THEN
     BEGIN
          CloseBase; { RWI 960828 }
          Exit;
     END;

     Assign (TmpFile,'JAMLINK.$$$');
     {$I-} ReWrite (TmpFile,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[JamDiskLink] Unable to open tempory file');
          Exit;
     END;

     Status.DezeArea:=0;
     Status.DezeToDo:=0;
     Aborted:=FALSE;

     REPEAT
           IF (NOT ReadHeaderEntry) THEN
           BEGIN
                LogMessage ('[JamDiskLink] Error reading msg header for '+AreaName+
                            ' in msg '+Word2String (Currentmessage)+', possible index failure ?');
                { Einde area }
                CloseBase;
                Exit;
           END;

           { Vul een entry in om naar disk te schrijven }
           WITH ReadEntry DO
           BEGIN
                xOffSet:=Jam_Msg_Header.MsgNum;
                xMsgId:=JAM_Msg_Header.MsgIdCRC;
                xReplyID:=JAM_Msg_Header.ReplyCRC;
                xReplyto:=0;
                xReply1:=0;
                xReply2:=0;
           END;

           { Sla dit hele spulletje over als de de reply link toch niet bestaat }
           IF (Jam_Msg_Header.ReplyCRC = $FFFFFFFF) THEN
              GOTO Verder;

           { Zoek naar een entry op basis van de reply id }
           Res:=FindItem (ReadEntry.xReplyID,FoundItem,Pos);

           IF (Res = 0) THEN
              GOTO Verder;

           IF (Res = 1) THEN
           BEGIN
                { Kijk of het eerste reply link leeg is. Dit is zo als dit }
                { de eerst reply naar een bericht is.                      }
                IF (FoundItem.xReply1 = 0) THEN
                BEGIN
                     FoundItem.xReply1:=JAM_Msg_Header.MsgNum;
                     ReadEntry.xReplyTo:=FoundItem.xOffset;
                     SaveItem (Pos,FoundItem);
                     GOTO Verder;
                END;

                IF (FoundItem.xReply2 = 0) THEN
                BEGIN
                     FoundItem.xReply2:=JAM_Msg_Header.MsgNum;
                     ReadEntry.xReplyTo:=FoundItem.xOffset;
                     SaveItem (Pos,FoundItem);
                     GOTO Verder;
                END;
           END;

           IF (Res = 2) THEN
           BEGIN
                { Kijk of het eerste reply link leeg is }
                { Dit is zo als dit de eerst reply naar }
                { een bericht is.                       }
                IF (FoundItem.xReply1 = 0) THEN
                BEGIN
                     FoundItem.xReply1:=JAM_Msg_Header.MsgNum;
                     ReadEntry.xReplyTo:=FoundItem.xOffset;
                     SaveItem (Pos,FoundItem);
                     GOTO Verder;
                END;

                IF (FoundItem.xReply2 = 0) THEN
                BEGIN
                     FoundItem.xReply2:=JAM_Msg_Header.MsgNum;
                     ReadEntry.xReplyTo:=FoundItem.xOffset;
                     SaveItem (Pos,FoundItem );
                     GOTO Verder;
                END;
           END;

           REPEAT
                 { Kijk of de 2e link vrij is }
                 IF (FoundItem.xReply2 = 0) AND
                    (FoundItem.xReplyID = ReadEntry.xReplyID) AND
                    (FoundItem.xReplyID <> $FFFFFFFF) THEN
                 BEGIN
                      FoundItem.xReply2:=JAM_Msg_Header.MsgNum;
                      ReadEntry.xReplyTo:=FoundItem.xReplyto;
                      SaveItem (Pos,FoundItem);
                      Break; { uit de repeat }
                 END;

           UNTIL (NOT ReadItem (FoundItem.xReply2,FoundItem,Pos));

           Slice_Now;

           IF KeyPressed AND (ReadKey = kEsc) THEN
           BEGIN
                Aborted:=TRUE;
                Break;
           END;

Verder:
           SaveItem (FileSize (TmpFile),ReadEntry);
           Inc (Status.DezeToDo);
           UtilUpdateProgress;

     UNTIL (NOT GetNextMessage);

     IF Aborted THEN
        GOTO AbortHere;

     { ok, disk implementatie klaar .. nu voor de header update }
     WriteXY (SXb2,SYb+6,'Linking ');

     Seek (TmpFile,0);
     WHILE (NOT Eof (TmpFile)) DO
     BEGIN
          Inc (Status.DezeArea);

          {$I-} BlockRead (TmpFile,FoundItem,Sizeof (FoundItem)); {$I+}
          IORes:=IOResult; { RWI 960828: nodig! }

          { Het heeft alleen zin om een record te updaten als er werkelijk }
          { links gelegt kunnen worden.                                    }

          IF (FoundItem.xReplyTo = 0) AND
             (FoundItem.xReply1 = 0) AND
             (FoundItem.xReply2 = 0)
          THEN
              Continue;

          IF ((Status.DezeArea MOD 24) = 1) THEN
          BEGIN
               UtilUpdateProgress;

               Slice_Now;

               IF KeyPressed AND (ReadKey = kEsc) THEN
               BEGIN
                    Aborted:=TRUE;
                    Break;
               END;
          END;

          { ok, we komen er niet onderuit. Probeer links te leggen }
          IF FindByIndex (FoundItem.xOffset) THEN
          BEGIN
               { Lees de header in, verander deze .. en schrijf 'm weer weg }
               IF (NOT ReadHeaderEntry) THEN
               BEGIN
                    LogMessage ('[JamDiskLink] Error reading msg header for '+AreaName+' in msg '+
                                Word2string (Currentmessage)+', possible index failure ?');
                    { Einde area }
                    Exit;
               END;

               WITH Jam_Msg_Header DO
               BEGIN
                    ReplyTo:=FoundItem.xReplyTo;
                    Reply1st:=FoundItem.xReply1;
                    ReplyNext:=FoundItem.xReply2;
               END;

               {$I-}
               Seek (HdrFile,CurrentHeader);
               BlockWrite (HdrFile,Jam_MSG_Header,SizeOf (Jam_MSG_Header ));
               {$I+}
               IORes:=IOResult;

               IF (IORes <> 0) THEN
               BEGIN
                    LogDiskIOError (IORes,'[JamDiskLink] Error writing to header');
                    Exit;
               END;
          END; { if }
     END; { while }

AbortHere:

     {$I-}
     Close (TmpFile);
     Erase (TmpFile);
     {$I+}
     IORes:=IOResult;

     DiskLinkArea:=Aborted;
END;


{--------------------------------------------------------------------------}
{ JAM-Link in memory                                                       }
{                                                                          }
{ Als er minder dan 2700 berichten in een gebied staan, link dan gewoon in }
{ het geheugen.                                                            }
{                                                                          }
FUNCTION JamBase.MemLinkArea (AreaData : AreaBaseRecord) : BOOLEAN;

TYPE ReplyMem = ARRAY[1..1] OF ReplyRecord; { 24 bytes per record }

VAR TmpFile     : ^ReplyMem;
    ItemTeller,
    AantalItems : LONGINT;
    ReadEntry,
    FoundItem   : ReplyRecord;
    Res,
    Pos         : LONGINT;
    IORes       : BYTE;

    { Zoek door de lijst naar een MsgId dat klopt, tegelijkertijd ook }
    { op zoek naar een ReplyId ... scheelt een loop door de file.     }

    FUNCTION FindItem (MsgId : LONGINT; VAR Found : ReplyRecord; VAR Pos : LONGINT) : WORD;

    VAR Temp   : ReplyRecord;
        Flag,
        Teller : LONGINT;
        IORes  : BYTE;

    BEGIN
         Flag:=-1;
         FindItem:=0{=False};

         FOR Teller:=1 TO AantalItems DO
         BEGIN
              Pos:=Teller;
              Temp:=TmpFile^[Teller];

              IF (Temp.xMsgId = MsgId) THEN
              BEGIN
                   Found:=TmpFile^[Teller];
                   FIndItem:=1; {Found}
                   Exit;
              END;

              IF (Flag = -1) AND (Temp.xReplyID = MsgId) THEN
              BEGIN
                   FindItem:=2; { Found secondary }
                   Flag:=Pos;
                   Found:=TmpFile^[Teller];
              END;
         END; { for }

         IF (Flag <> -1) THEN
            Pos:=Flag;
    END;

    FUNCTION ReadItem (Id : LONGINT; VAR Invoer : ReplyRecord; VAR Pos : LONGINT) : BOOLEAN;

    VAR Teller : LONGINT;

    BEGIN
         IF (Id <> 0) THEN
         BEGIN
              ReadItem:=TRUE;

              FOR Teller:=1 TO AantalItems DO
              BEGIN
                   Pos:=Teller;
                   Invoer:=TmpFile^[Teller];
                   IF (Invoer.xOffset = Id) THEN
                      Exit;
              END; { for }
         END;

         ReadItem:=FALSE;
    END;


{MemLinkArea}

LABEL Verder,AbortHere;

VAR Aborted : BOOLEAN;

BEGIN
     MemLinkArea:=FALSE; { not aborted }

     { Vul het status window }
     WriteXY (SXb2,SYb+2,'JAM (Mem) ');
     WriteXY (SXb2,SYb+6,'Scanning');

     { doorloop de area bericht voor bericht }
     IF (NOT GetFirstMessage) THEN
     BEGIN
          CloseBase; { RWI 970127 }
          Exit;
     END;

     { vraag het geheugen aan voor de routine }
     GetMem (TmpFile,65300);
     AantalItems:=0;

     Status.DezeArea:=0;
     Status.DezeToDo:=0;
     Aborted:=FALSE;

     REPEAT
           IF (NOT ReadHeaderEntry) THEN
           BEGIN
                LogMessage ('[JamMemLink] Error reading message header for '+AreaName+' in msg '+
                            Word2String (Currentmessage)+', possible index failure ?');
                { einde area }
                CloseBase; { RIW 970127 }
                Exit;
           END;

           { Vul een entry in om naar disk te schrijven }
           WITH ReadEntry DO
           BEGIN
                xOffSet:=Jam_Msg_Header.MsgNum;
                xMsgId:=JAM_Msg_Header.MsgIdCRC;
                xReplyID:=JAM_Msg_Header.ReplyCRC;
                xReplyto:=0;
                xReply1:=0;
                xReply2:=0;
           END; { with }

           { sla dit hele spulletje over als de de reply link toch niet }
           { bestaat.                                                   }
           IF (Jam_Msg_Header.ReplyCRC = $FFFFFFFF) THEN
              GOTO Verder;

           { zoek naar een entry op basis van de reply id }
           Res:=FindItem (ReadEntry.xReplyID,FoundItem,Pos);

           IF (Res = 0) THEN
              GOTO Verder;

           IF (Res = 1) THEN
           BEGIN
                { Kijk of het eerste reply link leeg is Dit is zo als }
                { dit de eerst reply naar een bericht is.             }
                IF (FoundItem.xReply1 = 0) THEN
                BEGIN
                     FoundItem.xReply1:=JAM_Msg_Header.MsgNum;
                     ReadEntry.xReplyTo:=FoundItem.xOffset;
                     TmpFile^[Pos]:=FoundItem;
                     GOTO Verder;
                END;

                IF (FoundItem.xReply2 = 0) THEN
                BEGIN
                     FoundItem.xReply2:=JAM_Msg_Header.MsgNum;
                     ReadEntry.xReplyTo:=FoundItem.xOffset;
                     TmpFile^[Pos]:=FoundItem;
                     GOTO Verder;
                END;
           END; { res = 1 }

           IF (Res = 2) THEN
           BEGIN
                { kijk of het eerste reply link leeg is. Dit is zo als }
                { dit de eerst reply naar een bericht is.              }
                IF (FoundItem.xReply1 = 0) THEN
                BEGIN
                     FoundItem.xReply1:=JAM_Msg_Header.MsgNum;
                     ReadEntry.xReplyTo:=FoundItem.xOffset;
                     TmpFile^[Pos]:=FoundItem;
                     GOTO Verder;
                END;

                IF (FoundItem.xReply2 = 0) THEN
                BEGIN
                     FoundItem.xReply2:=JAM_Msg_Header.MsgNum;
                     ReadEntry.xReplyTo:=FoundItem.xOffset;
                     TmpFile^[Pos]:=FoundItem;
                     GOTO Verder;
                END;
           END; { res = 2 }

           REPEAT
                 { Kijk of de 2e link vrij is }
                 IF (FoundItem.xReply2 = 0) AND
                    (FoundItem.xReplyID = ReadEntry.xReplyID) AND
                    (FoundItem.xReplyID <> $FFFFFFFF) THEN
                 BEGIN
                      FoundItem.xReply2:=JAM_Msg_Header.MsgNum;
                      ReadEntry.xReplyTo:=FoundItem.xReplyto;
                      TmpFile^[Pos]:=FoundItem;
                      Break; { uit de while }
                 END;

           UNTIL (NOT ReadItem (FoundItem.xReply2,FoundItem,Pos));

           Slice_Now;

           IF KeyPressed AND (ReadKey = kEsc) THEN
           BEGIN
                Aborted:=TRUE;
                Break; { from the repeat/until }
           END;

Verder:
           Inc (AantalItems);
           TmpFile^[AantalItems]:=ReadEntry;

           Inc (Status.DezeToDo);
           UtilUpdateProgress;

     UNTIL (NOT GetNextMessage);

     IF Aborted THEN
        GOTO AbortHere;

     { ok, memory implementatie klaar .. nu voor de header update }
     WriteXY (SXb2,SYb+6,'Linking ');

     FOR ItemTeller:=1 TO AantalItems-1 DO
     BEGIN
          FoundItem:=TmpFile^[ItemTeller];

          Inc (Status.DezeArea);

          { Het heeft alleen zin om een record te updaten als er werkelijk }
          { links gelegt kunnen worden.                                    }

          IF (FoundItem.xReplyTo = 0) AND
             (FoundItem.xReply1 = 0) AND
             (FoundItem.xReply2 = 0)
          THEN
              Continue;

          IF ((Status.DezeArea MOD 24) = 1) THEN
          BEGIN
               UtilUpdateProgress;

               Slice_Now;

               IF KeyPressed AND (ReadKey = kEsc) THEN
               BEGIN
                    Aborted:=TRUE;
                    Break;
               END;
          END;

          { ok, we komen er niet onderuit. Probeer links te leggen }
          IF FindByIndex (FoundItem.xOffset) THEN
          BEGIN
               { Lees de header in, verander deze .. en schrijf 'm weer weg }
               IF (NOT ReadHeaderEntry) THEN
               BEGIN
                    LogMessage ('[JamMemLink] Error reading msg header for '+AreaName+' in msg '+
                                Word2String (Currentmessage)+', possible index failure?');
                    { Einde area }
                    CloseBase;
                    Exit;
               END;

               WITH Jam_Msg_Header DO
               BEGIN
                    ReplyTo:=FoundItem.xReplyTo;
                    Reply1st:=FoundItem.xReply1;
                    Replynext:=FoundItem.xReply2;
               END;

               {$I-}
               Seek (HdrFile,CurrentHeader);
               BlockWrite (HdrFile,Jam_MSG_Header,SizeOf (Jam_MSG_Header));
               {$I+}
               IORes:=IOResult;

               IF (IORes <> 0) THEN
               BEGIN
                    LogDiskIOError (IORes,'[JamMemLink] Error writing to header');
                    Exit;
               END;
          END; { if }
     END; { for }

AbortHere:

     FreeMem (TmpFile,65300);
     IORes:=IOResult;

     MemLinkArea:=Aborted;
END;


{---------------------------------------------------------------------------}
{ JamBase.RenumberArea                                                      }
{                                                                           }
{ Deze routine hernummert de berichten in de opgegeven areas en voert       }
{ daarna een re-index uit om te zorgen dat de indexen ook weer goed staan.  }
{ Omdat de re-index routine veel van het werk doet, hernummeren we hier     }
{ alleen de berichten.                                                      }
{                                                                           }
PROCEDURE JamBase.RenumberArea (VAR AreaRec : AreaBaseRecord);

VAR NextMsgNum : LONGINT;
    StorePos   : LONGINT;
    JLRFile    : FILE;
    IORes      : BYTE;
    LR         : JLRRecord;
    DoWrite    : BOOLEAN;
    NextEntry  : LONGINT;

LABEL GaVerder;

BEGIN
     { open de database }
     IF (NOT OpenBase (TRUE,AreaRec.AreaName_F,AreaRec.FidoMsgPath)) THEN
     BEGIN
          LogMessage ('[JamRenum] Unable to access '+AreaRec.AreaName_F);
          Exit;
     END;

     Assign (JLRFile,AreaRec.FidoMsgPath+EXT_LRDFILE);
     {$I-} Reset (JLRFile,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          IF (IORes = 2) THEN
          BEGIN
               { probeer de file aan te maken }
               LogMessage ('[RenumJAM] LastRead file does exist; creating '+AreaRec.FidoMsgPath+EXT_LRDFILE);

               {$I-} ReWrite (JLRFile,1); {$I+} IORes:=IOResult;
               IF (IORes <> 0) THEN
               BEGIN
                    LogDiskIOError (IORes,'[RenumJAM] Cannot create above mentioned file');
                    CloseBase;
                    Exit;
               END;
          END ELSE
          BEGIN
               LogDiskIOError (IORes,'[RenumJAM] Cannot open '+AreaRec.FidoMsgPath+EXT_LRDFILE);
               CloseBase;
               Exit;
          END;
     END;

     { zorg dat andere programma niet meer kunnen }
     IF (NOT LockBase) THEN
     BEGIN
          LogMessage ('[RenumJAM] Area locked tight ('+AreaName+'); renumber failed');
          CloseBase; { RWI 950121 }
          Exit;
     END;

     { overschrijf de indexfile }
     {$I-} ReWrite (IdxFile,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[RenumJAM] Unable to recreate index file for '+AreaName);
          CloseBase;
          Exit;
     END;

     NextMsgNum:=1; { nummer van eerste bericht }

     { zorg voor up-to-date informatie }
     ReadJAMHeader;
     IF (Jam_JHR_header.BaseMsgNum <> NextMsgNum) THEN
     BEGIN
          Jam_JHR_header.BaseMsgNum:=NextMsgNum; { 1-based }
          WriteJAMHeader; { seeked eerst weer naar 0 }
          { dus nu staan we weer op dezelfde plek als na de ReadJamHeader }
     END;

     Status.DezeToDo:=0; { unknown }
     Status.DezeArea:=0;

     WHILE (NOT Eof (HdrFile)) DO
     BEGIN
          StorePos:=FilePos (HdrFile);

          IF (NOT ReadHeaderEntry) THEN
          BEGIN
               { probeer het volgende intacte frame te vinden }
               IF (NOT Synchronize (HdrFile,HeaderSig,SizeOf (HeaderSig))) THEN
               BEGIN
                    LogMessage ('[JamRenum] Error synchronizing message header in '+AreaName+', aborting');
                    UnlockBase;
                    CloseBase;
                    Exit;
               END;

               Continue;
          END;

          { nieuwe msg nummer invullen }

          { RWI 950121: controle op deleted verwijderd }
          { RWI 970205: weer toegevoegd. Deleted berichten kregen ook }
          {             een nummer en dat leidde tot gaten!           }
          IF ((Jam_MSG_header.Attribute AND JMSG_DELETED) <> 0) THEN
             GOTO GaVerder;

          IF (Jam_MSG_header.MsgNum <> NextMsgNum) THEN
          BEGIN
               { zoek in de JLR file naar overeenkomsten }
               { en pas die dan ook aan.                 }
               Seek (JLRFile,0); { RWI 950317: was seek naar pos. 1 !!}

               WHILE (FilePos (JLRFile) < FileSize (JLRFile)) DO
               BEGIN
                    {$I-} BlockRead (JLRFile,LR,SizeOf (JLRRecord)); {$I+} IORes:=IOResult;

                    IF (IORes = 0) AND (LR.UserCRC <> $FFFFFFFF) AND (LR.UserID <> $FFFFFFFF) THEN
                    BEGIN
                         DoWrite:=FALSE;

                         IF (LR.LastReadMsg = Jam_MSG_header.MsgNum) THEN
                         BEGIN
                              LR.LastReadMsg:=NextMsgNum;
                              DoWrite:=TRUE;
                         END;

                         IF (LR.HighReadMsg = Jam_MSG_header.MsgNum) THEN
                         BEGIN
                              LR.HighReadMsg:=NextMsgNum;
                              DoWrite:=TRUE;
                         END;

                         IF DoWrite THEN
                         BEGIN
                              Seek (JLRFile,FilePos (JLRFile)-SizeOf (JLRRecord));
                              BlockWrite (JLRFile,LR,SizeOf (JLRRecord));
                         END;
                    END;
               END; { while }

               Jam_MSG_header.MsgNum:=NextMsgNum;

               { lekker lokaal met een eigen routine updaten... }
               Seek (HdrFile,JamMsgHeaderOffset);
               BlockWrite (HdrFile,Jam_MSG_Header,SizeOf (Jam_MSG_Header));
          END;

          Inc (NextMsgNum);

          { RWI 970205: we moeten de index ook updaten }

          { Als het bericht nummer groter is dan het vorige bericht nummer }
          { vul de header aan met lege records.                            }
          NextEntry:=(Jam_Msg_Header.MsgNum-Jam_JHR_header.BaseMsgNum)*SizeOf (JAMIDXREC);

          { voeg een index entry toe }
          IF (NOT WriteIndexEntry (ReadJAMSubField0003,JamMsgHeaderOffset)) THEN
             LogMessage ('[RenumJAM] Unable to append to index file '+AreaName);


     GaVerder:

          { subfields blok overslaan, klaar zetten voor volgende header }
          Seek (HdrFile,JamMsgHeaderOffset+SizeOf (Jam_MSG_Header)+Jam_MSG_Header.SubFieldLen);

          Inc (Status.DezeArea);
          IF ((Status.DezeArea MOD 24) = 1) THEN
          BEGIN
               UtilUpdateProgress;
               Slice_Now;
          END;

     END; { while }

     { controleer of de JLRfile illegale pointers bevat. Zoja, reset ze dan }

     Dec (NextMsgNum); { bevat nu het laatste msg nummer }

     Seek (JLRFile,0);
     WHILE (FilePos (JLRFile) < FileSize (JLRFile)) DO
     BEGIN
          Slice_Now;

          {$I-} BlockRead (JLRFile,LR,SizeOf (JLRRecord)); {$I+} IORes:=IOResult;

          IF (IORes = 0) AND (LR.UserCRC <> $FFFFFFFF) AND (LR.UserID <> $FFFFFFFF) THEN
          BEGIN
               DoWrite:=FALSE;

               IF ((NextMsgNum > 0) AND (LR.LastReadMsg > NextMsgNum)) THEN
               BEGIN
                    LogMessage ('[RenumJAM] Bad LASTread in JLR @'+
                                Longint2String (FilePos (JLRFile)-SizeOf (JLRRecord))+':'+
                                Longint2String (LR.LastReadMsg)+'), resetting to 1 ('+AreaName+')');

                    LR.LastReadMsg:=1;
                    DoWrite:=TRUE;
               END;

               IF ((NextMsgNum > 0) AND (LR.HighReadMsg > NextMsgNum)) THEN
               BEGIN
                    LogMessage ('[RenumJAM] Bad HIGHread in JLR @'+
                                Longint2String (FilePos (JLRFile)-SizeOf (JLRRecord))+':'+
                                Longint2String (LR.HighReadMsg)+'), resetting to 1 ('+AreaName+')');

                    LR.HighReadMsg:=1;
                    DoWrite:=TRUE;
               END;

               IF DoWrite THEN
               BEGIN
                    Seek (JLRFile,FilePos (JLRFile)-SizeOf (JLRRecord));
                    BlockWrite (JLRFile,LR,SizeOf (JLRRecord));
               END;
          END;

     END; { while }

     { sluit de JLR base }
     Close (JLRFile);

     { geef de base weer vrij voor gebruik }
     UnlockBase;
     CloseBase;
END;


{--------------------------------------------------------------------------}
{ Unit Initialization                                                      }
{                                                                          }
BEGIN
     JamMsgBase.InitBase;
END.

