UNIT Globals;

{ Globale routines voor Wtr*.* }

{ History:

RvdW 20-02-93 Deze unit afgeplitst uit wtrconf.pas
     02-04-93 Beta teken vervangen door de tekst "beta"
MD   11-07-93 Maand + Datum strings hier onder gebracht.
     08-09-93 $IFDEF WtrConf toegevoegd
     11-09-93 Globals voor de OBJECT bases hier toevoegen
     09-10-93 Fix in datum formaat Okt -> Oct
     03-12-93 PackedMem type toegevoegt om Frontdoor File Attaches by
              te houden
     05-03-94 Fix in datum formaat

RvdW 23-10-94 DeleteCTFBS gemaakt: DeleteCommentTabsFrontAndBackSpaces
}

{$IFNDEF DPMI}
{$IFNDEF OS2}
{(not)$DEFINE DebugMemUsage}
{$ENDIF}
{$ENDIF}

{(not)$DEFINE DoPeekFiles}

INTERFACE

USES Ramon,
     Dos,
     Database,
     PackMem;

      {EnterMsg : STRING[25] = '<press enter to see list>';}
CONST DotDotDot : STRING[3] = '...';


      Month : ARRAY[1..12] OF STRING[3] = ('Jan','Feb','Mar',
                                           'Apr','May','Jun',
                                           'Jul','Aug','Sep',
                                           'Oct','Nov','Dec');
      Day : ARRAY[0..6] OF STRING[3]  = ('Sun','Mon','Tue',
                                         'Wed','Thu','Fri','Sat');

      fmReadOnly  = 0;          {FileMode constants}
      fmWriteOnly = 1;
      fmReadWrite = 2;
      fmDenyAll   = 16;
      fmDenyWrite = 32;
      fmDenyRead  = 48;
      fmDenyNone  = 64;
      fmNoInherit = 128;

      MEMUSEFOR = 'Memory usage for ';

      CopyrightLine = '(c) 1993-2000 Ramon van der Winkel';

      DesktopProgramName    : STRING[12] = 'WaterGate'{$IFDEF OS2}+'/2'{$ENDIF};
      ProgramShortName      : STRING[9]  = 'WtrGate'{$IFDEF OS2}+'/2'{$ENDIF};
      ProgramUserName       : STRING[9]  = 'wtrgate';

      MainVersionNr         = '1.00';
      MainRevisionNr        = MainVersionNr{+'.p1'};

      FullProgramVersion    : STRING[20] = MainRevisionNr
                             {$IFDEF DPMI} +'-d'     {$ENDIF}
                           {$IFDEF USEOVR} +'-o'     {$ENDIF}
                             {$IFDEF ALFA} +' ALPHA' {$ENDIF}
                             {$IFDEF BETA} +' beta'  {$ENDIF}
                            {$IFDEF GAMMA} +' gamma' {$ENDIF}
                                           ;

      { PID regel: ^APID <pid> <version> <serial> }
      {            ^APID WaterGate 0.92/b sn48 }
      ProgramPID            : STRING[30] = 'WaterGate '
                                           +MainVersionNr
                             {$IFDEF ALFA} +'/a'    {$ENDIF}
                             {$IFDEF BETA} +'/b'    {$ENDIF}
                            {$IFDEF GAMMA} +'/g'    {$ENDIF}
                                           ;


      { version history:

      1.00               000226
      0.93.p9            991229
      0.93.p8            981213
      0.93.p7            981006
      0.93.p6            980623
      0.93.p5            980315
      0.93.p4            971206
      0.93.p3            971116
      0.93.p2            971011
      0.93.p1            970910
      0.93               970706
      0.93.PRE14.p1      970629
      0.93.PRE14         970617
      0.93.PRE13.p4      970608 (OS2)
      0.93.PRE13.p3      970531
      0.93.PRE13.p2      970528
      0.93.PRE13.p1      970519
      0.93.PRE13         970511
      0.93.PRE12.p4      970510  (Guus only: Squish fixes)
      0.93.PRE12.p3      9705
      0.93.PRE12.p2      97
      0.93.PRE12.p1      97
      0.93.PRE12         970415
      0.93.PRE11.p2      970410
      0.93.PRE11.p1      970409
      0.93.PRE11         970408
      0.93.PRE10.p3      970406  (Francois only: BBS Interface)
      0.93.PRE10.p2      970405  (Francois only: BBS Interface)
      0.93.PRE10.p1      970329
      0.93.PRE10         970323
      0.93.PRE9          970228
      0.93.PRE8          970219
      0.93.PRE7          970215
      0.93.PRE6          970130
      0.93.PRE5          970126
      0.93.PRE4          970116
      0.93.PRE3          970112
      0.93.PRE2          970101
      0.93.PRE1          9612   (started 961208)
      0.93.PRE0 /2       961130
      0.92 alfa /2       961126
      0.92 gamma         961012
      0.92.PRE12 beta    9610??
      0.92.PRE11 beta    9610??
      0.92.PRE10 beta    960922
      0.92.PRE9 beta     960921 WtrTest
      0.92.PRE8 beta     960916
      0.92.PRE7 beta     960906 Overlay files
      0.92.PRE6 beta     960905
      0.92.PRE5 beta     9608??
      0.92.PRE4 beta     960824
      0.92.PRE3 beta     960821
      0.92.PRE2 beta     960819
      0.92.PRE1 beta     960719
      0.91.p1 beta       960
      0.91 beta          960530
      0.90.p10 beta      960505
      0.90.p9 beta       960419 (zegt nog steeds "p8" ;-( ;-( ;-( !!)
      0.90.p8 beta       960408?
      0.90.p7 beta       960324
      0.90.p6 beta       960315 (should have called it alpha.. ;)
      0.90.p5 beta       960313
      0.90.p4 beta       960310
      0.90.p3 cl. beta   9602.. Frans, Christian, Guus
      0.90.p2+ cl. beta  960225
      0.90.p2 cl. beta   960225
      0.90.p1+ cl. beta  960223 Rob Szarka + John Mudge
      0.90.p1 beta       960219
      0.90 beta          960214
      0.22 PRE1 beta     960209 (0.22 = 0.90)
      0.21.p4 beta       960115
      0.21.p3 beta       960113
      0.21.p2 beta       951231
      0.21.p1 beta       951217
      0.21 beta          951203
      0.21 PRE3          951130  voor Giovanni
      0.21.PRE2          951117  voor Giovanni
      0.21.PRE           951110  voor Giovanni
      0.20.p1 beta
      0.20 beta          951103
      0.19.p3 beta       951005  *.msg export loop wanneer geen header lines
      0.19.p2 beta       9509__
      0.19.p1 beta       950910  grote mails export problem
      0.19 beta          950903
      0.19.PRE3 beta     950827
      0.19.PRE2 beta     950816
      0.19.PRE beta      950810
      0.18.0629.p2 beta  950722
      0.18.0629.p1 beta  950721  distributie via mailing list
      0.18.0629 beta
      0.17.0606.p3 beta
      0.17.0606.p2 beta  950621: fixed read-only area problem
      0.17.0606.p1 beta  950612: fixed JAM problem
      0.17.0606 beta
      0.16.0327 beta
      0.15.0220.p5 beta  the usual...
      0.15.0220.p4 beta  voor joop (again... :-( )
      0.15.0220.p3 beta  terug van joop, wijzigingen verwerken
      0.15.0220.p2 beta  debuggen bij joop
      0.15.0220.p1 beta  Toen ik naar joop ging
      0.15.0220 beta
      twee patched versies van wtrgate.exe -> rene vreeman
      0.14.0302 beta
      vier patches
      0.13.1214 beta     Snelle opvolger ivm geen CR tussen tear en origin
      0.12.1128 beta
      0.11.1030 beta

      (RWI takeover)

      0.10.0816 beta
      0.10.0428 beta
      0.05.2002 beta
      others (?)

      }

TYPE PathString     = STRING[79];
     FilenameString = STRING[12];

VAR GroupListDesc    : STRING[54];
    LowestMemReached : LONGINT;

    ConditionRed     : BYTE;
    GlobalAbort      : BOOLEAN;

    FrontDoorAttach  : PackedBoolMem;

    regKeyDate       : LONGINT;
    regKeyNumber     : WORD;
    regUserName      : STRING[49];
    regOrganization  : STRING[49];

    ForceNoNet       : BOOLEAN;
    ForceNoEcho      : BOOLEAN;
    ForceNoRoute     : BOOLEAN;
    ForceNoImport    : BOOLEAN;
    ForceNoExport    : BOOLEAN;
    ForceNoNewsToss  : BOOLEAN;
    ForceNoFAKill    : BOOLEAN;
    ForceNoNewScan   : BOOLEAN;
    ForceCleanScan   : BOOLEAN;
    ForceNoTunnel    : BOOLEAN;

    DebugMem         : BOOLEAN;
    GoSetFMRescan    : BOOLEAN;
    GoSetFDRescan    : BOOLEAN;

    TempPath         : PathStr;

PROCEDURE WriteMenuKeysLine;
FUNCTION  CopyFromFile (VAR Source,Dest : FILE; StartPos, NumBytes : LongInt ) : Boolean;
PROCEDURE WriteFieldEditDirectKeysLine;
FUNCTION  BuildGroupDesc (Lp : GroupNrType; VAR GroupData : GroupDescRecord) : STRING;
PROCEDURE EditGroupsList (VAR Groups : GroupFlagType; Msg1,Msg2 : STRING; Help1,Help2 : HelpHandleType);
PROCEDURE EditFidoAddr (VAR Address : FidoAddrType; Help : HelpHandleType);
FUNCTION  AreYouSureWithHelp (Title : STRING; Handle : HelpHandleType) : KeyType;
FUNCTION  AreYouSure (Title : STRING) : KeyType;
PROCEDURE PeekMem;
PROCEDURE DumpMem;
PROCEDURE PeekFiles;
FUNCTION  ReplaceExtension (Source : STRING; NewExt : STRING) : STRING;
FUNCTION  RenameSerial (Source : STRING; VAR Destination : STRING): BOOLEAN;
FUNCTION  AtoI (Invoer : STRING; VAR Uitvoer : WORD) : BYTE;
FUNCTION  Micro2Longint (Invoer : LONGINT) : LONGINT;
FUNCTION  Longint2Micro (Invoer : LONGINT) : LONGINT;
FUNCTION  DeleteCTFBS (Tekst : STRING) : STRING;
FUNCTION  CalcMaxAllowedMem (VAR Allowed : WORD; AtLeast,AtMost : WORD) : BOOLEAN;

{$IFNDEF OS2}
PROCEDURE FindClose (VAR Search : SearchRec);
{$ENDIF}


IMPLEMENTATION

USES Logs,
     Fido,
     Msgs,
     Cfg,
     Err_func;

{--------------------------------------------------------------------------}
{ WriteFieldEditDirectKeysLine                                             }
{                                                                          }
{ Deze routine drukt de keysline af voor de FieldEditDirect routine.       }
{                                                                          }
PROCEDURE WriteFieldEditDirectKeysLine;
BEGIN
     WriteKeysLine (' ^Esc abort  ^Enter accept  ^Ctrl-End clear rest of field');
END;


{--------------------------------------------------------------------------}
{ WriteMenuKeysLine                                                        }
{                                                                          }
{ Deze routine drukt de keysline af voor de menus.                         }
{                                                                          }
PROCEDURE WriteMenuKeysLine;
BEGIN
     WriteKeysLine (' ^Esc return  ^'#24#25' position  ^Enter select');
END;


{--------------------------------------------------------------------------}
{ BuildGroupDesc                                                           }
{                                                                          }
FUNCTION BuildGroupDesc (Lp : GroupNrType; VAR GroupData : GroupDescRecord) : STRING;

CONST ReadOnlyStrs : ARRAY[FALSE..TRUE] OF STRING[11] = ('','[READ-ONLY]');

BEGIN
     BuildGroupDesc:=BuildSingleGroupDesc (Lp)+': '+
                     AddUpWithSpaces (30,GroupData.GroupDesc)+' '+
                     Fido2Str (Config.NodeNrs[GroupData.OriginAka])+' '+
                     ReadOnlyStrs[GroupData.ReadOnly];
END;


{--------------------------------------------------------------------------}
{ EditGroupsList                                                           }
{                                                                          }
{ Deze routine kan voor zowel UserData als AreaData gebruikt worden om het }
{ groups veld aan te passen. Msg1 komt boven de lijst waar de user/area    }
{ lid van is, dan andere in de diezelfde lijst als er geen groups in       }
{ zitten.                                                                  }
{                                                                          }
PROCEDURE EditGroupsList (VAR Groups : GroupFlagType; Msg1,Msg2 : STRING; Help1,Help2 : HelpHandleType);

CONST GroupKeysLine = ' ^Esc Abort  ^Ins Add group  ^Del Delete group ^F5 (Un)tag';

VAR Quit,Quit2,
    First,
    RebuildList : BOOLEAN;
    GroupData   : GroupDescRecord;
    Lp,Keuze    : WORD;

BEGIN
     ListDefine (3,3,Video.Cols-10,Video.Rows-4,Default,Msg1,Help1);

     FOR Lp:=1 TO MaxGroups DO
         IF TestIfInGroup (Groups,Lp) THEN
         BEGIN
              ReadGroupDescRecord (Lp,GroupData);
              ListAddItem (BuildGroupDesc (Lp,GroupData),Lp,Sorted);
         END;

     Quit:=FALSE;
     REPEAT
           ListTagKeysLine:=GroupKeysLine;

           IF (ListItemCount = 0) THEN
           BEGIN
                ListAddItem (Msg2,65534,Bottom);
                Keuze:=ListSelect (DoTag,[kIns]);
           END ELSE
               Keuze:=ListSelect (DoTag,[kIns,kDel]);

           ListTagKeysLine:=ORG_ListTagKeysLine;

           ListRemoveItem (65534);

           CASE Key OF
                kIns : BEGIN
                            ListDefine (78,3,Video.Cols-10,Video.Rows-4,TopRight,'Other groups',Help2);
                            FOR Lp:=1 TO MaxGroups DO
                                IF (NOT TestIfInGroup (Groups,Lp)) THEN
                                BEGIN
                                     ReadGroupDescRecord (Lp,GroupData);
                                     ListAddItem (BuildGroupDesc (Lp,GroupData),Lp,Bottom);
                                END;

                            IF (ListItemCount = 0) THEN
                               ListAddItem ('<no other groups>',65534,Bottom);

                            Quit2:=FALSE;
                            REPEAT
                                  Keuze:=ListSelect (DoTag,[]);

                                  CASE Key OF
                                       kEsc : Quit2:=TRUE;

                                       kRet : BEGIN
                                                   IF (ListTagCount = 0) THEN
                                                   BEGIN
                                                        AddGroupToGroupList (Groups,Keuze);
                                                        ListAddItemToPrevList (ListGetItemTekst (Keuze),Keuze,Sorted);
                                                   END ELSE
                                                       WHILE (ListTagCount > 0) DO
                                                       BEGIN
                                                            Keuze:=ListGetTaggedItemNr (1);
                                                            AddGroupToGroupList (Groups,Keuze);
                                                            ListAddItemToPrevList (ListGetItemTekst (Keuze),Keuze,Sorted);
                                                            ListRemoveItem (Keuze);
                                                       END;

                                                   Quit2:=TRUE;
                                              END; { kRet }
                                  END; { case }
                            UNTIL Quit2;

                            ListErase;
                       END; { kIns }

                kDel : BEGIN
                            IF (ListTagCount = 0) THEN
                            BEGIN
                                 DeleteGroupFromGroupList (Groups,Keuze);
                                 ListRemoveItem (Keuze);
                            END ELSE
                                WHILE (ListTagCount > 0) DO
                                BEGIN
                                     Keuze:=ListGetTaggedItemNr (1);
                                     DeleteGroupFromGroupList (Groups,Keuze);
                                     ListRemoveItem (Keuze);
                                END;

                       END; { kDel }

                kEsc : Quit:=TRUE;
           END;
     UNTIL Quit;

     ListErase;

     GroupListDesc:=AddUpWithSpaces (54,BuildGroupListDesc (Groups,54));
END;


{--------------------------------------------------------------------------}
{ EditFidoAddr                                                             }
{                                                                          }
{ Dit is een universele routine om een Fidonet Addr type te editten.       }
{                                                                          }
PROCEDURE EditFidoAddr (VAR Address : FidoAddrType; Help : HelpHandleType);

CONST Xb = 20;
      Yb = 7;
      Xl = 40;
      Yl = 7;

VAR ZoneStr,
    NetStr,
    NodeStr,
    PointStr  : STRING[5];
    DomainStr : STRING[MaxLenFidoAddrString-23];
    Nop       : ValNop;
    Temp      : WORD;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     WITH Address DO
     BEGIN
          Str (Zone,ZoneStr);
          ZoneStr:=AddUpWithSpaces (5,ZoneStr);

          Str (Net,NetStr);
          NetStr:=AddUpWithSpaces (5,NetStr);

          Str (Node,NodeStr);
          NodeStr:=AddUpWithSpaces (5,NodeStr);

          Str (Point,PointStr);
          PointStr:=AddUpWithSpaces (5,PointStr);

          DomainStr:=AddUpWithSpaces (MaxLenFidoAddrString-23,Domain);
     END;

     WriteXY (Xb+2,Yb+1,'Zone');
     FieldDefineOne (1,Xb+9,Yb+1,5,5,2,@ZoneStr,RepChar (5,'%'));
     FieldSetHelp (1,Help);

     WriteXY (Xb+2,Yb+2,'Net');
     FieldDefineOne (2,Xb+9,Yb+2,5,1,3,@NetStr,RepChar (5,'%'));
     FieldSetHelp (2,Help);

     WriteXY (Xb+2,Yb+3,'Node');
     FieldDefineOne (3,Xb+9,Yb+3,5,2,4,@NodeStr,RepChar (5,'%'));
     FieldSetHelp (3,Help);

     WriteXY (Xb+2,Yb+4,'Point');
     FieldDefineOne (4,Xb+9,Yb+4,5,3,5,@PointStr,RepChar (5,'%'));
     FieldSetHelp (4,Help);

     WriteXY (Xb+2,Yb+5,'Domain');
     FieldDefineOne (5,Xb+9,Yb+5,MaxLenFidoAddrString-23,4,1,@DomainStr,RepChar (MaxLenFidoAddrString-23,'$'));
     FieldSetHelp (5,Help);

     FieldEdit;

     WITH Address DO
     BEGIN
          Val (DeleteBackSpaces (ZoneStr),Temp,Nop);
          IF (Nop = 0) THEN Zone:=Temp;

          Val (DeleteBackSpaces (NetStr),Temp,Nop);
          IF (Nop = 0) THEN Net:=Temp;

          Val (DeleteBackSpaces (NodeStr),Temp,Nop);
          IF (Nop = 0) THEN Node:=Temp;

          Val (DeleteBackSpaces (PointStr),Temp,Nop);
          IF (Nop = 0) THEN Point:=Temp;

          Domain:=DeleteBackSpaces (DomainStr);
     END;

     FieldPopAll;
     WindowPop; { adres edit scherm }
END;


{--------------------------------------------------------------------------}
{ AreYouSure(WithHelp)                                                     }
{                                                                          }
{ Deze routine zet een vraag op het scherm waar met Yes of No op           }
{ geantwoord moet worden, Escape werkt niet.
{                                                                          }
FUNCTION AreYouSureWithHelp (Title : STRING; Handle : HelpHandleType) : KeyType;

VAR X : BYTE;

BEGIN
     X:=40-(Length (Title) DIV 2);
     MenuDefine (X,10,Title);
     MenuSetHelp (Handle);
     MenuAddItem ('Yes');
     MenuAddItem ('No');
     MenuShow;

     REPEAT
     UNTIL (MenuSelect IN [mOpt01,mOpt02,kEsc]);

     MenuErase;

     AreYouSureWithHelp:=Key;
END;

FUNCTION AreYouSure (Title : STRING) : KeyType;
BEGIN
     AreYouSure:=AreYouSureWithHelp (Title,0);
END;


{---------------------------------------------------------------------------}
{ PeekMem                                                                   }
{                                                                           }
{ Deze routine drukt de hoeveelheid vrij geheugen af in de linker bovenhoek }
{ van het scherm.                                                           }
{                                                                           }
PROCEDURE PeekMem;
{$IFDEF DebugMemUsage}
TYPE HeapRecPtr = ^HeapRec;
     HeapRec = RECORD
                     NextPtr : HeapRecPtr;
                     N : LONGINT;
               END;

VAR Frags : WORD;
    HPtr  : HeapRecPtr;
{$ENDIF}
BEGIN
     {$IFDEF DebugMemUsage}
     Frags:=0;
     HPtr:=FreeList;
     WHILE (HPtr <> HeapPtr) DO
     BEGIN
          Inc (Frags);
          HPtr:=HPtr^.NextPtr;
     END;
     {$ENDIF}

     IF (MemAvail < LowestMemReached) THEN
        LowestMemReached:=MemAvail;

     {$IFDEF DebugMemUsage}
     IF (OldVideoMode <> 0) THEN
        WriteXY (60,2,' '+Longint2String (LowestMemReached)+' '+Longint2String (MemAvail)+' '+Word2String (Frags)+' ');
     {$ENDIF}
END;


{--------------------------------------------------------------------------}
{ DumpMem                                                                  }
{                                                                          }
{ Deze routine schrijft de geheugen blokken naar disk.                     }
{                                                                          }
PROCEDURE DumpMem;

    FUNCTION Ptr2Long (X : POINTER) : LONGINT;
    BEGIN
         Ptr2Long:=(Longint (X) SHR 12)+Word (X);
    END;

TYPE HeapRecPtr = ^HeapRec;
     HeapRec = RECORD
                     NextPtr : HeapRecPtr;
                     M,N     : WORD;
               END;

VAR Frags : WORD;
    HPtr  : HeapRecPtr;
    Start : LONGINT;

    EOB,
    Last  : LONGINT;

BEGIN
{$IFNDEF DPMI}
{$IFNDEF OS2}

     {
     GetMem (HPtr,16);
     LogMessage ('GetMem (16) returns '+Ptr2HexString (HPtr));
     GetMem (HPtr,16);
     LogMessage ('GetMem (16) returns '+Ptr2HexString (HPtr));
     }

     {
     LogExtraMessage ('MemAvail = '+Longint2String (MemAvail));
     LogExtraMessage ('MaxAvail = '+Longint2String (MaxAvail));
     }

     Start:=Ptr2Long (HeapOrg);

     {
     LogExtraMessage ('HeapEnd = '+Long2HexString (Ptr2Long (HeapEnd)));
     }

     Last:=0;

     HPtr:=FreeList;

     IF (HPtr <> HeapPtr) THEN
     BEGIN
          LogMessage ('Memory dump:');
          LogExtraMessage ('HeapOrg = '+Long2HexString (Ptr2Long (HeapOrg)));
          LogExtraMessage ('HeapPtr = '+Long2HexString (Ptr2Long (HeapPtr))+
                           ' (+$'+Long2HexString (Ptr2Long (HeapPtr)-Start)+')');
     END;

     WHILE (HPtr <> HeapPtr) DO
     BEGIN
          IF (HPtr <> HeapOrg) THEN
          BEGIN
               EOB:=Ptr2Long (HPtr)-Start-1;

               LogExtraMessage ('Not returned: +$'+Long2HexString (Last)+
                                '..+$'+Long2HexString (EOB)+
                                ' ('+Longint2String (EOB-Last+1)+')');
          END;

          Last:=Ptr2Long (HPtr)-Start+(HPtr^.N*16+HPtr^.M);

          LogExtraMessage ('Free block at +$'+Long2HexString (Ptr2Long (HPtr)-Start)+
                           '..+$'+Long2HexString (Ptr2Long (HPtr)-Start+(HPtr^.N*16+HPtr^.M)-1));

          HPtr:=HPtr^.NextPtr;
     END;

     LogClose;
{$ENDIF}
{$ENDIF}
END;


{$IFDEF DoPeekFiles}
 {$IFNDEF WtrGate}
 {$UNDEF DoPeekFiles}
 {$ENDIF}

 {$IFDEF DPMI}
 {$UNDEF DoPeekFiles}
 {$ENDIF}

 {$IFDEF OS2}
 {$UNDEF DoPeekFiles}
 {$ENDIF}
{$ENDIF}

{$IFDEF DoPeekFiles}
FUNCTION GetOpenFilesCount (VAR TabSize : BYTE) : BYTE;

TYPE TabArrayPtr = ^TabArray;
     TabArray = ARRAY[1..256] OF BYTE;

VAR TabPtr    : TabArrayPtr;
    OpenCount,
    FreeCount,
    Lp        : BYTE;

BEGIN
     TabSize:=Mem[PrefixSeg:$32];
     TabPtr:=TabArrayPtr (MemL[PrefixSeg:$34]);

     OpenCount:=0;

     FOR Lp:=1 TO TabSize DO
     BEGIN
          {
          IF (TabPtr^[Lp] = 255) THEN
             Inc (FreeCount)
          ELSE
              Inc (OpenCount);
          }
          IF (TabPtr^[Lp] <> 255) THEN
             Inc (OpenCount);
     END;

     GetOpenFilesCount:=OpenCount;
END;
{$ENDIF}

{---------------------------------------------------------------------------}
{ PeekFiles                                                                 }
{                                                                           }
{ Deze routine bepaald hoeveel files er open zijn en hoeveel nog vrij en    }
{ zet dat in de linker bovenhoek van het scherm.                            }
{                                                                           }
PROCEDURE PeekFiles;
{$IFDEF DoPeekFiles}

VAR TabSize : BYTE;

BEGIN
     { alleen schrijven als de desktop open is }
     IF (DesktopCopyright = 'WSD') THEN
        SneakWrite (40,1,'O:'+Byte2String (GetOpenFilesCount (TabSize))+'/'+Byte2String (TabSize)+' ');
{$ELSE}
BEGIN
{$ENDIF}
END;


{--------------------------------------------------------------------------}
{ AtoI                                                                     }
{                                                                          }
{ Converteerd een string naar integer, totaan het teken dat geen numeriek  }
{ getal meer is. De functie geeft ook de lengte (in tekens) van het getal  }
{ terug.                                                                   }
{                                                                          }
FUNCTION AtoI (Invoer : STRING; VAR Uitvoer : WORD) : BYTE;

VAR LocalStr : STRING;
    Lp       : INTEGER;
    Nop      : ValNop;

BEGIN
     LocalStr:='';
     FOR Lp:=1 TO Length (Invoer) DO
         IF (Invoer[Lp] IN ['0'..'9']) THEN
            LocalStr:=LocalStr+Invoer[Lp]
         ELSE
             Break;

     Val (LocalStr,Uitvoer,Nop);
     AtoI:=Length (LocalStr);
END;


{---------------------------------------------------------------------------}
{ CopyFromFile                                                              }
{                                                                           }
{ Copieerd een stuk van een bestand naar het einde van het doelbestand.     }
{ De routine gaat ervanuit dat zowel bron als doel bestand open zijn.       }
{                                                                           }
FUNCTION CopyFromFile (VAR Source,Dest : FILE; StartPos, NumBytes : LONGINT) : BOOLEAN;

TYPE MemBlock = ARRAY[1..65000] OF BYTE;

VAR Block   : ^MemBlock;
    ToDo    : LONGINT;
    IORes   : WORD;
    BufSize : WORD;

BEGIN
     CopyFromFile:=TRUE;

     { Alloceer een 16Kb geheugen blok , toch wel het minimum om te kunnen }
     { opereren.                                                           }

     IF (MaxAvail < 65000) THEN
        BufSize:=MaxAvail
     ELSE
         BufSize:=65000;

     GetMem (Block,BufSize);
     PeekMem;

     WHILE (NumBytes > 0) DO
     BEGIN
          {$I-}
          Seek (Source,StartPos);
          IF (NumBytes > BufSize) THEN
          BEGIN
               BlockRead (Source,Block^,BufSize);
               BlockWrite (Dest,Block^,BufSize);
               Dec (NumBytes,BufSize);
          END ELSE
          BEGIN
               BlockRead (Source,Block^,NumBytes);
               BlockWrite (Dest,Block^,NumBytes);
               NumBytes:=0;
          END;

          {$I+}
          IORes:=IOResult;
          IF (IORes > 0) THEN
          BEGIN
               LogDiskIoError (IORes,'Fatal error copying file blocks');
               Break;
          END;
     END; { while }

     { Geef het geheugen blok weer terug }
     FreeMem (Block,BufSize);
END;


{---------------------------------------------------------------------------}
{ ReplaceExtension                                                          }
{                                                                           }
{ Deze functie vervangt de extensie van de opgegeven naam en geeft deze     }
{ weer volledig terug. De nieuwe extensie moet een punt bevatten.           }
{                                                                           }
FUNCTION ReplaceExtension (Source : STRING; NewExt : STRING) : STRING;

VAR Dir  : DirStr;
    Name : NameStr;
    Ext  : ExtStr;

BEGIN
     FSplit (Source,Dir,Name,Ext);
     ReplaceExtension:=Dir+Name+NewExt;
END;


{--------------------------------------------------------------------------}
{ RenameSerial                                                             }
{                                                                          }
{ Probeer eerst een file te renamen, vervolgens naar .xx0 , dan naar .xx1  }
{ etc. Als er een .xx9 file bestaat, wordt er niet gerenamed. Dan komt     }
{ ie vanzelf in de log.                                                    }
{                                                                          }
FUNCTION RenameSerial (Source : STRING; VAR Destination : STRING): BOOLEAN;

VAR SFile   : FILE;
    Counter : CHAR;
    IORes   : BYTE;

BEGIN
     RenameSerial:=FALSE;
     { Probeer eerst of we de file gewoon kunnen renamen }
     Assign (SFile,Source);
     {$I-} Rename (SFile,Destination); {$I+} IORes:=IOResult;
     IF (IORes = 0) THEN
     BEGIN
          RenameSerial:=TRUE;
          Exit;
     END;

     FOR Counter:='0' TO '9' DO
     BEGIN
          Destination[Length(Destination)]:=Counter;
          {$I-} Rename (SFile,Destination); {$I+} IORes:=IOResult;
          IF (IORes = 0) THEN
          BEGIN
               RenameSerial:=TRUE;
               Exit;
          END;
     END; { for }
END;


{---------------------------------------------------------------------------}
{ Micro2Longint                                                             }
{                                                                           }
{ Converteert een microsoft 32bit floating point getal naar een longint,    }
{ deze routine werkt alleen voor GEHELE getallen.                           }
{                                                                           }
{ Deze hele routine werkt zonder floating point getallen om de overhead     }
{ zo klein mogenlijk te houden.                                             }
{                                                                           }
{ De PC-Board was zeker eerst in basic geschreven? Het formaat voor deze    }
{ floats werd alleen door IBM basic ondersteund....                         }
{                                                                           }
FUNCTION Micro2Longint (Invoer : LONGINT) : LONGINT;

VAR Mantisse,
    Tmp_Mant,
    Res      : LONGINT;
    Exp      : BYTE;
    Tel      : BYTE;

LABEL Found_1;

BEGIN
     IF (Invoer = 0) THEN                         { Volgens Tanenbaum is 0 }
     BEGIN                                        { een speciaal geval (!) }
          Micro2Longint := 0;
          Exit;
     END;

     Res:=0;
     Exp:=0;
     Tel:=0;

     { Verbeter een reken fout omdat pascal met signed longints werkt }
     { Aagll.. ik stuur de halve wereld een kopie.. is ie buggie      }
     ASM
        XOR CH,CH
        MOV CL,BYTE PTR Invoer + 3;   { Exponent := (Invoer SHR 24) - $81 }
        SUB CL,$81
        MOV Exp,CL

        XOR DX,DX
        MOV AX,$01                    { Res := 1 SHL Exponent          }
        CMP CL,$00                    { Kijk of er wel een exponent is    }
        JZ  @@10                        { Geen exponent ?                   }
        DEC BYTE PTR Exp              { Exponent := Exponent - 1         }

        CMP CL,15
       JG  @@1
        SHL AX,CL
        JMP @@10
       @@1:
        SUB CL,16
        INC DX
        SHL DX,CL

        @@10:

         MOV WORD PTR Res  , AX
         MOV WORD PTR Res+2, DX

        XOR AH,AH
        MOV BYTE PTR Invoer + 3,AH;  { Invoer   := Invoer AND ($7FFFFF) }
        MOV AX,WORD PTR Invoer       { Mantisse := Invoer               }
        MOV WORD PTR Mantisse, AX
        MOV AX,WORD PTR Invoer + 2
        MOV WORD PTR Mantisse+2,AX

        MOV BL,1                     { Teller = 0                       }

       @@11:

        CMP Exp,$00                  { Exponent = 0 ?                   }
        JL  @@12                       { Dan naar einde lus               }

        MOV AX,WORD PTR Invoer       { Mantisse := Invoer               }
        MOV WORD PTR Mantisse, AX
        MOV AX,WORD PTR Invoer + 2
        MOV WORD PTR Mantisse+2,AX

        MOV AX,$01                   { 1 SHL (22 - Tel)                 }
        XOR DX,DX
        MOV CL,23
        SUB CL,BL

        CMP CL,15
        JG  @@2
        SHL AX,CL
        JMP @@20
       @@2:
        INC DX
        SUB CL,16
        SHL DX,CL

       @@20:
        AND WORD PTR Mantisse+2 , DX
        JNZ @@30
        AND WORD PTR Mantisse   , AX
        JNZ @@30

        DEC BYTE PTR Exp           { Exponent := Exponent - 1           }
        INC BL                     { Tel      := Tel + 1                }

        JMP @@11

       @@30:

        MOV AX,$01                 { Res := Res + 1 SHL Exponent  }
        XOR DX,DX
        XOR CH,CH
        MOV CL,Exp
        CMP CL,0
        JZ  @@21;

        @@25:

         SHL AX,1                     { DX:AX is een 32 bits longint      }
         ROL DX,1                     { Rotate with Carry                 }
         SHL DX,1

         LOOP @@25;

        @@21:

        ADD WORD PTR Res     , AX
        ADC WORD PTR Res + 2 , DX

        DEC BYTE PTR Exp           { Exponent := Exponent - 1           }
        INC BL                     { Tel      := Tel + 1                }

        JMP @@11

        @@12:
     END;

(* Dec( Exp );
 Tel := 0;
 WHILE (Exp>0) DO
  BEGIN
  IF (Mantisse AND (1 SHL (22 - Tel)))>0 THEN
   Res := Res + (1 SHL Exp);
  Dec(Exp);
  Inc(Tel);
  END; *)

     Micro2Longint:=Res;
END;


{--------------------------------------------------------------------------}
{ Longint2Micro                                                            }
{                                                                          }
{ Converteert een longint getal naar een microsoft 32 bit floating point   }
{ Ook hier geldt dat het alleen werkt voor POSITIEVE GEHELE getallen.      }
{                                                                          }
FUNCTION Longint2Micro (Invoer : LONGINT) : LONGINT;

VAR Res     : LONGINT;
    Exponent,
    Tel,
    Start   : BYTE;

BEGIN
     IF (Invoer = 0) THEN                        { 0 is een speciaal geval }
     BEGIN
          Longint2Micro:=0;
          Exit;
     END;

     Tel:=0;
     Res:=0;
     Start:=31;

     { Zoek de grootste 2 macht }
     WHILE (Start > 0) DO
     BEGIN
          IF (Invoer AND (longint (1) SHL Start)) > 0 THEN
             Break;
          Dec (Start);
     END;

     Exponent:=Start;
     ASM
        MOV AX,1
        XOR DX,DX
        MOV CL,Exponent
        CMP CL, 15
        JG @@1
        SHL AX,CL
        JMP @@2
       @@1:
        SUB CL,16
        INC DX
        SHL DX,CL
       @@2:
       SUB WORD PTR Invoer   , AX
       SBB WORD PTR Invoer+2 , DX
     END;

     {Invoer:=Longint ( Invoer - Longint( 1 SHL Exponent ) );}
     Dec (Start);

     { Zorgt dat de mantisse met zinnige informatie gevuld wordt }
     WHILE (Invoer > 0) DO
     BEGIN
          IF (Invoer-(Longint (1) SHL Start)) >= 0 THEN
          BEGIN
               Invoer:=Invoer-Longint((Longint (1) SHL Start));
               Res:=Res+(Longint (1) SHL (22-Tel));
          END;

          Inc (Tel);
          Dec (Start);
     END; { while }

     Longint2Micro:=Res OR (Longint ((Exponent+$81)) SHL 24);
END;


{---------------------------------------------------------------------------}
{ DeleteCTFBS                                                               }
{                                                                           }
{ Deze routine haalt commentaar uit de regel (beginnend met een puntkomma), }
{ vertaalt tabs naar spaties en verwijderd de spaties aan het begin en het  }
{ einde van de regel. De rest komt terug.                                   }
{                                                                           }
FUNCTION DeleteCTFBS (Tekst : STRING) : STRING;

VAR P : BYTE;

BEGIN
     P:=Pos (';',Tekst);
     IF (P > 0) THEN
        Tekst:=Copy (Tekst,1,P-1);

     DeleteCTFBS:=DeleteFrontAndBackSpaces (CleanTabs (Tekst,1));
END;


{--------------------------------------------------------------------------}
{ CalcAllowedMem                                                           }
{                                                                          }
{ Deze routine berekent hoeveel geheugen voor een buffer aangevraagd mag   }
{ worden zonder dat het systeem in de problemen komt. We zorgen dat er     }
{ altijd MINFREE (=20000) bytes vrijblijven na het aanvragen. Er mag dus   }
{ MaxAvail-MINFREE aangevraagd worden. Als dat niet gaat, dan nemen we het }
{ maximum beschikbare.                                                     }
{ Er kan ook een AtLeast opgegeven worden. Als zoveel bytes niet           }
{ beschikbaar kunnen worden gemaakt, dan wordt FALSE terug gegeven.        }
{ Merk op dat MSGS_LOMEM_GOSWAP op 15000 staat.                            }
{                                                                          }
FUNCTION CalcMaxAllowedMem (VAR Allowed : WORD; AtLeast,AtMost : WORD) : BOOLEAN;

{ 20k is swappen, dan altijd nog 8000 nodig voor een export }
{ buffer en dat kan nu dus nog.                             }

CONST MINMEMFREE = 10000;       { voor CalcMaxAllowedMem }

VAR MaxAllowed : LONGINT;

BEGIN
     { Make sure there is always 20k free in small blocks, so check }
     { with MemAvail.                                               }
     MaxAllowed:=MemAvail-MINMEMFREE;

     { if there is not enough memory, then abort at once }
     IF (MaxAllowed < 0) THEN
     BEGIN
          LogMessage ('WARNING: Free memory below critical limit in CalcMaxAllowedMem !!');
          CalcMaxAllowedMem:=FALSE; { niet gelukt }
          Exit;
     END;

     { the possible block can of course not be bigger than MaxAvail }
     IF (MaxAllowed > MaxAvail) THEN
        MaxAllowed:=MaxAvail;

     { give em what they want }
     Allowed:=AtMost;

     { unless there is not enough space }
     IF (Allowed > MaxAllowed) THEN
        Allowed:=MaxAllowed;

     { return if succesful (hopefully, in most cases) }
     CalcMaxAllowedMem:=(Allowed >= AtLeast);
END;


{$IFNDEF OS2}
PROCEDURE FindClose (VAR Search : SearchRec);
BEGIN
END;
{$ENDIF}


{--------------------------------------------------------------------------}
{ unit initialization                                                      }
{                                                                          }
BEGIN
     FILEMODE:=fmReadWrite+fmDenyNone;
     LowestMemReached:=MemAvail;
     regKeyNumber:=$FFFF;

     TempPath:=GetEnv('TEMP');
     IF (TempPath = '') THEN
        TempPath:=GetEnv('TMP');
     TempPath:=CorrectPath (TempPath);
END.
