{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT FidoMsg;

{ FidoMsg                                                                 }
{                                                                         }
{ Deze unit bevat alle routines die nodig zijn om een FIDO *.MSG base     }
{ te manipuleren. Het is een samenraapsel van routines die eerst in       }
{ <FIDO> en <MSGS> bewaard werden.                                        }
{                                                                         }
{ 10-09-93 Hierheen verplaatst                                            }
{ 23-09-93 \*.MSG toevoegen aan searchpath bug gefixed.                   }


INTERFACE

USES Database;

TYPE MsgOverlapRecord = RECORD
                              { at offset 176 / $B0 }
                              CASE INTEGER OF
                                        { Standard Format }
                                   0 : (DestZone,
                                        OrigZone,
                                        DestPoint,
                                        OrigPoint   : WORD);

                                        { Opus / FrontDoor format }
                                   1 : (DateWritten,
                                        DateArrived : LONGINT);

                                   2 : (A1,A2,A3,A4 : BYTE;
                                        B1,B2,B3,B4 : BYTE);

                              { DateWritten and DateArrived are packed }
                              { DOS dates with the high and low word   }
                              { exchanged as per the format used by    }
                              { Opus 1.03                              }
                        END;

TYPE FidoStoredHeader = RECORD
                              FromUserName  : ARRAY[0..35] OF CHAR;
                              ToUserName    : ARRAY[0..35] OF CHAR;
                              Subject       : ARRAY[0..71] OF CHAR;
                              DateTime      : ARRAY[0..19] OF CHAR;
                              TimesRead     : WORD;

                              DestNode,
                              OrigNode,
                              Cost          : WORD;

                              OrigNet,
                              DestNet       : WORD;

                              { Opus or not? }
                              Overlap       : MsgOverlapRecord;

                              ReplyTo       : WORD;
                              Attribute     : WORD;
                              NextReply     : WORD;
                        END;

PROCEDURE ScanFidoMsgArea (AreaData : AreaBaseRecord; IsPrimaryNetmailArea : BOOLEAN);
FUNCTION  FidoMsgSaveMessage (Target_Directory : STRING) : BOOLEAN;
PROCEDURE FidoMsgImport (AreaName,Aka : STRING; ForceNoKill,DeskTop : BOOLEAN);

PROCEDURE FidoMsgClearMsgCount;
PROCEDURE FidoMsgInitMsgCount;
FUNCTION  FidoMsgGetNextMsgNum (Path : STRING) : STRING;


IMPLEMENTATION

USES Ramon,
     Crt,
     AreaMgr,
     Cfg,
     Logs,
     Fido,
     Globals,
     Dos,
     FBuffer,
     AreaBase,
     Msgs,
     UserBase,
     Strings,
     Stats,
     Fd,
     ListSrv,
     SwapMem,
     JAM,
     Squish,
     PCBoard,
     Decode,
     Routing,
     Start,
     {$IFDEF OS2}
     Os2Base,
     {$ENDIF}
     Slice,
     WildCat;

     { Lijst met het aantal berichten in een fido *.MSG area }
TYPE MsgCounterPtr = ^MsgCounter;
     MsgCounter = RECORD
                        AreaId  : LONGINT;
                        AreaCnt : LONGINT;
                        AreaNxt : MsgCounterPtr;
                  END;

VAR CounterMsg : MsgCounterPtr;

CONST MsgCacheSize = 10000; { de meeste berichten zullen niet groter zijn }


{--------------------------------------------------------------------------}
{ ScanFidoMsgArea                                                          }
{                                                                          }
{ Doorzoekt een directory op fido *.MSG berichten die verstuurd moeten     }
{ worden. Het path & de naam van de area moeten worden meegegeven, als de  }
{ areaname leeg is, wordt ervanuit gegaan dat het bericht een Netmail is.  }
{                                                                          }
{ RWI961218: Index toegevoegd. Iedere entry is een combinatie van de low   }
{            wordt van de date en size in een longint.                     }
{                                                                          }
PROCEDURE ScanFidoMsgArea (AreaData : AreaBaseRecord; IsPrimaryNetmailArea : BOOLEAN);

CONST MsgIndexFilename = 'MSGINDEX.WG';

VAR ZoekFile      : SearchRec;
    InputFile     : FBufferType;
    FidoMsgHeader : FidoStoredHeader;
    UserName      : STRING[MaxLenFromUser_F];
    FidoTmpAdres  : FidoAddrType;
    IORes         : BYTE;
    MsgNr         : LONGINT;
    Error         : ValNop;
    TmpFile,
    DirectoryName,
    Regel,
    LastRegel     : STRING;
    WhereTo       : WhereToType;
    RegelNr       : WORD;
    UserRecordNr  : UserBaseRecordNrType;
    RealLen       : BYTE;
    Abort_Read    : BOOLEAN;
    FirstExport   : BOOLEAN;
    IndexFile     : FILE;
    IndexCheck,
    IndexCode     : LONGINT;

LABEL FindNextMsg;

BEGIN
     IF (AreaData.FidoMsgPath = '') THEN
     BEGIN
          LogMessage ('[Scan] Path not defined for *.MSG area '+AreaData.AreaName_F);
          Exit;
     END;

     FirstExport:=TRUE;

     { houdt de stats bij van de lokale gebieden }
     UserDataRecNr:=NILRecordNr;
     DirectoryName:=AreaData.FidoMsgPath;

     { verwijder backspace aan het einde }
     IF (DirectoryName[Length (DirectoryName)] = '\') THEN
        Delete (DirectoryName,Length (DirectoryName),1);

     { kijk of de gegeven directory wel bestaat }
     FindFirst (DirectoryName,$10,Zoekfile);
     IF (Dos.DosError <> 0) THEN
     BEGIN
          LogMessage ('Directory '+DirectoryName+' does not exist!');
          FindClose (ZoekFile);
          Exit;
     END;
     FindClose (ZoekFile);

     { zoek naar het eerste *.MSG bestand in deze directory }
     DirectoryName:=AreaData.FidoMsgPath;
     IF (DirectoryName[Length (DirectoryName)] <> '\') THEN
        DirectoryName:=DirectoryName+'\';

     FindFirst (DirectoryName+'*.MSG',$3F,ZoekFile);
     IF (Dos.DosError = 18) THEN
     BEGIN
          FindClose (ZoekFile);
          Exit; { geen files }
     END;

     { open / create the message index file }
     Assign (IndexFile,DirectoryName+MsgIndexFilename);
     {$I-} Reset (IndexFile,1); {$I+} IORes:=IOResult;
     IF (IORes = 2) THEN
     BEGIN
          {$I-} ReWrite (IndexFile,1); {$I+} IORes:=IOResult;
     END;

     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'Error accessing '+MsgIndexFilename);
          Exit;
     END;

     PeekFiles;

     { doorloop de directory tot alle berichten zijn gevonden }
     WHILE (NOT GlobalAbort) AND (Dos.DosError = 0) DO
     BEGIN
          { controleer of het bericht begint met een decimale naam }
          Val (Copy (Zoekfile.Name,1,Pos ('.',Zoekfile.Name)-1),MsgNr,Error);

          { zo niet, raporteer dit aan de bevoegde instanties }
          IF (Error > 0) THEN
          BEGIN
               LogExtraMessage ('Ignoring invalid number in *.MSG filename '+ZoekFile.Name);
               GOTO FindNextMsg;
          END;

          IF ((Zoekfile.Attr AND 1) <> 0) THEN
          BEGIN
               LogMessage ('Skipping locked message '+ZoekFile.Name);
               GOTO FindNextMsg;
          END;

          { update de index file }
          IndexCode:=(Zoekfile.Time SHL 16) OR (Zoekfile.Size AND 65535);

          { controleer de index }
          IF (NOT ForceCleanScan) AND (MsgNr*4 < FileSize (IndexFile)) THEN
          BEGIN
               {$I-}
               Seek (IndexFile,MsgNr*4);
               BlockRead (IndexFile,IndexCheck,4);
               {$I+}

               IF (IndexCheck = IndexCode) THEN
                  GOTO FindNextMsg;
          END;

          { update the index code }

          Slice_Now;

          IF KeyPressed AND (Ramon.ReadKey = kEsc) THEN
          BEGIN
               GlobalAbort:=TRUE;
               Break;
          END;

          { niet de index updaten als we alleen op zoek zijn naar file    }
          { attaches, want dan kunnen berichten nooit geexporteerd raken. }
          IF (SystemMode <> smFDSCAN) THEN
          BEGIN
               {$I-}
               Seek (IndexFile,MsgNr*4);
               BlockWrite (IndexFile,IndexCode,4);
               {$I+} IORes:=IOResult;
               IF (IORes <> 0) THEN
                  LogDiskIOError (IORes,'Error updating *.MSG index at '+Longint2String (MsgNr*4));
          END;

          UpdateReadFile (DirectoryName+Zoekfile.Name,Zoekfile.Size);

          { probeer het bericht te openen }
          IF (NOT FBufferOpen (InputFile,DirectoryName+Zoekfile.Name,MsgCacheSize,SizeOf (FidoStoredHeader))) THEN
          BEGIN
               { RWI 961005: added FBufferOpen result check, log and Continue (!!) }
               LogMessage ('Failed to open '+Zoekfile.Name);
               FBufferClose (InputFile);
               GOTO FindNextMsg;
          END;

          { probeer de header in te lezen }
          IF (NOT FBBlockRead (InputFile,FidoMsgHeader,SizeOf (FidoStoredHeader))) THEN
          BEGIN
               LogMessage ('Unable to read from '+Zoekfile.Name);
               FBufferClose (InputFile);
               GOTO FindNextMsg;
          END;

          { nu kijken we of dit bericht niet verzonden moet worden }
          { RWI 960219: check voor Hold en Read verplaatst tot Na' de }
          {             file attach check.                            }
          IF ((FidoMsgHeader.Attribute AND MSGSENT) <> 0) OR
             ((FidoMsgHeader.Attribute AND MSGFRQ) <> 0) THEN
          BEGIN
               { Er staat een SENT vlag op het bericht, we negeren het dus }
               { de geadresseerde heeft het bericht al gelezen het bericht }
               { is niet lokaal, en niet geforward                         }

               { RAWI 970531: sla berichten met een File Request vlag }
               {              natuurlijk ook over..                   }
               FBufferClose (InputFile);
               GOTO FindNextMsg;
          END;

          { test op READ berichten of (HOLD en FrontDoor) }
          IF ((FidoMsgHeader.Attribute AND MSGREAD) <> 0) OR
{RWI 960521} ((Config.FidoSystem = stFrontDoor) AND
{RWI 941127}  ((FidoMsgHeader.Attribute AND MSGHOLD) <> 0)) THEN
          BEGIN
               IF ((FidoMsgHeader.Attribute AND MSGFILE) = 0) THEN
               BEGIN
                    { Read or Hold message, but not a file attach: skip it }
                    FBufferClose (InputFile);
                    GOTO FindNextMsg;
               END;
          END;

          { ---- initialisatie van de lokale variabelen ---- }

          LastRegel:='';
          RegelNr:=0;

          Found_Path:=FALSE;
          Found_SeenBy:=FALSE;
          Found_Tear:=FALSE;
          Found_Origin:=FALSE;

          { maak eerst de interne bericht structuur leeg }
          MsgsEmpty;

          { vul dan opnieuw de header in }
          WITH FidoMsgHeader DO
          BEGIN
               IF (AreaData.AreaType = Area_Echo) THEN
               BEGIN
                    Msg.Ready_F:=Local_Echomail;
                    { vul de extra informatie in }
                    Msg.Area_F:=AreaData.AreaName_F;
                    { Stop de AREA: kludge in de eerste regel van het bericht }
                    MsgsAddLineTo (Header_F,'AREA:'+AreaData.AreaName_F);
               END ELSE
                   Msg.Ready_F:=Local_Netmail;

               Msg.FromUser_F:=DeleteBackSpaces (StrPas (FromUserName));
               Msg.ToUser_F:=DeleteBackSpaces (StrPas (ToUserName));
               Msg.Subj_F:=DeleteBackSpaces (StrPas (Subject));
               Msg.Date_F:=FidoCorrectDate (DateTime);
               Msg.Cost_F:=Cost;
               Msg.Attr_F:=Attribute;

               { Let op ! Over het algemeen zetten alle editors rotzooi }
               { in de zone + point velden. Als er een zone in het      }
               { bericht staat halen we hem wel uit de MSGID ofzo.      }

               { FrontDoor/Opus zetten in die velden twee datums }

               Msg.FromAddr_F.Zone:=0;
               Msg.FromAddr_F.Net:=origNet;
               Msg.FromAddr_F.Node:=origNode;
               Msg.FromAddr_F.Point:=0;

               Msg.ToAddr_F.Zone:=0;
               Msg.ToAddr_F.Net:=destNet;
               Msg.ToAddr_F.Node:=destNode;
               Msg.ToAddr_F.Point:=0;
          END; { with }

          WHILE FBReadLnCR (InputFile,Regel) AND (Regel <> #0) DO
          BEGIN
               { soft CR's strippen }
               WHILE (Pos (#$8D,Regel) > 0) DO
                     Delete (Regel,Pos (#$8D,Regel),1);

               { FidoAddLineToMessage gaat er vanuit dat de nodige }
               { cr,lf enzo al in Regel zitten. Dat hebben we dus  }
               { precies nodig om regels langer dan 255 tekens toe }
               { te kunnen voegen...                               }
               FidoAddLineToMessage (Regel,LastRegel);

          END; { while }

          FidoAddLastLine (LastRegel);

          { ignore LOcKed messages }
          IF ((Msg.ExtAttr_F AND EXTMSGLOK) <> 0) THEN
          BEGIN
               FBufferClose (InputFile);
               GOTO FindNextMsg;
          END;

          { we no longer need the FBuffer cache, so we disable it }
          FBufferFreeCache (InputFile);

          { Als de FROM zone nog steeds nul is, probeer hem dan aan te }
          { vullen met de Area AKA                                     }
          IF (Msg.FromAddr_F.Zone = 0) THEN
             IF (Msg.Ready_F = Local_Echomail) THEN
                FidoMergeAdres (Config.NodeNrs[AreaData.OriginAka],Msg.FromAddr_F)
             ELSE
                 FidoMergeAdres (Config.NodeNrs[1],Msg.FromAddr_F);

          { Als de TO zone nog steeds nul is, probeer hem dan aan te }
          { vullen met de FROM zone.                                 }
          IF (Msg.ToAddr_F.Zone = 0) AND (Msg.FromAddr_F.Zone <> 0) THEN
             Msg.ToAddr_F.Zone:=Msg.FromAddr_F.Zone;

          {----------------------------------------------------------------}
          { Frontdoor Netmail MODE                                         }
          {                                                                }
          { Controleer of we met een 'leeg' netmail bericht te maken       }
          { hebben dat met een file-attch heeft. Controleer vervolgens of  }
          { die file attach nog wel bestaat.                               }
          {                                                                }
          { Deze functie bestaat ALLEEN voor de Fido *.MSG routines,       }
          { Frontdoor kent (nog) geen andere formaten.                     }
          {----------------------------------------------------------------}
          IF (Config.FidoSystem = stFrontdoor) AND (Msg.Ready_F = Local_Netmail{geen echomail}) THEN
          BEGIN
               { controleer of het bericht }
               {  A) Van ons afkomt        }
               {  B) Van ARCMAIL is        }

               IF FidoOurAdres (Msg.FromAddr_F) AND (Msg.FromUser_F = 'ARCmail') THEN
                  { controleer of dit een 'leeg' bericht is }
                  IF (Msg.BodyTop = NIL) OR (Msg.BodyTop^.TotalRegelLength < 5) THEN
                     IF ((FidoMsgHeader.Attribute AND MSGFILE) <> 0) THEN
                     BEGIN
                          { Controleer alleen of de EERSTE file op de }
                          { regel nog wel bestaat.                    }
                          TmpFile:=DeleteBackSpaces (StrPas (FidoMsgHeader.Subject));
                          IF (Pos (' ',TmpFile) > 0) THEN
                             TmpFile:=Copy (TmpFile,1,Pos (' ',TmpFile)-1);

                          { de file moet een VOLLEDIG (incl. Drive!) path }
                          { bevatten                                      }
                          IF (TmpFile[2] = ':'{C:\FILES}) AND (NOT ForceNoFAKill) THEN
                             IF (NOT TestIfExist (TmpFile)) THEN
                             BEGIN
                                  LogMessage ('Attached file no longer exists for '+StrPas (FileRec (InputFile.Bestand).Name)+
                                              '; deleting');
                                  FBufferClose (InputFile);
                                  {$I-} Erase (InputFile.Bestand); {$I+}
                                  IORes:=IOResult;
                                  IF (IORes <> 0) THEN
                                     LogDiskIOError (IORes,'Unable to delete empty file attach message');

                                  GOTO FindNextMsg;
                             END;

                          { Als we hier aankomen hebben we dus een         }
                          { fileattach voor een node gevonden, die nog     }
                          { bestaat ook!                                   }
                          { Kijk alleen nog ff of we de node wel kennen... }
                          FrontDoorAddToList (Msg.ToAddr_F,TmpFile);

                          { nu moeten we er voor zorgen dat dit bericht }
                          { bij een volgende scan weer bekeken wordt.   }
                          { verander daarom de index!                   }

                          {$I-}
                          Seek (IndexFile,MsgNr*4);
                          IndexCode:=-1; { bijna onmogelijke met deze korte file attaches }
                          BlockWrite (IndexFile,IndexCode,4);
                          {$I+} IORes:=IOResult;
                          IF (IORes <> 0) THEN
                             LogDiskIOError (IORes,'Error updating *.MSG index');

                     END; { if FileAttach }
          END; { if Frontdoor }

          { Controleer of het bericht voor Areafix, listserver of gateway }
          { is EN of het uberhaupt wel lokaal is.                         }
          IF (SystemMode = smFDSCAN) OR (NOT FidoCheckNetmail (IsPrimaryNetmailArea)) THEN
          BEGIN
               FBufferClose (InputFile);
               GOTO FindNextMsg;
          END;

          { verwijderen van lokale vlaggen van een bericht }
          Msg.Attr_F:=Msg.Attr_F AND ($FFFF-MSGLOCAL-MSGXX2);

          { aanvullen van het bericht }
          IF (NOT Found_Tear) THEN
             MsgsAddLineTo (Footer_F,FidoTear);

          { alleen als het bericht een Echomail is }
          IF (Msg.Ready_F = Local_Echomail) THEN
             FidoFinishEchomailExport;

          IF FirstExport THEN
          BEGIN
               FirstExport:=FALSE;
               LogMessage ('Exporting from '+AreaData.AreaName_F+' (*.MSG)');
          END;

          { werk de statistieken bij... }
          IF (Msg.Ready_F = Local_Netmail) THEN
          BEGIN
               {Inc (FidoProcessStatus.NetCount) { Netmail }
               IF Config.LogExportedMsgs THEN
                  LogMessage ('  Exporting '+Zoekfile.Name+' for "'+Msg.ToUser_F+'"%'+Fido2Str (Msg.ToAddr_F));
          END ELSE
          BEGIN
               { echomail }
               UpdateAreaStats (GetAreaBaseRecordNrByAreaName_F (AreaData.AreaName_F),Msg.MsgSize);
               UpdateUserStats (NILRecordNr{local},EchoFrom,Msg.MsgSize);
          END;

          UpdateInfoNr (INFO_MsgScan_Msgs,1);
          UpdateInfoNr (INFO_MsgScan_Bytes,ZoekFile.Size);

          IF (Msg.Ready_F IN [Netmail,Local_Netmail]) then
             UpdateInfoNr (INFO_MsgScan_Net,1)
          ELSE
              UpdateInfoNr (INFO_MsgScan_Echo,1);

          IF Config.KillAreaFixMsgs AND
             (UpCaseString (Msg.ToUser_F) = UpCaseString (Config.AreafixName)) AND
             FidoOurAdres (Msg.ToAddr_F)
          THEN
              FidoMsgHeader.Attribute:=FidoMsgHeader.Attribute OR MSGKILL;

          MsgsExport;

          { als WasGated en KillGatedNetmail beide gezet zijn, dan is }
          { deze netmail naar Usenet gestuurd en moet ik verwijderd   }
          { worden. Lekker simpel: de KillSent vlag erop zetten...    }
          IF (Msg.WasGated AND Config.KillGatedNetmail) THEN
             FidoMsgHeader.Attribute:=FidoMsgHeader.Attribute OR MSGKILL;

          { Nu moeten we de file voorzien van een 'SENT' vlag, en als het }
          { een Kill/Sent vlag had verwijderen.                           }

          { Omdat ik geen zin heb om moeilijk te gaan doen,... ff heel    }
          { smerig. Maar omdat we de file hierna toch afsluiten...        }
          {                                                               }
          { We passeren hier de read cache van FBuffer om direct in de    }
          { file te gaan zitten klooien. Dit was minder werk dan om       }
          { FBUFFER geheel transparant te maken.                          }
          IF NOT ((FidoMsgHeader.Attribute AND MSGKILL) = MSGKILL) THEN
          BEGIN
               { plaats een sent vlag op het bericht om aan te geven dat }
               { het verzonden is.                                       }
               FidoMsgHeader.Attribute:=FidoMsgHeader.Attribute OR MSGSENT;

               { update de header van het bericht }
               {$I-}
               Seek (Inputfile.Bestand,0);
               BlockWrite (Inputfile.Bestand,FidoMsgHeader,SizeOf (FidoMsgHeader));
               {$I+}

               IORes:=IOResult;
               IF (IORes > 0) THEN
                  LogDiskIOError (IORes,'Unable to update *.MSG message header');

               FBufferClose (Inputfile);
          END ELSE
          BEGIN
               { er stond een kill/sent vlag op het bericht, we }
               { verwijderen het dus.                           }
               FBufferClose (InputFile);
               {$I-} Erase (InputFile.Bestand); {$I+}
               IORes:=IOResult;
               IF (IORes > 0) THEN
                  LogDiskIOError (IORes,'[ScanFidoMsgArea] Unable to delete '+InputFile.Filename);
          END;

 FindNextMsg:
          { en spring door naar de volgende file }
          { RWI 201094: Gaat dit ook goed als je een file verwijderd hebt? }
          {             In de *.PKT inlees routine gingen we steeds        }
          {             opnieuw verder door FindFirst uit te voeren...     }
          FindNext (Zoekfile);
     END; { while DosError=0  }

     {$I-} Close (IndexFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'Error closing *.MSG index file');

     FindClose (ZoekFile);

     MsgsEmpty;
END;


{--------------------------------------------------------------------------}
{ FidoMsgsSaveMessage                                                      }
{                                                                          }
{ Deze routine importeert een bericht in een lokale *.MSG base.            }
{                                                                          }
FUNCTION FidoMsgSaveMessage (Target_Directory : STRING) : BOOLEAN;

TYPE MsgBufferPtr  = ^MsgBufferType;
     MsgBufferType = ARRAY[0..65528] OF BYTE;

VAR Target_File   : STRING;
    MsgBuffer     : MsgBufferPtr;
    MsgBufOfs     : WORD;
    WriteBufLen   : WORD;
    Outfile       : FILE;
    Remembered    : BOOLEAN;
    RememberLine  : STRING;
    SplitCurrPart : WORD;

    {----------------------------------------------------------------------}
    { FillMsgBuffer                                                        }
    {                                                                      }
    { Deze routine vult het MsgBuffer met regels uit de message. Er worden }
    { net zoveel tekens in gezet totdat een regel er niet meer in past.    }
    { Er wordt TRUE terug gegeven als het einde van het bericht bereikt    }
    { is.                                                                  }
    {                                                                      }
    FUNCTION FillMsgBuffer (VAR EenRegelPtr : EenRegelRecordPtr;
                            VAR SwapPos : LONGINT;
                            VAR StoreLeft : LONGINT;
                            StripSeenBy,SkipArea : BOOLEAN;
                            IsBody : BOOLEAN) : BOOLEAN;

    VAR Len   : BYTE;
        Regel : STRING;

        PrevRegelPtr : EenRegelRecordPtr;

    LABEL VolleBak;

    BEGIN
         FillMsgBuffer:=FALSE; { assume not full }

         { zorg dat het swap geheugen klaar staat }
         IF SwapIsOpen THEN
            Seek (SwapFile,SwapPos);

         { blijf regels uit de Msg structuur toevoegen aan het buffer }
         { totdat het buffer vol zit, of we het einde van het bericht }
         { bereikt hebben.                                            }
         WHILE (EenRegelPtr <> NIL) OR (IsBody AND Remembered) DO
         BEGIN
              IF IsBody AND Remembered THEN
              BEGIN
                   Regel:=RememberLine;
                   Remembered:=FALSE;
              END ELSE
                  ExtractFile (EenRegelPtr,Regel);

              Len:=Length (Regel);

              IF (Len > (WriteBufLen-MsgBufOfs)) THEN
              BEGIN
                   IF IsBody THEN
                   BEGIN
                        RememberLine:=Regel;
                        Remembered:=TRUE;
                   END; { else too bad }

                   GOTO VolleBak;
              END;

              IF (Len > StoreLeft) THEN
              BEGIN
                   StoreLeft:=0;

                   IF IsBody THEN
                   BEGIN
                        RememberLine:=Regel;
                        Remembered:=TRUE;
                   END; { else too bad }

                   GOTO VolleBak;
              END;

              { optioneel kan de SEEN-BY regel gestript worden }
              { bij het importeren.                            }
              IF NOT (StripSeenBy AND (Copy (Regel,1,7) = 'SEEN-BY')) THEN
              BEGIN
                   IF SkipArea THEN
                      SkipArea:=FALSE
                   ELSE BEGIN
                        { RAWI 971206: replace MSGID for split parts }
                        IF (NOT IsBody) AND
                           (SplitCurrPart > 1) AND
                           (Copy (Regel,1,8) = #1'MSGID: ') THEN
                        BEGIN
                             Dec (Regel[0],9); { ook de #13 eraf }
                             Regel:=Regel+GetFidoPktName+#13; { en weer erbij }
                        END;

                        Move (Regel[1],MsgBuffer^[MsgBufOfs],Len);
                        Inc (MsgBufOfs,Len);
                        Dec (StoreLeft,Len);
                   END;
              END;
         END; { while }

         { als we hier komen, dan hebben we het einde van dit blok }
         { bereikt en dan moeten we TRUE terug geven.              }
         FillMsgBuffer:=TRUE;

    VolleBak:

         { bewaar de huidige positie van de swapfile voor de volgende keer }
         IF SwapIsOpen THEN
            SwapPos:=FilePos (SwapFile);
    END;


    {----------------------------------------------------------------------}
    { FlushBuffer                                                          }
    {                                                                      }
    { Schrijf de huidige inhoud van het buffer naar disk en maak deze weer }
    { leeg.                                                                }
    {                                                                      }
    PROCEDURE FlushBuffer;

    VAR IORes : BYTE;

    BEGIN
         BlockWrite (OutFile,MsgBuffer^[0],MsgBufOfs);
         UpdateInfoNr (INFO_MsgSave_Bytes,MsgBufOfs);

         IORes:=IOResult;
         IF (IORes <> 0) THEN
            LogDiskIOError (IORes,'[FidoMsgSaveMessage] Unable to write to '+Target_File);

         MsgBufOfs:=0; { zo... buffer is weer leeg }
    END;

{FidoMsgSaveMessage}

VAR SplitBodyLen,
    BodySwapPos,
    SomeSwapPos   : LONGINT;
    FidoHeaderLen,
    FidoFooterLen,
    FidoBodyLen   : LONGINT;
    SplitParts_R  : REAL;
    SplitParts    : WORD;
    MsgHeader     : FidoStoredHeader;
    HulpPtr,
    BodyPtr       : EenRegelRecordPtr;
    IORes         : INTEGER;
    ReachedEOHdr,
    ReachedEOMsg  : BOOLEAN;
    SubjectLine   : STRING[MaxLenSubj_F];
    SplitLine     : STRING[79];
    StoreLeft     : LONGINT;
    DT            : Dos.DateTime;
    Lp            : BYTE;
    Nop           : ValNop;

BEGIN
     Target_Directory:=DeleteFrontAndBackSpaces (Target_Directory);

     IF (Target_Directory[Length (Target_Directory)] <> '\') THEN
        Target_Directory:=Target_Directory+'\';

     UpdateWriteFile (Target_Directory,0);

     { bereken de grootte van de Header, Footer en Body }
     IF (Msg.HeaderTop_F <> NIL) THEN FidoHeaderLen:=Msg.HeaderTop_F^.TotalRegelLength
                                 ELSE FidoHeaderLen:=0;    { RWI 951005: Was: FidoBodyLen }

     IF (Msg.BodyTop <> NIL) THEN FidoBodyLen:=Msg.BodyTop^.TotalRegelLength
                             ELSE FidoBodyLen:=0; { oh ja... }

     IF (Msg.FooterTop_F <> NIL) THEN FidoFooterLen:=Msg.FooterTop_F^.TotalRegelLength
                                 ELSE FidoFooterLen:=0;

     IF (Msg.BodyTop = NIL) THEN
        BodyPtr:=NIL
     ELSE BEGIN
          BodyPtr:=Msg.BodyTop^.FirstRegelRecordPtr;

          IF SwapIsOpen THEN
          BEGIN
               MsgsNewSeek (BodyPtr);
               BodySwapPos:=FilePos (SwapFile);
          END;
     END;

     { bereken het aantal delen waarin het bericht gesplitst gaat worden }
     { RWI 950202: -512 toegevoegd }
     { RWI 950217: veranderd in -256 en toen in -310 }
     IF (Config.MaxFidoMsgLen <> 0) THEN
     BEGIN
          SplitBodyLen:=Config.MaxFidoMsgLen-
                        SizeOf (MsgHeader)-
                        FidoHeaderLen-
                        FidoFooterLen-
                        6;    { "(1/1) " }

          SplitParts_R:=FidoBodyLen / SplitBodyLen;

          SplitParts:=Trunc (SplitParts_R);
          IF (SplitParts < SplitParts_R) THEN
             Inc (SplitParts);
     END ELSE
     BEGIN
          SplitParts:=0;
          SplitBodyLen:=MAXLONGINT;
     END;

     IF (NOT CalcMaxAllowedMem (WriteBufLen,8192,65528)) THEN
     BEGIN
          LogMessage ('[FidoMsgSaveMessage] Short on memory ('+Word2String (WriteBufLen)+'), skipping message');
          Exit;
     END;

     GetMem (MsgBuffer,WriteBufLen);
     {$IFDEF LogGetMem} LogGetMem (MsgBuffer,WriteBufLen,'MsgBuffer'); {$ENDIF}
     PeekMem;

     Remembered:=FALSE;

     { doorloop het volgende blok voor ieder van de split parts }
     SplitCurrPart:=0;
     REPEAT
           { Vul de doel file aan met het eerst volgende bericht nummer }
           Target_File:=FidoMsgGetNextMsgNum (Target_Directory)+'.MSG';

           IF Config.LogDebug THEN
              LogExtraMessage ('  Creating '+Target_File);

           Target_File:=Target_Directory+Target_File;

           { Schrijf het bericht naar disk }
           Assign (OutFile,Target_File);
           {$I-} ReWrite (Outfile,1); {$I+} IORes:=IOResult;

           IF (IORes <> 0) THEN
           BEGIN
                LogDiskIOError (IORes,'[FidoMsgSaveMessage] Cannot create '+Target_File+', aborting!');
                FreeMem (MsgBuffer,WriteBufLen);
                Exit;
           END;

           UpdateInfoNr (INFO_MsgSave_Msgs,1);

           { Is dit bericht in meerdere delen opgesplitst? }
           { zoja, pas dan de Subject lijn aan en voeg een }
           { Split kludge toe.                             }

           IF (SplitParts > 1) THEN
           BEGIN
                Inc (SplitCurrPart);
                SubjectLine:='('+Word2String (SplitCurrPart)+
                             '/'+Word2String (SplitParts)+
                             ') '+Msg.Subj_F;

                SplitLine:=FidoCreateSplitLine (SplitCurrPart,SplitParts)+#13;
           END ELSE
               SubjectLine:=Msg.Subj_F;

           { vul het bericht header gedeelte met gegevens }

           { maak de header leeg, zodat er geen troep staat als je een }
           { hex dump van het bericht bekijkt.              RWI 951126 }
           FillChar (MsgHeader,SizeOf (FidoStoredHeader),#0);

           WITH MsgHeader DO
           BEGIN
                StrPCopy (FromUserName,Msg.FromUser_F);
                StrPCopy (ToUserName,Msg.ToUser_F);
                StrPCopy (Subject,SubjectLine);
                StrPCopy (DateTime,Msg.Date_F);

                TimesRead:=0;
                Cost:=Msg.Cost_F;
                ReplyTo:=0;
                NextReply:=0;

                Attribute:=Msg.Attr_F;

                IF NoLocalFlag THEN
                   Attribute:=Attribute AND ($FFFF-MSGLOCAL);

                WITH Msg.FromAddr_F DO
                BEGIN
                     Overlap.origZone:=Zone;
                     origNet:=Net;
                     origNode:=Node;
                     Overlap.origPoint:=Point;
                END; { with }

                WITH Msg.ToAddr_F DO
                BEGIN
                     Overlap.destZone:=Zone;
                     destNet:=Net;
                     destNode:=Node;
                     Overlap.destPoint:=Point;
                END; { with }

                IF Config.OpusDateFormat THEN
                BEGIN
                     { speciale date format invullen }

                     WITH DT DO
                     BEGIN
                          Val (Copy (Msg.Date_F,1,2),Day,Nop);
                          Val (Copy (Msg.Date_F,8,2),Year,Nop);
                          Val (Copy (Msg.Date_F,12,2),Hour,Nop);
                          Val (Copy (Msg.Date_F,15,2),Min,Nop);
                          Val (Copy (Msg.Date_F,18,2),Sec,Nop);
                     END; { with }

                     DT.Month:=1;

                     FOR Lp:=1 TO 12 DO
                         IF (Month[Lp] = Copy (Msg.Date_F,4,3)) THEN
                         BEGIN
                              DT.Month:=Lp;
                              Break;
                         END;

                     IF (DT.Year > 79) THEN
                        Inc (DT.Year,1900)
                     ELSE
                         Inc (DT.Year,2000);

                     PackTime (DT,Overlap.DateWritten);

                     { swap byte order inside the longint }
                     Overlap.B1:=Overlap.A4;
                     Overlap.B2:=Overlap.A3;
                     Overlap.B3:=Overlap.A2;
                     Overlap.B4:=Overlap.A1;

                     { make both the same }
                     Overlap.DateWritten:=Overlap.DateArrived;
                END; { if opus }

           END; { with }

           { schrijf header aan begin bericht }
           Move (MsgHeader,MsgBuffer^[0],SizeOf (MsgHeader));

           { zet MsgBufOfs vlak achter de header. Vanaf daar kan de }
           { body tekst neergepoot worden.                          }
           MsgBufOfs:=SizeOf (MsgHeader);

           { nu komen alle kludges, de header dus }
           IF (Msg.HeaderTop_F <> NIL) THEN
           BEGIN
                HulpPtr:=Msg.HeaderTop_F^.FirstRegelRecordPtr;

                IF SwapIsOpen THEN
                BEGIN
                     MsgsNewSeek (HulpPtr);
                     SomeSwapPos:=FilePos (SwapFile);
                END;

                REPEAT
                      StoreLeft:=MAXLONGINT;

                      ReachedEOHdr:=FillMsgBuffer (HulpPtr,      { wordt gewijzigd }
                                                   SomeSwapPos,  { wordt gewijzigd }
                                                   StoreLeft,
                                                   FALSE,        { niet belangrijk }
                                                   (Msg.Ready_F = Echomail), { eerste kludge (AREA:) overslaan? }
                                                   FALSE);

                      IF (NOT ReachedEOHdr) THEN
                         FlushBuffer;

                UNTIL ReachedEOHdr;
           END; { has a header }

           { de split lijn komt NA de header }
           IF (SplitParts > 1) THEN
           BEGIN
                IF (Length (SplitLine) > (WriteBufLen-MsgBufOfs)) THEN
                   FlushBuffer;

                Move (SplitLine[1],MsgBuffer^[MsgBufOfs],Length (SplitLine));
                Inc (MsgBufOfs,Length (SplitLine));
           END;

           { nu een (gedeelte van) de body wegschrijven }
           IF (BodyPtr = NIL) THEN
              ReachedEOMsg:=TRUE
           ELSE
               StoreLeft:=SplitBodyLen;

               REPEAT
                     { de body wordt nu in het bericht geplaatst }
                     { alleen het gedeelte dat er door de split in past }
                     ReachedEOMsg:=FillMsgBuffer (BodyPtr,
                                                  BodySwapPos,
                                                  StoreLeft,
                                                  FALSE,
                                                  FALSE,
                                                  TRUE{body});

                     IF (NOT (ReachedEOMsg OR (StoreLeft = 0))) THEN
                        FlushBuffer;

               UNTIL ReachedEOMsg OR (StoreLeft = 0);

           IF (FidoFooterLen > (WriteBufLen-MsgBufOfs)) THEN
              FlushBuffer;

           { nu de footer er nog achter. Hier staan dingen in als Origin  }
           { lines + Seenby's die in iedere kopie + Split van het bericht }
           { moeten komen.                                                }
           IF (Msg.FooterTop_F <> NIL) THEN
           BEGIN
                { RWI 950216: voordat we aan de footer beginnen,      }
                {             controleren we eerst even of er twee    }
                {             enters aan het einde van het blok staan }
                {             want daardoor ontstaat een lege regel   }
                {             _voor_ de tear-line, die als eerste in  }
                {             de body staat (waarschijnlijk). Simpel: }
                {             er moet #13#13 aan het einde staan,     }
                {             anders maken we dat ervan.              }
                StoreLeft:=2;
                IF (MsgBufOfs < 1) OR (MsgBuffer^[MsgBufOfs-1] = 13) THEN
                BEGIN
                     Dec (StoreLeft);
                     IF (MsgBufOfs < 2) OR (MsgBuffer^[MsgBufOfs-2] = 13) THEN
                        Dec (StoreLeft);
                END;

                { nu de enters toevoegen }
                WHILE (StoreLeft <> 0) DO
                BEGIN
                     MsgBuffer^[MsgBufOfs]:=13;
                     Inc (MsgBufOfs);
                     Dec (StoreLeft);
                END;

                HulpPtr:=Msg.FooterTop_F^.FirstRegelRecordPtr;

                IF SwapIsOpen THEN
                BEGIN
                     MsgsNewSeek (HulpPtr);
                     SomeSwapPos:=FilePos (SwapFile);
                END;

                REPEAT
                      StoreLeft:=MAXLONGINT;

                      ReachedEOHdr:=FillMsgBuffer (HulpPtr,
                                                   SomeSwapPos,
                                                   StoreLeft,
                                                   Config.StripSeenBy,
                                                   FALSE,
                                                   FALSE);

                      IF (NOT ReachedEOHdr) THEN
                         FlushBuffer;

                UNTIL ReachedEOHdr;
           END;

           IF (WriteBufLen = MsgBufOfs) THEN
              FlushBuffer; { damn if this runs! }

           { einde bericht. Ieder bericht wordt afgesloten met een 0 }
           MsgBuffer^[MsgBufOfs]:=0;
           Inc (MsgBufOfs);

           { nu MOET het bericht naar disk }
           FlushBuffer;

           { sluit de file voor dit split deel }
           Close (OutFile);

     UNTIL ReachedEOMsg;

     FreeMem (MsgBuffer,WriteBufLen);
END;


{--------------------------------------------------------------------------}
{ FidoClearMsgCount                                                        }
{                                                                          }
{ Deze procedure verwijderd de lijst met alle tellingen van *.MSG          }
{ directory's uit het geheugen.                                            }
{                                                                          }
{ Deze lijst is bedoeld om snel het volgende bericht nummer in een         }
{ *.MSG area te kunnen schrijven, zonder door het gehele bericht te        }
{ hoeven lopen.                                                            }
{                                                                          }
PROCEDURE FidoMsgClearMsgCount;

VAR Local : MsgCounterPtr;

BEGIN
     { RWI 951117: rewritten. CounterMsg was not set to NIL }
     WHILE (CounterMsg <> NIL) DO
     BEGIN
          Local:=CounterMsg;
          CounterMsg:=CounterMsg^.AreaNxt;

          FreeMem (Local,SizeOf (MsgCounter));
     END; { while }
END;


{--------------------------------------------------------------------------}
{ FidoInitMsgCount                                                         }
{                                                                          }
{ Deze procedure initialiseerd de lijst met tellingen van alle *.MSG       }
{ gebieden                                                                 }
{                                                                          }
PROCEDURE FidoMsgInitMsgCount;
BEGIN
     CounterMsg:=NIL;
END;


{--------------------------------------------------------------------------}
{ FidoGetNextMsgNum                                                        }
{                                                                          }
{ Zoekt het volgende bericht nummer bij een directory , beginnende bij 1   }
{ Van elke gegeven directory wordt gecontroleerd of het in de lijst in het }
{ geheugen zit.                                                            }
{                                                                          }
FUNCTION FidoMsgGetNextMsgNum (Path : STRING) : STRING;

VAR LastFound,
    LocalCnt       : MsgCounterPtr;
    PathId         : LONGINT;
    Error          : ValNop;
    ZoekRecord     : SearchRec;
    LaatstGevonden,
    HoogstGevonden : LONGINT;

BEGIN
     { Init van lokale variabelen                       }
     { Maak van de Areaname een CRC32 en stop die in    }
     { een tabeletje in het geheugen zodat we snel      }
     { door de huidige stand van zaken kunnen heenlopen }

     LastFound:=CounterMsg;
     LocalCnt:=CounterMsg;
     Path:=DeleteBackSpaces (Path);
     IF (Path[Length (Path)] <> '\') THEN
        Path:=Path+'\';
     PathId:=UpdateCRC32 (0,Path[1],Length (Path));

     { Zoeken in de tabel naar bekende directory's }
     WHILE (LocalCnt <> NIL) DO
     BEGIN
          { Als we een area gevonden hebben geef dan }
          { het volgende bericht nummer terug.       }
          IF (LocalCnt^.AreaID = PathID) THEN
          BEGIN
               { RWI 951117: controle toegevoegd die er voor zorgt dat }
               { WaterGate tegelijkertijd met een ander programma kan  }
               { draaien dat in dezelfde directory nummers gebruikt.   }
               { Vanaf het laatste gebruikte nummer wordt het eerst    }
               { volgende vrije nummer gezocht.                        }
               REPEAT
                     Inc (LocalCnt^.AreaCnt);
               UNTIL (NOT TestIfExist (Path+Longint2String (LocalCnt^.AreaCnt)+'.MSG'));

               FidoMsgGetNextMsgNum:=LongInt2String (LocalCnt^.AreaCnt);
               Exit;
          END;

          LastFound:=LocalCnt;
          LocalCnt:=LocalCnt^.AreaNxt;
     END; { while }

     { Niet gevonden }
     { LastFound wijst nu naar het laatste record }

     { Begin met tossen op 2.msg, zodat een 1.msg eventueel als }
     { high water mark gebruikt kan worden.                     }

     { Zoek nu alle files in de directory af en kijk of ze een hoger  }
     { nummer hebben. Bewaar dat hoogste nummer, tel er een bij op en }
     { geef het terug aan de aanroeper van het programma.             }

     HoogstGevonden:=0; { RWI 960604: was 1 -> resulteert in 2.msg }
     FindFirst (Path+'*.MSG',$3F,ZoekRecord);

     WHILE (Dos.DosError = 0) DO
     BEGIN
          { converteer de naam naar een longint }
          Val (Copy (ZoekRecord.Name,1,Pos ('.',ZoekRecord.Name)-1),LaatstGevonden,Error);

          { kijk of deze file groter is dan de vorige }
          IF (Error = 0) AND (LaatstGevonden > HoogstGevonden) THEN
             HoogstGevonden:=LaatstGevonden;

          { volgende patient }
          FindNext (ZoekRecord);
     END; { while }

     FindClose (ZoekRecord);

     { een nieuw item aan de lijst toevoegen }
     GetMem (LocalCnt,SizeOf (MsgCounter){=12});
     {$IFDEF LogGetMem} LogGetMem (LocalCnt,SizeOf (MsgCounter),'LocalCnt'); {$ENDIF}
     PeekMem;

     WITH LocalCnt^ DO
     BEGIN
          AreaID:=PathId;
          AreaCnt:=HoogstGevonden+1;
          AreaNxt:=NIL;
     END; { with }

     { Link de variabele vast aan de lijst }
     IF (CounterMsg = NIL) THEN
        CounterMsg:=LocalCnt
     ELSE
         LastFound^.AreaNxt:=LocalCnt;

     FidoMsgGetNextMsgNum:=LongInt2String (LocalCnt^.AreaCnt);
END;


{--------------------------------------------------------------------------}
{ FidoMsgImport                                                            }
{                                                                          }
{ Importeer berichten uit de *.MSG netmail area naar een Squish of Jam     }
{ base. Deze routine wordt gebruikt om berichten die in een lokale *.MSG   }
{ staan voor BBS programma's zichtbaar te maken.                           }
{                                                                          }
{ Wordt aangeroepen door de commandline optie 'IMPORT'                     }
{                                                                          }
{ IMPORT <AreaName> [<Aka>] [<-NOKILL>]                                    }
{                                                                          }
{ BTW. Mocht het je nog niet zijn opgevallen.. de onderstaande code is     }
{      een puinzooi, maar het werkt :-(                                    }
{                                                                          }
PROCEDURE FidoMsgImport (AreaName,Aka : STRING; ForceNoKill,DeskTop : BOOLEAN);

    PROCEDURE ErrorBeep;
    BEGIN
         {$IFDEF OS2}
         DosBeep (220,200);
         {$ELSE}
         Sound (220);        { Beep }
         NewDelay (200);     { For 200 ms }
         NoSound;            { Relief! }
         {$ENDIF}
         DelayOneSecond;
         DelayOneSecond;
    END;

    PROCEDURE DeskErr (Msg : STRING);
    BEGIN
         IF Desktop THEN
            Error (Msg)
         ELSE
             LogExtraMessage (Msg);
    END;

VAR AreaRec       : AreaBaseRecordNrType;
    Address       : FidoAddrType;
    ZoekFile      : SearchRec;
    FidoMsgHeader : FidoStoredHeader;
    TotalMsgs     : LONGINT;
    UserName,
    Regel,
    LastRegel     : STRING;
    Fout          : ValNop;
    Test          : INTEGER;
    InputFile     : FBufferType;
    IORes         : BYTE;

LABEL FindNextMessage,
      CloseAndFindNextMessage;

BEGIN
     LogMessage ('Importing netmail messages from Fido *.MSG base');

     { Kijk of we uberhaupt wel een *.MSG netmail base hebben }
     IF (Config.FidoNetmailType <> FidoMsgType) THEN
     BEGIN
          DeskErr ('The system netmail area must be of *.MSG type to use this option!');
          ErrorBeep;
          Exit;
     END;

     { kijk of er een geldige areaname meegegeven is }
     AreaName:=UpCaseString (DeleteBackSpaces (AreaName));
     AreaRec:=GetAreaBaseRecordNrByAreaName_F (AreaName);
     IF (AreaRec = NILRecordNr) THEN
     BEGIN
          AreaRec:=GetAreaBaseRecordNrByAreaName_U (AreaName);
          IF (AreaRec = NILRecordNr) THEN
          BEGIN
               DeskErr ('Unknown or missing destination area name! '+AreaName);
               ErrorBeep;
               Exit;
          END;
     END;

     { lees het area record in }
     ReadAreaBaseRecord (AreaRec,AreaData);

     IF NOT (AreaData.FidoMsgStyle IN [SquishType,JAMType,WildCatType]) THEN
     BEGIN
          DeskErr ('Unsupported target base type! Must be JAM, Squish or WildCat');
          ErrorBeep;
          Exit;
     END;

     { Kijk of een er een AKA meegegeven is, zoja, kijk of het een geldig }
     { AKA is.                                                            }
     Aka:=UpCaseString (DeleteBackSpaces (Aka));
     TotalMsgs:=0;
     FidoSplit ('0',Address);

     IF (Aka <> '') THEN
     BEGIN
          FidoSplit (AKA,Address);
          IF (NOT FidoOurAdres (Address)) THEN
          BEGIN
               DeskErr ('This address is not defined as one of our system AKAs!');
               ErrorBeep;
               Exit;
          END;
     END;

     {=====================================================================}

     { kijk of de gegeven directory wel bestaat }
     Regel:=Config.FidoNetmailPath;
     Dec (Regel[0]);

     FindFirst (Regel,$10,Zoekfile);
     IF (Dos.DosError <> 0) THEN
     BEGIN
          DeskErr ('Directory '+Config.FidoNetmailPath+' does not exist!');
          ErrorBeep;
          FindClose (ZoekFile);
          Exit;
     END;

     FindClose (ZoekFile);

     IF Desktop THEN
        Message ('Importing Netmail messages into '+AreaName);

     TotalMsgs:=0;

     { zoek naar het eerste *.MSG bestand in deze directory }
     FindFirst (Config.FidoNetmailPath+'*.MSG',$3C,ZoekFile);

     { doorloop de directory tot alle berichten zijn gevonden }
     WHILE (Dos.DosError = 0) DO
     BEGIN
          { controleer of het bericht begint met een decimale naam }
          Val (Copy (Zoekfile.Name,1,Pos ('.',Zoekfile.Name)-1),Test,Fout);

          { zo niet, raporteer dit aan de bevoegde instanties }
          IF (Fout <> 0) THEN
          BEGIN
               LogExtraMessage ('Ignoring invalid name '+ZoekFile.Name);
               GOTO FindNextMessage;
          END;

          IF ((Zoekfile.Attr AND 1{readonly}) <> 0) THEN
          BEGIN
               LogMessage ('Skipping '+ZoekFile.Name+' (locked message)');
               GOTO FindNextMessage;
          END;

          { probeer het bericht te openen }
          IF (NOT FBufferOpen (InputFile,Config.FidoNetmailPath+ZoekFile.Name,MsgCacheSize,SizeOf (FidoStoredHeader))) THEN
          BEGIN
               LogMessage ('Failed to open '+Zoekfile.Name);
               GOTO CloseAndFindNextMessage;
          END;

          { probeer de header in te lezen }
          IF (NOT FBBlockRead (InputFile,FidoMsgHeader,SizeOf (FidoStoredHeader))) THEN
          BEGIN
               LogMessage ('Unable to read from '+Zoekfile.Name);
               GOTO CloseAndFindNextMessage;
          END;

          { maak eerst de interne bericht structuur leeg }
          MsgsEmpty;

          { vul dan opnieuw de header in }
          WITH FidoMsgHeader,Msg DO
          BEGIN
               Ready_F:=Local_Netmail;

               FromUser_F:=DeleteBackSpaces (StrPas (FromUserName));
               ToUser_F:=DeleteBackSpaces (StrPas (ToUserName));
               Subj_F:=DeleteBackSpaces (StrPas (Subject));
               Date_F:=FidoCorrectDate (DateTime);
               Cost_F:=Cost;
               Attr_F:=Attribute;

               { Let op ! Over het algemeen zetten alle editors rotzooi in }
               { de zone + point velden. Als er een zone in het bericht    }
               { staat halen we hem wel uit de MSGID ofzo.                 }

               WITH FromAddr_F DO
               BEGIN
                    Zone:=0;
                    Net:=origNet;
                    Node:=origNode;
                    Point:=0;
               END; { with }

               WITH ToAddr_F DO
               BEGIN
                    Zone:=0;
                    Net:=destNet;
                    Node:=destNode;
                    Point:=0;
               END; { with }
          END; { with }

          IF (Msg.FromUser_F = 'ARCmail') THEN
          BEGIN
               IF Config.LogDebug THEN
                  LogMessage ('Skipping '+Zoekfile.Name+' (from ARCmail)');

               GOTO CloseAndFindNextMessage;
          END;

          IF Config.LogDebug THEN
             LogMessage ('Import: From='+Word2String (Msg.FromAddr_F.Net)+'/'+Word2String (Msg.FromAddr_F.Node)+
                         ', To='+Word2String (Msg.ToAddr_F.Net)+'/'+Word2String (Msg.ToAddr_F.Node));

          { loop door het hele bericht regel voor regel heen }
          WHILE FBReadLnCR (InputFile,Regel) AND (Regel <> #0) DO
          BEGIN
               { RWI 960425: overgenomen }

               { soft CR's strippen }
               WHILE (Pos (#$8D,Regel) > 0) DO
                     Delete (Regel,Pos (#$8D,Regel),1);

               FidoAddLineToMessage (Regel,LastRegel);
          END; { while }

          FidoAddLastLine (LastRegel);

          { we no longer need the FBuffer cache, so we disable it }
          FBufferFreeCache (InputFile);

          { Als de FROM zone nog steeds nul is, probeer hem dan aan te }
          { vullen met de Area AKA                                     }
          IF (Msg.FromAddr_F.Zone = 0) THEN
             FidoMergeAdres (Config.NodeNrs[1],Msg.FromAddr_F);

          { Als de TO zone nog steeds nul is, probeer hem dan aan te }
          { vullen met de FROM zone.                                 }
          IF (Msg.ToAddr_F.Zone = 0) AND (Msg.FromAddr_F.Zone <> 0) THEN
             Msg.ToAddr_F.Zone:=Msg.FromAddr_F.Zone;

          { Verwerk het bericht alleen als het aan ons systeem gericht is }
          { en niet voor een listserver, areafix of ander gedrocht.       }

          { Controleer op de AKA waarvoor we willen importeren }
          IF NOT ( ((Address.Zone <> 0) AND FidoCompare (Address,Msg.ToAddr_F)) OR
                   ((Address.Zone =  0) AND FidoOurAdres (Msg.ToAddr_F))) THEN
          BEGIN
               GOTO CloseAndFindNextMessage;
          END;

          UserName:=UpCaseString (Msg.ToUser_F);

          IF (UserName = UpCaseString (Config.GatewayUser)) OR
             ListServerSearchName (UserName) OR
             (UserName = ListServer1) OR
             (UserName = ListServer2) OR
             (UserName = UpCaseString (Config.AreafixName)) OR
             IsCustomSkipName (UserName) OR
             (Config.FidoAcceptTO AND ((Pos ('@',UserName) > 0) OR (Pos ('!',UserName) > 0))) THEN
          BEGIN
               GOTO CloseAndFindNextMessage;
          END;

          {----------------------------------------------------------------------}
          { En hier deden we het dus voor, kijk naar welke message base het moet }

          Inc (TotalMsgs);

          { strip the local flag on all imported netmail, to prevent exporting }
          Msg.Attr_F:=Msg.Attr_F AND ($FFFF-MSGLOCAL);

          CASE AreaData.FidoMsgStyle OF
               JamType :
                   JamMsgBase.WriteMessage (AreaName,AreaData.FidoMsgPath);

               SquishType :
                   SquishMsgBase.SquishSaveMessage;

               WildCatType:
                   WildCatMsgBase.WriteMessage (AreaName,AreaData.FidoMsgPath);

              {PCBoardType :
                  PCBoardMsgBase.WriteMessage{(Msg,AreaName,AreaData.FidoMsgPath);}
          END; { case }

          FBufferClose (InputFile);

          { Als we de kill vlag gebruiken wordt het bericht na de import }
          { verwijderd uit de *.MSG directory.                           }
          IF (NOT ForceNoKill) THEN
          BEGIN
               {$I-} Erase (InputFile.Bestand); {$I+} IORes:=IOResult;
               IF (IORes <> 0) THEN
                  LogDiskIOError (IORes,'[FidoMsgImport] Unable to delete '+InputFile.Filename);
          END;

          GOTO FindNextMessage;

CloseAndFindNextMessage:

          FBufferClose (InputFile);

FindNextMessage:

          FindNext (ZoekFile);
     END; { while DosError == 0  }

     FindClose (ZoekFile);

     { RWI 960425: Fix: close the last used bases }
     SquishMsgBase.CloseBase;
     JamMsgBase.CloseBase;

     LogExtraMessage ('Imported '+Longint2String (TotalMsgs)+' messages.');

     IF Desktop THEN
        WindowPop; { message }

     MsgsEmpty;
END;


END.
