{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT FD;

{ FrontDoor.PAS                                                            }
{                                                                          }
{ Wat specifieke routines om een Frontdoor outbound directory bij te       }
{ kunnen houden. Zo moet er een lijst bijgehouden worden met het archive   }
{ waaraan we op dit moment pakketen aan moeten toevoegen etc.              }


INTERFACE

USES Database,
     DList;

TYPE FDOutboundRec = RECORD
                           FileName : STRING[79];
                           Node     : FidoAddrType;
                     END;

     FDOutboundRecPtr = ^FDOutBoundRec;

VAR FDOutboundList : List;

FUNCTION  FrontDoorGetOutboundFile (Destination_Dir : STRING; Node,Source : FidoAddrType; VAR NewAttachFile : BOOLEAN;
                                    QQQRecNr : UserBaseRecordNrType) : STRING;
PROCEDURE FrontDoorAddToList (Node : FidoAddrType; ArchiveName : STRING);
PROCEDURE FrontDoor_Done;


IMPLEMENTATION

USES Cfg,
     Dos,
     Fido,
     Ramon,
     Logs,
     Start,
     Globals;

{--------------------------------------------------------------------------}
{ FrontdoorAddToList                                                       }
{                                                                          }
{ Voegt een archive toe aan de lijst met bekende systemen.                 }
{ RWI 960219: onthoudt nu alle attached files voor iedere node.            }
{                                                                          }
PROCEDURE FrontDoorAddToList (Node : FidoAddrType; ArchiveName : STRING);

VAR TmpString : STRING[79];
    TmpRec    : FDOutboundRecPtr;
    Dir       : DirStr;
    Name      : NameStr;
    Ext       : ExtStr;

BEGIN
     FSplit (ArchiveName,Dir,Name,Ext);

     IF (Ext = '') THEN
     BEGIN
          {LogMessage ('[DEBUG1] Ignoring f/a: '+ArchiveName);}
          Exit;
     END;

     IF (Ext[1] = '.') THEN
        Delete (Ext,1,1);

     Ext:=UpCaseString (Ext);

     IF (Ext = 'PKT') THEN
     BEGIN
          {LogMessage ('[DEBUG2] Ignoring f/a: '+ArchiveName);}
          Exit;
     END;

     Ext:=Copy (Ext,1,2);

     IF NOT ((Ext = 'SU') OR (Ext = 'MO') OR (Ext = 'TU') OR
             (Ext = 'WE') OR (Ext = 'TH') OR (Ext = 'FR') OR (Ext = 'SA')) THEN
     BEGIN
          {LogMessage ('[DEBUG3] Ignoring f/a: '+ArchiveName);}
          Exit;
     END;

     { RWI 960402: controleer of de directory wel onze outbound is }
     IF (UpCaseString (Dir) <> Config.Outbound_F) THEN
     BEGIN
          {LogMessage ('[FdDebug4] Not my outbound: '+Dir);}
          Exit;
     END;

     (* RWI 960219: niet meer... we onthouden nu alle files
     { doorzoek de lijst op zoek naar eerdere kopie }
     TmpRec:=FDOutboundList.GetFirstItem;
     WHILE (TmpRec <> NIL) DO
     BEGIN
          IF FidoCompare (TmpRec^.Node,Node) THEN
          BEGIN
               TmpRec^.FileName:=ArchiveName;
               Exit;
          END;

          TmpRec:=FDOutboundList.GetNextItem;
     END; { while }

     { blijkbaar niet gevonden, voeg dan toe aan de lijst }
     *)

     GetMem (TmpRec,SizeOf (FDOutboundRec));

     TmpRec^.Node:=Node;
     TmpRec^.Filename:=ArchiveName;

     FDOutboundList.Add (TmpRec);
END;


{---------------------------------------------------------------------------}
{ FrontdoorGetOutboundFile                                                  }
{                                                                           }
{ Zoekt in de lijst naar de huidige outbound file voor een bepaalde node.   }
{ Als die niet gevonden wordt, probeert de routine een nieuwe te bedenken.  }
{ QQQRecNr wordt door de aanroeper meegegeven en is het record nummer van   }
{ het zendende systeem en wordt door deze routine doorgegeven aan           }
{ FidoGetExtension.                                                         }
{                                                                           }
FUNCTION FrontDoorGetOutboundFile (Destination_Dir : STRING; Node,Source : FidoAddrType; VAR NewAttachFile : BOOLEAN;
                                   QQQRecNr: UserBaseRecordNrType) : STRING;

VAR TmpString : STRING[79];
    TmpRec    : FDOutboundRecPtr;
    ZoekFile  : SearchRec;

BEGIN
     { RWI 961012: nu is het pas nodig om naar file attaches te zoeken! }
     ScanForFileAttaches;

     NewAttachFile:=FALSE; { geen nieuwe file aanmaken }

     { doorzoek de lijst op zoek naar eerdere kopie }
     TmpRec:=FDOutboundList.GetFirstItem;
     WHILE (TmpRec <> NIL) DO
     BEGIN
          IF FidoCompare (TmpRec^.Node,Node) THEN
          BEGIN
               { controleer of de file niet de pan uitgroeit }
               FindFirst (TmpRec^.FileName,$3C,ZoekFile);
               IF (DosError = 0) THEN
                  { Als de file niet gevonden kan worden, kan ie ook nooit te groot zijn ;-) }
                  IF (ZoekFile.Size > Config.MaxFidoArcLen) AND (Config.MaxFidoArcLen > 0) THEN
                  BEGIN
                       TmpRec^.Filename:=Copy (TmpRec^.FileName,1,Length (TmpRec^.FileName)-4)+
                                         FidoGetExtension (Copy (TmpRec^.FileName,1,Length (TmpRec^.FileName)-4),QQQRecNr,'');
                       NewAttachFile:=TRUE;
                  END;

               FindClose (ZoekFile);

               {LogMessage ('*** FD_Using: '+TmpRec^.Filename);}
               FrontDoorGetOutboundFile:=Copy (TmpRec^.FileName,Length (TmpRec^.FileName)-11,255);
               Exit;
          END;

          TmpRec:=FDOutboundList.GetNextItem;
     END;

     { Niet gevonden, aaagll... nu moeten we dus wat nieuws verzinnen }
     IF (Node.Point > 0) THEN
        { RWI 950618: Deze P lijkt nog wat problemen te veroorzaken! }
        { RWI 950627: vervangen door een 8. De net nummers moeten nu }
        {             32000 uit elkaar liggen om hier overheen te    }
        {             schrijven.                                     }
        TmpString:='8'+Copy (Word2HexString (Node.Node),2,3)+Word2HexString (Node.Point)
     ELSE
         TmpString:=Word2HexString (Source.Net-Node.Net)+
                    Word2HexString (Source.Node-Node.Node);

     { Maak er %OUTBOUND%\xxxxxxx.SU0 van }
     TmpString:=Destination_Dir+TmpString+FidoGetExtension (Destination_Dir+TmpString,QQQRecNr,'');
     NewAttachFile:=TRUE; { maak een nieuwe file aan }

     { en voeg 'm toe aan de lijst }
     GetMem (TmpRec,SizeOf (FDOutboundRec));

     TmpRec^.Node:=Node;
     TmpRec^.Filename:=TmpString;
     FDOutboundList.Add (TmpRec);
     FrontDoorGetOutboundFile:=Copy (TmpRec^.FileName,Length (TmpRec^.FileName)-11,255);
END;


{--------------------------------------------------------------------------}
{ FrontDoor_Done                                                           }
{                                                                          }
PROCEDURE FrontDoor_Done;
BEGIN
     FDOutboundList.Clear;
END;


{--------------------------------------------------------------------------}
{ unit initialization                                                      }
{                                                                          }
BEGIN
     FDOutboundList.Init (SizeOf (FDOutboundRec),NIL);
END.


