UNIT CheckCfg;

{ deze unit bevat alle code of de setup to controleren en eventuele }
{ suggesties te geven over de mogelijke problemen die kunnen        }
{ optreden met die fouten in place.                                 }

{ RWI961210, San Fransisco: Started this unit }

{ todo:

 - smarthost existance check
 - bag return system existance check
 - both area names filled in
 - existing aka's selected, not 0:0/0.0 akas
 - path filled in when msgbase selected
 - no e-mail addresses in domain fields
 - no system domain addresses filled in in user records
 - no uucpname fields left empty for uucp users
 - tunnel-to user needs compression set
 - no duplicate domain names in user records
 - volgorde rules in new newsgroups name filter file controleren en
   volgende situatie detecteren:
   ALT.*
   !ALT.BBS.*
   !ALT.BINARIES.*
 - controleren dat we zelf wel de node zijn van de points die gedefinieerd
   zijn. Oftewel: .0 moet in de system akas voorkomen.
}

INTERFACE

PROCEDURE CheckConfig;


IMPLEMENTATION

USES Ramon,
     Database,
     Cfg,
     Language,
     Fido;

VAR AllOk : BOOLEAN;


{--------------------------------------------------------------------------}
{ ListError                                                                }
{                                                                          }
PROCEDURE ListError (Msg : STRING; ActionCode : WORD);
BEGIN
     ListAddItem (' !! '+Msg,ActionCode,Bottom);
     AllOk:=FALSE;
END;


{--------------------------------------------------------------------------}
{ GoCheckSystem                                                            }
{                                                                          }
{ Checks the system configuration settings and everything underneath, or   }
{ basically everything that is in the WTRCFG.TDB file.                     }
{                                                                          }
PROCEDURE GoCheckSystem;

VAR FidoNul : FidoAddrType;

BEGIN
     ListAddItem ('--- Checking system configuration settings ---',0,Bottom);
     AllOk:=TRUE;

     IF (Config.SystemDir = '') THEN
        ListError ('System directory not specified',1);

     FidoSplit ('0',FidoNul);
     IF FidoCompare (Config.NodeNrs[1],FidoNul) THEN
        ListError ('First system node number not defined',2);

     IF (Config.Domains[1] = '') THEN
        ListError ('First system domain address not defined',3);

     IF AllOK THEN
        ListAddItem ('   No problems found',0,Bottom);
     ListAddItem ('',0,Bottom);
END;


{--------------------------------------------------------------------------}
{ GoCheckAreas                                                             }
{                                                                          }
PROCEDURE GoCheckAreas;
BEGIN
     ListAddItem ('--- Checking Area Definitions ---',0,Bottom);
     AllOk:=TRUE;

     IF AllOK THEN
        ListAddItem ('   No problems found',0,Bottom);
     ListAddItem ('',0,Bottom);
END;


{--------------------------------------------------------------------------}
{ GoCheckUsers                                                             }
{                                                                          }
PROCEDURE GoCheckUsers;
BEGIN
     ListAddItem ('--- Checking User Definitions ---',0,Bottom);
     AllOk:=TRUE;

     IF AllOK THEN
        ListAddItem ('   No problems found',0,Bottom);
     ListAddItem ('',0,Bottom);
END;


{--------------------------------------------------------------------------}
{ GoCheckLists                                                             }
{                                                                          }
PROCEDURE GoCheckLists;
BEGIN
     ListAddItem ('--- Checking Mailing List Definitions ---',0,Bottom);
     AllOk:=TRUE;

     IF AllOK THEN
        ListAddItem ('   No problems found',0,Bottom);
     ListAddItem ('',0,Bottom);
END;


{--------------------------------------------------------------------------}
{ GoCheckGroups                                                            }
{                                                                          }
PROCEDURE GoCheckGroups;
BEGIN
     ListAddItem ('--- Checking Group Definitions ---',0,Bottom);
     AllOk:=TRUE;

     IF AllOK THEN
        ListAddItem ('   No problems found',0,Bottom);
     ListAddItem ('',0,Bottom);
END;


{--------------------------------------------------------------------------}
{ GoCheckRouteTdb                                                          }
{                                                                          }
PROCEDURE GoCheckRouteTdb;
BEGIN
     ListAddItem ('--- Checking ROUTE.TDB configuration ---',0,Bottom);
     AllOk:=TRUE;

     IF AllOK THEN
        ListAddItem ('   No problems found',0,Bottom);
     ListAddItem ('',0,Bottom);
END;


{--------------------------------------------------------------------------}
{ GoCheckLang                                                              }
{                                                                          }
PROCEDURE GoCheckLang;
BEGIN
     ListAddItem ('--- Checking the Language file ---',0,Bottom);

     IF (NOT CheckLang (Config.SystemDir)) THEN
        ListAddItem ('   No problems found',0,Bottom);

     ListAddItem ('',0,Bottom);
END;


{--------------------------------------------------------------------------}
{ GoCheckTxts                                                              }
{                                                                          }
PROCEDURE GoCheckTxts;
BEGIN
     ListAddItem ('--- Checking TXT response file ---',0,Bottom);
     AllOk:=TRUE;

     IF AllOK THEN
        ListAddItem ('   No problems found',0,Bottom);
     ListAddItem ('',0,Bottom);
END;


{--------------------------------------------------------------------------}
{ CheckConfig                                                              }
{                                                                          }
{ Deze routine checkt alle mogelijke configuratie opties en geeft een      }
{ rapport.                                                                 }
{                                                                          }
PROCEDURE CheckConfig;

VAR Quit  : BOOLEAN;
    Keuze : WORD;
    Regel : STRING;

BEGIN
     ListDefine (1,2,80,Video.Rows-2,Default,'Configuration Integrity Check Report',0);

     GoCheckSystem;
     GoCheckAreas;
     GoCheckUsers;
     GoCheckLists;
     GoCheckGroups;
     GoCheckRouteTdb;
     GoCheckLang;
     GoCheckTxts;

     Quit:=FALSE;
     REPEAT
           Keuze:=ListSelect (NoTag,[]);

           CASE Key OF
                kEsc : Quit:=TRUE;

                kRet :
                    BEGIN
                         CASE Keuze OF
                              0 :; { geen actie }
                              1 : {ChangeSystemSettings (2)};
                              2 : {ChangeFidoSettingsAddr (1)};
                              3 : {ChangeUUCPSettings (7)};
                         END; { case }

                         Regel:=ListGetItemTekst (Keuze);
                         IF (Copy (Regel,1,4) = ' !! ') THEN
                         BEGIN
                              Regel:=' ?? '+Copy (Regel,5,255);
                              ListSetItemTekst (Keuze,Regel);
                         END;
                    END;
           END; { case }

     UNTIL Quit;

     ListErase;
END;

END.