UNIT CfgEdit;

{ All WtrConf routines to edit the System Configuration }

{ Started RAWI 970223 while replacing the system menu structure }
{ in an attempt to reduce the size of cfg.pas.                  }

INTERFACE

PROCEDURE EditSystemConfig;


IMPLEMENTATION

USES Ramon,
     Database,
     Msgs,
     Fido,
     Cfg,
     DupeChk,
     Globals,
     Dos;

VAR LastSelectedAFixGroup : GroupNrType;
    EditAFixEntry         : BYTE;
    GatewayAkaStr         : FidoAddrString;


{==========================================================================}
{==                                                                      ==}
{==                         GLOBAL SETTINGS                              ==}
{==                                                                      ==}
{==========================================================================}


{--------------------------------------------------------------------------}
{ ChangeColors                                                             }
{                                                                          }
{ Deze routine kan gebruikt worden om de kleuren die WaterGate gebruikt te }
{ veranderen.                                                              }
{                                                                          }
PROCEDURE ChangeColors; FAR;

    {----------------------------------------------------------------------}
    { EditOneColor                                                         }
    {                                                                      }
    PROCEDURE EditOneColor (ColorNr : BYTE);

    CONST Xb = 10;
          Yb = 7;

    VAR Lp      : BYTE;
        Attr    : BYTE;
        Quit    : BOOLEAN;
        C,PrevC,
        R,PrevR : BYTE;
        X,Y     : XYType;

    BEGIN
         PushKeysLine;
         WriteKeysLine (' ^Esc Abort  ^F10 Accept  ^Left/Right Change ^Up/Down Foreground/Background');

         WindowPush (Xb,Yb,65,12);
         BoxDraw (Double,Xb,Yb,65,12);

         WriteXY (Xb+2,Yb+2,'Foreground');
         WriteXY (Xb+2,Yb+5,'Background');

         FOR Lp:=0 TO 15 DO
         BEGIN
              ModifyColor (cCustom1,Lp);
              WriteXYC (Xb+15+Lp*3,Yb+2,cCustom1,'');

              ModifyColor (cCustom1,Lp*16);
              WriteXYC (Xb+15+Lp*3,Yb+5,cCustom1,'  ');
         END;

         Attr:=Config.Colors[ColorNr];

         R:=1;
         C:=Attr AND 15;
         PrevR:=2;
         PrevC:=255;

         SetLines (Single);

         Quit:=FALSE;
         REPEAT
               IF (PrevR <> R) OR (PrevC <> C) THEN
               BEGIN
                    SetColor (cBoxBack);

                    { oude verwijderen }
                    IF (PrevC <> 255) THEN
                    BEGIN
                         Y:=Yb+PrevR*3-2;
                         X:=Xb+14+PrevC*3;

                         WriteXY (X,Y,'    ');
                         WriteXY (X,Y+1,' ');
                         WriteXY (X+3,Y+1,' ');
                         WriteXY (X,Y+2,'    ');
                    END;

                    { nieuwe tekenen }

                    Y:=Yb+R*3-2;
                    X:=Xb+14+C*3;

                    WriteXY (X,Y,LB+HO+HO+RB);
                    WriteXY (X,Y+1,VR);
                    WriteXY (X+3,Y+1,VR);
                    WriteXY (X,Y+2,LON+HO+HO+RO);

                    PrevC:=C;
                    PrevR:=R;

                    WriteXY (Xb+5,Yb+8,Byte2HexString (Attr));

                    ModifyColor (cCustom1,Attr);
                    SetColor (cCustom1);
                    WriteXY (Xb+15,Yb+8,' This is in the selected color ');
               END;

               CASE ReadKey OF
                    kF10 :
                        BEGIN
                             Config.Colors[ColorNr]:=Attr;
                             Quit:=TRUE;
                        END;

                    kEsc :
                        Quit:=TRUE;

                    kUp :
                        IF (R = 2) THEN
                        BEGIN
                             R:=1;
                             C:=Attr AND 15;
                        END;

                    kDown :
                        IF (R = 1) THEN
                        BEGIN
                             R:=2;
                             C:=Attr SHR 4;
                        END;

                    kRight :
                        IF (C < 15) THEN
                        BEGIN
                             Inc (C);
                             IF (R = 1) THEN
                                Inc (Attr)
                             ELSE
                                 Inc (Attr,16);
                        END;

                    KLeft :
                        IF (C > 0) THEN
                        BEGIN
                             Dec (C);
                             IF (R = 1) THEN
                                Dec (Attr)
                             ELSE
                                 Dec (Attr,16);
                        END;

               END; { case }

         UNTIL Quit;

         WindowPop;
         PopKeysLine;
    END;


    {----------------------------------------------------------------------}
    { QuickEntry                                                           }
    {                                                                      }
    PROCEDURE QuickEntry;

    CONST Xb = 10;
          Yb = 7;
          Xl = 65;
          Yl = 7;

    VAR Lp         : BYTE;
        CurrentStr,
        QuickStr   : STRING[21*2];

    BEGIN
         WindowPush (Xb,Yb,Xl,Yl);
         BoxDraw (Double,Xb,Yb,Xl,Yl);

         WriteXY (Xb+2,Yb+2,'Current selection:');
         WriteXY (Xb+2,Yb+4,'Quick new entry:');

         CurrentStr:='';
         FOR Lp:=1 TO 21 DO
             CurrentStr:=CurrentStr+Byte2HexString (Config.Colors[Lp]);

         WriteXYC (Xb+21,Yb+2,cBoxData,CurrentStr);

         QuickStr:=CurrentStr;

         FieldPushAll;

         FieldInit;
         FieldDefineOne (1,Xb+21,Yb+4,21*2,0,0,@QuickStr,RepChar (21*2,'$'));

         FieldEditKeysLine:=' ^F1 Help  ^Enter Accept  ^Esc Restore old';

         FieldEditDirect;

         FieldEditKeysLine:=ORG_FieldEditKeysLine;

         IF (Key <> kEsc) THEN
         BEGIN
              FOR Lp:=1 TO 21 DO
              BEGIN
                   Config.Colors[Lp]:=HexString2Long (Copy (QuickStr,1,2));
                   Delete (QuickStr,1,2);
              END;
         END;

         FieldPopAll;

         WindowPop;
    END;

    {----------------------------------------------------------------------}
    { SelectSet                                                            }
    {                                                                      }
    PROCEDURE SelectSet;

    CONST GrayishSet : ARRAY[1..21] OF BYTE = ($78,$70,$7F,$7E,$7E,$08,$7F,
                                               $4E,$2F,$74,$70,$F4,$6F,$6E,
                                               $6B,$7A,$4F,$78,$2F,$2A,$7E);

    CONST BlackSet : ARRAY[1..21] OF BYTE = ($80,$03,$07,$03,$03,$08,$0F,
                                             $4E,$0B,$0B,$03,$84,$3F,$3E,
                                             $31,$1A,$4F,$08,$4C,$CF,$4E);

    VAR Keuze  : WORD;
        Search : SearchRec;
        InFile : TEXT;
        IORes  : BYTE;
        Regel  : STRING[80];
        Lp     : BYTE;

    BEGIN
         ListDefine (10,5,50,Video.Rows-8,Default,'Select a built in color set',0);
         ListAddItem ('WaterGate Standard',1,Bottom);
         ListAddItem ('Sunny',2,Bottom);
         ListAddItem ('Dark Room',3,Bottom);

         Keuze:=1000;
         FindFirst (DeleteBackSpaces (Config.SystemDir)+'*.WCS',Archive+ReadOnly,Search);
         WHILE (DosError = 0) DO
         BEGIN
              ListAddItem (Search.Name,Keuze,Bottom);
              Inc (Keuze);
              FindNext (Search);
         END;

         Keuze:=ListSelect (NoTag,[]);

         IF (Key <> kEsc) THEN
            CASE Keuze OF
                 1 : RestoreSystemColors;
                 2 : Move (GrayishSet,Config.Colors,21);
                 3 : Move (BlackSet,Config.Colors,21);

                 ELSE BEGIN
                           Assign (InFile,DeleteBackSpaces (Config.SystemDir)+ListGetItemTekst (Keuze));
                           {$I-} Reset (InFile); {$I+} IORes:=IOResult;
                           IF (IORes <> 0) THEN
                              Error ('Could not read from file')
                           ELSE BEGIN
                                ReadLn (InFile,Regel);
                                Close (InFile);

                                FOR Lp:=1 TO 21 DO
                                    Config.Colors[Lp]:=HexString2Long (Copy (Regel,Lp*2-1,2));
                           END;
                      END;
            END;

         ListErase;
    END;

{ChangeColors}

VAR Quit  : BOOLEAN;
    Keuze : WORD;

BEGIN
     ListNoTagKeysLine:=ORG_ListNoTagKeysLine+'  ^F2 Quick Entry  ^F3 Select Set';

     ListDefine (2,3,80,Video.Rows-4,Default,'Select a color',1009);

     ListAddItem ('Desktop: background',1,Bottom);
     ListAddItem ('Desktop: title',2,Bottom);
     ListAddItem ('Window: border, no focus',3,Bottom);
     ListAddItem ('Window: border, focus',4,Bottom);
     ListAddItem ('Window: background',5,Bottom);
     ListAddItem ('Window: shadow',6,Bottom);
     ListAddItem ('Window: text',7,Bottom);
     ListAddItem ('Message: error',8,Bottom);
     ListAddItem ('Message: normal',9,Bottom);
     ListAddItem ('Keys line: key name',10,Bottom);
     ListAddItem ('Keys line: key description',11,Bottom);
     ListAddItem ('Keys line: blinking text',12,Bottom);
     ListAddItem ('Help: window',13,Bottom);
     ListAddItem ('Help: highlighted',14,Bottom);
     ListAddItem ('Help: link',15,Bottom);
     ListAddItem ('List: Tagged item',16,Bottom);
     ListAddItem ('List: Not taggable item',17,Bottom);
     ListAddItem ('Disabled field',18,Bottom);
     ListAddItem ('Cursor bar',19,Bottom);
     ListAddItem ('Cursor bar on tagged item',20,Bottom);
     ListAddItem ('Selected menu/list item',21,Bottom);

     Quit:=FALSE;
     REPEAT
           ActivateColors;

           Keuze:=ListSelect (NoTag,[kF2,kF3]);

           CASE Key OF
                kEsc : Quit:=TRUE;

                kRet : EditOneColor (Keuze);

                kF2 : QuickEntry;

                kF3 : SelectSet;

           END; { case }

     UNTIL Quit;

     ListErase;

     ListNoTagKeysLine:=ORG_ListNoTagKeysLine;
END;


{--------------------------------------------------------------------------}
{ CheckHandles                                                             }
{                                                                          }
FUNCTION CheckHandles (BufferPtr : StringPtr) : BOOLEAN; FAR;

VAR Nr  : BYTE;
    Nop : ValNop;

BEGIN
     Val (DeleteFrontAndBackSpaces (BufferPtr^),Nr,Nop);

     IF (Nop <> 0) THEN
        Nr:=8; { default }

     IF (Nr = 0) THEN
        Nr:=1;

     IF (Nr > MostHandles) THEN
     BEGIN
          Error ('Maximum allowed value is '+Word2String (MostHandles));
          Nr:=MostHandles;
     END;

     BufferPtr^:=AddUpWithSpaces (3,Byte2String (Nr));
     Config.MaxHandles:=Nr;

     CheckHandles:=TRUE;
END;


{--------------------------------------------------------------------------}
{ ChangeAdvancedSettings                                                   }
{                                                                          }
PROCEDURE ChangeAdvancedSettings; FAR;

CONST Xb = 6;
      Yb = 14;
      Xl = 28;
      Yl = 5;

      Xb2 = Xb+20;

VAR FieldY        : XYType;
    MaxHandlesStr : STRING[3];

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     MaxHandlesStr:=AddUpWithSpaces (3,Byte2String (Config.MaxHandles));
     FieldY:=Yb+1;

     WriteXY (Xb+2,FieldY,'Max. files open');
     FieldAutoDefineCheckOne (Xb2,FieldY,@MaxHandlesStr,'%%%',CheckHandles);
     FieldSetHelp (0,1015);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Cache .TDB files');
     FieldAutoDefineToggles (Xb2,FieldY,Config.CacheTdbs,'no|yes',0);
     FieldSetHelp (0,1016);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Time slicing');
     FieldAutoDefineToggles (Xb2,FieldY,Config.TimeSlicing,'no|yes',0);
     FieldSetHelp (0,1613);

     FieldEdit;

     FieldPopAll;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ GraySwapFields                                                           }
{                                                                          }
PROCEDURE GraySwapFields; FAR;
BEGIN
     IF Config.UseSwapFile THEN
     BEGIN
          FieldEnableField (2);
          FieldEnableField (3);
     END ELSE
     BEGIN
          FieldDisableField (2);
          FieldDisableField (3);
     END;

     FieldUpdateOneField (2);
     FieldUpdateOneField (3);
END;


{--------------------------------------------------------------------------}
{ CheckSwapSize                                                            }
{                                                                          }
FUNCTION CheckSwapSize (BufferPtr : StringPtr) : BOOLEAN; FAR;

VAR Nr  : BYTE;
    Nop : ValNop;

BEGIN
     Val (DeleteFrontAndBackSpaces (BufferPtr^),Nr,Nop);

     IF (Nop <> 0) OR (Nr = 0) THEN
        Nr:=2;

     BufferPtr^:=AddUpWithSpaces (2,Byte2String (Nr));
     Config.SwapFileSize:=Nr;

     CheckSwapSize:=TRUE;
END;


{--------------------------------------------------------------------------}
{ ChangeSwapFileSettings                                                   }
{                                                                          }
PROCEDURE ChangeSwapFileSettings; FAR;

CONST Xb = 8;
      Yb = 13;
      Xl = 64;
      Yl = 5;

VAR SwapSizeStr : STRING[2];

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     IF (Config.SwapfileSize > 99) THEN
        Config.SwapfileSize:=99; { just in case }

     SwapSizeStr:=AddUpWithSpaces (2,Byte2String (Config.SwapfileSize));

     WriteXY (Xb+2,Yb+1,'Use swap file?');
     FieldAutoDefineTogglesCall (Xb+20,Yb+1,Config.UseSwapfile,'no|yes',0,GraySwapFields);
     FieldSetHelp (0,1610);

     WriteXY (Xb+2,Yb+2,'Swap file path');
     FieldAutoDefineCheckLongOne (Xb+20,Yb+2,42,@Config.SwapfilePath,RepChar (MaxLenPath,'@'),CheckFileAndPathFunc);
     FieldSetHelp (0,1611);

     WriteXY (Xb+2,Yb+3,'Swap file size');
     FieldAutoDefineCheckOne (Xb+20,Yb+3,@SwapSizeStr,'##',CheckSwapSize);
     FieldSetHelp (0,1612);

     GraySwapFields;

     FieldEdit;

     FieldPopAll;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ ChangeLogfileSettings_DebugHasChanged                                    }
{                                                                          }
PROCEDURE ChangeLogfileSettings_DebugHasChanged; FAR;

VAR Lp : BYTE;

BEGIN
     FOR Lp:=2 TO MaxFields DO { gewoon alle andere velden... }
     BEGIN
          IF (Config.LogDebug) THEN
             FieldDisableField (Lp)
          ELSE
              FieldEnableField (Lp);

          FieldUpdateOneField (Lp);
     END;
END;


{--------------------------------------------------------------------------}
{ ChangeLogfileSettings                                                    }
{                                                                          }
{ Met deze routine kunnen de booleans gezet worden die bijhouden wat er in }
{ de logfile komt te staan.                                                }
{                                                                          }
PROCEDURE ChangeLogfileSettings; FAR;

CONST Xb = 25;
      Yb = 3;
      Xl = 37;
      Yl = 21;

      Xb2 = Xb+29;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     WriteXY (Xb+2,Yb+1,'Debug (=all to YES)');
     FieldAutoDefineTogglesCall (Xb2,Yb+1,Config.LogDebug,'no|yes',0,ChangeLogfileSettings_DebugHasChanged);
     FieldSetHelp (0,4210);

     WriteXY (Xb+2,Yb+3,'Tossing .X and .D files');
     FieldAutoDefineToggles (Xb2,Yb+3,Config.LogSpoolTossed,'no|yes',0);
     FieldSetHelp (0,4211);

     WriteXY (Xb+2,Yb+4,'Extracting Fido archives');
     FieldAutoDefineToggles (Xb2,Yb+4,Config.LogFidoExtract,'no|yes',0);
     FieldSetHelp (0,4212);

     WriteXY (Xb+2,Yb+5,'Tossing Fido .PKT files');
     FieldAutoDefineToggles (Xb2,Yb+5,Config.LogFidoTossed,'no|yes',0);
     FieldSetHelp (0,4213);

     WriteXY (Xb+2,Yb+6,'Address translation F->U');
     FieldAutoDefineToggles (Xb2,Yb+6,Config.LogTranslationFU,'no|yes',0);
     FieldSetHelp (0,4214);

     WriteXY (Xb+2,Yb+7,'New newsgroup names check');
     FieldAutoDefineToggles (Xb2,Yb+7,Config.LogCheckFilter,'no|yes',0);
     FieldSetHelp (0,4215);

     WriteXY (Xb+2,Yb+8,'Incomplete .X address fix');
     FieldAutoDefineToggles (Xb2,Yb+8,Config.LogXFix,'no|yes',0);
     FieldSetHelp (0,4216);

     WriteXY (Xb+2,Yb+9,'Copied headers F->U');
     FieldAutoDefineToggles (Xb2,Yb+9,Config.LogCopyHeaders,'no|yes',0);
     FieldSetHelp (0,4217);

     WriteXY (Xb+2,Yb+10,'Illegal copy headers');
     FieldAutoDefineToggles (Xb2,Yb+10,Config.LogIllegalHeaders,'no|yes',0);
     FieldSetHelp (0,4218);

     WriteXY (Xb+2,Yb+11,'Area/newsfix processing');
     FieldAutoDefineToggles (Xb2,Yb+11,Config.LogAreaFix,'no|yes',0);
     FieldSetHelp (0,4219);

     WriteXY (Xb+2,Yb+12,'Applied mapping statements');
     FieldAutoDefineToggles (Xb2,Yb+12,Config.LogMapApply,'no|yes',0);
     FieldSetHelp (0,4220);

     WriteXY (Xb+2,Yb+13,'Importing of netmail');
     FieldAutoDefineToggles (Xb2,Yb+13,Config.LogNetmailImport,'no|yes',0);
     FieldSetHelp (0,4221);

     WriteXY (Xb+2,Yb+14,'Read-only denied postings');
     FieldAutoDefineToggles (Xb2,Yb+14,Config.LogRODeny,'no|yes',0);
     FieldSetHelp (0,4222);

     WriteXY (Xb+2,Yb+15,'Each message from a .PKT');
     FieldAutoDefineToggles (Xb2,Yb+15,Config.LogPktEachEcho,'no|yes',0);
     FieldSetHelp (0,4223);

     WriteXY (Xb+2,Yb+16,'Created UUCP jobs');
     FieldAutoDefineToggles (Xb2,Yb+16,Config.LogUUCPOutbound,'no|yes',0);
     FieldSetHelp (0,4224);

     WriteXY (Xb+2,Yb+17,'Created SMTP jobs');
     FieldAutoDefineToggles (Xb2,Yb+17,Config.LogSMTPOutbound,'no|yes',0);
     FieldSetHelp (0,4225);

     WriteXY (Xb+2,Yb+18,'Exported messages');
     FieldAutoDefineToggles (Xb2,Yb+18,Config.LogExportedMsgs,'no|yes',0);
     FieldSetHelp (0,4226);

     WriteXY (Xb+2,Yb+19,'Article newsgroups');
     FieldAutoDefineToggles (Xb2,Yb+19,Config.LogErrNewsgroups,'no|yes',0);
     FieldSetHelp (0,4227);

     { hier nieuwe velden bijvoegen }

     {
     WriteXY (Xb+2,Yb+Yl-2,'(more to come in future releases)');
     }

     ChangeLogfileSettings_DebugHasChanged; { initial graying }

     FieldEdit;
     FieldPopAll;

     WindowPop;
END;


{--------------------------------------------------------------------------}
{ CheckDupes                                                               }
{                                                                          }
FUNCTION CheckDupes (BufferPtr : StringPtr) : BOOLEAN; FAR;

VAR Nr  : WORD;
    Nop : ValNop;

BEGIN
     Val (DeleteFrontAndBackSpaces (BufferPtr^),Nr,Nop);

     IF (Nop <> 0) THEN
        Nr:=10000; { default }

     IF (Nr > MAXDUPECHECKS) THEN
     BEGIN
          Error ('Maximum allowed value is '+Word2String (MAXDUPECHECKS));
          Nr:=MaxDupeChecks;
     END;

     BufferPtr^:=AddUpWithSpaces (5,Word2String (Nr));
     Config.DupeChecks:=Nr;

     CheckDupes:=TRUE;
END;


{--------------------------------------------------------------------------}
{ GrayDupeChecks                                                           }
{                                                                          }
PROCEDURE GrayDupeChecks; FAR;
BEGIN
     IF Config.DoDupeChk THEN
        FieldEnableField (6)
     ELSE
         FieldDisableField (6);

     FieldUpdateOneField (6);
END;


{--------------------------------------------------------------------------}
{ CheckMinDiskFree                                                         }
{                                                                          }
FUNCTION CheckMinDiskFree (BufferPtr : StringPtr) : BOOLEAN; FAR;

VAR Nop : ValNop;

BEGIN
     Val (DeleteFrontAndBackSpaces (BufferPtr^),Config.MinimumDiskFree,Nop);
     IF (Nop <> 0) THEN
        Config.MinimumDiskFree:=0;

     BufferPtr^:=AddUpWithSpaces (2,Byte2String (Config.MinimumDiskFree));

     CheckMinDiskFree:=TRUE;
END;


{--------------------------------------------------------------------------}
{ CheckDiskFreeDrives                                                      }
{                                                                          }
FUNCTION CheckDiskFreeDrives (BufferPtr : StringPtr) : BOOLEAN; FAR;

VAR Lp   : BYTE;
    D    : CHAR;
    Temp : STRING[26];

BEGIN
     Temp:='';

     FOR Lp:=0 TO 25 DO
     BEGIN
          D:=Chr (Ord ('A')+Lp);

          IF (Pos (D,BufferPtr^) > 0) THEN
             Temp:=Temp+D;
     END;

     BufferPtr^:=AddUpWithSpaces (26,Temp);

     CheckDiskFreeDrives:=TRUE;
END;


{--------------------------------------------------------------------------}
{ LogFileMgr                                                               }
{                                                                          }
{ Laat een file/directory uitzoeken en voeg "wtrgate.log" toe als alleen   }
{ een logfile gekozen is.                                                  }
{                                                                          }
PROCEDURE LogFileMgr (BufferPtr : StringPtr); FAR;
BEGIN
     BufferPtr^:=FileManager (DeleteFrontAndBackSpaces (BufferPtr^),'','*.*');
     IF (BufferPtr^[Length (BufferPtr^)] = '\') THEN
        BufferPtr^:=BufferPtr^+'WTRGATE.LOG';
     BufferPtr^:=AddUpWithSpaces (MaxLenPath,BufferPtr^);
END;


{--------------------------------------------------------------------------}
{ EditGlobalSettings                                                       }
{                                                                          }
PROCEDURE EditGlobalSettings;

CONST Xb  = 3;
      Yb  = 3;
      Xl  = 75;
      Yl  = 14;

      Xb2 = Xb+21;

VAR FieldY         : XYType;
    DupeCheckStr   : STRING[5];
    MinDiskFreeStr : STRING[2];

BEGIN
     FixConfigRecord;

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldInit;

     DupeCheckStr:=AddUpWithSpaces (5,Word2String (Config.DupeChecks));
     MinDiskFreeStr:=AddUpWithSpaces (2,Byte2String (Config.MinimumDiskFree));

     FieldY:=Yb+1;

     WriteXY (Xb+2,FieldY,'Sysop name');
     FieldAutoDefineOne (Xb2,FieldY,@Config.Sysop,RepChar(MaxLenSysopName,'$'));
     FieldSetHelp (0,1011);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'System path');
     FieldAutoDefineFileMgr (Xb2,FieldY,52,@Config.SystemDir,PathFileMgr);
     FieldSetHelp (0,1012);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Log file path');
     FieldAutoDefineFileMgr (Xb2,FieldY,52,@Config.LogFilePath,LogFileMgr);
     FieldSetHelp (0,1018);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Oversized path');
     FieldAutoDefineFileMgr (Xb2,FieldY,52,@Config.TooLargePath,PathFileMgr);
     FieldSetHelp (0,1017);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Dupe checking');
     FieldAutoDefineTogglesCall (Xb2,FieldY,Config.DoDupeChk,'no|yes',0,GrayDupeChecks);
     FieldSetHelp (0,1013);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Dupe checks');
     FieldAutoDefineCheckOne (Xb2,FieldY,@DupeCheckStr,'%%%%%',CheckDupes);
     FieldSetHelp (0,1014);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Minimum disk free');
     WriteXY (Xb2+3,FieldY,'Mb');
     FieldAutoDefineCheckOne (Xb2,FieldY,@MinDiskFreeStr,'$$',CheckMinDiskFree);
     FieldSetHelp (0,1614);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Drives to check');
     FieldAutoDefineCheckOne (Xb2,FieldY,@Config.DiskFreeDrives,RepChar (26,'@'),CheckDiskFreeDrives);
     FieldSetHelp (0,1615);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Log file settings');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,ChangeLogFileSettings);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Swap file settings');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,ChangeSwapFileSettings);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Advanced settings');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,ChangeAdvancedSettings);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Colors');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,ChangeColors);

     GrayDupeChecks;

     FieldEdit;

     WindowPop;
     UnfixConfigRecord;
END;


{==========================================================================}
{==                                                                      ==}
{==                         FTN SETTINGS                                 ==}
{==                                                                      ==}
{==========================================================================}


{--------------------------------------------------------------------------}
{ EditOneSystemNodeNr                                                      }
{                                                                          }
PROCEDURE EditOneSystemNodeNr (Aka : AkaIndexType);

CONST Xb = 12;
      Yb =  7;
      Xl = MaxLenFidoAddrString+16;
      Yl =  4;

VAR FidoStr  : FidoAddrString;
    PointStr : STRING[5];
    Nop      : ValNop;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     FidoStr:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (Config.NodeNrs[Aka]));
     PointStr:=AddUpWithSpaces (5,Word2String (Config.PointNets[Aka]));

     WriteXY (Xb+2,Yb+1,'Node number');
     FieldAutoDefineCheckOne (Xb+14,Yb+1,@FidoStr,RepChar (MaxLenFidoAddrstring,'$'),CheckFidoAddr);
     FieldSetHelp (1,1021);

     WriteXY (Xb+2,Yb+2,'Point net');
     FieldAutoDefineCheckOne (Xb+14,Yb+2,@PointStr,'%%%%%',FieldCheckWordFunc);
     FieldSetHelp (2,1021);

     FieldEdit;

     FidoSplit (DeleteBackSpaces (FidoStr),Config.NodeNrs[Aka]);
     Val (DeleteBackSpaces (PointStr),Config.PointNets[Aka],Nop);

     FieldPopAll;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ EditSystemNodeNrs                                                        }
{                                                                          }
PROCEDURE EditSystemNodeNrs; FAR;

VAR AkaLp   : AkaIndexType;
    FieldNr : FieldNrType;
    Keuze   : WORD;
    Quit    : BOOLEAN;
    Prev,
    Next    : FieldNrType;

BEGIN
     { Het zelfde als eerst, maar nu via een select lijst }
     ListDefine (3,3,70,Video.Rows-4,Default,'System node numbers',1021);

     FOR AkaLp:=1 TO MaxAkas DO
         ListAddItem (AddUpWithSpaces (50,Fido2Str (Config.NodeNrs[AkaLp]))+
                      AddUpWithPreSpaces (5,Word2String (Config.PointNets[Akalp])),AkaLp,Bottom);

     ListShow (Double,FALSE);

     Quit:=FALSE;
     REPEAT
           Keuze:=ListSelect (NoTag,[]);

           CASE Key OF
                kEsc : Quit:=TRUE;

                kRet : BEGIN
                            EditOneSystemNodeNr (Keuze);
                            ListSetItemTekst (Keuze,AddUpWithSpaces (50,Fido2Str (Config.NodeNrs[Keuze]))+
                                                    AddUpWithPreSpaces (5,Word2String (Config.PointNets[Keuze])));
                       END;
           END; { case }

     UNTIL Quit;

     ListErase;
END;


{--------------------------------------------------------------------------}
{ EditFTNArchivers                                                         }
{                                                                          }
PROCEDURE EditFTNArchivers; FAR;

CONST Xb = 28;
      Yb = 4;
      Xl = 47;
      Yl = 18;

VAR ComprLp : CompressionType;
    FieldY  : XYType;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     FieldY:=Yb;

     FOR ComprLp:=ARC{=0} TO OP1 DO
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,ComprDescr[ComprLp]);
          FieldAutoDefineLongOne (Xb+10,FieldY,35,
                                  @Config.ComprPrgs_F[Compr,ComprLp],
                                  RepChar (MaxLenComprPrgDescr,'$'));
          FieldSetHelp (0,1060);

          IF (ComprLp <> OP1) THEN
          BEGIN
               Inc (FieldY);
               WriteXY (Xb+2,FieldY,'UN'+ComprDescr[ComprLp]);
               FieldAutoDefineLongOne (Xb+10,FieldY,35,
                                       @Config.ComprPrgs_F[DeCompr,ComprLp],
                                       RepChar (MaxLenComprPrgDescr,'$'));
               FieldSetHelp (0,1060);
          END;
     END;

     { GUS Support - We kunnen alleen maar uitpakken met een onbekend formaat }
     Inc (FieldY);
     WriteXY (Xb+2,FieldY,ComprDescr[GUS]);
     FieldAutoDefineLongOne (Xb+10,FieldY,35,
                             @Config.ComprPrgs_F[DeCompr,GUS],
                             RepChar (MaxLenComprPrgDescr,'$'));
     FieldSetHelp (0,1061);

     FieldEdit;

     FieldPopAll;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ SelectAFixGroup                                                          }
{                                                                          }
PROCEDURE SelectAFixGroup; FAR;

VAR Keuze     : WORD;
    Lp        : GroupNrType;
    GroupData : GroupDescRecord;

BEGIN
     ListDefine (Video.Cols-3,3,Video.Cols-10,Video.Rows-4,TopRight,'Select a group',0);

     FOR Lp:=1 TO MaxGroups DO
     BEGIN
          ReadGroupDescRecord (Lp,GroupData);
          ListAddItem (BuildGroupDesc (Lp,GroupData),Lp,Bottom);
     END;

     ListSetCursorOnItem (LastSelectedAFixGroup);

     Keuze:=ListSelect (NoTag,[]);

     IF (Key = kRet) THEN
     BEGIN
          ReadGroupDescRecord (Keuze,GroupData);
          GroupListDesc:=AddUpWithSpaces (30+4,BuildSingleGroupDesc (Keuze)+': '+GroupData.GroupDesc);
          LastSelectedAFixGroup:=Keuze;
     END;

     ListErase;
END;


{--------------------------------------------------------------------------}
{ GrayUnconditional                                                        }
{                                                                          }
PROCEDURE GrayUnconditional; FAR;
BEGIN
     IF (Config.AreaFixForward[EditAFixEntry].Unconditional) THEN
     BEGIN
          FieldDisableField (3);
          FieldDisableField (4);
     END ELSE
     BEGIN
          FieldEnableField (3);
          FieldEnableField (4);
     END;

     FieldUpdateOneField (3);
     FieldUpdateOneField (4);
END;


{--------------------------------------------------------------------------}
{ AreaListFileMgr                                                          }
{                                                                          }
PROCEDURE AreaListFileMgr (BufferPtr : StringPtr); FAR;
BEGIN
     BufferPtr^:=AddUpWithSpaces (50,FileManager (DeleteFrontAndBackSpaces (BufferPtr^),'','*.*'));
END;


{--------------------------------------------------------------------------}
{ EditAreafixForward                                                       }
{                                                                          }
{ Edit een Areafix forward record in de configuratie.                      }
{                                                                          }
PROCEDURE EditAreafixForward;

CONST Xb = 8;
      Yb = 6;
      Xl = 68;
      Yl = 10;

VAR FidoStr   : FidoAddrString;
    GroupData : GroupDescRecord;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     WITH Config.AreaFixForward[EditAFixEntry] DO
     BEGIN
          FidoStr:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (UplinkAddress));

          ReadGroupDescRecord (Group,GroupData);
          GroupListDesc:=AddUpWithSpaces (30+4,BuildSingleGroupDesc (Group)+': '+GroupData.GroupDesc);
          LastSelectedAFixGroup:=Group;

          WriteXY (Xb+2,Yb+1,'Address');
          FieldAutoDefineCheckOne (Xb+16,Yb+1,@FidoStr,RepChar (MaxLenFidoAddrstring,'$'),CheckFidoAddr);
          FieldSetHelp (0,4101);

          WriteXY (Xb+2,Yb+2,'Unconditional');
          FieldAutoDefineTogglesCall (Xb+16,Yb+2,Unconditional,'no|yes',0,GrayUnconditional);
          FieldSetHelp (0,4102);

          WriteXY (Xb+2,Yb+3,'Arealist path');
          FieldAutoDefineFileMgr (Xb+16,Yb+3,50,@AreaListPath,AreaListFileMgr);
          FieldSetHelp (0,4103);

          WriteXY (Xb+2,Yb+4,'Arealist type');
          FieldAutoDefineToggles (Xb+16,Yb+4,AreaList,'areas.bbs|name-list',0);
          FieldSetHelp (0,4104);

          WriteXY (Xb+2,Yb+5,'Area manager');
          FieldAutoDefineOne (Xb+16,Yb+5,@AreaManager,RepChar (10,'$'));
          FieldSetHelp (0,4105);

          WriteXY (Xb+2,Yb+6,'Password');
          FieldAutoDefineOne (Xb+16,Yb+6,@Password,RepChar (10,'$'));
          FieldSetHelp (0,4106);

          WriteXY (Xb+2,Yb+7,'Group');
          FieldAutoDefineList (Xb+16,Yb+7,@GroupListDesc,SelectAFixGroup);
          FieldSetHelp (0,4107);

          WriteXY (Xb+2,Yb+8,'Add "+"');
          FieldAutoDefineToggles (Xb+16,Yb+8,AddPlus,'no|yes',0);
          FieldSetHelp (0,4108);

          GrayUnconditional;

          FieldEdit;

          Group:=LastSelectedAFixGroup;

          FidoSplit (DeleteBackSpaces (FidoStr),UplinkAddress);
     END; { with }

     FieldPopAll;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ EditAreaFixForwardList                                                   }
{                                                                          }
{ Laat een lijstje zien met MaxForward aan entry's.                        }
{                                                                          }
PROCEDURE EditAreaFixForwardList; FAR;

    FUNCTION AFixDesc (Entry : BYTE) : STRING;
    BEGIN
         WITH Config.AreaFixForward[Entry] DO
         BEGIN
              IF FidoCompare (UplinkAddress,NullAdres) THEN
                 AFixDesc:='<empty>'
              ELSE
                  AFixDesc:=BuildSingleGroupDesc (Group)+' '+AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (UplinkAddress));
         END; { with }
    END;

VAR Quit  : BOOLEAN;
    AFLp  : 1..MaxAreafixFwd;
    Keuze : WORD;

BEGIN
     ListDefine (3,3,70,Video.Rows-4,Default,'AreaFix Forward Systems',4100);

     FOR AFLp:=1 TO MaxAreafixFwd DO
         ListAddItem (AFixDesc (AFLp),AFLp,Bottom);

     Quit:=FALSE;
     REPEAT
           Keuze:=ListSelect (NoTag,[]);

           CASE Key OF
                kEsc : Quit:=TRUE;

                kRet : BEGIN
                            EditAFixEntry:=Keuze;
                            EditAreaFixForward;
                            ListSetItemTekst (Keuze,AFixDesc (Keuze));
                       END;
           END; { case }

     UNTIL Quit;

     ListErase;
END;


{--------------------------------------------------------------------------}
{ CheckMaxArcLen                                                           }
{                                                                          }
FUNCTION CheckMaxArcLen (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     Config.MaxFidoArcLen:=CheckNumberLimits (BufferPtr,50000);
     CheckMaxArcLen:=TRUE;
END;


{--------------------------------------------------------------------------}
{ EditFTNSettings                                                          }
{                                                                          }
PROCEDURE EditFTNSettings;

CONST Xb = 3;
      Yb = 3;
      Xl = 75;
      Yl = 21;

      Xb2 = Xb+22;

VAR FieldY       : XYType;
    MaxArcLenStr : STRING[7];

BEGIN
     FixConfigRecord;

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldInit;

     FieldY:=Yb+1;
     MaxArcLenStr:=AddUpWithSpaces (7,Longint2String (Config.MaxFidoArcLen));

     WriteXY (Xb+2,FieldY,'System node numbers');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,EditSystemNodeNrs);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Inbound 1');
     FieldAutoDefineFileMgr (Xb2,FieldY,51,@Config.InBound_F[1],PathFileMgr);
     FieldSetHelp (0,1031);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Security');
     FieldAutoDefineToggles (Xb2,FieldY,Config.Security_F[1],'on|off',0);
     FieldSetHelp (0,1032);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Inbound 2');
     FieldAutoDefineFileMgr (Xb2,FieldY,51,@Config.InBound_F[2],PathFileMgr);
     FieldSetHelp (0,1031);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Security');
     FieldAutoDefineToggles (Xb2,FieldY,Config.Security_F[2],'on|off',0);
     FieldSetHelp (0,1032);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Outbound dir');
     FieldAutoDefineFileMgr (Xb2,FieldY,51,@Config.OutBound_F,PathFileMgr);
     FieldSetHelp (0,1033);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Origin 1');
     FieldAutoDefineLongOne (Xb2,FieldY,51,@Config.Origins[1],RepChar (MaxLenOrigin,'$'));
     FieldSetHelp (0,1034);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Origin 2');
     FieldAutoDefineLongOne (Xb2,FieldY,51,@Config.Origins[2],RepChar (MaxLenOrigin,'$'));
     FieldSetHelp (0,1034);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Mailer type');
     FieldAutoDefineToggles (Xb2,FieldY,Config.FidoSystem,'binkley|frontdoor|d''bridge',0);
     FieldSetHelp (0,1035);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'D''Bridge queue');
     FieldAutoDefineFileMgr (Xb2,FieldY,51,@Config.DBridgeQueuePath,AnyFileMgr);
     FieldSetHelp (0,3043);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Mailer rescan file');
     FieldAutoDefineFileMgr (Xb2,FieldY,51,@Config.RescanFlagFile,AnyFileMgr);
     FieldSetHelp (0,3044);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Editor rescan file');
     FieldAutoDefineFileMgr (Xb2,FieldY,51,@Config.RescanFlagFile2,AnyFileMgr);
     FieldSetHelp (0,3044);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Max archive length');
     FieldAutoDefineCheckOne (Xb2,FieldY,@MaxArcLenStr,RepChar (7,'%'),CheckMaxArcLen);
     FieldSetHelp (0,3045);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'ARCmail extensions');
     FieldAutoDefineToggles (Xb2,FieldY,Config.FidoArcmailExtension,'arcmail|hex|all',0);
     FieldSetHelp (0,3042);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Archivers');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,EditFTNArchivers);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Default archiver');
     FieldAutoDefineToggles (Xb2,FieldY,Config.DefaultCompressor,'arc|arj|lzh|pak|zip|zoo|rar|op1||pkt',0);
     FieldSetHelp (0,1062);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Areafix name');
     FieldAutoDefineOne (Xb2,FieldY,@Config.AreafixName,RepChar (10,'$'));
     FieldSetHelp (0,1019);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Areafix forwarding');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,EditAreafixForwardList);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Kill after AreaFix');
     FieldAutoDefineToggles (Xb2,FieldY,Config.KillAreaFixMsgs,'no|yes',0);
     FieldSetHelp (0,1616);

     FieldEdit;

     WindowPop;
     UnfixConfigRecord;
END;


{==========================================================================}
{==                                                                      ==}
{==                         RFC SETTINGS                                 ==}
{==                                                                      ==}
{==========================================================================}


{--------------------------------------------------------------------------}
{ EditNewsfixForward                                                       }
{                                                                          }
PROCEDURE EditNewsfixForward (Entry : BYTE);

CONST Xb = 8;
      Yb = 6;
      Xl = 68;
      Yl = 5;

VAR GroupData : GroupDescRecord;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     WITH Config.UUCPForward[Entry] DO
     BEGIN
          ReadGroupDescRecord (Group,GroupData);
          GroupListDesc:=AddUpWithSpaces (30+4,BuildSingleGroupDesc (Group)+': '+GroupData.GroupDesc);
          LastSelectedAFixGroup:=Group;

          WriteXY (Xb+2,Yb+1,'UUCP name of uplink');
          FieldAutoDefineOne (Xb+26,Yb+1,@UUCPName,RepChar (MaxLenUUCPName,'$'));
          FieldSetHelp (0,4150);

          WriteXY (Xb+2,Yb+2,'Newsgroups listing path');
          FieldAutoDefineFileMgr (Xb+26,Yb+2,40,@AreaListPath,AreaListFileMgr);
          FieldSetHelp (0,4151);

          WriteXY (Xb+2,Yb+3,'Group for created areas');
          FieldAutoDefineList (Xb+26,Yb+3,@GroupListDesc,SelectAFixGroup);
          FieldSetHelp (0,4153);

          FieldEdit;

          Group:=LastSelectedAFixGroup;
     END; { with }

     FieldPopAll;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ EditNewsfixForwardList                                                   }
{                                                                          }
PROCEDURE EditNewsfixForwardList; FAR;

    FUNCTION NFixDesc (Entry : BYTE) : STRING;
    BEGIN
         WITH Config.UUCPForward[Entry] DO
              IF (DeleteBackSpaces (UUCPName) = '') AND
                 (DeleteBackSpaces (AreaListPath) = '')
              THEN
                  NFixDesc:='<empty>'
              ELSE
                  NFixDesc:=BuildSingleGroupDesc (Group)+' '+
                            UUCPName+' '+
                            DeleteBackSpaces (AreaListPath);
    END;

VAR Quit  : BOOLEAN;
    AFLp  : 1..MaxAreafixFwd;
    Keuze : WORD;

BEGIN
     ListDefine (3,3,70,Video.Rows-4,Default,'NewsFix Forward Configuration',4100);

     FOR AFLp:=1 TO MaxAreafixFwd DO
         ListAddItem (NFixDesc (AFLp),AFLp,Bottom);

     Quit:=FALSE;
     REPEAT
           Keuze:=ListSelect (NoTag,[]);

           CASE Key OF
                kEsc : Quit:=TRUE;

                kRet : BEGIN
                            EditNewsFixForward (Keuze);
                            ListSetItemTekst (Keuze,NFixDesc (Keuze));
                       END;
           END; { case }

     UNTIL Quit;

     ListErase;
END;


{--------------------------------------------------------------------------}
{ EditSystemDomains                                                        }
{                                                                          }
PROCEDURE EditSystemDomains; FAR;

CONST Xb = 20;
      Yb = 6;
      Xl = MaxLenDomain+4;
      Yl = MaxDomains+2;

VAR Lp : 1..MaxDomains;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     FOR Lp:=1 TO MaxDomains DO
     BEGIN
          FieldAutoDefineOne (Xb+2,Yb+Lp,@Config.Domains[Lp],RepChar (MaxLenDomain,'$'));
          FieldSetHelp (0,1077);
     END;

     FieldEdit;

     FieldPopAll;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ EditUUCPCompressionProgs                                                 }
{                                                                          }
PROCEDURE EditUUCPCompressionProgs; FAR;

CONST Xb = 20;
      Yb = 11;
      Xl = 49;
      Yl = 6;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     WriteXY (Xb+2,Yb+1,'Compress');
     FieldAutoDefineLongOne (Xb+14,Yb+1,33,
                             @Config.ComprPrg_U[Compress,Compr],
                             RepChar (MaxLenComprPrgDescr,'$'));
     FieldSetHelp (0,1090);

     WriteXY (Xb+2,Yb+2,'De-compress');
     FieldAutoDefineLongOne (Xb+14,Yb+2,33,
                             @Config.ComprPrg_U[Compress,DeCompr],
                             RepChar (MaxLenComprPrgDescr,'$'));
     FieldSetHelp (0,1090);

     WriteXY (Xb+2,Yb+3,'GZip');
     FieldAutoDefineLongOne (Xb+14,Yb+3,33,
                             @Config.ComprPrg_U[Gzip,Compr],
                             RepChar (MaxLenComprPrgDescr,'$'));
     FieldSetHelp (0,1090);

     WriteXY (Xb+2,Yb+4,'Un-GZip');
     FieldAutoDefineLongOne (Xb+14,Yb+4,33,
                             @Config.ComprPrg_U[GZip,DeCompr],
                             RepChar (MaxLenComprPrgDescr,'$'));
     FieldSetHelp (0,1090);

     FieldEdit;

     FieldPopAll;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ CheckDatLength                                                           }
{                                                                          }
FUNCTION CheckDatLength (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     Config.MaxDatLength:=CheckNumberLimits (BufferPtr,10000);
     CheckDatLength:=TRUE;
END;


{--------------------------------------------------------------------------}
{ EditUUCPSettings                                                         }
{                                                                          }
PROCEDURE EditUUCPSettings; FAR;

CONST Xb = 5;
      Yb = 6;
      Xl = 70;
      Yl = 8;

      Xb2 = Xb+23;

VAR FieldY       : XYType;
    MaxDatLenStr : STRING[6];

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     MaxDatLenStr:=AddUpWithSpaces (6,Longint2String (Config.MaxDatLength));

     FieldY:=Yb+1;

     WriteXY (Xb+2,FieldY,'Spool directory');
     FieldAutoDefineFileMgr (Xb2,FieldY,Xl-(Xb2-Xb)-2,@Config.SpoolBaseDir,PathFileMgr);
     FieldSetHelp (0,1072);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'System UUCP name');
     FieldAutoDefineOne (Xb2,FieldY,@Config.UUCPName,RepChar (MaxLenUUCPName,'$'));
     FieldSetHelp (0,1073);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'World registered');
     FieldAutoDefineToggles (Xb2,FieldY,Config.WorldWide,'no|yes',0);
     FieldSetHelp (0,1076);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Maximum .DAT length');
     FieldAutoDefineCheckOne (Xb2,FieldY,@MaxDatLenStr,RepChar (6,'%'),CheckDatLength);
     FieldSetHelp (0,1080);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'UUCP filenames');
     FieldAutoDefineToggles (Xb2,FieldY,Config.ForceNoBitmask,'normal|no bitmask',0);
     FieldSetHelp (0,1084);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Compression programs');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,EditUUCPCompressionProgs);

     FieldEdit;

     FieldPopAll;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ CheckMaxXPostNewsgroups                                                  }
{                                                                          }
FUNCTION CheckMaxXPostNewsgroups (BufferPtr : StringPtr) : BOOLEAN; FAR;

VAR Nop : ValNop;

BEGIN
     Val (DeleteFrontAndBackSpaces (BufferPtr^),Config.MaxXPostNewsgroups,Nop);

     IF (Nop <> 0) THEN
        Config.MaxXPostNewsgroups:=255
     ELSE
         IF (Config.MaxXPostNewsgroups = 0) THEN
            Config.MaxXPostNewsgroups:=255;

     BufferPtr^:=AddUpWithSpaces (3,Byte2String (Config.MaxXPostNewsgroups));
END;


{--------------------------------------------------------------------------}
{ EditRFCSettings                                                          }
{                                                                          }
PROCEDURE EditRFCSettings;

CONST Xb = 3;
      Yb = 3;
      Xl = 74;
      Yl = 15;

      Xb2 = Xb+21;

VAR FieldY       : XYType;
    CrossPostStr : STRING[3];

BEGIN
     FixConfigRecord;

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldInit;

     FieldY:=Yb+1;

     CrossPostStr:=AddUpWithSpaces (3,Byte2String (Config.MaxXPostNewsgroups));

     WriteXY (Xb+2,FieldY,'Organization');
     FieldAutoDefineLongOne (Xb2,FieldY,Xl-Xb2+1,@Config.Organization,RepChar (MaxLenOrganization,'$'));
     FieldSetHelp (0,1071);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Smart host');
     FieldAutoDefineOne (Xb2,FieldY,@Config.SmartHost,RepChar (MaxLenUUCPName,'$'));
     FieldSetHelp (0,1074);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'System domains');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,EditSystemDomains);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Time zone');
     FieldAutoDefineOne (Xb2,FieldY,@Config.TimeZone,RepChar (25,'$'));
     FieldSetHelp (0,1079);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Undeliverable mail');
     FieldAutoDefineToggles (Xb2,FieldY,Config.BounceUnknown,'netmail|bounce',0);
     FieldSetHelp (0,1081);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Bounce small');
     FieldAutoDefineToggles (Xb2,FieldY,Config.BounceSmall,'no|yes',0);
     FieldSetHelp (0,1082);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Cross-post limit');
     FieldAutoDefineCheckOne (Xb2,FieldY,@CrossPostStr,'###',CheckMaxXPostNewsgroups);
     FieldSetHelp (0,1085);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Newsfix name');
     FieldAutoDefineOne (Xb2,FieldY,@Config.NewsfixName,RepChar (10,'$'));
     FieldSetHelp (0,4152);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Newsfix forwarding');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,EditNewsfixForwardList);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'UUCP settings');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,EditUUCPSettings);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'SMTP forward');
     FieldAutoDefineOne (Xb2,FieldY,@Config.SmtpForward,RepChar (MaxLenDomain,'$'));
     FieldSetHelp (0,1086);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Address completion');
     FieldAutoDefineToggles (Xb2,FieldY,Config.RMailCorrect,'add system domain|search headers',1);
     FieldSetHelp (0,1087);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Backbone');
     FieldAutoDefineOne (Xb2,FieldY,@Config.BackBone,RepChar (MaxLenDomain,'$'));
     FieldSetHelp (0,1075);

     FieldEdit;

     WindowPop;
     UnfixConfigRecord;
END;


{==========================================================================}
{==                                                                      ==}
{==                   MESSAGE BASE SETTINGS                              ==}
{==                                                                      ==}
{==========================================================================}


{--------------------------------------------------------------------------}
{ CheckDefaultDays                                                         }
{                                                                          }
FUNCTION CheckDefaultDays (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     Config.DefDaysToKeep_F:=CheckNumberLimits (BufferPtr,DefaultFidoAge);
     CheckDefaultDays:=TRUE; { no problems }
END;


{--------------------------------------------------------------------------}
{ CheckDefaultNumber                                                       }
{                                                                          }
FUNCTION CheckDefaultNumber (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     Config.DefNumbToKeep_F:=CheckNumberLimits (BufferPtr,DefaultFidoLimit);
     CheckDefaultNumber:=TRUE; { no problems }
END;


{--------------------------------------------------------------------------}
{ EditNewAreaDefaults                                                      }
{                                                                          }
PROCEDURE EditNewAreaDefaults; FAR;

CONST Xb = 6;
      Yb = 7;
      Xl = 72;
      Yl = 6;

      Xb2 = Xb+20;

VAR FieldY  : XYType;
    NumStr,
    DaysStr : STRING[5];

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     FieldY:=Yb+1;

     NumStr:=AddUpWithSpaces (5,Word2String (Config.DefNumbToKeep_F));
     DaysStr:=AddUpWithSpaces (5,Word2String (Config.DefDaysToKeep_F));


     WriteXY (Xb+2,FieldY,'Auto Create Type ');
     FieldAutoDefineToggles (Xb2,FieldY,Config.FidoAutoCreateType,'none|msg|squish|jam|wildcat',0);
     FieldSetHelp (0,1051);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Default number');
     FieldAutoDefineCheckOne (Xb2,FieldY,@NumStr,'%%%%%',CheckDefaultNumber);
     FieldSetHelp (0,1044);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Default days');
     FieldAutoDefineCheckOne (Xb2,FieldY,@DaysStr,'%%%%%',CheckDefaultDays);
     FieldSetHelp (0,1045);

     Inc (FieldY);
     WriteXy (Xb+2,FieldY,'Default new path');
     FieldAutoDefineFileMgr (Xb2,FieldY,50,@Config.DefaultFidoMsgPath,PathFileMgr);
     FieldSetHelp (0,1052);

     FieldEdit;

     FieldPopAll;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ FidoFileMgr                                                              }
{                                                                          }
{ Controleerd of een JAM/SQUISH/WC area geen trailing '\' heeft, en plakt  }
{ hem er juist bij voor een Fido *.MSG area. Deze routine is speciaal voor }
{ de Fido MsgBase Settings routine. Aan de hand van het veldnummer wordt   }
{ gekeken naar het netmail, badmail of dupemail pad.                       }
{                                                                          }
PROCEDURE FidoFileMgr (BufferPtr : StringPtr); FAR;

VAR BaseType : FidoMsgStyleType;

BEGIN
     CASE LastFieldNr OF
          2 : BaseType:=Config.FidoNetmailType;   { netmail path }
          7 : BaseType:=Config.FidoBadAreaType;   { badmail path }
          9 : BaseType:=Config.FidoDupeAreaType;  { dupemail path }
     END; { case }

     MsgBaseFileMgr (BufferPtr,BaseType);
END;


{--------------------------------------------------------------------------}
{ GrayNetFilesPath                                                         }
{                                                                          }
PROCEDURE GrayNetFilesPath; FAR;
BEGIN
     IF Config.NetmailDecode THEN
        FieldEnableField (4)
     ELSE
         FieldDisableField (4);

     FieldUpdateOneField (4);
END;


{--------------------------------------------------------------------------}
{ GrayBadPathField                                                         }
{                                                                          }
PROCEDURE GrayBadPathField; FAR;
BEGIN
     IF (Config.FidoBadAreaType <> NoneType) THEN
        FieldEnableField (7)
     ELSE
         FieldDisableField (7);

     FieldUpdateOneField (7);
END;


{--------------------------------------------------------------------------}
{ GrayDupePathField                                                        }
{                                                                          }
PROCEDURE GrayDupePathField; FAR;
BEGIN
     IF (Config.FidoDupeAreaType <> NoneType) THEN
        FieldEnableField (9)
     ELSE
         FieldDisableField (9);

     FieldUpdateOneField (9);
END;


{--------------------------------------------------------------------------}
{ GrayOpusDateField                                                        }
{                                                                          }
PROCEDURE GrayOpusDateField; FAR;
BEGIN
     IF (Config.FidoNetmailType <> FidoMsgType) THEN
        FieldDisableField (5)
     ELSE
         FieldEnableField (5);

     FieldUpdateOneField (5);
END;


{--------------------------------------------------------------------------}
{ EditSystemMsgBases                                                       }
{                                                                          }
PROCEDURE EditSystemMsgBases; FAR;

CONST Xb = 6;
      Yb = 8;
      Xl = 72;
      Yl = 13;

      Xb2 = Xb+20;

VAR FieldY : XYType;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     FieldY:=Yb+1;

     WriteXY (Xb+2,FieldY,'Netmail type');
     FieldAutoDefineTogglesCall (Xb2,FieldY,Config.FidoNetmailType,'msg|squish|jam|wildcat',1,GrayOpusDateField);
     FieldSetHelp (0,1046);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Netmail path');
     FieldAutoDefineFileMgr (Xb2,FieldY,50,@Config.FidoNetmailPath,FidoFileMgr);
     FieldSetHelp (0,1047);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Decode files');
     FieldAutoDefineTogglesCall (Xb2,FieldY,Config.NetmailDecode,'no|on import',0,GrayNetFilesPath);
     FieldSetHelp (0,1604);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Files path');
     FieldAutoDefineCheckLongOne (Xb2,FieldY,50,@Config.NetmailDecodePath,RepChar (79,'@'),CheckPathFunc);
     FieldSetHelp (0,1605);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Opus date format');
     FieldAutoDefineToggles (Xb2,FieldY,Config.OpusDateFormat,'no|yes',0);
     FieldSetHelp (0,1606);

     Inc (FieldY);
     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Badmail type');
     FieldAutoDefineTogglesCall (Xb2,FieldY,Config.FidoBadAreaType,'none|msg|squish|jam|wildcat',0,GrayBadPathField);
     FieldSetHelp (0,1048);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Badmail path');
     FieldAutoDefineFileMgr (Xb2,FieldY,50,@Config.FidoBadPath,FidoFileMgr);
     FieldSetHelp (0,1049);

     Inc (FieldY);
     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Dupemail type');
     FieldAutoDefineTogglesCall (Xb2,FieldY,Config.FidoDupeAreaType,'none|msg|squish|jam|wildcat',0,GrayDupePathField);
     FieldSetHelp (0,1053);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Dupemail path');
     FieldAutoDefineFileMgr (Xb2,FieldY,50,@Config.FidoDupePath,FidoFileMgr);
     FieldSetHelp (0,1054);

     GrayNetFilesPath;
     GrayBadPathField;
     GrayDupePathField;

     FieldEdit;

     FieldPopAll;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ CheckMsgLen                                                              }
{                                                                          }
FUNCTION CheckMsgLen (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     CheckNumberLimits (BufferPtr,5000);
     CheckMsgLen:=TRUE;
END;


{--------------------------------------------------------------------------}
{ EditMessageBaseSettings                                                  }
{                                                                          }
PROCEDURE EditMessageBaseSettings;

CONST Xb = 3;
      Yb = 3;
      Xl = 72;
      Yl = 15;

      Xb2 = Xb+23;

VAR FieldY     : XYType;
    WcStr,
    JamStr,
    SquishStr,
    MsgStr     : STRING[11];
    Nop        : ValNop;

BEGIN
     FixConfigRecord;

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldInit;

     MsgStr:=AddUpWithSpaces (11,Longint2String (Config.MaxFidoMsgLen));
     SquishStr:=AddUpWithSpaces (11,Longint2String (Config.MaxSquishMsgLen));
     JamStr:=AddUpWithSpaces (11,Longint2String (Config.MaxJamMsgLen));
     WcStr:=AddUpWithSpaces (11,Longint2String (Config.MaxWildCatMsgLen));

     FieldY:=Yb+1;

     WriteXY (Xb+2,FieldY,'System message bases');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,EditSystemMsgBases);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'New area defaults');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,EditNewAreaDefaults);

     Inc (FieldY);
     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Auto link');
     FieldAutoDefineToggles (Xb2,FieldY,Config.AutoLink,'no|yes',0);
     FieldSetHelp (0,1041);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Strip SEEN-BY');
     FieldAutoDefineToggles (Xb2,FieldY,Config.StripSeenBy,'no|yes',0);
     FieldSetHelp (0,1042);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Replace tear');
     FieldAutoDefineToggles (Xb2,FieldY,Config.ReplaceTear,'no|yes',0);
     FieldSetHelp (0,1043);

     Inc (FieldY);
     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Message size *.MSG');
     FieldAutoDefineCheckOne (Xb2,FieldY,@MsgStr,RepChar (11,'%'),CheckMsgLen);
     FieldSetHelp (0,1036);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Message size Squish');
     FieldAutoDefineCheckOne (Xb2,FieldY,@SquishStr,RepChar (11,'%'),CheckMsgLen);
     FieldSetHelp (0,1036);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Message size JAM');
     FieldAutoDefineCheckOne (Xb2,FieldY,@JamStr,RepChar (11,'%'),CheckMsgLen);
     FieldSetHelp (0,1036);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Message size WildCat');
     FieldAutoDefineCheckOne (Xb2,FieldY,@WcStr,RepChar (11,'%'),CheckMsgLen);
     FieldSetHelp (0,1036);

     Inc (FieldY);
     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'WildCat MSGLOCK dir');
     FieldAutoDefineFileMgr (Xb2,FieldY,47,@Config.WildCatMsgLockDir,PathFileMgr);
     FieldSetHelp (0,1057);

     FieldEdit;

     Val (DeleteFrontAndBackSpaces (MsgStr),Config.MaxFidoMsgLen,Nop);
     Val (DeleteFrontAndBackSpaces (SquishStr),Config.MaxSquishMsgLen,Nop);
     Val (DeleteFrontAndBackSpaces (JamStr),Config.MaxJamMsgLen,Nop);
     Val (DeleteFrontAndBackSpaces (JamStr),Config.MaxWildCatMsgLen,Nop);

     WindowPop;
     UnfixConfigRecord;
END;


{==========================================================================}
{==                                                                      ==}
{==                        GATEWAY SETTINGS                              ==}
{==                                                                      ==}
{==========================================================================}


{--------------------------------------------------------------------------}
{ CheckWrapLineLen                                                         }
{                                                                          }
FUNCTION CheckWrapLineLen (BufferPtr : StringPtr) : BOOLEAN; FAR;

VAR Nop : ValNop;

BEGIN
     Val (BufferPtr^,Config.WrapLineLen,Nop);

     IF (Nop <> 0) THEN
        Config.WrapLineLen:=72; { default }

     IF (Config.WrapLineLen > 99) THEN
        Config.WrapLineLen:=99;

     IF (Config.WrapLineLen < 50) THEN
     BEGIN
          Error ('Minimum allowed value is 50');
          Config.WrapLineLen:=50;
     END;

     BufferPtr^:=Byte2String (Config.WrapLineLen);

     CheckWrapLineLen:=TRUE;
END;


{--------------------------------------------------------------------------}
{ GrayLineWrapField                                                        }
{                                                                          }
PROCEDURE GrayLineWrapField; FAR;
BEGIN
     IF Config.AlwaysMimeQuotePrint THEN
        FieldDisableField (7)
     ELSE
         FieldEnableField (7);

     FieldUpdateOneField (7);
END;


{--------------------------------------------------------------------------}
{ EditGatewayAKA                                                           }
{                                                                          }
PROCEDURE EditGatewayAKA; FAR;

VAR AkaLp : 1..MaxAkas;
    Keuze : WORD;
    Quit  : BOOLEAN;

BEGIN
     ListDefine (3,3,39,Video.Rows-4,Default,'Select the Gateway AKA',0);

     ListSetConvertRoutine (FidoAkaListConvertFunc);

     FOR AkaLp:=1 TO MaxAkas DO
         IF (Fido2Str (Config.NodeNrs[AkaLp]) <> '0') THEN
            ListAddItem (Fido2Str (Config.NodeNrs[AkaLp]),AkaLp,Convert);

     IF (ListItemCount = 0) THEN
     BEGIN
          Error ('Please define a system node number first');
          ListErase;
          Exit;
     END;

     ListSetCursorOnItem (Config.GatewayAka);

     Quit:=FALSE;
     REPEAT
           Keuze:=ListSelect (NoTag,[]);

           CASE Key OF
                kRet : BEGIN
                            Config.GatewayAKA:=Keuze;
                            GatewayAkaStr:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (Config.NodeNrs[Config.GatewayAKA]));
                            Quit:=TRUE;
                       END;

                kEsc : Quit:=TRUE;
           END; { case }
     UNTIL Quit;

     ListErase;
     FixConfigRecord;
END;


{--------------------------------------------------------------------------}
{ EditCopyHeaders                                                          }
{                                                                          }
PROCEDURE EditCopyHeaders; FAR;

    {----------------------------------------------------------------------}
    { BuildCopyHeadersDescr                                                }
    {                                                                      }
    { Build a description to put in the list.                              }
    {                                                                      }
    FUNCTION BuildCopyHeadersDescr (Index : BYTE) : STRING;

    VAR SelectStr :STRING;

    BEGIN
         CASE Config.CopyHeaderHow[Index] OF
              chNot :    SelectStr:='Don''t copy';
              chKludge : SelectStr:='Copy as kludge';
              chText :   SelectStr:='Copy as plain text';
         END; { case }

         BuildCopyHeadersDescr:=Config.CopyHeaderNames[Index]+' '+SelectStr;
    END;

    {----------------------------------------------------------------------}
    { EditCopyHeaders                                                      }
    {                                                                      }
    { Edit one of the entries. Assume FixConfig has already added spaces   }
    { and UnfixConfig removes them.                                        }
    {                                                                      }
    PROCEDURE EditCopyHeaders (Index : BYTE);

    CONST Xb  = 20;
          Yb  = 10;
          Xl  = 32;
          Yl  = 4;
          Xb2 = Xb+15;

    BEGIN
         FieldPushAll; { Gateway screen }

         WindowPush (Xb,Yb,Xl,Yl);
         BoxDraw (Double,Xb,Yb,Xl,Yl);

         FieldInit;

         WriteXY (Xb+2,Yb+1,'Header name');
         FieldAutoDefineOne (Xb2,Yb+1,
                             @Config.CopyHeaderNames[Index],
                             RepChar (MaxLenCopyHeaderName,'$'));
         FieldSetHelp (0,1039);

         WriteXY (Xb+2,Yb+2,'Copy whereto');
         FieldAutoDefineToggles (Xb2,Yb+2,
                                 Config.CopyHeaderHow[Index],
                                 'not|kludge|text',0);
         FieldSetHelp (0,1039);

         FieldEdit;

         WindowPop;
         FieldPopAll;
    END;

{ EditCopyHeaders }

CONST Title = 'E-mail/news headers to copy netmail/echomail';

VAR Lp    : BYTE;
    Keuze : WORD;
    Quit  : BOOLEAN;

BEGIN
     ListDefine (22,3,Length (Title)+4,Video.Rows-4,Default,Title,1039);

     FOR Lp:=1 TO MaxCopyHeaders DO
         ListAddItem (BuildCopyHeadersDescr (Lp),Lp,Bottom);

     Quit:=FALSE;
     REPEAT
           Keuze:=ListSelect (NoTag,[]);

           CASE Key OF
                kEsc :
                    Quit:=TRUE;

                kRet :
                    BEGIN
                         EditCopyHeaders (Keuze);
                         ListSetItemTekst (Keuze,BuildCopyHeadersDescr (Keuze));
                    END;

           END; { case }

     UNTIL Quit;

     ListErase;
END;


{--------------------------------------------------------------------------}
{ EditGatewaySettings                                                      }
{                                                                          }
PROCEDURE EditGatewaySettings;

CONST Xb = 3;
      Yb = 3;
      Xl = 76;
      Yl = 21;

      Xb2 = Xb+25;

VAR WrapLineLenStr : STRING[3];
    TransName      : STRING[1];
    FieldY         : XYType;

BEGIN
     FixConfigRecord;

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldInit;

     TransName:=Config.NameSeparator; { cant edit CHAR as field }
     WrapLineLenStr:=Byte2String (Config.WrapLineLen);

     FieldY:=Yb+1;

     GatewayAkaStr:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (Config.NodeNrs[Config.GatewayAKA]));

     SetLines (Single);
     WriteXY (Xb2,FieldY,HO+HO+HO+' FTN to RFC '+HO+HO+HO);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Gateway AKA');
     FieldAutoDefineList (Xb2,FieldY,@GatewayAkaStr,EditGatewayAka);
     FieldSetHelp (0,1023);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Gateway user');
     FieldAutoDefineOne (Xb2,FieldY,@Config.GatewayUser,RepChar (MaxLenToUser_F,'$'));
     FieldSetHelp (0,1024);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Accept To:');
     FieldAutoDefineToggles (Xb2,FieldY,Config.FidoAcceptTO,'no|yes',0);
     FieldSetHelp (0,1025);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Kill gated netmail');
     FieldAutoDefineToggles (Xb2,FieldY,Config.KillGatedNetmail,'no|yes',0);
     FieldSetHelp (0,1029);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Allow headers');
     FieldAutoDefineToggles (Xb2,FieldY,Config.CopyHeaders_FU,'no|yes',0);
     FieldSetHelp (0,1022);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Quoted-printable');
     FieldAutoDefineTogglesCall (Xb2,FieldY,Config.AlwaysMimeQuotePrint,'when needed|always',0,GrayLineWrapField);
     FieldSetHelp (0,1056);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Line wrap');
     FieldAutoDefineCheckOne (Xb2,FieldY,@WrapLineLenStr,'$$',CheckWrapLineLen);
     FieldSetHelp (0,1055);

     Inc (FieldY,2);
     WriteXY (Xb2,FieldY,HO+HO+HO+' RFC to FTN '+HO+HO+HO);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'FSC-35 kludges?');
     FieldAutoDefineToggles (Xb2,FieldY,Config.ReplyFSC35,'no|yes',0);
     FieldSetHelp (0,1026);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'FTN From:');
     FieldAutoDefineToggles (Xb2,FieldY,Config.HeaderFullname,'e-mail address|full name',0);
     FieldSetHelp (0,1030);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Copy headers');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,EditCopyHeaders);
     FieldSetHelp (0,1038);

     { deze vervangen door default FTN en MIME sets }
     (*
     WriteXY (Xb+2,FieldY,'ASCII Conversion');
     FieldAutoDefineList (Xb2,FieldY,@EnterToEdit,ConfigChangeConvTable);
     FieldSetHelp (0,3040);
     *)

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Message-ID to MSGID');
     FieldAutoDefineToggles (Xb2,FieldY,Config.GateMsgId,'no|include',0);
     FieldSetHelp (0,3046);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Organization to Origin');
     FieldAutoDefineToggles (Xb2,FieldY,Config.OrganizationInOrigin,'no|yes|override',0);
     FieldSetHelp (0,3047);

     Inc (FieldY,2);
     WriteXY (Xb2,FieldY,HO+HO+HO+' Both directions '+HO+HO+HO);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Name separator');
     FieldAutoDefineOne (Xb2,FieldY,@TransName,'$');
     FieldSetHelp (0,1027);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Small addresses');
     FieldAutoDefineToggles (Xb2,FieldY,Config.PackedAddresses,'no|yes',0);
     FieldSetHelp (0,1028);

     GrayLineWrapField;

     FieldEdit;

     IF (TransName[1] = ' ') THEN
        Config.NameSeparator:='_'
     ELSE
         Config.NameSeparator:=TransName[1];

     WindowPop;

     UnfixConfigRecord;
END;


{==========================================================================}
{==                                                                      ==}
{==                    PRIVATE MAILS SCAN SETTINGS                       ==}
{==                                                                      ==}
{==========================================================================}


{---------------------------------------------------------------------------}
{ PrivFileMgr                                                               }
{                                                                           }
PROCEDURE PrivFileMgr (BufferPtr : StringPtr); FAR;
BEGIN
     MsgBaseFileMgr (BufferPtr,Config.PrivMailType);
END;


{--------------------------------------------------------------------------}
{ GrayPrivDecodeField                                                      }
{                                                                          }
PROCEDURE GrayPrivDecodeField; FAR;
BEGIN
     IF Config.PrivateDecode THEN
        FieldEnableField (4)
     ELSE
         FieldDisableField (4);

     FieldUpdateOneField (4);
END;


{--------------------------------------------------------------------------}
{ GrayPrivFields                                                           }
{                                                                          }
PROCEDURE GrayPrivFields; FAR;
BEGIN
     IF (Config.PrivMailType <> NoneType) THEN
     BEGIN
          FieldEnableField (2);
          FieldEnableField (3);
          GrayPrivDecodeField;
     END ELSE
     BEGIN
          FieldDisableField (2);
          FieldDisableField (3);
          FieldDisableField (4);
     END;

     FieldUpdateOneField (2);
     FieldUpdateOneField (3);
     FieldUpdateOneField (4);
END;


{--------------------------------------------------------------------------}
{ EditPrivateMailScanSettings                                              }
{                                                                          }
PROCEDURE EditPrivateMailScanSettings;

CONST Xb = 3;
      Yb = 3;
      Xl = 64;
      Yl = 18;

VAR Lp     : 1..MaxPrivMail;
    FieldY : XYType;

BEGIN
     FixConfigRecord;

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldInit;

     FieldY:=Yb+1;

     WriteXY (Xb+2,FieldY,'Private mail type');
     FieldAutoDefineTogglesCall (Xb+20,FieldY,Config.PrivMailType,'none|msg|squish|jam|wildcat',0,GrayPrivFields);
     FieldSetHelp (0,1600);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Private mail path');
     FieldAutoDefineFileMgr (Xb+20,FieldY,42,@Config.PrivmailPath,PrivFileMgr);
     FieldSetHelp (0,1601);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Decode files');
     FieldAutoDefineTogglesCall (Xb+20,FieldY,Config.PrivateDecode,'no|on import',0,GrayPrivDecodeField);
     FieldSetHelp (0,1604);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Files path');
     FieldAutoDefineFileMgr (Xb+20,FieldY,42,@Config.PrivateDecodePath,PathFileMgr);
     FieldSetHelp (0,1605);

     Inc (FieldY);
     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Search for');
     WriteXY (Xb+50,FieldY,'In');

     FOR Lp:=1 TO MaxPrivMail DO
     BEGIN
          Inc (FieldY);
          FieldAutoDefineLongOne (Xb+2,FieldY,47,@Config.PrivMailOption[Lp],RepChar (MaxLenSubj_F,'@'));
          FieldSetHelp (0,1602);

          FieldAutoDefineToggles (Xb+50,FieldY,Config.PrivmailSelect[Lp],'from|to|subj',0);
          FieldSetHelp (0,1603);
     END; { for }

     GrayPrivFields;
     FieldEdit;

     WindowPop;
     UnfixConfigRecord;
END;


{==========================================================================}
{==                                                                      ==}
{==                        NEW USER DEFAULTS                             ==}
{==                                                                      ==}
{==========================================================================}


{--------------------------------------------------------------------------}
{ EditDefaultGroupsFTN                                                     }
{                                                                          }
PROCEDURE EditDefaultGroupsFTN (BufferPtr : StringPtr); FAR;
BEGIN
     EditGroupsList (Config.DefGroups_F,'Default groups for new FTN style users','No groups',1300,1301);
     BufferPtr^:=AddUpWithSpaces (45,BuildGroupListDesc (Config.DefGroups_F,45));
END;


{--------------------------------------------------------------------------}
{ EditDefaultGroupsRFC                                                     }
{                                                                          }
PROCEDURE EditDefaultGroupsRFC (BufferPtr : StringPtr); FAR;
BEGIN
     EditGroupsList (Config.DefGroups_U,'Default groups for new UUCP/BAG style users','No groups',1300,1301);
     BufferPtr^:=AddUpWithSpaces (45,BuildGroupListDesc (Config.DefGroups_U,45));
END;


{--------------------------------------------------------------------------}
{ EditNewUserDefaults                                                      }
{                                                                          }
PROCEDURE EditNewUserDefaults;

CONST Xb = 3;
      Yb = 3;
      Xl = 75;
      Yl = 4;

      Xb2 = Xb+28;

VAR DefGroupsStr_F : STRING[45];
    DefGroupsStr_U : STRING[45];

BEGIN
     FixConfigRecord;

     { system dir wordt gebruikt om de groups database te lezen }
     Config.SystemDir:=DeleteBackSpaces (Config.SystemDir);

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldInit;

     DefGroupsStr_F:=AddUpWithSpaces (45,BuildGroupListDesc (Config.DefGroups_F,45));
     DefGroupsStr_U:=AddUpWithSpaces (45,BuildGroupListDesc (Config.DefGroups_U,45));

     WriteXY (Xb+2,Yb+1,'New FTN user groups');
     FieldAutoDefineEdit (Xb2,Yb+1,@DefGroupsStr_F,EditDefaultGroupsFTN);

     WriteXY (Xb+2,Yb+2,'New UUCP/BAG users groups');
     FieldAutoDefineEdit (Xb2,Yb+2,@DefGroupsStr_U,EditDefaultGroupsRFC);

     FieldEdit;

     WindowPop;
     UnfixConfigRecord;
END;


{==========================================================================}
{==                                                                      ==}
{==                        ADMINISTRATOR SETTINGS                        ==}
{==                                                                      ==}
{==========================================================================}


{--------------------------------------------------------------------------}
{ ChangeAdminSettings_TypeHasChanged                                       }
{                                                                          }
PROCEDURE ChangeAdminSettings_TypeHasChanged; FAR;

VAR Ok1,Ok2,Ok3 : BOOLEAN;
    Lp          : BYTE;

BEGIN
     CASE Config.AdminAddrType OF
          0 : BEGIN
                   { disabled }
                   Ok1:=FALSE;
                   Ok2:=FALSE;
                   Ok3:=FALSE;
              END;

          1 : BEGIN
                   { fido }
                   Ok1:=TRUE;
                   Ok2:=FALSE;
                   Ok3:=TRUE;
              END;

          2 : BEGIN
                   { usenet }
                   Ok1:=FALSE;
                   Ok2:=TRUE;
                   Ok3:=TRUE;
              END;
     END; { case }

     IF Ok1 THEN
     BEGIN
          FieldEnableField (2);
          FieldEnableField (3);
     END ELSE
     BEGIN
          FieldDisableField (2);
          FieldDisableField (3);
     END;

     FieldUpdateOneField (2);
     FieldUpdateOneField (3);

     IF Ok2 THEN
        FieldEnableField (4)
     ELSE
         FieldDisableField (4);

     FieldUpdateOneField (4);

     FOR Lp:=5 TO 20 DO
     BEGIN
          IF Ok3 THEN
             FieldEnableField (Lp)
          ELSE
              FieldDisableField (Lp);

          FieldUpdateOneField (Lp);
     END; { for }
END;


{--------------------------------------------------------------------------}
{ EditAdministratorSettings                                                }
{                                                                          }
PROCEDURE EditAdministratorSettings;

CONST Xb = 20;
      Yb = 4;
      Xl = 55;
      Yl = 14;

      Xb2 = 37;

VAR FidoStr : STRING[MaxLenFidoAddrString];
    Lp      : BYTE;

BEGIN
     FixConfigRecord;

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FidoStr:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (Config.AdminFidoAddr));

     FieldInit;

     WriteXY (Xb+2,Yb+1,'Administrator Settings');

     WriteXY (Xb+2,Yb+3,'Address type');
     FieldAutoDefineTogglesCall (Xb2,Yb+3,Config.AdminAddrType,'disable|netmail|e-mail',0,ChangeAdminSettings_TypeHasChanged);
     FieldSetHelp (0,4400);

     WriteXY (Xb+2,Yb+5,'FTN username');
     FieldAutoDefineOne (Xb2,Yb+5,@Config.AdminFidoName,RepChar (MaxLenToUser_F,'$'));
     FieldSetHelp (0,4401);

     WriteXY (Xb+2,Yb+6,'FTN address');
     FieldAutoDefineLongOne (Xb2,Yb+6,36,@FidoStr,RepChar (MaxLenFidoAddrstring,'$'));
     FieldSetHelp (0,4402);

     WriteXY (Xb+2,Yb+8,'E-mail address');
     FieldAutoDefineLongOne (Xb2,Yb+8,36,@Config.AdminUUCPAddr,RepChar (MaxLenUser_U,'$'));
     FieldSetHelp (0,4403);

     WriteXY (Xb+2,Yb+10,'Send log?');
     FieldAutoDefineToggles (Xb2,Yb+10,Config.AdminSendLog,'no|yes',0);
     FieldSetHelp (0,4404);

     WriteXY (Xb2,Yb+12,'(more to come in future releases)');

     ChangeAdminSettings_TypeHasChanged; { initial graying }

     FieldEdit;

     FidoSplit (DeleteFrontAndBackSpaces (FidoStr),Config.AdminFidoAddr);

     WindowPop;
     UnFixConfigRecord;
END;


{--------------------------------------------------------------------------}
{ EditSystemConfig                                                         }
{                                                                          }
PROCEDURE EditSystemConfig;

VAR Quit,
    Quit2 : BOOLEAN;

BEGIN
     MenuDefine (3,3,'System configuration Menu');
     MenuSetHelp (1000);
     MenuAddItem ('Global settings');
     MenuAddItem ('FTN settings');
     MenuAddItem ('RFC settings');
     MenuAddItem ('Gateway settings');
     MenuAddItem ('Message base settings');
     MenuAddItem ('Private mail scan settings');
     MenuAddItem ('Administrator settings');
     MenuAddItem ('New user defaults');
     MenuShow;

     Quit:=FALSE;
     REPEAT
           CASE MenuSelect OF
                mOpt01 : EditGlobalSettings;
                mOpt02 : EditFTNSettings;
                mOpt03 : EditRFCSettings;
                mOpt04 : EditGatewaySettings;
                mOpt05 : EditMessageBaseSettings;
                mOpt06 : EditPrivateMailScanSettings;
                mOpt07 : EditAdministratorSettings;
                mOpt08 : EditNewUserDefaults;
                kEsc   : Quit:=TRUE;
           END; { case }

           IF Quit AND ConfigHasChanged THEN
           BEGIN
                MenuDefine (6,Video.Rows-10,'Save changes?');
                MenuSetHelp (1001);
                MenuAddItem ('Yes');
                MenuAddItem ('No');
                MenuShow;

                { moet een keuze maken, Escape keert terug naar het menu }
                Quit2:=FALSE;
                REPEAT
                      CASE MenuSelect OF
                           mOpt01 : BEGIN
                                         SaveConfigFile;
                                         Quit2:=TRUE;
                                    END;

                           mOpt02 : Quit2:=TRUE;

                           kEsc : BEGIN
                                       Quit2:=TRUE;
                                       Quit:=FALSE;
                                  END;
                      END; { case }
                UNTIL Quit2;

                MenuErase;
           END;

     UNTIL Quit;

     MenuErase;
     UnFixConfigRecord; { ivm healt check }
END;


END.
