UNIT Msgs;

{ Routines voor een standaard (intern) message formaat. Vanuit Fido en
  Usenet kunnen de berichten eerst naar dit formaat ingelezen worden en
  daarna van hieruit weer weggeschreven. Deze routines doen voornamelijk
  het vertalen tussen Fido en Usenet en het inpakken van de mail. Het
  schrijven naar de verschillende outbounds gebeurt in MAKEOUT. }

{ History:

RvdW 20-02-93 Deze unit wat opgepoetst.
              TYPE FidoAddrType en CONST MaxLenFidoAddrDomain verplaatst
              naar FIDO.PAS.
     26-02-93 CreateLine, ReleaseLines vervangen en TopRecord aangemaakt
              om snelheid te winnen bij het aanmaken van de interne msg.
     30-03-93 MsgsExport en direct aangeroepen routines vervangen. Usenet
              Export is nu goed.
     31-03-93 Test op Passive vlag ingebouwd.
     02-04-93 ReleaseLines omgedoopt in MsgsReleaseLines en public gemaakt
              zodat na een conversie de header / footer van het oude type
              weggegooid kunnen worden.
     02-04-93 In verband met type casting de MaxLenUser_U aangemaakt om de
              andere vier User_U constanten te vervangen. In Translate zit
              nu een typecast bij een procedure aanroep zodat niet de hele
              string mee gegeven hoeft te worden.
     03-04-93 Overal in zitten bouwen dat voor gebruik van de Msg.??Top_?
              pointers eerst gekeken wordt of ze NIL zijn. Er waren namelijk
              msgs die geen header hadden...
              Bittenbak optie toegevoegd aan de WhereTo om invalid kludges
              in netmail en echomail te kunnen verwijderen.
     16-05-93 Bij ExportMsgInFidoStyle wordt vanaf nu de Exported vlag niet
              meer op 1 gezet. Deze is alleen voor Usenet belangrijk, omdat
              daar de 'newsgroups:' het bericht al n-keer opneemt in de .D
              file. Bij Fido met bij een x-post of split meerdere delen naar
              de .pkt geschreven worden en dat ging niet door die Exported.
     30-05-93 Herkenning usenet mail aan areafix gemaakt.
     06-06-93 MsgsExportUsenetMail uitgebreid zodat nu ook de juiste info in
              een .XQT file gezet wordt.
              De grootte van de msg wordt hier nu ook bijgehouden zodat de
              statistieken routines goed kunnen werken.
              Aantal van de statistiek tel routines worden nu vanuit hier
              aangeroepen.
     13-06-93 FlagPathAsExported ingebouwd om te voorkomen dat een bericht
              terug gestuurd wordt. We vlagden al de zender, maar nu ook de
              rest die in het path staan. Is alleen nodig bij node-onder-node
              constructies.
MD   17-06-93 Spatie verwijderd uit de '---' TearKludge omdat Frontdoor
              ook kludges zonder inhoud bleek te produceren.
MD   18-06-93 Toevoegen van de FTSC ^SplitLine
MD   18-06-93 Toevoegen van MsgExportMsgStyle uit mijn eigen FidoMsg.Pas
              verplaatst naar Msgs.Pas omdat ze heavy gebruik maakt van
              de lokale variabelen.
MD   24-06-93 Toevoegen van de AddToLineBuffer routine voor de Areafix
              routines
     18-07-93 Toevoegen van MsgsDeleteFirstRowFromBody
     23-09-93 Toevoegen van SYSTEMMODE (!!!!)
              Belangrijk, zo kunnen uitzonderings situaties zoals het tossen
              van BAD mail gecontroleerd worden door de routines.
     10-10-93 Moderated newsgroups worden nu ondersteund
     07-01-94 Bugfix: Mail pakketen sluiten na bericht (!)
     12-02-94 Te grote berichten worden nu apart gedumpt !

RWI  06-11-94 MAJOR CHANGE: Vanaf nu worden de CR's in de regels opgenomen
              en moeten ALLE routines dus aangepast worden zodat ze van die
              CR's niet over hun nek gaan.
              De vertaling voor Usenet naar LF's gebeurd bij het inlezen en
              wegschrijven van de berichten, dan wordt met een stukje
              assembly alle CR's in LF's veranderd of omgekeerd.
              MsgsAddLineTo voegt nu automatisch een CR toe aan het einde
              van de regel om compatible met de vorige versie te blijven.
              MsgsAddLineToNoEOL voegt geen CR toe.
     10-04-95 Line buffering op disk toegevoegd, zodat we straks geen
              TooBig meer nodig hebben.
              Tijdje stil gelegd ivm verhuizing naar Zweden.
     06-05-95 Per-regel adminstratie voor op disk gebufferde regels neemt
              te veel geheugen in beslag. Nu gaat ook de admin naar disk.
              MsgsGoSwap zorgt er nu voor dat FilePos van de swapfile weer
              op dezelfde plek staat als voor het swappen. Dit voorkomt
              problemen als tijdens het verwerken uit de swapfile er nieuwe
              regels naartoe verhuisd worden... Het kan overigens nog steeds
              wel mis gaan als we op twee plaatsen in het programma uit een
              swap blok aan het lezen zijn. Tijdens het splitten
              bijvoorbeeld als we de body aan het schrijven zijn en er moet
              een nieuwe header boven.
              MsgsInMem mogelijkheid verwijderd. MsgsDeleteFirstRowFromBody
              aangepast voor swapped mogelijkheid.
              MsgSearchLinePtr routine verwijderd.

RWI 950624 Flink zitten sleutelen zodat de PrivateMailScan en de ListServer
           het nu tenminste in alle vier de situaties goed doen: netmail,
           echomail, mail en news.
}

{ _F = Fido         }
{ _U = Usenet       }
{ _B = Bag supplier }

INTERFACE

USES FidoMsg,
     Database;

CONST MaxLenToUser_F   = 36;
      MaxLenFromUser_F = 36;
      MaxLenSubj_F     = 72;
      MaxLenPath_F     = 255;
      MaxLenDate_F     = 20;

      MaxLenUser_U         = 255;
    { MaxLenFromUser_U = 255;
      MaxLenToUser_U   = 255;    Deze vier zijn vervangen door MaxLenUser_U
      MaxLenReplyTo_U  = 255;
      MaxLenSender_U   = 255; }
      MaxLenSubj_U         = 255;
      MaxLenToAddr_U       = 255;
      MaxLenFromAddr_U     = 255;
      MaxLenPath_U         = 255;
      MaxLenDate_U         = 255;
      MaxLenOrganization_U = 255;
      MaxLenMsgId_U        = 255;
      MaxLenNewsgroups_U   = 255;

TYPE MsgType = (NotReady,                   { Nog niet klaar voor dat type }
                Local_Echomail,Local_Netmail,                      { Local }
                Netmail,Echomail,Dupe,Bad,                          { Fido }
                Mail,News,                                        { Usenet }
                PrivMail);                                      { Bullshit }

     WaarType = (wMem,       { per regel benaderbaar }
                 wSwapped);  { gepacked op disk }

     EenRegelRecordPtr = ^EenRegelRecord;
     EenRegelRecord    = RECORD
                               NextRegelRecordPtr : EenRegelRecordPtr;

                               Waar : WaarType;

                               CASE INTEGER OF
                        { wMem }    0 : (RegelPtr   : ^STRING;
                                         Len_Check  : BYTE);

                    { wSwapped }    1 : (SwapOffset : LONGINT);
                         END;

     TopRegelRecordPtr = ^TopRegelRecord;
     TopRegelRecord    = RECORD
                               TotalRegelLength    : LONGINT;
                               FirstRegelRecordPtr,
                               LastRegelRecordPtr  : EenRegelRecordPtr;
                         END;

     UsenetUserNameString = STRING[MaxLenUser_U];
     UsenetDomainNameString = STRING[MaxLenDomain];

     MessageRecord = RECORD
                           Ready_F,
                           Ready_U     : MsgType;
                           BadReason   : STRING;

                           FoundWtrBad : BOOLEAN;
                           ListServer  : BOOLEAN; { TRUE als msg distributie van mailing list }
                           WasGated    : BOOLEAN; { to usenet, ivm KillGatedNetmail }

                           { voor de stats }
                           MsgSize    : LONGINT; { in bytes }

                           { fido fields }
                           FromUser_F  : STRING[MaxLenFromUser_F];
                           ToUser_F    : STRING[MaxLenToUser_F];
                           ToAddr_F    : FidoAddrType;
                           FromAddr_F  : FidoAddrType;
                           Routed_F    : INTEGER;
                           Cost_F      : INTEGER;
                           Subj_F      : STRING[MaxLenSubj_F];
                           Path_F      : STRING[MaxLenPath_F];
                           Date_F      : STRING[MaxLenDate_F];
                           Attr_F      : WORD;
                           ExtAttr_F   : LONGINT;
                           Area_F      : STRING[MaxLenAreaName];
                           MsgIDOnly_F : STRING[20]; { !!alleen!! het ID uit de MSGID kludge }
                           ReplyID_F   : STRING[120];
                           MsgID_F     : STRING[120];
                           ReplyAKA    : FidoAddrType;
                           ReplyUser   : STRING[MaxLenUserName];
                           ReplyEmail  : STRING[MaxLenDomain];
                           ReplyAlso   : STRING[MaxLenDomain];
                           Chrs_F      : STRING[20];

                           { usenet fields }
                           FromUser_U     : UsenetUserNameString;
                           ToUser_U       : UsenetUserNameString;
                           ToSystem_U     : UUCPNameString;
                           Routed_U       : INTEGER;
                           Subj_U         : STRING[MaxLenSubj_U];
                           Path_U         : STRING[MaxLenPath_U];
                           Date_U         : STRING[MaxLenDate_U];
                           Newsgroups_U   : STRING[MaxLenNewsgroups_U];
                           ReplyTo_U      : UsenetUserNameString;
                           Sender_U       : UsenetUserNameString;
                           XqtTo_U        : UsenetUserNameString;
                           ApparentlyTo   : UsenetUserNameString;
                           ApparentlyFrom : UsenetUserNameString;
                           Control        : STRING;
                           FailXqtTo_U    : BOOLEAN;
                           Approved_U     : BOOLEAN;
                           References_U   : UsenetUserNameString;
                           Organization_U : STRING[MaxLenOrganization_U];
     { RWI 960404 }        InReplyTo_U    : STRING[MaxLenMsgId_U];
                           MessageId_U    : STRING[MaxLenMsgId_U];
                           IsMime         : BOOLEAN;
                           BBSUserIndex   : WORD;

                           { pointers naar de regels chains }
                           HeaderTop_F,
                           HeaderTop_U,
                           BodyTop,
                           FooterTop_F    : TopRegelRecordPtr;

                           MapAreaReplyAddrPtr : ^STRING;
                     END;

     ExportedListPtr = ^ExportedList;
     ExportedList    = ARRAY[1..65528] OF BYTE; { 0 = Nothing sent yet }
                                                { 1 = Has received msg }
                                                { 2 = Source, don't return }
                                                { 3 = Passive, don't send }
                                                { 4 = Already in Path }
                                                { 5 = Already in SeenBy }

     WhereToType = (Header_F,
                    Header_U,
                    Body,
                    Footer_F,
                    Unknown,
                    Bittenbak);

     SystemModeType = (smNORMAL,
                       smDISTRIBUTE,
                       smTOSSFIDOBAD,
                       smFDSCAN);

     MsgsCallProcType = PROCEDURE (VAR Regel : STRING);

      { let op! Mag niet lager als MINFREE (10000) in CalcMaxAllowedMem }
      {         plus een beetje voor de buffers die ze daar aanvragen.  }
CONST MSGS_LOWMEM_GOSWAP  = 25000; { als MemAvail hier onder duikt, dan de swapfile gaan gebruiken }
      MSGS_LOWMEM_GOTRASH = 5000;  { als MemAvail hier onder duikt, dan gaan trashen }
      MSGS_LOWMEM_PRESWAP = 50000; { als MemAvail hier onder zit voor MsgsForEach(Kill) dan swappen }

VAR Msg                 : MessageRecord;
    LineBuffer          : TopRegelRecordPtr;
    SystemMode          : SystemModeType;
    Exported            : ExportedListPtr;
    MsgTrashAllNewLines : BOOLEAN;
    FoundBagReturnUser  : BYTE; { 0=no attempt, 1=found, 2=not found }
    BagReturnRecordNr   : UserBaseRecordNrType;


PROCEDURE MsgsEmpty;
PROCEDURE MsgsEmptyKeepSwapfile;
PROCEDURE MsgsAddLineToNoEOL (WhereTo : WhereToType; Line : STRING);
PROCEDURE MsgsAddLineTo (WhereTo : WhereToType; Line : STRING);
PROCEDURE MsgsAddFirstLineToNoEOL (WhereTo : WhereToType; Line : STRING);
PROCEDURE MsgsAddFirstLineTo (WhereTo : WhereToType; Line : STRING);
PROCEDURE MsgsReleaseLines (VAR EersteRegelRecordPtr : TopRegelRecordPtr);
PROCEDURE MsgsNewSeek (RegelPtr : EenRegelRecordPtr);
PROCEDURE MsgsForEach (TopRegelPtr : TopRegelRecordPtr; CallProc : MsgsCallProcType);
PROCEDURE MsgsForEachKill (VAR TopRegelPtr : TopRegelRecordPtr; CallProc : MsgsCallProcType);
FUNCTION  MsgsSearchLine (Source : WhereToType; ZoekString : STRING; UpCaseFirst : BOOLEAN) : STRING;
PROCEDURE MsgsExport;
PROCEDURE MsgsExportUsenetMail;
PROCEDURE InitExportedList;
PROCEDURE JunkExportedList;

PROCEDURE ClearLineBuffer (VAR LineBuffer : TopRegelRecordPtr);
PROCEDURE AddToLineBufferNoEOL (VAR LineBuffer : TopRegelRecordPtr; Line : STRING);
PROCEDURE MoveRegelsToLineBuffer (VAR Regels,LineBuffer : TopRegelRecordPtr);
FUNCTION  CopyNLinesToLineBuffer (EenRegelPtr : EenRegelRecordPtr;
                                  VAR LineBuffer : TopRegelRecordPtr; LineCount : WORD) : BOOLEAN;
PROCEDURE AddToLineBuffer (VAR LineBuffer : TopRegelRecordPtr; Line : STRING);
PROCEDURE MsgsDeleteFirstRowFromBody;
FUNCTION  MsgsSizeOf (EenRegelPtr : EenRegelRecordPtr) : LONGINT; { RWI950416: was een WORD! :-( }


IMPLEMENTATION

USES Ramon,
     AreaBase,
     UserBase,
     MakeOut,
     Logs,
     Cfg,
     Strings,
     Translat,
     AreaMgr,
     ListSrv,
     Stats,
     Dos,
     Globals,
     Binkley,
     FBuffer,
     Usenet,
     Squish,
     FidoPkt,
     Routing,
     UUCPRout,
     SwapMem,
     Slice,
     Start,
     Fido,
     SeenBy;

VAR ExportedCount : WORD; { aantal records in de exported list }
    MsgTrashFile  : TEXT;


{---------------------------------------------------------------------------}
{ MsgsGoSwap                                                                }
{                                                                           }
{ Deze routine schrijft regels naar de swapfile, als daar nog ruimte is     }
{ ten minste. Het doel hiervan is weer intern geheugen vrij te maken om     }
{ meer regels te kunnen verwerken.                                          }
{                                                                           }
{ Eerst was er een structuur waarbij alleen de data van de regel naar disk  }
{ werd geschreven, maar er nog wel _per regel_ een administratie record     }
{ aanwezig was om de lengte van de regel en de offset van de data in de     }
{ swapfile bij te houden.                                                   }
{                                                                           }
{ Als een pointer naar een EenRegelRecord record wijst met een Waar type    }
{ van wSwapped, dan moet vanaf de swapfile offset in dat record alle regels }
{ verwerkt worden. Eerst moet de lengte van disk gelezen worden en daarna   }
{ kan de hele regel ingelezen worden. Als de lengte 0 is, dan is het einde  }
{ van dit swap blok bereikt.                                                }
{                                                                           }
{ Deze routine schrijft het nieuwe swap blok altijd aan het einde van de    }
{ swapfile bij. Er is geen gap administratie dus. Dit is niet zo erg, want  }
{ aan het begin van het volgende bericht wordt de swapfile eerste weer leeg }
{ gemaakt.                                                                  }
{                                                                           }
PROCEDURE MsgsGoSwap (VAR TopPtr : TopRegelRecordPtr);

TYPE BufArray    = ARRAY[0..65520] OF BYTE;
     BufArrayPtr = ^BufArray;

VAR OldPos,
    NewPos  : LONGINT;
    NewPtr,
    OldPtr  : EenRegelRecordPtr;
    Keep    : BOOLEAN;
    Len     : WORD;
    BufLen  : WORD;
    BufOfs  : WORD;
    BufPtr  : BufArrayPtr;

BEGIN
     IF (TopPtr = NIL) OR (NOT SwapIsOpen) THEN
        Exit;

     PeekMem; { nu zit het geheugen propje vol }

     WindowPush (62,3,15,1);
     WriteXY (62,3,' SWAPPING... ');

     { Om fragmentatie te voorkomen, zetten we de hele chain opnieuw op.  }
     { Anders zou het geheugen steeds meer uit kleine stukjes vrijgegeven }
     { regels gaan bestaan, waar bijna niets meer te beginnen is (ik heb  }
     { die fragmentatie teller gezien!)                                   }

     WITH TopPtr^ DO
     BEGIN
          OldPtr:=FirstRegelRecordPtr;
          FirstRegelRecordPtr:=NIL;
          LastRegelRecordPtr:=NIL;
     END;

     OldPos:=FilePos (SwapFile);

     { doorloop alle regel record }
     WHILE (OldPtr <> NIL) DO
     BEGIN
          {LogExtraMessage ('Admin block at '+Long2HexString (Longint (OldPtr))+' Waar='+Byte2String (Byte (OldPtr^.Waar)));}

          IF (OldPtr^.Waar = wMem) THEN
          BEGIN
               { begin van een blok wMem regels (1 of meer) die naar }
               { disk kunnen.                                        }

               NewPos:=FileSize (SwapFile);

               IF (NewPos > MaxSwapLen) THEN
               BEGIN
                    { swap file zit vol. Nog niets veranderd, dus we }
                    { kunnen nog terug.                              }
                    LogMessage ('Swap file is full!');
                    Break; { uit de while }
               END;

               { breng de swapfile in positie }
               Seek (SwapFile,NewPos);

               {LogExtraMessage ('  Writing wMem block to '+Longint2String (NewPos));}

               { maak een buffer aan om de regels in te bufferen voordat }
               { ze naar disk geschreven worden.                         }
               BufLen:=65520;
               WHILE (MaxAvail < BufLen) DO
                     BufLen:=BufLen DIV 2;

               GetMem (BufPtr,BufLen);
               {$IFDEF LogGetMem} LogGetMem (BufPtr,BufLen,'MsgsGoSwap (1)'); {$ENDIF}
               BufOfs:=0;

               { nu alle volgende wMem regels naar de swapfile schrijven }
               { en hun geheugen vrijgeven.                              }
               WHILE (OldPtr <> NIL) AND (OldPtr^.Waar = wMem) DO
                     WITH OldPtr^ DO
                     BEGIN
                          Len:=Byte (RegelPtr^[0])+1;

                          IF ((BufLen-BufOfs) < Len) THEN
                          BEGIN
                               BlockWrite (SwapFile,BufPtr^[0],BufOfs);
                               BufOfs:=0;
                          END;

                          { schrijf de regel, inclusief lengte byte, naar de swapfile }
                          {BlockWrite (SwapFile,RegelPtr^[0],Len);}
                          Move (RegelPtr^[0],BufPtr^[BufOfs],Len);
                          Inc (BufOfs,Len);

                          { geef het geheugen voor de regel zelf vrij }
                          FreeMem (RegelPtr,Len);

                          { bewaar de pointer naar het volgende record even }
                          {RAWI 980215: crashed here once, error 204: invalid pointer operation}
                          {which means it points outside the heap}
                          NewPtr:=NextRegelRecordPtr;

                          { geef het regel record zelf vrij }
                          FreeMem (OldPtr,SizeOf (EenRegelRecord));

                          { laat OldPtr naar het volgende record wijzigen }
                          OldPtr:=NewPtr;
                     END; { while blok met wMem regels }

               { nu meteen het buffer leegmaken }
               IF (BufOfs > 0) THEN
               BEGIN
                    BlockWrite (SwapFile,BufPtr^[0],BufOfs);
                    BufOfs:=0;
               END;

               FreeMem (BufPtr,BufLen);

               { RWI 950910: Hier naartoe verplaatst om problemen te     }
               {             voorkomen als er GEEN blok toegevoegd wordt }

               { schrijf een eind record naar de swapfile }
               Len:=0;
               BlockWrite (SwapFile,Len,1);

               { in de nieuwe keten wordt een swap record aangemaakt }
               GetMem (NewPtr,SizeOf (EenRegelRecord));
               {$IFDEF LogGetMem} LogGetMem (NewPtr,SizeOf (EenRegelRecord),'MsgsGoSwap (2)'); {$ENDIF}

               WITH NewPtr^ DO
               BEGIN
                    NextRegelRecordPtr:=NIL;
                    Waar:=wSwapped;
                    SwapOffset:=NewPos;
               END;

               {LogExtraMessage ('  New admin block at '+Long2HexString (Longint (NewPtr)));}

               { link dit record in de TopPtr chain }
               WITH TopPtr^ DO
               BEGIN
                    IF (LastRegelRecordPtr = NIL) THEN
                       FirstRegelRecordPtr:=NewPtr
                    ELSE
                        LastRegelRecordPtr^.NextRegelRecordPtr:=NewPtr;

                    LastRegelRecordPtr:=NewPtr;
               END;

          END ELSE { wMem found }
          BEGIN
               { dit is geen wMem blok, dus een wSwapped block. }
               { Die toevoegen aan de nieuwe chain en verder niet aanraken. }

               {LogExtraMessage ('  Swapped at '+Longint2String (OldPtr^.SwapOffset));}

               { bewaar de pointer naar het volgende record }
               NewPtr:=OldPtr^.NextRegelRecordPtr;

               OldPtr^.NextRegelRecordPtr:=NIL;

               WITH TopPtr^ DO
               BEGIN
                    { link dit record in de TopPtr chain }
                    IF (LastRegelRecordPtr = NIL) THEN
                       FirstRegelRecordPtr:=OldPtr
                    ELSE
                        LastRegelRecordPtr^.NextRegelRecordPtr:=OldPtr;

                    LastRegelRecordPtr:=OldPtr;
               END;

               { en wij vrolijk verder naar het volgende record }
               OldPtr:=NewPtr;
          END;
     END; { while not end of old chain }

     IF (FileSize (SwapFile) > SwapTopUse) THEN
        SwapTopUse:=FileSize (SwapFile);

     { herstel de huidige positie in de swapfile, zodat het niet mis kan }
     { gaan als we nu midden in een verwerking zitten.                   }
     Seek (SwapFile,OldPos);

     WindowPop; { "SWAPPING" }

     PeekMem;
END;


{--------------------------------------------------------------------------}
{ CreateLine                                                               }
{                                                                          }
{ Met deze routine kan een nieuwe regel aangemaakt worden. Als het TopRec  }
{ nog niet bestaat, dan wordt deze aangemaakt en gevuld. Anders wordt er   }
{ gewoon een nieuwe regel aangemaakt op de heap en de TopRec.LastPtr       }
{ aangepast. De pointer naar de nieuw aangemaakte regel wordt terug        }
{ gegeven.                                                                 }
{                                                                          }
{ Deze routine is vervangen op 27-02-93 omdat ie te traag was. Dit kwam    }
{ omdat voor iedere nieuw aan te sluiten regel de hele structuur opnieuw   }
{ doorzocht werd naar de laatste regel. Deze is nu direct bereikbaar       }
{ vanuit het TopRecord.                                                    }
{                                                                          }
FUNCTION CreateLine (VAR EersteRegelRecordPtr : TopRegelRecordPtr; LineLength : BYTE) : EenRegelRecordPtr;

VAR NewRegelRecordPtr : EenRegelRecordPtr;

BEGIN
     GetMem (NewRegelRecordPtr,SizeOf (EenRegelRecord));
     {$IFDEF LogGetMem} LogGetMem (NewRegelRecordPtr,SizeOf (EenRegelRecord),'CreateLine (1)'); {$ENDIF}

     WITH NewRegelRecordPtr^ DO
     BEGIN
          NextRegelRecordPtr:=NIL;
          Waar:=wMem;
          RegelPtr:=NIL;
          Len_Check:=0;
     END; { with }

     CreateLine:=NewRegelRecordPtr;

     IF (EersteRegelRecordPtr <> NIL) THEN
        WITH EersteRegelRecordPtr^ DO
        BEGIN
             LastRegelRecordPtr^.NextRegelRecordPtr:=NewRegelRecordPtr;
             LastRegelRecordPtr:=NewRegelRecordPtr;
             { bewaar de regel lengte }
             Inc (TotalRegelLength,LineLength);
             Exit;
        END; { with,if }

     { er was nog geen top record. Maakt die nu aan }
     GetMem (EersteRegelRecordPtr,SizeOf (TopRegelRecord));
     {$IFDEF LogGetMem} LogGetMem (EersteRegelRecordPtr,SizeOf (TopRegelRecord),'CreateLine (2)'); {$ENDIF}

     WITH EersteRegelRecordPtr^ DO
     BEGIN
          TotalRegelLength:=LineLength;
          FirstRegelRecordPtr:=NewRegelRecordPtr;
          LastRegelRecordPtr:=NewRegelRecordPtr;
     END;
END;


{--------------------------------------------------------------------------}
{ CreateFirstLine                                                          }
{                                                                          }
{ Deze routine maakt een regel aan aan het begin van de lijst.             }
{                                                                          }
FUNCTION CreateFirstLine (VAR EersteRegelRecordPtr : TopRegelRecordPtr; LineLength : BYTE) : EenRegelRecordPtr;

VAR NewRegelRecordPtr : EenRegelRecordPtr;

BEGIN
     GetMem (NewRegelRecordPtr,SizeOf (EenRegelRecord));
     {$IFDEF LogGetMem} LogGetMem (NewRegelRecordPtr,SizeOf (EenRegelRecord),'CreateFirstLine (1)'); {$ENDIF}

     WITH NewRegelRecordPtr^ DO
     BEGIN
          {
          IF (EersteRegelRecordPtr = NIL) THEN
             Error ('[CreateFirstLine] TopRegelRecordPtr = NIL!');
          }
          { Hier ging het mis als EersteRegelRecordPtr nog NIL is... }
          { Nu wordt de toekenning verderop gedaan.  RWI 950312.     }

          NextRegelRecordPtr:=NIL; { inchainen alleen als het straks kan }
          Waar:=wMem;
          RegelPtr:=NIL;
          Len_Check:=0;
     END; { with }

     CreateFirstLine:=NewRegelRecordPtr;

     IF (EersteRegelRecordPtr <> NIL) THEN
     BEGIN
          { RWI 950312: hier mag ie wel ingechained worden }
          NewRegelRecordPtr^.NextRegelRecordPtr:=EersteRegelRecordPtr^.FirstRegelRecordPtr;

          EersteRegelRecordPtr^.FirstRegelRecordPtr:=NewRegelRecordPtr;
          { bewaar de regel lengte }
          Inc (EersteRegelRecordPtr^.TotalRegelLength,LineLength);
          Exit;
     END; { with,if }

     { top record was er nog niet. Maak die aan }
     GetMem (EersteRegelRecordPtr,SizeOf (TopRegelRecord));
     {$IFDEF LogGetMem} LogGetMem (EersteRegelRecordPtr,SizeOf (TopRegelRecord),'CreateFirstLine (2)'); {$ENDIF}

     WITH EersteRegelRecordPtr^ DO
     BEGIN
          TotalRegelLength:=LineLength;
          FirstRegelRecordPtr:=NewRegelRecordPtr;
          LastRegelRecordPtr:=NewRegelRecordPtr;
     END;
END;


{--------------------------------------------------------------------------}
{ MsgsReleaseLines                                                         }
{                                                                          }
{ Met deze routine kunnen de aangevraagde stukken geheugen waarin de lines }
{ zijn opgeslagen, weer worden vrijgegeven. Daarna wordt ook het TopRecord }
{ weer vrijgegeven.                                                        }
{                                                                          }
PROCEDURE MsgsReleaseLines (VAR EersteRegelRecordPtr : TopRegelRecordPtr);

VAR EraseRegelRecordPtr : EenRegelRecordPtr;

BEGIN
     IF (EersteRegelRecordPtr = NIL) THEN
        Exit;

     WITH EersteRegelRecordPtr^ DO
          WHILE (FirstRegelRecordPtr <> NIL) DO
          BEGIN
               EraseRegelRecordPtr:=FirstRegelRecordPtr;
               FirstRegelRecordPtr:=FirstRegelRecordPtr^.NextRegelRecordPtr;

               WITH EraseRegelRecordPtr^ DO
                    IF (Waar = wMem) THEN
                    BEGIN
                         { RWI950322: nu wordt het geheugen alleen vrij   }
                         {            gegeven als de regel in gebruik is. }
                         IF (RegelPtr <> NIL) THEN
                         BEGIN
                              IF (Len_Check <> Length (RegelPtr^)) THEN
                              BEGIN
                                   LogMessage ('[Msgs] Modified ('+
                                               SignedInteger2String (Length (RegelPtr^)-Len_Check)+
                                               '): '+RegelPtr^);
                                   LogClose; { voor het geval we crashen }
                              END;

                              FreeMem (RegelPtr,Byte (RegelPtr^[0])+1);
                         END;
                    END; { if, with }

               FreeMem (EraseRegelRecordPtr,SizeOf (EenRegelRecord));
          END; { while, with }

     FreeMem (EersteRegelRecordPtr,SizeOf (TopRegelRecord));
     EersteRegelRecordPtr:=NIL;
END;


{--------------------------------------------------------------------------}
{ MsgsEmpty                                                                }
{                                                                          }
{ Deze routine maakt de universele interne message leeg en vult de struc-  }
{ tuur met NIL pointers. De acties in deze routine moeten zo kort mogelijk }
{ gemaakt worden omdat voor ieder mailtje dat verwerkt moet worden dit     }
{ record leeg gemaakt wordt met deze routine.                              }
{                                                                          }
{ RWI 950910: MsgsEmptyKeepSwapfile toegevoegd, zodat bij het schrijven    }
{             van een reply waarbij de Swapfile in een linebuffer gebruikt }
{             wordt, de swapfile niet weggegooid wordt.                    }
{                                                                          }
PROCEDURE MsgsEmptyKeepSwapfile;
BEGIN
     IF MsgTrashAllNewLines THEN
        Close (MsgTrashFile);

     MsgTrashAllNewLines:=FALSE;

     PrevKludgeID:=klNone;

     WITH Msg DO
     BEGIN
          MsgsReleaseLines (HeaderTop_F);
          MsgsReleaseLines (HeaderTop_U);
          MsgsReleaseLines (BodyTop);
          MsgsReleaseLines (FooterTop_F);

          Ready_F:=NotReady;
          Ready_U:=NotReady;
          BadReason:='';
          FoundWtrBad:=FALSE;
          WasGated:=FALSE;
          ListServer:=FALSE;

          MsgSize:=0;

        { niet wissen omdat in FIDO.PAS bij het importeren de nieuwe
          area gegevens alleen worden ingelezen als de area naam verschilt
          van de vorige msg. Dan moeten wij hem hier natuurlijk niet
          alsnog leeg gaan halen.

          AreaBaseRecordNr:=NILRecordNr;
        }

          { fido fields }
          Routed_F:=0;
          FromUser_F:='';
          ToUser_F:='';
          FidoSplit ('0',ToAddr_F);
          FromAddr_F:=ToAddr_F;
          Subj_F:='';
          Path_F:='';
          Date_F:='';
          Attr_F:=0;
          ExtAttr_F:=0;
          Cost_F:=0;
          Area_F:='';
          MsgIDOnly_F:='';
          ReplyID_F:='';
          MsgID_F:='';
          ReplyAKA:=FromAddr_F;
          ReplyUser:='';
          ReplyEmail:='';
          ReplyAlso:='';
          Chrs_F:='';

          { usenet fields }
          Routed_U:=0;
          FromUser_U:='';
          ToUser_U:='';
          ToSystem_U:='';
          Subj_U:='';
          Path_U:='';
          Date_U:='';
          Newsgroups_U:='';
          ReplyTo_U:='';
          Sender_U:='';
          FailXqtTo_U:=FALSE;
          Approved_U:=FALSE;
          References_U:='';
          Organization_U:='';
          MessageId_U:='';
          InReplyTo_U:='';
          ApparentlyTo:='';
          ApparentlyFrom:='';
          Control:='';

          IsMime:=FALSE;
          BBSUserIndex:=NILRecordNr;

          MapAreaReplyAddrPtr:=NIL;


        { Niet wissen, omdat de .X inlees routines deze invullen en pas bij
          de .D verwerk routines deze routine pas wordt aangeroepen en de
          data dan verloren zou gaan.

          XqtTo_U:='';
        }
     END; { msg }
END;

PROCEDURE MsgsEmpty;
BEGIN
     MsgsEmptyKeepSwapfile;
     {$IFDEF WtrGate}
     EmptySwapfile; { ook meteen geen last meer van gaps! }
     {$ENDIF}
END;


{--------------------------------------------------------------------------}
{ MsgsTrashDumpLines                                                       }
{                                                                          }
PROCEDURE MsgTrashDumpLines (Source : TopRegelRecordPtr);

VAR EenRegelPtr : EenRegelRecordPtr;
    Line        : STRING;
    IORes       : BYTE;

BEGIN
     { RWI950605: controle op NIL toegevoegd. Kwam anders in een oneindige }
     {            lus terecht.                                             }
     IF (Source = NIL) THEN
        Exit;

     EenRegelPtr:=Source^.FirstRegelRecordPtr;
     MsgsNewSeek (EenRegelPtr);

     WHILE (EenRegelPtr <> NIL) DO
     BEGIN
          CASE EenRegelPtr^.Waar OF
               wMem :
                   BEGIN
                        Line:=EenRegelPtr^.RegelPtr^;
                        EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                        MsgsNewSeek (EenRegelPtr);
                   END;

               wSwapped :
                   BEGIN
                        BlockRead (SwapFile,Line[0],1);

                        IF (Line[0] = #0) THEN
                        BEGIN
                             EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                             MsgsNewSeek (EenRegelPtr);
                             Continue;
                        END;

                        BlockRead (SwapFile,Line[1],Byte (Line[0]));
                   END;
          END; { case }

          { speciale verwerking zodat #13's vertaald worden in Cr+Lf }
          WHILE (Line <> '') DO
          BEGIN
               IF (Pos (#13,Line) > 0) THEN
               BEGIN
                    { RWI 950202: Write veranderd in WriteLn. Fixed overwrite dump bug }
                    WriteLn (MsgTrashFile,Copy (Line,1,Pos (#13,Line)-1));
                    Delete (Line,1,Pos (#13,Line));
               END ELSE
               BEGIN
                    Write (MsgTrashFile,Line);
                    Line:='';
               END;
          END; { while line <> '' }
     END; { while not end of lines }
END;


{--------------------------------------------------------------------------}
{ MsgsTrashHeader                                                          }
{                                                                          }
{ Schrijft de header van een te groot bericht naar de trashcan.            }
{                                                                          }
PROCEDURE MsgsTrashHeader;
BEGIN
     {$I-}
     { dump de header informatie naar disk }
     WriteLn (MsgTrashFile,RepChar (79,'-'));
     WriteLn (MsgTrashFile,DesktopProgramName+' '+FullProgramVersion);
     WriteLn (MsgTrashFile,RepChar (79,'-'));

     IF (Msg.Ready_F <> NotReady) THEN
     BEGIN
          WriteLn (MsgTrashFile,'From: ',Msg.FromUser_F,',',Fido2Str (Msg.FromAddr_F));
          WriteLn (MsgTrashFile,'To  : ',Msg.ToUser_F,',',Fido2Str (Msg.ToAddr_F));
          WriteLn (MsgTrashFile,'Subj: ',Msg.Subj_F);
          WriteLn (MsgTrashFile,'Date: ',Msg.Date_F);
          WriteLn (MsgTrashFile,RepChar (79,'-'));

         { Dump de fido header naar de logfile }
           MsgTrashDumpLines (Msg.HeaderTop_F);
     END ELSE
     BEGIN
          { dump de Usenet header naar de logfile }
          MsgTrashDumpLines (Msg.HeaderTop_U);
     END;
     {$I+}
END;


{--------------------------------------------------------------------------}
{ MsgsAddLineTo en MsgsAddLineToNoEOL                                      }
{                                                                          }
{ Met deze routine kan een regel worden toegevoegd aan de universele msg.  }
{ Door middel van de WhereTo kan gekozen worden uit de header, body of de  }
{ footer.                                                                  }
{                                                                          }
{ RvdW 04-04-93 Foutje bij het toevoegen van de Bittenbak optie. De Exit   }
{               in de case stond er niet, dus NewRegelRecordPtr was onge-  }
{               definieerd en dat gaf bij fouten na het case statement.    }
{                                                                          }
PROCEDURE MsgsAddLineToNoEOL (WhereTo : WhereToType; Line : STRING);

VAR NewRegelRecordPtr : EenRegelRecordPtr;
    IORes             : BYTE;
    DumpName          : STRING;

BEGIN
     IF MsgTrashAllNewLines THEN
     BEGIN
          WHILE (Line <> '') DO
          BEGIN
               IF (Pos (#13,Line) > 0) THEN
               BEGIN
                    WriteLn (MsgTrashFile,Copy (Line,1,Pos (#13,Line)-1));
                    Delete (Line,1,Pos (#13,Line));
               END ELSE
               BEGIN
                    Write (MsgTrashFile,Line);
                    Line:='';
               END;
          END; { while }

          Exit;
     END;

     CASE WhereTo OF
          Header_F  : NewRegelRecordPtr:=CreateLine (Msg.HeaderTop_F,Length (Line));
          Header_U  : NewRegelRecordPtr:=CreateLine (Msg.HeaderTop_U,Length (Line));
          Body      : NewRegelRecordPtr:=CreateLine (Msg.BodyTop,Length (Line));
          Footer_F  : NewRegelRecordPtr:=CreateLine (Msg.FooterTop_F,Length (Line));
          Bittenbak : Exit; { poof! :-) }
     END; { case }

     GetMem (NewRegelRecordPtr^.RegelPtr,Length (Line)+1);
     {$IFDEF LogGetMem} LogGetMem (NewRegelRecordPtr^.RegelPtr,Length (Line)+1,'MsgsAddLineToNoEOL'); {$ENDIF}
     NewRegelRecordPtr^.RegelPtr^:=Line;
     NewRegelRecordPtr^.Len_Check:=Length (Line);
     Inc (Msg.MsgSize,Length (Line));

     { deze vergelijking moet ruimte vrij maken. Als dat niet lukt, }
     { dan reageert de opvolger van deze routine met het trashen    }
     { van de file.                                                 }
     { RWI 960309: MemAvail veranderd in MaxAvail ivm CalcMaxAllowedMem }
     IF (MaxAvail < MSGS_LOWMEM_GOSWAP) THEN
     BEGIN
          {
          IF Config.LogDebug THEN
             LogMessage ('Swapping body. Pre: '+Longint2String (MemAvail)+'/'+Longint2String (MaxAvail));
          }

          MsgsGoSwap (Msg.BodyTop);

          {
          IF Config.LogDebug THEN
             LogExtraMessage ('Post: '+Longint2String (MemAvail)+'/'+Longint2String (MaxAvail));
          }
     END;

     { header en body mogen nu ook naar disk, maar doen we nog even niet }
     { in verband met de verwerkings snelheid. De code is overal al      }
     { aanwezig en gaat er vanuit dat de header en footer op disk kunnen }
     { staan (neath eh?)                                                 }

     { als er nu nog steeds te weinig geheugen vrij is, dan gaan we }
     { dumpen. Zou eigenlijk nooit meer voor mogen komen.           }
     IF (NOT MsgTrashAllNewLines) AND (MemAvail < MSGS_LOWMEM_GOTRASH) THEN
     BEGIN
          DumpName:=Config.TooLargePath+GetFidoPktName;
          Assign (MsgTrashFile,DumpName);
          {$I-} ReWrite (MsgTrashFile); {$I+}
          IORes:=IOResult;
          IF (IORes <> 0) THEN
          BEGIN
               LogDiskIOError (IORes,'Unable to create dump file: '+DumpName);
               Exit;
          END;

          LogMessage ('Out of memory. Dumping msg to '+DumpName);
          MsgsTrashHeader;
          MsgTrashDumpLines (Msg.BodyTop);
          MsgTrashAllNewLines:=TRUE;

          { RWI 961028: geheugen vrij geven }
          MsgsReleaseLines (Msg.BodyTop);
     END;
END;

PROCEDURE MsgsAddLineTo (WhereTo : WhereToType; Line : STRING);
BEGIN
     MsgsAddLineToNoEOL (WhereTo,Line+#13);
END;


{--------------------------------------------------------------------------}
{ MsgsAddFirstLineTo                                                       }
{                                                                          }
{ Met deze routine kan een regel worden toegevoegd aan de universele msg.  }
{ Door middel van de WhereTo kan gekozen worden uit de header, body of de  }
{ footer. Er wordt automatisch een CR toegevoegd.                          }
{                                                                          }
PROCEDURE MsgsAddFirstLineToNoEOL (WhereTo : WhereToType; Line : STRING);

VAR NewRegelRecordPtr : EenRegelRecordPtr;

BEGIN
     CASE WhereTo OF
          Header_F  : NewRegelRecordPtr:=CreateFirstLine (Msg.HeaderTop_F,Length (Line));
          Header_U  : NewRegelRecordPtr:=CreateFirstLine (Msg.HeaderTop_U,Length (Line));
          Body      : NewRegelRecordPtr:=CreateFirstLine (Msg.BodyTop,Length (Line));
          Footer_F  : NewRegelRecordPtr:=CreateFirstLine (Msg.FooterTop_F,Length (Line));
          Bittenbak : Exit; { poof! :-}
     END; { case }

     GetMem (NewRegelRecordPtr^.RegelPtr,Length (Line)+1);
     {$IFDEF LogGetMem} LogGetMem (NewRegelRecordPtr^.RegelPtr,Length (Line)+1,'MsgsAddFirstLineToNoEOL'); {$ENDIF}

     NewRegelRecordPtr^.RegelPtr^:=Line;
     NewRegelRecordPtr^.Len_Check:=Length (Line);
     Inc (Msg.MsgSize,Length (Line));
END;

PROCEDURE MsgsAddFirstLineTo (WhereTo : WhereToType; Line : STRING);
BEGIN
     MsgsAddFirstLineToNoEOL (WhereTo,Line+#13);
END;


{---------------------------------------------------------------------------}
{ MsgsNewSeek                                                               }
{                                                                           }
{ Deze routine moet worden aangeroepen als een EenRegelRecordPtr naar een   }
{ nieuwe EenRegelRecord wijst. Als dit nieuwe record namelijk een Waar type }
{ wSwapPacked heeft, dan moet er een seek in de swapfile plaatsvinden. Dat  }
{ gebeurd hier.                                                             }
{                                                                           }
PROCEDURE MsgsNewSeek (RegelPtr : EenRegelRecordPtr);
BEGIN
     IF (RegelPtr <> NIL) AND (RegelPtr^.Waar = wSwapped) THEN
        Seek (SwapFile,RegelPtr^.SwapOffset);
END;


{---------------------------------------------------------------------------}
{ MsgsForEach                                                               }
{                                                                           }
{ Deze routine doorloopt iedere regel in het opgegeven blok en roept de     }
{ opgegeven routine aan met als argument een pointer naar de regel. Als de  }
{ regel in het geheugen staat is het simpel. Anders wordt ie uit de         }
{ swapfile gelezen en in een lokale variabele opgeslagen.                   }
{                                                                           }
{ Hele leuke routine, maar kan niet gebruikt worden voor object shit als    }
{ de CallProc bij attributen van het object moet kunnen... CallProc moet    }
{ dan een member van het object zijn, want als subproc mag het niet van BP. }
{ Zonder object shit kan je nog lekker vies doen gelukken.                  }
{                                                                           }
PROCEDURE MsgsForEach (TopRegelPtr : TopRegelRecordPtr; CallProc : MsgsCallProcType);

VAR EenRegelPtr : EenRegelRecordPtr;
    RegelLength : BYTE;
    Regel       : STRING; { voor swapped regels }

BEGIN
     IF (TopRegelPtr = NIL) THEN
        Exit;

     EenRegelPtr:=TopRegelPtr^.FirstRegelRecordPtr;
     MsgsNewSeek (EenRegelPtr);

     WHILE (EenRegelPtr <> NIL) DO
     BEGIN
          CASE EenRegelPtr^.Waar OF
               wMem :
                   BEGIN
                        RegelLength:=Length (EenRegelPtr^.RegelPtr^);
                        CallProc (EenRegelPtr^.RegelPtr^);

                        IF (RegelLength <> Length (EenRegelPtr^.RegelPtr^)) THEN
                           LogMessage ('[MFE] Modify: '+EenRegelPtr^.RegelPtr^);

                        EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                        MsgsNewSeek (EenRegelPtr);
                   END;

               wSwapped :
                   BEGIN
                        { lees de lengte van de regel in }
                        BlockRead (SwapFile,RegelLength,1);

                        { einde van het swapped blok? }
                        IF (RegelLength = 0) THEN
                        BEGIN
                             { ja, ga naar de volgende regel }
                             EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                             MsgsNewSeek (EenRegelPtr);
                             Continue;
                        END;

                        { lees de regel zelf in }
                        BlockRead (SwapFile,Regel[1],RegelLength);
                        Regel[0]:=Char (RegelLength);

                        { verwerk de regel }
                        CallProc (Regel);
                   END;
          END; { case }
     END; { while }
END;


{---------------------------------------------------------------------------}
{ MsgsForEachKill                                                           }
{                                                                           }
{ As MsgsForEach, but frees each processed line.                            }
{                                                                           }
PROCEDURE MsgsForEachKill (VAR TopRegelPtr : TopRegelRecordPtr; CallProc : MsgsCallProcType);

VAR KillRegelPtr,
    EenRegelPtr  : EenRegelRecordPtr;
    RegelLength  : BYTE;
    Regel        : STRING; { voor swapped regels }

BEGIN
     IF (TopRegelPtr = NIL) THEN
        Exit;

     { RAWI 970608: now swapping when running low of memory to avoid    }
     {              problems later on. Without this, the lines occupied }
     {              by TopRegelPtr would never be swapped out.          }
     IF (MemAvail < MSGS_LOWMEM_PRESWAP) THEN
        MsgsGoSwap (TopRegelPtr);

     EenRegelPtr:=TopRegelPtr^.FirstRegelRecordPtr;
     MsgsNewSeek (EenRegelPtr);

     WHILE (EenRegelPtr <> NIL) DO
     BEGIN
          CASE EenRegelPtr^.Waar OF
               wMem :
                   BEGIN
                        Regel:=EenRegelPtr^.RegelPtr^;
                        RegelLength:=Length (Regel);

                        KillRegelPtr:=EenRegelPtr;
                        EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;

                        FreeMem (KillRegelPtr^.RegelPtr,RegelLength+1);
                        FreeMem (KillRegelPtr,SizeOf (EenRegelRecord));

                        CallProc (Regel);

                        IF (RegelLength <> Length (Regel)) THEN
                           LogMessage ('[MFEK] Modify: '+Regel);

                        MsgsNewSeek (EenRegelPtr);
                   END;

               wSwapped :
                   BEGIN
                        { lees de lengte van de regel in }
                        BlockRead (SwapFile,RegelLength,1);

                        { einde van het swapped blok? }
                        IF (RegelLength = 0) THEN
                        BEGIN
                             { ja, ga naar de volgende regel }
                             KillRegelPtr:=EenRegelPtr;
                             EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                             FreeMem (KillRegelPtr,SizeOf (EenRegelRecord));
                             MsgsNewSeek (EenRegelPtr);
                             Continue;
                        END;

                        { lees de regel zelf in }
                        BlockRead (SwapFile,Regel[1],RegelLength);
                        Regel[0]:=Char (RegelLength);

                        { verwerk de regel }
                        CallProc (Regel);
                   END;
          END; { case }
     END; { while }

     FreeMem (TopRegelPtr,SizeOf (TopRegelRecord));
     TopRegelPtr:=NIL;
END;


{--------------------------------------------------------------------------}
{ MsgsSizeOf                                                               }
{                                                                          }
{ Deze routine berekent het aantal bytes dat een header,body of footer     }
{ in beslag neemt. Deze gegevens zijn namelijk nodig voordat er            }
{ geexporteerd kan gaan worden.                                            }
{ Iedere regel is Length (Regel) bytes +1 lang, +1 omdat er een #13 (bij   }
{ Fido) of een #10 (bij Usenet) aan iedere regel wordt toegevoegd.         }
{                                                                          }
{ RWI 941220: Bugfix. Door het opslaan van de #13 in de interne structuur  }
{             hoeft de +1 nu niet meer. Vette bug dus...                   }
{                                                                          }
FUNCTION MsgsSizeOf (EenRegelPtr : EenRegelRecordPtr) : LONGINT; { RWI950416: was een WORD! :-( }

VAR TotaalBytes : LONGINT;
    RegelLength : BYTE;

BEGIN
     TotaalBytes:=0;

     MsgsNewSeek (EenRegelPtr);

     WHILE (EenRegelPtr <> NIL) DO
     BEGIN
          CASE EenRegelPtr^.Waar OF
               wMem :
                   BEGIN
                        Inc (TotaalBytes,Length (EenRegelPtr^.RegelPtr^));
                        EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                        MsgsNewSeek (EenRegelPtr);
                   END;

               wSwapped :
                   BEGIN
                        BlockRead (SwapFile,RegelLength,1);

                        IF (RegelLength = 0) THEN
                        BEGIN
                             EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                             MsgsNewSeek (EenRegelPtr);
                             Continue;
                        END;

                        Inc (TotaalBytes,RegelLength);

                        { sla de regel data over }
                        Seek (SwapFile,FilePos (SwapFile)+RegelLength);
                   END;
          END; { case }
     END; { while }

     MsgsSizeOf:=TotaalBytes;
END;


{--------------------------------------------------------------------------}
{ MsgsExportInUsenetStyle                                                  }
{                                                                          }
{ Deze routine export de Universele Msg naar alle op de area aangesloten   }
{ Usenet nodes. Deze routine geeft TRUE terug als er tussen de aangesloten }
{ users ook Fido users zaten. Op dat moment moet de msg namelijk vertaald  }
{ worden naar Fido style en daar ook geexporteerd.                         }
{                                                                          }
{ Omdat het mogelijk is dat we niet genoeg geheugen hebben om het HELE     }
{ bericht klaar te maken voor export, kan deze routine het ook in stukken  }
{ versturen. Hij houdt bij welke regel ie als laatste verwerkt heeft. Als  }
{ de volgende regel er niet meer bij kan, dan stopt het inpakken en wordt  }
{ er eerst geexporteerd. Daarna volgt een tweede, derde, etc. ronde voor   }
{ de rest van het bericht.                                                 }
{                                                                          }
{ RWI 950217: Alleen de eerste 64k van een groot newsje werd geexporteerd. }
{             Aanpassingen in de structuur gemaakt zodat nu wel weer alle  }
{             blokken geexporteerd worden. Het bericht wordt nu per user   }
{             opnieuw ingepakt omdat het een makkelijkere implementatie is }
{             en in de toekomst kunnen we het nog wel verbeteren. Voor     }
{             korte berichten werkt dit goed genoeg. Voor langere          }
{             berichten is het waarschijnlijk wel trager, ja.              }
{                                                                          }
FUNCTION MsgsExportInUsenetStyle : BOOLEAN;

TYPE PackedMsgPtr = ^PackedMsg;
     PackedMsg    = ARRAY[1..65528] OF CHAR;

VAR PackedLen : WORD;
    PackedPtr : PackedMsgPtr;
    PackedAll : BOOLEAN; { TRUE als het hele bericht geexporteerd is }
    IsPacked,
    DoRNews   : BOOLEAN; { schrijf er "#! rnews <getal>" voor? }
    DidBody   : BOOLEAN; { al eens begonnen aan de body? }
    SwapPos   : LONGINT;
    CurrRegel : EenRegelRecordPtr;
    Requested : WORD;

    {----------------------------------------------------------------------}
    { PacketMsgPartInUsenetStyle                                           }
    {                                                                      }
    { Deze routine pakt een stuk van het usenet bericht in om te           }
    { exporteren. Als het einde van de body bereikt is, dan wordt          }
    { PackedAll op TRUE gezet.                                             }
    {                                                                      }
    PROCEDURE PackMsgPartInUsenetStyle;

    VAR Lp          : WORD;
        Sum         : LONGINT;
        RegelLength : BYTE;
        RNewsStr    : STRING[20]; { >> "#! rnews 9999999<#10>" }

    BEGIN
         PackedLen:=0;

         IF DoRNews THEN
         BEGIN
              { RWI 950313: de DPMI versie klaagde, dus: sum en NIL checks }
              Sum:=1; { extra CR tussen header en body }

              IF (Msg.HeaderTop_U <> NIL) THEN
                 Sum:=Sum+MsgsSizeOf (Msg.HeaderTop_U^.FirstRegelRecordPtr);

              IF (Msg.BodyTop <> NIL) THEN
                 Sum:=Sum+MsgsSizeOf (Msg.BodyTop^.FirstRegelRecordPtr);

              RNewsStr:='#! rnews '+Longint2String (Sum)+#10;
              Move (RNewsStr[1],PackedPtr^[PackedLen+1],Length (RNewsStr));
              Inc (PackedLen,Length (RNewsStr));
              DoRNews:=FALSE;
         END;

         IF SwapIsOpen THEN
            Seek (SwapFile,SwapPos);

         IsPacked:=FALSE;
         WHILE (NOT IsPacked) DO
         BEGIN
              IF (CurrRegel = NIL) THEN
              BEGIN
                   { einde van de header _of_ de body }
                   IF (NOT DidBody) THEN
                   BEGIN
                        { body was nog niet gedaan }

                        { RWI970116: lege regel tussen de header en body invoegen }
                        PackedPtr^[PackedLen+1]:=#13;
                        Inc (PackedLen);

                        DidBody:=TRUE;
                        IF (Msg.BodyTop = NIL) THEN
                        BEGIN
                             { er is geen body }
                             CurrRegel:=NIL;
                             IsPacked:=TRUE;
                             PackedAll:=TRUE;
                        END ELSE
                        BEGIN
                             CurrRegel:=Msg.BodyTop^.FirstRegelRecordPtr;
                             MsgsNewSeek (CurrRegel);
                        END;
                   END ELSE
                   BEGIN
                        IsPacked:=TRUE;
                        PackedAll:=TRUE;
                   END;
              END;

              IF (NOT IsPacked) THEN { is sneller dan een verg. op NIL }
              BEGIN
                   CASE CurrRegel^.Waar OF
                        wMem :
                            BEGIN
                                 RegelLength:=Length (CurrRegel^.RegelPtr^);
                                 IF (RegelLength < (Requested-PackedLen)) THEN
                                 BEGIN
                                      Move (CurrRegel^.RegelPtr^[1],PackedPtr^[PackedLen+1],RegelLength);
                                      Inc (PackedLen,RegelLength);

                                      CurrRegel:=CurrRegel^.NextRegelRecordPtr;
                                      MsgsNewSeek (CurrRegel);
                                 END ELSE
                                     IsPacked:=TRUE;
                            END;

                        wSwapped :
                            BEGIN
                                 BlockRead (SwapFile,RegelLength,1);

                                 IF (RegelLength = 0) THEN
                                 BEGIN
                                      CurrRegel:=CurrRegel^.NextRegelRecordPtr;
                                      MsgsNewSeek (CurrRegel);
                                 END ELSE
                                 BEGIN
                                      IF (RegelLength < (Requested-PackedLen)) THEN
                                      BEGIN
                                           BlockRead (SwapFile,PackedPtr^[PackedLen+1],RegelLength);
                                           Inc (PackedLen,RegelLength);
                                      END ELSE
                                      BEGIN
                                           IsPacked:=TRUE;
                                           { lengte byte terug stoppen }
                                           Seek (SwapFile,FilePos (SwapFile)-1);
                                      END;
                                 END;
                            END; { wSwapped }
                   END; { case }
              END; { if not IsPacked }

         END; { while not IsPacked }

         IF SwapIsOpen THEN
            SwapPos:=FilePos (SwapFile);

         { RWI 941106: nu nog even alle CR's vertalen in LF's }
         {# nog versnellen met assembly }
         {# nog aanpassen voor SMTP (dit is news, maar ivm mail2news }
         {  zodat er een CR,LF in komt. Meteen doen na inlezen regel }
         FOR Lp:=1 TO PackedLen DO
             IF (PackedPtr^[Lp] = #13) THEN
                PackedPtr^[Lp]:=#10;
    END;

{ ExportMsgInUsenetStyle }

VAR FidoAlso  : BOOLEAN;
    NewsLine  : STRING;
    NewsGroup : STRING[MaxLenAreaName];
    Search    : SubscrSearchRecord;
    AreaRecNr : AreaBaseRecordNrType;
    UserRec   : UserBaseRecord;

BEGIN
     IF (NOT CalcMaxAllowedMem (Requested,5000,65528)) THEN
     BEGIN
          LogMessage ('[ExportMsgInUsenetStyle] Low on memory, skipping message');
          Exit;
     END;

     GetMem (PackedPtr,Requested);
     {$IFDEF LogGetMem} LogGetMem (PackedPtr,Requested,'MsgsExportInUsenetStyle'); {$ENDIF}
     PeekMem;

     FidoAlso:=FALSE;

     { hier gebeurd het iets minder efficient als het zou kunnen. Voor  }
     { iedere user die op de area is aangesloten wordt het hele bericht }
     { opnieuw ingepakt, in plaats van steeds een stuk in te pakken en  }
     { weg te schrijven voor alle aangesloten users.                    }
     GetFirstUserSubscribedToThisArea (AreaData.UserList,Search);
     WHILE (Search.Found) DO
     BEGIN
          ReadUserBaseRecord (Search.UserBaseRecordNr,UserRec);

          IF UserRec.Passive THEN
             Exported^[Search.UserBaseRecordNr]:=3;

          { als dit bericht terug moet naar een Bag Supplier, dan moet }
          { het geredirect worden naar zijn return systeem. Als de     }
          { back supplier de zender was, dan krijgt ie zelf al niets,  }
          { omdat ie de Exported vlag gezet heeft.                     }
          { Hieronder komt ie dus alleen als het bericht van een ander }
          { systeem dan de Bag Supplier afkomstig is.                  }
          IF (UserRec.System = _B) AND (Exported^[Search.UserBaseRecordNr] = 0) THEN
          BEGIN
               { yepp.. modificeer een paar punten zodat het record }
               { van de return-link nu de data krijgt.              }
               IF (FoundBagReturnUser = 1) THEN
               BEGIN
                    { record nummer van het return systeem was al }
                    { opgezocht. Lees die gewoon in.              }
                    Search.UserBaseRecordNr:=BagReturnRecordNr;
                    ReadUserBaseRecord (BagReturnRecordNr,UserRec);
               END ELSE
                   { als we al eens gezocht hebben en niets hebben }
                   { kunnen vinden, dan hoeven we niet nog eens te }
                   { zoeken en loggen we gewoon dat we een bericht }
                   { niet terug konden sturen.                     }
                   IF (FoundBagReturnUser = 0) THEN
                   BEGIN
                        IF (Mail2NewsAddress <> '') AND (UpCaseString (UserRec.BagBackLink) = 'MAIL2NEWS') THEN
                        BEGIN
                             IF Config.LogDebug THEN
                                LogMessage ('Sending news article to '+Mail2NewsAddress);

                             Msg.ToSystem_U:=Config.SmartHost;
                             Msg.XqtTo_U:=Mail2NewsAddress;

                             { laad de Userbase record van het TO system }
                             IF FindUserBaseRecordByUUCPName (Config.SmartHost,UserDataRecNr) THEN
                             BEGIN
                                  LogMessage ('Sending e-mail for '+Msg.XqtTo_U+' to the smarthost');
                                  ReadUserBaseRecord (UserDataRecNr,UserData);
                                  StatUsenetSendMail;
                                  MsgsExportUsenetMail;
                             END ELSE
                                 LogMessage('[Mail2News] Serious config error! Smarthost not in UserBase!');
                        END ELSE
                        BEGIN
                             { zoek het record nummer van het bag return systeem }
                             { op en sla deze op.                                }
                             IF FindUserBaseRecordByUUCPName (UserRec.BagBackLink,Search.UserBaseRecordNr) THEN
                             BEGIN
                                  BagReturnRecordNr:=Search.UserBaseRecordNr;
                                  ReadUserBaseRecord (BagReturnRecordNr,UserRec);
                                  FoundBagReturnUser:=1; { gevonden! }
                             END ELSE
                             BEGIN
                                  LogMessage ('Cannot find Bag supplier Return Link user record!!');
                                  FoundBagReturnUser:=2; { niet gevonden, niet meer zoeken }
                                  { UserRec blijft gewoon het _B systeem, dus }
                                  { het volgende blok wordt niet getriggerd.  }
                             END;
                        END;
                   END;
          END; { is bag user }

          IF (UserRec.System = _U) AND (Exported^[Search.UserBaseRecordNr] = 0) THEN
          BEGIN
               UpdateInfoNr (INFO_UucpOut_Msgs,1);
               UpdateInfoNr (INFO_UucpOut_News,1);

               IF (Msg.HeaderTop_U = NIL) THEN
                  CurrRegel:=NIL
               ELSE
                   CurrRegel:=Msg.HeaderTop_U^.FirstRegelRecordPtr;

               IF SwapIsOpen THEN
               BEGIN
                    MsgsNewSeek (CurrRegel);
                    SwapPos:=FilePos (SwapFile);
               END;

               DidBody:=FALSE;
               DoRNews:=TRUE;
               PackedAll:=FALSE;

               XqtLineC:='rnews';

               WHILE (NOT PackedAll) DO
               BEGIN
                    PackMsgPartInUsenetStyle; { (stuk) inpakken }

                    { voor Aantal niet Msg.MsgSize nemen, omdat na het vertalen }
                    { de fido header+footer erbij is geteld en die gaat nu niet }
                    { mee.                                                      }
                    UpdateUserStats (Search.UserBaseRecordNr,NewsTo,PackedLen);
                    WriteMsgToDat (UserRec,PackedPtr^[1],PackedLen,FALSE{news});
               END; { while }

               Exported^[Search.UserBaseRecordNr]:=1; { exported }
          END;

          IF (UserRec.System = _F) THEN
             FidoAlso:=TRUE;

          GetNextUserSubscribedToThisArea (Search);
     END;

     FreeMem (PackedPtr,Requested);

     { als er helemaal niemand op een van de newsgroups is aangesloten, }
     { dan is er ook nog niet gepacked (dit gebeurt pas als er iemand   }
     { aangesloten is) en moet er dus wel gestopt worden. Dit komt      }
     { bijvoorbeeld voor als alle newsgroups auto-created zijn. Vandaar }
     { de controle "OR (NOT IsPacked)"                                  }

     CheckExportFilesFull;

     MsgsExportInUsenetStyle:=FidoAlso;
END;


{--------------------------------------------------------------------------}
{ ExportNews                                                               }
{                                                                          }
{ Deze routine moet worden aangeroepen om een vers ontdekt Usenet style    }
{ newsje te controleren en distribueren. Alle aangesloten Usenet style     }
{ users krijgen het bericht, waarna het eventueel vertaald wordt en naar   }
{ alle aangesloten Fidonet style users, de List Server en Private Scan     }
{ gestuurd wordt en eventueel geimporteerd wordt in een messagebase.       }
{ Vertaalde echomail berichten moeten naar MsgsExportInUsenetStyle         }
{ gestuurd wordt, want daar worden geen controles uitgevoerd.              }
{                                                                          }
PROCEDURE ExportNews;

CONST MAX_XPOST = 35; { maximaal in 35 areas tegelijkertijd }
                      { MaxLenAreaName (60) * 35 = 2100     }
                      { tegenwoordig: 35 bekende en 35 onbekende newsgroups }

VAR NewsLine  : STRING;
    XPost     : STRING;

    NewsLines : ARRAY[1..MAX_XPOST] OF STRING[MaxLenAreaName];
    NewsRecNr : ARRAY[1..MAX_XPOST] OF AreaBaseRecordNrType;
    NewsCount : BYTE;
    Lp        : BYTE;

    NotCount  : BYTE;
    NewsNot   : ARRAY[1..MAX_XPOST] OF STRING[MaxLenAreaName];

    FidoAlso  : ARRAY[1..MAX_XPOST] OF BOOLEAN;
    ListAlso  : ARRAY[1..MAX_XPOST] OF BOOLEAN;
    AtAnyList : BOOLEAN;
    PrivAlso  : BOOLEAN;
    BaseAlso  : ARRAY[1..MAX_XPOST] OF BOOLEAN;
    AtAllSo   : BOOLEAN;

    AreaRecNr : AreaBaseRecordNrType;
    Sum       : LONGINT;

    {----------------------------------------------------------------------}
    { Zorgt voor de default moderator routing:                             }
    {                                                                      }
    { COMP-OS-IBM-PC@BERKELEY.EDU                                          }
    {                                                                      }
    FUNCTION MungeAreaName (Invoer : STRING) : STRING;
    BEGIN
         IF (Config.BackBone = '') THEN
         BEGIN
              LogMessage ('No backbone defined!');
              MungeAreaName:='';
              Exit;
         END;

         WHILE (Pos ('.',Invoer) > 0) DO
               Invoer[Pos('.',Invoer)]:='-';

         MungeAreaName:=Invoer+'@'+Config.BackBone;
    END;


    {----------------------------------------------------------------------}
    { ProcessNewsgroupsLine                                                }
    {                                                                      }
    { Deze routine doorloopt de opgegeven newsgroups regel en haalt daar   }
    { een voor een alle newsgroup namen uit. Deze worden op bekendheid     }
    { gecontroleerd en of in het NewsLines[] of in het NewsNot[] array     }
    { opgenomen. In totaal kunnen in ieder array 35 namen. Als NewsLine    }
    { vol is, dan wordt zowiezo terug gekeerd. Hierop moet gecontroleerd   }
    { worden bij terugkeer.                                                }
    {                                                                      }
    PROCEDURE ProcessNewsgroupsLine (NewsLine : STRING);

    VAR NewPath : STRING; { for auto area creation }

    BEGIN
         WHILE (NewsCount < MAX_XPOST) AND (NewsLine <> '') AND
               (NewsCount+NotCount < Config.MaxXPostNewsgroups) DO
         BEGIN
              Inc (NewsCount);

              IF (Pos (',',NewsLine) > 0) THEN
              BEGIN
                   NewsLines[NewsCount]:=Copy (NewsLine,1,Pos (',',NewsLine)-1);
                   Delete (NewsLine,1,Pos (',',NewsLine));
              END ELSE
              BEGIN
                   IF (NewsLine[Length (NewsLine)] <> #13) THEN
                      NewsLine:='' { wordt verderop op gereageerd }
                   ELSE
                       Delete (NewsLine,Length (NewsLine),1); { #13 weghalen }

                   NewsLines[NewsCount]:=NewsLine;
                   NewsLine:='';
              END;

              { spaties verwijderen die voor en na de komma kunnen staan }
              NewsLines[NewsCount]:=DeleteFrontAndBackSpaces (NewsLines[NewsCount]);

              IF (NewsLines[NewsCount] = '') THEN
              BEGIN
                   Dec (NewsCount);
                   Continue; { met de while }
              END;

              { zoek het bijbehorende areabase record }
              NewsRecNr[NewsCount]:=GetAreaBaseRecordNrByAreaName_U (NewsLines[NewsCount]);

              { kennen wij de area? }
              IF (UserDataRecNr <> NILRecordNr) AND
                 (PacketUserData.AllowCreate) AND
                 (NewsRecNr[NewsCount] = NILRecordNr) AND
                 CheckFilter (NewsLines[NewsCount],NewPath) THEN
              BEGIN
                   { we kennen deze area niet. Maar... de user heeft  }
                   { AllowCreate en de filter file laat deze naam toe }
                   LogMessage ('Auto-Created area: '+NewsLines[NewsCount]);
                   NewsRecNr[NewsCount]:=AutoCreateArea (NewsLines[NewsCount],NewPath);
              END;

              { als ie nu nog NILRecordNr is, dan mocht de area niet }
              { aangemaakt worden en kennen wij em niet.             }

              IF (NewsRecNr[NewsCount] = NILRecordNr) THEN
              BEGIN
                   IF (NotCount < MAX_XPOST) THEN
                   BEGIN
                        Inc (NotCount);
                        NewsNot[NotCount]:=NewsLines[NewsCount];
                   END ELSE
                       NewsNot[NotCount]:='<rest not remembered>';

                   Dec (NewsCount);
                   Continue; { met de while }
              END;

              { lees het record in }
              ReadAreaBaseRecord (NewsRecNr[NewsCount],AreaData);

              { controleer of de user wel toegang heeft tot deze area }
              IF (UserDataRecNr <> NILRecordNr) THEN
              BEGIN
                   IF (NOT TestIfUserIsInAreaRec_UserList (AreaData.UserList,UserDataRecNr)) THEN
                   BEGIN
                        Inc (NotCount);
                        NewsNot[NotCount]:=NewsLines[NewsCount];
                        Dec (NewsCount);
                        Continue; { met de while }
                   END;

                   { de user is aangesloten op de area, maar dat betekent niet }
                   { dat er ook in geschreven mag worden.                      }

                   { kijk of de area in een read/write group zit, anders }
                   { mag de user er niet in schrijven. RWI 941126        }
                   { RWI 960224: Nu WEL als de user niet in de groups mag waar }
                   {             de area in zit.                               }
                   IF TestIfGroupCommon (PacketUserData.Groups,AreaData.IsInGroups) THEN { new }
                      IF (NOT TestIfGroupCommon3 (PacketUserData.Groups,AreaData.IsInGroups,ReadWriteGroupsFilter)) THEN
                      BEGIN
                           { user mag niet in deze area schrijven. Misschien wel een }
                           { of meer van de andere areas, dus deze ignoren we maar   }
                           { even.                                                   }
                           IF Config.LogRODeny THEN
                           BEGIN
                                IF (PacketUserData.System = _F) THEN
                                   NewPath{abuse}:='FTN style user '+Fido2Str (PacketUserData.Address)
                                ELSE
                                    NewPath:='UUCP style user '+PacketUserData.UUCPname;

                                LogMessage ('Group read-only deny on '+AreaData.AreaName_U+' for '+NewPath);
                           END;

                           Inc (NotCount);
                           NewsNot[NotCount]:=NewsLines[NewsCount];
                           Dec (NewsCount);
                           Continue; { met de while }
                      END;
              END;

              XPost:=XPost+','+NewsLines[NewsCount];

         END; { while}
    END; { procedure ProcessNewsgroupsLine }

{ ExportNews }

CONST ZoekHeader = 'NEWSGROUPS: ';

VAR ScanBody : BOOLEAN;
    RegelPtr : EenRegelRecordPtr;
    Found    : BYTE;
    PrevPart : STRING;
    Regel    : STRING;
    P        : BYTE;

BEGIN
     { doorloop de Newsgroups: header en breek deze op in een array met }
     { alle newsgroup namen die voorkomen.                              }

     Xpost:='';
     NewsCount:=0;
     NotCount:=0;

     { RWI 960601: doorzoek de body als de hele newsgroups regel niet in }
     {             header stond.                                         }
     ScanBody:=(Pos (#13,Msg.NewsGroups_U) = 0);

     IF (NOT ScanBody) THEN
     BEGIN
          Regel:=DeleteBackSpaces (Copy (Msg.Newsgroups_U,1,Length (Msg.Newsgroups_U)-1));
          IF (Regel[Length (Regel)] = ',') THEN
             ScanBody:=TRUE;
     END;

     IF ScanBody THEN
     BEGIN
          RegelPtr:=Msg.HeaderTop_U^.FirstRegelRecordPtr;
          MsgsNewSeek (RegelPtr);

          { zoek de eerste Newsgroups: regel }
          Found:=0;
          PrevPart:='';  { halve newsgroup name }

          WHILE (RegelPtr <> NIL) DO
          BEGIN
               CASE RegelPtr^.Waar OF
                    wMem :
                         BEGIN
                              IF (Found = 0) THEN
                              BEGIN
                                   IF (UpCaseString (Copy (RegelPtr^.RegelPtr^,1,Length (ZoekHeader))) = ZoekHeader) THEN
                                   BEGIN
                                        Regel:=RegelPtr^.RegelPtr^;
                                        Delete (Regel,1,Length (ZoekHeader));
                                        Found:=1;
                                   END;
                              END ELSE
                                  Regel:=RegelPtr^.RegelPtr^;

                              RegelPtr:=RegelPtr^.NextRegelRecordPtr;
                              MsgsNewSeek (RegelPtr);
                         END;

                    wSwapped :
                        BEGIN
                             BlockRead (SwapFile,Regel[0],1);

                             IF (Regel[0] = #0) THEN
                             BEGIN
                                  RegelPtr:=RegelPtr^.NextRegelRecordPtr;
                                  MsgsNewSeek (RegelPtr);
                                  Continue; { met de while }
                             END;

                             BlockRead (SwapFile,Regel[1],Byte (Regel[0]));

                             IF (Found = 0) AND (UpCaseString (Copy (Regel,1,Length (ZoekHeader))) = ZoekHeader) THEN
                             BEGIN
                                  Delete (Regel,1,Length (ZoekHeader));
                                  Found:=1;
                             END;
                        END; { wSwapped }
               END; { case }

               IF (Found = 1) THEN
               BEGIN
                    { dit is een tweede of volgende regel met  }
                    { newsgroups. Kijk of we het einde bereikt }
                    { hebben.                                  }
                    IF (Pos (': ',Regel) > 0) THEN
                    BEGIN
                         { als er nu nog een deel in PrevPart zit dan }
                         { is dat pech gehad hoor.                    }
                         Break; { uit de while }
                    END;

                    { eventuele tabs eruit slopen }
                    Regel:=CleanTabs (Regel,1);

                    Regel:=DeleteFrontSpaces (Regel);

                    Regel:=UpCaseString (Regel);

                    { kijk of we nog een afgekapte newsgroup naam }
                    { hebben die nog verwerkt moet worden.        }
                    IF (PrevPart <> '') THEN
                    BEGIN
                         { haal uit de nieuwe regel de rest van de naam }
                         IF (Pos (',',Regel) > 0) THEN
                         BEGIN
                              PrevPart:=PrevPart+Copy (Regel,1,Pos (',',Regel)-1);
                              Delete (Regel,1,Pos (',',Regel));
                         END ELSE
                         BEGIN
                              PrevPart:=PrevPart+Regel;
                              Regel:='';
                         END;

                         ProcessNewsgroupsLine (PrevPart);
                         PrevPart:='';

                         { no MAX_XPOST check here.. }
                    END;

                    { kijk of ie afgekapt is }
                    IF (Regel <> '') AND (NOT (Regel[Length (Regel)] IN [',',#13])) THEN
                    BEGIN
                         { kopieer afgekapte newsgroup }
                         P:=Length (Regel);
                         WHILE (P > 0) AND (Regel[P] <> ',') DO
                               Dec (P);

                         IF (P > 0) THEN
                         BEGIN
                              PrevPart:=Copy (Regel,P+1,255);
                              Regel:=Copy (Regel,1,P);
                         END;
                    END;

                    ProcessNewsgroupsLine (Regel);

                    IF (NewsCount+NotCount >= Config.MaxXPostNewsgroups) THEN
                    BEGIN
                         LogMessage ('Ignoring over-cross-posted article');
                         Exit;
                    END;

                    IF (NewsCount = MAX_XPOST) THEN
                       Break; { uit de while }
               END; { if }

          END; { while }

          { als we niets hebben kunnen vinden, val dan terug op de }
          { al opgeslagen newsgroups header. Niets aan te doen...  }
          IF (Found = 0) THEN
             ScanBody:=FALSE;
     END;

     { als er iets mis ging tijdens het zoeken, dan is ScanBody nu weer }
     { FALSE en moeten we terug vallen op de "normale" manier.          }
     IF (NOT ScanBody) THEN
     BEGIN
          NewsLine:=UpCaseString (DeleteBackSpaces (Msg.NewsGroups_U));
          NewsLine:=Copy (NewsLine,Pos (':',NewsLine)+2,255);
          NewsLine:=CleanTabs (NewsLine,1); { RWI 960601: voor het geval dat.. }
          ProcessNewsgroupsLine (NewsLine);
     END;

     { RWI 950624: als het bericht crossposted is en de user heeft geen  }
     {             toegang tot een van die areas (not subscribed) of een }
     {             van die areas is read-only voor hem of haar, dan      }
     {             wordt het bericht gewoon terug gestuurd.              }
     {             Dit was allemaal heel geavanceerd, totdat je erachter }
     {             komt dat Son-of-RFC1036 zegt dat je als RELAYER niet  }
     {             op moderated hoeft te controleren enzo. En je weet    }
     {             dan ook niet zeker of je de zender van het bericht    }
     {             kent en dus kan gaan bouncen. Dan maar de BAD in en   }
     {             al die geavanceerde code eruit.                       }

     { opsplitsen van de Newsgroups: header in stukken en controleren of }
     { de zender r/w toegang had in alle areas. Als het voor e'e'n van   }
     { de areas niet klopt, dan cancellen we het hele bericht gewoon.    }
     { nee... dat willen we ook niet. Want als het bericht dan in e'e'n  }
     { goede area gepost is, dan maakt de rest niet uit. Dit komt voor   }
     { als de uplink een newsje stuurd die in vage newsgroups gecross-   }
     { post is en CreateNew uit staat. In dat geval doorsturen in alle   }
     { goede areas en de rest gewoon ignoren. Als het in geen een area   }
     { goed is, dan loggen we dat.                                       }

     IF (NewsCount = 0) THEN
     BEGIN
          { geen areas kunnen vinden, of we kennen al deze areas niet, }
          { of de user was er niet op aangesloten, of de area was      }
          { read-only voor deze user.                                  }

          IF Config.LogErrNewsgroups THEN
          BEGIN
               LogMessage ('Article in the following newsgroups not processed:');
               LogExtraMessage ('('+Msg.MessageID_U+')');
               FOR Lp:=1 TO NotCount DO
                   LogExtraMessage ('  '+NewsNot[Lp]);
          END;

          { naar de BAD wordt moeilijk omdat het een newsje is en de }
          { translate routines controles uit kunnen voeren.          }
          Exit;
     END;

     { RWI 950804: weer toegevoegd, want in the news stonden nu }
     {             onnodige XPOST kludges...                    }
     IF (NewsCount = 1) THEN
        XPost:=''
     ELSE
         IF (XPost <> '') AND (XPost[1] = ','){altijd...} THEN
            Delete (XPost,1,1);

     { exporteer het bericht naar alle areas die wel goedkeuring kregen }
     { RWI 960202: Maar nu alleen even naar de UUCP users.              }

     AtAllSo:=FALSE; { no need for translation }
     AtAnyList:=FALSE; { RWI 960219: forgot to initialise }

     (*
     IF Config.LogDebug THEN
     BEGIN
          LogMessage ('Processing article in these known newsgroups:');
          FOR Lp:=1 TO NewsCount DO
              LogExtraMessage ('  '+NewsLines[Lp]+' ('+Word2String (NewsRecNr[Lp])+')');
          LogExtraMessage ('..and ignoring these newsgroups:');
          FOR Lp:=1 TO NotCount DO
              LogExtraMessage ('  '+NewsNot[Lp]);
     END;
     *)

     FOR Lp:=1 TO NewsCount DO
     BEGIN
          NewsLine:=NewsLines[Lp];
          AreaRecNr:=NewsRecNr[Lp];

          ReadAreaBaseRecord (AreaRecNr,AreaData);

          { houdt de statistieken bij van deze posting }

          { RWI 950313: de dpmi versie klaagde hierover, dus doen we }
          {             het nu maar met Sum en controles.            }
          Sum:=0;

          IF (Msg.HeaderTop_U <> NIL) THEN
             Sum:=Sum+Msg.HeaderTop_U^.TotalRegelLength;

          IF (Msg.BodyTop <> NIL) THEN
             Sum:=Sum+Msg.BodyTop^.TotalRegelLength;

          UpdateAreaStats (AreaRecNr,Sum);

          IF (NOT ForceNoExport) THEN
             FidoAlso[Lp]:=MsgsExportInUsenetStyle;

          BaseAlso[Lp]:=(AreaData.FidoMsgStyle <> NoneType) AND
                        (NOT ForceNoImport);

          IF (Lp = 1) THEN
             PrivAlso:=UseScanForPrivate;

          { Controleer of er misschien Mailinglist gebruikers zijn die }
          { deze area willen lezen.                                    }
          ListAlso[Lp]:=((SystemMode <> smDISTRIBUTE) AND
                        ListServerSearchAreaName (AreaData.AreaName_F) AND
                        ListServerEchoList);

          AtAnyList:=AtAnyList OR ListAlso[Lp];

          { allow gating for import in message base attached to CONTROL area }
          AtAllSo:=AtAllSo OR AtAnyList OR PrivAlso OR  { lekker optimaliseren }
                           FidoAlso[Lp] OR BaseAlso[Lp];

     END; { NewsCount for (UUCP) }

     IF (Msg.Control = '') AND AtAllSo THEN
     BEGIN
          FOR Lp:=1 TO NewsCount DO
              IF FidoAlso[Lp] OR BaseAlso[Lp] THEN
              BEGIN
                   NewsLine:=NewsLines[Lp];
                   AreaRecNr:=NewsRecNr[Lp];

                   ReadAreaBaseRecord (AreaRecNr,AreaData);

                   IF (Msg.Ready_F <> Echomail) THEN
                   BEGIN
                        { initiele overzetting }
                        TranslateNews2Echomail (XPost);
                        FidoWriteMessageToPrivate (PrivAlso); { non-destructive }
                   END ELSE
                   BEGIN
                        { pas de echomail aan voor deze area waarin ie }
                        { gedistribueerd gaat worden. Dit betekent een }
                        { nieuwe AREA:, Origin line, PATH, SEEN-BY,    }
                        { MSGID, etc.                                  }
                        Translate_PatchEchomail;
                   END;

                   { add SEEN-BY and PATH before distribution }
                   AddUsToSeenByAndPath (AreaRecNr,AreaData);

                   IF FidoAlso[Lp] THEN
                      FidoPktExportMsg;

                   IF BaseAlso[Lp] THEN
                      FidoImportEchomail;

              END; { if, NewsCount for (Fido) }

          IF AtAnyList THEN
          BEGIN
               { vertaal de echomail naar netmail voor list server }
               { distributie in alle mogelijke areas waarin dit    }
               { newsje gecrossposted was.                         }

               Msg.ListServer:=TRUE; { intelligently use old headers }

               TranslateEchomail2Netmail;

               AtAnyList:=FALSE; { ook via mail? }

               FOR Lp:=1 TO NewsCount DO
                   IF ListAlso[Lp] THEN
                   BEGIN
                        AreaRecNr:=NewsRecNr[Lp];
                        ReadAreaBaseRecord (AreaRecNr,AreaData);

                        { zorg dat ListMainRec de juiste gegevens bevat }
                        ListServerSearchAreaName (AreaData.AreaName_F);

                        { nu versturen, maar alleen in netmail formaat }
                        ListAlso[Lp]{Mail too}:=ListServerDistributeAsNetmailOnly;

                        AtAnyList:=AtAnyList OR ListAlso[Lp];
                   END; { if, for }

               { nu nog eens naar mail vertalen en distribueren }
               IF AtAnyList THEN
               BEGIN
                    FOR Lp:=1 TO NewsCount DO
                        IF ListAlso[Lp] THEN
                        BEGIN
                             AreaRecNr:=NewsRecNr[Lp];
                             ReadAreaBaseRecord (AreaRecNr,AreaData);

                             { zorg dat ListMainRec de juiste gegevens bevat }
                             ListServerSearchAreaName (AreaData.AreaName_F);

                             IF (Msg.Ready_U <> Mail) THEN
                                TranslateNetmail2Mail (ListMainRec.ListName+'@'+Config.Domains[1]);

                             ListServerDistributeAsMailOnly;
                        END; { if,for }

               END; { in mail format as well }

          END; { for any mailing list distribution }

     END; { for any fidonet format output }
END;


{--------------------------------------------------------------------------}
{ MsgsExportEchomail                                                       }
{                                                                          }
{ Deze routine moet worden aangeroepen als een nieuw echomail bericht      }
{ ontdekt is. Het bericht wordt gecontroleerd en daar verstuurd naar alle  }
{ aangesloten Fidonet users en geimporteerd in de messagebase. Daarna      }
{ wordt het eventueel vertaald en ook aan alle aangesloten Usenet users    }
{ gestuurd. Aan het einde wordt een kopietje aan de List Server gegeven    }
{ als deze area ook daar aan gekoppeld is.                                 }
{                                                                          }
PROCEDURE MsgsExportEchomail;

VAR UsenetAlso : BOOLEAN;
    AreaRecNr  : AreaBaseRecordNrType;

BEGIN
     { de controle op read-only en subscribed zijn of niet is al uitgevoerd }
     { bij het verwerken van de .PKT file. Bij Usenet gebeurd het wel pas   }
     { hier omdat er meerdere newsgroups zijn waarin het bericht gepost     }
     { kan zijn. Voor fido is dit er altijd maar e'e'n.                     }
     AreaRecNr:=GetAreaBaseRecordNrByAreaName_F (Msg.Area_F);
     ReadAreaBaseRecord (AreaRecNr,AreaData);

     { mensen die al in de seen-by staan eerst vlaggen in Exported^ }
     { FlagSeenBysAsExported;                                       }

     IF (NOT ForceNoExport) THEN
     BEGIN
          AddUsToSeenByAndPath (AreaRecNr,AreaData);

          UsenetAlso:=FidoPktExportMsg;
          UsenetAlso:=UsenetAlso OR (Mail2NewsAddress <> '');
     END ELSE
         UsenetAlso:=FALSE;

     { lokaal importeren van het bericht }
     IF (Msg.Ready_F <> Local_Echomail) AND (NOT ForceNoImport) AND (AreaData.FidoMsgStyle <> NoneType) THEN
        FidoImportEchomail;

     { private mail scan, non-destructive }
     FidoWriteMessageToPrivate (FALSE{niet als news al gedetecteerd});

     IF UsenetAlso THEN
     BEGIN
          TranslateEchomail2News; { AreaBase moet geldig record bevatten(!) }
          MsgsExportInUsenetStyle;
     END;

     { het bericht kan nu News of Echomail zijn, maar dat maakt niets uit }

     { Exporteer het bericht via de listserver als deze erop }
     { aangesloten is.                                       }
     IF ((SystemMode <> smDISTRIBUTE) AND
         ListServerSearchAreaName (DeleteBackSpaces (Msg.Area_F)) AND
         ListServerEchoList)
     THEN
         ListServerDistributeNetMail; { alleen als Mail en Netmail versturen }
END;

(* Controle op Moderator moet alleen plaatsvinden als we een bericht
   POSTEN. Niet als we het bericht RELAYEN, wat we hier dus aan het
   doen zijn. De controle moet dus verhuizen naar TranslateEchomail2News
   ofzo.
   Nee.. zelfs al eerder. Want als de area moderated is, dan mag ie ook niet
   in Fidonet verstuurd worden.
   RWI 950624.

VAR SendMod   : BOOLEAN; { bericht naar de moderator sturen? }
    ModRecNr  : AreaBaseRecordNrType;
    ModHeader : BOOLEAN;
    TmpLine   : TopRegelRecordPtr;

     { als we hier komen dan heeft de sender van het bericht toegang  }
     { in alle crossposted areas. Voor de areas die moderated zijn    }
     { is NewsMod[] gezet. Zoek daarop en stuur het bericht eventueel }
     { naar een moderator.                                            }

     { The user heeft toegang tot al deze areas. Kijk of het bericht naar }
     { een moderator gestuurd moet worden.                                }
     SendMod:=FALSE;   { hoeft niet naar de moderator }
     ModHeader:=FALSE; { er hoeft geen multiple-moderators opmerking boven }

     FOR Lp:=1 TO NewsCount DO
         IF NewsMod[Lp] THEN
         BEGIN
              { hebben we al een moderator bepaald? }
              IF SendMod THEN
              BEGIN
                   { er is al een moderator bepaald. Stop een header }
                   { boven het bericht waarin verzocht wordt ook met }
                   { andere moderators te overleggen.                }

                   ModHeader:=TRUE; { die moet er ook in }

                   IF (AreaData.Moderator <> '') THEN
                      NewsLine:=AreaData.Moderator
                   ELSE
                       NewsLine:=MungeAreaName (NewsLines[Lp]);

                   IF (NewsLine = '') THEN
                   BEGIN
                        LogMessage ('Could not construct moderator for "'+NewsLines[Lp]+'"');
                        NewsLine:='?';
                   END;

                   MsgsAddFirstLineTo (Body,'   '+NewsLine+' for "'+NewsLines[Lp]+'"');
              END ELSE
              BEGIN
                   { dit is de eerste moderator }

                   SendMod:=TRUE;
                   ModRecNr:=NewsRecNr[NewsCount]; { naar deze moderator sturen }

                   MsgsAddFirstLineTo (Body,RepChar (70,'-'));
                   MsgsAddFirstLineTo (Body,'Original unposted messages follows');
                   MsgsAddFirstLineTo (Body,RepChar (70,'-'));
                   MsgsAddFirstLineTo (Body,'');
              END;
          END; { moderated area }
     END; { for }

     { als de moderator bepaald is, dan moet het bericht vertaald worden  }
     { in een mail message en verstuurd worden en NIET gepost worden, ook }
     { niet in echomail areas.                                            }
     IF SendMod THEN
     BEGIN
          IF ModHeader THEN
          BEGIN
               MsgsAddFirstLineTo (Body,'newsgroups before approving the message:');
               MsgsAddFirstLineTo (Body,'Please consult the following moderators for their respective');
               MsgsAddFirstLineTo (Body,'This message was cross-posted in multiple moderated areas.');
          END;

          ClearLineBuffer (LineBuffer);

          { Creer de Usenet Mail header }
          IF (AreaData.Moderator <> '') THEN
             Msg.XqtTo_U:=AreaData.Moderator
          ELSE
              Msg.XqtTo_U:=MungeAreaName (NewsLine);

          IF (Msg.XqtTo_U = '') THEN
          BEGIN
               LogMessage ('Unable to send news message to moderator');
               Exit;
          END;

          AddToLineBuffer (LineBuffer,'From postmaster@'+Config.Domains[1]+' '+UsenetArpaNetDate);
          { RWI 950623: niet meer voor door ons gegenereerde mail
          AddToLineBuffer (LineBuffer,'Received: by '+UseGetFromName+' ('+Copy (FidoTear,5,255)+')');
          AddToLineBuffer (LineBuffer,'          via UUCP; '+UsenetArpaNetDate);
          AddToLineBuffer (LineBuffer,'          for '+Msg.XqtTo_U);
          }
          AddToLineBuffer (LineBuffer,'Date: '+UsenetArpaNetDate);
          AddToLineBuffer (LineBuffer,Msg.FromUser_U);

          Knoei:=Copy (UseGetAddress (Msg.FromUser_U),Length('From:')+2,255);
          Knoei:=Copy (Knoei,Pos ('@',Knoei)+1,255);

          AddToLineBuffer (LineBuffer,'Message-ID: <'+GetFidoPktName+'@'+DeleteBackSpaces (knoei)+'>');

          AddToLineBuffer (LineBuffer,'To: '+Msg.XqtTo_U);
          AddToLineBuffer (LineBuffer,Msg.Subj_U);
          AddToLineBuffer (LineBuffer,''); { lege regel sluit header af }

          { Swap de Usenet header }
          TmpLine:=Msg.HeaderTop_U;
          Msg.HeaderTop_U:=LineBuffer;

          { Stuur het als een meeltje weg }
          UsenetRouteMail;

          { Swap terug naar de oude header }
          Msg.HeaderTop_U:=TmpLine;
          ClearLineBuffer (LineBuffer);
          Continue; { volgende area }
     END; { moderated }
*)


{--------------------------------------------------------------------------}
{ MsgsExportUsenetMail                                                     }
{                                                                          }
{ Deze routine exporteert een mailtje naar een Usenet domain. In de        }
{ Msg.ToSystem_U staat de UUCPNaam van het systeem. Aan de hand hiervan    }
{ kan een nieuwe file begonnen worden bij de exporteer routines.           }
{ Eis: Msg.ToUser_U moet de naam van de ontvanger bevatten voor in de .XQT }
{      file.                                                               }
{                                                                          }
PROCEDURE MsgsExportUsenetMail;

TYPE PackedMsgPtr = ^PackedMsg;
     PackedMsg    = ARRAY[1..65528] OF CHAR;

VAR MaxLen    : LONGINT;
    IsPacked  : BOOLEAN;
    PackedAll : BOOLEAN; { TRUE als het hele bericht geexporteerd is }
    PackedPtr : PackedMsgPtr;
    PackedLen : WORD;
    Requested : WORD;
    DidBody   : BOOLEAN; { al eens begonnen aan de body? }
    CurrRegel : EenRegelRecordPtr;
    SwapPos   : LONGINT;
    NoFrom_   : BOOLEAN;

    {----------------------------------------------------------------------}
    { PackMsgPartInUsenetStyle                                             }
    {                                                                      }
    { RWI 950910: Er werd voor de lengte byte en #13 naar #10 vertaal loop }
    {             een WORD gebruikt. Na de vertaal loop was de high-byte   }
    {             <> 0 en dit gaf problemen bij het gebruik als lengte     }
    {             byte, maar alleen bij de swapfile en alleen als de eind- }
    {             byte gemist werd.                                        }
    {                                                                      }
    PROCEDURE PackMsgPartInUsenetStyle;

    VAR RegelLen : BYTE;   { RWI 950910: was een WORD }
        Lp       : WORD;
        HulpStr  : STRING[5];

    BEGIN
         IF (NOT CalcMaxAllowedMem (Requested,5000,65520)) THEN
         BEGIN
              LogMessage ('[MsgsExportUsenetMail] Low on memory, skipping message');
              Exit;
         END;

         GetMem (PackedPtr,Requested);
         {$IFDEF LogGetMem} LogGetMem (PackedPtr,Requested,'MsgsExportUsenetMail'); {$ENDIF}
         PeekMem;

         PackedLen:=0;

         IF SwapIsOpen THEN
            Seek (SwapFile,SwapPos);

         WHILE (NOT IsPacked) DO
         BEGIN
              IF (CurrRegel = NIL) THEN
              BEGIN
                   { dit stukje is voor de overgang van de header naar de }
                   { body.                                                }
                   IF (NOT DidBody) THEN
                   BEGIN
                        { RWI970116: lege regel tussen header en body invoegen }
                        PackedPtr^[PackedLen+1]:=#13;
                        Inc (PackedLen);

                        DidBody:=TRUE;
                        IF (Msg.BodyTop = NIL) THEN
                           CurrRegel:=NIL
                        ELSE
                            CurrRegel:=Msg.BodyTop^.FirstRegelRecordPtr;
                        MsgsNewSeek (CurrRegel);

                        IF (CurrRegel = NIL) THEN
                        BEGIN
                             IsPacked:=TRUE;
                             PackedAll:=TRUE;
                        END;
                   END ELSE
                   BEGIN
                        IsPacked:=TRUE;
                        PackedAll:=TRUE;
                   END;
              END;

              IF (NOT IsPacked) THEN { is sneller dan een verg. op NIL }
              BEGIN
                   CASE CurrRegel^.Waar OF
                        wMem :
                            BEGIN
                                 RegelLen:=Length (CurrRegel^.RegelPtr^);

                                 IF (RegelLen < (Requested-PackedLen)) THEN
                                 BEGIN
                                      { leave the From_ line out of SMTP or GIGOT jobs }
                                      IF DidBody OR (NOT NoFrom_) OR (RegelLen < 5) OR
                                         (UpCaseString (Copy (CurrRegel^.RegelPtr^,1,5)) <> 'FROM ') THEN
                                      BEGIN
                                           Move (CurrRegel^.RegelPtr^[1],PackedPtr^[PackedLen+1],RegelLen);
                                           Inc (PackedLen,RegelLen);
                                      END;

                                      CurrRegel:=CurrRegel^.NextRegelRecordPtr;
                                      MsgsNewSeek (CurrRegel);
                                 END ELSE
                                     IsPacked:=TRUE;
                            END;

                        wSwapped :
                            BEGIN
                                 BlockRead (SwapFile,RegelLen,1);

{## crashed here once, error 100: disk read error }
                                 IF (RegelLen = 0) THEN
                                 BEGIN
                                      { einde van dit swap blok }
                                      CurrRegel:=CurrRegel^.NextRegelRecordPtr;
                                      MsgsNewSeek (CurrRegel);
                                 END ELSE
                                 BEGIN
                                      IF (RegelLen < (Requested-PackedLen)) THEN
                                      BEGIN
                                           BlockRead (SwapFile,PackedPtr^[PackedLen+1],RegelLen);

                                           IF DidBody OR (UserData.System <> _S) OR (RegelLen < 5) THEN
                                              Inc (PackedLen,RegelLen)
                                           ELSE BEGIN
                                                Move (PackedPtr^[PackedLen+1],HulpStr[1],5);
                                                HulpStr[0]:=#5;
                                                IF (UpCaseString (HulpStr) <> 'FROM ') THEN
                                                   Inc (PackedLen,RegelLen);
                                           END;

                                      END ELSE
                                      BEGIN
                                           IsPacked:=TRUE;
                                           { lengte byte in de swapfile recyclen }
                                           Seek (SwapFile,FilePos (SwapFile)-1);
                                      END;
                                 END;
                            END; { wSwapped }
                   END; { case }
              END; { if not IsPacked }
         END; { while not IsPacked }

         { stel de positie in de swapfile zeker }
         IF SwapIsOpen THEN
            SwapPos:=FilePos (SwapFile);

         { vertaal alle CR's naar LF's }
         {# moet nog versneld worden met assembly }
         FOR Lp:=1 TO PackedLen DO
             IF (PackedPtr^[Lp] = #13) THEN
                PackedPtr^[Lp]:=#10;
    END;

{ MsgsExportUsenetMail }

VAR StatLen : LONGINT;

BEGIN
     { neem alleen gedeelte van bericht dat ook echt verzonden wordt }
     StatLen:=Msg.HeaderTop_U^.TotalRegelLength;
     IF (Msg.BodyTop <> NIL) THEN
        StatLen:=StatLen+Msg.BodyTop^.TotalRegelLength;

     UpdateUserStats (UserDataRecNr,MailTo,StatLen);

     { forceer begin van nieuwe .DAT file ivm mail in eigen .DAT file }
     ExportForceFileFull (Msg.ToSystem_U);

     { ReadUserBaseRecord (UserDataRecNr,UserData); }
     WITH UserData DO
     BEGIN
          Compress:=USE_NONE; { dit is mail }
          CunBatch:=FALSE; { zelfde reden }
     END; { with }

     IF (Msg.HeaderTop_U = NIL) THEN
        CurrRegel:=NIL
     ELSE
         CurrRegel:=Msg.HeaderTop_U^.FirstRegelRecordPtr;

     IF SwapIsOpen THEN
     BEGIN
          MsgsNewSeek (CurrRegel);
          SwapPos:=FilePos (SwapFile);
     END;

     DidBody:=FALSE;
     PackedAll:=FALSE;
     XqtLineC:='rmail '+DeleteBackspaces (Msg.XqtTo_U);
     WrkFileFrom:=UseGetAddress (Copy (Msg.FromUser_U,7,255)); { strips full name }
     NoFrom_:=(UserData.System = _S) OR UserData.GigoT;

     IF (UserData.System = _U) THEN
     BEGIN
          UpdateInfoNr (INFO_UucpOut_Msgs,1);
          UpdateInfoNr (INFO_UucpOut_Mail,1);
     END ELSE
     BEGIN
          UpdateInfoNr (INFO_SmtpOut_Msgs,1);
          UpdateInfoNr (INFO_SmtpOut_Mail,1);
     END;

     REPEAT
           IsPacked:=FALSE;
           PackMsgPartInUsenetStyle; { (stuk) inpakken }

           IF (UserData.System = _S) THEN
              WriteMsgToSmtp (UserData,PackedPtr^[1],PackedLen)
           ELSE
               WriteMsgToDat (UserData,PackedPtr^[1],PackedLen,TRUE{Mail});

           FreeMem (PackedPtr,Requested);
     UNTIL PackedAll;

     { omdat het een mailtje is kan de .DAT meteen afgesloten worden }
     ExportForceFileFull (Msg.ToSystem_U);
END;


(*
{--------------------------------------------------------------------------}
{ FlagPathAsExported                                                       }
{                                                                          }
{ Deze routine breekt de path line op in losse domain namen en gaat daarna }
{ vergelijken met onze userbase. Als er nodes bij ons zijn die in de paths }
{ file staan, dan worden die op status 4 gevlagt in de Exported lijst,     }
{ zodat het bericht niet terug gestuurd wordt.                             }
{                                                                          }
{ Van een PATH: regel die doorloopt op de volgende regel (ander record),   }
{ wordt alleen het eerste stuk (255 tekens) verwerkt.                      }
{                                                                          }
PROCEDURE FlagPathAsExported;

CONST MAXHOSTS = 25; { 25*50  = 1250 } { was eens... }
                     { 25*255 = 6375 } { ietwat grof op de stack }
                     { 25*100 = 2500 } { RWI 950506: bijgesteld }

VAR Path      : STRING;
    Hosts     : ARRAY[1..MAXHOSTS] OF STRING[100]; {[MaxLenDomain]; {=50}
    Parts,P,
    Lp        : BYTE;
    UserRecNr : UserBaseRecordNrType;

BEGIN
     { zoek de path regel op in de header }
     Path:=MsgsSearchLine (Header_U,'PATH: ',TRUE{upcase first});

     IF (Path = '') THEN
     BEGIN
          LogMessage ('[FlagPathAsExported] Could not find Path line in Usenet message');
          Exit;
     END;

     { nu de path regel opsplitsen in losse stukjes en die opslaan }
     { Een hostnaam bestaat uit letter, cijfers en een koppelteken }
     Parts:=0;
     P:=1;
     REPEAT
           WHILE (P <= Length (Path)) AND (NOT (Path[P] IN ['A'..'Z','0'..'9','-','.'])) DO
                 Inc (P);

           IF (P <= Length (Path)) THEN
           BEGIN
                Inc (Parts);
                Hosts[Parts]:='';
                WHILE (P <= Length (Path)) AND (Path[P] IN ['A'..'Z','0'..'9','-','.']) DO
                BEGIN
                     Hosts[Parts]:=Hosts[Parts]+Path[P];
                     Inc (P);
                END;
           END;
     UNTIL (P > Length (Path));

     { nu de hele userbase doorlopen en vergelijken met de parts }
     IF (Parts = 0) THEN
     BEGIN
          LogMessage ('[FlagPathAsExported] Path line extraction failed');
          Exit;
     END;

     FOR Lp:=1 TO Parts DO
     BEGIN
          Path:=Hosts[Lp]; { ivm VAR STRING argument aan GetUUCPRoute }
          UserRecNr:=GetUucpRoute (Path{,Config.UUCPName});
          {IsKnownDomain (Hosts[Lp]);}
          IF (UserRecNr <> NILRecordNr) THEN
             Exported^[UserRecNr]:=4;
     END;
END;
*)


{--------------------------------------------------------------------------}
{ MsgsExport                                                               }
{                                                                          }
{ Deze routine verwerkt het universele mailtje dat opgebouwd is.           }
{ Om terugsturen te voorkomen moet de UserDataRecNr variabele in UserBase  }
{ het record nummer van het record nummer van de zender bevatten.          }
{ AreaData moet de gegevens van de Area bevatten, waarin dit mailtje nu    }
{ staat.                                                                   }
{                                                                          }
{ Voor een Usenet mailtje met multiple newsgroups wordt het mailtje maar   }
{ een keer naar een Usenet Node gestuurd. Voor Fido-style Usenet Points    }
{ wordt het mailtje in iedere area in de Newsgroups: regel geexporteerd,   }
{ met verschillende crossposts meldingen in de header.                     }
{                                                                          }
{ Bij aanroep van deze routine door Fido moet het AreaData record al       }
{ ingelezen zijn, zodat de aangesloten users kunnen worden gevonden.       }
{ Voor Usenet hoeft dit niet, ivm de multiple newsgroups wordt het         }
{ bijbehorende area record hier wel gevonden.                              }
{                                                                          }
PROCEDURE MsgsExport;

VAR Lp,Lp2    : WORD;
    OtherAlso : BOOLEAN;
    NewsLine  : STRING;
    NewsLines : ARRAY[1..20] OF STRING[MaxLenAreaName];
    NewsCount : BYTE;
    AreaRecNr : AreaBaseRecordNrType;
    XPost     : STRING;
    PrivAlso  : BOOLEAN;

BEGIN
     PeekMem; { nu zit het geheugen propje vol }

     Slice_Now;

     { Kijk of we te maken hebben met een te groot bericht        }
     { als dat het geval is, mag het bericht NOOIT geexporteerd   }
     { worden.                                                    }
     IF MsgTrashAllNewLines THEN
        Exit;

     { En dit was pas echt een vervelende bug, voor de export uit }
     { de lokale mail was UserDataRecNr = 0 , wat pointer errors  }
     { gaf in de MsgsEmpty routine... waar bleek dat steeds de    }
     { 2e regel van het bericht verminkt was.... Door FidoTrash   }
     { te gebruiken werd het probleem tot deze regels terug       }
     { gebracht. ScanFidoMsgArea zet nu altijd UserDataRecNr      }
     { op NIL, wat door de stats routine als lokale mail gezien   }
     { wordt.                                                     }
     FOR Lp:=1 TO ExportedCount DO
         Exported^[Lp]:=0;

     { voor Usenet Bad nog geen afhandelings routine }
     IF (Msg.Ready_U = Dupe) THEN
     BEGIN
          LogMessage ('Trashing DUPE message from RFC side');
          Exit;
     END;

     { voor Usenet Dupe nog geen afhandelings routine }
     IF (Msg.Ready_U = Bad) THEN
     BEGIN
          LogMessage ('Trashing BAD message from RFC side');
          Exit;
     END;

     { Als een bad bericht is, toss het dan naar de BADMAIL directory  }
     IF (Msg.Ready_F = Bad) THEN
     BEGIN
          UpdateInfoNr (INFO_DupBad_Msgs,1);
          FidoWriteMessageToBad;
          Exit;
     END;

     { Als het een Dupe bericht is, schrijf het naar de dupe directory }
     IF (Msg.Ready_F = Dupe) THEN
     BEGIN
          UpdateInfoNr (INFO_DupBad_Msgs,1);
          FidoWriteMessageToDupe;
          Exit;
     END;

     { Als we bezig zijn met het tossen van de lokale badmail area }
     { zorg dan dat de berichten NOOIT geexporteerd worden.        }
     IF (SystemMode = smTOSSFIDOBAD) THEN
     BEGIN
          AreaRecNr:=GetAreaBaseRecordNrByAreaName_F (Msg.Area_F);
          ReadAreaBaseRecord (AreaRecNr,AreaData);
          FidoImportEchomail;
          Exit;
     END;

     { Maakt niet echt uit, lokaal zullen we toch nooit nieuwe areas }
     { bouwen ;-)                                                    }
     { Dit hieronder is niet consistent. Fido zet Creator al goed en }
     { gebruikt FromUserRecNr instead. Exported zetten is een goede  }
     { zaak, ook al krijg ik als fido point nog steeds mijn news     }
     { ook terug.                                                    }
     IF (UserDataRecNr <> NILRecordNr) THEN
     BEGIN
          Exported^[UserDataRecNr]:=2; { Is Source }
          AreaCreatorUserBaseRecNr:=UserDataRecNr;
     END;

     { Gooi de MSGLOCAL vlag weg, om te voorkomen dat berichten gaan }
     { rondzingen.                                                   }
     Msg.Attr_F:=Msg.Attr_F AND ($FFFF-MSGLOCAL);

     { detecteer het msg type en verwerk em }
     IF (Msg.Ready_U = News) THEN
     BEGIN
          ExportNews;
          Exit;
     END;

     IF (Msg.Ready_F IN [Echomail,Local_Echomail]) THEN
     BEGIN
          MsgsExportEchomail;
          Exit;
     END;

     IF (Msg.Ready_U = Mail) THEN
     BEGIN
          PrivAlso:=UseScanForPrivate;
          UsenetRouteMail; { can change it into a netmail }
          FidoWriteMessageToPrivate (PrivAlso);
          Exit;
     END;

     IF (Msg.Ready_F IN [Netmail,Local_Netmail]) THEN
     BEGIN
          FidoRouteNetMail;
          { extra check nodig: bericht kan nu Empty zijn, }
          { of een AreaFix reply, of zelfs een Mail!      }
          FidoWriteMessageToPrivate (FALSE);
          Exit;
     END;

     LogMessage ('[MsgsExport] Unhandled');
END;


{--------------------------------------------------------------------------}
{ InitExportedList                                                         }
{                                                                          }
{ Deze routine vraagt geheugen aan voor de exported list. Hierna mag het   }
{ aantal userbaserecords niet meer veranderen! De userbase moeten open     }
{ staan om het aantal records daarin te kunnen bepalen.                    }
{                                                                          }
PROCEDURE InitExportedList;
BEGIN
     ExportedCount:=UserBaseRecCount;
     GetMem (Exported,ExportedCount);
     {$IFDEF LogGetMem} LogGetMem (Exported,ExportedCount,'InitExportedList'); {$ENDIF}
     PeekMem;
END;


{--------------------------------------------------------------------------}
{ JunkExportedList                                                         }
{                                                                          }
{ Deze routine geeft het geheugen dat met InitExportedList was aangevraagd }
{ weer vrij.                                                               }
{                                                                          }
PROCEDURE JunkExportedList;
BEGIN
     FreeMem (Exported,ExportedCount);
END;


{--------------------------------------------------------------------------}
{ ClearLineBuffer                                                          }
{                                                                          }
{ Maakt de line buffer schoon.                                             }
{                                                                          }
PROCEDURE ClearLineBuffer (VAR LineBuffer : TopRegelRecordPtr);
BEGIN
     MsgsReleaseLines (LineBuffer);
END;


{--------------------------------------------------------------------------}
{ AddToLineBuffer                                                          }
{                                                                          }
{ De line buffer is een stuk geheugen met tekstregels aan elkaar gelinkt   }
{ dit om het antwoord van Areafix te kunnen opslaan. Omdat de Line Buffer  }
{ door het programma in een keer als body van het bericht wordt gemaakt,   }
{ moeten hier ook de CR's toegevoegd worden.                               }
{                                                                          }
PROCEDURE AddToLineBufferNoEOL (VAR LineBuffer : TopRegelRecordPtr; Line : STRING);

VAR NewRegelRecordPtr : EenRegelRecordPtr;

BEGIN
     NewRegelRecordPtr:=CreateLine (LineBuffer,Length (Line));
     GetMem (NewRegelRecordPtr^.RegelPtr,Length (Line)+1);
     {$IFDEF LogGetMem} LogGetMem (NewRegelRecordPtr^.RegelPtr,Length (Line)+1,'AddToLineBufferNoEOL'); {$ENDIF}
     NewRegelRecordPtr^.RegelPtr^:=Line;
     NewRegelRecordPtr^.Len_Check:=Length (Line);

     { RWI 960309: MemAvail veranderd in MaxAvail ivm CalcMaxAllowedMem }
     IF (MaxAvail < MSGS_LOWMEM_GOSWAP) THEN
     BEGIN
          {
          IF Config.LogDebug THEN
             LogMessage ('Swapping line buffer. Pre: '+Longint2String (MemAvail)+'/'+Longint2String (MaxAvail));
          }

          MsgsGoSwap (LineBuffer);

          {
          IF Config.LogDebug THEN
             LogExtraMessage ('Post: '+Longint2String (MemAvail)+'/'+Longint2String (MaxAvail));
          }
     END;
END;

PROCEDURE AddToLineBuffer (VAR LineBuffer : TopRegelRecordPtr; Line : STRING);
BEGIN
     AddToLineBufferNoEOL (LineBuffer,Line+#13);
END;


{---------------------------------------------------------------------------}
{ MoveRegelsToLineBuffer                                                    }
{                                                                           }
{ Deze routine VERPLAATST alle regels van het ene TopRegelRecord naar het   }
{ opgegeven LineBuffer en plakt ze daar aan het einde er aan vast. Dit      }
{ voorkomt behoorlijk wat gekopieer van regels en het spaart ontzettend     }
{ veel geheugen. Bij het bouncen zou anders twee keer zoveel geheugen nodig }
{ zijn als het bericht groot is.                                            }
{                                                                           }
{                              let op: BEIDE zijn VAR!                      }
PROCEDURE MoveRegelsToLineBuffer (VAR {van}Regels,{naar}LineBuffer : TopRegelRecordPtr);
BEGIN
     { als het line buffer nog leeg is, dan kunnen we gewoon alles }
     { over poten.                                                 }
     IF (LineBuffer = NIL) THEN
     BEGIN
          LineBuffer:=Regels;
          Regels:=NIL;
          Exit;
     END;

     { als er nog geen regels in zitten, maar er wel een top regel }
     { record is, dan kunnen alle regels zo overgezet worden.      }
     IF (LineBuffer^.FirstRegelRecordPtr = NIL) THEN
     BEGIN
          { top regel record weggooien }
          { RWI 960521: was TopRegelRecordPTR }
          FreeMem (LineBuffer,SizeOf (TopRegelRecord));

          { en van Regels overzetten }
          LineBuffer:=Regels;

          { die dan niet meer gebruikt mag worden }
          Regels:=NIL;
          Exit;
     END;

     { regels aan het einde toevoegen }
     LineBuffer^.LastRegelRecordPtr^.NextRegelRecordPtr:=Regels^.FirstRegelRecordPtr;
     LineBuffer^.LastRegelRecordPtr:=Regels^.LastRegelRecordPtr;
     Inc (LineBuffer^.TotalRegelLength,Regels^.TotalRegelLength);

     { RWI 960521: was TopRegelRecordPTR }
     FreeMem (Regels,SizeOf (TopRegelRecord));
     Regels:=NIL;
END;


{--------------------------------------------------------------------------}
{ CopyNLinesToLineBuffer                                                   }
{                                                                          }
{ Deze routine kopieert de eerste N regels van het opgegeven regel buffer  }
{ naar het andere line buffer.                                             }
{ Er wordt TRUE terug gegeven als er nog meer regels zijn.                 }
{                                                                          }
FUNCTION CopyNLinesToLineBuffer (EenRegelPtr : EenRegelRecordPtr;
                                 VAR LineBuffer : TopRegelRecordPtr; LineCount : WORD) : BOOLEAN;

VAR RegelLength : BYTE;
    Regel       : STRING;

BEGIN
     MsgsNewSeek (EenRegelPtr);

     WHILE (EenRegelPtr <> NIL) AND (LineCount > 0) DO
     BEGIN
          CASE EenRegelPtr^.Waar OF
               wMem :
                   BEGIN
                        Regel:=EenRegelPtr^.RegelPtr^;
                        EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                        MsgsNewSeek (EenRegelPtr);
                   END;

               wSwapped :
                   BEGIN
                        { lees de lengte van de regel in }
                        BlockRead (SwapFile,RegelLength,1);

                        { einde van het swapped blok? }
                        IF (RegelLength = 0) THEN
                        BEGIN
                             { ja, ga naar de volgende regel }
                             EenRegelPtr:=EenRegelPtr^.NextRegelRecordPtr;
                             MsgsNewSeek (EenRegelPtr);
                             Continue;
                        END;

                        { lees de regel zelf in }
                        BlockRead (SwapFile,Regel[1],RegelLength);
                        Regel[0]:=Char (RegelLength);
                   END;
          END; { case }

          AddToLineBufferNoEOL (LineBuffer,Regel);   { RWI 951217: now NoEOL }
          Dec (LineCount);
     END; { while }

     CopyNLinesToLineBuffer:=(EenRegelPtr <> NIL);
END;


{--------------------------------------------------------------------------}
{ MsgsDeleteFirstRowFromBody                                               }
{                                                                          }
{ Haalt de Eerste regel van het bericht weg, dit om TO: commando's uit     }
{ een bericht te kunnen schrappen en later misschien nog wel meer.         }
{                                                                          }
{ RWI 950506: Door de komst van de swapfile is deze routine nu iets        }
{             lastiger geworden. Een leeg swap admin regel record wordt    }
{             ook nog eens verwijderd.                                     }
{             Meteen ook TotalRegelLength aan laten passen. Deed ie nog    }
{             niet. Ook Msg.MsgSize neemt ie nu mee.                       }
{                                                                          }
PROCEDURE MsgsDeleteFirstRowFromBody;

VAR HulpRegelPtr : EenRegelRecordPtr;
    RegelLength  : BYTE;

BEGIN
     IF (Msg.BodyTop = NIL) THEN
        Exit; { extratje }

     IF (Msg.BodyTop^.FirstRegelRecordPtr = NIL) THEN
        Exit;

     WITH Msg.BodyTop^ DO
     BEGIN
          { als de eerste regel in geheugen staat, dan verwijderen }
          { we dat hele record gewoon }
          IF (FirstRegelRecordPtr^.Waar = wMem) THEN
          BEGIN
               { link het begin door naar de volgende regel }
               HulpRegelPtr:=FirstRegelRecordPtr;
               FirstRegelRecordPtr:=FirstRegelRecordPtr^.NextRegelRecordPtr;

               Dec (TotalRegelLength,Length (HulpRegelPtr^.RegelPtr^));
               Dec (Msg.MsgSize,Length (HulpRegelPtr^.RegelPtr^));

               FreeMem (HulpRegelPtr^.RegelPtr,Length (HulpRegelPtr^.RegelPtr^)+1);
               FreeMem (HulpRegelPtr,SizeOf (EenRegelRecord));
          END ELSE
          BEGIN
               { eerste regel staat in de swapfile. Nu wordt het leuk, want }
               { we hoeven alleen SwapOffset aan te passen.                 }
               WITH FirstRegelRecordPtr^ DO
               BEGIN
                    Seek (SwapFile,SwapOffset);
                    BlockRead (SwapFile,RegelLength,1);

                    IF (RegelLength = 0) THEN
                    BEGIN
                         LogMessage ('[MsgsDeleteFirstRowFromBody] Stuck due to swapfile admin! PLEASE REPORT!');
                         Exit;
                    END;

                    { ook deze nog even aanpassen. Is beter voor split parts berekening enzo }
                    Dec (TotalRegelLength,RegelLength);
                    Dec (Msg.MsgSize,RegelLength);

                    { zet SwapOffset op het begin van de nieuwe regel }
                    Inc (SwapOffset,RegelLength+1);

                    { controleer nu nog even of dit admin blok leeg is geworden }
                    { (minieme kans).                                           }
                    Seek (SwapFile,SwapOffset);
                    BlockRead (SwapFile,RegelLength,1);

                    IF (RegelLength = 0) THEN
                    BEGIN
                         { ja! zowaar... dan kan dit admin blok helemaal weg }
                         HulpRegelPtr:=FirstRegelRecordPtr;
                         FirstRegelRecordPtr:=FirstRegelRecordPtr^.NextRegelRecordPtr;
                         FreeMem (HulpRegelPtr,SizeOf (EenRegelRecord));
                    END;
               END; { with }
          END;

          { als de laatste regel van het bericht nu verwijderd is, dan   }
          { hebben we een tering probleem, want dan gaat CreateFirstLine }
          { op zijn bek omdat LastRegelRecordPtr nog steeds ergens heen  }
          { wijst, wat nu dus verwijderd is. Als we die aanpassen, dan   }
          { gaat het nog steeds mis want als het top regel block er is,  }
          { dan is er ook een regel. Die moeten we dus ook nog even      }
          { verwijderen.                                                 }

          IF (FirstRegelRecordPtr = NIL) THEN
          BEGIN
               { last is now invalid, so kill it }
               LastRegelRecordPtr:=NIL;

               { now kill the top record as well }
               FreeMem (Msg.BodyTop,SizeOf (TopRegelRecord));
               Msg.BodyTop:=NIL;
          END;

     END; { with }
END;


{--------------------------------------------------------------------------}
{ MsgsSearchLine                                                           }
{                                                                          }
{ Zoekt in een opgegeven bericht gedeelte naar een gegeven begin string    }
{ en geeft de string minus de zoekstring terug. Wordt gebruikt door JAM    }
{ en de FlagPathAsExported routines.                                       }
{ RWI 950506: Uitgebreid met UpCaseFirst, zodat FlagPathAsExported em ook  }
{             kon gaan gebruiken.                                          }
{                                                                          }
FUNCTION MsgsSearchLine (Source : WhereToType; ZoekString : STRING; UpCaseFirst : BOOLEAN) : STRING;

    { zet het argument om in hoofdletters als UpCaseFirst TRUE is }
    FUNCTION DoUp (Regel : STRING) : STRING;
    BEGIN
         IF UpCaseFirst THEN
            DoUp:=UpCaseString (Regel)
         ELSE
             DoUp:=Regel;
    END;

VAR StartLine : EenRegelRecordPtr;
    Res       : STRING;

BEGIN
     StartLine:=NIL;

     { lijkt me handig als de zoekstring ook in allemaal hoofdletters is }
     IF UpCaseFirst THEN
        ZoekString:=UpCaseString (ZoekString);

     { zet de pointer op de eerste regel van de gezochte bron }
     WITH Msg DO
          CASE Source OF
               Header_F :
                   IF (HeaderTop_F <> NIL) THEN
                      StartLine:=HeaderTop_F^.FirstRegelRecordPtr;

               Header_U :
                   IF (HeaderTop_U <> NIL) THEN
                      StartLine:=HeaderTop_U^.FirstRegelRecordPtr;

               Body :
                   IF (BodyTop <> NIL) THEN
                      StartLine:=BodyTop^.FirstRegelRecordPtr;

               Footer_F :
                   IF (FooterTop_F <> NIL) THEN
                      StartLine:=FooterTop_F^.FirstRegelRecordPtr;
          END; { case, with }

     MsgsNewSeek (StartLine);

     { loop door de bron op zoek naar de juiste string }
     WHILE (StartLine <> NIL) DO
     BEGIN
          CASE StartLine^.Waar OF
               wMem :
                   BEGIN
                        IF (DoUp (Copy (StartLine^.RegelPtr^,1,Length (ZoekString))) = ZoekString) THEN
                        BEGIN
                             MsgsSearchLine:=Copy (StartLine^.RegelPtr^,Length (ZoekString)+1,255);
                             Exit;
                        END;

                        StartLine:=StartLine^.NextRegelRecordPtr;
                        MsgsNewSeek (StartLine);
                   END;

               wSwapped :
                   BEGIN
                        BlockRead (SwapFile,Res[0],1);

                        IF (Res[0] = #0) THEN
                        BEGIN
                             StartLine:=StartLine^.NextRegelRecordPtr;
                             MsgsNewSeek (StartLine);
                             Continue;
                        END;

                        BlockRead (SwapFile,Res[1],Byte (Res[0]));

                        IF (DoUp (Copy (Res,1,Length (ZoekString))) = ZoekString) THEN
                        BEGIN
                             MsgsSearchLine:=Copy (Res,Length (ZoekString)+1,255);
                             Exit;
                        END;
                   END; { wSwapped }
          END; { case }
     END; { while }

     { niets gevonden }
     MsgsSearchLine:='';
END;


(* lijkt niet gebruikt te worden... RWI950415
{--------------------------------------------------------------------------}
{ MsgReplaceLine                                                           }
{                                                                          }
{ Geeft het geheugen van de gegeven lijn vrij, en vraagt geheugen aan      }
{ de nieuwe lijn.                                                          }
{                                                                          }
PROCEDURE MsgReplaceLine (Source : WhereToType; LineOffSet : EenRegelRecordPtr; Line : STRING);

VAR TmpRegelLen : INTEGER; { RWI 950415: veranderd van BYTE in INTEGER }

BEGIN
     TmpRegelLen:=Length(Line)-Length (LineOffSet^.RegelPtr^);

     WITH MSG DO
          CASE Source OF
               Header_F :
                   IF (HeaderTop_F <> NIL) THEN
                      Inc (HeaderTop_F^.TotalRegelLength,TmpRegelLen);

               Header_U :
                   IF (HeaderTop_U <> NIL) THEN
                      Inc (HeaderTop_U^.TotalRegelLength,TmpRegelLen);

               Body :
                   IF (BodyTop <> NIL) THEN
                      Inc (BodyTop^.TotalRegelLength,TmpRegelLen);

               Footer_F :
                   IF (FooterTop_F <> NIL) THEN
                      Inc (FooterTop_F^.TotalRegelLength,TmpRegelLen);
          END; { case, with }

     FreeMem (LineOffset^.RegelPtr,Byte (LineOffset^.RegelPtr^[0])+1);
     GetMem (LineOffset^.RegelPtr,Length (Line)+1);
     LineOffset^.RegelPtr^:=Line;
END;
*)

{--------------------------------------------------------------------------}
{ unit initialisation                                                      }
{                                                                          }
{ Hier worden de regel pointer van de universele msg op NIL gezet zodat    }
{ MsgsEmpty geen onaangevraagd geheugen vrij probeert te geven.            }
{                                                                          }
BEGIN
     WITH Msg DO
     BEGIN
          HeaderTop_F:=NIL;
          HeaderTop_U:=NIL;
          BodyTop:=NIL;
          FooterTop_F:=NIL;
     END;

     MsgTrashAllNewLines:=FALSE;
     LineBuffer:=NIL;

     FoundBagReturnUser:=0; { nog niet gevonden }
END.
