{ KEYBOARD.INC: Keyboard Routines }

{==========================================================================}
{ (c) Copyright Waterline Software Developent V.O.F. 1990-1994             }
{                                                                          }
{    Waterline Software Development V.O.F.                                 }
{    Wouter Sluislaan 12                                                   }
{    1461 AC  Zuidoostbeemster                                             }
{    The Netherlands                                                       }
{                                                                          }
{ It not allowed to use this user interface in any program not owned by    }
{ the Waterline Software Development V.O.F.                                }
{ Special conditions apply to programs distributed by the Waterline        }
{ Software Development V.O.F. If the source code of any of these programs  }
{ is distributed as well, it is NOT allowed to use the user interface in   }
{ your own programs. Violators may be prosecuted!                          }
{                                                                          }
{ Please contact the Waterline Software Development V.O.F. at the above    }
{ address for your licence to use the "Ramon" user interface. You will get }
{ the most recent copy of the "Ramon" user interface and the "Ramon" user  }
{ interface expert for free. This program helps you design your user       }
{ interfaces at an instance.                                               }
{                                                                          }
{ This copyright notice should remain in this file and all files that are  }
{ part of the user interface "Ramon".                                      }
{==========================================================================}

CONST KbdScanCodeTranslateTable : ARRAY[0..255] OF KeyType = (

{000} kUnknown,   {001} kAltEsc,    {002} kUnknown,   {003} kUnknown,
{004} kUnknown,   {005} kUnknown,   {006} kUnknown,   {007} kUnknown,
{008} kUnknown,   {009} kUnknown,   {010} kUnknown,   {011} kUnknown,
{012} kUnknown,   {013} kUnknown,   {014} kAltBs,     {015} kShTab,
{016} kAltQ,      {017} kAltW,      {018} kAltE,      {019} kAltR,
{020} kAltT,      {021} kAltY,      {022} kAltU,      {023} kAltI,
{024} kAltO,      {025} kAltP,      {026} kUnknown,   {027} kUnknown,
{028} kAltRet,    {029} kUnknown,   {030} kAltA,      {031} kAltS,
{032} kAltD,      {033} kAltF,      {034} kAltG,      {035} kAltH,
{036} kAltJ,      {037} kAltK,      {038} kAltL,      {039} kUnknown,
{040} kUnknown,   {041} kUnknown,   {042} kUnknown,   {043} kUnknown,
{044} kAltZ,      {045} kAltX,      {046} kAltC,      {047} kAltV,
{048} kAltB,      {049} kAltN,      {050} kAltM,      {051} kUnknown,
{052} kUnknown,   {053} kUnknown,   {054} kUnknown,   {055} kUnknown,
{056} kUnknown,   {057} kUnknown,   {058} kUnknown,   {059} kF1,
{060} kF2,        {061} kF3,        {062} kF4,        {063} kF5,
{064} kF6,        {065} kF7,        {066} kF8,        {067} kF9,
{068} kF10,       {069} kUnknown,   {070} kUnknown,   {071} kHome,
{072} kUp,        {073} kPgUp,      {074} kUnknown,   {075} kLeft,
{076} kPad5,      {077} kRight,     {078} kUnknown,   {079} kEnd,
{080} kDown,      {081} kPgDn,      {082} kIns,       {083} kDel,
{084} kShF1,      {085} kShF2,      {086} kShF3,      {087} kShF4,
{088} kShF5,      {089} kShF6,      {090} kShF7,      {091} kShF8,
{092} kShF9,      {093} kShF10,     {094} kCtrlF1,    {095} kCtrlF2,
{096} kCtrlF3,    {097} kCtrlF4,    {098} kCtrlF5,    {099} kCtrlF6,
{100} kCtrlF7,    {101} kCtrlF8,    {102} kCtrlF9,    {103} kCtrlF10,
{104} kAltF1,     {105} kAltF2,     {106} kAltF3,     {107} kAltF4,
{108} kAltF5,     {109} kAltF6,     {110} kAltF7,     {111} kAltF8,
{112} kAltF9,     {113} kAltF10,    {114} kUnknown,   {115} kCtrlLeft,
{116} kCtrlRight, {117} kCtrlEnd,   {118} kCtrlPgDn,  {119} kCtrlHome,
{120} kAlt1,      {121} kAlt2,      {122} kAlt3,      {123} kAlt4,
{124} kAlt5,      {125} kAlt6,      {126} kAlt7,      {127} kAlt8,
{128} kAlt9,      {129} kAlt0,      {130} kUnknown,   {131} kUnknown,
{132} kCtrlPgUp,  {133} kF11,       {134} kF12,       {135} kShF11,
{136} kShF12,     {137} kCtrlF11,   {138} kCtrlF12,   {139} kAltF11,
{140} kAltF12,    {141} kCtrlUp,    {142} kUnknown,   {143} kUnknown,
{144} kUnknown,   {145} kCtrlDown,  {146} kCtrlIns,   {147} kCtrlDel,
{148} kCtrlTab,   {149} kUnknown,   {150} kUnknown,   {151} kAltHome,
{152} kAltUp,     {153} kAltPgUp,   {154} kUnknown,   {155} kAltLeft,
{156} kUnknown,   {157} kAltRight,  {158} kUnknown,   {159} kAltEnd,
{160} kAltDown,   {161} kAltPgDn,   {162} kAltIns,    {163} kAltDel,
{164} kUnknown,   {165} kAltTab,    {166} kAltRet,    {167} kUnknown,
{168} kUnknown,   {169} kUnknown,   {170} kUnknown,   {171} kUnknown,
{172} kUnknown,   {173} kUnknown,   {174} kUnknown,   {175} kUnknown,
{176} kUnknown,   {177} kUnknown,   {178} kUnknown,   {179} kUnknown,
{180} kUnknown,   {181} kUnknown,   {182} kUnknown,   {183} kUnknown,
{184} kUnknown,   {185} kUnknown,   {186} kUnknown,   {187} kUnknown,
{188} kUnknown,   {189} kUnknown,   {190} kUnknown,   {191} kUnknown,
{192} kUnknown,   {193} kUnknown,   {194} kUnknown,   {195} kUnknown,
{196} kUnknown,   {197} kUnknown,   {198} kUnknown,   {199} kUnknown,
{200} kUnknown,   {201} kUnknown,   {202} kUnknown,   {203} kUnknown,
{204} kUnknown,   {205} kUnknown,   {206} kUnknown,   {207} kUnknown,
{208} kUnknown,   {209} kUnknown,   {210} kUnknown,   {211} kUnknown,
{212} kUnknown,   {213} kUnknown,   {214} kUnknown,   {215} kUnknown,
{216} kUnknown,   {217} kUnknown,   {218} kUnknown,   {219} kUnknown,
{220} kUnknown,   {221} kUnknown,   {222} kUnknown,   {223} kUnknown,
{224} kUnknown,   {225} kUnknown,   {226} kUnknown,   {227} kUnknown,
{228} kUnknown,   {229} kUnknown,   {230} kUnknown,   {231} kUnknown,
{232} kUnknown,   {233} kUnknown,   {234} kUnknown,   {235} kUnknown,
{236} kUnknown,   {237} kUnknown,   {238} kUnknown,   {239} kUnknown,
{240} kUnknown,   {241} kUnknown,   {242} kUnknown,   {243} kUnknown,
{244} kUnknown,   {245} kUnknown,   {246} kUnknown,   {247} kUnknown,
{248} kUnknown,   {249} kUnknown,   {250} kUnknown,   {251} kUnknown,
{252} kUnknown,   {253} kUnknown,   {254} kUnknown,   {255} kUnknown);

CONST KbdFncNr : BYTE = $00; { geinitialiseerde variabele }

VAR{KbdScanCode  : BYTE; nu in RAMON.PAS }
    KbdAsciiCode : BYTE;

    TimeoutKey     : KeyType;
    TimeoutCounter : BYTE;

{--------------------------------------------------------------------------}
{ KeyPressed                                                               }
{                                                                          }
{ Kijk of er op een toets is gedrukt. Zoja, geef dan TRUE terug, anders    }
{ FALSE.                                                                   }
{                                                                          }
FUNCTION KeyPressed : BOOLEAN;
{$IFDEF OS2}

VAR ChData : KbdKeyInfo;

BEGIN
     KbdPeek (ChData,0);
     KeyPressed:=(ChData.fbStatus AND kbdtrf_Final_Char_In <> 0);
{$ELSE}
BEGIN
     KeyPressed:=(MemW[$40:$1A] <> MemW[$40:$1C]);
{$ENDIF}
END;


{--------------------------------------------------------------------------}
{ ReadKey                                                                  }
{                                                                          }
{ Lees het toetsenbord uit en geef de scancode terug. During Idle Time     }
{ wordt de IdleRoutine aangeroepen.                                        }
{                                                                          }
FUNCTION ReadKey : KeyType;

{$IFNDEF NoScrSaver}
VAR TimeoutNextTimer : REAL;
    Timeout          : BOOLEAN;
{$ENDIF}

{$IFDEF OS2}
VAR KeyInfo : KbdKeyInfo;
{$ENDIF}

BEGIN
{$IFDEF ShowMemAvail}
     WriteXY (1,2,AddUpWithSpaces (7,Longint2String (MemAvail)));
{$ENDIF}

{$IFNDEF NoScrSaver}
{}   IF (ScreenSaverCountDownTimer > 0{niet op ^A gedrukt}) THEN
{}      ScreenSaver_GotAKey; { vanaf dit moment 2 minuten wachten voor aanvang }
{}
{}   IF (TimeoutKey <> kUnknown) THEN
{}   BEGIN
{}        WindowPush (Video.Cols-3,Video.Rows,2,1);
{}        WriteXYC (Video.Cols-3,Video.Rows,cFieldCursor,AddUpWithPreSpaces (3,Byte2String (TimeoutCounter)));
{}   END;
{}   Timeout:=FALSE;
{}   TimeoutNextTimer:=GetTimer+18.2;
{}
{}   REPEAT
{}         Key:=IdleRoutine (Visible);
{}         IF (Key = kUnknown) THEN
{}            Key:=ScreenSaver_NoKeyYet;
{}
{}         IF (TimeoutKey <> kUnknown) AND (GetTimer > Round (TimeoutNextTimer)) THEN
{}         BEGIN
{}              TimeoutNextTimer:=TimeoutNextTimer+18.2;
{}              Dec (TimeoutCounter);
{}              WriteXYC (Video.Cols-3,Video.Rows,cFieldCursor,AddUpWithPreSpaces (3,Byte2String (TimeoutCounter)));
{}              Timeout:=(TimeoutCounter = 0);
{}         END;
{}
{}   UNTIL KeyPressed OR (Key <> kUnknown) OR Timeout;
{}
{}   IF (TimeoutKey <> kUnknown) THEN
{}      WindowPop;
{}
{}   IF Timeout THEN
{}   BEGIN
{}        Key:=TimeoutKey;
{}        ReadKey:=TimeoutKey;
{}        TimeoutKey:=kUnknown;
{}        Exit;
{}   END;
{}
{}   TimeoutKey:=kUnknown;
{}
{}   { als er een toets van de IdleRoutine verkregen is, }
{}   { dan die terug gegeven.                            }
{}   IF (Key <> kUnknown) THEN
{}   BEGIN
{}        ReadKey:=Key;
{}        AsciiKey:=#0; { geen toets, voorkom verwarring }
{}        Exit;
{}   END;
{$ENDIF} { not NoScrSaver }

{ toetsenbord actie }
     {$IFDEF OS2}
     REPEAT
           KbdCharIn (KeyInfo,0{wait},0);
     UNTIL (KeyInfo.fbStatus <> 0);
     {$ELSE}
     {$IFNDEF NoScrSaver}
     IF KeyPressed THEN
     {$ENDIF}
     {$ENDIF}
     BEGIN
          {$IFDEF OS2}
          KbdScanCode:=KeyInfo.chScan;
          KbdAsciiCode:=Byte (KeyInfo.chChar);
          {$ELSE}
          ASM
             MOV AH,KbdFncNr
             INT 16h
             MOV KbdScanCode,AH
             MOV KbdAsciiCode,AL
          END; { asm }
          {$ENDIF}

          CASE KbdAsciiCode OF
                 0,
               224 : Key:=KbdScanCodeTranslateTable[KbdScanCode];

{$IFNDEF NoScrSaver}
                 1 : {CtrlA} ScreenSaverCountDownTimer:=0; { force activation of screen saver }
{$ENDIF}
                 8 : Key:=kBs;
                 9 : Key:=kTab;
                13 : Key:=kRet;
                27 : Key:=kEsc;
               127 : Key:=kCtrlBs;
               ELSE  Key:=kUnknown;
          END; { case }
     END; { keypressed }

     ReadKey:=Key;
     AsciiKey:=Chr (KbdAsciiCode);

{$IFDEF CtrlF11IsScreenTextDump}
     IF (Key = kCtrlF11) THEN
        ScreenDumpToTextFile ('APPSCRN.TXT');
{$ENDIF}

{$IFDEF CtrlF12IsScreenDump}
     IF (Key = kCtrlF12) THEN
        ScreenDumpToFile ('APPSCRN.DMP');
{$ENDIF}
END;


{$IFNDEF NoScrSaver}
{--------------------------------------------------------------------------}
{ SetAutoKey                                                               }
{                                                                          }
{ Met deze routine kan een toets ingesteld worden, die automatisch wordt   }
{ uitgevoerd als er na het opgegeven aantal seconden bij de eerstevolgende }
{ ReadKey niet op een toets wordt gedrukt.                                 }
{                                                                          }
PROCEDURE SetAutoKey (AutoKey : KeyType; Timeout : BYTE{seconds});
BEGIN
     TimeoutKey:=AutoKey;
     TimeoutCounter:=Timeout;
END;


{--------------------------------------------------------------------------}
{ NoIdleRoutine                                                            }
{                                                                          }
{ Dit is een dummy routine om de Idle call vanuit ReadKey naar te leiden   }
{ als de Idle functie niet gebruikt wordt.
{                                                                          }
FUNCTION NoIdleRoutine (State : ScreenSaverStateType) : KeyType;
BEGIN
     NoIdleRoutine:=kUnknown;
END;
{$ENDIF}

{--------------------------------------------------------------------------}
{ KeyboardInit                                                             }
{                                                                          }
{ Deze routine initialiseert de keyboard routines en moet aangeroepen      }
{ worden om te detecteren of er een MF-II keyboard aanwezig is. Zoja, dan  }
{ wordt de toetsenbord-buffer uitlees routine functie nummer aangepast om  }
{ ook de extended keyboard codes terug te krijgen. Als deze routine niet   }
{ aangeroepen is, dan worden alleen de PC/XT en MF-I codes terug gegeven.  }
{ Daarbij zit niet F11,F12, Alt-Esc, Ctrl-Esc, Ctrl-Tab, Ctrl-Up,          }
{ Ctrl-Down, etc. etc.                                                     }
{                                                                          }
PROCEDURE KeyboardInit;

VAR Result : BYTE;

BEGIN
     {$IFNDEF OS2}
     ASM
        MOV AX,$1200
        INT $16
        MOV Result,AH
     END;

     IF (Result <> $12) THEN
     BEGIN
          { MF-II keyboard routines zijn aanwezig! }
          KbdFncNr:=$10; { extended codes uitlees functie nummer }

          {$IFNDEF NoScrSaver}
          ScrSaverKbdFncNr:=$10; { Screen Saver kan niet bij KbdFncNr }
          {$ENDIF}
     END;
     {$ENDIF}
END;
