PROGRAM RHFC; { Ramon Help File Compiler }

{==========================================================================}
{ (c) Copyright Waterline Software Developent V.O.F. 1990-1994             }
{                                                                          }
{    Waterline Software Development V.O.F.                                 }
{    Wouter Sluislaan 12                                                   }
{    1461 AC  Zuidoostbeemster                                             }
{    The Netherlands                                                       }
{                                                                          }
{ It not allowed to use this user interface in any program not owned by    }
{ the Waterline Software Development V.O.F.                                }
{ Special conditions apply to programs distributed by the Waterline        }
{ Software Development V.O.F. If the source code of any of these programs  }
{ is distributed as well, it is NOT allowed to use the user interface in   }
{ your own programs. Violators may be prosecuted!                          }
{                                                                          }
{ Please contact the Waterline Software Development V.O.F. at the above    }
{ address for your licence to use the "Ramon" user interface. You will get }
{ the most recent copy of the "Ramon" user interface and the "Ramon" user  }
{ interface expert for free. This program helps you design your user       }
{ interfaces at an instance.                                               }
{                                                                          }
{ This copyright notice should remain in this file and all files that are  }
{ part of the user interface "Ramon".                                      }
{==========================================================================}

{ dit programma kan een tekstfile compileren tot een helpfile die door }
{ het Ramon Unit Online Help System gebruikt kunnen worden.            }

{ History:

17-10-93 Eerste versie geschreven.
18-10-93 File-informatie header toegevoegd

}


{ opmerking: de compiler kan in het Tools Menu van de IDE opgenomen
             worden. In het commandline veld met dan "$EDNAME $MEM(100)"
             worden ingevuld. Door de $MEM(100) duurt het swappen niet
             zo lang, omdat maar 100kB vrijgemaakt wordt, wat genoeg is.
             $EDNAME is de naam van de file die in het huidige edit window
             staat. Dus om de helpfile te compiler, moet de file in een van
             de edit window geladen worden en dat window actief worden. Als
             de edit file bijvoorbeeld in edit scherm 2 zit en de compiler
             onder shift-f8 geinstalleerd is, dan kan met ALT-2 en SHIFT-F8
             de file gecompileerd worden.
}

USES Ramon;

{ formaat van de invoer tekstfile:

De eerste regel moet de naam van de output file bevatten in het volgende
formaat: "HLPfile <output filename>" zonder de aanhalingstekens. Bijvoorbeeld
"HLPfile WTRGATE.HLP". De extensie moet worden opgegeven.

Lege regels worden overgeslagen, behalve als ze in het help-tekst blok
voorkomen. Een Helpblok wordt begonnen met "#begin " en daarachter het
handle nummer. Bijvoorbeeld "#begin 100". Nummer 0 mag niet gebruikt worden
en het hoogste nummer is 65535. Het einde van een helpblock wordt door
"#end" aangegeven.

Link toetsen moeten tussen #begin en #end opgegeven worden in het volgende
formaat: "#link <toetscode> <link handle nummer>". De mogelijke link toetsen
zijn: A..Z, 0..9, F1..F10, Space, Ret, PgUp, PgDn, CtrlPgUp, CtrlPgDn, Home,
End. Bijvoorbeeld: "#link pgdn 20045"

}

{$I KEYSDEF.INC}
{$I HLPSTRUC.INC}

VAR TextFilename : STRING[79];
    TextFile     : TEXT;
    TextRegel    : STRING;
    Fatal        : BOOLEAN;

TYPE KeyDescrString = STRING[8];

{--------------------------------------------------------------------------}
{ KeyNameToKeyNr                                                           }
{                                                                          }
{ Deze routine vertaalt de omschrijvingen van de toetsen naar de nummers   }
{ voor de toetsen zoals de Ramon Unit deze kent. Als de opgegeven          }
{ omschrijving niet bekend is, dan wordt FALSE terug gegeven, anders       }
{ wordt het nummer ingegeven en TRUE terug gegeven.                        }
{                                                                          }
FUNCTION KeyNameToKeyNr (KeyDescr : KeyDescrString; VAR KeyNr : KeyType) : BOOLEAN;

TYPE KeyDescrRecord = RECORD
                            Name : KeyDescrString;
                            Nr   : KeyType;
                      END;

CONST KeysCount = 17;
      KeyNames : ARRAY[1..KeysCount] OF KeyDescrRecord = (
                                     (Name : 'F1';       Nr : kF1),
                                     (Name : 'F2';       Nr : kF2),
                                     (Name : 'F3';       Nr : kF3),
                                     (Name : 'F4';       Nr : kF4),
                                     (Name : 'F5';       Nr : kF5),
                                     (Name : 'F6';       Nr : kF6),
                                     (Name : 'F7';       Nr : kF7),
                                     (Name : 'F8';       Nr : kF8),
                                     (Name : 'F9';       Nr : kF9),
                                     (Name : 'F10';      Nr : kF10),
                                    {(Name : 'SPACE';    Nr : kSpace),}
                                     (Name : 'RET';      Nr : kRet),
                                     (Name : 'PGUP';     Nr : kPgUp),
                                     (Name : 'PGDN';     Nr : kPgDn),
                                     (Name : 'CTRLPGUP'; Nr : kCtrlPgUp),
                                     (Name : 'CTRLPGDN'; Nr : kCtrlPgDn),
                                     (Name : 'HOME';     Nr : kHome),
                                     (Name : 'END';      Nr : kEnd)
                                     );

VAR Lp : 1..KeysCount;

BEGIN
     KeyDescr:=UpCaseString (KeyDescr);

     IF (Length (KeyDescr) = 1) AND (KeyDescr[1] IN ['0'..'9','A'..'Z']) THEN
     BEGIN
          KeyNr:=KeyType (Ord (KeyDescr[1])+128); { met b7 geset }
          KeyNameToKeyNr:=TRUE;
          Exit;
     END;

     FOR Lp:=1 TO KeysCount DO
         IF (KeyNames[Lp].Name = KeyDescr) THEN
         BEGIN
              KeyNr:=KeyNames[Lp].Nr;
              KeyNameToKeyNr:=TRUE;
              Exit;
         END;

     KeyNameToKeyNr:=FALSE;
END;


{--------------------------------------------------------------------------}
{ ProcessTextFile                                                          }
{                                                                          }
{ Deze routine leest de hele tekstfile in en creert daarvan de output file }
{ op disk. De invoer moet uit TextFile komen, de uitvoer kan naar HelpFile }
{ geschreven worden, binair. Beide files zijn geopend. Afsluiten hoeft     }
{ hier niet.                                                               }
{                                                                          }
PROCEDURE ProcessTextFile;

VAR HandlesCount,
    HandleNr,
    CurrHandle   : HelpHandleType;
    IndexOffset,
    BlockOffset,
    BlkLenOffset : LONGINT;
    InBlock      : BOOLEAN;
    BlkLen,
    LineNr       : WORD;
    Index        : HelpIndexRecord;
    Header       : STRING[20];
    Nop          : INTEGER;
    LinkKey      : LinkKeyRecord;
    KeyName      : KeyDescrString;

BEGIN
     Header:='Online Help File'#26'RH1';

     { fase 1: handles tellen }

     HandlesCount:=0;
     WHILE (NOT Eof (TextFile)) DO
     BEGIN
          ReadLn (TextFile,TextRegel);
          IF (UpCaseString (Copy (TextRegel,1,7)) = '#BEGIN ') THEN
             Inc (HandlesCount);
     END;

     WriteLn ('Found handles: ',HandlesCount);

     Inc (HandlesCount); { een voor de afsluitende 0-handle }

     BlockWrite (HelpFile,Header[1],20);

     IndexOffset:=20;
     BlkLenOffset:=IndexOffset+HandlesCount*SizeOf (HelpIndexRecord);
     BlockOffset:=BlkLenOffset+2;

     { opnieuw de textfile openen om weer aan het begin te staan. De  }
     { eerste regel bevatte de HLPfile regel, die moet dus weggelezen }
     { worden.                                                        }
     Close (TextFile);
     Reset (TextFile); { geen controle, file bestond net ook }
     ReadLn (TextFile,TextRegel);
     LineNr:=1;

     { fase 2: de file compileren }
     InBlock:=FALSE;
     WHILE (NOT Eof (TextFile)) DO
     BEGIN
          ReadLn (TextFile,TextRegel);
          Inc (LineNr);
          TextRegel:=DeleteBackSpaces (TextRegel);

          IF InBlock OR
             ((TextRegel <> '') AND (TextRegel[1] <> ';')) THEN
          BEGIN
               { verwerk de regel }

               IF (TextRegel[1] = '#') THEN
               BEGIN
                    TextRegel:=UpCaseString (TextRegel);
                    IF (Copy (TextRegel,1,7) = '#BEGIN ') THEN
                    BEGIN
                         IF InBlock THEN
                         BEGIN
                              WriteLn ('Fatal: Already in Help Block when found an other #BEGIN in line ',LineNr);
                              Fatal:=TRUE;
                              Exit;
                         END;

                         InBlock:=TRUE;
                         BlkLen:=0;

                         Delete (TextRegel,1,7);
                         Val (TextRegel,HandleNr,Nop);
                         IF (Nop <> 0) OR (HandleNr = 0) THEN
                         BEGIN
                              WriteLn ('Fatal: Invalid HandleNr found in line ',LineNr);
                              Fatal:=TRUE;
                              Exit;
                         END;

                         Index.Handle:=HandleNr;
                         Index.Offset:=BlkLenOffset;
                         Seek (HelpFile,IndexOffset);
                         BlockWrite (HelpFIle,Index,SizeOf (HelpIndexRecord));
                         Inc (IndexOffset,SizeOf (HelpIndexRecord));

                         TextRegel:='';
                    END;

                    IF (TextRegel = '#END') THEN
                    BEGIN
                         IF (NOT InBlock) THEN
                         BEGIN
                              WriteLn ('Fatal: Not in a Help Block, but found a #END in line ',LineNr);
                              Fatal:=TRUE;
                              Exit;
                         END;

                         InBlock:=FALSE;
                         Seek (HelpFile,BlkLenOffset);
                         BlockWrite (HelpFile,BlkLen,2);

                         BlkLenOffset:=BlockOffset;
                         BlockOffset:=BlkLenOffset+2;

                         TextRegel:='';
                    END;

                    IF (Copy (TextRegel,1,6) = '#LINK ') THEN
                    BEGIN
                         IF (NOT InBlock) THEN
                         BEGIN
                              WriteLn ('Fatal: Found a #LINK while not in a Help Block in line ',LineNr);
                              Fatal:=TRUE;
                              Exit;
                         END;

                         Delete (TextRegel,1,6);
                         IF (Pos (' ',TextRegel) = 0) THEN
                            WriteLn ('Warning: Ignoring #LINK statement in line ',LineNr,' due to a syntax error')
                         ELSE BEGIN
                              KeyName:=Copy (TextRegel,1,Pos (' ',TextRegel)-1);
                              Delete (TextRegel,1,Pos (' ',TextRegel));

                              Val (TextRegel,HandleNr,Nop);
                              IF (HandleNr = 0) OR (Nop <> 0) THEN
                                 WriteLn ('Warning: Ignoring #LINK statement in line ',LineNr,' due to a bad Handle Number')
                              ELSE BEGIN
                                   IF (NOT KeyNameToKeyNr (KeyName,LinkKey.Key)) THEN
                                      WriteLn ('Warning: Ignoring #LINK statement in line ',LineNr,
                                               ' due to a unknown Key description')
                                   ELSE BEGIN
                                        LinkKey.Handle:=HandleNr;

                                        { schrijf het link record naar disk }
                                        Seek (HelpFile,BlockOffset);
                                        Header[1]:=#1;
                                        BlockWrite (HelpFile,Header[1],1);
                                        BlockWrite (HelpFile,LinkKey,SizeOf (LinkKeyRecord));
                                        Inc (BlockOffset,SizeOf (LinkKeyRecord)+1);
                                        Inc (BlkLen,SizeOf (LinkKeyRecord)+1);
                                   END; { unknown key name }
                              END; { bad handle number }
                         END; { syntax error in #link statement }

                         TextRegel:='';
                    END;
               END ELSE
               BEGIN
                    { kijk of we in een help blok zitten, dan naar de }
                    { file schrijven.                                 }

                    IF (NOT InBlock) THEN
                       WriteLn ('Warning: Line is not in a Help Block in line ',LineNr)
                    ELSE BEGIN
                         Seek (HelpFile,BlockOffset);
                         Header[1]:=#13;
                         BlockWrite (HelpFile,Header[1],1);
                         BlockWrite (HelpFile,TextRegel,Length (TextRegel)+1);
                         Inc (BlockOffset,Length (TextRegel)+2);
                         Inc (BlkLen,Length (TextRegel)+2);
                    END;
               END;

          END; { geen lege of rem regel }
     END; { while not eof }

     { nu moet het laatste block afgesloten zijn en kan de null-handle }
     { toegevoegd worden aan de index tabel.                           }
     IF InBlock THEN
        WriteLn ('Warning: Last block not closed with a #END');

     Index.Handle:=0;
     Index.Offset:=0;
     Seek (HelpFile,IndexOffset);
     BlockWrite (HelpFile,Index,SizeOf (HelpIndexRecord));
END;


{--------------------------------------------------------------------------}
{ main                                                                     }
{                                                                          }

VAR IORes : BYTE;

BEGIN
     WriteLn ('RHFC v1.0');
     WriteLn ('(c) Ramon van der Winkel ''93');
     WriteLn;

     IF (ParamCount <> 1) THEN
     BEGIN
          WriteLn ('Usage: RHFC <text helpfile name>');
          Halt;
     END;

     TextFilename:=UpcaseString (ParamStr (1));
     Assign (TextFile,TextFilename);
     {$I-} Reset (TextFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          WriteLn ('Fatal: Cannot open inputfile');
          Halt;
     END;

     ReadLn (TextFile,TextRegel);
     IF (UpCaseString (Copy (TextRegel,1,8)) <> 'HLPNAME ') THEN
        WriteLn ('Expected HLPNAME <name> on first line of file!')
     ELSE BEGIN
          Delete (TextRegel,1,8);
          HelpFilename:=UpCaseString (TextRegel);

          Assign (HelpFile,HelpFilename);
          {$I-} ReWrite (HelpFile,1); {$I+} IORes:=IOResult;
          IF (IORes <> 0) THEN
             WriteLn ('Fatal: Cannot create outputfile '+HelpFilename)
          ELSE BEGIN
               Fatal:=FALSE;
               ProcessTextFile;
               Close (HelpFile);
               IF Fatal THEN
                  Erase (HelpFile);
          END; { kon outputfile niet aanmaken }
     END; { geen commandline argument }

     Close (TextFile);
END.

