Unit dspin;
{
                DSpin - Door version of Spinning Curser Input
                             - Sep 05 / 1997
                This Unit has my new Funky Input routine.
                Also has the dynlb stuff from Enigma
}

interface

function ReadKeySpin(wait : Byte) : Char;
function readnospinkey : Char;
function ReadStringSpin(Len, X, Y, Attr1, Attr2: Byte; Limiter: Char): String;
function DPipeStrLen(S: String): Byte;
function Tdnylb(quest, ys, ns: string): boolean;
function Tdynlb(quest, ys, ns: string): boolean;

implementation
Uses
{$IFDEF OS2}
  os2base,
  VpSysLow,
  xdoor,
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  VpSysLow,
  xdoor,
{$ENDIF}
{$IFDEF LINUX}
  LocalD,
  Enigma,
{$ENDIF}
{$IFDEF MSDOS}
  Xdoor,
{$ENDIF}
  Crt;

Const
  SpinChar : Array [1..4] of Char = ('','/','','\');

Function ReadKeySpin(Wait : Byte) : Char;
Var
  X,Y  : Byte;
  Num  : Byte;
  Ch   : Char;
begin
  Num := 1;                               (* initialize SpinChars  *)
  X   := WhereX;                          (* Where am I ??         *)
  Y   := WhereY;
  Repeat
    CGotoXY(X, Y);                   (* Go back               *)
    Cout(SpinChar[Num]);           (* Spin the Cursor       *)
    Delay(Wait);                    (* Wait, it's to fast!   *)
    CGotoXY(X, Y);                   (* Go back               *)
{    DWrite(#8); }
    Inc(Num);                       (* Next SpinChar, please *)
    if Num = 5 then Num := 1;       (* I have only 5 Chars   *)
{$IFDEF LINUX}
  Until KeyPressed;
  DReadC(Ch);
{$ELSE}
  Until CKeyPressed;
  ch := InKey;
{$ENDIF}
  ReadKeySpin := Ch;                    (* give a result         *)
end;

function readnospinkey : Char;
Var
  Ch   : Char;
begin
  Repeat
  {$IFDEF LINUX}
  Until KeyPressed;
  DReadC(CH);
  {$ELSE}
  {$IFNDEF MSDOS}
  SysCtrlSleep(1);
  {$ENDIF}
  Until CKeyPressed;
  ch := inkey;                            { Get the pressed Key   }
  {$ENDIF}
  ReadNoSpinKey:= Ch;                    { give a result         }
end;

function ReadStringSpin(Len, X, Y, Attr1, Attr2: Byte; Limiter: Char): String;
var
  i: integer;
 ch: char;
  s: string;
begin
  cgotoxy(x,y);
  fg(Attr2);
  for i:=1 to len do cout(Limiter);
  for i:=1 to len do cout(#8);
  fg(Attr1);
  x:=wherex;
  y:=wherey;
  s:='';
  repeat
    ch:=ReadKeySpin(40);
    if (ch<>#8) and (ch<>^M) and (ch<>#9) and (length(s)<Len) then
      begin
        if ch in [#1..#7,#10..#12,#14..#31,#127..#255] then ch:=#0 else
        begin
          s:=s+ch;
          Cout(ch);
        end;
      end;
    if (ch=chr(8)) and (length(s)>0) then
      begin
        delete(s,length(s),1);
        Cout(chr(8));
        fg(Attr2);
        Cout(Limiter);
        fg(Attr1);
        Cout(#8);
      end;
  until (ch=^M) or (ch=#9);
  readstringspin:=s;
end;

function DPipeStrLen(S: String): Byte;
Var
  C: Byte;
  B: Integer;
Begin
  C:=Length(S);
  For B:=1 to Length(S) Do
    If S[B]='|' Then Dec(C, 3);
  DPipeStrLen:=C;
End;

function Tdynlb(quest, ys, ns: string): boolean;
var
  ch    : char;
  yn    : char;
  ysl   : integer;

procedure yes(b: boolean);
var
  i: integer;
begin
  for i:=1 to ysl do
    cout(#8);
  if b=true then
    cout(ys)
  else cout(ns);
end;

begin
  yn := 'Y';
  Ysl:=DPipeStrLen(Ys);
  Cout('|09' + quest + ' ' + ys);
  tdynlb:=true;
  repeat
    {$IFDEF LINUX}
    DReadC(Ch);
    {$ELSE}
    ch := InKey;
    {$ENDIF}
    Ch := Upcase(Ch);
    if ch = #32 then begin
      if yn = 'Y' then yn := 'N'
      else yn := 'Y'
    end else
    if ch in ['Y','D','4',#75] then yn := 'Y'
    else if ch in ['N','C','6',#77] then yn := 'N';
    case yn of
    'Y': begin
        yes(true);
        tdynlb:=true;
      end;
    'N': begin
        yes(false);
        tdynlb:=false;
      end;
    end;
  until ch = #13;
  nl;
end;

function Tdnylb(quest, ys, ns: string): boolean;
var
  ch: char;
  yn: char;
  nsl: integer;

procedure yes(b: boolean);
var
  i: integer;
begin
  for i:=1 to nsl do
    cout(#8);
  if b=true then
    cout(ys)
  else cout(ns);
end;

begin
  yn := 'N';
  Nsl:=DPipeStrLen(Ns);
  cout('|09' + quest + ' ' + Ns);
  tdnylb:=false;
  repeat
    {$IFDEF LINUX}
    DReadC(Ch);
    {$ELSE}
    ch := InKey;
    {$ENDIF}
    ch := upcase(ch);
    if ch = #32 then begin
      if yn = 'Y' then yn := 'N'
      else yn := 'Y'
    end
    else if ch in ['Y','D','4',#75] then yn:='Y'
    else if ch in ['N','C','6',#77] then yn:='N';
    case yn of
    'Y': begin
        yes(true);
        tdnylb:=true;
     end;
    'N': begin
        yes(false);
        tdnylb:=false;
      end;
    end;
  until ch = #13;
  nl;
end;

begin
end.
