{$O+,I-}
UNIT RWS_GV;

(* 

    RWS_GV - RWSETUP menus - general/variables

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


INTERFACE


PROCEDURE Handle_GeneralSettings;
PROCEDURE Handle_VariablesAndLimits;
PROCEDURE Handle_UserEditor;
PROCEDURE Handle_ProtocolEditor;


IMPLEMENTATION


USES  RWSGEN,   RWSMAIN,  RECORDS,  RWSTRUCT, CRT,      MSOBJ,
      MSTRINGS, MISC1,    CURSOR,   FASTW,    SCREENS,  MSBWGEN,
      KEYINPUT, MSRGGEN;


PROCEDURE Handle_GeneralSettings;
CONST Len          = 55;
      EditCol      = 22;
      
VAR   GenSetChoice : Integer;
      RwMenu       : PMenuType;

    PROCEDURE Init_GeneralSettings;
    CONST MenuItems = 11;
    BEGIN
       RWS_ReadMenuDesc(170,MenuItems);

       Menu_Init(RwMenu,3,7,78,21,1,25,MenuItems,TRUE,'Paths and filenames');
       Menu_AddItem(RwMenu,01,20,' ',FALSE,00,02,0,0,4, 9,0,1,MenuDesc^[01].Desc,MenuDesc^[01].Status);
       Menu_AddItem(RwMenu,02,21,' ',FALSE,01,03,0,0,4,10,0,1,MenuDesc^[02].Desc,MenuDesc^[02].Status);
       Menu_AddItem(RwMenu,03,22,' ',FALSE,02,04,0,0,4,11,0,1,MenuDesc^[03].Desc,MenuDesc^[03].Status);
       Menu_AddItem(RwMenu,04,23,' ',FALSE,03,05,0,0,4,12,0,1,MenuDesc^[04].Desc,MenuDesc^[04].Status);
       Menu_AddItem(RwMenu,05,24,' ',FALSE,04,06,0,0,4,13,0,1,MenuDesc^[05].Desc,MenuDesc^[05].Status);
       Menu_AddItem(RwMenu,06,25,' ',FALSE,05,07,0,0,4,14,0,1,MenuDesc^[06].Desc,MenuDesc^[06].Status);
       Menu_AddItem(RwMenu,07,26,' ',FALSE,06,08,0,0,4,15,0,1,MenuDesc^[07].Desc,MenuDesc^[07].Status);
       Menu_AddItem(RwMenu,08,27,' ',FALSE,07,09,0,0,4,16,0,1,MenuDesc^[08].Desc,MenuDesc^[08].Status);
       Menu_AddItem(RwMenu,09,28,' ',FALSE,08,10,0,0,4,17,0,1,MenuDesc^[09].Desc,MenuDesc^[09].Status);
       Menu_AddItem(RwMenu,10,29,' ',FALSE,09,11,0,0,4,18,0,1,MenuDesc^[10].Desc,MenuDesc^[10].Status);
       Menu_AddItem(RwMenu,11,30,' ',FALSE,10,00,0,0,4,19,0,1,MenuDesc^[11].Desc,MenuDesc^[11].Status);
    END;

    PROCEDURE DrawChoice(MChoice:Integer; Str:String; Len:Byte);
    BEGIN
       GotoXY(EditCol,MChoice+8);
       TextAttr := 27;
       Write(PadRight(Str,' ',Len));
    END;

    PROCEDURE DrawGeneralSettings;
    BEGIN
       DrawChoice(1,SRW.RgMainDir,Len);
       DrawChoice(2,SRW.RwMainDir,Len);
       DrawChoice(3,SRW.RwWorkDir,Len);
       DrawChoice(4,SRW.RwMenuDir,Len);
       DrawChoice(5,SRW.RwTextDir,Len);
       DrawChoice(6,SRW.RwHelpDir,Len);
       DrawChoice(7,SRW.RwLangDir,Len);
       DrawChoice(8,SRW.RwScanDir,Len);
       DrawChoice(9,SRW.LocalDLDir,Len);
       DrawChoice(10,SRW.LocalULDir,Len);
       DrawChoice(11,SRW.LogFile,Len);
    END;

    PROCEDURE DirectoryInput(n:Byte; VAR Dir:String);
    BEGIN
       WITH RwMenu^.ItemData^[n] DO
          GetInput(Dir,Dir,Filepath,63,EditCol,YPos,Len,TRUE);
       IF Dir <> '' THEN Dir := AddSlash(Dir);
       CheckDir(Dir);
    END;

BEGIN
   New(TempScreen2);
   Init_GeneralSettings;
   Menu_DrawMenu(RwMenu);
   Menu_ClearMenu(RwMenu);
   Menu_DrawItems(RwMenu);
   DrawGeneralSettings;
   REPEAT
      SetCursor(cmOff);
      Menu_GetChoice(RwMenu,GenSetChoice);
      CASE GenSetChoice OF
         1 : BEGIN
                DirectoryInput(1,SRW.RgMainDir);
                DrawChoice(1,SRW.RgMainDir,Len);
             END;
         2 : BEGIN
                DirectoryInput(2,SRW.RwMainDir);
                DrawChoice(2,SRW.RwMainDir,Len);
             END;
         3 : BEGIN
                DirectoryInput(3,SRW.RwWorkDir);
                DrawChoice(3,SRW.RwWorkDir,Len);
             END;
         4 : BEGIN
                DirectoryInput(4,SRW.RwMenuDir);
                DrawChoice(4,SRW.RwMenuDir,Len);
             END;
         5 : BEGIN
                DirectoryInput(5,SRW.RwTextDir);
                DrawChoice(5,SRW.RwTextDir,Len);
             END;
         6 : BEGIN
                DirectoryInput(6,SRW.RwHelpDir);
                DrawChoice(6,SRW.RwHelpDir,Len);
             END;
         7 : BEGIN
                DirectoryInput(7,SRW.RwLangDir);
                DrawChoice(7,SRW.RwLangDir,Len);
             END;
         8 : BEGIN
                DirectoryInput(8,SRW.RwScanDir);
                DrawChoice(8,SRW.RwScanDir,Len);
             END;
         9 : BEGIN
                DirectoryInput(9,SRW.LocalDLDir);
                DrawChoice(9,SRW.LocalDLDir,Len);
             END;
        10 : BEGIN
                DirectoryInput(10,SRW.LocalULDir);
                DrawChoice(10,SRW.LocalULDir,Len);
             END;
        11 : BEGIN
                GetInput(SRW.LogFile,SRW.LogFile,Filepath,64,EditCol,19,Len,TRUE);
                DrawChoice(11,SRW.LogFile,Len);
             END;
      END;
   UNTIL (GenSetChoice = -1);
   Dispose(TempScreen2);
   Menu_DeInit(RwMenu);
END;


PROCEDURE Handle_VariablesAndLimits;
CONST Len        = 11;
      MenuCol1   =  4;
      MenuCol2   = 40;
      EditCol1   = 28;
      EditCol2   = 64;

VAR   RwMenu     : PMenuType;
      TempStr    : String;
      TempInt,
      Err,
      VarChoice  : Integer;
      TempLInt   : LongInt;
      Ch         : Char;

   PROCEDURE Init_VariablesAndLimits;
   CONST MenuItems = 19;
   BEGIN
      RWS_ReadMenuDesc(190,MenuItems);

      Menu_Init(RwMenu,3,8,78,21,1,25,MenuItems,TRUE,'Miscellaneous options');

      Menu_AddItem(RwMenu, 1,40,' ',FALSE, 0, 2, 0,11,MenuCol1,10,0,1,MenuDesc^[01].Desc,MenuDesc^[01].Status);
      Menu_AddItem(RwMenu, 2,41,' ',FALSE, 1, 3, 0,12,MenuCol1,11,0,1,MenuDesc^[02].Desc,MenuDesc^[02].Status);
      Menu_AddItem(RwMenu, 3,58,' ',FALSE, 2, 4, 0,13,MenuCol1,12,0,1,MenuDesc^[03].Desc,MenuDesc^[03].Status);
      Menu_AddItem(RwMenu, 4,42,' ',FALSE, 3, 5, 0,14,MenuCol1,13,0,1,MenuDesc^[04].Desc,MenuDesc^[04].Status);
      Menu_AddItem(RwMenu, 5,43,' ',FALSE, 4, 6, 0,15,MenuCol1,14,0,1,MenuDesc^[05].Desc,MenuDesc^[05].Status);
      Menu_AddItem(RwMenu, 6,44,' ',FALSE, 5, 7, 0,16,MenuCol1,15,0,1,MenuDesc^[06].Desc,MenuDesc^[06].Status);
      Menu_AddItem(RwMenu, 7,45,' ',FALSE, 6, 8, 0,17,MenuCol1,16,0,1,MenuDesc^[07].Desc,MenuDesc^[07].Status);
      Menu_AddItem(RwMenu, 8,46,' ',FALSE, 7, 9, 0,18,MenuCol1,17,0,1,MenuDesc^[08].Desc,MenuDesc^[08].Status);
      Menu_AddItem(RwMenu, 9,47,' ',FALSE, 8,10, 0,19,MenuCol1,18,0,1,MenuDesc^[09].Desc,MenuDesc^[09].Status);
      Menu_AddItem(RwMenu,10,48,' ',FALSE, 9, 0, 0, 0,MenuCol1,19,0,1,MenuDesc^[10].Desc,MenuDesc^[10].Status);

      Menu_AddItem(RwMenu,11,49,' ',FALSE, 0,12, 1, 0,MenuCol2,10,0,1,MenuDesc^[11].Desc,MenuDesc^[11].Status);
      Menu_AddItem(RwMenu,12,50,' ',FALSE,11,13, 2, 0,MenuCol2,11,0,1,MenuDesc^[12].Desc,MenuDesc^[12].Status);
      Menu_AddItem(RwMenu,13,51,' ',FALSE,12,14, 3, 0,MenuCol2,12,0,1,MenuDesc^[13].Desc,MenuDesc^[13].Status);
      Menu_AddItem(RwMenu,14,52,' ',FALSE,13,15, 4, 0,MenuCol2,13,0,1,MenuDesc^[14].Desc,MenuDesc^[14].Status);
      Menu_AddItem(RwMenu,15,53,' ',FALSE,14,16, 5, 0,MenuCol2,14,0,1,MenuDesc^[15].Desc,MenuDesc^[15].Status);
      Menu_AddItem(RwMenu,16,54,' ',FALSE,15,17, 6, 0,MenuCol2,15,0,1,MenuDesc^[16].Desc,MenuDesc^[16].Status);
      Menu_AddItem(RwMenu,17,55,' ',FALSE,16,18, 7, 0,MenuCol2,16,0,1,MenuDesc^[17].Desc,MenuDesc^[17].Status);
      Menu_AddItem(RwMenu,18,56,' ',FALSE,17,19, 8, 0,MenuCol2,17,0,1,MenuDesc^[18].Desc,MenuDesc^[18].Status);
      Menu_AddItem(RwMenu,19,57,' ',FALSE,18, 0, 9, 0,MenuCol2,18,0,1,MenuDesc^[19].Desc,MenuDesc^[19].Status);
   END;

   PROCEDURE DrawChoice(MChoice:Integer; Str:String; Len:Byte);
   BEGIN
      WITH RwMenu^.ItemData^[MChoice] DO IF MChoice <= 10
         THEN GotoXY(Length(Desc)+MenuCol1+1,YPos)
         ELSE GotoXY(Length(Desc)+MenuCol2+1,YPos);
      TextAttr := 27;
      Write(PadRight(Str,' ',Len));
   END;

   PROCEDURE DrawVariablesAndLimits;
   BEGIN
      DrawChoice(1,SRW.BBSID,Len);

      CASE SRW.RwCommType OF
         0 : DrawChoice(2,'FOSSIL',Len);
         1 : DrawChoice(2,'ASYNC',Len);
      END;

      CASE SRW.RgVer OF
         0 : DrawChoice(3,'5-11 Exp',Len);
         1 : DrawChoice(3,'10-05 Exp',Len);
         2 : DrawChoice(3,'10-31 Exp',Len);
      END;

      DrawChoice(4,YesNoBoolean(SRW.ImportPointers),Len);
      DrawChoice(5,YesNoBoolean(SRW.ForceEmail),Len);
      DrawChoice(6,YesNoBoolean(SRW.ForceNetmail),Len);

      CASE SRW.NTypeEmail OF
         NameAlias : DrawChoice(7,'Alias',Len);
         NameReal  : DrawChoice(7,'Real',Len);
         NameEither: DrawChoice(7,'Alias/Real',Len);
      END;
      CASE SRW.NTypeNetmail OF
         NameAlias : DrawChoice(8,'Alias',Len);
         NameReal  : DrawChoice(8,'Real',Len);
         NameEither: DrawChoice(8,'Alias/Real',Len);
      END;

      DrawChoice(9,StrFunc(SRW.CreditsEmail),Len);
      DrawChoice(10,StrFunc(SRW.CreditsPublic),Len);

      {...}

      CASE SRW.SwapType OF
         EMS  : DrawChoice(11,'EMS',Len);
         DISK : DrawChoice(11,'Disk',Len);
         NONE : DrawChoice(11,'None',Len);
      END;

      DrawChoice(12,YesNoBoolean(SRW.AllowGoodbye),Len);
      DrawChoice(13,YesNoBoolean(SRW.HangUpOnTimeout),Len);
      DrawChoice(14,YesNoBoolean(SRW.NukeLocalRep),Len);
      DrawChoice(15,StrFunc(SRW.MaxDupes),Len);
      DrawChoice(16,StrFunc(SRW.MaxPWTries),Len);
      DrawChoice(17,StrFunc(SRW.TimeoutMinutes),Len);
      DrawChoice(18,StrFunc(SRW.MaxTotalMsgs),Len);
      DrawChoice(19,StrFunc(SRW.MaxBaseMsgs),Len);
   END;

BEGIN
   New(TempScreen2);
   Init_VariablesAndLimits;
   Menu_DrawMenu(RwMenu);
   Menu_ClearMenu(RwMenu);
   Menu_DrawItems(RwMenu);
   DrawVariablesAndLimits;
   REPEAT
      SetCursor(cmOff);
      Menu_GetChoice(RwMenu,Varchoice);
      CASE VarChoice OF
         1 : BEGIN
                GetInput(SRW.BBSID,SRW.BBSID,Filename,8,EditCol1,10,0,TRUE);
                DrawChoice(1,SRW.BBSID,Len);
             END;
         2 : BEGIN
                Inc(SRW.RwCommType);
                IF SRW.RwCommType >= 2 THEN SRW.RwCommType := 0;
                CASE SRW.RwCommType OF
                   0 : DrawChoice(2,'FOSSIL',Len);
                   1 : DrawChoice(2,'ASYNC',Len);
                END;
             END;
         3 : BEGIN
                SRW.RgVer := SRW.RgVer+1;
                IF SRW.RgVer > 2 THEN SRW.RgVer := 0;
                CASE SRW.RgVer OF
                   0 : DrawChoice(3,'5-11 Exp',Len);
                   1 : DrawChoice(3,'10-05 Exp',Len);
                   2 : DrawChoice(3,'10-31 Exp',Len);
                END;
             END;
         4 : BEGIN
                SRW.ImportPointers := SRW.ImportPointers XOR TRUE;
                DrawChoice(4,YesNoBoolean(SRW.ImportPointers),Len);
             END;
         5 : BEGIN
                SRW.ForceEmail := SRW.ForceEmail XOR TRUE;
                DrawChoice(5,YesNoBoolean(SRW.ForceEmail),Len);
             END;
         6 : BEGIN
                SRW.ForceNetmail := SRW.ForceNetmail XOR TRUE;
                DrawChoice(6,YesNoBoolean(SRW.ForceNetmail),Len);
             END;
         7 : BEGIN
                CASE SRW.NTypeEmail OF
                   NameAlias : SRW.NTypeEmail := NameReal;
                   NameReal  : SRW.NTypeEmail := NameEither;
                   NameEither: SRW.NTypeEmail := NameAlias;
                END;
                CASE SRW.NTypeEmail OF
                   NameAlias : DrawChoice(7,'Alias',Len);
                   NameReal  : DrawChoice(7,'Real',Len);
                   NameEither: DrawChoice(7,'Alias/Real',Len);
                END;
             END;
         8 : BEGIN
                CASE SRW.NTypeNetmail OF
                   NameAlias : SRW.NTypeNetmail := NameReal;
                   NameReal  : SRW.NTypeNetmail := NameEither;
                   NameEither: SRW.NTypeNetmail := NameAlias;
                END;
                CASE SRW.NTypeNetmail OF
                   NameAlias  : DrawChoice(8,'Alias',Len);
                   NameReal   : DrawChoice(8,'Real',Len);
                   NameEither:  DrawChoice(8,'Alias/Real',Len);
                END;
             END;
         9 : BEGIN
                TempStr := '';
                GetInput(TempStr,StrFunc(SRW.CreditsEmail),Number+'-',4,EditCol1,18,0,TRUE);
                Val(TempStr,TempInt,Err);
                IF (Err = 0) THEN SRW.CreditsEmail := TempInt;
                DrawChoice(9,StrFunc(SRW.CreditsEmail),Len);
             END;
        10 : BEGIN
                TempStr := '';
                GetInput(TempStr,StrFunc(SRW.CreditsPublic),Number+'-',4,EditCol1,19,0,TRUE);
                Val(TempStr,TempInt,Err);
                IF (Err = 0) THEN SRW.CreditsPublic := TempInt;
                DrawChoice(10,StrFunc(SRW.CreditsPublic),Len);
             END;
         {...}
        11 : BEGIN
                CASE SRW.SwapType OF
                   EMS  : SRW.SwapType := DISK;
                   DISK : SRW.SwapType := NONE;
                   NONE : SRW.SwapType := EMS;
                END;
                CASE SRW.SwapType OF
                   EMS  : DrawChoice(11,'EMS',Len);
                   DISK : DrawChoice(11,'Disk',Len);
                   NONE : DrawChoice(11,'None',Len);
                END;
             END;
        12 : BEGIN
                SRW.AllowGoodbye := SRW.AllowGoodbye XOR TRUE;
                DrawChoice(12,YesNoBoolean(SRW.AllowGoodbye),Len);
             END;
        13 : BEGIN
                SRW.HangUpOnTimeout := SRW.HangUpOnTimeout XOR TRUE;
                DrawChoice(13,YesNoBoolean(SRW.HangUpOnTimeout),Len);
             END;
        14 : BEGIN
                SRW.NukeLocalRep := SRW.NukeLocalRep XOR TRUE;
                DrawChoice(14,YesNoBoolean(SRW.NukeLocalRep),Len);
             END;
        15 : BEGIN
                TempStr := '';
                GetInput(TempStr,StrFunc(SRW.MaxDupes),Number,5,EditCol2,14,0,TRUE);
                Val(TempStr,TempInt,Err);
                IF (Err = 0) AND (TempInt >= 0) THEN SRW.MaxDupes := TempInt;
                DrawChoice(15,StrFunc(SRW.MaxDupes),Len);
             END;
        16 : BEGIN
                TempStr := '';
                GetInput(TempStr,StrFunc(SRW.MaxPWTries),Number,3,EditCol2,15,0,TRUE);
                Val(TempStr,TempInt,Err);
                IF (Err = 0) AND (TempInt IN [0..255]) THEN SRW.MaxPWTries := TempInt;
                DrawChoice(16,StrFunc(SRW.MaxPWTries),Len);
             END;
        17 : BEGIN
                TempStr := '';
                GetInput(TempStr,StrFunc(SRW.TimeoutMinutes),Number,3,EditCol2,16,0,TRUE);
                Val(TempStr,TempInt,Err);
                IF (Err = 0) AND (TempInt IN [0..255]) THEN SRW.TimeoutMinutes := TempInt;
                DrawChoice(17,StrFunc(SRW.TimeoutMinutes),Len);
             END;
        18 : BEGIN
                TempStr := '';
                GetInput(TempStr,StrFunc(SRW.MaxTotalMsgs),Number,6,EditCol2,17,0,TRUE);
                Val(TempStr,TempLInt,Err);
                IF (Err = 0) AND (TempLInt >= 0) THEN SRW.MaxTotalMsgs := TempLInt;
                DrawChoice(18,StrFunc(SRW.MaxTotalMsgs),Len);
             END;
        19 : BEGIN
                TempStr := '';
                GetInput(TempStr,StrFunc(SRW.MaxBaseMsgs),Number,6,EditCol2,18,0,TRUE);
                Val(TempStr,TempLInt,Err);
                IF (Err = 0) AND (TempLInt >= 0) THEN SRW.MaxBaseMsgs := TempLInt;
                DrawChoice(19,StrFunc(SRW.MaxBaseMsgs),Len);
             END;
       END;
   UNTIL (VarChoice = -1);
   Dispose(TempScreen2);
   Menu_DeInit(RwMenu);
END;


PROCEDURE Handle_UserEditor;
CONST MenuCol1   = 3;   Len1 = 15;  EditCol1 = 20;
      MenuCol2   = 37;  Len2 = 20;  EditCol2 = 57;

VAR   i,
      CurrUser,
      UserChoice : Integer;
      FoundUser  : Boolean;
      UserMenu   : PMenuType;
      ch         : Char;
      LoadError  : Boolean;

   PROCEDURE UserError(s:String);
   BEGIN
      LoadError := TRUE;
      RWS_DispErrorMsg('Error: '+s);
   END;

   PROCEDURE Init_UserEditor;
   CONST MenuItems = 13;
   BEGIN
      RWS_ReadMenuDesc(80,MenuItems);
      Menu_Init(UserMenu,2,8,78,21,1,25,MenuItems,TRUE,'User editor');

      Menu_AddItem(UserMenu,01,200,' ',FALSE,0,2,0,09,MenuCol1,12,0,1,MenuDesc^[01].Desc,MenuDesc^[01].Status);
      Menu_AddItem(UserMenu,02,201,' ',FALSE,1,3,0,10,MenuCol1,13,0,1,MenuDesc^[02].Desc,MenuDesc^[02].Status);
      Menu_AddItem(UserMenu,03,202,' ',FALSE,2,4,0,11,MenuCol1,14,0,1,MenuDesc^[03].Desc,MenuDesc^[03].Status);
      Menu_AddItem(UserMenu,04,203,' ',FALSE,3,5,0,12,MenuCol1,15,0,1,MenuDesc^[04].Desc,MenuDesc^[04].Status);
      Menu_AddItem(UserMenu,05,204,' ',FALSE,4,6,0,13,MenuCol1,16,0,1,MenuDesc^[05].Desc,MenuDesc^[05].Status);
      Menu_AddItem(UserMenu,06,205,' ',FALSE,5,7,0,00,MenuCol1,17,0,1,MenuDesc^[06].Desc,MenuDesc^[06].Status);
      Menu_AddItem(UserMenu,07,206,' ',FALSE,6,8,0,00,MenuCol1,19,0,1,MenuDesc^[07].Desc,MenuDesc^[07].Status);
      Menu_AddItem(UserMenu,08,207,' ',FALSE,7,0,0,00,MenuCol1,20,0,1,MenuDesc^[08].Desc,MenuDesc^[08].Status);

      Menu_AddItem(UserMenu,09,208,' ',FALSE,00,10,1,00,MenuCol2,12,0,1,MenuDesc^[09].Desc,MenuDesc^[09].Status);
      Menu_AddItem(UserMenu,10,209,' ',FALSE,09,11,2,00,MenuCol2,13,0,1,MenuDesc^[10].Desc,MenuDesc^[10].Status);
      Menu_AddItem(UserMenu,11,210,' ',FALSE,10,12,3,00,MenuCol2,14,0,1,MenuDesc^[11].Desc,MenuDesc^[11].Status);
      Menu_AddItem(UserMenu,12,211,' ',FALSE,11,13,4,00,MenuCol2,15,0,1,MenuDesc^[12].Desc,MenuDesc^[12].Status);
      Menu_AddItem(UserMenu,13,212,' ',FALSE,12,00,5,00,MenuCol2,16,0,1,MenuDesc^[13].Desc,MenuDesc^[13].Status);
   END;

   PROCEDURE DrawChoice(MChoice:Integer; Str:String; Len:Byte);
   BEGIN
      WITH UserMenu^.ItemData^[MChoice] DO
         IF MChoice <= 8
            THEN GotoXY(EditCol1,YPos)
            ELSE GotoXY(EditCol2,YPos);
      TextAttr := 27;
      Write(PadRight(Str,' ',Len));
   END;

   PROCEDURE DrawUserEditor;
   BEGIN
      ReadUsersRW(CurrUser);

      MsRg_UserIdxOpen;
      URW.UserRecNum := MsRg_UserIdxSearch(URW.RealName);
      MsRg_UserIdxRead(URW.UserRecNum);
      MsRg_UserIdxClose;
      URW.UserRecNum := MsRg_UserIdx.Number;
      MsRg_UserFileRead(URW.UserRecNum);

      WriteColorFast(04,10,'`1A'+PadRight(CutTo(URW.Alias,25)+' ('+CutTo(URW.RealName,25)+')',' ',50));

{      +' (Last DL: '+Unix2DateStr(1,UPCW.LastDL)+')',' ',50));}
      WriteColorFast(60,10,'`19'+PadLeft('Record #'+StrFunc(CurrUser+1)+'/'+StrFunc(FileSize(UsersRW)),' ',17));
      WriteColorFast(03,11,'`19'+RepChar('',75));
      WriteColorFast(03,18,'`19'+RepChar('',75));

      DrawChoice(1,YesNoBoolean(RwNukeEmail IN URW.RwFlags),Len1);
      DrawChoice(2,YesNoBoolean(RwHotkeys IN URW.BWaveFlags),Len1);
      DrawChoice(3,YesNoBoolean(RwXpert IN URW.BWaveFlags),Len1);
      DrawChoice(4,YesNoBoolean(NOT (RwNotMyMAil IN URW.BWaveFlags)),Len1);
      DrawChoice(5,YesNoBoolean(RwNumericPkt IN URW.BWaveFlags),Len1);
      DrawChoice(6,YesNoBoolean(RwFileList IN URW.BWaveFlags),Len1);

      i := RWS_ProtSearch(URW.RwProtocol);
      DrawChoice(7,'('+SRW.RwProtocols[i].Letter+') '+SRW.RwProtocols[i].Desc,Len1);
      DrawChoice(8,MsRg_General.FileArcInfo[MsRg_User.DefArcType].Ext,Len1);

      DrawChoice(9,URW.RWPass,Len2);
      CASE URW.PassUsage OF
         1 :  DrawChoice(10,'Door',Len2);
         2 :  DrawChoice(10,'Reader',Len2);
         3 :  DrawChoice(10,'Door/Reader',Len2);
         ELSE DrawChoice(10,'<disabled>',Len2);
      END;

      IF URW.MsgsLimit = 0
         THEN DrawChoice(11,'<disabled>',Len2)
         ELSE DrawChoice(11,StrFunc(URW.MsgsLimit),Len2);

      DrawChoice(12,StrFunc(URW.PktNumber),Len2);

      IF (RwPacketQwk IN URW.RwFlags)
         THEN DrawChoice(13,'QWK',Len2)
         ELSE DrawChoice(13,'Blue Wave',Len2);
   END;

   PROCEDURE DeleteUser;
   VAR ScanFile : FILE;
       ScanInfo : ^ScanInfoPtr;
       UserNum  : Word;
   BEGIN
      IF RWS_GetYesNo('Permanently delete this user''s ReneWave user record?',FALSE) THEN IF FileSize(UsersRw) > 1 THEN
         BEGIN
            Seek(UsersRw,CurrUser);
            IF CurrUser < (FileSize(UsersRw)-1) THEN
               FOR UserNum := CurrUser TO FileSize(UsersRw)-2 DO
                  BEGIN
                     ReadUsersRW(UserNum+1);
                     WriteUsersRW(UserNum);
                  END;
            Truncate(UsersRW);
            Reset(UsersRW);
            IF CurrUser > 0 THEN Dec(CurrUser) ELSE CurrUser := FileSize(UsersRW)-1;
            DrawUserEditor;

            IF FExists(SRW.RwMainDir+'SCANINFO.RW') THEN
               BEGIN
                  GetMem(ScanInfo,4096);
                  Assign(ScanFile,SRW.RwMainDir+'SCANINFO.RW');
                  Reset(ScanFile,4096);
                  IF CurrUser < FileSize(ScanFile) THEN
                     BEGIN
                        Seek(ScanFile,CurrUser);
                        IF CurrUser < (FileSize(ScanFile)-1) THEN
                           FOR UserNum := CurrUser TO FileSize(ScanFile)-2 DO
                              BEGIN
                                 Seek(ScanFile,UserNum+1);
                                 BlockRead(ScanFile,ScanInfo^,1);
                                 Seek(ScanFile,UserNum);
                                 BlockWrite(ScanFile,ScanInfo^,1);
                              END;
                        Truncate(ScanFile);
                     END;
                  Close(ScanFile);
                  FreeMem(ScanInfo,4096);
               END;
         END;
   END;

   PROCEDURE InsertUser;
   VAR SearchName:String;
   BEGIN
      ReadScreen(TempScreen2^);
      MakeBox('Enter user name (alias or real)',21,14,60,16,TRUE);
      SearchName := '';
      GetInput(SearchName,'',Standard,36,23,15,0,TRUE);

      MsRg_UserIdxOpen;
      i := MsRg_UserIdxSearch(SearchName);
      MsRg_UserIdxRead(i);
      MsRg_UserIdxClose;

      IF (i < 0)
         THEN UserError('User not found in USERS.IDX')
         ELSE BEGIN
               MsRg_UserFileRead(i);
               CurrUser := FileSize(UsersRW);
               NullUsersRW;
               URW.Alias := MsRg_User.Name;
               URW.RealName := MsRg_User.RealName;
               WriteUsersRW(CurrUser);
               DrawUserEditor;
            END;

      WriteScreen(TempScreen2^);
      DrawUserEditor;
   END;

   PROCEDURE SearchUser;
   VAR i:LongInt; SearchName:String;
   BEGIN
      ReadScreen(TempScreen2^);
      MakeBox('Enter user''s name or alias',21,14,60,16,TRUE);
      SearchName := '';
      GetInput(SearchName,'',Standard,36,23,15,0,TRUE);
      FoundUser := FALSE;
      FOR i := 0 TO FileSize(UsersRW)-1 DO
         BEGIN
            ReadUsersRW(I);
            IF (SearchName = UpcaseStr(URW.Alias)) OR
               (SearchName = UpcaseStr(URW.Realname)) THEN
               BEGIN
                  CurrUser := I;
                  FoundUser := TRUE;
               END;
         END;
      IF NOT (FoundUser) THEN UserError('|12A user by that name was not found.');
      WriteScreen(TempScreen2^);
      DrawUserEditor;
   END;

   PROCEDURE EditUser;
   VAR s:String;
   BEGIN
      REPEAT
         SetCursor(cmOff);
         Menu_GetChoice(UserMenu,UserChoice);
         CASE UserChoice OF
             1 : BEGIN
                    WITH URW DO IF RwNukeEmail IN RwFlags
                       THEN RwFlags := RwFlags - [RwNukeEmail]
                       ELSE RwFlags := RwFlags + [RwNukeEmail];
                    DrawChoice(1,YesNoBoolean(RwNukeEmail IN URW.RwFlags),Len1);
                 END;
             2 : BEGIN
                    WITH URW DO IF RwHotkeys IN BWaveFlags
                       THEN BWaveFlags := BWaveFlags - [RwHotkeys]
                       ELSE BWaveFlags := BWaveFlags + [RwHotkeys];
                    DrawChoice(2,YesNoBoolean(RwHotkeys IN URW.BWaveFlags),Len1);
                 END;
             3 : BEGIN
                    WITH URW DO IF RwXpert IN BWaveFlags
                       THEN BWaveFlags := BWaveFlags - [RwXpert]
                       ELSE BWaveFlags := BWaveFlags + [RwXpert];
                    DrawChoice(3,YesNoBoolean(RwXPert IN URW.BWaveFlags),Len1);
                 END;
             4 : BEGIN
                    WITH URW DO IF RwNotMyMail IN BWaveFlags
                       THEN BWaveFlags := BWaveFlags - [RwNotMyMail]
                       ELSE BWaveFlags := BWaveFlags + [RwNotMyMail];
                    DrawChoice(4,YesNoBoolean(NOT (RwNotMyMail IN URW.BWaveFlags)),Len1);
                 END;
             5 : BEGIN
                    WITH URW DO IF RwNumericPkt IN BWaveFlags
                       THEN BWaveFlags := BWaveFlags - [RwNumericPkt]
                       ELSE BWaveFlags := BWaveFlags + [RwNumericPkt];
                    DrawChoice(5,YesNoBoolean(RwNumericPkt IN URW.BWaveFlags),Len1);
                 END;
             6 : BEGIN
                    WITH URW DO IF RwFileList IN BWaveFlags
                       THEN BWaveFlags := BWaveFlags - [RwFileLIst]
                       ELSE BWaveFlags := BWaveFlags + [RwFileList];
                    DrawChoice(6,YesNoBoolean(RwFileList IN URW.BWaveFlags),Len1);
                 END;
             7 : BEGIN
                    i := RWS_SelectProt;
                    IF (i >= 1) AND (i <= 10) THEN URW.RwProtocol := SRW.RwProtocols[i].Letter;
                    i := RWS_ProtSearch(URW.RwProtocol);
                    DrawChoice(7,'('+SRW.RwProtocols[i].Letter+') '+SRW.RwProtocols[i].Desc,Len1);
                 END;
             8 : BEGIN
                    DrawChoice(8,MsRg_General.FileArcInfo[MsRg_User.DefArcType].Ext,Len1);
                 END;
             9 : BEGIN
                    GetInput(URW.RwPass,URW.RwPass,Standard,20,EditCol2,12,0,TRUE);
                    DrawChoice(9,URW.RwPass,Len2);
                 END;
            10 : BEGIN
                    IF URW.PassUsage < 3 THEN Inc(URW.PassUsage) ELSE URW.PassUsage := 0;
                    CASE URW.PassUsage OF
                       1 : DrawChoice(10,'Door',Len2);
                       2 : DrawChoice(10,'Reader',Len2);
                       3 : DrawChoice(10,'Door/Reader',Len2);
                       ELSE DrawChoice(10,'<disabled>',Len2);
                    END;
                 END;
            11 : BEGIN
                    DrawChoice(11,'',Len1);
                    GetInput(s,StrFunc(URW.MsgsLimit),Number,4,EditCol2,14,0,TRUE);
                    IF ValFunc(s) >= 0 THEN URW.MsgsLimit := ValFunc(s);
                    IF URW.MsgsLimit = 0
                       THEN DrawChoice(11,'<disabled>',Len1)
                       ELSE DrawChoice(11,StrFunc(URW.MsgsLimit),Len1);
                 END;
            12 : BEGIN
                    GetInput(s,StrFunc(URW.PktNumber),Number,3,EditCol2,15,0,TRUE);
                    IF ValFunc(s) >= 0 THEN URW.PktNumber := ValFunc(s);
                    DrawChoice(12,StrFunc(URW.PktNumber),Len2);
                 END;
            13 : BEGIN
                    IF (RwPacketQwk IN URW.RwFlags)
                       THEN URW.RwFlags := URW.RwFlags-[RwPacketQwk]
                       ELSE URW.RwFlags := URW.RwFlags+[RwPacketQwk];
                    IF (RwPacketQwk IN URW.RwFlags)
                       THEN DrawChoice(13,'QWK',Len2)
                       ELSE DrawChoice(13,'Blue Wave',Len2);
                 END;
         END;
      UNTIL (UserChoice = -1);
   END;

   PROCEDURE Init;
   BEGIN
      LoadError := FALSE;
      IF (FileSize(UsersRW) = 0)
         THEN UserError('No users currently exist - aborting')
         ELSE IF NOT FExists(SRW.RgMainDir+'RENEGADE.DAT')
            THEN UserError('Unable to open '+SRW.RGMainDir+'RENEGADE.DAT - aborting')
            ELSE BEGIN
                  MsRg_CfgPath := SRW.RgMainDir;
                  MsRg_GeneralRead;
                  IF FExists(MsRg_General.DataPath+'USERS.DAT')
                     THEN MsRg_UserFileOpen
                     ELSE UserError('|12Unable to locate USERS.DAT - please check your paths');
               END;
   END;

BEGIN
   Init;
   IF LoadError THEN Exit;

   New(TempScreen2);
   CurrUser := 0;
   ReadUsersRW(CurrUser);
   Init_UserEditor;
   Menu_DrawMenu(UserMenu);
   Menu_ClearMenu(UserMenu);
   Menu_DrawItems(UserMenu);
   DrawUserEditor;
   REPEAT
      Menu_EraseStatus(UserMenu);
      Menu_SetStatus(UserMenu,' '+#26#27+'=Next/Previous  [ENTER]=Edit  [INS]=Insert  [DEL]=Delete  [ALT-S]=Search');
      ch := Upcase(ReadKey);
      CASE Ch OF
         #13 : BEGIN
                  UserMenu^.ItemCurrent := 1;
                  EditUser;
                  WriteUsersRW(CurrUser);
                  Menu_DrawMenu(UserMenu);
                  Menu_ClearMenu(UserMenu);
                  Menu_DrawItems(UserMenu);
                  DrawUserEditor;
               END;
          #0 : CASE ReadKey OF
                  #82 : InsertUser;
                  #83 : DeleteUser;
                  #31 : SearchUser;
                  #75 : BEGIN
                           IF CurrUser > 0 THEN Dec(CurrUser) ELSE CurrUser := FileSize(UsersRW)-1;
                           DrawUserEditor;
                        END;
                  #77 : BEGIN
                           IF CurrUser < FileSize(UsersRW)-1 THEN Inc(CurrUser) ELSE CurrUser := 0;
                           DrawUserEditor;
                        END;
               END;
      END;
   UNTIL (ch = #27) OR (ch = 'Q');
   Dispose(TempScreen2);
   Menu_DeInit(UserMenu);
   MsRg_USerFileClose;
END;


PROCEDURE EditResultCodes;
VAR RwMenu:PMenuType; Choice:Integer;

   PROCEDURE DrawChoice(MChoice:Integer; Str:String; Len:Byte);
   BEGIN
      IF MChoice < 7
         THEN GotoXY(RwMenu^.ItemData^[MChoice].XPos+25,RwMenu^.ItemData^[MChoice].YPos)
         ELSE GotoXY(RwMenu^.ItemData^[MChoice].XPos+23,RwMenu^.ItemData^[MChoice].YPos);
      TextAttr := 27;
      Write(PadRight(Str,' ',Len));
   END;

   PROCEDURE EditResultNormal;
   CONST MenuItems=2; MenuCol1=3; VAR TempS:String;
   BEGIN
      RWS_ReadMenuDesc(280,10);
      Menu_Init(RwMenu,2,10,77,15,1,25,MenuItems,TRUE,'Result Codes Editor');
      Menu_AddItem(RwMenu,1,190,' ',FALSE,0,2,0,0,MenuCol1,12,0,1,MenuDesc^[1].Desc,MenuDesc^[1].Status);
      Menu_AddItem(RwMenu,2,191,' ',FALSE,1,0,0,0,MenuCol1,13,0,1,MenuDesc^[2].Desc,MenuDesc^[2].Status);
      Menu_ClearMenu(RwMenu);
      Menu_DrawMenu(RwMenu);
      Menu_DrawItems(RwMenu);

      IF SRW.RwProtocols[CurrProt].ResultT THEN DrawChoice(1,'Transfer OK',20) ELSE DrawChoice(1,'Transfer FAILED',20);
      DrawChoice(2,StrFunc(SRW.RwProtocols[CurrProt].ErrLev),20);

      REPEAT
         SetCursor(cmOff);
         Menu_GetChoice(RwMenu,Choice);
         CASE Choice OF
            1 : BEGIN
                   SRW.RwProtocols[CurrProt].ResultT := SRW.RwProtocols[CurrProt].ResultT XOR TRUE;
                   IF SRW.RwProtocols[CurrProt].ResultT
                      THEN DrawChoice(1,'Transfer OK',40)
                      ELSE DrawChoice(1,'Transfer FAILED',40);
                END;
            2 : BEGIN
                   GetInput(TempS,StrFunc(SRW.RwProtocols[CurrProt].ErrLev),Number,3,MenuCol1+25,13,0,TRUE);
                   IF ValFunc(TempS) > 0 THEN SRW.RwProtocols[CurrProt].ErrLev := ValFunc(TempS);
                   DrawChoice(2,StrFunc(SRW.RwProtocols[CurrProt].ErrLev),20);
                END;
         END;
      UNTIL (Choice = -1);
      Menu_DeInit(RwMenu);
   END;

   PROCEDURE EditResultBatch;
   CONST MenuItems=9; MenuCol1=3; MenuCol2=38;
   BEGIN
      RWS_ReadMenuDesc(270,10);
      Menu_Init(RwMenu,2,10,77,20,1,25,MenuItems,TRUE,'Result Codes Editor');
      Menu_AddItem(RwMenu,1,192,' ',FALSE,0,2,0,0,MenuCol1,12,0,1,MenuDesc^[1].Desc,MenuDesc^[1].Status);
      Menu_AddItem(RwMenu,2,193,' ',FALSE,1,3,0,0,MenuCol1,13,0,1,MenuDesc^[2].Desc,MenuDesc^[2].Status);
      Menu_AddItem(RwMenu,3,190,' ',FALSE,2,4,0,0,MenuCol1,14,0,1,MenuDesc^[3].Desc,MenuDesc^[3].Status);
      Menu_AddItem(RwMenu,4,-1 ,' ',FALSE,3,5,0,7,MenuCol1,16,0,1,MenuDesc^[4].Desc,MenuDesc^[4].Status);
      Menu_AddItem(RwMenu,5,-1 ,' ',FALSE,4,6,0,8,MenuCol1,17,0,1,MenuDesc^[5].Desc,MenuDesc^[5].Status);
      Menu_AddItem(RwMenu,6,-1 ,' ',FALSE,5,0,0,9,MenuCol1,18,0,1,MenuDesc^[6].Desc,MenuDesc^[6].Status);
      Menu_AddItem(RwMenu,7,-1 ,' ',FALSE,0,8,4,0,MenuCol2,16,0,1,MenuDesc^[7].Desc,MenuDesc^[7].Status);
      Menu_AddItem(RwMenu,8,-1 ,' ',FALSE,7,9,5,0,MenuCol2,17,0,1,MenuDesc^[8].Desc,MenuDesc^[8].Status);
      Menu_AddItem(RwMenu,9,-1 ,' ',FALSE,8,0,6,0,MenuCol2,18,0,1,MenuDesc^[9].Desc,MenuDesc^[9].Status);
      Menu_ClearMenu(RwMenu);
      Menu_DrawMenu(RwMenu);
      Menu_DrawItems(RwMenu);

      DrawChoice(1,SRW.RwProtocols[CurrProt].LogFile,40);
      DrawChoice(2,SRW.RwProtocols[CurrProt].EnvCmd,40);
      IF SRW.RwProtocols[CurrProt].ResultT THEN DrawChoice(3,'Transfer OK',40) ELSE DrawChoice(3,'Transfer FAILED',40);
      DrawChoice(4,'"'+SRW.RwProtocols[CurrProt].ResultD[1]+'"',9);
      DrawChoice(5,'"'+SRW.RwProtocols[CurrProt].ResultD[2]+'"',9);
      DrawChoice(6,'"'+SRW.RwProtocols[CurrProt].ResultD[3]+'"',9);
      DrawChoice(7,'"'+SRW.RwProtocols[CurrProt].ResultU[1]+'"',9);
      DrawChoice(8,'"'+SRW.RwProtocols[CurrProt].ResultU[2]+'"',9);
      DrawChoice(9,'"'+SRW.RwProtocols[CurrProt].ResultU[3]+'"',9);

      REPEAT
         SetCursor(cmOff);
         Menu_GetChoice(RwMenu,Choice);
         CASE Choice OF
            1 : BEGIN
                   GetInput(SRW.RwProtocols[CurrProt].LogFile,
                            SRW.RwProtocols[CurrProt].LogFile,
                            Filepath,40,MenuCol1+25,12,0,TRUE);
                   DrawChoice(1,SRW.RwProtocols[CurrProt].LogFile,40);
                END;
            2 : BEGIN
                   GetInput(SRW.RwProtocols[CurrProt].EnvCmd,
                            SRW.RwProtocols[CurrProt].EnvCmd,
                            Standard,40,MenuCol1+25,13,0,TRUE);
                   DrawChoice(2,SRW.RwProtocols[CurrProt].EnvCmd,40);
                END;
            3 : BEGIN
                   SRW.RwProtocols[CurrProt].ResultT := SRW.RwProtocols[CurrProt].ResultT XOR TRUE;
                   IF SRW.RwProtocols[CurrProt].ResultT
                      THEN DrawChoice(3,'Transfer OK',40)
                      ELSE DrawChoice(3,'Transfer FAILED',40);
                END;
            4 : BEGIN
                   DrawChoice(4,SRW.RwProtocols[CurrProt].ResultD[1],9);
                   GetInput(SRW.RwProtocols[CurrProt].ResultD[1],
                            SRW.RwProtocols[CurrProt].ResultD[1],
                            HighBit,5,MenuCol1+25,16,0,FALSE);
                   DrawChoice(4,'"'+SRW.RwProtocols[CurrProt].ResultD[1]+'"',9);
                END;
            5 : BEGIN
                   DrawChoice(5,SRW.RwProtocols[CurrProt].ResultD[2],9);
                   GetInput(SRW.RwProtocols[CurrProt].ResultD[2],
                            SRW.RwProtocols[CurrProt].ResultD[1],
                            HighBit,5,MenuCol1+25,17,0,FALSE);
                   DrawChoice(5,'"'+SRW.RwProtocols[CurrProt].ResultD[2]+'"',9);
                END;
            6 : BEGIN
                   DrawChoice(6,SRW.RwProtocols[CurrProt].ResultD[3],9);
                   GetInput(SRW.RwProtocols[CurrProt].ResultD[3],
                            SRW.RwProtocols[CurrProt].ResultD[3],
                            HighBit,5,MenuCol1+25,18,0,FALSE);
                   DrawChoice(6,'"'+SRW.RwProtocols[CurrProt].ResultD[3]+'"',9);
                END;
            7 : BEGIN
                   DrawChoice(7,SRW.RwProtocols[CurrProt].ResultU[1],9);
                   GetInput(SRW.RwProtocols[CurrProt].ResultU[1],
                            SRW.RwProtocols[CurrProt].ResultU[1],
                            HighBit,5,MenuCol2+23,16,0,FALSE);
                   DrawChoice(7,'"'+SRW.RwProtocols[CurrProt].ResultU[1]+'"',9);
                END;
            8 : BEGIN
                   DrawChoice(8,SRW.RwProtocols[CurrProt].ResultU[2],9);
                   GetInput(SRW.RwProtocols[CurrProt].ResultU[2],
                            SRW.RwProtocols[CurrProt].ResultU[2],
                            HighBit,5,MenuCol2+23,17,0,FALSE);
                   DrawChoice(8,'"'+SRW.RwProtocols[CurrProt].ResultU[2]+'"',9);
                END;
            9 : BEGIN
                   DrawChoice(9,SRW.RwProtocols[CurrProt].ResultU[3],9);
                   GetInput(SRW.RwProtocols[CurrProt].ResultU[3],
                            SRW.RwProtocols[CurrProt].ResultU[3],HighBit,
                            5,MenuCol2+23,18,0,FALSE);
                   DrawChoice(9,'"'+SRW.RwProtocols[CurrProt].ResultU[3]+'"',9);
                END;
         END;
      UNTIL (Choice = -1);
      Menu_DeInit(RwMenu);
   END;

BEGIN
  IF SRW.RwProtocols[CurrProt].Batch
     THEN EditResultBatch
     ELSE EditResultNormal;
END;

PROCEDURE Handle_ProtocolEditor;
CONST MenuCol    = 3;
      Len        = 65;
VAR   s          : String;
      i          : LongInt;
      Choice     : Integer;
      ch         : Char;
      RwMenu     : PMenuType;

   PROCEDURE Init_ProtEditor;
   CONST MenuItems = 8;
   BEGIN
      RWS_ReadMenuDesc(250,MenuItems);

      Menu_Init(RwMenu,2,9,78,20,1,25,MenuItems,TRUE,'Protocol Editor');
      Menu_AddItem(RwMenu,1,180,' ',FALSE,0,2,0,0,MenuCol,11,0,1,MenuDesc^[1].Desc,MenuDesc^[1].Status);
      Menu_AddItem(RwMenu,2,181,' ',FALSE,1,3,0,0,MenuCol,12,0,1,MenuDesc^[2].Desc,MenuDesc^[2].Status);
      Menu_AddItem(RwMenu,3,182,' ',FALSE,2,4,0,0,MenuCol,13,0,1,MenuDesc^[3].Desc,MenuDesc^[3].Status);
      Menu_AddItem(RwMenu,4,186,' ',FALSE,3,5,0,0,MenuCol,14,0,1,MenuDesc^[4].Desc,MenuDesc^[4].Status);
      Menu_AddItem(RwMenu,5,183,' ',FALSE,4,6,0,0,MenuCol,15,0,1,MenuDesc^[5].Desc,MenuDesc^[5].Status);
      Menu_AddItem(RwMenu,6,184,' ',FALSE,5,7,0,0,MenuCol,16,0,1,MenuDesc^[6].Desc,MenuDesc^[6].Status);
      Menu_AddItem(RwMenu,7,185,' ',FALSE,6,8,0,0,MenuCol,17,0,1,MenuDesc^[7].Desc,MenuDesc^[7].Status);
      Menu_AddItem(RwMenu,8,-1 ,' ',FALSE,7,0,0,0,MenuCol,19,0,1,MenuDesc^[8].Desc,MenuDesc^[8].Status);
   END;

   PROCEDURE DrawChoice(MChoice:Integer; Str:String; Len:Byte);
   BEGIN
      WITH RwMenu^.ItemData^[MChoice] DO GotoXY(MenuCol+1+Length(Desc),YPos);
      TextAttr := 27;
      Write(PadRight(Str,' ',Len));
   END;

   PROCEDURE DrawProtEditor;
   BEGIN
      WriteColorFast(3,18,'`19'+RepChar('',75));
      DrawChoice(1,YesNoBoolean(SRW.RwProtocols[CurrProt].Active),Len);
      DrawChoice(2,SRW.RwProtocols[CurrProt].Letter,Len);
      DrawChoice(3,SRW.RwProtocols[CurrProt].Desc,Len);
      DrawChoice(4,RWS_ProtStr(SRW.RwProtocols[CurrProt].IntProt),Len);

      IF SRW.RwProtocols[CurrProt].IntProt = Nothing
         THEN BEGIN
               DrawChoice(5,SRW.RwProtocols[CurrProt].Send,Len);
               DrawChoice(6,SRW.RwProtocols[CurrProt].Recv,Len);
               DrawChoice(7,YesNoBoolean(SRW.RwProtocols[CurrProt].Batch),Len);
               RwMenu^.ItemData^[4].LinkDown := 5;
               RwMenu^.ItemNum := 8;
            END
         ELSE BEGIN
               DrawChoice(5,'',Len);
               DrawChoice(6,'',Len);
               DrawChoice(7,'',Len);
               RwMenu^.ItemData^[4].LinkDown := 0;
               RwMenu^.ItemNum := 4;
            END;
   END;

   FUNCTION DeleteProt:Boolean;
   VAR i:Byte;
   BEGIN
      IF RWS_GetYesNo(' Delete this protocol? ',FALSE)
         THEN BEGIN
               FillChar(SRW.RwProtocols[CurrProt],SizeOf(SRW.RwProtocols[CurrProt]),0);
               DeleteProt := TRUE;
            END
         ELSE DeleteProt := FALSE;
   END;

   PROCEDURE InsertProt;
   VAR i:Byte;
   BEGIN
      FOR i := 1 TO 10 DO
         IF SRW.RwProtocols[i].Letter = #0 THEN
            BEGIN
               CurrProt := i;
               FillChar(SRW.RwProtocols[CurrProt],SizeOf(SRW.RwProtocols[CurrProt]),0);
               SRW.RwProtocols[CurrProt].Letter     := '-';
               SRW.RwProtocols[CurrProt].Desc       := 'New Protocol';
               SRW.RwProtocols[CurrProt].LogFile    := 'DSZ%N.LOG';
               SRW.RwProtocols[CurrProt].EnvCmd     := 'SET DSZLOG=DSZ%N.LOG';
               SRW.RwProtocols[CurrProt].Resultt    := TRUE;
               Exit;
            END;
      RWS_DispErrorMsg('Maximum of 10 protocols has been reached!');
   END;

   FUNCTION PickProt:Byte;
   CONST NumProts   = 9;
   VAR   ProtMenu   : PMenuType;
         ProtChoice : Integer;

        PROCEDURE InitProt;
        BEGIN
           Menu_Init(ProtMenu,13,10,66,17,1,25,NumProts,TRUE,'');
           Menu_AddItem(ProtMenu,1,-1,' ',FALSE,0,2,0,0,14,11,0,1,' External Protocol Driver                           ','');

           Menu_AddItem(ProtMenu,2,-1,' ',FALSE,1,3,0,6,14,13,0,1,' Internal Xmodem          ','');
           Menu_AddItem(ProtMenu,3,-1,' ',FALSE,2,4,0,7,14,14,0,1,' Internal Xmodem-1K       ','');
           Menu_AddItem(ProtMenu,4,-1,' ',FALSE,3,5,0,8,14,15,0,1,' Internal Xmodem-1K-G     ','');
           Menu_AddItem(ProtMenu,5,-1,' ',FALSE,4,6,0,9,14,16,0,1,' Internal Ymodem          ','');

           Menu_AddItem(ProtMenu,6,-1,' ',FALSE,5,7,2,0,40,13,0,1,' Internal Ymodem-1K       ','');
           Menu_AddItem(ProtMenu,7,-1,' ',FALSE,6,8,3,0,40,14,0,1,' Internal Ymodem-G        ','');
           Menu_AddItem(ProtMenu,8,-1,' ',FALSE,7,9,4,0,40,15,0,1,' Internal Zmodem          ','');
           Menu_AddItem(ProtMenu,9,-1,' ',FALSE,8,0,5,0,40,16,0,1,' Internal ZedZap          ','');
        END;

   BEGIN
      InitProt;
      Menu_ClearMenu(ProtMenu);
      Menu_DrawMenu(ProtMenu);
      Menu_DrawItems(ProtMenu);
      WriteColorFast(14,12,'`19');
      SetCursor(cmOff);
      Menu_GetChoice(ProtMenu,ProtChoice);
      Menu_DeInit(ProtMenu);
      IF ProtChoice < 1 THEN PickProt := 255 ELSE PickProt := ProtChoice-1;
   END;

   PROCEDURE EditProt;
   VAR i:Byte;
   BEGIN
      REPEAT
      Menu_EraseStatus(RwMenu);
      SetCursor(cmOff);
      Menu_GetChoice(RwMenu,Choice);
      CASE Choice OF
          1 : BEGIN
                 SRW.RwProtocols[CurrProt].Active := SRW.RwProtocols[CurrProt].Active XOR True;
                 DrawChoice(1,YesNoBoolean(SRW.RwProtocols[CurrProt].Active),Len);
              END;
          2 : WITH SRW.RwProtocols[CurrProt] DO
                 BEGIN
                    GetInput(s,Letter,Alpha,1,12,12,0,TRUE);
                    IF (s[1] IN ['A'..'Z'])
                       THEN Letter := s[1]
                       ELSE RWS_DispErrorMsg('You must enter a valid letter (A-Z) for this protocol!');
                    DrawChoice(2,Letter,Len);
                 END;
          3 : WITH SRW.RwProtocols[CurrProt] DO
                 BEGIN
                    GetInput(Desc,Desc,HighBit,35,12,13,0,FALSE);
                    DrawChoice(3,Desc,Len);
                 END;
          4 : WITH SRW.RwProtocols[CurrProt] DO
                 BEGIN
                    i := PickProt;
                    IF i <= 8 THEN IntProt := RwIntProts(i);
                    DrawProtEditor;
                 END;
          5 : BEGIN
                 GetInput(SRW.RwProtocols[CurrProt].Send,SRW.RwProtocols[CurrProt].Send,HighBit,75,12,15,65,FALSE);
                 DrawChoice(5,SRW.RwProtocols[CurrProt].Send,Len);
              END;
          6 : BEGIN
                 GetInput(SRW.RwProtocols[CurrProt].Recv,SRW.RwProtocols[CurrProt].Recv,HighBit,75,12,16,65,FALSE);
                 DrawChoice(6,SRW.RwProtocols[CurrProt].Recv,Len);
              END;
          7 : BEGIN
                 SRW.RwProtocols[CurrProt].Batch := SRW.RwProtocols[CurrProt].Batch XOR TRUE;
                 DrawChoice(7,YesNoBoolean(SRW.RwProtocols[CurrProt].Batch),Len);
              END;
          8 : EditResultCodes;
      END;
      UNTIL (Choice = -1);
      RwMenu^.ItemData^[4].LinkDown := 5;
      RwMenu^.ItemNum := 8;
   END;

   PROCEDURE ViewProt;
   BEGIN
      REPEAT
         Menu_EraseStatus(RwMenu);
         Menu_SetStatus(RwMenu,' '+#26#27+'=Next/Previous  [ENTER]=Edit  [INS]=Insert  [DEL]=Delete  [ALT-B]=Browse');
         ch := Upcase(ReadKey);
         CASE Ch OF
            #13 : BEGIN
                     RwMenu^.ItemCurrent := 1;
                     EditProt;
                     Menu_ClearMenu(RwMenu);
                     Menu_DrawMenu(RwMenu);
                     Menu_DrawItems(RwMenu);
                     DrawProtEditor;
                  END;
             #0 : BEGIN
                     CASE ReadKey OF
                        #82 : InsertProt;
                        #83 : IF DeleteProt THEN BEGIN
                                 CurrProt := RWS_SelectProt;
                                 IF (CurrProt <= 0) OR (CurrProt > 10) THEN Exit;
                              END;
                        #75 : IF CurrProt > 1 THEN BEGIN
                                 Dec(CurrProt);
                                 IF NOT (SRW.RwProtocols[CurrProt].Letter IN ['A'..'Z','-']) THEN Inc(CurrProt);
                              END;
                        #77 : IF CurrProt < 10 THEN BEGIN
                                 Inc(CurrProt);
                                 IF NOT (SRW.RwProtocols[CurrProt].Letter IN ['A'..'Z','-']) THEN Dec(CurrProt);
                              END;
                        #48 : BEGIN
                                 i := RWS_SelectProt;
                                 IF (i >= 1) AND (i <= 10) THEN CurrProt := i;
                              END;
                     END;
                     DrawProtEditor;
                  END;
         END;
      UNTIL (ch = #27) OR (ch = 'Q');
   END;

BEGIN
   CurrProt := RWS_SelectProt;
   IF CurrProt = 0 THEN
      BEGIN
         IF RWS_GetYesNo(' No protocols currently exist - insert a new entry? ',TRUE)
            THEN BEGIN
                  FillChar(SRW.RwProtocols[CurrProt],SizeOf(SRW.RwProtocols[CurrProt]),0);
                  CurrProt := 1;
                  SRW.RwProtocols[CurrProt].Letter := '-';
                  SRW.RwProtocols[CurrProt].Desc := 'New Protocol';
               END
            ELSE Exit;
      END;

   IF (CurrProt >= 1) AND (CurrProt <= 10) THEN
      BEGIN
         Init_ProtEditor;
         Menu_ClearMenu(RwMenu);
         Menu_DrawMenu(RwMenu);
         Menu_DrawItems(RwMenu);
         DrawProtEditor;
         ViewProt;
         Menu_DeInit(RwMenu);
      END;
END;



END.
