{$O+}
UNIT RWSMAIN;

(* 

    ReneWave Setup Program - Main Unit

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

INTERFACE

USES CRT,              {CRT Unit that comes with TP6.0                  }
     DOS,              {DOS Unit that comes with TP6.0                  }
     MSTRINGS,
     MISC1,
     FASTW,
     MSOBJ,
     CURSOR,
     SCREENS,
     RECORDS,
     RWSGEN,
     MSBWGEN,
     RWHELP,           {ReneWave Help System Unit                       }
     RWSTRUCT;         {ReneWave Data Structures                        }


PROCEDURE ShowBackground;
PROCEDURE CreateSetupRW;
PROCEDURE OpenSetupRW;
PROCEDURE ReadSetupRW;
PROCEDURE WriteSetupRW;
PROCEDURE OpenUsersRW;
PROCEDURE ReadUsersRW(Rec:Integer);
PROCEDURE WriteUsersRW(Rec:Integer);
PROCEDURE NullUsersRW;
PROCEDURE ShowHelp(IdxNum:Word);
PROCEDURE CheckDir(Dir:String);

PROCEDURE RWS_ReadMenuDesc(Pos:LongInt; Num:Word);
FUNCTION  RWS_GetYesNo(s:String; DefaultYes:Boolean):Boolean;
PROCEDURE RWS_DispErrorBox(Lines,Width:Byte);
PROCEDURE RWS_DispErrorLine(LineNum:Byte; s:String);
PROCEDURE RWS_DispErrorGetContinue;
PROCEDURE RWS_DispErrorMsg(s:String);

FUNCTION  RWS_SelectProt:Byte;
FUNCTION  RWS_ProtSearch(Prot:Char):Byte;
FUNCTION  RWS_ProtStr(Prot:RwIntProts):String;


IMPLEMENTATION


VAR ErrorMenu : PMenuType;
    StartOfs  : Byte;


FUNCTION RWS_ProtStr(Prot:RwIntProts):String;
BEGIN
   CASE Prot OF
       Int_X    : RWS_ProtStr := 'Internal Xmodem';
       Int_X1K  : RWS_ProtStr := 'Internal Xmodem-1K';
       Int_X1KG : RWS_ProtStr := 'Internal Xmodem-1K-G';
       Int_Y    : RWS_ProtStr := 'Internal Ymodem';
       Int_Y1K  : RWS_ProtStr := 'Internal Ymodem-1K';
       Int_YG   : RWS_ProtStr := 'Internal Ymodem-G';
       Int_Z    : RWS_ProtStr := 'Internal Zmodem';
       Int_Zap  : RWS_ProtStr := 'Internal ZedZap (8k Zmodem)';
       ELSE       RWS_ProtStr := 'External';
   END;
END;


FUNCTION RWS_ProtSearch(Prot:Char):Byte;
VAR ProtNum:Byte;
BEGIN
   FOR ProtNum := 1 TO 10 DO
      IF SRW.RwProtocols[ProtNum].Letter = Prot THEN
         BEGIN
            RWS_ProtSearch := ProtNum;
            Exit;
         END;
   RWS_ProtSearch := 0;
END;


FUNCTION RWS_SelectProt:Byte;
TYPE tProtArray = Array[1..10] OF RECORD
        Info    : RwProtRec;
        Num     : Byte;
     END;
VAR  ProtMenu   : PMenuType;
     NumProts   : Byte;
     ProtArray  : ^tProtArray;
     ProtChoice : Integer;
     TempStr    : String[20];

    PROCEDURE InitProt;
    VAR i:Byte;
    BEGIN
       New(ProtArray);
       NumProts := 0;
       FOR i := 1 TO 10 DO IF SRW.RwProtocols[i].Letter <> #0 THEN
          BEGIN
             ProtArray^[NumProts+1].Info := SRW.RwProtocols[i];
             ProtArray^[NumProts+1].Num := i;
             Inc(NumProts);
          END;
       IF NumProts = 0 THEN Exit;

       Menu_Init(ProtMenu,19,7,59,10+NumProts,1,25,NumProts,TRUE,'');
       FOR i := 1 TO NumProts DO
          BEGIN
             IF ProtArray^[i].Info.Active
                THEN TempStr := '(Active)  '
                ELSE TempStr := '(Inactive)';
             Menu_AddItem(ProtMenu,i,-1,' ',FALSE,i-1,i+1,0,0,20,9+i,0,1,
                          ' '+ProtArray^[i].Info.Letter+
                          ' '+PadRight(ProtArray^[i].Info.Desc,' ',24)+
                          ' '+TempStr+' ','');
             IF i = NumProts THEN ProtMenu^.ItemData^[i].LinkDown := 0;
          END;
    END;

BEGIN
   InitProt;
   IF NumProts = 0 THEN
      BEGIN
         Dispose(ProtArray);
         RWS_SelectProt := 0;
         Exit;
      END;
   Menu_ClearMenu(ProtMenu);
   Menu_DrawMenu(ProtMenu);
   Menu_DrawItems(ProtMenu);
   WriteColorFast(20,8,'`B1 @ Protocol Name            Active?    ');
   WriteColorFast(20,9,'`19');
   SetCursor(cmOff);
   Menu_GetChoice(ProtMenu,ProtChoice);
   Dispose(ProtArray);
   Menu_DeInit(ProtMenu);
   IF ProtChoice < 1
      THEN RWS_SelectProt := 255
      ELSE RWS_SelectProt := ProtArray^[ProtChoice].Num;
END;


FUNCTION RWS_GetYesNo(s:String; DefaultYes:Boolean):Boolean;
VAR YesNoMenu : PMenuType;
    Choice    : Integer;
    StartOfs  : Byte;
BEGIN
   StartOfs := (79-Length(s)) DIV 2;
   Menu_Init(YesNoMenu,StartOfs-1,10,StartOfs+Length(s),15,1,25,2,TRUE,'');
   Menu_AddItem(YesNoMenu,1,-1,'Y',FALSE,0,2,0,0,StartOfs,13,2,1,PadCenter('Yes',' ',Length(s)),'');
   Menu_AddItem(YesNoMenu,2,-1,'N',FALSE,1,0,0,0,StartOfs,14,2,1,PadCenter('No ',' ',Length(s)),'');
   Menu_DrawMenu(YesNoMenu);
   Menu_ClearMenu(YesNoMenu);
   Menu_DrawItems(YesNoMenu);
   WriteColorFast(StartOfs,11,'`1A'+s);
   WriteColorFast(StartOfs,12,'`19'+RepChar('',Length(s)));
   IF DefaultYes THEN YesNoMenu^.ItemCurrent := 2;
   REPEAT
      SetCursor(cmOff);
      Menu_GetChoice(YesNoMenu,Choice);
   UNTIL (Choice = 1) OR (Choice = 2);
   Menu_DeInit(YesNoMenu);
   RWS_GetYesNo := Choice = 1;
END;


PROCEDURE RWS_DispErrorBox(Lines,Width:Byte);
BEGIN
   StartOfs := (79-Width) DIV 2;
   Menu_Init(ErrorMenu,StartOfs-1,10,StartOfs+Width,13+Lines,1,25,2,TRUE,'');
   Menu_AddItem(ErrorMenu,1,-1,'C',FALSE,0,2,0,0,StartOfs,12+Lines,2,1,PadCenter('Continue',' ',Width),'');
   Menu_DrawMenu(ErrorMenu);
   Menu_ClearMenu(ErrorMenu);
   Menu_DrawItems(ErrorMenu);
   WriteColorFast(StartOfs,11+Lines,'`19'+RepChar('',Width));
END;


PROCEDURE RWS_DispErrorLine(LineNum:Byte; s:String);
BEGIN
   WriteColorFast(StartOfs,10+LineNum,'`19'+s);
END;


PROCEDURE RWS_DispErrorGetContinue;
VAR Choice:Integer;
BEGIN
   SetCursor(cmOff);
   Menu_GetChoice(ErrorMenu,Choice);
   Menu_DeInit(ErrorMenu);
END;


PROCEDURE RWS_DispErrorMsg(s:String);
VAR ErrorMenu:PMenuType; Choice:Integer; StartOfs:Byte;
BEGIN
   StartOfs := (79-Length(s)) DIV 2;
   Menu_Init(ErrorMenu,StartOfs-1,10,StartOfs+Length(s),14,1,25,2,TRUE,'');
   Menu_AddItem(ErrorMenu,1,-1,'C',FALSE,0,2,0,0,StartOfs,13,2,1,PadCenter('Continue',' ',Length(s)),'');
   Menu_DrawMenu(ErrorMenu);
   Menu_ClearMenu(ErrorMenu);
   Menu_DrawItems(ErrorMenu);
   WriteColorFast(StartOfs,11,'`1C'+s);
   WriteColorFast(StartOfs,12,'`19'+RepChar('',Length(s)));
   SetCursor(cmOff);
   Menu_GetChoice(ErrorMenu,Choice);
   Menu_DeInit(ErrorMenu);
END;


PROCEDURE RWS_ReadMenuDesc(Pos:LongInt; Num:Word);
BEGIN
   Seek(ResourceFile,Pos-1);
   BlockRead(ResourceFile,MenuDesc^[1],Num);
END;


{$L RWBACK.OBJ}
PROCEDURE RWBACK; External;
PROCEDURE RWBACK_Width; External;
PROCEDURE RWBACK_Depth; External;
PROCEDURE RWBACK_Length; External;


PROCEDURE ShowBackground;
BEGIN
   MOVE(Pointer(@RWBACK)^,Ptr(VideoAddress,0)^,4000);
END;


PROCEDURE CreateSetupRW;
BEGIN
   Rewrite(SetupRW);
   FillChar(SRW,SizeOf(SRW),0);
   FillChar(SRW.LogOpts,SizeOf(SRW.LogOpts),TRUE);

   IF      GetEnv('RENEGADE') <> '' THEN SRW.RgMainDir := AddSlash(GetEnv('RENEGADE'))
   ELSE IF GetEnv('RG')       <> '' THEN SRW.RgMainDir := AddSlash(GetEnv('RG'))
   ELSE IF GetEnv('BBS')      <> '' THEN SRW.RgMainDir := AddSlash(GetEnv('BBS'))
   ELSE    SRW.RgMainDir := 'C:\RENEGADE\';

   SRW.RwMainDir         := GetCurrentDir;
   SRW.RwMenuDir         := SRW.RwMainDir+'MENU\';
   SRW.RwWorkDir         := SRW.RwMainDir+'WORK\';
   SRW.RwTextDir         := SRW.RwMainDir+'TEXT\';
   SRW.RwHelpDir         := SRW.RwMainDir+'HELP\';
   SRW.RwLangDir         := SRW.RwMainDir+'LANGUAGE\';
   SRW.RwScanDir         := SRW.RwMainDir+'PRESCAN\';
   SRW.LogFile           := SRW.RwMainDir+'RENEWAVE.LOG';
   SRW.LocalULDir        := 'C:\BLUEWAVE\UPLOAD\';
   SRW.LocalDLDir        := 'C:\BLUEWAVE\DOWNLOAD\';

   SRW.FilesList         := SRW.RwMainDir+'NEWFILES.LST';
   SRW.TearLine          := 'Renegade v05-11 Exp';
   SRW.BragLine          := TRUE;
   SRW.BBSID             := 'RENEWAVE';
   SRW.AttachACS         := 's20';
   SRW.ForwardACS        := 's20';
   SRW.FileReqACS        := 's20';
   SRW.TimeoutMinutes    := 5;
   SRW.RwCommType        := 0;
   SRW.ForceEmail        := TRUE;
   SRW.ForceNetmail      := TRUE;
   SRW.ForceOvrACS       := 's200';
   SRW.HangUpOnTimeout   := TRUE;
   SRW.NukeLocalRep      := TRUE;
   SRW.SwapType          := Disk;
   SRW.FREQLimit         := 10;
   SRW.MaxPWTries        := 5;
   SRW.MaxTotalMsgs      := 5000;
   SRW.MaxTotalBytes     := 1000000;
   SRW.MaxBaseMsgs       := 2000;
   SRW.MaxBaseBytes      := 500000;
   SRW.MaxDupes          := 1000;
   SRW.AllowGoodbye      := TRUE;
   SRW.ImportPointers    := FALSE;
   SRW.ACS_Crash         := 's255';
   SRW.ACS_FAttach       := 's255';
   SRW.ACS_KillSent      := '^';
   SRW.ACS_Hold          := '^';
   SRW.ACS_Imm           := 's255';
   SRW.ACS_FREQ          := 's255';
   SRW.ACS_Direct        := 's255';
   SRW.ACS_UpdREQ        := 's255';
   SRW.ACS_AllEmail      := '%';
   SRW.ACS_NetStatus     := '%';
   SRW.BBSZone           := 1;
   SRW.BBSNet            := 259;
   SRW.BBSNode           := 412;
   SRW.BBSPoint          := 0;

   SRW.NTypeEmail        := NameAlias;
   SRW.NTypeNetmail      := NameReal;
   SRW.AnyNameEmail      := 's255';
   SRW.AnyNameNetmail    := 's255';
   SRW.CreditsPublic     := 0;
   SRW.CreditsEmail      := 0;
   SRW.DefaultNetAttr    := [Private,Local,KillSent];

   SRW.DefaultHotkeys    := TRUE;
   SRW.DefaultExpert     := FALSE;
   SRW.DefaultGraphics   := TRUE;
   SRW.DefaultNotMyMail  := TRUE;
   SRW.DefaultNumeric    := TRUE;
   SRW.DefaultFileList   := TRUE;
   SRW.DefaultQWK        := FALSE;
   SRW.DefaultNukeEmail  := TRUE;
   SRW.DefaultMsgsLimit  := 0;
   SRW.DefaultArc        := 'ZIP';
   SRW.DefaultProt       := 'Z';

   SRW.FileListType     := 1;
   SRW.FileListHdr      := '';
   SRW.FileListFtr      := '';
   SRW.FileListAreaT    := TRUE;
   SRW.FileListGrandT   := TRUE;
   SRW.FileListCredits  := FALSE;
   SRW.FileListOffline  := TRUE;
   SRW.FileListDates    := TRUE;
   SRW.FileListUploader := FALSE;
   SRW.FileListOptional := TRUE;
   SRW.FileListMaxDays  := 21;

   SRW.InetActive       := FALSE;
   SRW.InetAcs          := 's20';
   SRW.InetAreaNum      := 'INET';
   SRW.InetAreaTag      := 'INTERNET_EMAIL';
   SRW.InetAreaDesc     := 'Internet Email';
   SRW.InetToField      := 'UUCP';
   SRW.InetGateZone     := 1;
   SRW.InetGateNet      := 12;
   SRW.InetGateNode     := 98;
   SRW.InetGatePoint    := 0;
   SRW.InetMsgAttr      := [MsPrivate,MsLocal,MsKillSent];
   SRW.InetUseTo        := TRUE;

   SRW.RwProtocols[1].Active     := TRUE;
   SRW.RwProtocols[1].LogFile    := 'DSZ%N.LOG';
   SRW.RwProtocols[1].EnvCmd     := 'SET DSZLOG=DSZ%N.LOG';
   SRW.RwProtocols[1].Letter     := 'Z';
   SRW.RwProtocols[1].Batch      := TRUE;
   SRW.RwProtocols[1].ResultU[1] := 'Z';
   SRW.RwProtocols[1].ResultD[1] := 'z';
   SRW.RwProtocols[1].ResultT    := TRUE;
   SRW.RwProtocols[1].Desc       := 'Zmodem';
   SRW.RwProtocols[1].Recv       := 'DSZ portx %C,%E ha cts restrict rz -m %F';
   SRW.RwProtocols[1].Send       := 'DSZ portx %C,%E ha cts sz -m %F';
   SRW.RwProtocols[1].IntProt    := Int_Z;

   SRW.RwProtocols[2].Active     := TRUE;
   SRW.RwProtocols[2].LogFile    := 'DSZ%N.LOG';
   SRW.RwProtocols[2].EnvCmd     := 'SET DSZLOG=DSZ%N.LOG';
   SRW.RwProtocols[2].Letter     := 'Y';
   SRW.RwProtocols[2].Batch      := TRUE;
   SRW.RwProtocols[2].ResultU[1] := 'R';
   SRW.RwProtocols[2].ResultD[1] := 'S';
   SRW.RwProtocols[2].ResultT    := TRUE;
   SRW.RwProtocols[2].Desc       := 'Ymodem';
   SRW.RwProtocols[2].Recv       := 'DSZ portx %C,%E ha cts rb -k %F';
   SRW.RwProtocols[2].Send       := 'DSZ portx %C,%E ha cts sb -k %F';
   SRW.RwProtocols[2].IntProt    := Int_Y1K;

   SRW.RwProtocols[3].Active     := TRUE;
   SRW.RwProtocols[3].LogFile    := 'DSZ%N.LOG';
   SRW.RwProtocols[3].EnvCmd     := 'SET DSZLOG=DSZ%N.LOG';
   SRW.RwProtocols[3].Letter     := 'G';
   SRW.RwProtocols[3].Batch      := TRUE;
   SRW.RwProtocols[3].ResultU[1] := 'R';
   SRW.RwProtocols[3].ResultD[1] := 'S';
   SRW.RwProtocols[3].REsultT    := TRUE;
   SRW.RwProtocols[3].Desc       := 'Ymodem-G';
   SRW.RwProtocols[3].Recv       := 'DSZ portx %C,%E ha cts restrict rb -g %F';
   SRW.RwProtocols[3].Send       := 'DSZ portx %C,%E ha cts sb -g %F';
   SRW.RwProtocols[3].IntProt    := Int_YG;

   SRW.RwProtocols[4].Active     := TRUE;
   SRW.RwProtocols[4].Letter     := 'X';
   SRW.RwProtocols[4].Batch      := FALSE;
   SRW.RwProtocols[4].ErrLev     := 0;
   SRW.RwProtocols[4].ResultT    := TRUE;
   SRW.RwProtocols[4].Desc       := 'Xmodem';
   SRW.RwProtocols[4].Recv       := 'DSZ portx %C,%E ha cts rc %F';
   SRW.RwProtocols[4].Send       := 'DSZ portx %C,%E ha cts sx %F';
   SRW.RwProtocols[4].IntProt    := Int_X;

   SRW.RwProtocols[5].Active     := TRUE;
   SRW.RwProtocols[5].LogFile    := 'DSZ%N.LOG';
   SRW.RwProtocols[5].EnvCmd     := 'SET DSZLOG=DSZ%N.LOG';
   SRW.RwProtocols[5].Letter     := 'A';
   SRW.RwProtocols[5].Batch      := TRUE;
   SRW.RwProtocols[5].ResultU[1] := 'Z';
   SRW.RwProtocols[5].ResultD[1] := 'z';
   SRW.RwProtocols[5].Resultt    := TRUE;
   SRW.RwProtocols[5].Desc       := 'ZedZap (8k Zmodem)';
   SRW.RwProtocols[5].Recv       := 'MSZ /c:%P,%A,%B /F:ON /rZAP %F';
   SRW.RwProtocols[5].Send       := 'MSZ /c:%P,%A,%B /F:ON /sZAP %F';
   SRW.RwProtocols[5].IntProt    := Int_Zap;

   SRW.RwVer := 200;

   Write(SetupRW,SRW);
   Seek(SetupRW,0);
END;


PROCEDURE OpenSetupRW;
BEGIN
   Assign(SetupRW,'SETUP.RW');
   {$I-} Reset(SetupRW); {$I+}
   IF IoResult <> 0 THEN CreateSetupRW;
END;


PROCEDURE ReadSetupRW;
BEGIN
   Seek(SetupRW,0);
   FillChar(SRW,SizeOf(SRW),0);
   Read(SetupRW,SRW);
END;


PROCEDURE WriteSetupRW;
BEGIN
   Seek(SetupRW,0);
   Write(SetupRW,SRW);
END;


PROCEDURE OpenUsersRW;
BEGIN
   Assign(UsersRW,'USERS.RW');
   {$I-} Reset(UsersRW); {$I+}
   IF IoResult <> 0 THEN ReWrite(UsersRW);
END;


PROCEDURE ReadUsersRW(Rec:Integer);
BEGIN
   Seek(UsersRW,Rec);
   Read(UsersRW,URW);
END;


PROCEDURE WriteUsersRW(Rec: Integer);
BEGIN
   Seek(UsersRW,Rec);
   Write(UsersRW,URW);
END;


PROCEDURE NullUsersRW;
VAR i:Byte;
BEGIN
   FillChar(URW,SizeOf(URW),0);
   URW.BWaveFlags := [RwHotkeys,RwGraphics,RwNotMyMail,RwFileList];
   URW.RwFlags    := [RwNukeEmail];
   { Implement support for defaults here }
   URW.RwProtocol := SRW.DefaultProt;
   URW.PktNumber := 0;
   FOR I := 1 TO 10 DO URW.Keywords[I] := '';
   FOR I := 1 TO 10 DO URW.Filters[I] := '';
   FOR I := 1 TO 3 DO URW.BundlMacros[I] := '';
END;


PROCEDURE CheckDir(Dir:String);
BEGIN
   IF (DirExists(Dir) OR (Dir = '')) THEN Exit;
   IF RWS_GetYesNo(' Directory does not exist, create? ',TRUE) THEN DirMake(Dir);
END;


PROCEDURE ShowHelp(IdxNum:Word);
BEGIN
   New(HelpScreen);
   ReadScreen(HelpScreen^);
   DoHelp(IdxNum);
   WriteScreen(HelpScreen^);
   Dispose(HelpScreen);
END;




END.
