PROGRAM RWSETUP;
{$R-,S-,D+,O+,F+,V-}

{$M 50000,0,600000 }

(* 

    RWSETUP - RENEWAVE Setup Program - For use ewith ReneWave v2.00+

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

USES RWSA,     RWS_GV,   RWSMAIN,  RWSGEN,   RECORDS,  RWSTRUCT,
     MSBWGEN,  CRT,      DOS,      MSTRINGS, MISC1,    CURSOR,
     FASTW,    MYSHARE,  SCREENS,  RWREG,    KEYINPUT,
     MSOBJ,    EXECSWAP;


FUNCTION RunDoor(CmdLine:String; RunCommand:Boolean; AltStr:String):Byte;
VAR Result  : Word;
    FPath   : PathStr;
    Params  : String;
    vScreen : ScreenType;

    FUNCTION RandomFilename : String;
    VAR TempStr : String; StrPos : Byte;
    BEGIN
       Randomize;
       TempStr := '';
       FOR StrPos := 1 TO 8 DO TempStr[StrPos] := Chr(Random(25) + 65);
       TempStr[0] := Chr(8);
       TempStr := TempStr + '.RWS';
       RandomFilename := TempStr;
    END;

    PROCEDURE RestoreInitialSettings;
    BEGIN
       IF Result = 0 THEN ClrScr;
       WriteScreen(vScreen);
       GotoXY(vScreen.CursX,vScreen.CursY);
    END;

    PROCEDURE PrepareForSwap;
    BEGIN
       ReadScreen(vScreen);
       vScreen.CursX := WhereX;
       vScreen.CursY := WhereY;
       Window(1,1,80,25);               { Expand window }
       TextAttr := 7;
       ClrScr;
       TextAttr := 11+(1*16);
       {...}
       IF AltStr = ''
          THEN Write(PadRight('Executing '+CmdLine,' ',80))
          ELSE Write(PadRight(altstr,' ',80));
    END;

    PROCEDURE ParseCmdLine;
    VAR i:Byte; FName:NameStr; FExt:ExtStr; FDir:DirStr;
    BEGIN
       i := Pos(' ',CmdLine);
       IF i > 0 THEN Params := Copy(CmdLine,i+1,Length(CmdLine)-i) ELSE Params := '';
       IF i > 0 THEN FPath := Copy(CmdLine,1,i-1) ELSE FPath := CmdLine;
       FSplit(FPath,FDir,FName,FExt);
       IF (FExt = '') OR NOT FExists(FPath) THEN
          BEGIN
             FPath := FSearch(FName+'.EXE',FDir+';'+GetEnv('PATH'));
             IF FPath = '' THEN FPath := FSearch(FName+'.COM',FDir+';'+GetEnv('PATH'));
             IF FPath = '' THEN FPath := FSearch(FName+'.BAT',FDir+';'+GetEnv('PATH'));
          END;
    END;

    {$IFDEF OS2}
    PROCEDURE DoSwap;
    BEGIN
       Exec(GetEnv('COMSPEC'),'/C '+FPath+' '+Params);
       Result := Dos.DosError;
    END;
    {$ELSE}
    PROCEDURE DoSwap;
    BEGIN
       UseEmsIfAvailable := (SRW.SwapType = EMS);
       IF (SRW.SwapType = None) OR NOT InitExecSwap(HeapPtr,RandomFileName)
          THEN BEGIN
             IF (SRW.SwapType = None)
                THEN WritePipe('|16|03Not swapping out of memory - swapping is disabled ... |07')
                ELSE WritePipe('|16|03Error: could not swap out of memory, attempting to execute anyway ... |07');

             { Run if swapping is set to NONE or if the swapping could not be }
             { configured properly. }

             SwapVectors;
             IF RunCommand { then execute command interpreter }
                 THEN Exec(GetEnv('COMSPEC'),'/C '+FPath+Params)
                 ELSE Exec(FPath,Params);
              SwapVectors;
              Result := DosError;
           END
        ELSE BEGIN
              WritePipe('|16|03Swapping '+StrFunc(BytesSwapped)+' bytes out of memory ... |07');
              SwapVectors;
              IF RunCommand
                 THEN Result := ExecWithSwap(GetEnv('COMSPEC'),'/C '+FPath+Params)
                 ELSE Result := ExecWithSwap(FPath,Params);
              ShutDownExecSwap;
              SwapVectors;
           END;
    END;
    {$ENDIF}

BEGIN
   PrepareForSwap;
   ParseCmdLine;
   DoSwap;
   RestoreInitialSettings;
   RunDoor := Result;
END;


PROCEDURE DosShell; FAR;
VAR TScreen:^ScreenType;
BEGIN
   New(TScreen);
   ReadScreen(TScreen^);
   SetCursor(cmOn);
   RunDoor(GetEnv('COMSPEC'),FALSE,'');
   SetCursor(cmOff);
   WriteScreen(TScreen^);
   Dispose(TScreen);
END;


PROCEDURE Handle_MainSetupMenu;
VAR ChoiceID : Integer;
    RWMenu   : PMenuType;

    PROCEDURE Init_MainSetupMenu;
    CONST MenuItems=12;
    BEGIN
       RWS_ReadMenuDesc(220,MenuItems);

       Menu_Init(RwMenu,37,7,78,22,1,25,MenuItems,TRUE,'RWSETUP main menu');
       Menu_AddItem(RwMenu, 1, 1,' ',FALSE, 0, 2,0,0,38, 9,0,1,MenuDesc^[ 1].Desc,MenuDesc^[ 1].Status);
       Menu_AddItem(RwMenu, 2, 2,' ',FALSE, 1, 3,0,0,38,10,0,1,MenuDesc^[ 2].Desc,MenuDesc^[ 2].Status);
       Menu_AddItem(RwMenu, 3, 3,' ',FALSE, 2, 4,0,0,38,11,0,1,MenuDesc^[ 3].Desc,MenuDesc^[ 3].Status);
       Menu_AddItem(RwMenu, 4, 4,' ',FALSE, 3, 5,0,0,38,12,0,1,MenuDesc^[ 4].Desc,MenuDesc^[ 4].Status);
       Menu_AddItem(RwMenu, 5, 5,' ',FALSE, 4, 6,0,0,38,13,0,1,MenuDesc^[ 5].Desc,MenuDesc^[ 5].Status);
       Menu_AddItem(RwMenu, 6, 6,' ',FALSE, 5, 7,0,0,38,14,0,1,MenuDesc^[ 6].Desc,MenuDesc^[ 6].Status);
       Menu_AddItem(RwMenu, 7, 7,' ',FALSE, 6, 8,0,0,38,15,0,1,MenuDesc^[ 7].Desc,MenuDesc^[ 7].Status);
       Menu_AddItem(RwMenu, 8, 8,' ',FALSE, 7, 9,0,0,38,16,0,1,MenuDesc^[ 8].Desc,MenuDesc^[ 8].Status);
       Menu_AddItem(RwMenu, 9, 9,' ',FALSE, 8,10,0,0,38,17,0,1,MenuDesc^[ 9].Desc,MenuDesc^[ 9].Status);
       Menu_AddItem(RwMenu,10,10,' ',FALSE, 9,11,0,0,38,18,0,1,MenuDesc^[10].Desc,MenuDesc^[10].Status);
       Menu_AddItem(RwMenu,11,11,' ',FALSE,10,12,0,0,38,19,0,1,MenuDesc^[11].Desc,MenuDesc^[11].Status);
       Menu_AddItem(RwMenu,12,-1,'Q',FALSE,11, 0,0,0,38,20,0,1,MenuDesc^[12].Desc,MenuDesc^[12].Status);

      MakeBox('Keys available/menus',3,7,32,16,TRUE);
      WritePipeXY(5, 9,'|17|11'#26#27#24#25'    |07Scroll bar');
      WritePipeXY(5,10,'|17|11HOME    |07Go to first item');
      WritePipeXY(5,11,'|17|11END     |07Go to last item');
      WritePipeXY(5,12,'|17|11ESC     |07Previous menu/exit');
      WritePipeXY(5,13,'|17|11F1      |07Help on item');
      WritePipeXY(5,14,'|17|11ALT-J   |07Shell to DOS');
   END;


BEGIN
   ClrScr;
   ShowBackground;
   Init_MainSetupMenu;
   Menu_DrawMenu(RwMenu);
   Menu_ClearMenu(RwMenu);
   Menu_DrawItems(RwMenu);
   HelpProc := ShowHelp;
   REPEAT
      SetCursor(cmOff);
      Menu_GetChoice(RwMenu,ChoiceID);
      CASE ChoiceID OF
         1 : Handle_GeneralSettings;
         2 : Handle_VariablesAndLimits;
         3 : Handle_SystemACSSettings;
         4 : Handle_LoggingOptions;
         5 : Handle_NetmailInformation;
         6 : Handle_BulletinsForReader;
         7 : Handle_FileRequest;
         8 : Handle_NewUserDefaults;
         9 : Handle_InternetConfig;
        10 : Handle_ProtocolEditor;
        11 : Handle_UserEditor;
      END;
   UNTIL (ChoiceID = 12) OR (ChoiceID = -1);
   Menu_DeInit(RwMenu);
END;


PROCEDURE Handle_RegisterMode;
VAR ChoiceID : Integer;
    RwMenu   : PMenuType;
    f        : File;
    TempS    : String;
    TempL    : LongInt;
    TempI    : Integer;

    PROCEDURE ReadRegInfo;
    BEGIN
       RWK_ReadKey(SRW.RwMainDir);
       IsRegistered := TRUE;
    END;

    PROCEDURE Init_RegisterMode;
    BEGIN
       RWS_ReadMenuDesc(240,10);

       Menu_Init(RwMenu,9,11,70,20,1,25,9,TRUE,'Registration Menu');
       Menu_AddItem(RwMenu,1,-1,'1',FALSE,0,2,0,0,10,13,0,1,MenuDesc^[1].Desc,MenuDesc^[1].Status);
       Menu_AddItem(RwMenu,2,-1,'2',FALSE,1,3,0,0,10,14,0,1,MenuDesc^[2].Desc,MenuDesc^[2].Status);
       Menu_AddItem(RwMenu,3,-1,'3',FALSE,2,4,0,0,10,15,0,1,MenuDesc^[3].Desc,MenuDesc^[3].Status);
       Menu_AddItem(RwMenu,4,-1,'4',FALSE,3,5,0,0,10,17,0,1,MenuDesc^[4].Desc,MenuDesc^[4].Status);
       Menu_AddItem(RwMenu,5,-1,'Q',FALSE,4,0,0,0,10,19,2,1,MenuDesc^[5].Desc,MenuDesc^[5].Status);
    END;

    PROCEDURE DrawStatus;
    BEGIN
       MakeBox('',9,7,70,9,TRUE);
       IsRegistered := RWK_CheckReg;
       IF IsRegistered
          THEN WritePipeXY(11,8,'|17|09Current status: |10Registered - Thank You!')
          ELSE WritePipeXY(11,8,'|17|09Current status: |12UNREGISTERED           ');

       WritePipeXY(30,13,'|17|11'+PadRight(RwKey.RegBBS,' ',36));
       WritePipeXY(30,14,'|17|11'+PadRight(RwKey.RegPhone,' ',36));
       WritePipeXY(30,15,'|17|11'+PadRight(RwKey.RegName,' ',36));
       WritePipeXY(30,17,'|17|11'+PadRight('0',' ',36));
    END;

BEGIN
   ClrScr;
   ShowBackground;
   OpenSetupRw;
   ReadSetupRw;

   Init_RegisterMode;
   Menu_DrawMenu(RwMenu);
   Menu_ClearMenu(RwMenu);
   Menu_DrawItems(RwMenu);
   HelpProc := ShowHelp;
   ReadRegInfo;
   REPEAT
      DrawStatus;
      SetCursor(cmOff);
      Menu_GetChoice(RwMenu,ChoiceID);
      CASE ChoiceID OF
         1 : GetInput(RwKey.RegBBS,RwKey.RegBBS,Standard,36,30,13,0,FALSE);
         2 : GetInput(RwKey.RegPhone,RwKey.RegPhone,Number+'+-()',15,30,14,0,FALSE);
         3 : GetInput(RwKey.RegName,RwKey.RegName,Standard,36,30,15,0,FALSE);
         4 : BEGIN
                GetInput(TempS,'0','0123456789ABCDEFabcdef',8,30,17,0,FALSE);
             END;
       END;
   UNTIL (ChoiceID = 5) OR (ChoiceID = -1);
   Menu_DeInit(RwMenu);
   RWK_WriteKey(SRW.RwMainDir);
END;


PROCEDURE RwInit;
VAR ResPath:String;
BEGIN
   SetCBreak(FALSE);
   BreakOff;
   HighIntensity(TRUE);
   StatusAttr := 11;
   IF MyShare.ShareInstalled THEN FileMode := 66;
   MsObj.DosShellProc := DosShell;

   ResPath := FSearch('RWSETUP.RES',GetEnv('PATH')+';'+GetEnv('RENEWAVE')+';'+ExtractFDir(ParamStr(0)));
   IF NOT FExists(ResPath) THEN
      BEGIN
         WriteLn;
         WriteLn('+ ERROR: Unable to find RWSETUP.RES resource file!');
         Halt(255);
      END;

   New(MenuDesc);
   New(LogicalScreen);

   Assign(ResourceFile,ResPath);
   Reset(ResourceFile,SizeOf(MenuDescRec));

   GetVideoAddress;
   OpenSetupRW;
   ReadSetupRW;
   OpenUsersRW;

   IF UpcaseStr(ParamStr(1)) = '/REGISTER'
      THEN Handle_RegisterMode
      ELSE Handle_MainSetupMenu;
END;



PROCEDURE RWDone;
BEGIN
   HighIntensity(FALSE);

   WriteSetupRW;
   Close(SetupRW);
   Close(UsersRW);
   Close(ResourceFile);

   TextAttr := 7;
   ClrScr;
   WritePipe('|16|09|09|01|16');
   WritePipe('|17|09|15 RWSETUP - RENEWAVE configuration utility, for use with RENEWAVE v2.00 and up |08|16');
   WritePipe('|17|09|09 Copyright (C) 1994-1996 by Lars Hellsten and MatrixSoft, All Rights Reserved |08|16');
   WritePipe('|17|09|07 Future Shock - The MatrixSoft Support BBS (416)494-9237 / 1:259/412          |08|16');
   WritePipe('|16|01|08|08|16');
   WriteLn;

   SetCursor(cmUnderline);
   SetCursor(cmOn);
   Dispose(MenuDesc);
   Dispose(LogicalScreen);
END;


BEGIN
   RwInit;
   RwDone;
END.
