UNIT Spin;

(* 

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

INTERFACE


CONST SpinArray    : Array[1..4] OF Char = ('-','\','|','/');
VAR   SpinArrayPos : Byte;

PROCEDURE SpinInc;
PROCEDURE SpinInit;
FUNCTION  SpinPct(Num,Total:LongInt):Byte;


IMPLEMENTATION


PROCEDURE SpinInc;
BEGIN
   Inc(SpinArrayPos);
   IF SpinArrayPos > 4 THEN SpinArrayPos := 1;
END;

PROCEDURE SpinInit;
BEGIN
   SpinArrayPos := 1;
END;

FUNCTION SpinPct(Num,Total:LongInt):Byte;
VAR TempR:Real;
BEGIN
   IF Total > 0
      THEN TempR := (Num / Total) * 100
      ELSE TempR := 0.0;
   SpinPct := Byte(Round(TempR));
END;

END.
