{$O+,I-}
UNIT MSZ_XMOD;

(* 

    MSZ_XMOD  Xmodem code

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


INTERFACE


FUNCTION  Xmodem_SendPacket(Num,Size:Word; CheckType:Char):Boolean;
FUNCTION  Xmodem_ReceivePacket(Num:Word; VAR Size:Word; CheckType:Char; VAR IsEot:Boolean):Boolean;
FUNCTION  Xmodem_SendInit(VAR CheckType:Char):Boolean;
FUNCTION  Xmodem_ReceiveInit(VAR CheckType:Char):Boolean;
FUNCTION  Xmodem_SendEOT:Boolean;

FUNCTION  Xmodem_Send(FileName:String; PktSize:Word):Boolean;
FUNCTION  Xmodem_Receive(FileName:String; CheckType:Char):Boolean;
PROCEDURE Ymodem_SendEOT;
FUNCTION  Ymodem_Send(FileSpec:String; PktSize:Word):Boolean;
FUNCTION  Ymodem_Receive(Path:String; CheckType:Char):Boolean;


IMPLEMENTATION


USES  {$I c:\oldstuff\source\MSZ\FOSSTYPE.INC }

      {$IFDEF DELPHI}
      SysUtils, Windows,
      {$ENDIF}

      {$IFDEF DOS}
      MYSHARE,
      {$ENDIF}

      DOS,      CRT,      MSTRINGS, UNIXDATE, MISC1,    CRC32,
      MSZ_VID,  MSZ_MISC;


CONST { Xmodem constants }

      MAXRETRY    = 10;
      INITTIMEOUT = 100;
      READTIMEOUT = 10;

VAR   ForcedName  : String;


FUNCTION Xmodem_SendPacket(Num,Size:Word; CheckType:Char):Boolean;
VAR I          : Integer;
    Code       : Integer;
    CheckSum   : Word;
    Attempt    : Word;
    PacketType : Byte;
BEGIN
  CASE Size OF
    128  : PacketType := SOH;
    1024 : PacketType := STX;
    ELSE   BEGIN
              Zmodem_Message('Bad packet size!');
              Inc(Errors);
              Zmodem_Errors(Errors);
              Xmodem_SendPacket := FALSE;
              Exit;
           END;
  END;

  Zmodem_ShowBlockSize(Size);
  Num := Lo(Num);
  FOR Attempt := 1 TO MAXRETRY DO
     BEGIN
        Ms_WriteString(Chr(PacketType)+Chr(Num)+Chr(Lo(NOT Num)));
        CheckSum := 0;
        FOR i := 0 TO (Size-1) DO
           BEGIN
              Ms_WriteChar(Chr(DataBuf^[i]));
              IF CheckType <> Chr(NAK)
                 THEN CheckSum := UpdateCrc(DataBuf^[i],CheckSum)
                 ELSE CheckSum := CheckSum+DataBuf^[i];
           END;
        { Send checksum/CRC/whatever }
        IF CheckType <> Chr(NAK)
           THEN BEGIN
                 Ms_WriteChar(Chr(Lo(CheckSum SHR 8)));
                 Ms_WriteChar(Chr(Lo(CheckSum)));
              END
           ELSE Ms_WriteChar(Chr(Lo(CheckSum)));
        IF NOT fk_RemoteKeypressed AND (CheckType = 'G') THEN
           BEGIN
              { IF Num = 0 THEN RealDelay(0); }
              Xmodem_SendPacket := TRUE;
              Exit;
           END;
        Code := MSZ_TimedRead(50);
        Xmodem_Frame(Code);
        CASE Code OF
           CAN      : BEGIN
                         Zmodem_Message('Cancelled by remote!');
                         Xmodem_SendPacket := FALSE;
                         Exit;
                      END;
           ACK      : BEGIN
                         Xmodem_SendPacket := TRUE;
                         Exit;
                      END;
           67,
           NAK      : BEGIN
                         Inc(Errors);
                         Zmodem_Errors(Errors);
                         Zmodem_Message('Error, resending block');
                      END;
           TIMEDOUT : ;
           ELSE       BEGIN
                         Zmodem_Message('Remote out of sync - got: '+StrFunc(Code));
                         Xmodem_SendPacket := FALSE;
                         Exit;
                      END;
        END;
     END;
  Zmodem_Message('Block '+StrFunc(Num)+': Timed out!');
  Xmodem_SendPacket := FALSE
END;


FUNCTION Xmodem_ReceivePacket(Num:Word; VAR Size:Word; CheckType:Char; VAR IsEot:Boolean):Boolean;
VAR I            : Integer;
    Code         : Integer;
    Attempt      : Word;
    RxPacketNbr  : Word;
    RxPacketNbrC : Word;
    CheckSum     : Word;
    RxCheckSum   : Word;
    RxCheckSum1  : Word;
    RxCheckSum2  : Word;
    PacketType   : Byte;

    FUNCTION CheckTimeout(Code:Integer):Boolean;
    BEGIN
       Inc(Errors);
       Zmodem_Errors(Errors);
       Zmodem_Message('Block '+StrFunc(Num)+': Timed out!');
       RealDelay(2000);
       Xmodem_ReceivePacket := FALSE;
       CheckTimeout := TRUE;
    END;

BEGIN
   Num := Lo(Num);
   FOR Attempt := 1 TO MAXRETRY DO
      BEGIN
         { Wait for SOH/STX }
         Code := MSZ_TimedRead(READTIMEOUT);
         IF Code < 0 THEN IF CheckTimeout(Code) THEN Exit;
         CASE Code OF
            SOH : BEGIN { 128 byte packet }
                     PacketType := SOH;
                     Size := 128;
                  END;
            STX : BEGIN { 1024 byte packet }
                     PacketType := STX;
                     Size := 1024;
                  END;
            EOT : BEGIN { It's all been received }
                     Ms_WriteChar(Chr(ACK));
                     IsEOT := TRUE;
                     Xmodem_ReceivePacket := TRUE;
                     Exit;
                  END;
            CAN : BEGIN
                     Inc(Errors);
                     Zmodem_Errors(Errors);
                     Zmodem_Message('Cancelled by remote!');
                     RealDelay(2000);
                     Xmodem_ReceivePacket := FALSE;
                  END;
            ELSE  BEGIN
                     Zmodem_Message('Error: Got 0x'+Int2Hex(Code)+'!');
                     Xmodem_ReceivePacket := FALSE;
                     RealDelay(2000);
                     Exit;
                  END;
         END;

      { Get packet number }
      Code := MSZ_TimedRead(READTIMEOUT);
      IF Code < 0 THEN IF CheckTimeout(Code) THEN Exit;
      RxPacketNbr := Code AND $00FF;

      { Get 1's complement of packet number }
      Code := MSZ_TimedRead(READTIMEOUT);
      IF Code < 0 THEN IF CheckTimeout(Code) THEN Exit;
      RxPacketNbrC := Code AND $00FF;

      { Get data }
      Zmodem_ShowBlockSize(Size);
      CheckSum := 0;
      FillChar(DataBuf^,Size,0);
      FOR i := 0 TO (Size-1) DO
         BEGIN
            Code := MSZ_TimedRead(READTIMEOUT);
            IF Code < 0 THEN IF CheckTimeout(Code) THEN Exit;
            DataBuf^[i] := Lo(Code);
            IF CheckType <> Chr(NAK)
               THEN CheckSum := UpdateCrc(DataBuf^[i],CheckSum)
               ELSE CheckSum := (CheckSum+DataBuf^[i]) AND $00FF;
         END;

      { Receive CRC/checksum }
      IF CheckType <> Chr(NAK)
         THEN BEGIN
               Code := MSZ_TimedRead(READTIMEOUT);
               IF Code < 0 THEN IF CheckTimeout(Code) THEN Exit;
               RxCheckSum1 := Code AND $00FF;
               Code := MSZ_TimedRead(READTIMEOUT);
               IF Code < 0 THEN IF CheckTimeout(Code) THEN Exit;
               RxCheckSum2 := Code AND $00FF;
               RxCheckSum := (RxCheckSum1 SHL 8) OR RxCheckSum2;
            END
         ELSE BEGIN
               Code := MSZ_TimedRead(READTIMEOUT);
               IF Code < 0 THEN IF CheckTimeout(Code) THEN Exit;
               RxCheckSum := Code AND $00FF;
            END;
      IF CheckType = 'G' THEN { Don't send ACK }
         BEGIN
            Xmodem_ReceivePacket := TRUE;
            Exit;
         END;
      { Verify packet # and checksum }
      IF (RxCheckSum=CheckSum) AND (RxPacketNbr=Num) THEN
         BEGIN
            Ms_WriteChar(Chr(ACK));
            Xmodem_ReceivePacket := TRUE;
            Exit;
         END;

      Inc(Errors);
      Zmodem_Errors(Errors);
      Zmodem_Frame(NAK);
      Zmodem_Message('Garbled data subpacket, sending NAK');
      Ms_WriteChar(Chr(NAK));
   END;
   Zmodem_Message('Block '+StrFunc(Num)+': Timed out!');
   Xmodem_ReceivePacket := FALSE;
END;


FUNCTION Xmodem_SendInit(VAR CheckType:Char):Boolean;
VAR Code,i:Integer;
BEGIN
   fk_PurgeInputBuffer;
   { Wait for start up NAK or "C" }
   FOR i := 1 TO (MAXRETRY*2) DO
      BEGIN
         IF KeyPressed THEN IF (ReadKey=#27) THEN
            BEGIN
               Zmodem_Message('Cancelled from keyboard');
               Xmodem_SendInit := FALSE;
               Exit;
            END;
         Code := MSZ_TimedRead(READTIMEOUT);
         IF Hi(Code) = 0
            THEN BEGIN
                  IF (Code = NAK) OR (Code = Ord('C')) OR (Code = Ord('G')) THEN
                     BEGIN
                        CheckType := Chr(Lo(Code));
                        Xmodem_SendInit := TRUE;
                        Exit;
                     END;
               END
            ELSE CASE Code OF
                  CAN : BEGIN
                           Xmodem_SendInit := FALSE;
                           Exit;
                        END;
               END;
      END;
   Zmodem_Message('Timed out - no response from receiver');
   Xmodem_SendInit := FALSE;
   RealDelay(2000);
END;


FUNCTION Xmodem_ReceiveInit(VAR CheckType:Char):Boolean;
VAR i,Code:Integer;
BEGIN
   { Send NAK or 'C's }
   Zmodem_Message('Synchronizing with sender');
   FOR i := 1 TO 10 DO
      BEGIN
         IF KeyPressed THEN IF (ReadKey=#27) THEN
            BEGIN
               Zmodem_Message('Cancelled from keyboard');
               Xmodem_ReceiveInit := FALSE;
               Exit;
            END;
         { Stop trying to send CRC after 4 tries }
         IF (CheckType = 'C') AND (i=5) THEN CheckType := Chr(NAK);
         Ms_WriteChar(CheckType);
         IF MSZ_TimedKeypress(INITTIMEOUT) THEN
            BEGIN
               Xmodem_ReceiveInit := TRUE;
               Exit;
            END;
      END;
   Zmodem_Message('Timed out - no response from receiver');
   Xmodem_ReceiveInit := FALSE;
   RealDelay(2000);
END;


FUNCTION Xmodem_SendEOT:Boolean;
VAR i,Code:Integer;
BEGIN
   Zmodem_Message('Sending EOT');
   FOR i := 0 TO 10 DO
      BEGIN
         Ms_WriteChar(Chr(EOT));
         Code := MSZ_TimedRead(10);
         IF Code = ACK THEN
            BEGIN
               Xmodem_SendEOT := TRUE;
               Exit;
            END;
      END;
   Xmodem_SendEOT := FALSE;
END;


FUNCTION Send_XYmodem(FileName:String; PktSize:Word; Batch:Boolean):Boolean;
VAR i,BuffPos   : Integer;
    Packet      : Integer;
    BlockSize   : Word;
    FirstPacket : Word;
    CheckSum    : Word;
    FileTime    : LongInt;
    Number1K    : LongInt;
    Number128   : LongInt;
    CheckType   : Char;
    s           : String;
    {$IFDEF OS2}
    BytesRead   : LongInt;
    {$ELSE}
    BytesRead   : Integer;
    {$ENDIF}
    Finished    : Boolean;

  FUNCTION InitSend:Boolean;
  BEGIN
     StartTime := $7FFFFFFF;
     BlockSize := 128;
     Number128 := 0;
     Number1K := 0;
     Finished := FALSE;
     CheckType := Chr(NAK);
     IF Batch AND (Length(Filename)=0) THEN Finished := TRUE;
     IF NOT Finished
        THEN BEGIN
              Assign(TheFile,FileName);
              Reset(TheFile,1);

              IF IOResult <> 0 THEN
                 BEGIN
                    Zmodem_Message('Unable to find/open file');
                    InitSend := FALSE;
                    Send_XYmodem := FALSE;
                    BatchTx := BatchTx+FileTotal;
                    IF Batch THEN MSZ_WriteLog('S',0,FileName,FALSE) ELSE fk_Host.ExitCode := 1;
                    Exit;
                 END;

              Seek(TheFile,0);
              GetFTime(TheFile,FileTime);
              FileTotal := FSize(TheFile);
              FileTx := 0;
              IF PktSize = 1024
                 THEN BEGIN
                       Number1K := FileTotal DIV 1024;
                       Number128 := (FileTotal MOD 1024) DIV 128;
                    END
                 ELSE BEGIN
                       Number1K := 0;
                       Number128 := FileTotal DIV 128;
                    END;
              IF (LongInt(128)*Number128+LongInt(1024)*Number1K) < Filetotal THEN Number128 := Number128+1;
           END
        ELSE BEGIN
              Number128 := 0;
              Number1K := 0
           END;

     IF NOT Xmodem_SendInit(CheckType) THEN
        BEGIN
           InitSend := FALSE;
           BatchTx := BatchTx+FileTotal;
           IF Batch THEN MSZ_WriteLog('S',0,FileName,FALSE) ELSE fk_Host.ExitCode := 1;
           Send_XYmodem := FALSE;
           Exit;
        END;
     StartTime := CurrentSecsFunc;
     Zmodem_ShowName(FileName);
     Zmodem_ShowSize;
     CASE CheckType OF
        Chr(NAK) : Zmodem_ShowCheck('Xmodem-Checksum');
        'C'      : IF Batch
                      THEN Zmodem_ShowCheck('Ymodem-Batch/'+StrFunc(PktSize))
                      ELSE Zmodem_ShowCheck('Xmodem-CRC/'+StrFunc(PktSize));
        'G'      : IF Batch
                      THEN Zmodem_ShowCheck('Ymodem-G/'+StrFunc(PktSize))
                      ELSE Zmodem_ShowCheck('Xmodem-1K-G/'+StrFunc(PktSize));
     END;
  END;

BEGIN
   IF NOT InitSend THEN Exit;
   IF Batch THEN FirstPacket := 0 ELSE FirstPacket := 1;
   fk_PurgeInputBuffer;
   FOR Packet := FirstPacket TO Number1K+Number128 DO
      BEGIN
         IF KeyPressed THEN IF (ReadKey=#27) THEN
            BEGIN
               Zmodem_Message('Cancelled from keyboard');
               MSZ_SendCan;
               BatchTx := BatchTx+FileTotal;
               IF Batch THEN MSZ_WriteLog('S',FileTx,FileName,FALSE) ELSE fk_Host.ExitCode := 1;
               Send_XYmodem := FALSE;
               Exit;
            END;
         IF Packet=0
            THEN BEGIN
                  FillChar(DataBuf^,ZBUFSIZE,0);
                  IF Finished
                     THEN DataBuf^[0] := 0
                     ELSE BEGIN
                           BlockSize := 128;

                           s := DownCaseStr(
                                            FileName+#0+
                                            StrFunc(FileTotal)+' '+
                                            Zmodem_ToUnixDate(FileTime)+' '+
                                            '0 '+
                                            '0 '+
                                            StrFunc(BatchNum-BatchCurrent)+' '+
                                            StrFunc(BatchTotal-BatchTx)
                                           );

                           Move(s[1],DataBuf^[0],Length(s));
                           BuffPos := Length(s);
                        END;
               END
            ELSE BEGIN
                  IF (Packet <= Number1K)
                     THEN BlockSize := 1024
                     ELSE BlockSize := 128;

                  BlockRead(TheFile,DataBuf^,BlockSize,BytesRead);
                  FileTx := FileTx+BytesRead;
                  { Pad short buffer with ^Z }
                  IF BytesRead < BlockSize THEN
                     FOR i := BytesRead TO BlockSize-1 DO DataBuf^[i] := $1A;
               END;
         IF NOT Xmodem_SendPacket(Packet,BlockSize,CheckType) THEN
            BEGIN
               Send_XYmodem := FALSE;  { Bail ... }
               BatchTx := BatchTx+FileTotal;
               IF Batch THEN MSZ_WriteLog('S',FileTx,FileName,FALSE) ELSE fk_Host.ExitCode := 1;
               Exit;
            END;
         Zmodem_ShowLoc;
         IF Batch THEN Zmodem_ShowBatchLoc;
         IF (Finished=FALSE) AND (Packet = 0) THEN Xmodem_SendInit(CheckType);
      END;
   IF Finished THEN
      BEGIN
         Zmodem_Message('Batch transfer completed');
         Send_XYmodem := TRUE;
         Exit;
      END;
   BatchTx := BatchTx+FileTotal;
   IF Batch THEN MSZ_WriteLog('S',FileTotal,FileName,TRUE) ELSE fk_Host.ExitCode := 0;
   Close(TheFile);
   Xmodem_SendEOT;
   Send_XYmodem := TRUE;
END;


FUNCTION Receive_XYmodem(VAR FileName:String; CheckType:Char; Batch:Boolean):Boolean;
VAR Packet     : Word;
    EotFlag    : Boolean;
    FileTime   : LongInt;
    FilePath   : String;
    s          : String;
    FirstPacket: Word;
    Finished   : Boolean;
    PacketSize : Word;

   FUNCTION GetFileInfo:Boolean;
   BEGIN
      Zmodem_InitWindow(FALSE);

      FileTime := -1;
      FileName := '';
      FileTotal := -1;
      FileTx := 0;

      MSZ_GetInfoHeader(DataBuf,FileName,FileTotal,FileTime);

      IF (DataBuf^[0] = 0) OR (FileName = '') THEN
         BEGIN
            Zmodem_Message('Batch transfer complete');
            FileName := '';
            GetFileInfo := TRUE;
            Receive_XYmodem := TRUE;
            RealDelay(2000);
            fk_PurgeInputBuffer;
            Exit;
         END;

      IF ForcedName <> '' THEN
         BEGIN
            FileName := ForcedName;
            ForcedName := '';
         END;

      IF MSZ_CheckBadName(FileName) <> '' THEN
         BEGIN
            Zmodem_Message('Tried to upload to '+MSZ_CheckBadName(FileName)+' - skipping!');
            IF Batch THEN MSZ_WriteLog('R',0,FileName,FALSE) ELSE fk_Host.ExitCode := 1;
            RealDelay(2000);
            GetFileInfo := TRUE;
            Receive_XYmodem := FALSE;
            Exit;
         END;
      FileName := UpcaseStr(FilePath+ExtractFName(FileName));
      GetFileInfo := FALSE;
   END;

   FUNCTION InitReceive:Boolean;
   BEGIN
      Zmodem_InitWindow(FALSE);
      FilePath := FileName;
      StartTime := $7FFFFFFF;
      FileTx := 0;
      Finished := FALSE;
      EotFlag := FALSE;
      FileTotal := -1;
      IF NOT Xmodem_ReceiveInit(CheckType) THEN
         BEGIN
            InitReceive := FALSE;
            Receive_XYmodem := FALSE;
            Exit;
         END;
      IF Batch
         THEN FirstPacket := 0
         ELSE BEGIN
               FirstPacket := 1;
               FileName := FilePath;
               StartTime := CurrentSecsFunc;
               Assign(TheFile,FileName);
               Rewrite(TheFile,1);
               IF IOResult <> 0 THEN
                  BEGIN
                     Zmodem_Message('Error creating '+FileName);
                     InitReceive := FALSE;
                     Receive_XYmodem := FALSE;
                     Exit;
                  END;
               Seek(TheFile,0);
               Zmodem_ShowName(FileName);
               Zmodem_ShowSize;
            END;
      CASE CheckType OF
         Chr(NAK) : IF Batch
                       THEN Zmodem_ShowCheck('Ymodem-Batch')
                       ELSE Zmodem_ShowCheck('Xmodem-Checksum');
         'C'      : IF Batch
                       THEN Zmodem_ShowCheck('Ymodem-Batch')
                       ELSE Zmodem_ShowCheck('Xmodem-CRC');
         'G'      : IF Batch
                       THEN Zmodem_ShowCheck('Ymodem-G')
                       ELSE Zmodem_ShowCheck('Xmodem-1K-G');
      END;
      Zmodem_Message('Receiving file');
   END;

   FUNCTION CreateFile:Boolean;
   BEGIN
      Assign(TheFile,FileName);
      Rewrite(TheFile,1);
      IF IOResult <> 0 THEN
         BEGIN
            Zmodem_Message('Error creating '+FileName);
            IF Batch THEN MSZ_WriteLog('R',0,FileName,FALSE) ELSE fk_Host.ExitCode := 1;
            CreateFile := FALSE;
            Receive_XYmodem := FALSE;
            RealDelay(2000);
            Exit;
         END;
      StartTime := CurrentSecsFunc;
      Seek(TheFile,0);
      IF NOT Xmodem_ReceiveInit(CheckType) THEN
         BEGIN
            Zmodem_Message('Unable to synchronize with sender');
            IF Batch THEN MSZ_WriteLog('R',0,FileName,FALSE) ELSE fk_Host.ExitCode := 1;
            CreateFile := FALSE;
            Receive_XYmodem := FALSE;
            RealDelay(2000);
            Exit;
         END;
      CASE CheckType OF
         Chr(NAK) : IF Batch
                       THEN Zmodem_ShowCheck('Ymodem-Batch')
                       ELSE Zmodem_ShowCheck('Xmodem-Checksum');
         'C'      : IF Batch
                       THEN Zmodem_ShowCheck('Ymodem-Batch')
                       ELSE Zmodem_ShowCheck('Xmodem-CRC');
         'G'      : IF Batch
                       THEN Zmodem_ShowCheck('Ymodem-G')
                       ELSE Zmodem_ShowCheck('Xmodem-1K-G');
      END;
      Zmodem_ShowName(FileName);
      Zmodem_ShowSize;
      Zmodem_Message('Receiving file');
      CreateFile := TRUE;
   END;

   PROCEDURE WriteBuffer;
   VAR {$IFDEF OS2} BytesW:LongInt; {$ELSE} BytesW:Integer; {$ENDIF}
   BEGIN
      FileTx := FileTx+PacketSize;
      IF (FileTotal >= 0) AND (FileTx > FileTotal) AND (FileTx-FileTotal <= PacketSize)
         THEN BEGIN
               BlockWrite(TheFile,DataBuf^,PacketSize-(FileTx-FileTotal),BytesW);
               FileTx := FileTx-PacketSize+(FileTotal MOD PacketSize);
            END
         ELSE BlockWrite(TheFile,DataBuf^,PacketSize,BytesW);
   END;

   FUNCTION CheckAborted:Boolean;
   BEGIN
      IF (ReadKey=#27)
         THEN BEGIN
               Zmodem_Message('Cancelled from keyboard');
               MSZ_SendCan;
               IF Batch THEN MSZ_WriteLog('R',FileTx,FileName,FALSE) ELSE fk_Host.ExitCode := 1;
               Receive_XYmodem := FALSE;
               Exit;
            END
         ELSE CheckAborted := FALSE;
   END;

BEGIN
   fk_PurgeInputBuffer;
   IF NOT InitReceive THEN Exit;
   Packet := FirstPacket;
   WHILE TRUE DO
      BEGIN
         IF KeyPressed THEN IF CheckAborted THEN Exit;

         IF NOT Xmodem_ReceivePacket(Packet,PacketSize,CheckType,EotFlag) THEN
            BEGIN
               Receive_XYmodem := FALSE;
               IF Batch THEN MSZ_WriteLog('R',FileTx,FileName,FALSE) ELSE fk_host.ExitCode := 1;
               Exit;
            END;

         { Check if the last file has been received }
         IF (Packet = 0) THEN IF GetFileInfo THEN Exit;

         { Check if we're finished with this file }
         IF EotFlag THEN
            BEGIN
               FileTotal := FSize(TheFile);
               Zmodem_Message('File received ('+StrFunc(FileTotal)+' bytes)');
               IF Batch THEN MSZ_WriteLog('R',FileTotal,FileName,TRUE) ELSE fk_Host.ExitCode := 0;
               BatchTx := BatchTx+FileTotal;
               IF FileTime <> -1 THEN SetFTime(TheFile,FileTime);
               Close(TheFile);
               IF IOResult <> 0 THEN ;
               Receive_XYmodem := TRUE;
               Exit;
            END;

         IF (Packet <> 0)
            THEN WriteBuffer
            ELSE IF NOT CreateFile { Create the file to receive to }
               THEN Exit;

         Zmodem_ShowLoc;
         IF Batch THEN Zmodem_ShowBatchLoc;
         Inc(Packet);
      END;
END;


FUNCTION Xmodem_Send(FileName:String; PktSize:Word):Boolean;
BEGIN
   Zmodem_InitWindow(TRUE);
   Xmodem_Send := Send_XYmodem(DowncaseStr(FileName),PktSize,FALSE);
END;


FUNCTION Xmodem_Receive(FileName:String; CheckType:Char):Boolean;
BEGIN
   Xmodem_Receive := Receive_XYmodem(FileName,CheckType,FALSE);
END;


PROCEDURE Ymodem_SendEOT;
BEGIN
   Send_XYmodem('',128,TRUE);
END;


FUNCTION Ymodem_Send(FileSpec:String; PktSize:Word):Boolean;
VAR FileNum:Integer; DirInfo:SearchRec; FileName:String;
BEGIN
   FileNum := 1;
   FFirst(FileSpec,AnyFile AND NOT VolumeID,DirInfo);
   IF DosError <> 0
      THEN Ymodem_Send := FALSE
      ELSE BEGIN
            WHILE DosError = 0 DO
               BEGIN
                  Zmodem_InitWindow(TRUE);
                  FileName := AddSlash(ExtractFDir(FileSpec))+DirInfo.Name;
                  IF NOT Send_XYmodem(DowncaseStr(FileName),PktSize,TRUE) THEN
                     BEGIN
                        Ymodem_Send := FALSE;
                        {$IFDEF DELPHI} SYSUTILS.FindClose(DirInfo); {$ENDIF}
                        {$IFDEF OS2}    FindClose(DirInfo); {$ENDIF}
                        Exit;
                     END;
                  Inc(BatchCurrent);
                  Inc(FileNum);
                  FNext(DirInfo);
               END;
            {$IFDEF DELPHI} SYSUTILS.FindClose(DirInfo); {$ENDIF}
            {$IFDEF OS2}    FindClose(DirInfo); {$ENDIF}
            Ymodem_Send := TRUE;
         END;
END;


FUNCTION Ymodem_Receive(Path:String; CheckType:Char):Boolean;
VAR fn:String; Done:Boolean;
BEGIN
   Ymodem_Receive := TRUE;
   Done := FALSE;
   ForcedName := '';
   IF DirExists(Path)
      THEN Path := AddSlash(Path)
      ELSE ForcedName := ExtractFName(Path);
   Path := ExtractFDir(Path);
   IF Path <> '' THEN Path := AddSlash(Path);
   REPEAT
      fn := Path;
      IF NOT Receive_XYmodem(fn,CheckType,TRUE) THEN
         BEGIN
            Ymodem_Receive := FALSE;
            Exit;
         END;
      Inc(BatchCurrent);
      IF KeyPressed THEN Done := ReadKey = #27
  UNTIL Done OR (Length(fn)=0);
END;


END.
