UNIT SoundEx;

INTERFACE

{ SoundEx Hashing Implementation                                      }
{ Original work by Reynir Stefansson, additional modifications made   }
{ by Lars Hellsten.  This source code is public domain.  More info    }
{ on SoundEx hashing can be found in Donald Knuth's "Art of Computer  }
{ Programming" series.                                                }

TYPE SdxStr = String[4];


FUNCTION  SoundsAlike(s1,s2:String):Boolean;
FUNCTION  SoundexOf(WorkStr:String):SdxStr;


IMPLEMENTATION

CONST Group : Array[0..6] OF String[8] =
              ('AEHIOUWY','BFPV','CGJKQSXZ','DT','L','MN','R');


FUNCTION SoundsAlike(s1,s2:String):Boolean;
BEGIN
   SoundsAlike := SoundexOf(s1) = SoundexOf(s2);
END;


FUNCTION ValidityOf(Letter:Char):Char;
VAR i,j:Integer; Chs:String[8];
BEGIN
   FOR i := 0 TO 6 DO
      BEGIN
         Chs := Group[i];
         FOR j := 1 TO Length(Chs) DO
            IF Upcase(Letter) = Chs[j]
               THEN
                  ValidityOf := Chr(48+i);
      END;
END;


FUNCTION SoundexOf(WorkStr:String):SdxStr;
VAR Soundex:SdxStr; OldVal,Value:Char; i:Integer;
BEGIN
   SoundEx := Copy(WorkStr,1,1);
   OldVal := ValidityOf(WorkStr[1]);
   {...}
   FOR i := 2 TO Length(WorkStr) DO
      BEGIN
         Value := ValidityOf(WorkStr[i]);
         IF (Value <> '0') AND (Value <> OldVal)
            THEN
               Soundex := Soundex + Value;
         OldVal := Value;
      END;
   SoundexOf := SoundEx+'000';
END;


END.

