UNIT Screens;

{ SCREENS Manipulation Unit                                               }
{ (c) Copyright 1994 By Jeff Fanjoy and MatrixSoft.  All Rights Reserved. }

INTERFACE

{$IFDEF VIRTUALPASCAL}
USES CRT,DOS,FASTW,MSOBJ,OS2BASE;
{$ELSE}
USES CRT,DOS,FASTW,MSOBJ;
{$ENDIF}

{$IFNDEF OS2}
CONST pal_num  : Array[0..15] of Byte =(0,1,2,3,4,5,20,7,56,57,58,59,60,61,62,63);
      pal_red  : Array[0..15] of Byte =(0,0,0,0,42,42,42,42,21,21,21,21,63,63,63,63);
      pal_green: Array[0..15] of Byte =(0,0,42,42,0,0,21,42,21,21,63,63,21,21,63,63);
      pal_blue : Array[0..15] of Byte =(0,42,0,42,0,42,0,42,21,63,21,63,21,63,21,63);

      StripShading : Boolean = TRUE;

TYPE  PaletteType  = Array[0..255,1..3] OF Byte;

VAR   VideoAddress : Word;
      OlPlt        : PaletteType;
      Plt          : PaletteType;
      SetPal256    : PROCEDURE(VAR Pal:PaletteType);

PROCEDURE GetVideoAddress;
PROCEDURE SetPal86(VAR Pal:PaletteType);
PROCEDURE FadeUp;
PROCEDURE FadeDown;
{$ENDIF}

PROCEDURE HighIntensity(State:Boolean);
PROCEDURE MakeBox(Title:String; StartX,StartY,EndX,EndY:Byte; Shadow:Boolean);
PROCEDURE ScreenScroll(Direction:ScrollType; Lines,Top,Bot,SCol,FCol,FillAttr:Byte);


IMPLEMENTATION


{$IFDEF OS2}
PROCEDURE HighIntensity(State:Boolean);
VAR Intensity:VioIntensity;
BEGIN
   Intensity.cb := 6; { Structure size }
   Intensity.rType := 2; { 2 = set intensity/blink }
   IF State THEN Intensity.fs := 1 ELSE Intensity.fs := 0;
   VioSetState(Intensity,0);
END;


{$ELSE}
PROCEDURE HighIntensity(State:Boolean);
CONST BlinkBit    = $20;
      ModeSelOfs  = 4;
VAR   Regs        : Registers;
      CrtMode     : Byte ABSOLUTE $0040:$0065;
      CrtPortBase : Word ABSOLUTE $0040:$0063;

      FUNCTION EgaBios:Boolean; { test For the existance of EGA/VGA BIOS }
      VAR Regs:Registers;
      BEGIN
         Regs.AH := $12;
         Regs.BX := $FF10;
         Intr($10,Regs);
         EgaBios := Regs.BX <> $FF10;
      END;

BEGIN
   IF EgaBios
      THEN BEGIN
            Regs.AX := $1003;
            IF State
               THEN Regs.BL := 0
               ELSE Regs.BL := 1;
            Intr($10,Regs);
         END
      ELSE BEGIN
            IF State
               THEN CrtMode := CrtMode AND NOT BlinkBit
               ELSE CrtMode := CrtMode OR BlinkBit;
            Port[CrtPortBase+ModeSelOfs] := CrtMode;
         END;
END;


PROCEDURE GetVideoAddress;
VAR Regs:Registers;
BEGIN
   Regs.Ah := $0F;
   Intr($10,Regs);
   IF (Regs.Al IN [0..3])
      THEN VideoAddress := $B800
      ELSE IF Regs.Al = 7
         THEN VideoAddress := $B000
         ELSE ;
   Screen := Ptr(VideoAddress,0);
END;
{$ENDIF}


PROCEDURE MakeBox(Title:String; StartX,StartY,EndX,EndY:Byte; Shadow:Boolean);
VAR TXPos,TYPos:Byte;
BEGIN
   ReadScreen(LogicalScreen^);

   WITH LogicalScreen^,BoxInfo DO
     BEGIN
       Pos[StartY,StartX] := TopLeft;  { Corners }
       Pos[EndY  ,StartX] := BotLeft;
       Pos[StartY,EndX  ] := TopRight;
       Pos[EndY  ,EndX  ] := BotRight;

       FOR TXPos := (StartX+1) TO (EndX-1) DO Pos[StartY,TXPos  ] := Top;
       FOR TXPos := (StartX+1) TO (EndX-1) DO Pos[EndY  ,TXPos  ] := Bot;
       FOR TYPos := (StartY+1) TO (EndY-1) DO Pos[TYPos ,StartX ] := Left;
       FOR TYPos := (StartY+1) TO (EndY-1) DO Pos[TYPos ,EndX   ] := Right;

       IF Title <> '' THEN
          BEGIN
             Pos[StartY,StartX+2]                    := LeftTitle;
             Pos[StartY,StartX+3].Ch                 := ' ';
             Pos[StartY,StartX+3].Attr               := AttrTitle;
             Pos[StartY,StartX+5+Length(Title)]      := RightTitle;
             Pos[StartY,StartX+4+Length(Title)].Ch   := ' ';
             Pos[StartY,StartX+4+Length(Title)].Attr := AttrTitle;
             FOR TXPos := 1 TO Length(Title) DO
               BEGIN
                 Pos[StartY,StartX+3+TXPos].Ch   := Title[TXPos];
                 Pos[StartY,StartX+3+TXPos].Attr := AttrTitle;
               END;
          END;

       IF Shadow THEN { Draw shadowing }
          BEGIN
             FOR TXPos := (StartX+2) TO EndX DO
                BEGIN
                   Pos[EndY+1,TXPos].Attr := ShadowAttr;
                   IF StripShading AND (Pos[EndY+1,TXPos].Ch IN [''..'']) THEN Pos[EndY+1,TXPos].Ch := ' ';
                END;
             FOR TYPos := (StartY+1) TO (EndY+1) DO
                BEGIN
                   Pos[TYPos,EndX+1].Attr := ShadowAttr;
                   Pos[TYPos,EndX+2].Attr := ShadowAttr;
                   IF StripShading AND (Pos[TYPos,EndX+1].Ch IN [''..'']) THEN Pos[TYPos,EndX+1].Ch := ' ';
                   IF StripShading AND (Pos[TYPos,EndX+2].Ch IN [''..'']) THEN Pos[TYPos,EndX+2].Ch := ' ';
                END;
          END;

       Inc(StartY); Dec(EndY);
       Inc(StartX); Dec(EndX);

       FOR TYPos := StartY TO EndY DO
          FOR TXPos := StartX TO EndX DO
             BEGIN
                Pos[TYPos,TXPos].Ch   := ' ';
                Pos[TYPos,TXPos].Attr := AttrMiddle;
             END;
     END;

   WriteScreen(LogicalScreen^);
END;


{$IFDEF OS2}
PROCEDURE ScreenScroll(Direction:ScrollType; Lines,Top,Bot,SCol,FCol,FillAttr: Byte);
VAR i:Byte; w:Word;
BEGIN
   w := 0;
   IF (Direction=Up)
      THEN VioScrollUp(Top,SCol,Bot,FCol,Lines,w,0)
      ELSE VioScrollDn(Top,SCol,Bot,FCol,Lines,w,0);
END;


{$ELSE}
PROCEDURE ScreenScroll(Direction:ScrollType; Lines,Top,Bot,SCol,FCol,FillAttr: Byte);

BEGIN
   IF (Direction = Up) THEN
    ASM
       MOV Ah, 06h
       MOV Al, Lines
       MOV Bh, FillAttr
       MOV Ch, Top
       MOV Cl, SCol
       MOV Dh, Bot
       MOV Dl, FCol
       INT 10h
    END
   ELSE
    ASM
       MOV Ah, 07h
       MOV Al, Lines
       MOV Bh, FillAttr
       MOV Ch, Top
       MOV Cl, SCol
       MOV Dh, Bot
       MOV Dl, FCol
       INT 10h
    END;
END;


Procedure GetPal256 (Var Pal : PaletteType);
Var
  loope : Word;
begin
  port[$3C7] := 0;
  { when a read is made on port $3C9 it increment port $3C7 so no changing }
  { of the register port ($3C7) needs to be perFormed here                 }
  For loope := 0 to 255 do
    begin
      Pal[loope,1] := port[$3C9];   { Read red value   }
      Pal[loope,2] := port[$3C9];   { Read green value }
      Pal[loope,3] := port[$3C9];   { Read blue value  }
    end;
end;
{
    SetPal86:
        Loads the palette Registers With the values in
        Pal.
    86/88 instructions.
}
Procedure SetPal86 (Var Pal : PaletteType);
begin
  Asm
    push    ds      { preserve segment Registers }
    push    es
    mov cx,256 * 3  { 256 RBG values             }
    mov dx,03DAh
    { by waiting For the retrace to end it avoids static }
    { when the palette is altered                        }
@retrace1:
    in  al,dx       { wait For no retrace        }
    and al,8        { check For retrace          }
    jnz @retrace1   { so loop Until it goes low  }
@retrace2:
    in  al,dx       { wait For retrace           }
    and al,8        { check For retrace          }
    jz  @retrace2   { so loop Until it goes high }
    lds si, Pal     { ds:si = @Pal               }
    mov dx,3c8h     { set up For a blitz-white   }
    mov al,0        { from this register         }
    cli             { disable interrupts         }
    out dx,al       { starting register          }
    inc dx          { set up to update DAC       }
    cld             { clear direction flag       }
@outnext:
    { the following code is what I have found to be the  }
    { most efficient way to emulate the "rep outsb"      }
    { instructions on the 8086/88                       }
    lodsb               { load al With ds:[si]       }
    out dx,al           { out al to port in dx       }
    loop    @outnext    { loop cx times              }
    sti                 { end of critical section    }
    pop es
    pop ds              { restore segment Registers  }
  end;
end;


PROCEDURE FadeDown;
VAR Plt:PaletteType; i,j,k:Integer;
BEGIN
   GetPal256(Plt);
{   plt := olplt;  }
   FOR k := 0 TO 63 DO
      IF (k MOD 8) = 0 THEN
         BEGIN
            FOR j := 0 TO 255 DO FOR i := 1 TO 3 DO IF Plt[j,i] <> 0 THEN dec(Plt[j,i]);
            SetPal256(Plt);
         END;
END;


Procedure fadeup;
VAR Plt:PaletteType; i,j,k:Integer;
BEGIN
   GetPal256(Plt);           { Load current palette }
   FOR k := 0 TO 63 DO
      IF (k+1) MOD 8 = 0 THEN
         BEGIN
            FOR j := 0 TO 255 DO
               FOR i := 1 TO 3 DO
                  IF Plt[j,i] <> OlPlt[j,i] THEN
                     Inc(Plt[j,i]);      { bring palette back to the norm }
            SetPal256(Plt);         { gradually fades up the palette }
                                 { to the normal values           }
         END;
END;


BEGIN
  GetVideoAddress;
  SetPal256 := SetPal86;
  GetPal256(OlPlt);
  {$ENDIF}
END.
