{$O+,I-}
UNIT MSTGACS;

(* 

    MSTGACS - MatrixSoft's Telegard ACS Processing/Parsing Routines 

    MSCOMMON is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

INTERFACE


USES TGRECORD;


VAR  VoteQues       : Integer;
     AcsF_Baud      : String;


FUNCTION  EvalACSFunc(Func:String):Boolean;
FUNCTION  EvaluateACSString(ACSStringIn:String):Boolean;
FUNCTION  EvalAcs(AcsStringIn:String):Boolean;
FUNCTION  ProcessAge(Func,BDay:String):Boolean;
FUNCTION  ProcessConf(Func:String):Boolean;
FUNCTION  ProcessArFlag(Func:String; AR:ACRQs):Boolean;
FUNCTION  ProcessGender(Func:String; Sex:Char):Boolean;
FUNCTION  ProcessAcFlag(Func:String):Boolean;
FUNCTION  ProcessSL(Func:String; SL:Byte):Boolean;
FUNCTION  ProcessTimeLeft(Func:String; TimeLeft:Integer):Boolean;
FUNCTION  ProcessTime(Func:String):Boolean;
FUNCTION  ProcessPCR(Func:String):Boolean;
FUNCTION  ProcessCalls(Func:String; Calls:Word):Boolean;
FUNCTION  ProcessPosts(Func:String; Posts:Word):Boolean;
FUNCTION  ProcessFP(Func:String; Points:LongInt):Boolean;


IMPLEMENTATION

USES  DOS,
      CRT,
      MISC1,
      MSTRINGS,
      UNIXDATE,
      MSTGGEN;


FUNCTION EvalAcs(AcsStringIn:String):Boolean;
BEGIN
   EvalAcs := EvaluateAcsString(AcsStringIn);
END;


FUNCTION EvalACSFunc(Func:String):Boolean;
BEGIN
   CASE Func[1] OF
      'A' : EvalAcsFunc := ProcessAge(func,MsTg_User.BirthDate);
      'B' : EvalAcsFunc := TRUE;
      'C' : EvalAcsFunc := ProcessConf(func);
      'E' : EvalAcsFunc := ProcessArFlag(func,MsTg_User.AFlags1);
      'F' : EvalAcsFunc := ProcessArFlag(func,MsTg_User.AFlags2);
      'G' : EvalAcsFunc := ProcessGender(func,MsTg_User.Gender);
      'H' : EvalAcsFunc := TRUE; {ProcessHour(func);}
      'L' : EvalAcsFunc := ProcessCalls(func,MsTg_User.TotalCalls);
      'M' : EvalAcsFunc := ProcessPosts(func,MsTg_User.PubPost);
      'O' : EvalAcsFunc := TRUE;
      'P' : EvalAcsFunc := ProcessFP(func,MsTg_User.FilePoints);
      'R' : EvalAcsFunc := ProcessAcFlag(Func);
      'S' : EvalAcsFunc := ProcessSL(func,MsTg_User.SL);
      'T' : EvalAcsFunc := ProcessTimeLeft(func,MsTg_User.TlToday);
      'W' : EvalACSFunc := TRUE; {ProcessDOW(Func);}
      'Y' : EvalACSFunc := ProcessTime(Func);
      ELSE
        IF      (Func = 'VP') THEN EvalAcsFunc := ProcessPCR(func)
        ELSE IF (Func = 'VK') THEN EvalAcsFunc := TRUE { UL#K }
        ELSE IF (Func = 'VU') THEN EvalAcsFunc := TRUE { UL/DL }
        ELSE IF (Func = 'XA') THEN EvalAcsFunc := (MsTg_User.UGraphics = 1)
        ELSE IF (Func = 'XI') THEN EvalAcsFunc := (flInput IN MsTg_User.Flags)
        ELSE IF (Func = 'XC') THEN EvalAcsFunc := TRUE { sysop avail }
        ELSE IF (Func = 'XL') THEN
        ELSE IF (Func = 'XP') THEN EvalAcsFunc := (pause IN MsTg_User.Flags)
        ELSE IF (Func = 'XR') THEN EvalAcsFunc := (MsTg_User.UGraphics = 3)
        ELSE IF (Func = 'XT') THEN EvalAcsFunc := (MsTg_User.UGraphics = 0)
        ELSE IF (Func = 'XV') THEN EvalAcsFunc := (MsTg_User.UGraphics = 2)
        ELSE IF (Func = 'XX') THEN EvalAcsFunc := NOT (novice IN MsTg_User.Flags)
        ELSE EvalACSFunc := TRUE;
   END;
END;


FUNCTION EvaluateACSString(ACSStringIn:String):Boolean;
VAR ACSString,
    OneState,
    TempS          : String;
    ThisCh         : Byte;
    FinalStatus,
    SkipProc       : Boolean;
    LogicalStat    : Char;
    i              : integer;

   PROCEDURE GetNextStatement(VAR OneState, ACSString:String);
   VAR ThisChar,PosB:Integer;
   BEGIN
      ThisChar := 2; OneState := '';
      IF ACSString[1] IN ['!','|','&']
         THEN OneState := ACSString[1]
         ELSE BEGIN
               OneState := '&';
               Insert('&',ACSString,1);
            END;
      IF ACSString[2] = '(' THEN
         BEGIN
            i := Pos(')',ACSString);
            IF (i > 0)
               THEN OneState := Copy(ACSString,1,i)
               ELSE OneState := ACSString;
         END
      ELSE IF (ACSString[2] IN ['C','E','F','G','J','M','O','R','V','Z'])
         THEN OneState := Copy(ACSString,1,3)
         ELSE BEGIN
               OneState := OneState + ACSString[2];
               WHILE (ACSString[ThisChar+1] IN ['0'..'9']) AND (ThisChar+1 <= Length(ACSString)) DO
                  BEGIN
                     OneState := OneState + ACSString[ThisChar+1];
                     Inc(ThisChar);
                  END;
            END;
      Delete(acsstring,1,Length(OneState));
   END;

   FUNCTION EvalBracket(VAR InStr:String):Boolean;
   VAR OneState,TempS,TempS2:String;  TempStatus:Boolean;
   BEGIN
      TempStatus := TRUE;
      TempS2 := InStr;
      WHILE Length(TempS2) <> 0 DO
         BEGIN
            GetNextStatement(OneState,TempS2);
            TempS := Copy(OneState,2,Length(OneState) - 1);
            CASE OneState[1] OF
               '!' : TempStatus := TempStatus AND (NOT EvalACSFunc(TempS));
               '|' : TempStatus := TempStatus OR EvalACSFunc(TempS);
               '&' : TempStatus := TempStatus AND EvalACSFunc(TempS);
            END;
         END;
      InStr := '';
      EvalBracket := TempStatus;
   END;

BEGIN
   FinalStatus := TRUE;

   ACSString := ACSStringIn;
   ACSString := UpcaseStr(ACSString);
   WHILE Pos(' ',ACSString) > 0 DO Delete(ACSString,Pos(' ',ACSString),1);

   IF Pos('^',ACSString) <> 0      THEN FinalStatus := TRUE
   ELSE IF Pos('%',ACSString) <> 0 THEN FinalStatus := FALSE
   ELSE WHILE Length(ACSString) <> 0 DO
      BEGIN
         GetNextStatement(OneState,ACSString);
         TempS := Copy(OneState,2,Length(OneState)-1);
         IF OneState[2] = '(' THEN
            BEGIN
               TempS := Copy(OneState,3,Length(OneState)-3);
               CASE OneState[1] OF
                  '!' : FinalStatus := FinalStatus AND (NOT EvalBracket(TempS));
                  '|' : FinalStatus := FinalStatus OR EvalBracket(TempS);
                  '&' : FinalStatus := FinalStatus AND EvalBracket(TempS);
               END;
            END
         ELSE CASE OneState[1] OF
               '!' : FinalStatus := FinalStatus AND (NOT EvalACSFunc(TempS));
               '|' : FinalStatus := FinalStatus OR EvalACSFunc(TempS);
               '&' : FinalStatus := FinalStatus AND EvalACSFunc(TempS)
               ELSE ACSString := '';
            END;
      END;
   EvaluateACSString := FinalStatus;
END;


FUNCTION ProcessAge(Func,BDay:String):Boolean;
VAR Year,Month,Day,yy,mm,dd,Junk,InAge:Word;
BEGIN
   InAge := ValFunc(Copy(Func,2,Length(Func)-1));
   Year  := ValFunc('19'+Copy(BDay,7,2));
   Month := ValFunc(Copy(BDay,1,2));
   Day   := ValFunc(Copy(BDay,4,2));
   GetDate(yy,mm,dd,Junk);
   yy := yy - Year;
   IF (Month = mm)
      THEN BEGIN
            IF (Day < dd) THEN Dec(yy)
         END
      ELSE IF (mm < Month) THEN Dec(yy);
   ProcessAge := (yy >= InAge)
END;


FUNCTION ProcessConf(Func:String):Boolean;
BEGIN
   MsTg_ConfRead;
   ProcessConf := EvaluateACSString(MsTg_ConfData[Func[2]].ACS);
END;


FUNCTION ProcessARFlag(Func:String; AR:ACRQs):Boolean;
BEGIN
   ProcessARFlag := (Func[2] IN AR);
END;


FUNCTION ProcessGender(Func:String; Sex:Char):Boolean;
BEGIN
   IF (Func[2] = 'F')
      THEN ProcessGender := (Sex = 'F')
      ELSE ProcessGender := (Sex = 'M')
END;


FUNCTION ProcessAcFlag(Func:String):Boolean;
BEGIN
   CASE Func[2] OF
      'L' : ProcessAcFlag := (rlogon        IN MsTg_User.ac);
      'C' : ProcessAcFlag := (rchat         IN MsTg_User.ac);
      'A' : ProcessAcFlag := (ramsg         IN MsTg_User.ac);
      '*' : ProcessAcFlag := (rpostan       IN MsTg_User.ac);
      'E' : ProcessAcFlag := (rpostpvt      IN MsTg_User.ac);
      'N' : ProcessAcFlag := (rpostnet      IN MsTg_User.ac);
      'P' : ProcessAcFlag := (rpost         IN MsTg_User.ac);
      'K' : ProcessAcFlag := (rvoting       IN MsTg_User.ac);
      'M' : ProcessAcFlag := (rmsg          IN MsTg_User.ac);
      'G' : ProcessAcFlag := (rpostecho     IN MsTg_User.ac);
      '1' : ProcessAcFlag := (fnodlratio    IN MsTg_User.ac);
      '2' : ProcessAcFlag := (fnopostratio  IN MsTg_User.ac);
      '3' : ProcessAcFlag := (fnofilepts    IN MsTg_User.ac);
      '4' : ProcessAcFlag := (fnodeletion   IN MsTg_User.ac);
      '5' : ProcessAcFlag := (fnodailyratio IN MsTg_User.ac);
      '6' : ProcessAcFlag := (fnodltime     IN MsTg_User.ac);
      ELSE  ProcessAcFlag := FALSE;
   END
END;


FUNCTION ProcessSL(Func:String; SL:Byte):Boolean;
VAR InSL:Byte; ErrCode:Integer;
BEGIN
   Val(Copy(Func,2,Length(Func)-1),InSL,ErrCode);
   ProcessSL := ((SL >= InSL) AND (ErrCode = 0))
END;


FUNCTION ProcessCalls(Func:String; Calls:Word):Boolean;
BEGIN
   IF ValFunc(Copy(Func,2,Length(Func)-1)) >= 0
      THEN ProcessCalls := Calls >= ValFunc(Copy(Func,2,Length(Func)-1))
      ELSE ProcessCalls := FALSE;
END;


FUNCTION ProcessPosts(Func:String; Posts:Word):Boolean;
BEGIN
   IF ValFunc(Copy(Func,2,Length(Func)-1)) >= 0
      THEN ProcessPosts := Posts >= ValFunc(Copy(Func,2,Length(Func)-1))
      ELSE ProcessPosts := FALSE;
END;


FUNCTION ProcessFP(Func:String; Points:LongInt):Boolean;
BEGIN
   IF ValFunc(Copy(Func,2,Length(Func)-1)) >= 0
      THEN ProcessFP := Points >= ValFunc(Copy(Func,2,Length(Func)-1))
      ELSE ProcessFP := FALSE;
END;


FUNCTION ProcessTimeLeft(Func:String; TimeLeft:Integer):Boolean;
VAR InTime,ErrCode:Integer;
BEGIN
   Val(Copy(Func,2,Length(Func)-1),InTime,ErrCode);
   ProcessTimeLeft := ((TimeLeft >= InTime) AND (ErrCode = 0))
END;


FUNCTION ProcessTime(Func:String):Boolean;
VAR InMins,Hour,Minute,Second,ErrCode:Word;
BEGIN
   Val(Copy(func,2,Length(func)-1),InMins,ErrCode);
   IF (ErrCode = 0)
      THEN BEGIN
            GetTime(Hour,Minute,Second,ErrCode);
            Minute := (Hour * 60) + Minute;
            ProcessTime := (Minute >= InMins)
         END
      ELSE ProcessTime := False
END;


FUNCTION ProcessPCR(func:String):Boolean;
VAR GoodPost,TheirPost:Real;
BEGIN
   GoodPost   := (MsTg_Config.PostRatio[MsTg_User.SL] / 100);
   TheirPost  := (MsTg_User.PubPost / MsTg_User.TotalCalls);
   ProcessPCR := (TheirPost >= GoodPost);
END;


END.
