{$F+,O+}
UNIT MSSQU;

(* 

    MatrixSoft message reading/writing/conversion unit for Squish  

    MSCOMMON is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

INTERFACE

USES  DOS,CRC32,MISC1,MSTRINGS,TGRECORD,UNIXDATE,MYSHARE;

CONST Squ_MaxTxtBuff      = $FFFE;
      Squ_MaxLastReadBuff = 500;
      Squ_HeaderID        = $AFAE4453;  { Header must be this }

      Squ_FrameSize       : Word = SizeOf(SqHdrRec);

VAR   {***  Files and records used for the Squish message bases  ***}

      Squ_IdxFile      : FILE OF SqIndexRec;         { *.SQI file }
      Squ_Idx          : SqIndexRec;
      Squ_PtrFile      : FILE OF SqReadRec;          { *.SQL file }
      Squ_Ptr          : SqReadRec;
      Squ_MsgFile      : FILE;                       { *.SQD file }
      Squ_InfoHdr      : SqBaseRec;
      Squ_MsgFrame     : SqHdrRec;
      Squ_MsgHdr       : SqXmsgRec;

      {***  Other variables used, not specifically for data files ***}

TYPE  Squ_TxtBuffType  = Array[1..Squ_MaxTxtBuff] OF Char;
VAR   Squ_TxtBuff      : ^Squ_TxtBuffType;
      Squ_TxtBuffSize  : ^Word;

      Squ_SqiPos,
      Squ_SqlPos,
      Squ_SqdPos       : LongInt;

      Squ_HeaderSize   : Word;

CONST Squ_BaseLocked   : BOOLEAN = FALSE;  { Don't change this!!! }


{ SQUISH general generic functions }
PROCEDURE MsSqu_InitFiles(BaseFile:String);
PROCEDURE MsSqu_DeInitFiles;
FUNCTION  MsSqu_NumMessages:LongInt;
PROCEDURE MsSqu_CreateMessage;
FUNCTION  MsSqu_HashName(Name:String):Longint;
FUNCTION  MsSqu_DateDos2Squ(d:LongInt):LongInt;

{ SQUISH message base info, frame, header and text manipulation }
PROCEDURE MsSqu_ReadInfoHdr;
PROCEDURE MsSqu_WriteInfoHdr;
PROCEDURE MsSqu_CreateInfoHdr;
PROCEDURE MsSqu_ReadFrame(RecNum:LongInt);
PROCEDURE MsSqu_WriteFrame(RecNum:LongInt);
PROCEDURE MsSqu_ReadHdr(RecNum:LongInt);
PROCEDURE MsSqu_WriteHdr(RecNum:LongInt);
PROCEDURE MsSqu_ReadText;
PROCEDURE MsSqu_WriteText;
PROCEDURE MsSqu_WriteTextLine(Line:String);
FUNCTION  MsSqu_LockBase:Boolean;
FUNCTION  MsSqu_UnLockBase:Boolean;

{ SQUISH index file *.SQI manipulation }
PROCEDURE MsSqu_ReadIdx(RecNum:LongInt);
PROCEDURE MsSqu_WriteIdx(RecNum:LongInt);

{ SQUISH lastread pointer file *.SQL manipulation }
PROCEDURE MsSqu_ReadPtr(RecNum:LongInt);
PROCEDURE MsSqu_WritePtr(RecNum:LongInt);


IMPLEMENTATION


FUNCTION MsSqu_DateDos2Squ(d:LongInt):LongInt;
BEGIN
   MsSqu_DateDos2Squ := (d SHR 16) + ((d AND $FFFF) SHL 16);
END;


FUNCTION MsSqu_HashName(Name:String):Longint;
VAR StrPos : Byte;
    hash,g : LongInt;
BEGIN
   Hash := 0;
   FOR StrPos := 1 TO Length(Name) DO
      BEGIN
         Hash := (Hash SHL 4) + Ord(DownCasE(Name[StrPos]));
         g    := Hash AND $F0000000;
         IF (g <> 0) THEN
            BEGIN
               Hash := Hash OR (g SHR 24);
               Hash := Hash OR g;
            END;
       END;
   MsSqu_HashName := Hash AND $7FFFFFFF;
END;


FUNCTION  MsSqu_NumMessages:LongInt;
BEGIN
   MsSqu_NumMessages := FileSize(Squ_IdxFile);
END;


PROCEDURE MsSqu_InitFiles(BaseFile:String);
{ Initialize (open) all the *.SQ? files }
BEGIN
   Assign(Squ_IdxFile,BaseFile+'.SQI');
   Assign(Squ_PtrFile,BaseFile+'.SQL');
   Assign(Squ_MsgFile,BaseFile+'.SQD');

   FMode(66);

   IF FExists(BaseFile+'.SQI') THEN Reset(Squ_IdxFile)   ELSE Rewrite(Squ_IdxFile);
   IF FExists(BaseFile+'.SQL') THEN Reset(Squ_PtrFile)   ELSE Rewrite(Squ_PtrFile);
   IF FExists(BaseFile+'.SQD') THEN Reset(Squ_MsgFile,1) ELSE Rewrite(Squ_MsgFile,1);

   Squ_SqiPos := 0; Squ_SqlPos := 0; Squ_SqdPos := 0;
END;


PROCEDURE MsSqu_DeInitFiles;
{ Deinitialize (close) all the *.SQ? files }
BEGIN
   {$I-} Close(Squ_IdxFile); Close(Squ_PtrFile); Close(Squ_MsgFile); {$I+}
   Squ_SqiPos := 0; Squ_SqlPos := 0; Squ_SqdPos := 0;
END;


PROCEDURE MsSqu_CreateMessage;
BEGIN
   MsSqu_ReadInfoHdr;

   MsSqu_ReadIdx(FileSize(Squ_IdxFile)-1);
   MsSqu_ReadFrame(Squ_SqiPos);
   Squ_MsgFrame.NextMsg := FileSize(Squ_MsgFile);
   MsSqu_WriteFrame(Squ_SqiPos);

   MsSqu_ReadIdx(FileSize(Squ_IdxFile)-1);
   Squ_InfoHdr.NumMsgs    := Squ_InfoHdr.NumMsgs + 1;
   Squ_InfoHdr.HighMsg    := Squ_InfoHdr.NumMsgs;
   Squ_InfoHdr.EndFrame   := FileSize(Squ_MsgFile);
   Squ_InfoHdr.LastFrame  := Squ_InfoHdr.EndFrame;
   Squ_InfoHdr.LastMsgID  := Squ_InfoHdr.NumMsgs;

   FillChar(Squ_MsgFrame,SizeOf(Squ_MsgFrame),0);
   Squ_MsgFrame.NextMsg     := 0;
   Squ_MsgFrame.PrevMsg     := Squ_Idx.MsgPtr;
   Squ_MsgFrame.FrameLength := SizeOf(Squ_MsgHdr);
   Squ_MsgFrame.MsgLength   := SizeOf(Squ_MsgHdr);
   Squ_MsgFrame.CtrlLength  := 0;
   Squ_MsgFrame.HeaderType  := 0;

   Squ_Idx.MsgPtr    := FileSize(Squ_MsgFile);
   Squ_Idx.MsgID     := Squ_InfoHdr.LastMsgID;
   Squ_Idx.Hash      := MsSqu_HashName(Nul2Str(Squ_MsgHdr.MsgTo,35));

   Squ_MsgHdr.MsgID  := Squ_Idx.MsgID;

   MsSqu_WriteInfoHdr;
   MsSqu_WriteIdx(FileSize(Squ_IdxFile));
   MsSqu_WriteFrame(Squ_SqiPos);
   MsSqu_WriteText;
END;


PROCEDURE MsSqu_ReadInfoHdr;
{ Read the INFO record - the header at the very beginning of *.SQD }
VAR br:Word;
BEGIN
   IF FileSize(Squ_MsgFile) < (SizeOf(Squ_InfoHdr)-124) THEN
      BEGIN
         MsSqu_CreateInfoHdr;
         MsSqu_WriteInfoHdr;
         Exit;
      END;
   Seek(Squ_MsgFile,0); BlockRead(Squ_MsgFile,br,2);
   Seek(Squ_MsgFile,0); BlockRead(Squ_MsgFile,Squ_InfoHdr,Br);
   Seek(Squ_MsgFile,0); Squ_SqdPos := 0;
END;


PROCEDURE MsSqu_WriteInfoHdr;
{ Write the INFO header record to the beginning of the *.SQD file }
BEGIN
   IF FileSize(Squ_MsgFile) > 0 THEN IF NOT MsSqu_LockBase THEN Exit;
   Seek(Squ_MsgFile,0);
   BlockWrite(Squ_MsgFile,Squ_InfoHdr,SizeOf(Squ_InfoHdr));
   Seek(Squ_MsgFile,0);
   MsSqu_UnLockBase;
   Squ_SqdPos := 0;
END;


PROCEDURE MsSqu_CreateInfoHdr;
BEGIN
   FillChar(Squ_InfoHdr,SizeOf(Squ_InfoHdr),#0);
   Squ_InfoHdr.Len_SqBase := SizeOf(Squ_InfoHdr);
   Squ_InfoHdr.EndFrame   := SizeOf(Squ_InfoHdr);
   Squ_InfoHdr.SqHdrSize  := SizeOf(Squ_MsgFrame);
END;


PROCEDURE MsSqu_ReadFrame(RecNum:LongInt);
{ Read one message frame from index position RECNUM }
BEGIN
   MsSqu_ReadIdx(RecNum);
   Squ_SqdPos := Squ_Idx.MsgPtr;
   Seek(Squ_MsgFile,Squ_SqdPos);
   IF SizeOf(Squ_MsgFrame) < Squ_InfoHdr.SqHdrSize
      THEN Squ_FrameSize := SizeOf(Squ_MsgFrame)
      ELSE Squ_FrameSize := Squ_InfoHdr.SqHdrSize;
   BlockRead(Squ_MsgFile,Squ_MsgFrame,Squ_FrameSize);
END;


PROCEDURE MsSqu_WriteFrame(RecNum:LongInt);
{ Writes one message frame to the index position RECNUM - if you're calling }
{ this routine directly, you need to make sure you set the message length   }
{ and previous and next pointers properly.                                  }
BEGIN
   MsSqu_ReadIdx(RecNum);
   Squ_SqdPos := Squ_Idx.MsgPtr;
   IF NOT MsSqu_LockBase THEN Exit;
   Seek(Squ_MsgFile,Squ_SqdPos);
   IF SizeOf(Squ_MsgFrame) < Squ_InfoHdr.SqHdrSize
      THEN Squ_FrameSize := SizeOf(Squ_MsgFrame)
      ELSE Squ_FrameSize := SQu_InfoHdr.SqHdrSize;
   Squ_MsgFrame.SqID := Squ_HeaderID;
   BlockWrite(Squ_MsgFile,Squ_MsgFrame,Squ_FrameSize);
   MsSqu_UnLockBase;
END;


PROCEDURE MsSqu_ReadHdr(RecNum:LongInt);
{ Reads a message hader from index position RECNUM, reading frame first }
BEGIN
   MsSqu_ReadFrame(RecNum);
   Squ_SqdPos := Squ_Idx.MsgPtr+Squ_FrameSize;
   Squ_HeaderSize := SizeOf(Squ_MsgHdr); { blah }
   IF Squ_HeaderSize > SizeOf(Squ_MsgHdr) THEN Squ_HeaderSize := SizeOf(Squ_MsgHdr);
   Seek(Squ_MsgFile,Squ_SqdPos);
   BlockRead(Squ_MsgFile,Squ_MsgHdr,Squ_HeaderSize);
END;


PROCEDURE MsSqu_WriteHdr(RecNum:LongInt);
{ Writes a message to the header file - you MUST have written the index }
{ and message frame records for RECNUM before you call this.            }
BEGIN
   MsSqu_ReadFrame(RecNum);
   Squ_SqdPos := Squ_Idx.MsgPtr+Squ_FrameSize;
   Squ_HeaderSize := SizeOf(Squ_MsgHdr); {Squ_MsgFrame.TotalLength - Squ_MsgFrame.MsgLength;}
   IF NOT MsSqu_LockBase THEN Exit;
   IF Squ_HeaderSize > SizeOf(Squ_MsgHdr) THEN Squ_HeaderSize := SizeOf(Squ_MsgHdr);
   Seek(Squ_MsgFile,SQu_SqdPos);
   BlockWrite(Squ_MsgFile,SQu_MsgHdr,Squ_HeaderSize);
   MsSqu_UnLockBase;
END;


PROCEDURE MsSqu_ReadText;
{ Must have initialized the index and frame before calling this }
BEGIN
   IF (Squ_MsgFrame.MsgLength-SizeOf(Squ_MsgHdr)) < $FFFE
      THEN Squ_TxtBuffSize^ := Squ_MsgFrame.MsgLength-SizeOf(Squ_MsgHdr)
      ELSE Squ_TxtBuffSize^ := $FFFE;
   Seek(Squ_MsgFile,Squ_Idx.MsgPtr+SizeOf(Squ_MsgFrame)+SizeOf(Squ_MsgHdr));
   BlockRead(Squ_MsgFile,Squ_TxtBuff^,Squ_TxtBuffSize^);
   Seek(Squ_MsgFile,Squ_SqdPos);
END;


PROCEDURE MsSqu_WriteText;
{ Must have initialized and written the index and frame before calling this }
BEGIN
   IF NOT MsSqu_LockBase THEN Exit;
   Seek(Squ_MsgFile,Squ_Idx.MsgPtr+SizeOf(Squ_MsgFrame)+Squ_MsgFrame.FrameLength);
   BlockWrite(Squ_MsgFile,Squ_TxtBuff^,Squ_TxtBuffSize^);
   Seek(Squ_MsgFile,Squ_SqdPos);

   Squ_MsgFrame.FrameLength := Squ_MsgFrame.FrameLength + Squ_TxtBuffSize^;
   Squ_MsgFrame.MsgLength   := Squ_MsgFrame.MsgLength   + Squ_TxtBuffSize^;
   MsSqu_WriteFrame(Squ_SqiPos);
   MsSqu_WriteHdr(Squ_SqiPos);

   MsSqu_UnLockBase;
END;


PROCEDURE MsSqu_WriteTextLine(Line:String);
{ Writes a single line to the message text }
BEGIN
   IF NOT MsSqu_LockBase THEN Exit;
   Seek(Squ_MsgFile,Squ_Idx.MsgPtr+SizeOf(Squ_MsgFrame)+Squ_MsgFrame.FrameLength);
   BlockWrite(Squ_MsgFile,Line[1],Length(Line));
   Seek(Squ_MsgFile,Squ_SqdPos);

   Squ_MsgFrame.FrameLength := Squ_MsgFrame.FrameLength + Length(Line);
   Squ_MsgFrame.MsgLength   := Squ_MsgFrame.MsgLength   + Length(Line);
   MsSqu_WriteFrame(Squ_SqiPos);

   MsSqu_UnLockBase;
END;


FUNCTION MsSqu_LockBase:Boolean;
{ Attempt to lock the message file for adding/modifying a message }
VAR Counter:Word;
BEGIN
   IF Squ_BaseLocked OR NOT ShareInstalled THEN
      BEGIN
         MsSqu_LockBase := TRUE;
         Exit; { Base already locked }
      END;
   Counter := 500;
   WHILE NOT LockRec(Squ_MsgFile,0,1) AND (Counter > 0) DO
      BEGIN
         RealDelay(10);
         Dec(Counter);
      END;
   IF Counter > 0 THEN Squ_BaseLocked := TRUE;
   MsSqu_LockBase := Counter > 0;
END;


FUNCTION MsSqu_UnLockBase:Boolean;
{ Attempt to unlock the message file }
VAR Counter:Word;
BEGIN
   IF NOT Squ_BaseLocked OR NOT ShareInstalled THEN
      BEGIN
         MsSqu_UnLockBase := TRUE;
         Exit; { Base already unlocked }
      END;
   Counter := 200;
   WHILE NOT UnLockRec(Squ_MsgFile,0,1) AND (Counter > 0) DO
      BEGIN
         RealDelay(10);
         Dec(Counter);
      END;
   IF Counter > 0 THEN Squ_BaseLocked := FALSE;
   MsSqu_UnLockBase := Counter > 0;
END;


PROCEDURE MsSqu_ReadIdx(RecNum:LongInt);
BEGIN
   Squ_SqiPos := RecNum;
   IF Squ_SqiPos < 0 THEN Squ_SqiPos := 0;
   IF Squ_SqiPos >= FileSize(Squ_IdxFile) THEN Exit;
   Seek(Squ_IdxFile,Squ_SqiPos);
   Read(Squ_IdxFile,Squ_Idx);
END;


PROCEDURE MsSqu_WriteIdx(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(Squ_IdxFile) THEN Exit;
   Squ_SqiPos := RecNum;
   IF Squ_SqiPos < 0 THEN Squ_SqiPos := 0;
   IF NOT MsSqu_LockBase THEN Exit;
   Seek(Squ_IdxFile,Squ_SqiPos);
   Write(Squ_IdxFile,Squ_Idx);
   MsSqu_UnLockBase;
END;


PROCEDURE MsSqu_ReadPtr(RecNum:LongInt);
BEGIN
   IF RecNum >= FileSize(Squ_PtrFile) THEN Exit;
   Squ_SqlPos := RecNum;
   Seek(Squ_PtrFile,RecNum);
   Read(Squ_PtrFile,Squ_Ptr);
   Seek(Squ_PtrFile,RecNum);
END;


PROCEDURE MsSqu_WritePtr(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(Squ_PTrFile) THEN Exit;
   Squ_SqlPos := RecNum;
   Seek(Squ_PtrFile,RecNum);
   Write(Squ_PtrFile,Squ_Ptr);
   Seek(Squ_PtrFile,RecNum);
END;


END.
