UNIT MSMath;

{ Various math related functions (my new math unit, wohoo!)       }

INTERFACE


function RandomTP7(x:Word):Word; { Generates a TP 7.0 random number }
function RandomTP6(x:Word):Word; { Generates a TP 6.0 random number }
function RandReal:Real;          { Same as TP6/TP7 random call }


IMPLEMENTATION


function RandReal:Real;
begin
  RandSeed := RandSeed*134775813+1;
  if RandSeed < 0
    then RandReal := RandSeed/4294967296.0+1.0
    else RandReal := RandSeed/4294967296.0;
end;


function RandomTP7(x:Word):Word;
begin
  RandSeed := RandSeed*134775813+1;
  RandomTP7 := ((RandSeed shr 16)*x+((RandSeed and $FFFF)*x shr 16)) shr 16;
end;


function RandomTP6(x:Word):Word;
begin
  RandSeed := RandSeed*134775813+1;
  RandomTP6 := (RandSeed shr 16) mod x;
end;


end.
