{$F+,O-}
UNIT MSFOSDOS; { MSCOMM }

(* 

    MSCOMMON is Copyright (C) 1993-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

INTERFACE

{ Public procedures/functions - end programs should use the following }
{ routines exclusively.                                               }

{ Most of the identifiers begin with fk_ and are designed to be       }
{ compatible with the FKS FOSSIL library, since I was too lazy to     }
{ make the code properly portable between libraries.                  }

VAR   f:Text;

CONST msFossil    = 0;
      msAsync     = 1;

      CommType    : Byte = 0;  { 0=FOSSIL, 1=ASYNC }
      BaseAddress : Word = 0;  { Base address (ie $3F8) / 0=Look it up in BIOS }
      Irq         : Byte = 0;  { IRQ / 0=Use defaults for specified port }

      fk_StandardInput = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUV'
                        +'WXYZ1234567890~!@#$%^&*()-+\[]{};:`''".,/<> =_?|';
      fk_HighBitInput  = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUV'
                        +'WXYZ1234567890~!@#$%^&*()-+\[]{};:`''".,/<> =_?|'
                        +''
                        +''
                        +'';
      fk_FilenameInput = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUV'
                        +'WXYZ1234567890~!@#$%^&()-_{}.';
      fk_FilespecInput = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUV'
                        +'WXYZ1234567890~!@#$%^&()-_{}.?*';
      fk_FilepathInput = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUV'
                        +'WXYZ1234567890~!@#$%^&()-_{}.?*:\';
      fk_NumberInput   = '123456790.-+';

      fk_DriverVersion = '1.00';
      fk_DriverName    = 'MatrixSoft''s FOSSIL/ASYNC Communications Library';

      AnsiColorArray   : Array[0..7] OF Byte = (0,4,2,6,1,5,3,7);

      ExtTTY           : String[3]='ASC';
      ExtANSI          : String[3]='ANS';
      ExtAvatar        : String[3]='AVT';


VAR   fk_Fossil : RECORD
         Started      : Boolean;
         Port         : LongInt;
         Baud         : LongInt;
         Locked       : LongInt;
         Carrier      : Boolean;
         Driver       : String[80];
         Version      : Byte;
         Revision     : Byte;
      END;

      fk_ProgramInfo : RECORD
         Title        : String[25];
         Version      : String[8];
         Author       : String[20];
         Other        : String[20];
      END;

      fk_Task : RECORD
         System       : String[15];  { OS/2 }
         TaskType     : Byte;        { 0=DOS, 1=DV, 2=OS/2, 3=Windows}
         Window       : Integer;     { unused }
         Share        : Boolean;     { TRUE }
      END;

      fk_Client : RECORD
         BBSName      : String[35];
         Calls        : LongInt;
         CityState    : String[30];
         Downloads    : LongInt;
         FirstDate    : String[8];
         Handle       : String[35];
         HomePhone    : String[15];
         LastDate     : String[8];
         LastTime     : String[5];
         Name         : String[35];
         PageLength   : Byte;
         Password     : String[30];
         RecordPos    : LongInt;
         ScreenType   : Byte;
         Security     : LongInt;
         SysopName    : String[35];
         TimeLeft     : LongInt;
         Uploads      : LongInt;
         WorkPhone    : String[15];
      END;

      fk_Music : RECORD
         MusicType    : Byte;
         NoteLength   : Byte; { Default = 4, Quarter Note }
         Octave       : Byte; { Current Octave, Default=4 }
         Tempo        : Byte; { Tempo }
      END;

      fk_Host : RECORD
         AnsiTimer     : Word;       { Countdown f/ANSI detection (default=2500) }
         Clock         : Boolean;    { Decrease time, increase lastkey }
         CurrentInput  : String[80];
         Error         : Byte;
         ExitCode      : Byte;
         HostScreen    : Boolean;
         HostKey       : Boolean;
         Inactivity    : Word;
         Mono          : Boolean;
         Multinode     : Boolean;
         Node          : Byte;
         OutputChar    : Char;
         OutputLines   : Word;
         RemoteScreen  : Boolean;
         RemoteKey     : Boolean;
         Sound         : Boolean;
         StatusLineBuf : Byte;       { Blank lines before status line }
         StatusLinePos : Byte;       { Position of status line (25) }
         StatusLineMod : Byte;       { Current mode }
         StrictColour  : Boolean;
         TitleLine     : Boolean;
         ValidInput    : String;
         WarningBell   : Boolean;
         WarningTime   : Boolean;

         Colour : RECORD
            More,
            Baud,
            Handle,
            InfoDesc,
            LastKey,
            Multitasker,
            Name,
            Node,
            NoTimeLeft,
            ScreenType,
            StatusLine,
            TimeLeft,
            TitleLine,
            Warning      : Byte;
         END;

         { I don't recommend using these variables }

         CharReady     : Boolean;
         WaitForChar   : Boolean; { Use fk_NoWaitRead instead }
         TimeSlice     : Boolean;

         { Intended to be used internally only }

         Blink         : Boolean; { Current colour attribute settings }
         High          : Boolean;
         LastBg        : Byte;
         LastFg        : Byte;

         SaveX         : Byte;       { Saved cursor location }
         SaveY         : Byte;
         LastKP        : LongInt;
         LastKPVal     : LongInt;
         LastStatDraw  : LongInt;
         LastTimeCheck : LongInt;
         LastTimeVal   : LongInt;
      END;


VAR   fk_LocalInput   : FUNCTION(ch:Char):Char;
      fk_RemoteInput  : FUNCTION(ch:Char):Char;
      fk_MCI          : FUNCTION(s:String):String;
      fk_CarrierLoss  : PROCEDURE;
      fk_TimeOut      : PROCEDURE;
      fk_NoTimeLeft   : PROCEDURE;
      fk_Close        : PROCEDURE;
      fk_Open         : PROCEDURE;


PROCEDURE Ms_DrawStatus;
PROCEDURE Ms_DrawStatusTimes(UnixTime:LongInt);
PROCEDURE Ms_UpdateStatus;
PROCEDURE Ms_WriteString(s:String);
FUNCTION  Ms_ReadAhead:Char;
FUNCTION  Ms_ReadChar:Char;
PROCEDURE Ms_WriteChar(Ch:Char);
FUNCTION  Ms_CheckCarrier:Boolean;

PROCEDURE fk_AnsiMusic(s:String);
PROCEDURE fk_BS(n:integer);
PROCEDURE fk_Clock(b:boolean);
PROCEDURE fk_ClrEol;
PROCEDURE fk_ClrScr;
PROCEDURE fk_DeInitFossil;
FUNCTION  fk_DetectAnsi:Boolean;
FUNCTION  fk_DetectAvatar:Boolean;
PROCEDURE fk_Display(s:String);
PROCEDURE fk_DisplayFile(s:String);
PROCEDURE fk_FlushOutputBuffer;
PROCEDURE fk_GotoXY(x,y:Byte);
PROCEDURE fk_InitFossil(ComPort,Bps,Locked:LongInt; Name,Handle:String; TimeLeft:LongInt; ScreenType,StatusLinePos:Byte);
PROCEDURE fk_InitFossil_DF(StatusLinePos:Byte);
PROCEDURE fk_IdleTick;
FUNCTION  fk_KeyPressed:Boolean;
PROCEDURE fk_LocalBuffer(s:String);
PROCEDURE fk_LocalBufferClear;
PROCEDURE fk_MoveCursor(n:byte; dir:char);
FUNCTION  fk_NoWaitRead:Char;
PROCEDURE fk_PurgeInputBuffer;
PROCEDURE fk_PurgeOutputBuffer;
FUNCTION  fk_Read:Char;
FUNCTION  fk_ReadLn(n:Byte; up:Boolean):String;
PROCEDURE fk_ReadDorInfo(DropPath:String);
PROCEDURE fk_ReadDoorSys(DropPath:String);
PROCEDURE fk_RemoteBuffer(s:String);
PROCEDURE fk_RemoteBufferClear;
FUNCTION  fk_RemoteKeypressed:Boolean;
PROCEDURE fk_RemoteWrite(s:String);
PROCEDURE fk_RemoteWriteLn(s:String; n:Integer);
PROCEDURE fk_TextBackground(n:Byte);
PROCEDURE fk_TextColor(n:Byte);
PROCEDURE fk_TextForeground(n:Byte);
FUNCTION  fk_TimeLeft:String;
PROCEDURE fk_ToggleDTR(Up:Boolean);
PROCEDURE fk_Write(s:String);
PROCEDURE fk_WriteLn(s:String; n:Integer);
PROCEDURE fk_WriteLn_Ansi(s:String; n:Integer);
PROCEDURE fk_WriteLn_Avatar(s:STring; n:Integer);

{ Defaults for variable procedures/functions }

FUNCTION  fkp_Input(Ch:Char):Char;
PROCEDURE fkp_CarrierLoss;
PROCEDURE fkp_TimeOut;
PROCEDURE fkp_NoTimeLeft;
PROCEDURE fkp_Close;
PROCEDURE fkp_Open;
FUNCTION  fkp_MCI(s:String):String;

{ Asynchronous communications routines }

PROCEDURE Ms_AsyncClose;
PROCEDURE Ms_AsyncOpenPort(ComPort:Byte; Baud:LongInt);
PROCEDURE Ms_AsyncFlushOutput;
PROCEDURE Ms_AsyncPurgeInput;
PROCEDURE Ms_AsyncPurgeOutput;
FUNCTION  Ms_AsyncReadChar:Char;
FUNCTION  Ms_AsyncReadAhead:Char;
PROCEDURE Ms_AsyncSetRTS(On:Boolean);
PROCEDURE Ms_AsyncWriteChar(ch:Char);

{ FOSSIL routines }

FUNCTION  Ms_FossilActivatePort:Boolean;
FUNCTION  Ms_FossilCarrier:Boolean;
PROCEDURE Ms_FossilClose;
PROCEDURE Ms_FossilFlowControl(Setting:Byte);
PROCEDURE Ms_FossilFlushOutput;
PROCEDURE Ms_FossilGetDriverInfo;
PROCEDURE Ms_FossilOpenPort(ComPort:Byte; Baud:LongInt);
PROCEDURE Ms_FossilPurgeInput;
PROCEDURE Ms_FossilPurgeOutput;
FUNCTION  Ms_FossilReadNoWait:Char;
FUNCTION  Ms_FossilReadAhead:Char;
PROCEDURE Ms_FossilToggleDtr(Up:Boolean);
PROCEDURE Ms_FossilWriteChar(Ch:Char);
FUNCTION  Ms_FossilWriteCharNoWait(Ch:Char):Boolean;


(***********************************************************************)
                              IMPLEMENTATION
(***********************************************************************)


USES  CRT,DOS,MSTRINGS,MISC1,UNIXDATE,FASTW,MYSHARE;

VAR   BiosPortTable    : Array[1..4] OF Integer ABSOLUTE $0040:0000;
      BiosTimer        : LongInt ABSOLUTE $40:$6C;

CONST RxBufferSize     = 4096;
      TxBufferSize     = 0;
      AsyncTimeout     : Byte = 100;
      ReadUpdateStatus : Boolean = TRUE;  { Redraw status during fk_Read }
      OpenFlag         : Boolean = FALSE; { Is com port open? }

TYPE  pRxBuffer        = ^tRxBuffer;
      tRxBuffer        = Array[1..RxBufferSize] OF Char;

VAR   OriginalVector   : Pointer;  { Data saved when port is opened }
      IrqVector        : Byte;     { IRQ mask }
      IrqMask          : Byte;     { IRQ vector }
      IntCtrl          : Word;

      { Buffer is empty if In=Out.  Otherwise, the routines should       }
      { never let the head go past the tail - if the buffer is full,     }
      { any new characters will be tossed out.  The buffer is s circular }
      { FIFO buffer.  Once In=BufferSize, it goes back to Buffer[0].     }

      RxBuffer         : pRxBuffer;
      RxIn             : Word;  { Where to store next character }
      RxOut            : Word;  { Where to retrieve next character }
      RxLen            : Word;  { Number of chars in queue }

{      TxBuffer         : Array[1..TxBufferSize] OF Char;}
      TxIn             : Word;
      TxOut            : Word;
      TxLen            : Word;

      Uart_IER         : Word;
      Uart_IIR         : Word;
      Uart_LCR         : Word;
      Uart_MCR         : Word;
      Uart_LSR         : Word;
      Uart_MSR         : Word;
      Uart_SPR         : Word;

      Old_IER          : Byte;
      Old_LCR          : Byte;
      Old_MCR          : Byte;
      Old_IntMask      : Byte;

VAR   Regs             : Registers;


(* ------------------------------------------------------------------- *)
(* Internal use only - ASYNC routines                                  *)
(* ------------------------------------------------------------------- *)


PROCEDURE DisableInterrupts; Inline($FA);  { CLI }
PROCEDURE EnableInterrupts;  Inline($FB);  { STI }

(*
PROCEDURE Ms_AsyncIsr; INTERRUPT;
LABEL LOOP;
VAR i,i2:Byte; ch:Char;
BEGIN
   ASM
      LOOP:

      mov  DX,Uart_IIR
      in   AL,DX
      mov  i,AL
      and  AL,01h
      cmp  AL,00h
      jne  @@DONE

      and  i,06h
      shr  i,01h
      cmp  i,02h
      je   @@2
      cmp  i,01h
      je   @@1
      cmp  i,03h
      jmp  @@3
      cmp  i,00h
      jmp  @@0

      @@0:

      mov  DX,Uart_MSR
      in   AL,DX
      jmp  LOOP

      @@3:

      mov  DX,Uart_LSR
      in   AL,DX
      jmp  LOOP

      @@1:

      cmp  TxLen,0
      ja   @@1A
      mov  DX,Uart_IER  { i2 := Port[Uart_IER] AND NOT $02 }
      in   AL,DX
      mov  BL,2
      not  BL
      and  AL,BL
      out  DX,AL
      jmp  LOOP

      @@1A:

      mov  DX,Uart_LSR
      in   AL,DX
      and  AL,20h
      cmp  AL,0
      je   LOOP  { IF Port[Uart_LSR] AND 32 > 0 THEN }

      lea  SI,TxBuffer
      add  SI,TxOut
      mov  AL,[SI]
      mov  DX,BaseAddress
      out  DX,AL
      dec  TxLen
      inc  TxOut
      cmp  TxOut,TxBufferSize
      ja   @@1B
      jmp  LOOP
      @@1B:
      mov TxOut,0
      jmp LOOP

      mov DX,20h
      mov AL,20h
      out DX,AL
   END;
*)
(*
   i := Port[Uart_IIR];
   WHILE i AND $01 = 0 DO
      BEGIN
         CASE (i AND $06) SHR 1 OF
            2 : BEGIN
                   i := Port[BaseAddress];
                   RxBuffer[RxIn] := Chr(i);
                   Inc(RxLen);
                   Inc(RxIn);
                   IF RxIn > RxBufferSize THEN RxIn := 1;
            1 : BEGIN { Transmit register empty - if TX buffer is empty,
                        then disable transmitter to prevent any more
                        transmit interrupts, otherwise send next char }
                   IF (TxLen = 0)
                      THEN BEGIN
                            i := Port[Uart_IER];
                            Port[Uart_IER] := i AND NOT $02;
                         END
                      ELSE IF (Port[Uart_LSR] AND $20) > 0 THEN
                         BEGIN
                            Port[Uart_MCR] := $0B;
                            Time := BiosTimer+AsyncTimeout;
                            WHILE (Port[Uart_MSR] AND $10 = 0) AND (BiosTimer <= Time) DO ;
                            Port[BaseAddress] := Ord(TxBuffer[TxOut]);
                            Inc(TxOut);
                            IF TxOut > TxBufferSize THEN TxOut := 1;
                            Dec(TxLen);
                         END;
                END;

            { These 2 should never be called, but just in case, they }
            { should be handled to prevent an infinite loop }
            3 : i := Port[Uart_LSR];
            0 : i := Port[Uart_MSR];
         END;
         i := Port[Uart_IIR];
      END;
*)
PROCEDURE Ms_AsyncIsr; INTERRUPT;
VAR i:Byte; Time:LongInt; ch:Char;
BEGIN
   i := Port[Uart_IIR];
   WHILE i AND $01 = 0 DO
      BEGIN
         CASE (i AND $06) SHR 1 OF
            2 : BEGIN
                   i := Port[BaseAddress];
                   IF RxLen < RxBufferSize THEN
                      BEGIN
                         RxBuffer^[RxIn] := Chr(i);
                         Inc(RxLen);
                         Inc(RxIn);
                         IF RxIn > RxBufferSize THEN RxIn := 1;
                      END;
                END;
            1 : BEGIN { Transmit register empty - if TX buffer is empty,
                        then disable transmitter to prevent any more
                        transmit interrupts, otherwise send next char }
(*                   IF (TxLen = 0)
                      THEN BEGIN
                            i := Port[Uart_IER];
                            Port[Uart_IER] := i AND NOT $02;
                         END
                      ELSE IF (Port[Uart_LSR] AND $20 > 0) THEN
                         BEGIN
                            Time := BiosTimer+AsyncTimeout;
                            WHILE (Port[Uart_MSR] AND $10 = 0) AND (BiosTimer <= Time) DO ;
                            Port[BaseAddress] := Ord(TxBuffer[TxOut]);
                            Inc(TxOut);
                            IF TxOut > TxBufferSize THEN TxOut := 1;
                            Dec(TxLen);
                         END;*)
                END;
   (*
            2 : ASM
                   mov  DX,BaseAddress       { i := Port[BaseAddress] }
                   in   AL,DX
                   mov  i,AL

                   mov  SI,OFFSET RxBuffer
                   add  SI,RxIn
                   dec  SI
                   mov  [SI],AL
                   mov  AL,i

                   inc  RxLen
                   inc  RxIn
                   cmp  RxIn,RxBufferSize
                   ja   @@2
                   jmp  @@DONE

              @@2: mov  RxIn,1
                   jmp  @@DONE

           @@DONE:
                END;
            1 : ASM

                   cmp TxLen,0
                   je  @Empty

        @NotEmpty: mov DX,Uart_LSR
                   in  AL,DX
                   and AL,20h
                   cmp AL,0
                   je  @@DONE

                   mov DX,Uart_MCR
                   mov AL,0Bh
                   out DX,AL

                   @@LOOP1:

                   mov DX,Uart_MSR
                   in  AL,DX
                   and AL,10h
                   cmp AL,0
                   je  @@LOOP1

                   mov DX,BaseAddress
                   mov SI,OFFSET TxBuffer
                   add SI,TxOut
                   dec SI
                   mov AL,[SI]
                   mov DX,BaseAddress
                   out DX,AL
                   dec TxLen
                   inc TxOut
                   cmp TxOut,TxBufferSize
                   jle @@DONE
                   mov TxOut,1
                   jmp @@DONE

           @Empty: mov DX,Uart_IER
                   in  AL,DX
                   mov i,AL
                   not i
                   and AL,i
                   out DX,AL
                   jmp @@DONE

           @@DONE:
                END;*)

            { These 2 should never be called, but just in case, they }
            { should be handled to prevent an infinite loop }
            3 : i := Port[Uart_LSR];
            0 : i := Port[Uart_MSR];
         END;
         i := Port[Uart_IIR];
      END;
   Port[$20] := $20;
END;


PROCEDURE Ms_AsyncFlushOutput;
BEGIN
END;


PROCEDURE Ms_AsyncPurgeInput;
BEGIN
   DisableInterrupts;
   RxLen := 0;
   RxIn := 1;
   RxOut := 1;
   EnableInterrupts;
END;


PROCEDURE Ms_AsyncPurgeOutput;
BEGIN
   DisableInterrupts;
   TxLen := 0;
   TxIn := 1;
   TxOut := 1;
   EnableInterrupts;
END;


FUNCTION Ms_AsyncReadAhead:Char;
BEGIN
   fk_Host.CharReady := FALSE;
   IF (fk_Fossil.Baud = 0) OR (RxLen=0)
      THEN Ms_AsyncReadAhead := #0
      ELSE BEGIN
            fk_Host.CharReady := TRUE;
            Ms_AsyncReadAhead := RxBuffer^[RxOut];
         END;
END;


FUNCTION Ms_AsyncReadChar:Char;
BEGIN
   fk_Host.CharReady := FALSE;
   IF (fk_Fossil.Baud = 0) OR (RxLen=0)
      THEN Ms_AsyncReadChar := #0
      ELSE BEGIN
            fk_Host.CharReady := TRUE;
            DisableInterrupts;
            Ms_AsyncReadChar := RxBuffer^[RxOut];
            Inc(RxOut);
            IF RxOut > RxBufferSize THEN RxOut := 1;
            Dec(RxLen);
            EnableInterrupts;
         END;
END;


PROCEDURE Ms_AsyncWriteChar(Ch:Char);
VAR i:Byte; Time:LongInt;
BEGIN
   { Wait until ready to send character }
   Time := BiosTimer+AsyncTimeout;
   WHILE (Port[Uart_LSR] AND $20 = 0) AND (BiosTimer <= Time) DO ;
   { Wait for CTS }
   Time := BiosTimer+AsyncTimeout;
   WHILE (Port[Uart_MSR] AND $10 = 0) AND (BiosTimer <= Time) DO ;
   Port[BaseAddress] := Ord(Ch);

(*
   @@LOOP1:  cmp TxLen,TxBufferSize
             jge @@LOOP1

             mov SI,OFFSET TxBuffer
             add SI,TxIn
             dec SI
             mov AL,Ch
             mov [SI],AL
             inc TxLen
             inc TxIn
             cmp TxIn,TxBufferSize
             jle @@DONE
             mov TxIn,1
             jmp @@DONE

     @@DONE:

             mov DX,Uart_IER
             in  AL,DX
             or  AL,02h
             out DX,AL

   WHILE (TxLen >= TxBufferSize) DO ;
   DisableInterrupts;
   TxBuffer[TxIn] := Ch;
   IF TxIn < TxBufferSize THEN Inc(TxIn) ELSE TxIn := 1;
   Inc(TxLen);
   EnableInterrupts;
   Port[Uart_IER] := Port[Uart_IER] OR $02;
   *)
END;


FUNCTION  Ms_AsyncCarrier:Boolean;
BEGIN
   Ms_AsyncCarrier := Port[Uart_MSR] AND $80 <> 0;
END;


FUNCTION  Ms_AsyncWaiting:Boolean;
BEGIN
   Ms_AsyncWaiting := (RxLen > 0);
END;


PROCEDURE Ms_AsyncSetSpeed(Baud:LongInt);
VAR Divisor:Word; i:Byte;
BEGIN
   IF Baud = 0 THEN Baud := 1;
   Divisor := 115200 DIV Baud;
   DisableInterrupts;
   i := Port[Uart_LCR];
   Port [Uart_LCR] := i OR $80;
   Portw[BaseAddress] := Divisor;
   Port [Uart_LCR] := i AND NOT $80;
   EnableInterrupts;
END;


PROCEDURE Ms_AsyncSetParity(ParityType:Byte);
VAR i,j:Byte;
BEGIN
   CASE ParityType OF
      0 : i := $00 OR $03; { 8N1 }
      1 : i := $18 OR $02; { 7E1 }
   END;
   DisableInterrupts;
   j := Port[Uart_LCR];
   Port[Uart_LCR] := j AND $40 OR i;
   EnableInterrupts;
END;


PROCEDURE Ms_AsyncClose;
VAR i:Byte;
BEGIN
   IF OpenFlag THEN
      BEGIN
         OpenFlag := FALSE;
         DisableInterrupts;
         Port[Uart_MCR] := Old_MCR;
         Port[Uart_IER] := Old_IER;
         Port[Uart_LCR] := Old_MCR;
{         i := Port[IntCtrl];}
         Port[IntCtrl] := Old_IntMask;
         SetIntVec(IrqVector,OriginalVector);
         EnableInterrupts;
         IF RxBuffer <> NIL THEN FreeMem(RxBuffer,RXBUFFERSIZE);
         RxBuffer := NIL;
      END;
END;


PROCEDURE Ms_AsyncOpenPort(ComPort:Byte; Baud:LongInt);
VAR i:Byte;
BEGIN
   IF Baud = 0 THEN Exit;

   IF OpenFlag THEN Ms_AsyncClose;
   IF (BaseAddress=0) THEN BaseAddress := BiosPortTable[ComPort];
   IF (Irq=0) THEN Irq := Hi(BaseAddress)+1;

   GetMem(RxBuffer,RXBUFFERSIZE);

   CASE Irq OF
       0..7 : BEGIN
                 IrqVector := Irq+$08;
                 IrqMask := $01 SHL Irq;
                 IntCtrl := $21;
              END;
      8..15 : BEGIN
                 IrqVector := (Irq-$08)+$70;
                 IrqMask := $01 SHL (Irq-$08);
                 IntCtrl := $A1;
              END;
   END;

   RxIn := 1; RxOut := 1; RxLen := 0;
   TxIn := 1; TxOut := 1; TxLen := 0;

   Uart_IER := BaseAddress+$01;
   Uart_IIR := BaseAddress+$02;
   Uart_LCR := BaseAddress+$03;
   Uart_MCR := BaseAddress+$04;
   Uart_LSR := BaseAddress+$05;
   Uart_MSR := BaseAddress+$06;
   Uart_SPR := BaseAddress+$07;

   DisableInterrupts;

   GetIntVec(IrqVector,OriginalVector);
   SetIntVec(IrqVector,@Ms_AsyncIsr);

   i := Port[BaseAddress];
   i := Port[Uart_LSR];

   Old_IER := Port[Uart_IER];
   Old_LCR := Port[Uart_LCR];
   Old_MCR := Port[UArt_MCR];

   Port[Uart_LCR] := $03 { i AND $7F };
   Port[Uart_IER] := $01;
   Port[Uart_MCR] := $0B; { Old_MCR OR $08; { Enable DTR, RTS and OUT2 }

   Old_IntMask := Port[IntCtrl];
   Port[IntCtrl] := Old_IntMask AND (NOT IrqMask);
{   Port[Uart_MSR] := $30;}

   EnableInterrupts;

   Ms_AsyncSetSpeed(Baud);
   Ms_AsyncSetParity(0);

   OpenFlag := TRUE;
END;


PROCEDURE Ms_AsyncRaiseDTR;
BEGIN
   IF fk_Fossil.Baud = 0 THEN Exit;
   DisableInterrupts;
   Port[Uart_MCR] := Port[Uart_MCR] OR 1;
   EnableInterrupts;
END;


PROCEDURE Ms_AsyncLowerDTR;
BEGIN
   IF fk_Fossil.Baud = 0 THEN Exit;
   DisableInterrupts;
   Port[Uart_MCR] := Port[Uart_MCR] AND NOT 1;
   EnableInterrupts;
END;


PROCEDURE Ms_AsyncSetRTS(On:Boolean);
BEGIN
   IF fk_Fossil.Baud = 0 THEN Exit;
   DisableInterrupts;
   IF On
      THEN Port[Uart_MCR] := Port[Uart_MCR] OR $02
      ELSE Port[Uart_MCR] := Port[Uart_MCR] AND NOT $02;
   EnableInterrupts;
END;


(* ------------------------------------------------------------------- *)
(* FOSSIL Driver Routines                                              *)
(* ------------------------------------------------------------------- *)


PROCEDURE Ms_FossilWriteChar(Ch:Char);
BEGIN
   IF fk_Fossil.Baud = 0 THEN Exit;
   FillChar(Regs,SizeOf(Regs),0);
   Regs.AH := $01;
   Regs.AL := Ord(Ch);
   Regs.DX := fk_Fossil.Port-1;
   Intr($14,Regs);
   fk_Host.Error := Regs.AX;
END;


FUNCTION Ms_FossilWriteCharNoWait(Ch:Char):Boolean;
BEGIN
   FillChar(Regs,SizeOf(Regs),0);
   Regs.AH := $0B;
   Regs.AL := Ord(Ch);
   Regs.DX := fk_Fossil.Port-1;
   Intr($14,Regs);
   Ms_FossilWriteCharNoWait := Regs.AX = $0001;
END;


FUNCTION Ms_FossilCarrier:Boolean;
BEGIN
   Regs.AH := $03;
   Regs.DX := fk_Fossil.Port-1;
   Intr($14,Regs);
   Ms_FossilCarrier := (Regs.AL AND $80) = $80;
END;


PROCEDURE Ms_FossilOpenPort(ComPort:Byte; Baud:LongInt);
BEGIN
   IF Baud = 0 THEN Exit;

   Regs.AH := 0;
   Regs.DX := ComPort-1;
   CASE Baud OF
      1200  : Regs.AL := 128;
      2400  : Regs.AL := 160;
      4800  : Regs.AL := 192;
      9600  : Regs.AL := 224;
      19200 : Regs.AL := 0;
      ELSE IF Baud = 38400 THEN Regs.AL := 32;
   END;
   Regs.AL := Regs.AL OR 24;
   Regs.AL := Regs.AL OR $03;
   Intr($14,Regs);
   fk_Host.Error := Regs.AX;
END;


FUNCTION Ms_FossilReadAhead:Char;
BEGIN
   fk_Host.CharReady := FALSE;
   IF fk_Fossil.Baud = 0
      THEN Ms_FossilReadAhead := #0
      ELSE BEGIN
            FillChar(Regs,SizeOf(Regs),0);
            Regs.AH := $0C;
            Regs.DX := fk_Fossil.Port-1;
            Intr($14,Regs);
            IF (Regs.AH = 0)
               THEN BEGIN
                     fk_Host.CharReady := TRUE;
                     Ms_FossilReadAhead := Chr(Regs.AL)
                  END
               ELSE Ms_FossilReadAhead := #0;
         END;
END;


PROCEDURE Ms_FossilFlowControl(Setting:Byte);
{ 0=none, 1=CTS/RTS, 2=XON/XOFF, 3=Both }
BEGIN
   IF fk_Fossil.Baud = 0 THEN Exit;
   FillChar(Regs,SizeOf(Regs),0);
   Regs.AH := $0F;
   Regs.DX := fk_Fossil.Port-1;
   CASE Setting OF
      0 : Regs.AL := $00;
      1 : Regs.AL := $02;
      2 : Regs.AL := $09;
      3 : Regs.AL := $0B;
   END;
   Intr($14,Regs);
END;


FUNCTION Ms_FossilReadNoWait:Char;
VAR ch:Char;
BEGIN
   ch := Ms_FossilReadAhead;
   IF fk_Host.CharReady
      THEN BEGIN
            FillChar(Regs,SizeOf(Regs),0);
            Regs.AH := $02;
            Regs.DX := fk_Fossil.Port-1;
            Intr($14,Regs);
            fk_Host.Error := Regs.AH;
            Ms_FossilReadNoWait := Chr(Regs.AL);
         END
      ELSE Ms_FossilReadNoWait := #0;
END;


FUNCTION Ms_FossilActivatePort:Boolean;
VAR MaxFunc,      { Regs.BL = Maximum function # supported }
    FossRev:Byte; { Regs.BH = Revision of FOSSIL specification supported }
BEGIN
   IF fk_Fossil.Baud = 0 THEN Exit;
   FillChar(Regs,SizeOf(Regs),0);
   Regs.AH := $04;
   Regs.DX := fk_Fossil.Port-1;
   Intr($14,Regs);
   MaxFunc := Regs.BL;
   FossRev := Regs.BH;
   Ms_FossilActivatePort := Regs.AX = $1954;
END;


PROCEDURE Ms_FossilClose;
BEGIN
   IF fk_Fossil.Baud > 0 THEN
      BEGIN
         FillChar(Regs,SizeOf(Regs),0);
         Regs.AH := $05;
         Regs.DX := fk_Fossil.Port-1;
         Intr($14,Regs);
      END;
END;


PROCEDURE Ms_FossilToggleDtr(Up:Boolean);
BEGIN
   IF fk_Fossil.Baud = 0 THEN Exit;
   FillChar(Regs,SizeOf(Regs),0);
   Regs.AH := $06;
   Regs.AL := Byte(Up);
   Regs.DX := fk_Fossil.Port-1;
   Intr($14,Regs);
END;


PROCEDURE Ms_FossilFlushOutput;
BEGIN
   IF fk_Fossil.Baud = 0 THEN Exit;
   FillChar(Regs,SizeOf(Regs),0);
   Regs.AH := $08;
   Regs.DX := fk_Fossil.Port-1;
   Intr($14,Regs);
END;


PROCEDURE Ms_FossilPurgeOutput;
BEGIN
   IF fk_Fossil.Baud = 0 THEN Exit;
   FillChar(Regs,SizeOf(Regs),0);
   Regs.AH := $09;
   Regs.DX := fk_Fossil.Port-1;
   Intr($14,Regs);
END;


PROCEDURE Ms_FossilPurgeInput;
BEGIN
   IF fk_Fossil.Baud = 0 THEN Exit;
   FillChar(Regs,SizeOf(Regs),0);
   Regs.AH := $0A;
   Regs.DX := fk_Fossil.Port-1;
   Intr($14,Regs);
END;


PROCEDURE Ms_FossilGetDriverInfo;
TYPE  DriverInfo = RECORD
         StrucSize        : Word;
         MajorVersion     : Byte;
         CurrentRevision  : Byte;
         IDPtr            : Array[1..2] of Word;
         InputBufferSize  : Word;
         InputBufferFree  : Word;
         OutputBufferSize : Word;
         OutputBufferFree : Word;
         ScreenWidth      : Byte;
         ScreenHieght     : Byte;
         BaudRate         : Byte;
         DriverName       : String[80];
      END;

VAR   Temp       : String[80];  { Return Driver Information in record }
      Segment    : Word;        { Structure Type of DriverInfo        }
      OffSet     : Word;
      InputChr   : Char;
      FossilInfo : DriverInfo;

BEGIN
   Regs.AH := $1B;
   Regs.DX := fk_Fossil.Port-1;
   Regs.ES := Seg(FossilInfo);
   Regs.DI := Ofs(FossilInfo);
   Regs.CX := SizeOf(FossilInfo);
   Intr($14,Regs);
   Segment := FossilInfo.IdPtr[2];
   OffSet  := FossilInfo.IdPtr[1];
   Temp := '';
   InputChr := ' ';
   WHILE Ord(InputChr) <> 0 DO
      BEGIN
         InputChr := Chr(Mem[Segment:OffSet]);
         Inc(OffSet);
         Temp := Temp + InputChr;
      END;
   FossilInfo.DriverName := Temp;
   fk_Fossil.Driver := FossilInfo.DriverName;
   fk_Fossil.Version := FossilInfo.MajorVersion;
   fk_Fossil.Revision := FossilInfo.CurrentRevision;
END;



FUNCTION Ms_LastKeyStr(UnixTime:LongInt):String;
VAR s:String;
BEGIN
   s := StrFunc((UnixTime-fk_Host.LastKP) DIV 60)+':'+LeadingZero((UnixTime-fk_Host.LastKP) MOD 60,2);
   IF (fk_Host.Inactivity = 0) THEN s := '0:00';
   Ms_LastKeyStr := PadLeft(s,' ',5);
END;


FUNCTION Ms_TimeLeftStr:String;
VAR s:String;
BEGIN
   s := StrFunc(fk_Client.TimeLeft DIV 60)+':'+LeadingZero(fk_Client.TimeLeft MOD 60,2);
   Ms_TimeLeftStr := PadLeft(s,' ',7);
END;


PROCEDURE Ms_DrawStatus;
VAR TempX,TempY:Byte;

    PROCEDURE DrawMode1;
    BEGIN
       IF fk_Client.Handle <> fk_Client.Name
          THEN WITH fk_Client,fk_Host DO BEGIN
                WriteFast(12,StatusLinePos,CutTo(Handle,34),Colour.Handle);
                WriteFast(13+Length(Handle),StatusLinePos,CutTo(Name,34-Length(Handle)-2),Colour.Name);
             END
          ELSE WriteFast(12,fk_Host.StatusLinePos,CutTo(fk_Client.Name,34),fk_Host.Colour.Name);

       WriteFast(47,fk_Host.StatusLinePos,'Node',fk_Host.Colour.InfoDesc);
       IF fk_Host.Node > 99
          THEN WriteFast(51,fk_Host.StatusLinePos,StrFunc(fk_Host.Node),fk_Host.Colour.Node)
          ELSE WriteFast(52,fk_Host.StatusLinePos,StrFunc(fk_Host.Node),fk_Host.Colour.Node);

       IF fk_Fossil.Baud = 0
          THEN WriteFast(55,fk_Host.StatusLinePos,'Local',fk_Host.Colour.Baud)
          ELSE WriteFast(55,fk_Host.StatusLinePos,StrFunc(fk_Fossil.Baud),fk_Host.Colour.Baud);
    END;

    PROCEDURE DrawMode2;
    VAR s:String;
    BEGIN
       s := '`1B';
       IF fk_Fossil.Baud = 0 THEN s := s+'Local' ELSE s := s+StrFunc(fk_Fossil.Baud);
       s := s+' `19`1B COM'+StrFunc(fk_Fossil.Port)+' `19`1B '+fk_Task.System;
       IF fk_Task.Share THEN s := s+' `19`1B SHARE';
       CASE fk_Client.ScreenType OF
          0 : s := s+' `19`1B TTY';
          1 : s := s+' `19`1B Ansi';
          2 : s := s+' `19`1B AVT';
       END;
       WriteColorFast(12,fk_Host.StatusLinePos,s);
    END;

    PROCEDURE DrawMode3;
    BEGIN
       WriteColorFast(12,fk_Host.StatusLinePos,
                      '`1BALT`19-`1BJ `19Shell  '+
                      '`1BALT`19-`1BC `19Chat  '+
                      '`1BALT+`19/`1B- `195 mins');
    END;

BEGIN
   IF fk_Host.StatusLinePos = 0 THEN Exit;

   TempX := WhereX;
   TempY := WhereY;

   IF (fk_Host.StatusLinePos > 10)
      THEN BEGIN
            Window(1,1,80,fk_Host.StatusLinePos-1-fk_Host.StatusLineBuf);
            FastClr(' ',1,fk_Host.StatusLinePos-fk_Host.StatusLineBuf,80,fk_Host.StatusLinePos-1,0);
            FastClr(' ',1,fk_Host.StatusLinePos,80,fk_Host.StatusLinePos,fk_Host.Colour.StatusLine);
         END
      ELSE IF (fk_Host.StatusLinePos > 0) THEN
         BEGIN
            Window(1,fk_Host.StatusLinePos+1+fk_Host.StatusLineBuf,80,25);
            FastClr(' ',1,fk_Host.StatusLinePos+1,80,fk_Host.StatusLinePos+fk_Host.StatusLineBuf,0);
            FastClr(' ',1,fk_Host.StatusLinePos,80,fk_Host.StatusLinePos,fk_Host.Colour.StatusLine);
         END;
   WriteFast(2,fk_Host.StatusLinePos,'['+#27#26+'=more]',fk_Host.Colour.More);

   IF (fk_Host.StatusLineMod < 1) OR (fk_Host.StatusLineMod > 3) THEN fk_Host.StatusLineMod := 1;
   CASE fk_Host.StatusLineMod OF
      1 : DrawMode1;
      2 : DrawMode2;
      3 : DrawMode3;
   END;

   WriteFast(61,fk_Host.StatusLinePos,'KP:',fk_Host.Colour.InfoDesc);
   WriteFast(70,fk_Host.StatusLinePos,'TL:',fk_Host.Colour.InfoDesc);

   fk_Host.LastStatDraw := CurrentSecsFunc;
   Ms_DrawStatusTimes(fk_Host.LastStatDraw);
   GotoXY(TempX,TempY);
END;


PROCEDURE Ms_DrawStatusTimes(UnixTime:LongInt);
BEGIN
   IF fk_Host.StatusLinePos = 0 THEN Exit;

   IF fk_Host.WarningBell AND (fk_Host.Inactivity > 20) AND fk_Host.Clock
      THEN WriteFast(64,fk_Host.StatusLinePos,Ms_LastKeyStr(UnixTime),fk_Host.Colour.Warning)
      ELSE IF (UnixTime-fk_Host.LastKP >= 15) AND (fk_Host.Inactivity > 20) AND fk_Host.Clock
         THEN WriteFast(64,fk_Host.StatusLinePos,Ms_LastKeyStr(UnixTime),fk_Host.Colour.LastKey)
         ELSE WriteFast(64,fk_Host.StatusLinePos,PadLeft('0:00',' ',5),fk_Host.Colour.LastKey);

   IF fk_Host.WarningTime AND fk_Host.Clock
      THEN WriteFast(73,fk_Host.StatusLinePos,Ms_TimeLeftStr,fk_Host.Colour.Warning)
      ELSE WriteFast(73,fk_Host.StatusLinePos,Ms_TimeLeftStr,fk_Host.Colour.TimeLeft);
END;


PROCEDURE Ms_UpdateStatus;
VAR OldTime,OldKP,i:LongInt; DrawTimes:Boolean;

   PROCEDURE UpdateTimes;
   BEGIN
      OldTime := fk_Client.TimeLeft;
      OldKP := i-fk_Host.LastKP;
      IF fk_Host.Clock
         THEN BEGIN
               fk_Client.TimeLeft := fk_Host.LastTimeVal-(i-fk_Host.LastTimeCheck);
               IF fk_Client.TimeLeft <= 0 THEN fkp_NoTimeLeft;
               IF (i-fk_Host.LastKP > fk_Host.Inactivity) AND (fk_Host.Inactivity > 20) THEN fk_TimeOut;
               fk_Host.LastKPVal := i-fk_Host.LastKP;
            END
         ELSE BEGIN
               fk_Host.LastTimeCheck := i;
               fk_Host.LastTimeVal := fk_Client.TimeLeft;
               fk_Host.LastKPVal := i-fk_Host.LastKP;
            END;
      DrawTimes := (OldTime <> fk_Client.TimeLeft) OR (OldKP <> fk_Host.LastKPVal);
   END;

BEGIN
   IF (fk_Fossil.Port > 0) AND (fk_Fossil.Baud > 0) AND NOT Ms_CheckCarrier THEN fkp_CarrierLoss;
   i := CurrentSecsFunc;
   UpdateTimes;
   IF (i-fk_Host.LastStatDraw) > 30
      THEN Ms_DrawStatus
      ELSE IF DrawTimes
         THEN Ms_DrawStatusTimes(i);
END;


PROCEDURE Ms_WriteString(s:String);
VAR i:Byte;
BEGIN
   IF Length(s) > 0 THEN
      FOR i := 1 TO Length(s) DO Ms_WriteChar(s[i]);
END;


FUNCTION  Ms_ReadAhead:Char;
BEGIN
   IF fk_Fossil.Baud > 0
      THEN CASE CommType OF
            0 : Ms_ReadAhead := Ms_FossilReadAhead;
            1 : Ms_ReadAhead := Ms_AsyncReadAhead;
         END
      ELSE Ms_ReadAhead := #0;
END;


FUNCTION  Ms_ReadChar:Char;
VAR Ch:Char;
BEGIN
   IF fk_Fossil.Baud > 0
      THEN CASE CommType OF
            0 : ch := Ms_FossilReadNoWait;
            1 : ch := Ms_AsyncReadChar;
         END
      ELSE Ch := #0;
   Ms_ReadChar := ch;
END;


PROCEDURE Ms_WriteChar(Ch:Char);
BEGIN
   IF fk_Fossil.Baud > 0 THEN
      CASE CommType OF
         0 : Ms_FossilWriteChar(Ch);
         1 : Ms_AsyncWriteChar(Ch);
      END;
END;


FUNCTION Ms_CheckCarrier:Boolean;
BEGIN
   IF fk_Fossil.Baud > 0
      THEN CASE CommType OF
            0 : Ms_CheckCarrier := Ms_FossilCarrier;
            1 : Ms_CheckCarrier := Ms_AsyncCarrier;
         END
      ELSE Ms_CheckCarrier := TRUE;
END;


PROCEDURE Ms_InitOS;
VAR i:Word;

    PROCEDURE InitOS; ASSEMBLER;
    ASM
       mov fk_Task.TaskType,0  { Default DOS }
       mov ah,30h
       int 21h                 { DOS version }
       cmp al,14h
       jae @IBMOS2

       mov ax,2B01h
       mov cx,4445h
       mov dx,5351h
       int 21h
       cmp al,255
       jne @DesqView { Jump if AL <> 255 }

       mov ax,160Ah
       int 2Fh
       cmp ax,0h
       je  @Windows
       jmp @Finish

    @IBMOS2:

       mov fk_Task.TaskType,2
       jmp @Finish

    @DesqView:

       mov fk_Task.TaskType,1
       jmp @Finish

    @Windows:

       mov fk_Task.TaskType,3
       jmp @Finish

    @FINISH:

    END;

BEGIN
   Regs.AH := $30;
   Intr($21,Regs); { Check for DOS }

   fk_Task.TaskType := 0;
   fk_Task.System := 'MS-DOS '+StrFunc(Regs.AL)+'.'+StrFunc(Regs.AH);

   IF Regs.AL >= $14
      THEN BEGIN
            fk_Task.TaskType := 2; { OS/2 }
            Regs.AX := $3306;
            Intr($21,Regs);
            fk_Task.System := 'OS/2 '+StrFunc(Regs.BL DIV 10)+'.'+StrFunc(Regs.BH DIV 10);
         END
      ELSE BEGIN
            Regs.AX := $2B01;
            Regs.CX := $4445;
            Regs.DX := $5351;
            Intr($21,Regs); { Check for DV }

            IF Regs.AL <> $FF
               THEN BEGIN
                     fk_Task.TaskType := 1; { DV }
                     fk_Task.System := 'DESQview '+StrFunc(Regs.BH)+'.'+StrFunc(Regs.BL);
                  END
               ELSE BEGIN
                     Regs.AX := $160A;
                     Intr($2F,Regs);
                     IF Regs.AX = 0 THEN
                        BEGIN
                           fk_Task.TaskType := 3;
                           fk_Task.System := 'Windows '+StrFunc(Regs.BH)+'.'+StrFunc(Regs.BL);
                        END;
                  END;
         END;
END;


PROCEDURE Ms_VarsInit_Fossil;
BEGIN
   fk_Fossil.Started := FALSE;
   fk_Fossil.Port := 0;
   fk_Fossil.Baud := 0;
   fk_Fossil.Locked := 0;
   fk_Fossil.Carrier := FALSE;
   fk_Fossil.Driver := '';
   fk_Fossil.Version := 0;
   fk_Fossil.Revision := 0;
END;


PROCEDURE Ms_VarsInit_ProgramInfo;
BEGIN
   fk_ProgramInfo.Title := 'Unknown Program';
   fk_ProgramInfo.Version := '1.00';
   fk_ProgramInfo.Author := 'Lars Hellsten';
   fk_ProgramInfo.Other := '';
END;


PROCEDURE Ms_VarsInit_Task;
BEGIN
   fk_Task.System := 'DOS';
   fk_Task.TaskType := 0;
   fk_Task.Window := 0;
   fk_Task.Share := MyShare.ShareInstalled;
   MS_InitOS;
END;


PROCEDURE Ms_VarsInit_Client;
BEGIN
   FillChar(fk_Client,SizeOf(fk_Client),0);
END;


PROCEDURE Ms_VarsInit_Music;
BEGIN
   FillChar(fk_Music,SizeOf(fk_Music),0);
   fk_Music.NoteLength  := 4;
   fk_Music.Octave := 4;
   fk_Music.Tempo := 120;
END;


PROCEDURE Ms_VarsInit_Host;
BEGIN
   FillChar(fk_Host,SizeOf(fk_Host),0);
   fk_Host.AnsiTimer := 2500;
   fk_Host.Clock := TRUE;
   fk_Host.HostScreen := TRUE;
   fk_Host.HostKey := TRUE;
   fk_Host.Inactivity := 180;
   fk_Host.SaveX := 1;
   fk_Host.SaveY := 1;
   fk_Host.LastBG := 0;
   fk_Host.LastFG := 7;
   fk_Host.LastKP := CurrentSecsFunc;
   fk_Host.LastStatDraw := fk_Host.LastKP;
   fk_Host.LastTimeCheck := fk_Host.LastKP;
   fk_Host.Multinode := TRUE;
   fk_Host.RemoteScreen := TRUE;
   fk_Host.RemoteKey := TRUE;
   fk_Host.Sound := TRUE;
   fk_Host.StatusLineBuf := 1;
   fk_Host.StatusLinePos := 25;
   fk_Host.StatusLineMod := 1;
   fk_Host.StrictColour := TRUE;
   fk_Host.TimeSlice := TRUE;
   fk_Host.TitleLine := FALSE;
   fk_Host.ValidInput := fk_HighBitInput;
   fk_Host.WaitForChar := TRUE;
   fk_Host.WarningBell := FALSE;
   fk_Host.WarningTime := FALSE;

   fk_Host.Colour.More := $19;
   fk_Host.Colour.Baud := $19;
   fk_Host.Colour.Handle := $1B;
   fk_Host.Colour.InfoDesc := $19;
   fk_Host.Colour.LastKey := $1B;
   fk_Host.Colour.Multitasker := $19;
   fk_Host.Colour.Name := $1E;
   fk_Host.Colour.Node := $19;
   fk_Host.Colour.NoTimeLeft := $1C;
   fk_Host.Colour.ScreenType := $19;
   fk_Host.Colour.StatusLine := $19;
   fk_Host.Colour.TimeLeft := $1B;
   fk_Host.Colour.TitleLine := $1B;
   fk_Host.Colour.Warning := $1C;
END;


PROCEDURE fk_AnsiMusic(s:String);
BEGIN
END;


PROCEDURE fk_BS(n:integer);
BEGIN
   fk_Write(RepChar(#8,n));
   fk_Write(RepChar(#32,n));
   fk_Write(RepChar(#8,n));
END;


PROCEDURE fk_Clock(b:boolean);
BEGIN
   Ms_UpdateStatus;
   IF b=FALSE THEN
      BEGIN
         fk_Host.WarningBell := FALSE;
         fk_Host.WarningTime := FALSE;
      END;
   fk_Host.LastKP := CurrentSecsFunc;
   IF fk_Host.Clock=FALSE THEN fk_Host.LastTimeCheck := CurrentSecsFunc;
   fk_Host.Clock := b;
   Ms_UpdateStatus;
END;


PROCEDURE fk_ClrEol;
BEGIN
   CASE fk_Client.ScreenType OF
      1 : BEGIN
             Ms_WriteString(#27+'[K');
             ClrEol;
          END;
      2 : BEGIN
             Ms_WriteString(^V^G);
             ClrEol;
          END;
   END;
END;


PROCEDURE fk_ClrScr;
BEGIN
   CASE fk_Client.ScreenType OF
      1  : Ms_WriteString(#27+'[2J');
      ELSE Ms_WriteString(#12);
   END;
   ClrScr;
   fk_TextColor(7);
   Ms_DrawStatus;
END;


PROCEDURE fk_DeInitFossil;
BEGIN
   IF fk_Fossil.Baud > 0 THEN
      CASE CommType OF
         0 : Ms_FossilClose;
         1 : Ms_AsyncClose;
      END;
   fk_Close;
END;


FUNCTION  fk_DetectAnsi:Boolean;
VAR s             : String;
    DelayNum      : LongInt;
BEGIN
   IF (fk_Fossil.Baud = 0) THEN
       BEGIN
          fk_DetectAnsi := TRUE;
          Exit;
       END;

   Ms_WriteString(#27+'[6n'+RepChar(#8,4)+RepChar(#32,4)+RepChar(#8,4));

   s := '!!!';
   DelayNum := 0;
   REPEAT
      RealDelay(10);
      DelayNum := DelayNum + 10;
      IF fk_RemoteKeypressed THEN s[1] := fk_NoWaitRead;
      IF (s[1] = #27) THEN
         REPEAT
            RealDelay(10);
            DelayNum := DelayNum + 10;
            IF fk_RemoteKeypressed THEN s[2] := fk_NoWaitRead;
            IF (s[1] = '[') THEN
               REPEAT
                  RealDelay(10);
                  DelayNum := DelayNum + 10;
                  IF fk_RemoteKeyPressed THEN s[3] := fk_NoWaitRead;
               UNTIL (DelayNum > fk_Host.AnsiTimer) OR (s[3] = 'R');
         UNTIL (DelayNum > fk_Host.AnsiTimer) OR (s[2] = '[');
   UNTIL (DelayNum > fk_Host.AnsiTimer) OR (s[1] = #27);
   fk_DetectAnsi := (fk_Fossil.Baud = 0) OR (s = #27+'[R');
END;


FUNCTION  fk_DetectAvatar:Boolean;
BEGIN
END;


PROCEDURE fk_Display(s:String);
VAR f:Text; Line:String;
BEGIN
   IF NOT FExists(s) THEN Exit;
   Assign(f,s);
   Reset(f);
   WHILE NOT Eof(f) DO
      BEGIN
         ReadLn(f,Line);
         fk_WriteLn(Line,1);
         Inc(fk_Host.OutputLines);
      END;
   Close(f);
END;


PROCEDURE fk_DisplayFile(s:String);
BEGIN
   CASE fk_Client.ScreenType OF
      0 : fk_Display(s+'.'+ExtTTY);
      1 : IF FExists(s+'.'+ExtANSI)
             THEN fk_Display(s+'.'+ExtANSI)
             ELSE fk_Display(s+'.'+ExtTTY);
      2 : IF FExists(s+'.'+ExtAvatar)
             THEN fk_Display(s+'.'+ExtAvatar)
             ELSE fk_Display(s+'.'+ExtTTY);
   END;
END;


PROCEDURE fk_PurgeInputBuffer;
VAR ch:Char;
BEGIN
   CASE CommType OF
      0 : Ms_FossilPurgeInput;
      1 : Ms_AsyncPurgeInput;
   END;
   WHILE KeyPressed DO ch := ReadKey;
   fk_Host.LastKP := CurrentSecsFunc;
END;


PROCEDURE fk_PurgeOutputBuffer;
BEGIN
   CASE CommType OF
      0 : Ms_FossilPurgeOutput;
      1 : Ms_AsyncPurgeOutput;
   END;
END;


PROCEDURE fk_FlushOutputBuffer;
BEGIN
   CASE CommType OF
      0 : Ms_FossilFlushOutput;
      1 : Ms_AsyncFlushOutput;
   END;
END;


PROCEDURE fk_GotoXY(x,y:Byte);
BEGIN
   CASE fk_Client.ScreenType OF
      1 : Ms_WriteString(#27+'['+StrFunc(y)+';'+StrFunc(x)+'H');
      2 : Ms_WriteString(^V^H+Chr(y)+Chr(x));
   END;
   IF fk_Client.ScreenType <> 0 THEN GotoXY(x,y);
END;


PROCEDURE fk_InitFossil(ComPort,Bps,Locked:LongInt; Name,Handle:String; TimeLeft:LongInt; ScreenType,StatusLinePos:Byte);

    PROCEDURE InitVars;
    BEGIN
       fk_Host.Error := 0;
       fk_Fossil.Driver := 'MatrixSoft''s DOS Communications Library';
       fk_Fossil.Version := 0;
       fk_Fossil.Revision := 0;
       fk_Fossil.Started := TRUE;
       fk_Fossil.Port := ComPort;
       fk_Fossil.Baud := Bps;
       fk_Fossil.Locked := Locked;
       IF fk_Fossil.Port = 0 THEN fk_Fossil.Baud := 0;
       IF fk_Fossil.Port = 0 THEN fk_Fossil.Locked := 0;
       fk_Client.Name := Name;
       fk_Client.Handle := Handle;
       fk_Client.TimeLeft := TimeLeft;
       fk_Client.ScreenType := ScreenType;
       fk_Host.StatusLinePos := StatusLinePos;
       fk_Host.Error := 0;
       fk_Host.LastKP := CurrentSecsFunc;
       fk_Host.LastTimeVal := fk_Client.TimeLeft;
       fk_Host.LastTimeCheck := CurrentSecsFunc;
    END;

    PROCEDURE InitPort;
    BEGIN
       CASE CommType OF
          0 : BEGIN
{                 Ms_FossilOpenPort(fk_Fossil.Port,fk_Fossil.Baud);}
                 IF (NOT Ms_FossilActivatePort) AND (fk_Host.Error = 0) THEN fk_Host.Error := 10;
                 Ms_FossilGetDriverInfo;
                 Ms_FossilFlowControl(0);
              END;
          1 : BEGIN
                 Ms_AsyncOpenPort(fk_Fossil.Port,fk_Fossil.Locked);
{                 IF (OpenFlag=FALSE)
                    THEN fk_Host.Error := 2
                    ELSE Ms_AsyncSetBaud(9600);}
              END;
       END;
    END;

BEGIN
   InitVars;
   IF (fk_Fossil.Port > 0) AND (fk_Fossil.Baud > 0) THEN InitPort;
   Ms_DrawStatus;
   fk_Open;
END;


PROCEDURE fk_InitFossil_DF(StatusLinePos:Byte);
BEGIN
   WITH fk_Fossil,fk_Client DO
      fk_InitFossil(fk_Fossil.Port,fk_Fossil.Baud,fk_Fossil.Locked,Name,Handle,TimeLeft,ScreenType,StatusLinePos);
END;


PROCEDURE fk_IdleTick; ASSEMBLER;
ASM
   cmp fk_Task.TaskType,0
   je  @@DOS
   cmp fk_Task.TaskType,1
   je  @@DV
   mov AX,1680h
   int 2Fh
   jmp @@DONE

   @@DOS:

   int 28h
   jmp @@DONE

   @@DV:

   mov AX,1000h
   int 15h

   @@DONE:

(*
VAR Regs:Registers;
BEGIN
   CASE fk_Task.TaskType OF
      0 : Intr($28,Regs);       { Give up MS-DOS idle tick }
      1 : ASM
             mov AX,1000h
             int 15h         { DV }
          END;
    2,3 : ASM
             mov AX,1680h
             int 2Fh        { Windows and OS/2 }
          END;
   END;*)
END;


FUNCTION  fk_KeyPressed:Boolean;
BEGIN
   fk_KeyPressed := KeyPressed OR fk_RemoteKeyPressed;
END;


PROCEDURE fk_LocalBuffer(s:String);
BEGIN
END;


PROCEDURE fk_LocalBufferClear;
BEGIN
END;


PROCEDURE fk_MoveCursor(n:byte; dir:char);
VAR i:Byte;
BEGIN
   CASE fk_Client.ScreenType OF
      1 : CASE Dir OF
             'U' : Ms_WriteString(#27+'['+StrFunc(n)+'A');
             'D' : Ms_WriteString(#27+'['+StrFunc(n)+'B');
             'L' : Ms_WriteString(#27+'['+StrFunc(n)+'D');
             'R' : Ms_WriteString(#27+'['+StrFunc(n)+'C');
          END;
      2 : CASE Dir OF
             'U' : IF n > 0 THEN FOR i := 1 TO n DO Ms_WriteString(^V^C);
             'D' : IF n > 0 THEN FOR i := 1 TO n DO Ms_WriteString(^V^D);
             'L' : IF n > 0 THEN FOR i := 1 TO n DO Ms_WriteString(^V^E);
             'R' : IF n > 0 THEN FOR i := 1 TO n DO Ms_WriteString(^V^F);
          END;
   END;
   IF fk_Client.ScreenType <> 0 THEN
      CASE Dir OF
         'U' : GotoXY(WhereX,WhereY-n);
         'D' : GotoXY(WhereX,WhereY+n);
         'L' : GotoXY(WhereX-n,WhereY);
         'R' : GotoXY(WhereX+n,WhereY);
      END;
END;


FUNCTION fk_NoWaitRead:Char;
VAR ch:Char;
BEGIN
   IF (fk_Host.Inactivity <= 20) THEN fk_Host.LastKP := CurrentSecsFunc;
   IF fk_RemoteKeyPressed AND fk_Host.RemoteKey
      THEN BEGIN
            ch := Ms_ReadChar;
            fk_Host.LastKP := CurrentSecsFunc;
            fk_NoWaitRead := fk_RemoteInput(ch);
            fk_Host.CharReady := TRUE;
         END
      ELSE IF CRT.KeyPressed AND fk_Host.HostKey
         THEN BEGIN
               fk_Host.LastKP := CurrentSecsFunc;
               ch := fk_LocalInput(ReadKey);
               fk_NoWaitRead := ch;
               fk_Host.CharReady := TRUE;
            END
         ELSE BEGIN
               fk_Host.CharReady := FALSE;
               fk_NoWaitRead := #0;
            END;
END;


FUNCTION fk_Read:Char;
BEGIN
   IF (fk_Fossil.Port > 0) AND (fk_Fossil.Baud > 0) AND NOT Ms_CheckCarrier THEN fkp_CarrierLoss;
   WHILE (fk_Host.WaitForChar=TRUE) AND (fk_KeyPressed=FALSE) DO
      BEGIN
         Ms_UpdateStatus;
         IF fk_Host.TimeSlice THEN fk_IdleTick;
      END;
   fk_Read := fk_NoWaitRead;
END;


PROCEDURE fk_ReadDORINFO(DropPath:String);
VAR s:String; f:Text;
BEGIN
   IF NOT FExists(AddSlash(DropPath)+'DORINFO1.DEF') THEN
      BEGIN
         fk_Host.Error := 2;
         Exit;
      END;

   Assign(f,AddSlash(DropPath)+'DORINFO1.DEF');
   Reset(f);

   ReadLn(f,s);  fk_Client.BBSName := s;
   ReadLn(f,s);  fk_Client.SysopName := s;
   ReadLn(f,s);  fk_Client.SysopName := fk_Client.SysopName+' '+s;
   ReadLn(f,s);  fk_Fossil.Port := ValFunc(s[4]);
   ReadLn(f,s);  fk_Fossil.Baud := ValFunc(GetWord(s,1));
   ReadLn(f,s);  { Node/Junk }
   ReadLn(f,s);  fk_Client.Name := s;
   ReadLn(f,s);  fk_Client.Name := fk_Client.Name+' '+s;
   ReadLn(f,s);  fk_Client.CityState := s;
   ReadLn(f,s);  fk_Client.ScreenType := ValFunc(s);
   ReadLn(f,s);  fk_Client.Security := ValFunc(s);
   ReadLn(f,s);  fk_Client.TimeLeft := ValFunc(s)*60;

   fk_Client.Handle := fk_Client.Name;
   Close(f);
END;


PROCEDURE fk_ReadDOORSYS(DropPath:String);
VAR s:String; f:Text;
BEGIN
   IF NOT FExists(AddSlash(DropPath)+'DOOR.SYS') THEN
      BEGIN
         fk_Host.Error := 2;
         Exit;
      END;

   Assign(f,AddSlash(DropPath)+'DOOR.SYS');
   Reset(f);

   ReadLn(f,s);  fk_Fossil.Port := ValFunc(s[4]);
   ReadLn(f,s);  fk_Fossil.Baud := ValFunc(s);
   ReadLn(f,s);  { Data Bits }
   ReadLn(f,s);  fk_Host.Node := ValFunc(s);
   ReadLn(f,s);  fk_Fossil.Locked := ValFunc(s);
   ReadLn(f,s);  { Screen display; Y=ON, N=OFF }
   ReadLn(f,s);  { Printer toggle; Y=ON, N=OFF }
   ReadLn(f,s);  { Page bell; Y=ON, N=OFF }
   ReadLn(f,s);  { Caller alarm; Y=ON, N=OFF }
   ReadLn(f,s);  fk_Client.Name := s;  fk_Client.Handle := s;
   ReaDLn(f,s);  fk_Client.CityState := s;
   ReadLn(f,s);  fk_Client.HomePhone := s;
   ReadLn(f,s);  fk_Client.WorkPhone := s;
   ReadLn(f,s);  fk_Client.Password := s;
   ReadLn(f,s);  fk_Client.Security := ValFunc(s);
   ReadLn(f,s);  fk_Client.Calls := ValFunc(s);
   ReadLn(f,s);  fk_Client.LastDate := s;
   ReadLn(f,s);  fk_Client.TimeLeft := ValFunc(s);
   ReadLn(f,s);  { Time left in minutes }
   ReadLn(f,s);  IF s='GR' THEN fk_Client.ScreenType := 1 ELSE fk_Client.ScreenType := 0;
   ReadLn(f,s);  fk_Client.PageLength := ValFunc(s);
   ReadLn(f,s);  { Expert mode }
   ReadLn(f,s);  { Junk }
   ReadLn(f,s);  { Junk }
   ReadLn(f,s);  { Expiration date }
   ReadLn(f,s);  fk_Client.RecordPos := ValFunc(s);
   ReadLn(f,s);  { Default p rotocol }
   ReadLn(f,s);  fk_Client.Uploads := ValFunc(s);
   ReadLn(f,s);  fk_Client.Downloads := ValFunc(s);

   IF NOT Eof(f) THEN ReadLn(f,s);  { Daily k-byte total }
   IF NOT Eof(f) THEN ReadLn(f,s);  { Daily k-byte maximum }
   IF NOT Eof(f) THEN ReadLn(f,s);  { Birthdate 00/00/00 }
   IF NOT Eof(f) THEN ReadLn(f,s);  { Junk }
   IF NOT Eof(f) THEN ReadLn(f,s);  { Junk }

   IF NOT Eof(f) THEN
      BEGIN
         ReadLn(f,s);
         fk_Client.SysopName := s;
      END;

   IF NOT Eof(f) THEN ReadLn(f,s);  { Sysop alias }
   IF NOT Eof(F) THEN ReadLn(f,s);  { Event time }
   IF NOT Eof(f) THEN ReadLn(f,s);  { Error correcting connection }
   IF NOT Eof(f) THEN ReadLn(f,s);  { ANSI supported }
   IF NOT Eof(f) THEN ReadLn(f,s);  { Use record locking (Y/N) }
   IF NOT Eof(f) THEN ReadLn(f,s);  { Junk }
   IF NOT Eof(f) THEN ReadLn(f,s);  { Junk }
   IF NOT Eof(f) THEN ReadLn(f,s);  { Last new file scan }
   IF NOT Eof(f) THEN ReadLn(f,s);  { Time of this call }

   IF NOT Eof(f) THEN
      BEGIN
         ReadLn(f,s);
         fk_Client.LastTime := s;
      END;

   Close(f);
END;


FUNCTION fk_ReadLn(n:Byte; up:Boolean):String;
VAR Input:String; ch:Char; i:Byte;
BEGIN
   IF (fk_Fossil.Port > 0) AND (fk_Fossil.Baud > 0) AND NOT Ms_CheckCarrier THEN fkp_CarrierLoss;
   ReadUpdateStatus := FALSE;
   Ms_DrawStatus;
   Input := fk_Host.CurrentInput;
   REPEAT
      ch := fk_Read;
      IF up THEN ch := Upcase(ch);
      CASE ch OF
         ^X,
         ^Y  : IF Ord(Input[0]) > 0 THEN
                  BEGIN
                     fk_BS(Ord(Input[0]));
                     Input := '';
                  END;
         #13 : ;
         #8  : IF Ord(Input[0]) > 0 THEN
                  BEGIN
                     fk_BS(1);
                     Dec(Input[0]);
                  END;
         ELSE IF (Ord(Input[0]) < n) AND (Position(ch,fk_Host.ValidInput) > 0) THEN
            BEGIN
               Inc(Input[0]);
               Input[Ord(Input[0])] := ch;
               IF fk_Host.OutputChar = #0
                  THEN fk_Write(ch)
                  ELSE fk_Write(fk_Host.OutputChar);
            END;
      END;
   UNTIL (ch = #13);
   fk_Host.CurrentInput := '';
   ReadUpdateStatus := TRUE;
   fk_ReadLn := Input;
END;


PROCEDURE fk_RemoteBuffer(s:String);
BEGIN
END;


PROCEDURE fk_RemoteBufferClear;
BEGIN
END;


FUNCTION  fk_RemoteKeypressed:Boolean;
BEGIN
   IF (fk_Fossil.Baud=0)
      THEN fk_RemoteKeyPressed := FALSE
      ELSE CASE CommType OF
            0 : BEGIN
                   Ms_FossilReadAhead;
                   fk_RemoteKeyPressed := (fk_Host.CharReady=TRUE);
                END;
            1 : BEGIN
                   Ms_AsyncReadAhead;
                   fk_RemoteKeyPressed := (fk_Host.CharReady=TRUE);
                END;
         END;
END;


PROCEDURE fk_RemoteWrite(s:String);
VAR b:Boolean;
BEGIN
   b := fk_Host.HostScreen; { Store original local screen setting }
   fk_Host.HostScreen := FALSE; { Disable local output }
   fk_Write(s);
   fk_Host.HostScreen := b; { Restore }
END;


PROCEDURE fk_RemoteWriteLn(s:String; n:Integer);
VAR i:Integer;
BEGIN
   fk_RemoteWrite(s);
   IF n > 0 THEN FOR i := 1 TO n DO fk_RemoteWrite(#13#10);
END;


PROCEDURE fk_TextBackground(n:Byte);
BEGIN
   fk_TextColor((n*16) OR fk_Host.LastFG);
END;


PROCEDURE fk_TextColor(n:Byte);
VAR fg,bg:Byte; Temp:String;
BEGIN
   fg := n AND $0F;
   bg := (n SHR 4) AND $0F;
   CASE fk_Client.ScreenType OF
      1 : BEGIN
             Temp := #27+'[';

             IF (bg AND $08 > 0) THEN Temp := Temp+'5;' ELSE Temp := Temp+'0;';
             IF (fg AND $08 > 0) THEN Temp := Temp+'1;' ELSE Temp := Temp+'2;';
             Temp := Temp+StrFunc(AnsiColorArray[fg AND $07]+30)+';';
             Temp := Temp+StrFunc(AnsiColorArray[bg AND $07]+40)+';';

             IF Temp <> #27+'[' THEN Ms_WriteString(Copy(Temp,1,Length(Temp)-1)+'m');
          END;
      2 : Ms_WriteString(^V^A+Chr(n));
   END;
   IF (fk_Client.ScreenType <> 0) OR (fk_Host.StrictColour=FALSE) THEN TextAttr := n;
   fk_Host.High := (fg AND $08) > 0;
   fk_Host.Blink := (bg AND $08) > 0;
   fk_Host.LastFG := fg;
   fk_Host.LastBG := bg;
END;


PROCEDURE fk_TextForeground(n:Byte);
BEGIN
   fk_TextColor((fk_Host.LastBG*16) OR n);
END;


FUNCTION  fk_TimeLeft:String;
VAR s:String;
BEGIN
   IF fk_Client.TimeLeft < 0 THEN s := '-' ELSE s := '';
   s := s + LeadingZero(fk_Client.TimeLeft DIV 3600,2)+
            LeadingZero((fk_Client.TimeLeft MOD 3600) DIV 60,2)+
            LeadingZero(fk_Client.TimeLeft MOD 60,2);
   fk_TimeLeft := s;
END;


PROCEDURE fk_ToggleDTR(Up:Boolean);
BEGIN
   IF fk_Fossil.Baud > 0 THEN
      CASE CommType OF
         0 : Ms_FossilToggleDtr(Up);
         1 : IF (Up=FALSE) THEN Ms_AsyncLowerDTR ELSE Ms_AsyncRaiseDTR;
      END;
END;


PROCEDURE fk_Write(s:String);

{ The unit's main output procedure - almost all the other output routines  }
{ depend on fk_Write.  This procedure has an ANSI/AVATAR interpreter, etc. }

VAR WorkStr,
    CharBuff,
    EscapeStr   : String;      { ANSI codes }
    i,
    StrPos,
    StrLen      : Byte;

    PROCEDURE FlushCharBuff;
    BEGIN
       Write(CharBuff);
       CharBuff := '';
    END;

    PROCEDURE WriteChar(c:char);
    BEGIN
       IF fk_Host.RemoteScreen THEN Ms_WriteChar(c);
       IF fk_Host.HostScreen THEN
          CASE c OF
             #7 : IF fk_Host.Sound THEN CharBuff := CharBuff+c;
             ELSE CharBuff := CharBuff+c;
          END;
    END;

    PROCEDURE Ansi_AddrCursor;
    VAR XPos,YPos,SemiPos:Byte; Err:Integer;
    BEGIN
       SemiPos := Pos(';',EscapeStr);
       IF EscapeStr = ''
          THEN fk_GotoXY(1,1)
          ELSE IF SemiPos > 0 THEN
             BEGIN
                Val(Copy(EscapeStr,1,SemiPos-1),YPos,Err);
                IF Err <> 0 THEN YPos := 1;
                Val(Copy(EscapeStr,SemiPos+1,Length(EscapeStr)-SemiPos),XPos,Err);
                IF Err <> 0 THEN XPos := 1;
                fk_GotoXY(XPos,YPos);
             END
          ELSE BEGIN
               Val(EscapeStr,YPos,Err);
               IF Err <> 0 THEN YPos := 1;
               XPos := 1;
               fk_GotoXY(XPos,YPos);
            END;
   END;

   PROCEDURE Ansi_SetColor;
   VAR i:Byte; SemiPos,fg,bg:Byte; Err:Integer;
   BEGIN
      IF EscapeStr = '' THEN Exit;

      IF EscapeStr[Length(EscapeStr)] <> ';'  { Needs the trailing ; to }
         THEN                                 { parse correctly }
            EscapeStr := EscapeStr+';';

      fg := fk_Host.LastFG;
      bg := fk_Host.LastBG;

      REPEAT
         SemiPos := Position(';',EscapeStr);
         CASE ValFunc(Copy(EscapeStr,1,SemiPos-1)) OF
            0  : BEGIN
                    fg := 7;
                    bg := 0;
                 END;
            1  : fg := fg OR $08;       { High intensity ON }
            2  : fg := fg AND NOT $08;  { High intensity OFF }
            5  : bg := bg OR $08;       { Blink ON }
            7  : BEGIN
{                   i  := FG;
                    FG := BG;
                    BG := i; }
                 END;
            30 : fg := 0;  31 : fg := 4;  32 : fg := 2;  33 : fg := 6;
            34 : fg := 1;  35 : fg := 5;  36 : fg := 3;  37 : fg := 7;
            40 : bg := 0;  41 : bg := 4;  42 : bg := 2;  43 : bg := 6;
            44 : bg := 1;  45 : bg := 5;  46 : bg := 3;  47 : bg := 7;
         END;
         Delete(EscapeStr,1,SemiPos);
      UNTIL Length(EscapeStr) = 0;
      fk_TextColor(fg+(bg SHL 4));
   END;

   PROCEDURE EscapeMode;
   VAR Done:Boolean; bx,by:Byte;
   BEGIN
      FlushCharBuff;
      Inc(StrPos,2);
      EscapeStr := '';
      Done := FALSE;
      WHILE (StrPos <= Length(WorkStr)) AND NOT Done DO
         BEGIN
            IF (Upcase(WorkStr[StrPos]) IN ['M','F','H','J','K','S','U','A'..'D']) THEN
               BEGIN
                  Done := TRUE;
                  CASE Upcase(WorkStr[StrPos]) OF
                     'F',
                     'H' : Ansi_AddrCursor;
                     'M' : Ansi_SetColor;
                     'J' : IF EscapeStr = '2' THEN fk_ClrScr;
                     'K' : IF EscapeStr = '0' THEN fk_ClrEol;
                     'S' : BEGIN
                              fk_Host.SaveX := WhereX;
                              fk_Host.SaveY := WhereY;
                           END;
                     'U' : fk_GotoXY(fk_Host.SaveX,fk_Host.SaveY);
                     'A' : IF EscapeStr = ''
                              THEN fk_MoveCursor(1,'U')
                              ELSE fk_MoveCursor(ValFunc(EscapeStr),'U');
                     'B' : IF EscapeStr = ''
                              THEN fk_MoveCursor(1,'D')
                              ELSE fk_MoveCursor(ValFunc(EscapeStr),'D');
                     'C' : IF EscapeStr = ''
                              THEN fk_MoveCursor(1,'R')
                              ELSE fk_MoveCursor(ValFunc(EscapeStr),'R');
                     'D' : IF EscapeStr = ''
                              THEN fk_MoveCursor(1,'L')
                              ELSE fk_MoveCursor(ValFunc(EscapeStr),'L');
                  END;
               END
            ELSE EscapeStr := EscapeStr + WorkStr[StrPos];
            Inc(StrPos);
         END;
   END;

   PROCEDURE ProcAvatar;
   BEGIN
      FlushCharBuff;
      CASE WorkStr[StrPos+1] OF
         ^B : fk_TextColor(fk_Host.LastFG+((fk_Host.LastBG OR $08) SHL 4));
         ^C : fk_MoveCursor(1,'U');
         ^D : fk_MoveCursor(1,'D');
         ^E : fk_MoveCursor(1,'L');
         ^F : fk_MoveCursor(1,'R');
         ^G : fk_ClrEol;
         ^A : IF (StrLen >= 3) THEN
                 BEGIN
                    fk_TextColor(Ord(WorkStr[StrPos+2]));
                    Inc(StrPos);
                 END;
         ^H : IF (StrLen >= 4) THEN
                 BEGIN
                    fk_GotoXY(Ord(WorkStr[StrPos+3]),Ord(WorkStr[StrPos+2]));
                    Inc(StrPos,2);
                 END;
      END;
      Inc(StrPos,2);
   END;

BEGIN
   IF Length(s) = 0 THEN Exit;
   WorkStr := fk_MCI(s);
   StrPos := 1;
   CharBuff := '';

   REPEAT
      StrLen := (Length(WorkStr)-StrPos)+1;

      IF (WorkStr[StrPos] = #22) AND (StrLen >= 2) THEN ProcAvatar
      ELSE IF (StrLen >= 3) AND (WorkStr[StrPos] = #25) THEN
         BEGIN
            IF Ord(WorkStr[StrPos+2]) >= 1 THEN
               FOR i := 1 TO Ord(WorkStr[StrPos+2]) DO
                  WriteChar(WorkStr[StrPos+1]);
            Inc(StrPos,3);
         END
      ELSE IF (StrLen >= 3) AND (WorkStr[StrPos] = #27) AND (WorkStr[StrPos+1] = '[') THEN EscapeMode
      ELSE BEGIN
            WriteChar(WorkStr[StrPos]);
            Inc(StrPos);
         END;
   UNTIL StrPos > Length(WorkStr);
   FlushCharBuff;
END;


PROCEDURE fk_WriteLn(s:String; n:Integer);
VAR i:Integer;
BEGIN
   fk_Write(s);
   IF n > 0 THEN FOR i := 1 TO n DO fk_Write(#13#10);
END;


PROCEDURE fk_WriteLn_Ansi(s:String; n:Integer);
BEGIN
   fk_WriteLn(s,n);
END;


PROCEDURE fk_WriteLn_Avatar(s:STring; n:Integer);
BEGIN
   fk_WriteLn(s,n);
END;


(* ------------------------------------------------------------------- *)
(* Defaults for definable procedures/functions                         *)
(* ------------------------------------------------------------------- *)


FUNCTION fkp_MCI(s:String):String;
BEGIN
   fkp_MCI := s;
END;


FUNCTION fkp_Input(Ch:Char):Char;
BEGIN
   fk_Host.LastKP := CurrentSecsFunc;
   fkp_Input := Ch;
END;


PROCEDURE fkp_Open;
BEGIN
   fk_Host.LastKP := CurrentSecsFunc;
   fk_Host.LastStatDraw := CurrentSecsFunc;
   fk_Host.LastTimeCheck := CurrentSecsFunc;
   Ms_DrawStatus;
   Ms_UpdateStatus;
END;


PROCEDURE fkp_Close;
BEGIN
   Halt(fk_Host.ExitCode);
END;


PROCEDURE fkp_CarrierLoss;
BEGIN
   fk_TextColor(12);
   fk_WriteLn(#13#10+'++ Carrier Lost!',2);
   RealDelay(2000);
   fk_DeInitFossil;
END;


PROCEDURE fkp_TimeOut;
BEGIN
   fk_TextColor(12);
   fk_WriteLn(#13#10+'++ Inactivity timeout!',2);
   RealDelay(2000);
   fk_DeInitFossil;
END;


PROCEDURE fkp_NoTimeLeft;
BEGIN
   fk_TextColor(12);
   fk_WriteLn(#13#10+'++ You have used up all your time, exiting to the BBS!',2);
   RealDelay(2000);
   fk_DeInitFossil;
END;


VAR OldExitProc:Pointer;

PROCEDURE Ms_ExitProc; FAR;
BEGIN
   IF (CommType=1) AND (OpenFlag=TRUE) THEN Ms_AsyncClose;
   ExitProc := OldExitProc;
END;


BEGIN
   OldExitProc := ExitProc;
   ExitProc := @Ms_ExitProc;

   fk_LocalInput := fkp_Input;
   fk_RemoteInput := fkp_Input;
   fk_MCI := fkp_MCI;
   fk_CarrierLoss := fkp_CarrierLoss;
   fk_TimeOut := fkp_TimeOut;
   fk_NoTimeLeft := fkp_NoTimeLeft;
   fk_Close := fkp_Close;
   fk_Open := fkp_Open;

   Ms_VarsInit_Fossil;
   Ms_VarsInit_ProgramInfo;
   Ms_VarsInit_Task;
   Ms_VarsInit_Client;
   Ms_VarsInit_Music;
   Ms_VarsInit_Host;
END.









