{$I-}
UNIT MISC1;

(* 

    MSCOMMON is Copyright (C) 1993-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

INTERFACE


USES  {$IFDEF OS2}
      {$DEFINE IS32}
      OS2BASE,
      {$ENDIF}
      {$IFDEF WIN32}
      {$DEFINE IS32}
      WINDOWS,
      SYSUTILS,
      {$ENDIF}
      DOS,CRT,MSTRINGS,FASTW;

CONST kbd_RightShift = $01;
      kbd_LeftShift  = $02;
      kbd_Ctrl       = $04;
      kbd_Alt        = $08;
      kbd_ScrollLock = $10;
      kbd_NumLock    = $20;
      kbd_CapsLock   = $40;
      kbd_Insert     = $80;

      BreakTrapped   : Boolean = FALSE;

{$IFDEF WIN32}
TYPE  SearchRec      = TSearchRec;
{$ENDIF}

{ Miscellaneous system/math/number related things }
PROCEDURE RealDelay(ms:Word);
PROCEDURE FlushKeyboard;
FUNCTION  NameForm(s:string):String;
FUNCTION  HexDigit(n:byte):Char;
FUNCTION  Hex2Int(HexStr:String):LongInt;
FUNCTION  Int2Hex(n:Word):String;
FUNCTION  LongInt2Hex(n:LongInt):String;
FUNCTION  RaiseTo(Number,Power:LongInt):LongInt;
FUNCTION  BasicReal2Long(InValue:LongInt):LongInt;
FUNCTION  Long2BasicReal(InValue:LongInt):LongInt;
PROCEDURE FidoSplitAddr(Addr:String; VAR Zone,Net,Node,Point:Word);

{ Colour writing related }
PROCEDURE WriteColorFast(x,y:Byte; s:String);
FUNCTION  StripColor(s:String):String;
PROCEDURE WriteColor(VAR InStr,SchemeIn);
PROCEDURE WritePipe(InStr:String);
PROCEDURE WritePipeXY(x,y:Byte; InStr:String);

{ File handling }
PROCEDURE TouchSemaphore(fn:String);
FUNCTION  FSize(VAR f):LongInt;
PROCEDURE FFirst(SearchStr:String; DosAttr:Word; VAR s:SearchRec);
PROCEDURE FNext(VAR s:SearchRec);
PROCEDURE DirMake(path:String);
PROCEDURE NukeFiles(filespec:String);
FUNCTION  FExists(filename:String):Boolean;
FUNCTION  DirExists(dirname:String):Boolean;
FUNCTION  StripSlash(s:String):String;
FUNCTION  AddSlash(InStr:String):String;
FUNCTION  RemoveExtension(s:string):String;
FUNCTION  GetCurrentPath:String;
FUNCTION  GetCurrentDir:String;
FUNCTION  ExtractDriveNum(s:string):Byte;
FUNCTION  ExtractFDrive(s:String):Char;
FUNCTION  ExtractFDir(s:String):String;
FUNCTION  ExtractFName(s:string):String;
FUNCTION  ExtractFileName(s:String):String;
FUNCTION  ExtractFExt(s:string):String;
FUNCTION  ExtractDNum(s:string):Byte;
FUNCTION  MatchTheWildcards(fname,realfname:String):Boolean;
FUNCTION  MatchWildcards(fname,realfname:String):Boolean;
PROCEDURE CopyFile(f1,f2:String; ForceRewrite:Boolean);
FUNCTION  CheckValidFile(TempS:String):Boolean;

{$IFNDEF IS32}

{ Input type stuff }
FUNCTION  BiosReadChar:Char;
FUNCTION  BiosScanCode:Byte;
FUNCTION  BiosKeyFlags:Byte;
FUNCTION  TestKeyboardFlag(Flag:Byte):Boolean;
PROCEDURE BreakOff;
PROCEDURE BreakOn;

{$ENDIF}


IMPLEMENTATION


TYPE  SchemeRec = Record
         Description : String[30];
         Color       : Array[1..200] of Byte;
      END;

CONST BreakInterrupt = $1B;
      BreakTrapSet   : Boolean = FALSE;
VAR   OldBreakVector : Pointer;


{$IFDEF WIN32}
PROCEDURE RealDelay(ms:Word);
BEGIN
   Delay(ms);
END;
{$ENDIF}

{$IFDEF OS2}
PROCEDURE RealDelay(ms:Word);
BEGIN
   Delay(ms);
END;
{$ENDIF}

{$IFDEF DOS}
PROCEDURE RealDelay(ms:Word); Assembler;
ASM
   MOV AX, 1000;
   MUL MS;
   MOV CX, DX;
   MOV DX, AX;
   MOV AH, $86;
   INT $15;
END;
{$ENDIF}

(*
function HPFS (drv:char):boolean;
var
rc,len:longint;
dev:pchar;
PBTR:PFsqBuffer2;
BUFF:ARRAY[1..2048] OF CHAR;
p:string;
DNAME:STRING;
DTYPE:STRING;
DDATA:STRING;
begin
HPFS:=FALSE;
PBTR:=@BUFF[1];
if (drv < 'C') then exit;
p:=drv+':'+#0;
dev:=@p[1];
len := 2048;
rc:=DosQueryFSAttach(dev, 0, FSAIL_QUERYNAME, Pbtr^, len);
if rc <> 0 then exit;
DNAME[0]:=chr(lo(pBtr^.CBNAME));
DTYPE[0]:=chr(lo(pBtr^.CBFSDNAME));
DDATA[0]:=chr(lo(pBtr^.CBFSADATA));
move(buff[10+pBtr^.CBNAME],dtype[1],pBtr^.CBfsdNAME);
HPFS:=dtype='HPFS';
end;
*)

PROCEDURE FidoSplitAddr(Addr:String; VAR Zone,Net,Node,Point:Word);
VAR ColonPos:Byte; s:String;
BEGIN
   Zone := 0;  Net := 0;  Node := 0;  Point := 0;  s := Addr;

   ColonPos := Pos(':',s); IF ColonPos <= 1 THEN Exit;          { Net }
   Zone := ValFunc(Copy(s,1,ColonPos-1)); Delete(s,1,ColonPos);

   ColonPos := Pos('/',s); IF ColonPos <= 1 THEN Exit;          { Node }
   Net  := ValFunc(Copy(s,1,ColonPos-1)); Delete(s,1,ColonPos);

   ColonPos := Pos('.',s); IF ColonPos <= 1 THEN ColonPos := Length(s)+1;
   Node := ValFunc(Copy(s,1,ColonPos-1));

   IF ColonPos > Length(s) THEN Exit;
   Delete(s,1,ColonPos);
   Point := ValFunc(Copy(s,1,Length(s)));
END;


FUNCTION StripColor(s:String):String;
VAR TempS:String; StrPos,Len:Byte;
BEGIN
    Len := Length(s); StrPos := 1; TempS := '';
    WHILE (StrPos <= Len) DO
       BEGIN
          IF      (s[StrPos] = '|') THEN Inc(StrPos,3)
          ELSE IF (s[StrPos] = '`') THEN Inc(StrPos,3)
          ELSE IF (s[StrPos] = '^') THEN Inc(StrPos,2)
          ELSE BEGIN
             TempS := TempS + s[StrPos];
             Inc(StrPos);
          END;
       END;
    StripColor := TempS;
END;


PROCEDURE WriteColorFast(x,y:Byte; s:String);
VAR StrPos,Col,AddX:Byte; Temp:String;
BEGIN
    Col := 7;
    StrPos := 1;
    AddX := 0;
    Temp := '';
    REPEAT
       IF (s[StrPos] = '`') AND (s[StrPos+1] IN ['0'..'9','A'..'F']) AND (s[StrPos+2] IN ['0'..'9','A'..'F']) THEN
          BEGIN
             WriteFast(x+AddX,y,Temp,Col);
             AddX := AddX+Length(Temp);
             Temp := '';
             Col := Hex2Int(s[StrPos+1]+s[StrPos+2]);
             Inc(StrPos,3);
          END
       ELSE BEGIN
             Temp := Temp+s[StrPos];
             Inc(StrPos)
          END
    UNTIL (StrPos > Length(s));
    WriteFast(x+AddX,y,Temp,Col);
END;


PROCEDURE WriteColor(Var InStr, SchemeIn);
VAR s : String absolute InStr;

    {$IFDEF OS2}
       {$IFDEF SPEED}
       StrPos,Len,Err:Integer;
       {$ELSE}
       StrPos,Len,Err:LongInt;
       {$ENDIF}
    {$ELSE}
    StrPos,Len,Err:Integer;
    {$ENDIF}

    Col    : byte;
    Scheme : SchemeRec ABSOLUTE SchemeIn;
BEGIN
    Len := Length(s);
    StrPos := 1;
    REPEAT
       IF (s[StrPos] = '|') THEN
        BEGIN
           Val(Copy(s,StrPos+1,2),Col,Err);
           IF (Err = 0) AND (Col IN [0..22]) THEN
              IF Col IN [0..15] THEN TextColor(Col)
              ELSE TextBackground(Col - 16);
           Inc(StrPos,3)
        END
       ELSE IF (s[StrPos] = '^') THEN
        BEGIN
           Val(Copy(s,StrPos+1,1),Col,Err);
           IF (Err = 0) AND (Col IN [0..9]) THEN
              TextAttr := Scheme.Color[Col + 1];
           Inc(StrPos,2)
        END
       ELSE BEGIN
           Write(s[StrPos]);
           Inc(StrPos)
       END
    UNTIL (StrPos > Length(s))
END;


PROCEDURE WritePipe(InStr:String);
VAR StrPos:Integer; Col:LongInt; Temp:String;
BEGIN
    Temp := '';
    StrPos := 1;
    IF Length(InStr) > 0 THEN REPEAT
       IF (InStr[StrPos] = '|') AND (ValFunc(Copy(InStr,StrPos+1,2)) > 0) THEN
          BEGIN
             Write(Temp);
             Temp := '';
             Col := ValFunc(Copy(InStr,StrPos+1,2));
             IF (Col < 16) THEN TextAttr := (TextAttr AND $F0) OR Col ELSE
             IF (Col < 32) THEN TextAttr := (TextAttr AND $0F) OR ((Col-16)*16);
             Inc(StrPos,3);
          END
       ELSE BEGIN
           Temp := Temp+InStr[StrPos];
           Inc(StrPos);
       END
    UNTIL (StrPos > Length(InStr));
    Write(Temp);
END;


PROCEDURE WritePipeXY(x,y:Byte; InStr:String);
BEGIN
   GotoXY(x,y);
   WritePipe(InStr);
END;


PROCEDURE FlushKeyboard;
VAR ch:Char;
BEGIN
   WHILE KeyPressed DO ch := ReadKey;
END;


PROCEDURE TouchSemaphore(fn:String);
VAR f:FILE;
BEGIN
   IF NOT FExists(fn) THEN
      BEGIN
         Assign(f,fn);
         Rewrite(f,1);
         IF IOResult = 0 THEN Close(f);
      END;
END;


{$IFDEF OS2}
FUNCTION FSize(VAR f):LongInt;
VAR FStatus:FileStatus;
BEGIN
   DosQueryFileInfo(FileRec(f).Handle,1,FStatus,SizeOf(FStatus));
   FSize := FStatus.cbFile;
END;
{$ENDIF}


{$IFDEF WIN32}
FUNCTION FSize(VAR f):LongInt;
BEGIN
   IF TFileRec(f).RecSize = 0
      THEN FSize := 0
      ELSE FSize := LongInt(GetFileSize(TFileRec(f).Handle,NIL)) DIV TFileRec(f).RecSize;
END;
{$ENDIF}


{$IFDEF DOS}
FUNCTION FSize(VAR f):LongInt;
BEGIN
   FSize := FileSize(File(f));
END;
{$ENDIF}


PROCEDURE FFirst(SearchStr:String; DosAttr:Word; VAR s:SearchRec);
BEGIN
   {$IFDEF WIN32}
   DosError := FindFirst(SearchStr,DosAttr AND NOT VolumeID,s);
   {$ELSE}
   FindFirst(SearchStr,DosAttr AND NOT VolumeID,s);
   {$ENDIF}
END;


PROCEDURE FNext(VAR s:SearchRec);
BEGIN
   {$IFDEF WIN32}
   DosError := FindNext(s);
   {$ELSE}
   FindNext(s);
   {$ENDIF}
END;


PROCEDURE DirMake(path:String);
VAR TempDir:String; StrPos:Byte;
BEGIN
   IF Length(Path) <= 0 THEN Exit;
   Path := AddSlash(Path);
   WHILE Pos('\\',Path) > 0 DO Delete(Path,Pos('\\',Path),1);
   FOR StrPos := 1 TO Length(Path) DO
      IF (Path[StrPos] = '\') AND (StrPos > 1) THEN
         BEGIN
            TempDir := Copy(Path,1,StrPos-1);
            IF NOT DirExists(TempDir) THEN
               BEGIN
                  MkDir(TempDir);
                  IF IOResult <> 0 THEN ;
               END;
         END;
END;


FUNCTION DirExists(dirname:String):Boolean;
VAR s:SearchRec;
BEGIN
   FFirst(StripSlash(DirName),Directory,s);
   {$IFDEF IS32} FindClose(s); {$ENDIF}
   DirExists := DosError = 0;
END;


PROCEDURE NukeFiles(filespec:String);
VAR s:SearchRec; f:File;
BEGIN
   FFirst(FileSpec,Archive,s);
   WHILE DosError = 0 DO
      BEGIN
         Assign(f,ExtractFDir(FileSpec)+s.Name);
         Reset(f,1);
         IF IOResult = 0 THEN
            BEGIN
               Close(f);
               Erase(f);
            END;
         FNext(s);
      END;
   {$IFDEF IS32} FindClose(s); {$ENDIF}
END;


FUNCTION FExists(filename:String):Boolean;
VAR s:SearchRec;
BEGIN
   FFirst(FileName,Archive,s);
   {$IFDEF IS32} FindClose(s); {$ENDIF}
   FExists := DosError = 0;
END;


FUNCTION StripSlash(s:String):String;
BEGIN
   {$IFDEF WIN32}
   IF s[Length(s)] = '\' THEN SetLength(s,Length(s)-1);
   {$ELSE}
   IF s[Ord(s[0])] = '\' THEN Dec(s[0]);
   {$ENDIF}
   StripSlash := s;
END;


FUNCTION AddSlash(InStr:String):String;
VAR s:string;
BEGIN
   s := InStr;
   IF (s[Length(s)] <> '\') AND (Length(s) > 0) THEN s := s + '\';
   AddSlash := s;
END;


FUNCTION NameForm(s : string):String;
VAR
   InStr : String;
   ThisPos : Byte;
BEGIN
   InStr := s;
   InStr[1] := Upcase(InStr[1]);
   FOR ThisPos := 1 to (Length(InStr) - 1) DO
    BEGIN
       IF InStr[ThisPos] = #32 THEN
          InStr[ThisPos+1] := Upcase(InStr[ThisPos + 1])
       ELSE
          IF InStr[ThisPos+1] in ['A'..'Z'] THEN
             InStr[ThisPos+1] := Chr(Ord(InStr[ThisPos+1]) + 32)
    END;
   NameForm := InStr;
END;


FUNCTION RemoveExtension(s:string):String;
VAR DotPos : Byte;
BEGIN
   DotPos := Pos('.',s);
   IF (DotPos > 1) THEN RemoveExtension := Copy(s,1,DotPos-1)
   ELSE IF (DotPos = 0) THEN RemoveExtension := s
   ELSE IF (DotPos = 1) THEN RemoveExtension := '';
END;


FUNCTION HexDigit(n:byte):Char;
BEGIN
   IF n < 10 THEN HexDigit := Chr(Ord('0')+n)
   ELSE HexDigit := Chr(Ord('A')+(n-10));
END; { HexDigit }


FUNCTION  Int2Hex(n:Word):String;
BEGIN
   Int2Hex := HexDigit(Hi(n) DIV 16)+
              HexDigit(Hi(n) MOD 16)+
              HexDigit(Lo(n) DIV 16)+
              HexDigit(Lo(n) MOD 16);
END;


FUNCTION  LongInt2Hex(n:LongInt):String;
TYPE ByteRec = RECORD b1,b2,b3,b4:Byte; END;
VAR Digits : ByteRec ABSOLUTE n;
BEGIN
   LongInt2Hex := HexDigit(Digits.b4 DIV 16)+
                  HexDigit(Digits.b4 MOD 16)+
                  HexDigit(Digits.b3 DIV 16)+
                  HexDigit(Digits.b3 MOD 16)+
                  HexDigit(Digits.b2 DIV 16)+
                  HexDigit(Digits.b2 MOD 16)+
                  HexDigit(Digits.b1 DIV 16)+
                  HexDigit(Digits.b1 MOD 16);
END;


FUNCTION  Hex2Int(HexStr:String):LongInt;
VAR StrPos : Byte;
    TempRes, MultiplyBy : LongInt;
    BadCode : Boolean;

    FUNCTION GetDigit(ch:char):Byte;
    BEGIN
       IF      (ch >= '0') AND (ch <= '9') THEN GetDigit := Ord(ch) - 48
       ELSE IF (ch >= 'A') AND (ch <= 'F') THEN GetDigit := Ord(ch) - 55
       ELSE BEGIN
             GetDigit := 0;
             BadCode := tRUE;
          END;
    END;

BEGIN
   BadCode := FALSE;
   TempRes := 0;
   MultiplyBy := 1;
   FOR StrPos := Length(HexStr) DOWNTO 1 DO
      BEGIN
         TempRes := TempRes+(GetDigit(Upcase(HexStr[StrPos]))*MultiplyBy);
         MultiplyBy := MultiplyBy * 16;
      END;
   IF BadCode THEN Hex2Int := -1 ELSE Hex2Int := TempRes;
END;


FUNCTION RaiseTo(Number,Power:LongInt):LongInt;
VAR PowerNum:Byte; TempRes:LongInt;
BEGIN
   TempRes := 1;
   IF Power > 0 THEN FOR PowerNum := 1 TO Power DO TempRes := TempRes * Number;
   RaiseTo := TempRes;
END;


FUNCTION  GetCurrentPath:String;
BEGIN
   GetCurrentPath := FExpand('');
END;


FUNCTION  GetCurrentDir:String;
VAR s:string;
BEGIN
   s := ParamStr(0);
   {$IFDEF WIN32}
   WHILE (s[Length(s)] <> '\') AND (Length(s) > 0) DO SetLength(s,Length(s)-1);
   {$ELSE}
   WHILE (s[Length(s)] <> '\') AND (Length(s) > 0) DO Dec(s[0]);
   {$ENDIF}
   GetCurrentDir := s;
END;


FUNCTION ExtractDriveNum(s:string):Byte;
BEGIN
   IF (Length(s) > 1) AND (s[2] = ':')
      THEN ExtractDriveNum := Ord(Upcase(s[1]))-64
      ELSE ExtractDriveNum := 0;
END;


FUNCTION ExtractFDrive(s:String):Char;
BEGIN
   ExtractFDrive := Chr(ExtractDriveNum(s)+64);
END;


FUNCTION  ExtractFDir(s:String):String;
VAR Dir:DirStr; Name:NameStr; Ext:ExtStr;
BEGIN
   FSplit(s,Dir,Name,Ext);
   ExtractFDir := Dir;
END;


FUNCTION  ExtractFName(s:string):String;
VAR Path:PathStr; Dir:DirStr; Name:NameStr; Ext:ExtStr;
BEGIN
   Path := S;
   FSplit(Path,Dir,Name,Ext);
   ExtractFName := Name+Ext;
END;


FUNCTION ExtractFileName(s:String):String;
VAR Path:PathStr; Dir:DirStr; Name:NameStr; Ext:ExtStr;
BEGIN
   Path := S;
   FSplit(Path,Dir,Name,Ext);
   ExtractFileName := Name;
END;


FUNCTION  ExtractFExt(s:string):String;
VAR Path:PathStr; Dir:DirStr; Name:NameStr; Ext:ExtStr;
BEGIN
   Path := S;
   FSplit(Path,Dir,Name,Ext);
   ExtractFExt := Ext;
END;


FUNCTION ExtractDNum(s:string):Byte;
BEGIN
   IF (Upcase(s[1]) IN ['A'..'Z']) AND (s[2] = ':')
      THEN ExtractDNum := Ord(s[1]) - 64
      ELSE ExtractDNum := 0;
END;



{$IFDEF WIN32}
PROCEDURE CopyFile(f1,f2:String; ForceRewrite:Boolean);
BEGIN
   f1[Length(f1)+1] := #0;
   f2[Length(f2)+1] := #0;
   WINDOWS.CopyFile(@f1[1],@f2[1],NOT ForceRewrite);
END;
{$ENDIF}
{$IFDEF OS2}
PROCEDURE CopyFile(f1,f2:String; ForceRewrite:Boolean);
BEGIN
   f1[Length(f1)+1] := #0;
   f2[Length(f2)+1] := #0;
   IF ForceRewrite
      THEN DosCopy(@f1[1],@f2[1],dcpy_Existing)
      ELSE DosCopy(@f1[1],@f2[1],dcpy_Existing OR dcpy_Append);
END;
{$ENDIF}
{$IFDEF DOS}
PROCEDURE CopyFile(f1,f2:String; ForceRewrite:Boolean);
TYPE TBuffType   = Array[1..4096] of Byte;
VAR  File1,File2 : FILE;
     Buff        : TBuffType;
     NumRead,
     NumWritten  : Word;

BEGIN
   IF NOT FExists(f1) THEN Exit;

   Assign(File1,f1);
   Reset(File1,1);
   Assign(File2,f2);
   IF FExists(f2) AND (ForceRewrite=FALSE) THEN Reset(File2,1) ELSE Rewrite(File2,1);

   IF (IOResult=0) THEN
      BEGIN
         Seek(File1,0);
         Seek(File2,FileSize(File2));
         REPEAT
            BlockRead(File1,Buff,4096,NumRead);
            BlockWrite(File2,Buff,NumRead,NumWritten);
         UNTIL (NumRead = 0) OR (NumWritten <> NumRead) OR Eof(File1);
      END;

   Close(File1); IF IOResult <> 0 THEN ;
   Close(File2); IF IOResult <> 0 THEN ;
END;
{$ENDIF}


FUNCTION  CheckValidFile(TempS:String):Boolean;
VAR StrPos:Byte; s:String; TempRes:Boolean;
BEGIN
   s := StripChar(Copy(TempS,1,12),' ');
   StrPos := 1;
   WHILE (StrPos <= Length(s)) AND (Pos(s[StrPos],'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUV'+
                                                  'WXYZ1234567890~!@#$%^&()-_{}.') > 0) DO Inc(StrPos);
   CheckValidFile := (Length(s) > 0) AND (StrPos > Length(s));
END;


FUNCTION  MatchTheWildcards(fname,realfname:String):Boolean;
VAR FNPos,RealFNPos:Byte;
BEGIN
   FNPos := 1;
            FOR RealFNPos := 1 TO Length(RealFName) DO
               BEGIN
                  IF FName[FNPos] = RealFName[RealFNPos] THEN Inc(FNPos)
                  ELSE
                     CASE FName[FNPos] OF
                        '*' : ;
                        '?' : Inc(FNPos);
                        ELSE BEGIN
                              MatchTheWildcards := FALSE;
                              Exit;
                           END;
                     END;
               END;
            MatchTheWildcards := TRUE;
END;


FUNCTION  MatchWildcards(fname,realfname:String):Boolean;
VAR FN,RFN,FE,RFE:String; DotPos:Byte;
BEGIN
   FE := '';
   RFE := '';
   DotPos := Pos('.',RealFName);
   IF DotPos = 0
      THEN RFN := RealFName
      ELSE BEGIN
            RFN := Copy(RealFName,1,DotPos-1);
            RFE := Copy(RealFName,DotPos+1,Length(RealFName)-DotPos);
         END;
   DotPos := Pos('.',FName);
   IF DotPos = 0
      THEN FN := FName
      ELSE BEGIN
            FN := Copy(FName,1,DotPos-1);
            FE := Copy(FName,DotPos+1,Length(FName)-DotPos);
         END;
   MatchWildcards := MatchTheWildcards(PadRight(FN,' ',8),PadRight(RFN,' ',8)) AND
                     MatchTheWildcards(PadRight(FE,' ',3),PadRight(RFE,' ',3));
END;


{$IFDEF DOS}
FUNCTION BiosReadChar:Char;
BEGIN
   ASM
      MOV AX,0               ;
      INT 16h                ;
      MOV @Result,AL         ;
   END;
END;


FUNCTION BiosScanCode:Byte;
BEGIN
   ASM
      MOV AX,0               ;
      INT 16h                ;
      MOV @Result,AH         ;
   END;
END;


FUNCTION BiosKeyFlags:Byte;
BEGIN
   ASM
      MOV AX,02h             ;
      INT 16h                ;
      MOV @Result,AL         ;
   END;
END;


FUNCTION TestKeyboardFlag(Flag:Byte):Boolean;
BEGIN
   TestKeyboardFlag := (BiosKeyFlags AND Flag) = Flag;
END;


{$F+} PROCEDURE NewBreakVector; INTERRUPT; {$F-}
BEGIN
  Inline($FA); {Clear interrupts instruction - CLI }
  Mem[$0040:$0071] := Mem[$0040:$0071] AND $E;
  BreakTrapped := TRUE;
  Inline($FB) {Set interrupts instruction - STI}
END;


PROCEDURE BreakOff;
BEGIN
   IF NOT BreakTrapSet THEN
     BEGIN
        BreakTrapSet := TRUE;
        GetIntVec(BreakInterrupt,OldBreakVector);
        SetIntVec(BreakInterrupt,@NewBreakVector)
     END
END;

PROCEDURE BreakOn;
BEGIN
   IF BreakTrapSet THEN
      BEGIN
         BreakTrapSet := FALSE;
         SetIntVec(BreakInterrupt,OldBreakVector)
      END
END;
{$ENDIF}


FUNCTION BasicReal2Long(InValue:LongInt):LongInt;
VAR Temp:LongInt; Negative:Boolean; Expon:Integer;
BEGIN
    IF InValue = 0
       THEN BasicReal2Long := 0
       ELSE BEGIN
             Negative := InValue AND $00800000 <> 0;
             Expon    := ((InValue SHR 24) AND $FF) - 152;
             Temp     := (InValue AND $007FFFFF) OR $00800000;
             IF Expon < 0
                THEN Temp := Temp SHR Abs(Expon)
                ELSE Temp := Temp SHL Expon;
             IF Negative
                THEN BasicReal2Long := -Temp
                ELSE BasicReal2Long := Temp;
             IF Expon = 0 THEN BasicReal2Long := 0;
          END;
END;

{
FUNCTION  Long2BasicReal(InValue:LongInt):LongInt;
BEGIN
   Long2BasicReal := ((InValue AND NOT $ff000000) OR $00800000) SHR (24 - ((InValue SHR 24) AND $7f));
END;}


FUNCTION Long2BasicReal(InValue:LongInt):LongInt;
VAR Negative:Boolean; Expon:LongInt;
BEGIN
   IF InValue = 0
      THEN Long2BasicReal := 0
      ELSE BEGIN
            IF InValue < 0 THEN
                  BEGIN
                     Negative := TRUE;
                     InValue := Abs(InValue);
                  END
               ELSE Negative := False;
            Expon := 152;
            IF InValue < $007FFFFF
               THEN
                  WHILE ((InValue AND $00800000) = 0) DO
                     BEGIN
                        InValue := InValue SHL 1;
                        Dec(Expon);
                     END
               ELSE
                  WHILE ((InValue AND $FF000000) <> 0) DO
                     BEGIN
                        InValue := InValue SHR 1;
                        Inc(Expon);
                     END;
            InValue := InValue AND $007FFFFF;
            IF Negative THEN InValue := InValue OR $00800000;
            Long2BasicReal := InValue + (Expon SHL 24);
         END;
END;


END.
